/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parser;

import gorsat.parser.CalcLambdaInteger;
import gorsat.parser.CalcLambdaLong;
import gorsat.parser.CalcLambdaNumeric;
import gorsat.parser.CalcLambdaString;
import gorsat.parser.CalcLambdaVariable;
import gorsat.parser.CvpDoubleLambda;
import gorsat.parser.DoubleType;
import gorsat.parser.FunctionTypes;
import gorsat.parser.Numeric;
import gorsat.parser.TypedCalcLambda;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.model.ColumnValueProvider;

public class CalcLambdaDouble
extends CalcLambdaNumeric
implements DoubleType {
    private CvpDoubleLambda lambda;

    public CalcLambdaDouble(CvpDoubleLambda lambda) {
        this.lambda = lambda;
    }

    @Override
    public int evaluateInt(ColumnValueProvider columnValueProvider) {
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public String getType() {
        return FunctionTypes.DoubleFun();
    }

    @Override
    public long evaluateLong(ColumnValueProvider cvp) {
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public String evaluateString(ColumnValueProvider cvp) {
        double value = this.lambda.evaluate(cvp);
        return String.valueOf(value);
    }

    @Override
    public double evaluateDouble(ColumnValueProvider cvp) {
        return this.lambda.evaluate(cvp);
    }

    @Override
    public boolean evaluateBoolean(ColumnValueProvider cvp) {
        throw new GorParsingException("Can't cast number to boolean");
    }

    @Override
    public TypedCalcLambda addedTo(TypedCalcLambda left) {
        return left.add(this);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaInteger other) {
        return this.addNumber(other);
    }

    @Override
    public TypedCalcLambda add(int other) {
        return this.addNumber(other);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaLong other) {
        return this.addNumber(other);
    }

    @Override
    public TypedCalcLambda add(long other) {
        return this.addNumber(other);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaDouble other) {
        return this.addNumber(other);
    }

    @Override
    public TypedCalcLambda add(double other) {
        return this.addNumber(other);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaVariable other) {
        return other.toLambda().addedTo(this);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaString other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(String other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    private TypedCalcLambda addNumber(TypedCalcLambda other) {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other.evaluateDouble(cvp);
        return this;
    }

    private TypedCalcLambda addNumber(double other) {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other;
        return this;
    }

    @Override
    public TypedCalcLambda subtractedFrom(TypedCalcLambda other) {
        return other.subtract(this);
    }

    @Override
    public TypedCalcLambda subtract(int other) {
        return this.subtract((double)other);
    }

    @Override
    public TypedCalcLambda subtract(long other) {
        return this.subtract((double)other);
    }

    @Override
    public TypedCalcLambda subtract(double other) {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) - other;
        return this;
    }

    private TypedCalcLambda subtractNumber(TypedCalcLambda other) {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) - other.evaluateDouble(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaInteger other) {
        return this.subtractNumber(other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaLong other) {
        return this.subtractNumber(other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaDouble other) {
        return this.subtractNumber(other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaVariable other) {
        return other.toLambda().subtractedFrom(this);
    }

    @Override
    public TypedCalcLambda multipliedWith(TypedCalcLambda left) {
        return left.multiply(this);
    }

    @Override
    public TypedCalcLambda multiply(int other) {
        return this.multiply((double)other);
    }

    @Override
    public TypedCalcLambda multiply(long other) {
        return this.multiply((double)other);
    }

    @Override
    public TypedCalcLambda multiply(double other) {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) * other;
        return this;
    }

    private TypedCalcLambda multiplyNumber(TypedCalcLambda other) {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) * other.evaluateDouble(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaInteger other) {
        return this.multiplyNumber(other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaLong other) {
        return this.multiplyNumber(other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaDouble other) {
        return this.multiplyNumber(other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaVariable other) {
        return other.toLambda().multipliedWith(this);
    }

    @Override
    public TypedCalcLambda dividedInto(TypedCalcLambda left) {
        return left.divide(this);
    }

    @Override
    public TypedCalcLambda divide(int other) {
        return this.divide((double)other);
    }

    @Override
    public TypedCalcLambda divide(long other) {
        return this.divide((double)other);
    }

    @Override
    public TypedCalcLambda divide(double other) {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) / other;
        return this;
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    private TypedCalcLambda divideNumber(TypedCalcLambda other) {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) / other.evaluateDouble(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaInteger other) {
        return this.divideNumber(other);
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaLong other) {
        return this.divideNumber(other);
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaDouble other) {
        return this.divideNumber(other);
    }

    @Override
    public TypedCalcLambda pow(TypedCalcLambda o) {
        TypedCalcLambda other = o.toLambda();
        if (!(other instanceof Numeric)) {
            throw new GorParsingException("Number expected for ^ operator");
        }
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> Math.pow(prev.evaluate(cvp), other.evaluateDouble(cvp));
        return this;
    }

    @Override
    public TypedCalcLambda negate() {
        CvpDoubleLambda prev = this.lambda;
        this.lambda = cvp -> -prev.evaluate(cvp);
        return this;
    }
}

