/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.haplotype;

public class GBasicRulesCalculator {
    private static final byte UNDETERMINED_PHASE = 0;
    private static final byte CORRECT_PHASE = 1;
    private static final byte INCORRECT_PHASE = 2;
    private static final byte DOUBLE_CONGRUENCY = 3;
    private static final byte TRIPLE_CONGRUENCY = 4;
    public static final byte INCOMPATIBLE_GENOTYPES = 5;
    protected byte unknown = (byte)-128;

    public void setUnknownAllele(byte unknown) {
        this.unknown = unknown;
    }

    public byte checkBasicRules(byte[] child, byte[] father, byte[] mother) {
        boolean motherUnknown;
        boolean childUnknown = child[0] == this.unknown || child[1] == this.unknown;
        boolean fatherUnknown = father[0] == this.unknown || father[1] == this.unknown;
        boolean bl = motherUnknown = mother[0] == this.unknown || mother[1] == this.unknown;
        if (childUnknown || fatherUnknown && motherUnknown) {
            return 0;
        }
        boolean childHeterozygous = child[0] != child[1];
        boolean fatherLikeChild = this.likeChild(father, child);
        boolean motherLikeChild = this.likeChild(mother, child);
        if (childHeterozygous) {
            if (fatherUnknown && motherLikeChild || motherUnknown && fatherLikeChild) {
                return 3;
            }
            if (fatherLikeChild && motherLikeChild) {
                return 4;
            }
        }
        if ((fatherUnknown || child[0] == father[0] || child[0] == father[1]) && (motherUnknown || child[1] == mother[0] || child[1] == mother[1])) {
            return 1;
        }
        if ((motherUnknown || child[0] == mother[0] || child[0] == mother[1]) && (fatherUnknown || child[1] == father[0] || child[1] == father[1])) {
            return 2;
        }
        return 5;
    }

    private boolean likeChild(byte[] parent, byte[] child) {
        if (parent[0] == child[0] && parent[1] == child[1]) {
            return true;
        }
        return parent[0] == child[1] && parent[1] == child[0];
    }
}

