/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory;

import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.templating.DialogArgumentWrapper;
import org.gorpipe.querydialogs.templating.NetworkTemplateLoader;
import org.gorpipe.querydialogs.templating.SkipFirstMethodModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Perspective {
    public static final String GLOBAL_GROUP = "[global]";
    private static final StringTemplateLoader TEMPLATE_LOADER;
    private static final Configuration TEMPLATE_CONFIG;
    private static final Logger logger;
    private final String namePrefix;
    private final String name;
    private final String groupName;
    private final boolean isDefault;
    private final String filterTemplate;
    private final String viewTemplate;
    private final Set<Object> viewTemplateColumns;
    private final Set<Object> initialColumns;
    private Map<String, ? extends Object> argumentMap;

    public static void initializeTempleConfig(FileReader fileResolver) {
        String macroPath = System.getProperty("dialog.macrodir", null);
        if (macroPath != null) {
            NetworkTemplateLoader netLoader = new NetworkTemplateLoader(macroPath, fileResolver);
            TEMPLATE_CONFIG.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(new TemplateLoader[]{TEMPLATE_LOADER, netLoader}));
        }
    }

    public Perspective(String namePrefix, String name, String groupName, Boolean isDefault, String filterTemplate, String viewTemplate, List<Object> viewTemplateColumns, List<Object> initialColumns) {
        this(namePrefix, name, groupName, isDefault, filterTemplate, viewTemplate, viewTemplateColumns, initialColumns, true);
    }

    public Perspective(Perspective persp) {
        this(persp.namePrefix, persp.name, persp.groupName, persp.isDefault, persp.filterTemplate, persp.viewTemplate, persp.getViewTemplateColumnsList(), persp.getInitialColumnsList(), false);
        this.setArgumentMap(persp.copyArgumentMap());
    }

    private Perspective(String namePrefix, String name, String groupName, Boolean isDefault, String filterTemplate, String viewTemplate, List<Object> viewTemplateColumns, List<Object> initialColumns, boolean loadTemplates) {
        this.namePrefix = namePrefix;
        this.name = name;
        this.groupName = groupName == null ? GLOBAL_GROUP : groupName;
        this.isDefault = isDefault != null && isDefault != false;
        this.filterTemplate = filterTemplate;
        this.viewTemplate = viewTemplate;
        this.viewTemplateColumns = this.makeColumnSet(viewTemplateColumns);
        this.initialColumns = this.makeColumnSet(initialColumns);
        if (loadTemplates) {
            this.initialize();
        }
    }

    private void initialize() {
        if (this.viewTemplate != null) {
            TEMPLATE_LOADER.putTemplate(this.getViewTemplateName(), this.viewTemplate);
        }
        if (this.filterTemplate != null) {
            TEMPLATE_LOADER.putTemplate(this.getFilterTemplateName(), "<@compress>" + this.filterTemplate + "</@compress>");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public VIEW_TYPE getViewType() {
        if (this.viewTemplate != null && this.viewTemplate.length() > 0) {
            return VIEW_TYPE.HTML;
        }
        return VIEW_TYPE.TABLE;
    }

    public String getViewTemplate() {
        return this.viewTemplate;
    }

    public void setArgumentMap(Map<String, ? extends Object> argumentMap) {
        this.argumentMap = argumentMap;
    }

    private Map<String, ? extends Object> copyArgumentMap() {
        HashMap<String, Argument> newArgumentMap = null;
        if (this.argumentMap != null) {
            newArgumentMap = new HashMap<String, Argument>();
            for (Map.Entry<String, ? extends Object> entry : this.argumentMap.entrySet()) {
                Argument dialogArg = (Argument)entry.getValue();
                newArgumentMap.put(entry.getKey(), dialogArg.copyArgument());
            }
        }
        return newArgumentMap;
    }

    public String getFilterString() {
        if (this.argumentMap != null) {
            String filterString = this.interpolate(this.getFilterTemplateName(), this.argumentMap);
            return filterString == null ? "" : filterString;
        }
        return this.filterTemplate == null ? "" : this.filterTemplate;
    }

    public String getViewString(Map<String, ? extends Object> data) {
        HashMap<String, ? extends Object> withDialogArguments = new HashMap<String, Object>(data);
        if (this.argumentMap != null) {
            withDialogArguments.put("dialog_args", this.argumentMap);
        }
        return this.interpolate(this.getViewTemplateName(), withDialogArguments);
    }

    public Set<Object> getViewTemplateColumns() {
        return this.viewTemplateColumns;
    }

    public Set<Object> getInitialColumns() {
        return this.initialColumns;
    }

    private List<Object> getViewTemplateColumnsList() {
        return this.viewTemplateColumns != null ? new ArrayList<Object>(this.viewTemplateColumns) : null;
    }

    private List<Object> getInitialColumnsList() {
        return this.initialColumns != null ? new ArrayList<Object>(this.initialColumns) : null;
    }

    private String interpolate(String templateName, Map<String, ? extends Object> arguments) {
        try {
            SkipFirstMethodModel sf = (SkipFirstMethodModel)TEMPLATE_CONFIG.getSharedVariable("skip");
            sf.reset();
            Template template = TEMPLATE_CONFIG.getTemplate(templateName);
            template.setTemplateExceptionHandler((TemplateExceptionHandler)new PerspectiveTemplateExceptionHandler());
            StringWriter writer = new StringWriter();
            template.process(arguments, (Writer)writer);
            return writer.toString().trim();
        }
        catch (FileNotFoundException sf) {
        }
        catch (ParseException pe) {
            throw new RuntimeException("Invalid template", pe);
        }
        catch (IOException ioe) {
            logger.error("Error on String(Reader/Writer) io", (Throwable)ioe);
        }
        catch (TemplateException te) {
            logger.warn("Could not interpolate query template", (Throwable)te);
            return te.getMessage();
        }
        return null;
    }

    private String getViewTemplateName() {
        return this.namePrefix + "." + this.getName() + ".view";
    }

    private String getFilterTemplateName() {
        return this.namePrefix + "." + this.getName() + ".filter";
    }

    private Set<Object> makeColumnSet(List<Object> columns) {
        if (columns != null && !columns.isEmpty()) {
            HashSet<Object> result = new HashSet<Object>(columns.size());
            for (Object o : columns) {
                if (Number.class.isAssignableFrom(o.getClass())) {
                    result.add(((Number)o).intValue());
                    continue;
                }
                result.add(o.toString().toLowerCase());
            }
            return result;
        }
        return null;
    }

    public String toString() {
        return this.getName() + " " + this.getViewType();
    }

    static {
        logger = LoggerFactory.getLogger(Perspective.class);
        try {
            freemarker.log.Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        TEMPLATE_CONFIG = new Configuration();
        TEMPLATE_LOADER = new StringTemplateLoader();
        TEMPLATE_CONFIG.setTemplateLoader((TemplateLoader)TEMPLATE_LOADER);
        TEMPLATE_CONFIG.setObjectWrapper((ObjectWrapper)new DialogArgumentWrapper());
        TEMPLATE_CONFIG.setSharedVariable("skip", (TemplateModel)new SkipFirstMethodModel());
        TEMPLATE_CONFIG.setLocale(Locale.ENGLISH);
    }

    private static final class PerspectiveTemplateExceptionHandler
    implements TemplateExceptionHandler {
        private static final Pattern MESSAGE_PATTERN = Pattern.compile("Expression [\\p{Graph}]* is undefined on.*");

        private PerspectiveTemplateExceptionHandler() {
        }

        public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
            try {
                Matcher m = MESSAGE_PATTERN.matcher(te.getMessage());
                if (!m.matches()) {
                    throw te;
                }
                int colNameStart = te.getMessage().indexOf("Expression ") + 11;
                int colNameEnd = te.getMessage().indexOf(" is undefined on");
                out.write("[Unknown column name: " + te.getMessage().substring(colNameStart, colNameEnd).trim() + "]");
            }
            catch (IOException e) {
                throw new TemplateException("Failed to write required argument. Cause: " + e, env);
            }
        }
    }

    public static enum VIEW_TYPE {
        HTML,
        TABLE;

    }
}

