/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.gor.model.ReportCommand;
import org.gorpipe.gor.model.RequiredColumn;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.ChartDataType;
import org.gorpipe.querydialogs.DialogDescription;
import org.gorpipe.querydialogs.DialogType;
import org.gorpipe.querydialogs.GridArgumentBuilder;
import org.gorpipe.querydialogs.factory.AbstractDialogFactory;
import org.gorpipe.querydialogs.factory.ColumnGroup;
import org.gorpipe.querydialogs.factory.Perspective;
import org.gorpipe.querydialogs.factory.PerspectiveDialog;
import org.gorpipe.querydialogs.factory.PerspectiveDialogDisplayParams;
import org.gorpipe.querydialogs.factory.builder.DateArgumentBuilder;
import org.gorpipe.querydialogs.factory.builder.FileArgumentBuilder;
import org.gorpipe.querydialogs.factory.builder.NumberArgumentBuilder;
import org.gorpipe.querydialogs.factory.builder.QueryArgumentBuilder;
import org.gorpipe.querydialogs.factory.builder.StringArgumentBuilder;

public class PerspectiveDialogFactory
extends AbstractDialogFactory<PerspectiveDialog> {
    public static final String OTHER_DIALOG_CATEGORY = "Other";

    public PerspectiveDialogFactory(FileReader fileResolver, QueryEvaluator queryEvaluator) {
        super(fileResolver, queryEvaluator);
    }

    public static PerspectiveDialogFactory create(FileReader fileResolver, QueryEvaluator queryEval) {
        PerspectiveDialogFactory factory = new PerspectiveDialogFactory(fileResolver, queryEval);
        factory.registerArgumentBuilder(ArgumentType.STRING, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.NUMBER, new NumberArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.DATE, new DateArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.FILE, new FileArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.POSITION_RANGE, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.PN_LISTS, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.FILTERED_PN_LISTS, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.SLIDER, new NumberArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.VIRTUAL_PN_FILE, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.GOR_GRID, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.VALUE_GRID, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.PN_LISTS_ENTRIES, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.GENE_LIST, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.GRID, new GridArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.CHECK_ITEMS, new StringArgumentBuilder(fileResolver));
        factory.registerArgumentBuilder(ArgumentType.QUERY, new QueryArgumentBuilder(fileResolver, queryEval));
        return factory;
    }

    @Override
    protected PerspectiveDialog buildDialog(String name, Map<String, ? extends Object> attributes) throws TemplateException {
        String gitSHA;
        String category = attributes.containsKey("dialog_group") ? attributes.get("dialog_group").toString() : OTHER_DIALOG_CATEGORY;
        String imageColor = attributes.containsKey("image_color") ? attributes.get("image_color").toString() : "";
        PerspectiveDialogDisplayParams displayParams = new PerspectiveDialogDisplayParams(category, imageColor);
        String displayName = attributes.containsKey("name") ? attributes.get("name").toString() : name;
        String shortDescr = attributes.containsKey("short_description") ? attributes.get("short_description").toString() : "Missing short description";
        String detailedDescr = attributes.containsKey("long_description") ? attributes.get("long_description").toString() : "Missing long description";
        String helpLink = attributes.containsKey("help_link") ? attributes.get("help_link").toString() : name;
        String string = gitSHA = attributes.containsKey("Git_SHASUM") ? attributes.get("Git_SHASUM").toString() : null;
        if (gitSHA == null) {
            displayName = name;
            detailedDescr = attributes.containsKey("description") ? attributes.get("description").toString() : null;
            shortDescr = attributes.containsKey("list_description") ? attributes.get("list_description").toString() : null;
        }
        DialogDescription dialogDescription = new DialogDescription(displayName, detailedDescr, shortDescr, helpLink);
        String writePath = attributes.containsKey("write_path") ? attributes.get("write_path").toString() : "";
        DialogType type = attributes.containsKey("dialog_type") ? DialogType.valueOf(attributes.get("dialog_type").toString().toUpperCase().trim()) : DialogType.HTML_COL;
        Object oquery = attributes.get("query");
        String query = "";
        if (oquery != null) {
            if (oquery instanceof Map) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    query = objectMapper.writeValueAsString(oquery);
                }
                catch (JsonProcessingException e) {
                    query = oquery.toString();
                }
            } else {
                query = oquery.toString();
            }
        }
        String errorMsgTemplate = attributes.containsKey("error_message") ? attributes.get("error_message").toString() : null;
        String longRunningQueryTemplate = attributes.containsKey("query_type") ? attributes.get("query_type").toString() : null;
        String version = attributes.containsKey("Version_info") ? attributes.get("Version_info").toString() : null;
        String packageVersion = attributes.containsKey("Package_version") ? attributes.get("Package_version").toString() : null;
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        if (attributes.containsKey("arguments")) {
            List argumentAttributes = (List)attributes.get("arguments");
            for (Map entry : argumentAttributes) {
                try {
                    arguments.add(this.buildArgument((String)entry.get("name"), entry));
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("Error in dialog " + name + "\n" + ex.getMessage());
                }
            }
        }
        String htmlTemplate = attributes.containsKey("html_template") ? attributes.get("html_template").toString() : null;
        List initialColumns = attributes.containsKey("initial_columns") ? (List)attributes.get("initial_columns") : null;
        ArrayList<Perspective> perspectives = new ArrayList<Perspective>();
        if (attributes.containsKey("perspectives")) {
            List perspectiveAttributes = (List)attributes.get("perspectives");
            for (Map entry : perspectiveAttributes) {
                perspectives.add(new Perspective(name, (String)entry.get("name"), (String)entry.get("group"), (Boolean)entry.get("default"), (String)entry.get("filter"), (String)entry.get("view_template"), (List)entry.get("view_columns"), (List)entry.get("initial_columns")));
            }
        }
        ArrayList<ColumnGroup> columnGroups = new ArrayList<ColumnGroup>();
        if (attributes.containsKey("column_groups")) {
            List groupAttributes = (List)attributes.get("column_groups");
            int order = 1000;
            for (Map entry : groupAttributes) {
                columnGroups.add(new ColumnGroup((String)entry.get("name"), (String)entry.get("description"), (String)entry.get("columns"), true, order--));
            }
        }
        String chartScript = attributes.containsKey("chartScript") ? attributes.get("chartScript").toString() : null;
        String chartExec = attributes.containsKey("chart") ? attributes.get("chart").toString() : null;
        String chartColumns = attributes.containsKey("chartColumns") ? attributes.get("chartColumns").toString() : "";
        ChartDataType chartDF = attributes.containsKey("chartDF") ? ChartDataType.valueOf(attributes.get("chartDF").toString()) : ChartDataType.PLAINTEXT;
        List<ReportCommand> reportCommands = this.getReportCommands(attributes);
        return new PerspectiveDialog(attributes, this.fileResolver, this.queryEval, dialogDescription, displayParams, type, query, chartScript, chartExec, chartColumns, chartDF, arguments, htmlTemplate, initialColumns, perspectives, columnGroups, reportCommands, errorMsgTemplate, writePath, longRunningQueryTemplate, version, packageVersion, gitSHA);
    }

    @Override
    public List<PerspectiveDialog> buildDialogs(Path resource) throws IOException, TemplateException {
        List<PerspectiveDialog> dialogs = super.buildDialogs(resource);
        for (PerspectiveDialog dialog : dialogs) {
            dialog.setDialogsFilePath(resource);
        }
        return dialogs;
    }

    @Override
    public List<PerspectiveDialog> buildDialogs(String resource, String cacheDir) throws IOException, TemplateException {
        List<PerspectiveDialog> dialogs = super.buildDialogs(resource, cacheDir);
        for (PerspectiveDialog dialog : dialogs) {
            dialog.setDialogsFilePath(this.getFileReader().toPath(resource));
        }
        return dialogs;
    }

    @Override
    public List<PerspectiveDialog> buildDialogs(String resource) throws IOException, TemplateException {
        List<PerspectiveDialog> dialogs = super.buildDialogs(resource);
        for (PerspectiveDialog dialog : dialogs) {
            dialog.setDialogsFilePath(this.getFileReader().toPath(resource));
        }
        return dialogs;
    }

    public List<PerspectiveDialog> buildDialogs(String resource, byte[] ymlPayload) throws IOException, TemplateException {
        List<PerspectiveDialog> dialogs = super.buildDialogs(new StringReader(new String(ymlPayload)), null);
        for (PerspectiveDialog dialog : dialogs) {
            dialog.setDialogsFilePath(this.getFileReader().toPath(resource));
        }
        return dialogs;
    }

    private List<ReportCommand> getReportCommands(Map<String, ? extends Object> attributes) {
        ArrayList<ReportCommand> reportCommands = new ArrayList<ReportCommand>();
        if (attributes.containsKey("drill_in_reports")) {
            List reportCommandsAttributes = (List)attributes.get("drill_in_reports");
            for (Map entry : reportCommandsAttributes) {
                ArrayList<RequiredColumn> requiredColumns = new ArrayList<RequiredColumn>();
                for (String reqCol : (List)entry.get("required_columns")) {
                    requiredColumns.add(new RequiredColumn(reqCol));
                }
                try {
                    String category = entry.get("category") != null ? (String)entry.get("category") : "";
                    reportCommands.add(new ReportCommand((String)entry.get("name"), category, (String)entry.get("query"), requiredColumns));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return reportCommands;
    }
}

