/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Regression;

import org.apache.commons.math3.special.Erf;

class RegressionUtilities {
    private static final double SQRT_2 = 1.4142135623730951;

    private RegressionUtilities() {
    }

    static double computePValue(double z) {
        return 1.0 - Erf.erf((double)(Math.abs(z) / 1.4142135623730951));
    }

    static void computePValues(double[] z, double[] pValues) {
        for (int i = 0; i < z.length; ++i) {
            pValues[i] = RegressionUtilities.computePValue(z[i]);
        }
    }

    static double[][] getTriangularMatrix(int dim) {
        double[][] toReturn = new double[dim][];
        int i = 0;
        while (i < dim) {
            toReturn[i++] = new double[i];
        }
        return toReturn;
    }
}

