/*
 * Decompiled with CFR 0.152.
 */
package gorsat.gtgen;

import gorsat.gtgen.PowerLookupTable;
import java.util.Arrays;

public class GTGen {
    private final int n;
    private int m;
    private double priorAF;
    private boolean hasPrior;
    private final double[] qs;
    private final boolean[] hasData;
    private double pAA = 0.25;
    private double pAB = 0.5;
    private double pBB = 0.25;
    private double fpaa = 0.3333333333333333;
    private double fpab = 0.3333333333333333;
    private double fpbb = 0.3333333333333333;
    private int covCount;
    private final PowerLookupTable ePlt;
    private final PowerLookupTable oneMinusEPlt;
    private final PowerLookupTable halfPlt;

    public GTGen(double e, int n) {
        this.n = n;
        this.qs = new double[3 * n];
        this.hasData = new boolean[n];
        this.ePlt = PowerLookupTable.getLookupTable(e);
        this.oneMinusEPlt = PowerLookupTable.getLookupTable(1.0 - e);
        this.halfPlt = PowerLookupTable.getLookupTable(0.5);
    }

    public void reset() {
        Arrays.fill(this.hasData, false);
        this.hasPrior = false;
        this.covCount = 0;
    }

    public int getNumberOfSamples() {
        return this.n;
    }

    public double getPriorAf() {
        return this.priorAF;
    }

    public int getPriorAn() {
        return this.m;
    }

    public void setAF(double af) {
        this.pAA = (1.0 - af) * (1.0 - af);
        this.pAB = 2.0 * af * (1.0 - af);
        this.pBB = af * af;
    }

    public void setAFsinglePriors(double fpab, double fpbb) {
        this.fpab = fpab;
        this.fpbb = fpbb;
        this.fpaa = 1.0 - fpab - fpbb;
    }

    public double getAF() {
        return 0.5 * this.pAB + this.pBB;
    }

    public double get_pAB() {
        return this.pAB;
    }

    public double get_pBB() {
        return this.pBB;
    }

    public boolean hasCoverage(int idx) {
        return this.hasData[idx];
    }

    public int getAn() {
        return this.hasPrior ? this.m + this.covCount : this.covCount;
    }

    public void setPrior(double pab, double pbb, int m) {
        this.pAB = pab;
        this.pBB = pbb;
        this.pAA = 1.0 - pab - pbb;
        this.m = m;
        this.hasPrior = true;
        this.priorAF = this.getAF();
    }

    public void setPrior(double af, int m) {
        this.pBB = af * af;
        this.pAA = (1.0 - af) * (1.0 - af);
        this.pAB = 1.0 - this.pAA - this.pBB;
        this.m = m;
        this.hasPrior = true;
        this.priorAF = this.getAF();
    }

    public void addData(int sampleIdx, double pAA, double pAB, double pBB) {
        if (this.hasData[sampleIdx]) {
            throw new IllegalStateException("The data for sample " + sampleIdx + " has already been set.");
        }
        this.hasData[sampleIdx] = true;
        ++this.covCount;
        this.qs[3 * sampleIdx] = pAA / this.fpaa;
        this.qs[3 * sampleIdx + 1] = pAB / this.fpab;
        this.qs[3 * sampleIdx + 2] = pBB / this.fpbb;
    }

    public void addData(int sampleIdx, int call, int depth) {
        if (this.hasData[sampleIdx]) {
            throw new IllegalStateException("The data for sample " + sampleIdx + " has already been set.");
        }
        this.hasData[sampleIdx] = true;
        ++this.covCount;
        this.qs[3 * sampleIdx] = this.ePlt.pow(call) * this.oneMinusEPlt.pow(depth - call);
        this.qs[3 * sampleIdx + 1] = this.halfPlt.pow(depth);
        this.qs[3 * sampleIdx + 2] = this.ePlt.pow(depth - call) * this.oneMinusEPlt.pow(call);
    }

    public boolean impute(double[] gts, double tol, int maxIt) {
        if (this.covCount > 0) {
            boolean converged = this.computeAf(tol, maxIt);
            this.fillGenotypes(gts);
            return converged;
        }
        Arrays.fill(gts, 0.0);
        return true;
    }

    private void fillGenotypes(double[] gts) {
        for (int i = 0; i < this.n; ++i) {
            if (this.hasData[i]) {
                double x0 = this.qs[3 * i] * this.pAA;
                double x1 = this.qs[3 * i + 1] * this.pAB;
                double x2 = this.qs[3 * i + 2] * this.pBB;
                double sum_rec = 1.0 / (x0 + x1 + x2);
                gts[3 * i] = x0 * sum_rec;
                gts[3 * i + 1] = x1 * sum_rec;
                gts[3 * i + 2] = x2 * sum_rec;
                continue;
            }
            gts[3 * i] = 0.0;
            gts[3 * i + 1] = 0.0;
            gts[3 * i + 2] = 0.0;
        }
    }

    private boolean computeAf(double tol, int maxIt) {
        if (this.hasPrior) {
            return this.computeAfWithPrior(tol, maxIt);
        }
        return this.computeAfWithoutPrior(tol, maxIt);
    }

    private boolean computeAfWithPrior(double tol, int maxIt) {
        double p0AA = this.pAA;
        double p0AB = this.pAB;
        double p0BB = this.pBB;
        double error = Double.POSITIVE_INFINITY;
        double corr_factor = 0.01 / (double)(1 + this.m + this.covCount);
        int it = 0;
        while (error > tol && error > corr_factor && it++ < maxIt) {
            double sum_pAA = (double)this.m * p0AA;
            double sum_pAB = (double)this.m * p0AB;
            double sum_pBB = (double)this.m * p0BB;
            for (int i = 0; i < this.n; ++i) {
                if (!this.hasData[i]) continue;
                double x0 = this.qs[3 * i] * this.pAA;
                double x1 = this.qs[3 * i + 1] * this.pAB;
                double x2 = this.qs[3 * i + 2] * this.pBB;
                double sum_rec = 1.0 / (x0 + x1 + x2);
                sum_pAA += x0 * sum_rec;
                sum_pAB += x1 * sum_rec;
                sum_pBB += x2 * sum_rec;
            }
            double new_pAA_temp = corr_factor + sum_pAA / (double)(this.m + this.covCount);
            double new_pAB_temp = corr_factor + sum_pAB / (double)(this.m + this.covCount);
            double new_pBB_temp = corr_factor + sum_pBB / (double)(this.m + this.covCount);
            double tot_prob = new_pAA_temp + new_pAB_temp + new_pBB_temp;
            double new_pAA = new_pAA_temp / tot_prob;
            double new_pAB = new_pAB_temp / tot_prob;
            double new_pBB = new_pBB_temp / tot_prob;
            error = Math.max(Math.abs(new_pAA - this.pAA), Math.max(Math.abs(new_pAB - this.pAB), Math.abs(new_pBB - this.pBB)));
            this.pAA = new_pAA;
            this.pAB = new_pAB;
            this.pBB = new_pBB;
        }
        return error <= tol || error < corr_factor;
    }

    private boolean computeAfWithoutPrior(double tol, int maxIt) {
        double error = Double.POSITIVE_INFINITY;
        double corr_factor = 0.01 / (double)(1 + this.covCount);
        int it = 0;
        while (error > tol && error > corr_factor && it++ < maxIt) {
            double sum_pAA = 0.0;
            double sum_pAB = 0.0;
            double sum_pBB = 0.0;
            for (int i = 0; i < this.n; ++i) {
                if (!this.hasData[i]) continue;
                double x0 = this.qs[3 * i] * this.pAA;
                double x1 = this.qs[3 * i + 1] * this.pAB;
                double x2 = this.qs[3 * i + 2] * this.pBB;
                double sum_rec = 1.0 / (x0 + x1 + x2);
                sum_pAA += x0 * sum_rec;
                sum_pAB += x1 * sum_rec;
                sum_pBB += x2 * sum_rec;
            }
            double new_pAA_temp = corr_factor + sum_pAA / (double)this.covCount;
            double new_pAB_temp = corr_factor + sum_pAB / (double)this.covCount;
            double new_pBB_temp = corr_factor + sum_pBB / (double)this.covCount;
            double tot_prob = new_pAA_temp + new_pAB_temp + new_pBB_temp;
            double new_pAA = new_pAA_temp / tot_prob;
            double new_pAB = new_pAB_temp / tot_prob;
            double new_pBB = new_pBB_temp / tot_prob;
            error = Math.max(Math.abs(new_pAA - this.pAA), Math.max(Math.abs(new_pAB - this.pAB), Math.abs(new_pBB - this.pBB)));
            this.pAA = new_pAA;
            this.pAB = new_pAB;
            this.pBB = new_pBB;
        }
        return error <= tol || error < corr_factor;
    }
}

