/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory;

import freemarker.template.TemplateException;
import gorsat.Utilities.Utilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.Dialog;
import org.gorpipe.querydialogs.factory.ArgumentBuilder;
import org.yaml.snakeyaml.Yaml;

public abstract class AbstractDialogFactory<T extends Dialog> {
    private final Map<ArgumentType, ArgumentBuilder> argumentBuilders;
    protected String inputFileFirstReport;
    FileReader fileResolver;
    QueryEvaluator queryEval;
    boolean ignoreAllowedMismatch;

    public AbstractDialogFactory(FileReader fr, QueryEvaluator queryEval, boolean ignoreAllowedMismatch) {
        this.fileResolver = fr;
        this.queryEval = queryEval;
        this.argumentBuilders = new HashMap<ArgumentType, ArgumentBuilder>();
        this.ignoreAllowedMismatch = ignoreAllowedMismatch;
    }

    public ArgumentBuilder registerArgumentBuilder(ArgumentType type, ArgumentBuilder builder) {
        builder.setIgnoreAllowedMismatch(this.ignoreAllowedMismatch);
        return this.argumentBuilders.put(type, builder);
    }

    public FileReader getFileReader() {
        return this.fileResolver;
    }

    public QueryEvaluator getQueryEval() {
        return this.queryEval;
    }

    public List<T> buildDialogs(String resource, String cacheDir) throws IOException, TemplateException {
        try (BufferedReader br = this.fileResolver.getReader(resource);){
            List<T> list = this.buildDialogs(br, cacheDir);
            return list;
        }
    }

    public List<T> buildDialogs(String resource) throws IOException, TemplateException {
        try (BufferedReader br = this.fileResolver.getReader(resource);){
            List<T> list = this.buildDialogs(br, null);
            return list;
        }
    }

    public List<T> buildDialogs(Path resource) throws IOException, TemplateException {
        try (Reader br = this.fileResolver.getReader(resource);){
            List<T> list = this.buildDialogs(br, null);
            return list;
        }
    }

    public List<T> buildDialogs(Reader reader, String cacheDir) throws TemplateException, IOException {
        Yaml yaml = new Yaml();
        Object o = yaml.load(reader);
        if (o == null) {
            return new ArrayList();
        }
        if (!(o instanceof Map)) {
            throw new RuntimeException("Invalid dialog configuration file");
        }
        Map dialogMap = (Map)o;
        this.inputFileFirstReport = (String)dialogMap.keySet().iterator().next();
        ArrayList<T> dialogs = new ArrayList<T>();
        if (cacheDir == null) {
            cacheDir = Files.createTempDirectory("dialogs", new FileAttribute[0]).toAbsolutePath().toString();
        }
        for (String key : dialogMap.keySet()) {
            Map val = (Map)dialogMap.get(key);
            for (String skey : val.keySet()) {
                boolean found;
                Object oval = val.get(skey);
                if (!(oval instanceof String)) continue;
                Object sval = oval.toString();
                int i = ((String)sval).indexOf("${");
                boolean bl = found = i != -1;
                while (i != -1) {
                    int u = ((String)sval).indexOf("}", i + 1);
                    String entry = ((String)sval).substring(i + 2, u);
                    if (val.containsKey(entry)) {
                        String value = val.get(entry).toString();
                        sval = ((String)sval).substring(0, i) + Utilities.makeTempFile(value, cacheDir) + ((String)sval).substring(u + 1);
                    }
                    i = ((String)sval).indexOf("${", i + 1);
                }
                if (!found) continue;
                val.put(skey, sval);
            }
        }
        TreeSet sortedKeys = new TreeSet(dialogMap.keySet());
        for (String key : sortedKeys) {
            dialogs.add(this.buildDialog(key, (Map)dialogMap.get(key)));
        }
        return dialogs;
    }

    public String getInputFileFirstReport() {
        return this.inputFileFirstReport;
    }

    protected abstract T buildDialog(String var1, Map<String, ? extends Object> var2) throws TemplateException;

    protected Argument buildArgument(String name, Map<String, ? extends Object> attributes) {
        ArgumentType argType = attributes.containsKey("type") ? ArgumentType.valueOf(attributes.get("type").toString().trim().toUpperCase()) : ArgumentType.STRING;
        return this.argumentBuilders.get(argType).build(name, attributes);
    }
}

