/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Script;

import gorsat.Commands.CommandParseUtilities$;
import gorsat.DynIterator;
import gorsat.Script.ScriptParsers$;
import gorsat.Script.SplitEntry;
import gorsat.Script.SplitEntry$;
import gorsat.Script.SplitManager;
import gorsat.process.GorPipeCommands$;
import java.io.Serializable;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorContext;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SplitManager$
implements scala.Serializable {
    public static SplitManager$ MODULE$;
    private final String REGULAR_REPLACEMENT_PATTERN;
    private final String SPLIT_REPLACEMENT_PATTERN;
    private final String WHERE_SPLIT_WINDOW;
    private final String CHROM_PATTERN;
    private final String START_PATTERN;
    private final String STOP_PATTERN;
    private final String RANGETAG_PATTERN;
    private final int MAXIMUM_NUMBER_OF_SPLITS;
    private final int MAX_CHROM_SIZE;

    static {
        new SplitManager$();
    }

    public String REGULAR_REPLACEMENT_PATTERN() {
        return this.REGULAR_REPLACEMENT_PATTERN;
    }

    public String SPLIT_REPLACEMENT_PATTERN() {
        return this.SPLIT_REPLACEMENT_PATTERN;
    }

    public String WHERE_SPLIT_WINDOW() {
        return this.WHERE_SPLIT_WINDOW;
    }

    public String CHROM_PATTERN() {
        return this.CHROM_PATTERN;
    }

    public String START_PATTERN() {
        return this.START_PATTERN;
    }

    public String STOP_PATTERN() {
        return this.STOP_PATTERN;
    }

    public String RANGETAG_PATTERN() {
        return this.RANGETAG_PATTERN;
    }

    public int MAXIMUM_NUMBER_OF_SPLITS() {
        return this.MAXIMUM_NUMBER_OF_SPLITS;
    }

    public int MAX_CHROM_SIZE() {
        return this.MAX_CHROM_SIZE;
    }

    public SplitManager createFromCommand(String groupName, String commandToExecute, GorContext context) {
        SplitManager splitManager;
        block1: {
            String splitOverlap;
            String splits;
            String splitOpt;
            block2: {
                splitManager = null;
                splitManager = commandToExecute.contains(this.REGULAR_REPLACEMENT_PATTERN()) ? new SplitManager(groupName, this.parseBuildSizeSplit(context.getSession().getProjectContext().getReferenceBuild().getBuildSize()), this.REGULAR_REPLACEMENT_PATTERN()) : new SplitManager(groupName, this.parseSplitSizeSplit(context.getSession().getProjectContext().getReferenceBuild().getBuildSize(), context.getSession().getProjectContext().getReferenceBuild().getBuildSplit()), this.SPLIT_REPLACEMENT_PATTERN());
                if (!commandToExecute.contains(this.REGULAR_REPLACEMENT_PATTERN()) && !commandToExecute.contains(this.SPLIT_REPLACEMENT_PATTERN())) break block1;
                Tuple4<String, String, String, Object> tuple4 = ScriptParsers$.MODULE$.splitOptionParser(commandToExecute);
                if (tuple4 == null) {
                    throw new MatchError(tuple4);
                }
                String splitOpt2 = (String)tuple4._1();
                String splits2 = (String)tuple4._2();
                String splitOverlap2 = (String)tuple4._3();
                boolean splitZero = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
                Tuple4 tuple42 = new Tuple4((Object)splitOpt2, (Object)splits2, (Object)splitOverlap2, (Object)BoxesRunTime.boxToBoolean((boolean)splitZero));
                Tuple4 tuple43 = tuple42;
                splitOpt = (String)tuple43._1();
                splits = (String)tuple43._2();
                splitOverlap = (String)tuple43._3();
                boolean splitZero2 = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
                if (!CommandParseUtilities$.MODULE$.isNestedCommand(splits)) break block2;
                splitManager = new SplitManager(groupName, this.parseNestedSplit(context, splits, splitZero2 ? 0 : 1), splitManager.replacementPattern());
                break block1;
            }
            String string = splitOpt;
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block1;
            String string3 = splitOverlap;
            String string4 = "";
            splitManager = new SplitManager(groupName, this.parseArbitrarySplit(context.getSession().getProjectContext().getReferenceBuild().getBuildSize(), new StringOps(Predef$.MODULE$.augmentString(splits)).toInt(), !(string3 != null ? !string3.equals(string4) : string4 != null) ? 0 : new StringOps(Predef$.MODULE$.augmentString(splitOverlap)).toInt()), splitManager.replacementPattern());
        }
        return splitManager;
    }

    public Map<String, SplitEntry> parseBuildSizeSplit(java.util.Map<String, Integer> buildSizes) {
        ObjectRef chromosomeSplits = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(buildSizes).asScala()).foreach((Function1 & Serializable & scala.Serializable)c -> {
            chromosomeSplits.elem = ((Map)chromosomeSplits.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c._1()), (Object)new SplitEntry((String)c._1(), 0, SplitManager$.MODULE$.getUpperBounds((String)c._1(), Predef$.MODULE$.Integer2int((Integer)c._2()), buildSizes), SplitEntry$.MODULE$.apply$default$4())));
            return BoxedUnit.UNIT;
        });
        return (Map)chromosomeSplits.elem;
    }

    public Map<String, SplitEntry> parseSplitSizeSplit(java.util.Map<String, Integer> buildSizes, java.util.Map<String, Integer> buildSplits) {
        ObjectRef chromosomeSplits = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(buildSizes).asScala()).foreach((Function1 & Serializable & scala.Serializable)c -> {
            SplitManager$.$anonfun$parseSplitSizeSplit$1(buildSplits, chromosomeSplits, buildSizes, c);
            return BoxedUnit.UNIT;
        });
        return (Map)chromosomeSplits.elem;
    }

    public Map<String, SplitEntry> parseArbitrarySplit(java.util.Map<String, Integer> buildSizes, int iSplitSize, int splitOverlap) {
        ObjectRef chromosomeSplits = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        IntRef splitSize = IntRef.create((int)(iSplitSize <= 1000 && splitOverlap == 0 ? (int)(3000000000L / (long)iSplitSize) : iSplitSize));
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(buildSizes).asScala()).foreach((Function1 & Serializable & scala.Serializable)c -> {
            SplitManager$.$anonfun$parseArbitrarySplit$1(splitSize, splitOverlap, chromosomeSplits, buildSizes, c);
            return BoxedUnit.UNIT;
        });
        return (Map)chromosomeSplits.elem;
    }

    public Map<String, SplitEntry> parseNestedSplit(GorContext context, String query, int base) {
        Map chromosomeSplits = Predef$.MODULE$.Map().empty();
        String iteratorCommand = CommandParseUtilities$.MODULE$.parseNestedCommand(query).trim();
        try (DynIterator.DynamicRowSource dynamicSource = null;){
            dynamicSource = new DynIterator.DynamicRowSource(iteratorCommand, context, DynIterator.DynamicRowSource$.MODULE$.$lessinit$greater$default$3());
            int i = 0;
            String lastChr = "";
            while (dynamicSource.hasNext()) {
                Row row = dynamicSource.next();
                if (!row.chr.equals(lastChr)) {
                    i = 1;
                    lastChr = row.chr;
                }
                int pos = row.pos + base;
                int end = row.colAsInt(2);
                String tag = row.numCols() > 3 ? ((Object)row.colAsString(3)).toString() : "";
                chromosomeSplits = chromosomeSplits.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(row.chr).append("_").append(i).toString()), (Object)new SplitEntry(row.chr, pos, end, tag)));
                ++i;
            }
        }
        return chromosomeSplits;
    }

    public int parseNestedSplit$default$3() {
        return 1;
    }

    public boolean useWholeChromosomeSplit(String command2) {
        String commandUpperCase = command2.toUpperCase();
        BooleanRef commandsOk = BooleanRef.create((boolean)true);
        String[] commandsToCheck = GorPipeCommands$.MODULE$.getWholeChromosomeSplitCommands();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commandsToCheck)).foreach((Function1 & Serializable & scala.Serializable)command -> {
            Object object;
            if (commandUpperCase.contains((CharSequence)command)) {
                String y = commandUpperCase.replaceAll(new StringBuilder(9).append((String)command).append(" +1[^0-9]").toString(), "xxx");
                if (y.contains(new StringBuilder(1).append((String)command).append(" ").toString())) {
                    commandsOk$1.elem = false;
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxesRunTime.boxToBoolean((boolean)commandsOk$1.elem);
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return !commandsOk.elem;
    }

    public int getUpperBounds(String chrom, int pos, java.util.Map<String, Integer> buildSizes) {
        return buildSizes.containsKey(chrom) && pos >= Predef$.MODULE$.Integer2int(buildSizes.get(chrom)) ? -1 : pos;
    }

    public SplitManager apply(String groupName, Map<String, SplitEntry> chromosomeSplits, String replacementPattern) {
        return new SplitManager(groupName, chromosomeSplits, replacementPattern);
    }

    public Option<Tuple3<String, Map<String, SplitEntry>, String>> unapply(SplitManager x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.groupName(), x$0.chromosomeSplits(), (Object)x$0.replacementPattern()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$parseSplitSizeSplit$1(java.util.Map buildSplits$1, ObjectRef chromosomeSplits$2, java.util.Map buildSizes$2, Tuple2 c) {
        Option option = Option$.MODULE$.apply(buildSplits$1.getOrDefault(c._1(), null));
        if (option instanceof Some) {
            Some some = (Some)option;
            Integer chromosomeSplit = (Integer)some.value();
            chromosomeSplits$2.elem = ((Map)chromosomeSplits$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append((String)c._1()).append("a").toString()), (Object)new SplitEntry((String)c._1(), 0, Predef$.MODULE$.Integer2int(chromosomeSplit) - 1, SplitEntry$.MODULE$.apply$default$4())));
            chromosomeSplits$2.elem = ((Map)chromosomeSplits$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append((String)c._1()).append("b").toString()), (Object)new SplitEntry((String)c._1(), Predef$.MODULE$.Integer2int(chromosomeSplit), MODULE$.getUpperBounds((String)c._1(), Predef$.MODULE$.Integer2int((Integer)c._2()), buildSizes$2), SplitEntry$.MODULE$.apply$default$4())));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            chromosomeSplits$2.elem = ((Map)chromosomeSplits$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c._1()), (Object)new SplitEntry((String)c._1(), 0, MODULE$.getUpperBounds((String)c._1(), Predef$.MODULE$.Integer2int((Integer)c._2()), buildSizes$2), SplitEntry$.MODULE$.apply$default$4())));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$parseArbitrarySplit$1(IntRef splitSize$1, int splitOverlap$2, ObjectRef chromosomeSplits$3, java.util.Map buildSizes$3, Tuple2 c) {
        int beginBp = 0;
        int endBp = splitSize$1.elem;
        int no = 1;
        if (Predef$.MODULE$.Integer2int((Integer)c._2()) / splitSize$1.elem > 100) {
            throw new GorParsingException(new StringBuilder(137).append("Error in -split option - PGOR does now allow more than 100 splits per chromosome.\nCurrently using ").append(Predef$.MODULE$.Integer2int((Integer)c._2()) / splitSize$1.elem).append(" splits. Usage -split size[:overlap] : ").toString());
        }
        if (splitOverlap$2 > splitSize$1.elem / 2) {
            throw new GorParsingException(new StringBuilder(100).append("Error in -split - overlap is too large compared with the split size ").append(splitSize$1.elem).append(". Usage -split size[:overlap] : ").toString());
        }
        while (beginBp <= Predef$.MODULE$.Integer2int((Integer)c._2())) {
            chromosomeSplits$3.elem = ((Map)chromosomeSplits$3.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append((String)c._1()).append("_").append(no).toString()), (Object)new SplitEntry((String)c._1(), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), beginBp - splitOverlap$2), MODULE$.getUpperBounds((String)c._1(), endBp - 1 + splitOverlap$2, buildSizes$3), SplitEntry$.MODULE$.apply$default$4())));
            beginBp += splitSize$1.elem;
            endBp += splitSize$1.elem;
            ++no;
        }
    }

    private SplitManager$() {
        MODULE$ = this;
        this.REGULAR_REPLACEMENT_PATTERN = "##REGULAR_CHR_REPLACE##";
        this.SPLIT_REPLACEMENT_PATTERN = "##SPLIT_CHR_REPLACE##";
        this.WHERE_SPLIT_WINDOW = "##WHERE_SPLIT_WINDOW##";
        this.CHROM_PATTERN = "#{CHROM}";
        this.START_PATTERN = "#{BPSTART}";
        this.STOP_PATTERN = "#{BPSTOP}";
        this.RANGETAG_PATTERN = "#{RANGETAG}";
        this.MAXIMUM_NUMBER_OF_SPLITS = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("gor.validation.split.maxcount", "5000"))).toInt();
        this.MAX_CHROM_SIZE = 1000000000;
    }
}

