/*
 * Decompiled with CFR 0.152.
 */
package gorsat;

import gorsat.Commands.Analysis;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorSession;

public class IOTestAnalyser
extends Analysis {
    private final Map<String, Integer> headerIndexMap = new HashMap<String, Integer>();
    private final Random rnd = new Random();
    String header;
    private final boolean parallel;
    private final List<Row> rows;
    private final FileReader fileReader;
    private final String cacheDir;

    public IOTestAnalyser(String header, boolean parallel, GorSession session) {
        this.header = header;
        this.parallel = parallel;
        this.fileReader = session.getProjectContext().getFileReader();
        this.cacheDir = session.getProjectContext().getCacheDir();
        this.rows = new ArrayList<Row>();
    }

    public void setup() {
        String[] hsplit = this.header.split("\t");
        for (int i = 0; i < hsplit.length; ++i) {
            this.headerIndexMap.put(hsplit[i].toLowerCase(), i);
        }
    }

    public void finish() {
        ArrayList lt = new ArrayList();
        List res = Collections.synchronizedList(new ArrayList());
        this.rows.forEach(row -> {
            Thread t = new Thread(() -> res.add(this.testRow((Row)row)));
            lt.add(t);
            t.start();
        });
        lt.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        res.forEach(x$0 -> super.process(x$0));
    }

    private Row testRow(Row row) {
        int bytebuffersize = 1000000;
        byte[] bb = new byte[bytebuffersize];
        ByteBuffer bbb = ByteBuffer.wrap(bb);
        String filepath = row.colAsString(this.headerIndexMap.get("filepath").intValue()).toString();
        long streamsize = (long)row.colAsDouble(this.headerIndexMap.get("streamsize").intValue());
        int seeknum = this.headerIndexMap.containsKey("seeknum") ? row.colAsInt(this.headerIndexMap.get("seeknum").intValue()) : 1;
        String write = this.headerIndexMap.containsKey("write") ? row.colAsString(this.headerIndexMap.get("write").intValue()).toString() : null;
        try {
            long total;
            long t = System.nanoTime();
            if (write != null && (write.equals("1") || write.equals("true")) && !filepath.contains("..") && !filepath.startsWith("/")) {
                Path p = this.fileReader.toPath(this.cacheDir);
                p = p.resolve(filepath);
                try (OutputStream os = Files.newOutputStream(p, new OpenOption[0]);){
                    long wsize;
                    for (total = 0L; total < streamsize; total += wsize) {
                        wsize = Math.min((long)bb.length, streamsize - total);
                        os.write(bb, 0, (int)wsize);
                    }
                }
                Files.delete(p);
            } else {
                Path p = this.fileReader.toPath(filepath);
                if (seeknum > 0) {
                    long filesize = Files.size(p);
                    for (int i = 0; i < seeknum; ++i) {
                        long subtotal = 0L;
                        try (SeekableByteChannel sbc = Files.newByteChannel(p, new OpenOption[0]);){
                            sbc.position(Math.abs(this.rnd.nextLong()) % Math.max(1L, filesize - streamsize));
                            bbb.limit((int)Math.min((long)bb.length, streamsize));
                            int r = sbc.read(bbb);
                            while (r > 0 && (subtotal += (long)r) != streamsize) {
                                bbb.rewind();
                                bbb.limit((int)Math.min((long)bb.length, streamsize - subtotal));
                                r = sbc.read(bbb);
                            }
                            bbb.rewind();
                            if ((long)bb.length > streamsize - subtotal) {
                                bbb.limit((int)(streamsize - subtotal));
                            }
                            total += subtotal;
                            continue;
                        }
                    }
                } else {
                    try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                        int r = is.read(bb, 0, (int)Math.min((long)bb.length, streamsize));
                        while (r > 0) {
                            if ((total += (long)r) == streamsize) {
                            }
                            r = is.read(bb, 0, (int)Math.min((long)bb.length, streamsize - total));
                        }
                    }
                }
            }
            long et = System.nanoTime();
            return row.rowWithAddedColumn((CharSequence)(total + "\t" + (et - t)));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to access file " + filepath, e);
        }
    }

    public void process(Row row) {
        if (this.parallel) {
            this.rows.add(row);
        } else {
            super.process(this.testRow(row));
        }
    }

    public String getHeader() {
        return this.header + "\ttotalbytes\ttime";
    }
}

