/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Regression;

import gorsat.Regression.LinearAlgebra;
import gorsat.Regression.MultipleCovariateLogisticRegression;
import gorsat.Regression.RegressionUtilities;
import gorsat.Regression.SigmoidFunction;
import gorsat.Regression.SingleCovariateLogisticRegression;
import java.util.Arrays;

public abstract class LogisticRegression {
    protected final int numberOfDepVars;
    protected final int maximumNumberOfSamples;
    protected final int dim;
    public double[] beta;
    public double[] zStats;
    public double[] pValues;
    public int numberOfIterations;
    protected final double[] gradient;
    protected final double[][] hessian;
    protected final double[] delta;
    protected int numberOfSamples;
    protected final double[] oneOver;
    protected final double[] gradMult;
    protected final double[] prod;
    private double error;
    private boolean betaClean;
    protected final SigmoidFunction sf;

    protected LogisticRegression(int numberOfDepVars, int maximumNumberOfSamples) {
        this.numberOfDepVars = numberOfDepVars;
        this.maximumNumberOfSamples = maximumNumberOfSamples;
        this.dim = numberOfDepVars + 1;
        this.beta = new double[this.dim];
        this.zStats = new double[this.dim];
        this.pValues = new double[this.dim];
        this.gradient = new double[this.dim];
        this.hessian = RegressionUtilities.getTriangularMatrix(this.dim);
        this.delta = new double[this.dim];
        this.oneOver = new double[this.maximumNumberOfSamples];
        this.gradMult = new double[this.maximumNumberOfSamples];
        this.prod = new double[this.maximumNumberOfSamples];
        this.betaClean = true;
        this.sf = SigmoidFunction.getSigmoidFunction();
    }

    public static LogisticRegression getGorLogisticRegressionObject(int numberOfDepVars, int maximumNumberOfSamples) {
        assert (numberOfDepVars > 0);
        assert (maximumNumberOfSamples > 0);
        return numberOfDepVars == 1 ? new SingleCovariateLogisticRegression(maximumNumberOfSamples) : new MultipleCovariateLogisticRegression(numberOfDepVars, maximumNumberOfSamples);
    }

    public boolean runRegression(double[][] x, boolean[] y, int numberOfSamples, double tol, int maxIter) {
        boolean converged;
        this.numberOfSamples = numberOfSamples;
        if (!this.betaClean) {
            Arrays.fill(this.beta, 0.0);
        }
        try {
            this.updateGradientAndHessianFirstRun(x, y);
            this.updateBeta();
            converged = this.error < tol;
            this.numberOfIterations = 1;
            while (!converged && this.numberOfIterations < maxIter) {
                this.updateGradientAndHessian(x, y);
                this.updateBeta();
                converged = this.error < tol;
                ++this.numberOfIterations;
            }
            this.betaClean = false;
        }
        catch (IllegalArgumentException e) {
            this.betaClean = false;
            converged = false;
        }
        if (converged) {
            this.computeTestStats();
            RegressionUtilities.computePValues(this.zStats, this.pValues);
        }
        return converged;
    }

    private void updateBeta() {
        this.error = 0.0;
        LinearAlgebra.solveSymPosDef(this.hessian, this.delta, this.gradient);
        for (int i = 0; i < this.dim; ++i) {
            double tmpError = Math.abs(this.delta[i]);
            if (tmpError > this.error) {
                this.error = tmpError;
            }
            int n = i;
            this.beta[n] = this.beta[n] + this.delta[i];
        }
    }

    protected abstract void computeTestStats();

    protected abstract void updateGradientAndHessian(double[][] var1, boolean[] var2);

    protected abstract void updateGradientAndHessianFirstRun(double[][] var1, boolean[] var2);
}

