/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.function;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.model.RowBase;

public class GorRowInferFunction
implements BinaryOperator<Row>,
Serializable {
    static Map<String, Character> convMap = new HashMap<String, Character>();

    void checkNumericTypes(RowBase row, Row t1, int i) {
        String colval = row.stringValue(i);
        if (colval.equals("I")) {
            try {
                t1.intValue(i);
            }
            catch (Exception e) {
                colval = "D";
                ((StringBuilder)row.getAllCols()).setCharAt(i * 2, 'D');
            }
        }
        if (colval.equals("D")) {
            try {
                t1.doubleValue(i);
            }
            catch (Exception e) {
                ((StringBuilder)row.getAllCols()).setCharAt(i * 2, 'S');
            }
        }
    }

    void inferOther(RowBase row, Row t1) {
        for (int i = 0; i < row.numCols(); ++i) {
            if (t1.colAsString(i).length() > 16) {
                ((StringBuilder)row.getAllCols()).setCharAt(i * 2, 'S');
                continue;
            }
            this.checkNumericTypes(row, t1, i);
        }
    }

    Row inferBoth(Row row, Row t1) {
        int i;
        int[] sa = new int[row.numCols()];
        StringBuilder sb = new StringBuilder();
        sb.append("I");
        for (i = 1; i < row.numCols(); ++i) {
            sb.append("\tI");
            sa[i - 1] = i * 2 - 1;
        }
        sa[i - 1] = i * 2 - 1;
        RowBase newrow = new RowBase(null, -1, (CharSequence)sb, sa, null);
        this.inferOther(newrow, row);
        this.inferOther(newrow, t1);
        return newrow;
    }

    public Row infer(Row row, Row t1) {
        if (row.chr == null) {
            if (t1.chr == null) {
                for (int i = 0; i < row.numCols(); ++i) {
                    String duo = row.stringValue(i) + t1.stringValue(i);
                    if (!convMap.containsKey(duo)) continue;
                    ((StringBuilder)row.getAllCols()).setCharAt(i * 2, convMap.get(duo).charValue());
                }
            } else {
                this.inferOther((RowBase)row, t1);
            }
            return row;
        }
        if (t1.chr == null) {
            this.inferOther((RowBase)t1, row);
            return t1;
        }
        return this.inferBoth(row, t1);
    }

    @Override
    public Row apply(Row row, Row row2) {
        return this.infer(row, row2);
    }

    static {
        convMap.put("IS", Character.valueOf('S'));
        convMap.put("SI", Character.valueOf('S'));
        convMap.put("DS", Character.valueOf('S'));
        convMap.put("SD", Character.valueOf('S'));
        convMap.put("ID", Character.valueOf('D'));
        convMap.put("DI", Character.valueOf('D'));
    }
}

