/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.gava;

import org.gorpipe.gor.util.GLogGamma;

public class CombinationIterator {
    private final int n;
    private final int k;
    private boolean[] included;
    private int j;
    private int i;
    private int[] perm;

    public CombinationIterator(int totalCount, int subCount) {
        this.n = totalCount;
        this.k = subCount;
        this.i = this.j = this.n - 1;
    }

    public int[] getPermutation() {
        return this.perm;
    }

    public boolean next() {
        if (this.included == null) {
            if (this.n <= 0 || this.k < 0 || this.k > this.n) {
                return false;
            }
            this.included = new boolean[this.n];
            this.perm = new int[this.n];
            for (int t = 0; t < this.n; ++t) {
                this.included[t] = t < this.k;
                this.perm[t] = t;
            }
        } else {
            if (this.i < 0 || this.j < 0) {
                return false;
            }
            if (this.i < this.j - 1) {
                this.included[this.i] = false;
                this.included[++this.i] = true;
                while (this.j < this.n - 1) {
                    this.included[++this.j] = false;
                    this.included[++this.i] = true;
                }
            } else {
                this.included[this.i] = false;
                this.included[this.i + 1] = true;
            }
        }
        while (this.j >= 0 && this.included[this.j]) {
            --this.j;
        }
        while (this.i >= 0 && !this.included[this.i]) {
            --this.i;
        }
        int r = 0;
        int s = this.k;
        for (int t = 0; t < this.included.length; ++t) {
            if (this.included[t]) {
                this.perm[r++] = t;
                continue;
            }
            this.perm[s++] = t;
        }
        return true;
    }

    public static double getNumberOfCombinations(int n, int k) {
        return Math.exp(GLogGamma.get(n) - GLogGamma.get(k) - GLogGamma.get(n - k));
    }
}

