/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.argument;

import java.net.URI;
import java.text.ParseException;
import java.util.List;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.RangedNumberFormatter;

public class NumberArgument
extends Argument {
    public static final String PROPERTY_NUMBER_VALUE = "numberValue";
    private RangedNumberFormatter formatter;
    private int valueTextFieldMinWidth;
    private int minTextFieldMinWidth;
    private int maxTextFieldMinWidth;

    public NumberArgument(ArgumentDescription argDescr, Boolean optional, Object defaultValue, List<? extends Object> allowedValues, URI valuesPath, List<String> operators, Boolean advanced, Integer displayWidth, Number min, Number max, ArgumentType argType) {
        super(argType, argDescr, optional, defaultValue, allowedValues, valuesPath, operators, advanced, displayWidth);
        Double dmin = null;
        Double dmax = null;
        if (min != null) {
            dmin = min.doubleValue();
        }
        if (max != null) {
            dmax = max.doubleValue();
        }
        this.setMin(dmin);
        this.setMax(dmax);
    }

    public NumberArgument(NumberArgument numbArg) {
        super(numbArg);
        this.formatter = numbArg.formatter;
        this.valueTextFieldMinWidth = numbArg.valueTextFieldMinWidth;
        this.minTextFieldMinWidth = numbArg.minTextFieldMinWidth;
        this.maxTextFieldMinWidth = numbArg.maxTextFieldMinWidth;
    }

    private RangedNumberFormatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new RangedNumberFormatter(this.getMin(), this.getMax());
        }
        return this.formatter;
    }

    public Double getMin() {
        if (this.formatter == null) {
            return null;
        }
        return (Double)this.getFormatter().getMinimum();
    }

    public void setMin(Double min) {
        this.getFormatter().setMinimum(min);
        if (this.getNumberValue() != null && min != null && min.compareTo(this.getNumberValue().doubleValue()) > 0) {
            this.setNumberValue(min);
        }
    }

    public Double getMax() {
        if (this.formatter == null) {
            return null;
        }
        return (Double)this.getFormatter().getMaximum();
    }

    public void setMax(Double max) {
        this.getFormatter().setMaximum(max);
        if (this.getNumberValue() != null && max != null && max.compareTo(this.getNumberValue().doubleValue()) < 0) {
            this.setNumberValue(max);
        }
    }

    @Override
    public void setValue(Object value) {
        if (value != null && !(value instanceof Number)) {
            try {
                value = this.getFormatter().stringToValue(value.toString());
            }
            catch (ParseException e) {
                value = null;
            }
        }
        this.setNumberValue((Number)value);
    }

    public Number getNumberValue() {
        if (this.getValue() == null) {
            return null;
        }
        try {
            return (Number)this.getFormatter().stringToValue((String)this.getValue());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setNumberValue(Number value) {
        try {
            super.setValue(this.getFormatter().valueToString(value));
        }
        catch (ParseException e) {
            super.setValue(null);
        }
    }

    @Override
    protected Object parseValue(String val) {
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            return Double.valueOf(val);
        }
    }

    public int getValueTextFieldMinWidth() {
        return this.valueTextFieldMinWidth;
    }

    public void setValueTextFieldMinWidth(int valueTextFieldMinWidth) {
        this.valueTextFieldMinWidth = valueTextFieldMinWidth;
    }

    public int getMinTextFieldMinWidth() {
        return this.minTextFieldMinWidth;
    }

    public void setMinTextFieldMinWidth(int minTextFieldMinWidth) {
        this.minTextFieldMinWidth = minTextFieldMinWidth;
    }

    public int getMaxTextFieldMinWidth() {
        return this.maxTextFieldMinWidth;
    }

    public void setMaxTextFieldMinWidth(int maxTextFieldMinWidth) {
        this.maxTextFieldMinWidth = maxTextFieldMinWidth;
    }

    @Override
    public NumberArgument copyArgument() {
        return new NumberArgument(this);
    }
}

