/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory;

import java.util.HashMap;
import java.util.Map;

public class ArgumentContent {
    private static final String STORE_FORMAT_LIST = "list";
    private static final String STORE_FORMAT_KEYWORDS = "keyw";
    public final String value;
    public final Format format;

    public ArgumentContent(String value) {
        this(value, null);
    }

    private ArgumentContent(String value, Format format) {
        this.value = value;
        this.format = format;
    }

    public static ArgumentContent parseContent(String content) {
        String tmpValue = content;
        Format format = null;
        if (content.startsWith(STORE_FORMAT_LIST)) {
            format = Format.LIST;
            tmpValue = format.extractValue(tmpValue);
        } else if (content.startsWith(STORE_FORMAT_KEYWORDS)) {
            format = Format.KEYWORDS;
            tmpValue = format.extractValue(tmpValue);
        }
        return new ArgumentContent(tmpValue, format);
    }

    public static enum Format {
        LIST("values", "list"),
        KEYWORDS("keywords", "keyw");

        private static final Map<String, Format> valueFormat2Format;
        public final String valueFormat;
        public final String storeFormat;

        private Format(String valueFormat, String storeFormat) {
            this.valueFormat = valueFormat;
            this.storeFormat = storeFormat;
        }

        public static Format getFormatByValueFormat(String valueFormat) {
            return valueFormat2Format.get(valueFormat);
        }

        public String extractValue(String content) {
            return content.replace(this.storeFormat + "(", "").replace(")", "");
        }

        public String formatForStore(String valueString) {
            return this.storeFormat + "(" + valueString + ")";
        }

        static {
            valueFormat2Format = new HashMap<String, Format>();
            for (Format format : Format.values()) {
                valueFormat2Format.put(format.valueFormat, format);
            }
        }
    }
}

