/*
 * Decompiled with CFR 0.152.
 */
package gorsat;

import java.time.Duration;
import org.aeonbits.owner.Config;
import org.gorpipe.base.config.annotations.Documentation;
import org.gorpipe.base.config.converters.DurationConverter;

public interface BatchedReadSourceConfig
extends Config {
    public static final String BATCHEDREADSOURCETIMETRIGGERMS_KEY = "gor.bufferflush.timetrigger";
    public static final String BATCHOFFERTIMEOUTMS_KEY = "gor.batch.offer.timeout";
    public static final String BATCHLOGINTERVALMS_KEY = "gor.batch.log.interval";
    public static final String BATCHMAXGORLINES_KEY = "gor.batch.max.gorlines";
    public static final String BATCHBUFFERFILLTIME_KEY = "gor.bufferfill.time";
    public static final String FRAMEBUFFERSIZE_KEY = "gor.cmd.framebuffer.size";
    public static final String CONNECTIONRETRIES_KEY = "gor.cmd.connection.retries";
    public static final String CONNECTIONRETRYTIME_KEY = "gor.cmd.connection.retry.time";
    public static final String CONNECTIONRETRYEXPONENT_KEY = "gor.cmd.connection.retry.exponent";

    @Config.Key(value="gor.cmd.connection.retries")
    @Config.DefaultValue(value="10")
    @Documentation(value="Maximum number of connection retries")
    public Integer getConnectionRetries();

    @Config.Key(value="gor.cmd.connection.retry.exponent")
    @Config.DefaultValue(value="0.0")
    @Documentation(value="Maximum number of connection retries")
    public Double getConnectionRetryExponent();

    @Config.Key(value="gor.cmd.connection.retry.time")
    @Config.DefaultValue(value="1s")
    @Config.ConverterClass(value=DurationConverter.class)
    @Documentation(value="Connection retry wait time")
    public Duration getConnectionRetryTime();

    @Config.Key(value="gor.cmd.framebuffer.size")
    @Config.DefaultValue(value="4000000")
    @Documentation(value="Limit the size of gorline batch to fit in GRPC/HTTP2 framebuffer")
    public Integer getFrameBufferSize();

    @Config.Key(value="gor.batch.max.gorlines")
    @Config.DefaultValue(value="16384")
    @Documentation(value="Maximum number of gorlines in batch")
    public Integer getMaxGorlines();

    @Config.Key(value="gor.bufferfill.time")
    @Config.DefaultValue(value="1000ms")
    @Config.ConverterClass(value=DurationConverter.class)
    @Documentation(value="Max milliseconds until read buffer is flushed")
    public Duration getBufferFillTime();

    @Config.Key(value="gor.bufferflush.timetrigger")
    @Config.DefaultValue(value="100ms")
    @Config.ConverterClass(value=DurationConverter.class)
    @Documentation(value="Minimum milliseconds until read buffer is flushed")
    public Duration getBufferFlushTimout();

    @Config.Key(value="gor.batch.offer.timeout")
    @Config.DefaultValue(value="100ms")
    @Config.ConverterClass(value=DurationConverter.class)
    @Documentation(value="Minimum milliseconds until batch offer times out")
    public Duration getBatchOfferTimeout();

    @Config.Key(value="gor.batch.log.interval")
    @Config.DefaultValue(value="3 seconds")
    @Config.ConverterClass(value=DurationConverter.class)
    @Documentation(value="Log interval while waiting for a batch")
    public Duration getLogInterval();
}

