/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Regression;

import gorsat.Regression.LinearAlgebra;
import gorsat.Regression.RegressionUtilities;
import java.util.Arrays;

public class LinearRegression {
    private final int n;
    private int numberOfSamples;
    private final double[] rDiag;
    private final double[][] X;
    private final double[][] Rinv;
    public final double[] beta;
    public final double[] betaError;
    public final double[] tStats;
    public final double[] pValues;

    public LinearRegression(int maxNumberOfSamples, int numberOfCovariates) {
        this.validateDimensions(maxNumberOfSamples, numberOfCovariates);
        this.n = numberOfCovariates + 1;
        this.beta = new double[this.n];
        this.rDiag = new double[this.n];
        this.X = new double[this.n][];
        this.X[0] = new double[maxNumberOfSamples];
        this.Rinv = RegressionUtilities.getTriangularMatrix(this.n);
        this.betaError = new double[this.n];
        this.tStats = new double[this.n];
        this.pValues = new double[this.n];
    }

    public void setData(double[][] X, int numberOfSamples) {
        this.validateDimensions(numberOfSamples, this.n - 1);
        this.numberOfSamples = numberOfSamples;
        System.arraycopy(X, 0, this.X, 1, X.length);
        Arrays.fill(this.X[0], 1.0);
        LinearAlgebra.QRFactorize(this.X, this.rDiag, numberOfSamples);
    }

    private void validateDimensions(int numberOfSamples, int numberOfCovariates) {
        if (numberOfSamples <= numberOfCovariates) {
            throw new IllegalArgumentException("Number of samples must be greater than the number of covariates.");
        }
    }

    public void runRegression(double[] y) {
        double[] X_j;
        for (int j = 0; j < this.n; ++j) {
            X_j = this.X[j];
            double scale = LinearAlgebra.dotProd(y, X_j, j, this.numberOfSamples) / (this.rDiag[j] * X_j[j]);
            LinearAlgebra.addMultipleOf(y, scale, X_j, j, this.numberOfSamples);
        }
        double error2 = LinearAlgebra.dotProd(y, y, this.n, this.numberOfSamples);
        System.arraycopy(y, 0, this.beta, 0, this.n);
        for (int j = this.n - 1; j != -1; --j) {
            double beta_j;
            this.beta[j] = beta_j = this.beta[j] / this.rDiag[j];
            X_j = this.X[j];
            for (int i = j - 1; i != -1; --i) {
                int n = i;
                this.beta[n] = this.beta[n] - X_j[i] * beta_j;
            }
        }
        this.computeTestStats(error2);
    }

    private void computeTestStats(double error2) {
        this.setRInv();
        this.computeBetaVariance();
        this.computeBetaError(error2);
        this.computeZStats();
        RegressionUtilities.computePValues(this.tStats, this.pValues);
    }

    private void computeZStats() {
        for (int i = 0; i < this.n; ++i) {
            this.tStats[i] = this.beta[i] / this.betaError[i];
        }
    }

    private void setRInv() {
        this.writeR(this.Rinv);
        LinearAlgebra.invertUpperTriangular(this.Rinv, this.Rinv, this.n);
    }

    private void computeBetaError(double error2) {
        double errorVar = error2 / (double)(this.numberOfSamples - this.n);
        for (int i = 0; i < this.n; ++i) {
            this.betaError[i] = Math.sqrt(errorVar * this.betaError[i]);
        }
    }

    private void computeBetaVariance() {
        for (int j = 0; j < this.n; ++j) {
            double[] Rinv_j = this.Rinv[j];
            for (int i = 0; i < j; ++i) {
                int n = i;
                this.betaError[n] = this.betaError[n] + Rinv_j[i] * Rinv_j[i];
            }
            this.betaError[j] = Rinv_j[j] * Rinv_j[j];
        }
    }

    private void writeR(double[][] R) {
        R[0][0] = this.rDiag[0];
        for (int i = 1; i < this.n; ++i) {
            double[] R_i = R[i];
            System.arraycopy(this.X[i], 0, R_i, 0, i);
            R_i[i] = this.rDiag[i];
        }
    }
}

