/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parser;

import gorsat.parser.CalcLambdaBoolean;
import gorsat.parser.CalcLambdaDouble;
import gorsat.parser.CalcLambdaInteger;
import gorsat.parser.CalcLambdaLong;
import gorsat.parser.CalcLambdaStringConstant;
import gorsat.parser.CalcLambdaVariable;
import gorsat.parser.CvpStringLambda;
import gorsat.parser.FunctionTypes;
import gorsat.parser.StringType;
import gorsat.parser.TypedCalcLambda;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.model.ColumnValueProvider;

public class CalcLambdaString
implements StringType,
TypedCalcLambda {
    private CvpStringLambda lambda;

    public CalcLambdaString(CvpStringLambda lambda) {
        this.lambda = lambda;
    }

    @Override
    public String getType() {
        return FunctionTypes.StringFun();
    }

    @Override
    public int evaluateInt(ColumnValueProvider columnValueProvider) {
        throw new GorParsingException("Can't cast string to integer");
    }

    @Override
    public long evaluateLong(ColumnValueProvider cvp) {
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public String evaluateString(ColumnValueProvider cvp) {
        return this.lambda.evaluate(cvp);
    }

    @Override
    public double evaluateDouble(ColumnValueProvider cvp) {
        throw new GorParsingException("Can't cast string to number");
    }

    @Override
    public boolean evaluateBoolean(ColumnValueProvider cvp) {
        throw new GorParsingException("Can't cast string to boolean");
    }

    @Override
    public TypedCalcLambda addedTo(TypedCalcLambda left) {
        return left.add(this);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaVariable other) {
        return other.toLambda().addedTo(this);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaString other) {
        CvpStringLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other.evaluateString(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda add(String other) {
        CvpStringLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other;
        return this;
    }

    @Override
    public TypedCalcLambda add(CalcLambdaInteger other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(int other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(CalcLambdaLong other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(long other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(CalcLambdaDouble other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(double other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda subtractedFrom(TypedCalcLambda other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda subtract(int other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda subtract(long other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda subtract(double other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaInteger other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaLong other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaDouble other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multipliedWith(TypedCalcLambda left) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(int other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(long other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(double other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaInteger other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaLong other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaDouble other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda dividedInto(TypedCalcLambda left) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(int other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(long other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(double other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaInteger other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaLong other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaDouble other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    public TypedCalcLambda add(TypedCalcLambda o) {
        TypedCalcLambda other = o.toLambda();
        CvpStringLambda prev = this.lambda;
        if (other instanceof CalcLambdaStringConstant) {
            String c = other.evaluateString(null);
            this.lambda = cvp -> prev.evaluate(cvp) + c;
            return this;
        }
        if (other instanceof CalcLambdaString) {
            this.lambda = cvp -> prev.evaluate(cvp) + other.evaluateString(cvp);
            return this;
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda pow(TypedCalcLambda other) {
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda negate() {
        throw new GorParsingException("Negation not applicable for string");
    }

    @Override
    public TypedCalcLambda compare(TypedCalcLambda o, int op) {
        TypedCalcLambda other = o.toLambda();
        if (!(other instanceof StringType)) {
            throw TypedCalcLambda.getIncompatibleTypes();
        }
        switch (op) {
            case 21: 
            case 22: {
                return new CalcLambdaBoolean(cvp -> this.evaluateString(cvp).equals(other.evaluateString(cvp)));
            }
            case 23: {
                return new CalcLambdaBoolean(cvp -> !this.evaluateString(cvp).equals(other.evaluateString(cvp)));
            }
            case 24: {
                return new CalcLambdaBoolean(cvp -> this.evaluateString(cvp).compareTo(other.evaluateString(cvp)) > 0);
            }
            case 25: {
                return new CalcLambdaBoolean(cvp -> this.evaluateString(cvp).compareTo(other.evaluateString(cvp)) >= 0);
            }
            case 26: {
                return new CalcLambdaBoolean(cvp -> this.evaluateString(cvp).compareTo(other.evaluateString(cvp)) < 0);
            }
            case 27: {
                return new CalcLambdaBoolean(cvp -> this.evaluateString(cvp).compareTo(other.evaluateString(cvp)) <= 0);
            }
            case 28: {
                if (other instanceof CalcLambdaStringConstant) {
                    String pattern = other.evaluateString(null).replace("*", ".*").replace("?", ".");
                    return new CalcLambdaBoolean(cvp -> this.evaluateString(cvp).matches(pattern));
                }
                return new CalcLambdaBoolean(cvp -> {
                    String pattern = other.evaluateString(cvp).replace("*", ".*").replace("?", ".");
                    return this.evaluateString(cvp).matches(pattern);
                });
            }
            case 29: {
                if (other instanceof CalcLambdaStringConstant) {
                    String pattern = other.evaluateString(null);
                    return new CalcLambdaBoolean(cvp -> this.evaluateString(cvp).matches(pattern));
                }
                return new CalcLambdaBoolean(cvp -> {
                    String pattern = other.evaluateString(cvp);
                    return this.evaluateString(cvp).matches(pattern);
                });
            }
        }
        throw new GorParsingException("Operator not supported for string");
    }
}

