/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parser;

import gorsat.parser.CalcLambdaDouble;
import gorsat.parser.CalcLambdaInteger;
import gorsat.parser.CalcLambdaLong;
import gorsat.parser.CalcLambdaString;
import gorsat.parser.StringType;
import gorsat.parser.TypedCalcLambda;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.ColumnValueProvider;

public class CalcLambdaVariable
implements TypedCalcLambda {
    private final int columnIndex;
    private final String columnType;

    public CalcLambdaVariable(int columnIndex, String columnType) {
        this.columnIndex = columnIndex;
        this.columnType = columnType;
    }

    @Override
    public TypedCalcLambda toLambda() {
        TypedCalcLambda result;
        switch (this.columnType) {
            case "S": {
                result = new CalcLambdaString(cvp -> cvp.stringValue(this.columnIndex));
                break;
            }
            case "D": {
                result = new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex));
                break;
            }
            case "L": {
                result = new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex));
                break;
            }
            case "I": {
                result = new CalcLambdaInteger(cvp -> cvp.intValue(this.columnIndex));
                break;
            }
            default: {
                throw new GorSystemException("Unknown type", null);
            }
        }
        return result;
    }

    @Override
    public String getType() {
        return this.columnType;
    }

    @Override
    public int evaluateInt(ColumnValueProvider cvp) {
        return cvp.intValue(this.columnIndex);
    }

    @Override
    public long evaluateLong(ColumnValueProvider cvp) {
        return cvp.longValue(this.columnIndex);
    }

    @Override
    public double evaluateDouble(ColumnValueProvider cvp) {
        return cvp.doubleValue(this.columnIndex);
    }

    @Override
    public String evaluateString(ColumnValueProvider cvp) {
        return cvp.stringValue(this.columnIndex);
    }

    @Override
    public boolean evaluateBoolean(ColumnValueProvider cvp) {
        return false;
    }

    @Override
    public TypedCalcLambda addedTo(TypedCalcLambda left) {
        return left.add(this);
    }

    @Override
    public TypedCalcLambda add(String other) {
        return new CalcLambdaString(cvp -> cvp.stringValue(this.columnIndex) + other);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaInteger other) {
        return this.toLambda().add(other);
    }

    @Override
    public TypedCalcLambda add(int other) {
        if (this.columnType.equals("I")) {
            return new CalcLambdaInteger(cvp -> cvp.intValue(this.columnIndex) + other);
        }
        if (this.columnType.equals("L")) {
            return new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex) + (long)other);
        }
        if (this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) + (double)other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda add(CalcLambdaLong other) {
        return this.toLambda().add(other);
    }

    @Override
    public TypedCalcLambda add(long other) {
        if (this.columnType.equals("I") || this.columnType.equals("L")) {
            return new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex) + other);
        }
        if (this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) + (double)other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda add(CalcLambdaDouble other) {
        return this.toLambda().add(other);
    }

    @Override
    public TypedCalcLambda add(double other) {
        if (this.columnType.equals("I") || this.columnType.equals("L") || this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) + other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda add(CalcLambdaVariable other) {
        if (this.columnType.equals("S") || other.getType().equals("S")) {
            return new CalcLambdaString(cvp -> cvp.stringValue(this.columnIndex) + other.evaluateString(cvp));
        }
        return this.toLambda().add(other);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaString other) {
        return this.toLambda().add(other);
    }

    @Override
    public TypedCalcLambda subtractedFrom(TypedCalcLambda left) {
        return left.subtract(this);
    }

    @Override
    public TypedCalcLambda subtract(int other) {
        if (this.columnType.equals("I")) {
            return new CalcLambdaInteger(cvp -> cvp.intValue(this.columnIndex) - other);
        }
        if (this.columnType.equals("L")) {
            return new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex) - (long)other);
        }
        if (this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) - (double)other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda subtract(long other) {
        if (this.columnType.equals("I") || this.columnType.equals("L")) {
            return new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex) - other);
        }
        if (this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) - (double)other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda subtract(double other) {
        if (this.columnType.equals("I") || this.columnType.equals("L") || this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) - other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaLong other) {
        return this.toLambda().subtract(other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaDouble other) {
        return this.toLambda().subtract(other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaVariable other) {
        return this.toLambda().subtract(other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaInteger other) {
        return this.toLambda().subtract(other);
    }

    @Override
    public TypedCalcLambda multipliedWith(TypedCalcLambda left) {
        return this.toLambda().multipliedWith(left);
    }

    @Override
    public TypedCalcLambda multiply(int other) {
        if (this.columnType.equals("I")) {
            return new CalcLambdaInteger(cvp -> cvp.intValue(this.columnIndex) * other);
        }
        if (this.columnType.equals("L")) {
            return new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex) * (long)other);
        }
        if (this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) * (double)other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda multiply(long other) {
        if (this.columnType.equals("I") || this.columnType.equals("L")) {
            return new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex) * other);
        }
        if (this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) * (double)other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda multiply(double other) {
        if (this.columnType.equals("I") || this.columnType.equals("L") || this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) * other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaVariable other) {
        return this.toLambda().multiply(other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaInteger other) {
        return this.toLambda().multiply(other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaLong other) {
        return this.toLambda().multiply(other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaDouble other) {
        return this.toLambda().multiply(other);
    }

    @Override
    public TypedCalcLambda dividedInto(TypedCalcLambda left) {
        return this.toLambda().dividedInto(left);
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaVariable other) {
        return other.toLambda().dividedInto(this);
    }

    @Override
    public TypedCalcLambda divide(int other) {
        if (this.columnType.equals("I")) {
            return new CalcLambdaInteger(cvp -> cvp.intValue(this.columnIndex) / other);
        }
        if (this.columnType.equals("L")) {
            return new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex) / (long)other);
        }
        if (this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) / (double)other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda divide(long other) {
        if (this.columnType.equals("I") || this.columnType.equals("L")) {
            return new CalcLambdaLong(cvp -> cvp.longValue(this.columnIndex) / other);
        }
        if (this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) / (double)other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda divide(double other) {
        if (this.columnType.equals("I") || this.columnType.equals("L") || this.columnType.equals("D")) {
            return new CalcLambdaDouble(cvp -> cvp.doubleValue(this.columnIndex) / other);
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaInteger other) {
        return this.toLambda().divide(other);
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaLong other) {
        return this.toLambda().divide(other);
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaDouble other) {
        return this.toLambda().divide(other);
    }

    @Override
    public TypedCalcLambda pow(TypedCalcLambda other) {
        return this.toLambda().pow(other);
    }

    @Override
    public TypedCalcLambda negate() {
        return this.toLambda().negate();
    }

    @Override
    public TypedCalcLambda compare(TypedCalcLambda other, int op) {
        if (other instanceof StringType) {
            return new CalcLambdaString(cvp -> cvp.stringValue(this.columnIndex)).compare(other, op);
        }
        return this.toLambda().compare(other, op);
    }
}

