/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Iterators.SingleIteratorSource;
import gorsat.process.BaseStreamIterator;
import gorsat.process.GorStreamIterator;
import gorsat.process.NorStreamIterator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.driver.providers.db.DbScope;
import org.gorpipe.gor.model.DbSource;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.table.TableHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorJavaUtilities {
    private static final Logger log = LoggerFactory.getLogger(GorJavaUtilities.class);
    public static final String GORZ_META = ".gorz.meta";
    public static DecimalFormat fd3 = new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ROOT));
    public static double[] pArray = IntStream.range(0, 128).mapToDouble(qual -> 1.0 - (double)(qual - 33) / 93.0).toArray();
    public static String[] prArray = (String[])Arrays.stream(pArray).mapToObj(p -> fd3.format(p)).toArray(String[]::new);
    public static PRPRValue prprFunction = new PRPRValue();
    public static PRPRPRValue prprprFunction = new PRPRPRValue();

    public static PhenoInfo getPhenotype(String phenoHeader, BufferedReader pheno) {
        String[] common;
        Optional<String[]> ocommon = pheno.lines().skip(1L).map(s -> s.split("\t")).map(s -> Arrays.copyOfRange(s, 1, ((String[])s).length)).reduce((r1, r2) -> {
            for (int i = 0; i < ((String[])r1).length; ++i) {
                try {
                    if (!r1[i].equalsIgnoreCase("NA")) {
                        Integer.parseInt(r1[i]);
                    }
                    r1[i] = r2[i];
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return r1;
        });
        Phenotypes phenotypes = Phenotypes.BINARY;
        if (ocommon.isPresent() && (common = ocommon.get()).length > 0) {
            Phenotypes pt = null;
            for (String s2 : common) {
                try {
                    Integer.parseInt(s2);
                    if (pt == null) {
                        pt = Phenotypes.BINARY;
                        continue;
                    }
                    if (!pt.equals((Object)Phenotypes.QUANTITATIVE)) continue;
                    pt = Phenotypes.MIXED;
                }
                catch (NumberFormatException e) {
                    if (pt == null) {
                        pt = Phenotypes.QUANTITATIVE;
                        continue;
                    }
                    if (!pt.equals((Object)Phenotypes.BINARY)) continue;
                    pt = Phenotypes.MIXED;
                }
            }
            phenotypes = pt;
        }
        String[] phenoSplit = phenoHeader.split("\t");
        String[] phenoNames = Arrays.copyOfRange(phenoSplit, 1, phenoSplit.length);
        return new PhenoInfo(phenotypes, phenoNames);
    }

    public static String clearHints(String query) {
        int i = query.indexOf("/*+");
        if (i != -1) {
            return query.substring(0, i) + query.substring(query.indexOf("*/", i + 3) + 2, query.length());
        }
        return query;
    }

    public static String[] splitResourceHints(String query, String validStart) {
        int i = ((String)query).indexOf("/*+");
        String[] ret = new String[]{query, null};
        if (i != -1) {
            int e = ((String)query).indexOf("*/", i + 3);
            String hints = ((String)query).substring(i + 3, e).trim();
            ArrayList resourceHints = new ArrayList();
            ArrayList sqlHints = new ArrayList();
            String[] hintSplit = hints.split("[ ]+");
            Arrays.asList(hintSplit).forEach(hint -> {
                if (hint.startsWith(validStart)) {
                    resourceHints.add(hint);
                } else {
                    sqlHints.add(hint);
                }
            });
            if (resourceHints.size() > 0) {
                ret[1] = String.join((CharSequence)" ", resourceHints);
            }
            query = sqlHints.size() == 0 ? ((String)query).substring(0, i) + ((String)query).substring(e + 2) : ((String)query).substring(0, i + 3) + String.join((CharSequence)" ", sqlHints) + ((String)query).substring(e);
            ret[0] = query;
        }
        return ret;
    }

    public static String createMapString(Map<String, String> createMap) {
        return createMap.entrySet().stream().map(e -> "create " + (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining("; ", "", ""));
    }

    public static List<Row> stream2RowList(Stream<Row> str) {
        return str.collect(Collectors.toList());
    }

    public static String seekReplacement(String myCommand, String chr, int start, int stop) {
        int sPos = ((String)myCommand).indexOf("#(S:");
        if (sPos != -1) {
            int sEnd = ((String)myCommand).indexOf(41, sPos + 1);
            Object seek = "";
            if (chr != null) {
                seek = ((String)myCommand).substring(sPos + 4, sEnd).replace("chr", chr);
                int pos = ((String)seek).indexOf("pos-end");
                if (pos != -1) {
                    seek = ((String)seek).replace("pos", "" + (start + 1)).replace("end", "" + stop);
                } else if (((String)seek).contains("pos")) {
                    pos = ((String)seek).indexOf("pos-");
                    seek = stop == -1 ? ((String)seek).replace("pos", "" + start) : (start == stop && pos != -1 ? ((String)seek).replace("pos-", "" + start) : ((String)seek).replace("pos", start + "-") + stop);
                }
            }
            myCommand = ((String)myCommand).substring(0, sPos) + (String)seek + ((String)myCommand).substring(sEnd + 1);
        }
        return myCommand;
    }

    public static String projectReplacement(String myCommand, GorSession session) throws IOException {
        String projectRoot = session.getProjectContext().getRealProjectRoot();
        String requestId = session.getRequestId();
        String securityContext = session.getProjectContext().getFileReader().getSecurityContext();
        return GorJavaUtilities.projectReplacement(myCommand, projectRoot, requestId, securityContext);
    }

    public static String projectReplacement(String myCommand, String projectRoot, String requestId, String securityContext) throws IOException {
        myCommand = GorJavaUtilities.projectDataReplacement(projectRoot, myCommand);
        myCommand = GorJavaUtilities.requestIdReplacement(requestId, myCommand);
        myCommand = GorJavaUtilities.projectIdReplacement(securityContext, myCommand);
        return myCommand;
    }

    public static String projectDataReplacement(String projectRoot, String myCommand) throws IOException {
        Path rootPath;
        if (projectRoot != null && projectRoot.length() > 0 && Files.exists(rootPath = Paths.get(projectRoot, new String[0]), new LinkOption[0])) {
            Path dataPath;
            Path rootRealPath = rootPath.toRealPath(new LinkOption[0]);
            myCommand = myCommand.replace("#{projectroot}", rootRealPath.toString());
            Path cachePath = rootRealPath.resolve("cache/result_cache");
            if (Files.exists(cachePath, new LinkOption[0])) {
                Path cacheRealPath = cachePath.toRealPath(new LinkOption[0]).getParent();
                myCommand = myCommand.replace("#{projectcache}", cacheRealPath.toString());
            }
            if (Files.exists(dataPath = rootRealPath.resolve("source"), new LinkOption[0])) {
                Path dataRealPath = dataPath.toRealPath(new LinkOption[0]).getParent();
                myCommand = myCommand.replace("#{projectdata}", dataRealPath.toString());
            }
        }
        return myCommand;
    }

    private static String requestIdReplacement(String requestId, String myCommand) {
        if (requestId != null) {
            myCommand = myCommand.replace("#{requestid}", requestId);
        }
        return myCommand;
    }

    static String projectIdReplacement(String securityContext, String myCommand) {
        if (securityContext != null) {
            List dbScopes = DbScope.parse((String)securityContext);
            Integer projectIdValue = null;
            for (DbScope dbScope : dbScopes) {
                if (!dbScope.getColumn().equals("project_id")) continue;
                projectIdValue = (Integer)dbScope.getValue();
            }
            if (projectIdValue != null) {
                myCommand = myCommand.replace("#{projectid}", projectIdValue.toString());
            }
        }
        return myCommand;
    }

    public static Optional<String> readRangeFromMeta(Path metaPath, String prefix) throws IOException {
        return Files.lines(metaPath).filter(l -> l.startsWith("## RANGE")).map(s -> s.substring(9).trim()).filter(f -> !f.isEmpty()).map(s -> prefix + s + "\t").findFirst();
    }

    public static GenomicIterator getDbIteratorSource(String sqlQuery, boolean gortable, String source, boolean scoping) {
        Supplier<Stream<String>> streamSupplier = () -> DbSource.getDBLinkStream((String)("//db:" + sqlQuery), (Object[])new Object[0], (String)source);
        BaseStreamIterator its = gortable ? new GorStreamIterator(streamSupplier, scoping) : new NorStreamIterator(streamSupplier);
        return new SingleIteratorSource(its, "dbit");
    }

    public static Stream<String> wrapObjectArrayIterator(final Iterator<Object[]> iterator) {
        Iterator<String> theIterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                Object[] data = (Object[])iterator.next();
                return Arrays.stream(data).map(x$0 -> GorJavaUtilities.nullSafeToString(x$0)).collect(Collectors.joining("\t"));
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(theIterator, 1024), false);
    }

    private static String nullSafeToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static Map<String, CmdParams> readWhiteList(Path cmdConfigPath) {
        HashMap<String, CmdParams> allowedCmds = new HashMap<String, CmdParams>();
        try {
            if (cmdConfigPath != null && Files.exists(cmdConfigPath, new LinkOption[0])) {
                List<String> lines = Files.readAllLines(cmdConfigPath);
                for (String line : lines) {
                    String[] split = line.split("\t");
                    if (split.length == 1) {
                        String[] stringArray;
                        int i = line.indexOf(91);
                        if (i > 0) {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = line.substring(0, i).trim();
                            stringArray = stringArray2;
                            stringArray2[1] = line.substring(i);
                        } else {
                            stringArray = split = null;
                        }
                    }
                    if (split == null) continue;
                    String cmd = split[1].substring(1, split[1].length() - 1);
                    CmdParams cmdParams = new CmdParams(split[0].split("[ ]+"), cmd);
                    allowedCmds.put(cmdParams.getAliasName(), cmdParams);
                }
            }
        }
        catch (IOException ioe) {
            throw new GorSystemException("Failed to load white listed commands.", (Throwable)ioe);
        }
        return allowedCmds;
    }

    public static Map<String, CmdParams> readWhiteList(String cmdConfigFile) throws IOException {
        if (cmdConfigFile != null) {
            Path p = Paths.get(cmdConfigFile, new String[0]);
            return GorJavaUtilities.readWhiteList(p);
        }
        return new HashMap<String, CmdParams>();
    }

    public static Path resolveWhiteListFilePath(String whiteListFile, Path projectRoot) {
        if (whiteListFile == null || whiteListFile.isEmpty()) {
            throw new GorSystemException("Can not resolve empty white list file path", null);
        }
        Path whiteListPath = Paths.get(whiteListFile, new String[0]);
        if (whiteListPath.isAbsolute()) {
            return whiteListPath;
        }
        if (projectRoot != null) {
            return projectRoot.resolve(whiteListFile);
        }
        log.warn("Whitelist file {} is relative but no project root is defined!", (Object)whiteListFile);
        return whiteListPath;
    }

    public static Optional<String> getIgnoreCase(Collection<String> c, String str) {
        return c.stream().filter(s -> s.equalsIgnoreCase(str)).findFirst();
    }

    public static String[] toUppercase(Collection<String> c) {
        return (String[])c.stream().map(String::toUpperCase).toArray(String[]::new);
    }

    public static String[] mergeArrays(String[] array1, String[] array2) {
        return (String[])Stream.concat(Arrays.stream(array1), Arrays.stream(array2)).toArray(String[]::new);
    }

    public static boolean isGorCmd(String cmd) {
        return cmd.toLowerCase().startsWith("gor ") || cmd.toLowerCase().startsWith("pgor ") || cmd.toLowerCase().startsWith("gorrow ") || cmd.toLowerCase().startsWith("gorrows ");
    }

    public static boolean isPGorCmd(String cmd) {
        return cmd.toLowerCase().startsWith("pgor ");
    }

    private static boolean isUUID(String filename) {
        return filename.indexOf(46) == 36 && filename.charAt(8) == '-';
    }

    private static void md5Rename(String md5, Path p) throws IOException {
        Path dm = p.getParent().resolve(md5 + GORZ_META);
        if (!Files.exists(dm, new LinkOption[0])) {
            Files.move(p, dm, new CopyOption[0]);
        } else if (Files.exists(p, new LinkOption[0]) && !Files.isSameFile(p, dm)) {
            Files.delete(p);
        }
        String fn = p.getFileName().toString();
        Path g = p.getParent().resolve(fn.substring(0, fn.length() - 5));
        Path d = p.getParent().resolve(md5 + ".gorz");
        if (!Files.exists(d, new LinkOption[0])) {
            Files.move(g, d, new CopyOption[0]);
        } else if (Files.exists(g, new LinkOption[0]) && !Files.isSameFile(g, d)) {
            Files.delete(g);
        }
    }

    private static void writeDummyHeader(Path dictionarypath) throws IOException {
        String[] defheader = new String[]{"chrom", "pos"};
        TableHeader tableheader = new TableHeader();
        tableheader.setColumns(defheader);
        String header = tableheader.formatHeader();
        Files.writeString(dictionarypath, (CharSequence)header, new OpenOption[0]);
    }

    private static void writeHeader(Path dictionarypath, Path p, boolean lineFilter) throws IOException {
        String fileName = p.getFileName().toString();
        Path gorzFile = p.getParent().resolve(fileName.substring(0, fileName.length() - 5));
        if (Files.exists(gorzFile, new LinkOption[0])) {
            try (BufferedReader br = new BufferedReader(new FileReader(gorzFile.toAbsolutePath().toString()));){
                String[] headerspl = br.readLine().split("\t");
                TableHeader tableheader = new TableHeader();
                tableheader.setColumns(headerspl);
                tableheader.setTableColumns(TableHeader.DEFULT_RANGE_TABLE_HEADER);
                if (!lineFilter) {
                    tableheader.setProperty("LINE_FILTER", Boolean.toString(lineFilter));
                }
                String header = tableheader.formatHeader();
                Files.writeString(dictionarypath, (CharSequence)header, new OpenOption[0]);
            }
        }
    }

    private static String resolveOutfile(Path outfolderpath, Path p) {
        String o = outfolderpath.relativize(p).toString();
        return o.substring(0, o.length() - GORZ_META.length());
    }

    private static Optional<String> findEntry(List<String> linelist, String entry) {
        return linelist.stream().filter(s -> s.startsWith(entry)).map(s -> s.substring(s.indexOf(58) + 1).trim()).findFirst();
    }

    public static synchronized void writeDictionaryFromMeta(Path outfolderpath, Path dictionarypath) throws IOException {
        boolean headerWritten = false;
        try (Stream<Path> metapathstream = Files.walk(outfolderpath, new FileVisitOption[0]);){
            List metapaths = metapathstream.filter(p -> p.getFileName().toString().endsWith(".meta")).collect(Collectors.toList());
            int i = 0;
            for (Path p2 : metapaths) {
                Stream<String> lines = Files.lines(p2);
                try {
                    boolean useMd5;
                    List<String> linelist = lines.collect(Collectors.toList());
                    Optional<String> omd5 = GorJavaUtilities.findEntry(linelist, "## MD5");
                    Optional<String> cc = GorJavaUtilities.findEntry(linelist, "## CARDCOL");
                    Optional<String> tags = GorJavaUtilities.findEntry(linelist, "## TAGS");
                    Optional<String> range = GorJavaUtilities.findEntry(linelist, "## RANGE");
                    boolean bl = useMd5 = omd5.isPresent() && GorJavaUtilities.isUUID(p2.getFileName().toString());
                    if (range.isPresent()) {
                        String s = range.get();
                        String outfile = (useMd5 ? omd5.get() : GorJavaUtilities.resolveOutfile(outfolderpath, p2)) + ".gorz";
                        String gordline = outfile + "\t" + ++i + "\t" + s + "\t";
                        if (cc.isPresent()) {
                            gordline = gordline + cc.get();
                        } else if (tags.isPresent()) {
                            gordline = gordline + tags.get();
                        }
                        if (!headerWritten) {
                            GorJavaUtilities.writeHeader(dictionarypath, p2, !tags.isPresent());
                            headerWritten = true;
                        }
                        Files.writeString(dictionarypath, (CharSequence)(gordline + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                    }
                    if (!useMd5) continue;
                    GorJavaUtilities.md5Rename(omd5.get(), p2);
                }
                finally {
                    if (lines == null) continue;
                    lines.close();
                }
            }
            if (!headerWritten) {
                GorJavaUtilities.writeDummyHeader(dictionarypath);
            }
        }
    }

    public static class CmdParams {
        String[] cmdParams;
        String command;

        CmdParams(String[] cmdParams, String command) {
            this.cmdParams = cmdParams;
            this.command = command;
        }

        public String getAliasName() {
            return this.cmdParams[0];
        }

        public String getCmdPath() {
            return this.command.split("[ ]+")[0];
        }

        public String getCommand() {
            return this.command;
        }

        public Optional<String> getType() {
            return Arrays.stream(this.cmdParams).skip(1L).filter(e -> e.startsWith("-s")).map(e -> e.substring(2)).findFirst();
        }

        public boolean isNor() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-n"));
        }

        public boolean isFormula() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-c"));
        }

        public boolean skipHeader() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-h"));
        }

        public boolean useProcessMethod() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-p"));
        }

        public boolean useHttpServer() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-u"));
        }

        public Optional<String> skipLines() {
            return Arrays.stream(this.cmdParams).skip(1L).filter(p -> p.startsWith("-s")).findFirst().map(p -> p.substring(2));
        }

        public boolean allowError() {
            return Arrays.stream(this.cmdParams).skip(1L).anyMatch(e -> e.equals("-e"));
        }
    }

    public static class VCFValue
    extends PRPRValue {
        double threshold;

        public VCFValue(double threshold) {
            super(',');
            this.threshold = threshold;
        }

        private String getGT(int c1, int c2) {
            double p1 = pArray[c1];
            double p2 = pArray[c2];
            double p0 = Math.abs(1.0 - p1 - p2);
            String gp = prprprFunction.get(c1, c2);
            if (p0 > this.threshold) {
                return "\t0/0:" + gp;
            }
            if (p1 > this.threshold) {
                return "\t0/1:" + gp;
            }
            if (p2 > this.threshold) {
                return "\t1/1:" + gp;
            }
            return "\t./.:" + gp;
        }

        @Override
        public String get(int c1, int c2) {
            if (c1 == 32) {
                return "\t./.:0" + this.sep + "0" + this.sep + "0";
            }
            if (this.prprArray == null) {
                this.prprArray = (String[][])IntStream.range(0, 128).mapToObj(i -> (String[])IntStream.range(0, 128).mapToObj(k -> this.getGT(i, k)).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
            }
            return this.prprArray[c1][c2];
        }
    }

    public static class PRPRPRValue
    extends PRPRValue {
        PRPRPRValue() {
        }

        @Override
        public String get(int c1, int c2) {
            if (this.prprArray == null) {
                this.prprArray = (String[][])IntStream.range(0, 128).mapToObj(i -> (String[])IntStream.range(0, 128).mapToObj(k -> fd3.format(Math.abs(1.0 - pArray[i] - pArray[k])) + this.sep + prArray[i] + this.sep + prArray[k]).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
            }
            return this.prprArray[c1][c2];
        }
    }

    public static enum Phenotypes {
        BINARY,
        QUANTITATIVE,
        MIXED;

    }

    public static class PhenoInfo {
        public Phenotypes phenotype;
        public String[] phenotypeNames;

        public PhenoInfo(Phenotypes phenotype, String[] phenotypeNames) {
            this.phenotype = phenotype;
            this.phenotypeNames = phenotypeNames;
        }
    }

    public static class PRPRValue {
        String[][] prprArray;
        char sep;

        PRPRValue() {
            this(';');
        }

        PRPRValue(char sep) {
            this.sep = sep;
        }

        public String get(int c1, int c2) {
            if (this.prprArray == null) {
                this.prprArray = (String[][])IntStream.range(0, 128).mapToObj(i -> (String[])IntStream.range(0, 128).mapToObj(k -> prArray[i] + this.sep + prArray[k]).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
            }
            return this.prprArray[c1][c2];
        }
    }
}

