/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Commands;

import gorsat.Commands.Analysis;
import gorsat.Commands.CommandArguments;
import gorsat.Commands.CommandArguments$;
import gorsat.Commands.CommandInfo;
import gorsat.Commands.CommandInfo$;
import gorsat.Commands.CommandOptions;
import gorsat.Commands.CommandOptions$;
import gorsat.Commands.CommandParseUtilities$;
import gorsat.Commands.CommandParsingResult;
import gorsat.Commands.CommandParsingResult$;
import gorsat.Commands.CommandRuntime;
import gorsat.external.plink.PlinkArguments;
import gorsat.external.plink.PlinkProcessAdaptor;
import gorsat.external.plink.PlinkVcfProcessAdaptor;
import gorsat.process.GorJavaUtilities;
import java.io.BufferedReader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.session.GorContext;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0002\u0004\u0001\u0017!)\u0001\u0003\u0001C\u0001#!)1\u0003\u0001C!)!)\u0011\n\u0001C\u0005\u0015\")A\r\u0001C\u0005K\ny\u0001\u000b\\5oWJ+wM]3tg&|gN\u0003\u0002\b\u0011\u0005A1i\\7nC:$7OC\u0001\n\u0003\u00199wN]:bi\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0007\u0013\tyaAA\u0006D_6l\u0017M\u001c3J]\u001a|\u0017A\u0002\u001fj]&$h\bF\u0001\u0013!\ti\u0001!\u0001\tqe>\u001cWm]:Be\u001e,X.\u001a8ugRAQ\u0003\u0007\u00146wu\u0012E\t\u0005\u0002\u000e-%\u0011qC\u0002\u0002\u0015\u0007>lW.\u00198e!\u0006\u00148/\u001b8h%\u0016\u001cX\u000f\u001c;\t\u000be\u0011\u0001\u0019\u0001\u000e\u0002\u000f\r|g\u000e^3yiB\u00111\u0004J\u0007\u00029)\u0011QDH\u0001\bg\u0016\u001c8/[8o\u0015\ty\u0002%A\u0002h_JT!!\t\u0012\u0002\u000f\u001d|'\u000f]5qK*\t1%A\u0002pe\u001eL!!\n\u000f\u0003\u0015\u001d{'oQ8oi\u0016DH\u000fC\u0003(\u0005\u0001\u0007\u0001&A\u0005be\u001e\u001cFO]5oOB\u0011\u0011F\r\b\u0003UA\u0002\"a\u000b\u0018\u000e\u00031R!!\f\u0006\u0002\rq\u0012xn\u001c;?\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Er\u0003\"\u0002\u001c\u0003\u0001\u00049\u0014!B5be\u001e\u001c\bc\u0001\u001d:Q5\ta&\u0003\u0002;]\t)\u0011I\u001d:bs\")AH\u0001a\u0001o\u0005!\u0011M]4t\u0011\u0015q$\u00011\u0001@\u0003))\u00070Z2vi\u0016tuN\u001d\t\u0003q\u0001K!!\u0011\u0018\u0003\u000f\t{w\u000e\\3b]\")1I\u0001a\u0001Q\u0005\tbm\u001c:dK\u0012Le\u000e];u\u0011\u0016\fG-\u001a:\t\u000f\u0015\u0013\u0001\u0013!a\u0001\r\u0006q1m\\7nC:$'+\u001e8uS6,\u0007CA\u0007H\u0013\tAeA\u0001\bD_6l\u0017M\u001c3Sk:$\u0018.\\3\u0002\u0019\u001d,G\u000f\u00155f]>$\u0018\u0010]3\u0015\u0007-\u0003'\rE\u0002M#Nk\u0011!\u0014\u0006\u0003\u001d>\u000bA!\u001e;jY*\t\u0001+\u0001\u0003kCZ\f\u0017B\u0001*N\u0005!y\u0005\u000f^5p]\u0006d\u0007C\u0001+^\u001d\t)&L\u0004\u0002W1:\u00111fV\u0005\u0002\u0013%\u0011\u0011\fC\u0001\baJ|7-Z:t\u0013\tYF,\u0001\tH_JT\u0015M^1Vi&d\u0017\u000e^5fg*\u0011\u0011\fC\u0005\u0003=~\u0013\u0011\u0002\u00155f]>LeNZ8\u000b\u0005mc\u0006\"B1\u0004\u0001\u0004A\u0013!\u00029iK:|\u0007\"B2\u0004\u0001\u0004Q\u0012AC4pe\u000e{g\u000e^3yi\u0006\u0001r-\u001a;D_2,XN\\%oI&\u001cWm\u001d\u000b\u0004M*d\u0007c\u0001\u001d:OB\u0011\u0001\b[\u0005\u0003S:\u00121!\u00138u\u0011\u0015YG\u00011\u00018\u0003!Ig\u000eS3bI\u0016\u0014\b\"B7\u0005\u0001\u0004q\u0017\u0001B2pYN\u00042\u0001O8)\u0013\t\u0001hF\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002")
public class PlinkRegression
extends CommandInfo {
    public CommandParsingResult processArguments(GorContext context, String argString, String[] iargs, String[] args, boolean executeNor, String forcedInputHeader, CommandRuntime commandRuntime) {
        GorJavaUtilities.Phenotypes phenotype;
        int[] colIndices;
        String hideCovarOption = "-hc";
        String firthOption = "-firth";
        String residualizeOption = "-residualize";
        String impOption = "-imp";
        String domOption = "-dom";
        String recOption = "-rec";
        String cvsOption = "-cvs";
        String vsOption = "-vs";
        String qnOption = "-qn";
        String vcfOption = "-vcf";
        String phenoOption = "-1";
        String covarOption = "-covar";
        String thresholdOption = "-threshold";
        String hweOption = "-hwe";
        String genoOption = "-geno";
        String mafOption = "-maf";
        boolean firth = CommandParseUtilities$.MODULE$.hasOption(args, firthOption);
        boolean imputed = CommandParseUtilities$.MODULE$.hasOption(args, impOption);
        boolean thresholdSet = CommandParseUtilities$.MODULE$.hasOption(args, thresholdOption);
        boolean dom = CommandParseUtilities$.MODULE$.hasOption(args, domOption);
        boolean rec = CommandParseUtilities$.MODULE$.hasOption(args, recOption);
        boolean cvs = CommandParseUtilities$.MODULE$.hasOption(args, cvsOption);
        boolean vs = CommandParseUtilities$.MODULE$.hasOption(args, vsOption);
        boolean qn = CommandParseUtilities$.MODULE$.hasOption(args, qnOption);
        boolean hc = CommandParseUtilities$.MODULE$.hasOption(args, hideCovarOption);
        boolean vcf = CommandParseUtilities$.MODULE$.hasOption(args, vcfOption);
        boolean ph = CommandParseUtilities$.MODULE$.hasOption(args, phenoOption);
        if (!imputed && thresholdSet) {
            throw new GorParsingException("The -threshold option is only allowed together with the -imp option.");
        }
        String pheno = iargs[0];
        String covar = CommandParseUtilities$.MODULE$.stringValueOfOptionWithDefault(args, covarOption, null);
        float threshold = (float)CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck(args, thresholdOption, 0.9, 0.0, 1.0);
        float hwe = (float)CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck(args, hweOption, -1.0, CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$4(), CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$5());
        float geno = (float)CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck(args, genoOption, -1.0, CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$4(), CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$5());
        float maf = (float)CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck(args, mafOption, -1.0, CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$4(), CommandParseUtilities$.MODULE$.doubleValueOfOptionWithDefaultWithRangeCheck$default$5());
        String residualize = CommandParseUtilities$.MODULE$.stringValueOfOptionWithDefault(args, residualizeOption, "");
        String[] inHeaderCols = new StringOps(Predef$.MODULE$.augmentString(forcedInputHeader)).split('\t');
        int[] nArray = colIndices = vcf ? this.getColumnIndices(inHeaderCols, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(RS|ID).*", "REF.*", "ALT.*"})) : this.getColumnIndices(inHeaderCols, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(RS|ID).*", "REF.*", "ALT.*", "VALUE.*"}));
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colIndices)).tail())).contains((Object)BoxesRunTime.boxToInteger((int)-1))) {
            throw new GorParsingException("There must be a reference allele column, alternative allele column and value column.");
        }
        Optional<GorJavaUtilities.PhenoInfo> phenoinfo = this.getPhenotype(pheno, context);
        String[] phenonames = phenoinfo.isPresent() ? phenoinfo.get().phenotypeNames : (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        PlinkArguments plinkArguments = new PlinkArguments(phenonames, pheno, covar, residualize, firth, hc, dom, rec, vs, qn, cvs, ph, hwe, geno, maf);
        scala.collection.mutable.StringBuilder headerBuilder = new scala.collection.mutable.StringBuilder();
        headerBuilder.append(inHeaderCols[0]);
        headerBuilder.append('\t');
        headerBuilder.append(inHeaderCols[1]);
        headerBuilder.append('\t');
        scala.collection.mutable.StringBuilder stringBuilder = colIndices[0] == -1 ? headerBuilder.append("ID") : headerBuilder.append(inHeaderCols[colIndices[0]]);
        headerBuilder.append('\t');
        headerBuilder.append(inHeaderCols[colIndices[1]]);
        headerBuilder.append('\t');
        headerBuilder.append(inHeaderCols[colIndices[2]]);
        headerBuilder.append('\t');
        GorJavaUtilities.Phenotypes phenotypes = phenotype = phenoinfo.isPresent() ? phenoinfo.get().phenotype : GorJavaUtilities.Phenotypes.BINARY;
        scala.collection.mutable.StringBuilder stringBuilder2 = phenotype.equals((Object)GorJavaUtilities.Phenotypes.BINARY) ? headerBuilder.append("A1\tFIRTH\tTEST\tOBS_CT\tOR\tLOG_OR_SE\tZ_STAT\tP\tERRCODE\tPHENO") : (phenotype.equals((Object)GorJavaUtilities.Phenotypes.MIXED) ? headerBuilder.append("A1\tFIRTH?\tTEST\tOBS_CT\tOR\tLOG(OR)_SE\tZ_STAT\tP\tERRCODE\tPHENO") : headerBuilder.append("A1\tTEST\tOBS_CT\tBETA\tSE\tT_STAT\tP\tERRCODE\tPHENO"));
        String header = headerBuilder.toString();
        PlinkProcessAdaptor pip = vcf ? new PlinkVcfProcessAdaptor(context.getSession(), plinkArguments, colIndices[1], colIndices[2], colIndices[0], colIndices.length == 4 ? colIndices[3] : -1, !imputed, threshold, vcf, forcedInputHeader, header) : new PlinkProcessAdaptor(context.getSession(), plinkArguments, colIndices[1], colIndices[2], colIndices[0], colIndices.length == 4 ? colIndices[3] : -1, !imputed, threshold, vcf, header);
        return new CommandParsingResult((Analysis)pip, header, CommandParsingResult$.MODULE$.apply$default$3(), CommandParsingResult$.MODULE$.apply$default$4());
    }

    private Optional<GorJavaUtilities.PhenoInfo> getPhenotype(String pheno, GorContext gorContext) {
        Optional<GorJavaUtilities.PhenoInfo> phenoinfo;
        block1: {
            Path phenoPath = Paths.get(pheno, new String[0]);
            if (!phenoPath.isAbsolute()) {
                String root = gorContext.getSession().getProjectContext().getRoot();
                String rootExtract = root.split("[ \t]+")[0];
                Path rootPath = Paths.get(rootExtract, new String[0]);
                phenoPath = rootPath.resolve(phenoPath);
            }
            phenoinfo = Optional.empty();
            if (!Files.exists(phenoPath, new LinkOption[0])) break block1;
            BufferedReader phenoReader = Files.newBufferedReader(phenoPath);
            String phenoHeader = phenoReader.readLine();
            phenoinfo = Optional.of(GorJavaUtilities.getPhenotype(phenoHeader, phenoReader));
        }
        return phenoinfo;
    }

    private int[] getColumnIndices(String[] inHeader, Seq<String> cols) {
        String[] inHeaderToUpper = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inHeader)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (!cols.forall((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)PlinkRegression.$anonfun$getColumnIndices$2(inHeaderToUpper, col)))) {
            throw new GorParsingException(new StringBuilder(34).append("Ambiguous column names in header:\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inHeader)).mkString("\t")).toString());
        }
        return (int[])((TraversableOnce)cols.map((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToInteger((int)PlinkRegression.$anonfun$getColumnIndices$4(inHeaderToUpper, col)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ boolean $anonfun$getColumnIndices$2(String[] inHeaderToUpper$1, String col) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inHeaderToUpper$1)).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.matches(col))) <= 1;
    }

    public static final /* synthetic */ int $anonfun$getColumnIndices$4(String[] inHeaderToUpper$1, String col) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inHeaderToUpper$1)).indexWhere((Function1 & Serializable & scala.Serializable)in -> BoxesRunTime.boxToBoolean((boolean)in.matches(col)));
    }

    public PlinkRegression() {
        super("PLINKREGRESSION", new CommandArguments("-hc -firth -imp -dom -rec -cvs -vs -qn -vcf -1", "-residualize -covar -threshold -hwe -geno -maf", 1, 1, CommandArguments$.MODULE$.apply$default$5()), new CommandOptions(true, true, CommandOptions$.MODULE$.apply$default$3(), CommandOptions$.MODULE$.apply$default$4(), CommandOptions$.MODULE$.apply$default$5(), CommandOptions$.MODULE$.apply$default$6()), CommandInfo$.MODULE$.$lessinit$greater$default$4());
    }
}

