/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Regression;

public class LinearAlgebra {
    private static final double EPSILON = Double.longBitsToDouble(4368491638549381120L);

    private LinearAlgebra() {
    }

    public static void solveSymPosDef(double[][] A, double[] x, double[] b) {
        if (b.length == 2) {
            double det = A[0][0] * A[1][1] - A[1][0] * A[1][0];
            if (det <= EPSILON) {
                throw new IllegalArgumentException("Singular matrix.");
            }
            x[0] = (b[0] * A[1][1] - b[1] * A[1][0]) / det;
            x[1] = (A[0][0] * b[1] - A[1][0] * b[0]) / det;
        } else {
            int n = b.length;
            LinearAlgebra.choleskyFactorize(A, n);
            LinearAlgebra.solveUpper(A, b, b, n);
            LinearAlgebra.solveLower(A, x, b, n);
        }
    }

    public static void choleskyFactorize(double[][] A, int dim) {
        for (int i = dim - 1; i != -1; --i) {
            double sqrt;
            double[] A_i = A[i];
            if (A_i[i] <= EPSILON) {
                throw new IllegalArgumentException("Not a positive definite matrix.");
            }
            A_i[i] = sqrt = Math.sqrt(A_i[i]);
            double invSqrt = 1.0 / sqrt;
            int j = i - 1;
            while (j != -1) {
                int n = j--;
                A_i[n] = A_i[n] * invSqrt;
            }
            for (int k = i - 1; k != -1; --k) {
                double tmp = A_i[k];
                double[] A_k = A[k];
                for (int j2 = k; j2 != -1; --j2) {
                    int n = j2;
                    A_k[n] = A_k[n] - tmp * A_i[j2];
                }
            }
        }
    }

    public static void solveUpper(double[][] U, double[] x, double[] y, int n) {
        for (int i = n - 1; i != -1; --i) {
            double[] U_i = U[i];
            int n2 = i;
            double d = y[n2] / U_i[i];
            y[n2] = d;
            double y_i = d;
            for (int j = i - 1; j != -1; --j) {
                int n3 = j;
                x[n3] = x[n3] - y_i * U_i[j];
            }
        }
    }

    public static void solveLower(double[][] L, double[] x, double[] y, int n) {
        for (int i = 0; i < n; ++i) {
            double[] L_i = L[i];
            double x_i = y[i];
            for (int j = 0; j < i; ++j) {
                x_i -= L_i[j] * x[j];
            }
            x[i] = x_i / L_i[i];
        }
    }

    public static void QRFactorize(double[][] X, double[] rDiag, int m) {
        for (int j = 0; j < X.length; ++j) {
            double[] X_j = X[j];
            double x2 = LinearAlgebra.dotProd(X_j, X_j, j, m);
            double a = X_j[j] > 0.0 ? -Math.sqrt(x2) : Math.sqrt(x2);
            int n = j;
            X_j[n] = X_j[n] - a;
            rDiag[j] = a;
            double X_jj = X_j[j];
            for (int k = j + 1; k < X.length; ++k) {
                double scale = LinearAlgebra.dotProd(X[k], X_j, j, m) / (a * X_jj);
                LinearAlgebra.addMultipleOf(X[k], scale, X_j, j, m);
            }
        }
    }

    public static void invertUpperTriangular(double[][] U, double[][] X, int n) {
        for (int colIdx = n - 1; colIdx != -1; --colIdx) {
            LinearAlgebra.solveUxEqualsKthElem(U, X[colIdx], colIdx);
        }
    }

    private static void solveUxEqualsKthElem(double[][] U, double[] x, int k) {
        double x_j;
        double[] U_j = U[k];
        x[k] = x_j = 1.0 / U_j[k];
        for (int i = k - 1; i != -1; --i) {
            x[i] = -U_j[i] * x_j;
        }
        for (int j = k - 1; j != -1; --j) {
            U_j = U[j];
            int n = j;
            double d = x[n] / U_j[j];
            x[n] = d;
            x_j = d;
            for (int i = j - 1; i != -1; --i) {
                int n2 = i;
                x[n2] = x[n2] - U_j[i] * x_j;
            }
        }
    }

    public static double dotProd(double[] x, double[] y, int len) {
        return LinearAlgebra.dotProd(x, y, 0, len);
    }

    public static double dotProd(double[] x, double[] y, int offset, int upTo) {
        int i;
        double s0 = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double s4 = 0.0;
        double s5 = 0.0;
        double s6 = 0.0;
        double s7 = 0.0;
        int unfoldUpTo = upTo - 7;
        for (i = offset; i < unfoldUpTo; i += 8) {
            s0 += x[i] * y[i];
            s1 += x[i + 1] * y[i + 1];
            s2 += x[i + 2] * y[i + 2];
            s3 += x[i + 3] * y[i + 3];
            s4 += x[i + 4] * y[i + 4];
            s5 += x[i + 5] * y[i + 5];
            s6 += x[i + 6] * y[i + 6];
            s7 += x[i + 7] * y[i + 7];
        }
        double s = s0 + s1 + s2 + s3 + s4 + s5 + s6 + s7;
        while (i < upTo) {
            s += x[i] * y[i];
            ++i;
        }
        return s;
    }

    public static double tripleDotProd(double[] x, double[] y, double[] z, int len) {
        return LinearAlgebra.tripleDotProd(x, y, z, 0, len);
    }

    public static double tripleDotProd(double[] x, double[] y, double[] z, int offset, int upTo) {
        int i;
        double s0 = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double s4 = 0.0;
        double s5 = 0.0;
        double s6 = 0.0;
        double s7 = 0.0;
        int unfoldUpTo = upTo - 7;
        for (i = offset; i < unfoldUpTo; i += 8) {
            s0 += x[i] * y[i] * z[i];
            s1 += x[i + 1] * y[i + 1] * z[i + 1];
            s2 += x[i + 2] * y[i + 2] * z[i + 2];
            s3 += x[i + 3] * y[i + 3] * z[i + 3];
            s4 += x[i + 4] * y[i + 4] * z[i + 4];
            s5 += x[i + 5] * y[i + 5] * z[i + 5];
            s6 += x[i + 6] * y[i + 6] * z[i + 6];
            s7 += x[i + 7] * y[i + 7] * z[i + 7];
        }
        double s = s0 + s1 + s2 + s3 + s4 + s5 + s6 + s7;
        while (i < upTo) {
            s += x[i] * y[i] * z[i];
            ++i;
        }
        return s;
    }

    public static double sum(double[] x, int len) {
        return LinearAlgebra.sum(x, 0, len);
    }

    public static double sum(double[] x, int offset, int upTo) {
        int i;
        double s0 = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double s4 = 0.0;
        double s5 = 0.0;
        double s6 = 0.0;
        double s7 = 0.0;
        int unfoldUpTo = upTo - 7;
        for (i = offset; i < unfoldUpTo; i += 8) {
            s0 += x[i];
            s1 += x[i + 1];
            s2 += x[i + 2];
            s3 += x[i + 3];
            s4 += x[i + 4];
            s5 += x[i + 5];
            s6 += x[i + 6];
            s7 += x[i + 7];
        }
        double s = s0 + s1 + s2 + s3 + s4 + s5 + s6 + s7;
        while (i < upTo) {
            s += x[i];
            ++i;
        }
        return s;
    }

    public static void addMultipleOf(double[] x, double a, double[] y, int offset, int upTo) {
        int i;
        int unfoldUpTo = upTo - 7;
        for (i = offset; i < unfoldUpTo; i += 8) {
            int n = i;
            x[n] = x[n] + a * y[i];
            int n2 = i + 1;
            x[n2] = x[n2] + a * y[i + 1];
            int n3 = i + 2;
            x[n3] = x[n3] + a * y[i + 2];
            int n4 = i + 3;
            x[n4] = x[n4] + a * y[i + 3];
            int n5 = i + 4;
            x[n5] = x[n5] + a * y[i + 4];
            int n6 = i + 5;
            x[n6] = x[n6] + a * y[i + 5];
            int n7 = i + 6;
            x[n7] = x[n7] + a * y[i + 6];
            int n8 = i + 7;
            x[n8] = x[n8] + a * y[i + 7];
        }
        while (i < upTo) {
            int n = i;
            x[n] = x[n] + a * y[i];
            ++i;
        }
    }
}

