/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory;

import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.gorpipe.util.Pair;

public class PerspectiveDialogDisplayParams {
    private static final HashMap<String, Color> colorMap = new HashMap();
    private static final HashMap<String, Color> fadeInColorMap = new HashMap();
    public final String category;
    public final String imageColorName;

    public PerspectiveDialogDisplayParams(String category, String imageColorName) {
        this.category = category;
        this.imageColorName = imageColorName.toUpperCase();
    }

    public static Pair<Color, Color> getRandomColor() {
        int colorIdx = (int)Math.round(Math.random() * (double)(colorMap.size() - 1));
        String colorName = PerspectiveDialogDisplayParams.getAvailableColors()[colorIdx];
        return new Pair((Serializable)colorMap.get(colorName.toUpperCase()), (Serializable)fadeInColorMap.get(colorName.toUpperCase()));
    }

    private static String[] getAvailableColors() {
        Set<String> availableColors = colorMap.keySet();
        return availableColors.toArray(new String[availableColors.size()]);
    }

    public Color getImageColor() {
        return colorMap.get(this.imageColorName);
    }

    public Color getFadeInImageColor() {
        return fadeInColorMap.get(this.imageColorName);
    }

    static {
        colorMap.put("RED", new Color(128, 0, 0));
        colorMap.put("GREEN", new Color(0, 128, 0));
        colorMap.put("BLUE", Color.BLUE);
        colorMap.put("MAGENTA", Color.MAGENTA);
        colorMap.put("DARK_GRAY", Color.DARK_GRAY);
        colorMap.put("BLACK", Color.BLACK);
        colorMap.put("CYAN", new Color(0, 172, 170));
        colorMap.put("ORANGE", new Color(255, 153, 0));
        colorMap.put("OLIVE", new Color(128, 128, 0));
        fadeInColorMap.put("RED", new Color(255, 153, 153));
        fadeInColorMap.put("GREEN", new Color(153, 255, 153));
        fadeInColorMap.put("BLUE", new Color(153, 153, 255));
        fadeInColorMap.put("MAGENTA", new Color(255, 153, 255));
        fadeInColorMap.put("DARK_GRAY", new Color(204, 204, 204));
        fadeInColorMap.put("BLACK", new Color(140, 140, 140));
        fadeInColorMap.put("CYAN", new Color(153, 255, 255));
        fadeInColorMap.put("ORANGE", new Color(255, 203, 121));
        fadeInColorMap.put("OLIVE", new Color(243, 246, 0));
    }
}

