/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parser;

import gorsat.parser.CalcFunctions;
import gorsat.parser.CalcLambdaBoolean;
import gorsat.parser.CalcLambdaDouble;
import gorsat.parser.CalcLambdaDoubleConstant;
import gorsat.parser.CalcLambdaInteger;
import gorsat.parser.CalcLambdaIntegerConstant;
import gorsat.parser.CalcLambdaLong;
import gorsat.parser.CalcLambdaLongConstant;
import gorsat.parser.CalcLambdaString;
import gorsat.parser.CalcLambdaStringConstant;
import gorsat.parser.CalcLambdaVariable;
import gorsat.parser.Constant;
import gorsat.parser.DoubleType;
import gorsat.parser.FunctionRegistry;
import gorsat.parser.FunctionTypes;
import gorsat.parser.FunctionWrapper;
import gorsat.parser.IntegerType;
import gorsat.parser.LongType;
import gorsat.parser.Numeric;
import gorsat.parser.ParseArith;
import gorsat.parser.StringDistance;
import gorsat.parser.StringType;
import gorsat.parser.TypedCalcLambda;
import gorsat.parser.TypedExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.GorScriptBaseVisitor;
import org.gorpipe.gor.GorScriptParser;
import org.gorpipe.gor.model.ColumnValueProvider;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;

public class CalcCompiler
extends GorScriptBaseVisitor<TypedCalcLambda> {
    private static final int REPLACE_COLUMN = -3;
    private final FunctionRegistry functionRegistry = CalcFunctions.registry();
    private final ParseArith owner;
    private final Map<String, Integer> columns = new HashMap<String, Integer>();
    private final Map<Integer, String> columnTypes = new HashMap<Integer, String>();
    private final List<String> columnNames = new ArrayList<String>();

    public CalcCompiler() {
        this(null);
    }

    public CalcCompiler(ParseArith owner) {
        this.owner = owner;
        this.columnTypes.put(-3, "S");
    }

    private static int typePriority(String type) {
        if (type.equals("Boolean")) {
            return 0;
        }
        if (type.equals("Int")) {
            return 1;
        }
        if (type.equals("Long")) {
            return 2;
        }
        if (type.equals("Double")) {
            return 3;
        }
        if (type.equals("String")) {
            return 4;
        }
        throw new GorSystemException("Unknown type", null);
    }

    private GorParsingException getIncompatibleTypes() {
        return new GorParsingException("Incompatible types");
    }

    public void setColumnNamesAndTypes(String[] colNames, String[] colTypes) {
        for (int i = 0; i < colNames.length; ++i) {
            this.columnNames.add(colNames[i]);
            this.columns.put(colNames[i].toUpperCase(), i);
            this.columnTypes.put(i, colTypes[i]);
        }
    }

    public void addSpecialVars() {
        this.columns.put("X", -2);
        this.columnTypes.put(-2, "S");
        this.columns.put("I", -1);
        this.columnTypes.put(-1, "I");
    }

    @Override
    public TypedCalcLambda visitCalc_expression(GorScriptParser.Calc_expressionContext ctx) {
        return (TypedCalcLambda)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public TypedCalcLambda visitExpression(GorScriptParser.ExpressionContext ctx) {
        TypedCalcLambda accumulator = (TypedCalcLambda)ctx.getChild(0).accept((ParseTreeVisitor)this);
        int childCount = ctx.getChildCount();
        for (int i = 1; i < childCount; i += 2) {
            int op = ((TerminalNode)ctx.getChild(i)).getSymbol().getType();
            GorScriptParser.TermContext child = (GorScriptParser.TermContext)ctx.getChild(i + 1);
            TypedCalcLambda nextTerm = child.accept(this);
            try {
                if (op == 16) {
                    accumulator = nextTerm.addedTo(accumulator);
                    continue;
                }
                if (op != 17) continue;
                accumulator = nextTerm.subtractedFrom(accumulator);
                continue;
            }
            catch (GorParsingException e) {
                e.setLine(child.start.getLine());
                e.setPos(child.start.getStopIndex() + 1);
                throw e;
            }
        }
        return accumulator;
    }

    @Override
    public TypedCalcLambda visitTerm(GorScriptParser.TermContext ctx) {
        TypedCalcLambda accumulator = (TypedCalcLambda)ctx.getChild(0).accept((ParseTreeVisitor)this);
        int childCount = ctx.getChildCount();
        for (int i = 1; i < childCount; i += 2) {
            int op = ((TerminalNode)ctx.getChild(i)).getSymbol().getType();
            GorScriptParser.Optional_power_factorContext child = (GorScriptParser.Optional_power_factorContext)ctx.getChild(i + 1);
            TypedCalcLambda nextTerm = child.accept(this);
            try {
                if (op == 18) {
                    accumulator = nextTerm.multipliedWith(accumulator);
                    continue;
                }
                if (op != 19) continue;
                accumulator = nextTerm.dividedInto(accumulator);
                continue;
            }
            catch (GorParsingException e) {
                e.setLine(child.start.getLine());
                e.setPos(child.start.getStopIndex() + 1);
                throw e;
            }
        }
        return accumulator;
    }

    @Override
    public TypedCalcLambda visitSigned_factor(GorScriptParser.Signed_factorContext ctx) {
        int op = ((TerminalNode)ctx.getChild(0)).getSymbol().getType();
        TypedCalcLambda ex = (TypedCalcLambda)ctx.getChild(1).accept((ParseTreeVisitor)this);
        if (op == 17) {
            return ex.negate();
        }
        return ex;
    }

    @Override
    public TypedCalcLambda visitFunction_call(GorScriptParser.Function_callContext ctx) {
        List<TypedCalcLambda> argLambdas;
        String name = ctx.function_name().getText().toUpperCase();
        TypedCalcLambda lambdaFromFunctionWrapper = this.getTypedCalcLambdaForFunction(name, argLambdas = this.getArgLambdas(ctx.expression()), ArgumentPromotion.NONE);
        if (lambdaFromFunctionWrapper != null) {
            return lambdaFromFunctionWrapper;
        }
        lambdaFromFunctionWrapper = this.getTypedCalcLambdaForFunction(name, argLambdas, ArgumentPromotion.NUMERIC_VARIABLES_AS_STRING);
        if (lambdaFromFunctionWrapper != null) {
            return lambdaFromFunctionWrapper;
        }
        throw this.getIncompatibleTypes();
    }

    private TypedCalcLambda getTypedCalcLambdaForFunction(String name, List<TypedCalcLambda> argLambdas, ArgumentPromotion argumentPromotion) {
        TypedCalcLambda lambdaFromFunctionWrapper = null;
        ArrayList sortedVariants = new ArrayList();
        this.functionRegistry.getVariants(name).iterator().foreach(sortedVariants::add);
        sortedVariants.sort((a, b) -> {
            String returnTypeA = a.split("2")[1];
            String returnTypeB = b.split("2")[1];
            return CalcCompiler.typePriority(returnTypeA) - CalcCompiler.typePriority(returnTypeB);
        });
        for (String signature : sortedVariants) {
            String mangledName = name + "_" + signature;
            FunctionWrapper functionWrapper = this.functionRegistry.lookupWrapper(mangledName);
            ArrayList<TypedExpression> args = new ArrayList<TypedExpression>();
            Iterator expectedArgs = functionWrapper.expectedArgs().iterator();
            java.util.Iterator<TypedCalcLambda> lambdaIterator = argLambdas.iterator();
            boolean argumentsMatch = true;
            while (expectedArgs.hasNext()) {
                TypedExpression typedExpression = this.getTypedExpression((String)expectedArgs.next(), lambdaIterator, argumentPromotion);
                if (typedExpression == null) {
                    argumentsMatch = false;
                    break;
                }
                args.add(typedExpression);
            }
            if (lambdaIterator.hasNext() || !argumentsMatch) continue;
            lambdaFromFunctionWrapper = this.getLambdaFromFunctionWrapper(functionWrapper, args);
            break;
        }
        return lambdaFromFunctionWrapper;
    }

    private List<TypedCalcLambda> getArgLambdas(List<GorScriptParser.ExpressionContext> arguments) {
        ArrayList<TypedCalcLambda> argLambdas = new ArrayList<TypedCalcLambda>();
        for (GorScriptParser.ExpressionContext e : arguments) {
            argLambdas.add(e.accept(this));
        }
        return argLambdas;
    }

    private TypedExpression getTypedExpression(String argType, java.util.Iterator<TypedCalcLambda> lambdaIterator, ArgumentPromotion argumentPromotion) {
        TypedExpression typedExpression = null;
        if (lambdaIterator.hasNext()) {
            TypedCalcLambda orgLambda = lambdaIterator.next();
            TypedCalcLambda argLambda = orgLambda.toLambda();
            if (argType.equals(FunctionTypes.DoubleFun()) && argLambda instanceof Numeric) {
                typedExpression = new TypedExpression(FunctionTypes.DoubleFun(), argLambda::evaluateDouble);
            } else if (argType.equals(FunctionTypes.IntFun()) && argLambda instanceof IntegerType) {
                typedExpression = new TypedExpression(FunctionTypes.IntFun(), argLambda::evaluateInt);
            } else if (argType.equals(FunctionTypes.LongFun()) && (argLambda instanceof IntegerType || argLambda instanceof LongType)) {
                typedExpression = new TypedExpression(FunctionTypes.LongFun(), argLambda::evaluateLong);
            } else if (argType.equals(FunctionTypes.StringFun())) {
                if (orgLambda instanceof StringType || orgLambda instanceof Numeric && argumentPromotion == ArgumentPromotion.NUMERIC_AS_STRING || orgLambda instanceof CalcLambdaVariable && argumentPromotion == ArgumentPromotion.NUMERIC_VARIABLES_AS_STRING) {
                    typedExpression = new TypedExpression(FunctionTypes.StringFun(), orgLambda::evaluateString);
                }
            } else if (argType.equals(FunctionTypes.StringList()) && argLambda instanceof CalcLambdaStringConstant) {
                ListBuffer sl = new ListBuffer();
                boolean consumedAllArguments = false;
                while (orgLambda instanceof CalcLambdaStringConstant) {
                    sl.$plus$eq((Object)orgLambda.evaluateString(null));
                    if (!lambdaIterator.hasNext()) {
                        consumedAllArguments = true;
                        break;
                    }
                    orgLambda = lambdaIterator.next();
                }
                if (consumedAllArguments) {
                    typedExpression = new TypedExpression(FunctionTypes.StringList(), sl.toList());
                }
            }
        }
        return typedExpression;
    }

    private TypedCalcLambda getLambdaFromFunctionWrapper(FunctionWrapper functionWrapper, List<TypedExpression> args) {
        if (functionWrapper.returnType().equals(FunctionTypes.DoubleFun())) {
            return new CalcLambdaDouble(FunctionTypes.dFunToLambda((Function1<ColumnValueProvider, Object>)((Function1)functionWrapper.call(this.owner, args))));
        }
        if (functionWrapper.returnType().equals(FunctionTypes.IntFun())) {
            return new CalcLambdaInteger(FunctionTypes.iFunToLambda((Function1<ColumnValueProvider, Object>)((Function1)functionWrapper.call(this.owner, args))));
        }
        if (functionWrapper.returnType().equals(FunctionTypes.LongFun())) {
            return new CalcLambdaLong(FunctionTypes.lFunToLambda((Function1<ColumnValueProvider, Object>)((Function1)functionWrapper.call(this.owner, args))));
        }
        if (functionWrapper.returnType().equals(FunctionTypes.StringFun())) {
            return new CalcLambdaString(FunctionTypes.sFunToLambda((Function1<ColumnValueProvider, String>)((Function1)functionWrapper.call(this.owner, args))));
        }
        if (functionWrapper.returnType().equals(FunctionTypes.BooleanFun())) {
            return new CalcLambdaBoolean(FunctionTypes.bFunToLambda((Function1<ColumnValueProvider, Object>)((Function1)functionWrapper.call(this.owner, args))));
        }
        throw new GorSystemException("Unsupported return type", null);
    }

    @Override
    public TypedCalcLambda visitParen_expr(GorScriptParser.Paren_exprContext ctx) {
        return (TypedCalcLambda)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public TypedCalcLambda visitParen_rel_expr(GorScriptParser.Paren_rel_exprContext ctx) {
        return (TypedCalcLambda)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public TypedCalcLambda visitNot_rel_expr(GorScriptParser.Not_rel_exprContext ctx) {
        TypedCalcLambda expr = (TypedCalcLambda)ctx.getChild(1).accept((ParseTreeVisitor)this);
        return new CalcLambdaBoolean(cvp -> !expr.evaluateBoolean(cvp));
    }

    @Override
    public TypedCalcLambda visitIn_expression(GorScriptParser.In_expressionContext ctx) {
        TypedCalcLambda left = (TypedCalcLambda)ctx.getChild(0).accept((ParseTreeVisitor)this);
        HashSet<String> sl = new HashSet<String>();
        ParseTree slCtx = ctx.getChild(2);
        for (int argIx = 1; argIx < slCtx.getChildCount(); argIx += 2) {
            TypedCalcLambda arg = (TypedCalcLambda)slCtx.getChild(argIx).accept((ParseTreeVisitor)this);
            sl.add(arg.evaluateString(null));
        }
        return new CalcLambdaBoolean(cvp -> sl.contains(left.evaluateString(cvp)));
    }

    @Override
    public TypedCalcLambda visitIndag_expression(GorScriptParser.Indag_expressionContext ctx) {
        TypedCalcLambda left = (TypedCalcLambda)ctx.getChild(0).accept((ParseTreeVisitor)this);
        TypedCalcLambda file = (TypedCalcLambda)ctx.getChild(3).accept((ParseTreeVisitor)this);
        TypedCalcLambda v = (TypedCalcLambda)ctx.getChild(5).accept((ParseTreeVisitor)this);
        Set<String> dagSet = this.owner.aDagSet(file.evaluateString(null), v.evaluateString(null));
        return new CalcLambdaBoolean(cvp -> dagSet.contains((Object)left.evaluateString(cvp).toUpperCase()));
    }

    @Override
    public TypedCalcLambda visitRel_term(GorScriptParser.Rel_termContext ctx) {
        TypedCalcLambda accumulator = (TypedCalcLambda)ctx.getChild(0).accept((ParseTreeVisitor)this);
        int childCount = ctx.getChildCount();
        for (int i = 1; i < childCount; i += 2) {
            int op = ((TerminalNode)ctx.getChild(i)).getSymbol().getType();
            TypedCalcLambda nextTerm = (TypedCalcLambda)ctx.getChild(i + 1).accept((ParseTreeVisitor)this);
            if (op != 34) continue;
            TypedCalcLambda acc = accumulator;
            accumulator = new CalcLambdaBoolean(cvp -> acc.evaluateBoolean(cvp) && nextTerm.evaluateBoolean(cvp));
        }
        return accumulator;
    }

    @Override
    public TypedCalcLambda visitRel_expr(GorScriptParser.Rel_exprContext ctx) {
        TypedCalcLambda accumulator = (TypedCalcLambda)ctx.getChild(0).accept((ParseTreeVisitor)this);
        int childCount = ctx.getChildCount();
        for (int i = 1; i < childCount; i += 2) {
            int op = ((TerminalNode)ctx.getChild(i)).getSymbol().getType();
            TypedCalcLambda nextTerm = (TypedCalcLambda)ctx.getChild(i + 1).accept((ParseTreeVisitor)this);
            if (op != 33) continue;
            TypedCalcLambda acc = accumulator;
            accumulator = new CalcLambdaBoolean(cvp -> acc.evaluateBoolean(cvp) || nextTerm.evaluateBoolean(cvp));
        }
        return accumulator;
    }

    @Override
    public TypedCalcLambda visitCompare_expressions(GorScriptParser.Compare_expressionsContext ctx) {
        GorScriptParser.ExpressionContext leftCtx = (GorScriptParser.ExpressionContext)ctx.getChild(GorScriptParser.ExpressionContext.class, 0);
        GorScriptParser.ExpressionContext rightCtx = (GorScriptParser.ExpressionContext)ctx.getChild(GorScriptParser.ExpressionContext.class, 1);
        int op = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        TypedCalcLambda left = leftCtx.accept(this);
        TypedCalcLambda right = rightCtx.accept(this);
        return left.compare(right, op);
    }

    @Override
    public TypedCalcLambda visitIf_expr(GorScriptParser.If_exprContext ctx) {
        GorScriptParser.Rel_exprContext relExprContext = (GorScriptParser.Rel_exprContext)ctx.getChild(GorScriptParser.Rel_exprContext.class, 0);
        TypedCalcLambda predicate = relExprContext.accept(this);
        GorScriptParser.ExpressionContext thenExprContext = (GorScriptParser.ExpressionContext)ctx.getChild(GorScriptParser.ExpressionContext.class, 0);
        TypedCalcLambda thenExpr = thenExprContext.accept(this).toLambda();
        GorScriptParser.ExpressionContext elseExprContext = (GorScriptParser.ExpressionContext)ctx.getChild(GorScriptParser.ExpressionContext.class, 1);
        TypedCalcLambda elseExpr = elseExprContext.accept(this).toLambda();
        if (thenExpr instanceof IntegerType && elseExpr instanceof IntegerType) {
            return new CalcLambdaInteger(cvp -> {
                if (predicate.evaluateBoolean(cvp)) {
                    return thenExpr.evaluateInt(cvp);
                }
                return elseExpr.evaluateInt(cvp);
            });
        }
        if (thenExpr instanceof DoubleType && elseExpr instanceof DoubleType) {
            return new CalcLambdaDouble(cvp -> {
                if (predicate.evaluateBoolean(cvp)) {
                    return thenExpr.evaluateDouble(cvp);
                }
                return elseExpr.evaluateDouble(cvp);
            });
        }
        if (thenExpr instanceof StringType && (elseExpr instanceof StringType || !(elseExpr instanceof Constant))) {
            return new CalcLambdaString(cvp -> {
                if (predicate.evaluateBoolean(cvp)) {
                    return thenExpr.evaluateString(cvp);
                }
                return elseExpr.evaluateString(cvp);
            });
        }
        throw this.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda visitPower_factor(GorScriptParser.Power_factorContext ctx) {
        ParseTree leftCtx = ctx.getChild(0);
        ParseTree rightCtx = ctx.getChild(2);
        TypedCalcLambda left = (TypedCalcLambda)leftCtx.accept((ParseTreeVisitor)this);
        TypedCalcLambda right = (TypedCalcLambda)rightCtx.accept((ParseTreeVisitor)this);
        return left.pow(right);
    }

    @Override
    public TypedCalcLambda visitString_literal(GorScriptParser.String_literalContext ctx) {
        String textWithQuotes = ctx.getText();
        boolean escaped = false;
        StringBuilder text = new StringBuilder(textWithQuotes.length() - 2);
        for (int i = 1; i < textWithQuotes.length() - 1; ++i) {
            char c = textWithQuotes.charAt(i);
            if (escaped || c != '\\') {
                text.append(c);
                escaped = false;
                continue;
            }
            escaped = true;
        }
        return new CalcLambdaStringConstant(text.toString());
    }

    @Override
    public TypedCalcLambda visitNumber(GorScriptParser.NumberContext ctx) {
        String text = ctx.getText();
        try {
            int i = Integer.parseInt(text);
            return new CalcLambdaIntegerConstant(i);
        }
        catch (NumberFormatException e1) {
            try {
                long l = Long.parseLong(text);
                return new CalcLambdaLongConstant(l);
            }
            catch (NumberFormatException e2) {
                double d = Double.parseDouble(text);
                return new CalcLambdaDoubleConstant(d);
            }
        }
    }

    @Override
    public TypedCalcLambda visitVariable(GorScriptParser.VariableContext ctx) {
        int columnIndex;
        String originalName = ctx.getText();
        String name = originalName.toUpperCase();
        if (name.equals("#RC")) {
            columnIndex = -3;
        } else if (name.startsWith("#")) {
            try {
                columnIndex = Integer.parseInt(name.substring(1)) - 1;
            }
            catch (NumberFormatException e) {
                throw new GorParsingException(String.format("Variable '%s' not found", name));
            }
        } else {
            Integer ix = this.columns.get(name);
            if (ix == null) {
                ListBuffer names = new ListBuffer();
                this.columnNames.forEach(arg_0 -> ((ListBuffer)names).$plus$eq(arg_0));
                String closest = StringDistance.findClosest(name, 3, (Seq<String>)names.toList());
                Object suffix = "";
                if (!closest.isEmpty()) {
                    suffix = " - did you mean: " + closest + "?";
                }
                String message = String.format("Variable name '%s' not found%s", originalName, suffix);
                throw new GorParsingException(message, ctx.start.getLine(), ctx.start.getStopIndex() + 1);
            }
            columnIndex = ix;
        }
        return new CalcLambdaVariable(columnIndex, this.columnTypes.get(columnIndex));
    }

    @Override
    public TypedCalcLambda visitFilename(GorScriptParser.FilenameContext ctx) {
        return new CalcLambdaStringConstant(ctx.getText());
    }

    static enum ArgumentPromotion {
        NONE,
        NUMERIC_VARIABLES_AS_STRING,
        NUMERIC_AS_STRING;

    }
}

