/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Iterators.IteratorSource;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.exceptions.GorSystemException;

public abstract class BaseStreamIterator
extends IteratorSource {
    private final Supplier<Stream<String>> streamSupplier;
    private Iterator<String> dbit;
    private String header;
    private Stream<String> strstr;

    public BaseStreamIterator(Supplier<Stream<String>> streamSupplier) {
        this.streamSupplier = streamSupplier;
        this.initIteratorAndHeader();
    }

    protected void initIteratorAndHeader() {
        try {
            this.strstr = this.streamSupplier.get();
            this.dbit = this.strstr.iterator();
            this.header = this.produceHeaderFromData();
        }
        catch (GorResourceException e) {
            throw new GorSystemException("Unable to initialize iterator from stream.", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            throw new GorSystemException("Unable to initialize iterator from stream.", (Throwable)e);
        }
    }

    public String produceHeaderFromData() {
        return this.dbit.next();
    }

    @Override
    public boolean hasNext() {
        return this.dbit.hasNext();
    }

    @Override
    public String next() {
        return this.dbit.next();
    }

    @Override
    public void setPosition(String seekChr, int seekPos) {
        this.strstr.close();
        this.initIteratorAndHeader();
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public void close() {
        this.strstr.close();
    }
}

