/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.QueryHandlers.GeneralQueryHandler;
import gorsat.Utilities.AnalysisUtilities$;
import gorsat.process.CLISessionFactory$;
import gorsat.process.FreemarkerReportBuilder;
import gorsat.process.GenericRunnerFactory;
import gorsat.process.GorJavaUtilities;
import gorsat.process.GorSessionCacheManager;
import gorsat.process.GorSessionFactory;
import gorsat.process.PipeOptions;
import gorsat.process.SessionBasedQueryEvaluator;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.RequestStats;
import org.gorpipe.gor.clients.LocalFileCacheClient;
import org.gorpipe.gor.model.DefaultEventLogger;
import org.gorpipe.gor.model.DriverBackedFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GorParallelQueryHandler;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.gor.session.EventLogger;
import org.gorpipe.gor.session.GorReportBuilder;
import org.gorpipe.gor.session.GorRunnerFactory;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.GorSessionCache;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.gor.session.SystemContext;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054Aa\u0003\u0007\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u0015i\u0003\u0001\"\u0011/\u0011\u0015Y\u0004\u0001\"\u0003=\u0011\u0015)\u0005\u0001\"\u0003G\u000f\u001diE\"!A\t\u000293qa\u0003\u0007\u0002\u0002#\u0005q\nC\u0003)\u0011\u0011\u0005A\u000bC\u0004V\u0011E\u0005I\u0011\u0001,\u0003#\rc\u0015jU3tg&|gNR1di>\u0014\u0018P\u0003\u0002\u000e\u001d\u00059\u0001O]8dKN\u001c(\"A\b\u0002\r\u001d|'o]1u\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0007\n\u0005Ua!!E$peN+7o]5p]\u001a\u000b7\r^8ss\u0006Y\u0001/\u001b9f\u001fB$\u0018n\u001c8t!\t\u0019\u0002$\u0003\u0002\u001a\u0019\tY\u0001+\u001b9f\u001fB$\u0018n\u001c8t\u0003=\u0019XmY;sSRL8i\u001c8uKb$\bC\u0001\u000f&\u001d\ti2\u0005\u0005\u0002\u001fC5\tqD\u0003\u0002!!\u00051AH]8pizR\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\na\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011A%I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)ZC\u0006\u0005\u0002\u0014\u0001!)ac\u0001a\u0001/!9!d\u0001I\u0001\u0002\u0004Y\u0012AB2sK\u0006$X\rF\u00010!\t\u0001\u0014(D\u00012\u0015\t\u00114'A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005Q*\u0014aA4pe*\u0011agN\u0001\bO>\u0014\b/\u001b9f\u0015\u0005A\u0014aA8sO&\u0011!(\r\u0002\u000b\u000f>\u00148+Z:tS>t\u0017\u0001E2sK\u0006$XMR5mKJ+\u0017\rZ3s)\ti4\t\u0005\u0002?\u00036\tqH\u0003\u0002Ag\u0005)Qn\u001c3fY&\u0011!i\u0010\u0002\u000b\r&dWMU3bI\u0016\u0014\b\"\u0002#\u0006\u0001\u0004Y\u0012aB4peJ{w\u000e^\u0001\u0013GJ,\u0017\r^3Rk\u0016\u0014\u0018\u0010S1oI2,'\u000fF\u0002H\u00152\u0003\"A\u0010%\n\u0005%{$aF$peB\u000b'/\u00197mK2\fV/\u001a:z\u0011\u0006tG\r\\3s\u0011\u0015Ye\u00011\u0001\u001c\u0003A\tX/\u001a:z\u0011\u0006tG\r\\3s\u001d\u0006lW\rC\u00033\r\u0001\u0007q&A\tD\u0019&\u001bVm]:j_:4\u0015m\u0019;pef\u0004\"a\u0005\u0005\u0014\u0005!\u0001\u0006CA)S\u001b\u0005\t\u0013BA*\"\u0005\u0019\te.\u001f*fMR\ta*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0002/*\u00121\u0004W\u0016\u00023B\u0011!lX\u0007\u00027*\u0011A,X\u0001\nk:\u001c\u0007.Z2lK\u0012T!AX\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002a7\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class CLISessionFactory
extends GorSessionFactory {
    private final PipeOptions pipeOptions;
    private final String securityContext;

    public static String $lessinit$greater$default$2() {
        return CLISessionFactory$.MODULE$.$lessinit$greater$default$2();
    }

    public GorSession create() {
        String requestId = this.pipeOptions.requestId() != null ? this.pipeOptions.requestId() : "-1";
        boolean useSubFolder = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("gor.local.filecache.usesubfolders", "true"))).toBoolean();
        int subFolderSize = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("gor.local.filecache.subfoldersize", "2"))).toInt();
        GorSession session = new GorSession(requestId);
        Path projectRoot = Paths.get(this.pipeOptions.gorRoot() != null ? this.pipeOptions.gorRoot() : ".", new String[0]);
        Path cacheDir = Paths.get(this.pipeOptions.cacheDir() != null ? this.pipeOptions.cacheDir() : ProjectContext.DEFAULT_CACHE_DIR, new String[0]);
        if (!cacheDir.isAbsolute()) {
            cacheDir = projectRoot.resolve(cacheDir);
        }
        ProjectContext.Builder projectContextBuilder = new ProjectContext.Builder();
        ProjectContext projectContext = projectContextBuilder.setAliasFile(this.pipeOptions.aliasFile()).setCacheDir(((Object)cacheDir).toString()).setConfigFile(this.pipeOptions.configFile()).setLogDirectory(this.pipeOptions.logDir()).setConfigFile(this.pipeOptions.configFile()).setRoot(((Object)projectRoot).toString()).setFileReader(this.createFileReader(((Object)projectRoot).toString())).setFileCache((FileCache)new LocalFileCacheClient(cacheDir, useSubFolder, subFolderSize)).setQueryHandler(this.createQueryHandler(this.pipeOptions.queryHandler(), session)).setQueryEvaluator((QueryEvaluator)new SessionBasedQueryEvaluator(session)).build();
        SystemContext.Builder systemContextBuilder = new SystemContext.Builder();
        SystemContext systemContext = systemContextBuilder.setCommandWhitelist(GorJavaUtilities.readWhiteList(AnalysisUtilities$.MODULE$.getWhiteListCommandFilePath(projectContext.getRealProjectRootPath()))).setReportBuilder((GorReportBuilder)new FreemarkerReportBuilder(session)).setRunnerFactory((GorRunnerFactory)new GenericRunnerFactory()).setServer(false).setWorkers(this.pipeOptions.workers()).setStartTime(System.currentTimeMillis()).build();
        GorSessionCache cache = GorSessionCacheManager.getCache(requestId);
        session.setNorContext(this.pipeOptions.norContext());
        RequestStats eventLogger = this.pipeOptions.stats() ? new RequestStats(session) : new DefaultEventLogger();
        session.init(projectContext, systemContext, cache, (EventLogger)eventLogger);
        return session;
    }

    private FileReader createFileReader(String gorRoot) {
        return new DriverBackedFileReader(this.securityContext, gorRoot, null);
    }

    private GorParallelQueryHandler createQueryHandler(String queryHandlerName, GorSession session) {
        return new GeneralQueryHandler(session.getGorContext(), false);
    }

    public CLISessionFactory(PipeOptions pipeOptions, String securityContext) {
        this.pipeOptions = pipeOptions;
        this.securityContext = securityContext;
    }
}

