/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.QueryHandlers.GeneralQueryHandler;
import gorsat.process.FreemarkerReportBuilder;
import gorsat.process.GenericRunnerFactory;
import gorsat.process.GorSessionCacheManager;
import gorsat.process.GorSessionFactory;
import gorsat.process.SessionBasedQueryEvaluator;
import java.nio.file.Paths;
import java.util.UUID;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.clients.LocalFileCacheClient;
import org.gorpipe.gor.model.DriverBackedFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GorParallelQueryHandler;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.gor.session.GorReportBuilder;
import org.gorpipe.gor.session.GorRunnerFactory;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.GorSessionCache;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.gor.session.SystemContext;

public class GenericSessionFactory
extends GorSessionFactory {
    private String root = "";
    private final String cacheDir;
    private String configFile = "";

    public GenericSessionFactory() {
        this.cacheDir = ProjectContext.DEFAULT_CACHE_DIR;
    }

    public GenericSessionFactory(String root, String cacheDir) {
        this.root = root;
        this.cacheDir = cacheDir;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public GorSession create() {
        String requestId = UUID.randomUUID().toString();
        GorSession session = new GorSession(requestId);
        ProjectContext.Builder projectContextBuilder = new ProjectContext.Builder();
        projectContextBuilder.setRoot(this.root).setCacheDir(this.cacheDir).setConfigFile(this.configFile).setFileReader((FileReader)new DriverBackedFileReader("", this.root, null)).setFileCache((FileCache)new LocalFileCacheClient(Paths.get(this.cacheDir, new String[0]))).setQueryHandler((GorParallelQueryHandler)new GeneralQueryHandler(session.getGorContext(), false)).setQueryEvaluator((QueryEvaluator)new SessionBasedQueryEvaluator(session));
        SystemContext.Builder systemContextBuilder = new SystemContext.Builder();
        systemContextBuilder.setReportBuilder((GorReportBuilder)new FreemarkerReportBuilder(session)).setRunnerFactory((GorRunnerFactory)new GenericRunnerFactory()).setServer(false).setStartTime(System.currentTimeMillis());
        GorSessionCache cache = GorSessionCacheManager.getCache(requestId);
        session.init(projectContextBuilder.build(), systemContextBuilder.build(), cache);
        return session;
    }
}

