/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function0;
import scala.Unit;

public class ParallelExecutor {
    private Throwable firstException;
    private final Thread[] threads;
    private final Function0<Unit>[] commands;

    public ParallelExecutor(int workers, Function0<Unit>[] commands) {
        this.commands = commands;
        this.threads = new Thread[workers];
        this.firstException = null;
    }

    public void parallelExecute() throws Throwable {
        ConcurrentLinkedQueue<Function0<Unit>> clq = new ConcurrentLinkedQueue<Function0<Unit>>(Arrays.asList(this.commands));
        for (int i = 0; i < this.threads.length; ++i) {
            Thread t = new Thread(() -> {
                Function0 func = (Function0)clq.poll();
                while (func != null) {
                    func.apply();
                    func = (Function0)clq.poll();
                }
            }, "ParallelExecutorThread-" + i);
            t.setUncaughtExceptionHandler(this::parallelExcecuteUncaughtExceptionHandler);
            t.start();
            this.threads[i] = t;
        }
        for (Thread t : this.threads) {
            t.join();
            if (this.firstException == null) continue;
            throw this.firstException;
        }
    }

    private synchronized void parallelExcecuteUncaughtExceptionHandler(Thread thread, Throwable throwable) {
        if (this.firstException == null) {
            this.firstException = throwable;
            for (Thread t : this.threads) {
                if (t == thread) continue;
                t.interrupt();
            }
        }
    }
}

