/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import cern.jet.stat.Probability;
import org.apache.commons.math3.util.FastMath;

public class StatisticalAdjustment {
    private static final double CHI_INV_HALF = 0.4549364231195736;
    private static final double EULER_MASCHERONI = 0.5772156649015329;

    private StatisticalAdjustment() {
    }

    public static double genomic_control_correct_z(double z, double invSqrtLambda) {
        return 2.0 * Probability.normal((double)(-z * invSqrtLambda));
    }

    public static double genomic_control_correct_p(double pValue, double invSqrtLambda) {
        return StatisticalAdjustment.genomic_control_correct_z(Math.abs(Probability.normalInverse((double)(pValue / 2.0))), invSqrtLambda);
    }

    public static double getInvSqrtLambda_p(double[] p) {
        int n = p.length;
        int mIdx = n >>> 1;
        double denom = (n & 1) == 0 ? (StatisticalAdjustment.squared(Probability.normalInverse((double)(p[mIdx - 1] / 2.0))) + StatisticalAdjustment.squared(Probability.normalInverse((double)(p[mIdx] / 2.0)))) / 2.0 : StatisticalAdjustment.squared(Probability.normalInverse((double)(p[mIdx] / 2.0)));
        return Math.sqrt(0.4549364231195736 / denom);
    }

    public static double bonferroni(double pValue, int len) {
        return Math.min(pValue * (double)len, 1.0);
    }

    public static void holm_bonferroni(double[] pValues, double[] holm) {
        int i;
        int mult = pValues.length;
        double adjP = Double.NEGATIVE_INFINITY;
        for (i = 0; i < pValues.length && !((adjP = Math.max(adjP, (double)mult * pValues[i])) > 1.0); ++i) {
            holm[i] = adjP;
            --mult;
        }
        while (i < pValues.length) {
            holm[i++] = 1.0;
        }
    }

    public static double sidak_ss(double pValue, int len) {
        return 1.0 - StatisticalAdjustment.pow(1.0 - pValue, len);
    }

    public static void sidak_sd(double[] pValues, double[] sidak) {
        int n;
        int k = n = pValues.length;
        double last = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            sidak[i] = last = Math.max(1.0 - StatisticalAdjustment.pow(1.0 - pValues[i], k--), last);
        }
    }

    public static void benjamini_hochberg(double[] pValues, double[] bh) {
        int m = pValues.length;
        if (m == 0) {
            return;
        }
        double last_bh = Double.POSITIVE_INFINITY;
        int n = m;
        while (n != 0) {
            bh[--n] = last_bh = Math.min(last_bh, (double)m / (double)n * pValues[n]);
        }
    }

    public static void benjamini_yekutieli(double[] pValues, double[] by) {
        double last_by;
        int n;
        double mcm;
        block3: {
            int m = pValues.length;
            if (m == 0) {
                return;
            }
            mcm = (double)m * StatisticalAdjustment.harmonic(m);
            n = m;
            do {
                double d;
                last_by = mcm / (double)n * pValues[--n];
                if (!(d > 1.0)) break block3;
                by[n] = 1.0;
            } while (n != 0);
            return;
        }
        by[n] = last_by;
        while (n != 0) {
            by[--n] = last_by = Math.min(last_by, mcm / (double)n * pValues[n]);
        }
    }

    static double pow(double b, int e) {
        if (e == 0) {
            return 1.0;
        }
        double res = 1.0;
        double mult = b;
        while (true) {
            if ((e & 1) == 1) {
                res *= mult;
            }
            if ((e >>>= 1) == 0) break;
            mult *= mult;
        }
        return res;
    }

    static double squared(double a) {
        return a * a;
    }

    static double harmonic(int n) {
        if (n < 10) {
            switch (n) {
                case 1: {
                    return 1.0;
                }
                case 2: {
                    return 1.5;
                }
                case 3: {
                    return 1.8333333333333333;
                }
                case 4: {
                    return 2.0833333333333335;
                }
                case 5: {
                    return 2.283333333333333;
                }
                case 6: {
                    return 2.45;
                }
                case 7: {
                    return 2.592857142857143;
                }
                case 8: {
                    return 2.717857142857143;
                }
                case 9: {
                    return 2.828968253968254;
                }
            }
            throw new IllegalArgumentException();
        }
        double rec_n2 = 1.0 / (double)(n * n);
        return FastMath.log((double)n) + 0.5772156649015329 + 1.0 / (double)(2 * n) + rec_n2 * (-0.08333333333333333 + rec_n2 * (0.008333333333333333 + rec_n2 * (-0.003968253968253968 + rec_n2 * (0.004166666666666667 + rec_n2 * (-0.007575757575757576 + rec_n2 * 691.0 / 32760.0)))));
    }

    public static void invert(int[] perm) {
        boolean[] covered = new boolean[perm.length];
        int i = 0;
        while (i < perm.length) {
            int j = i;
            int jth = perm[j];
            while (jth != i) {
                int tmp = perm[jth];
                perm[jth] = j;
                covered[jth] = true;
                j = jth;
                jth = tmp;
            }
            perm[i] = j;
            covered[i++] = true;
            while (i < perm.length && covered[i]) {
                ++i;
            }
        }
    }
}

