/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.clients;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.driver.meta.DataType;
import org.gorpipe.gor.driver.meta.FileNature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileCacheClient
implements FileCache {
    private static final Logger log = LoggerFactory.getLogger(LocalFileCacheClient.class);
    private final Path rootPath;
    private final boolean useSubFolders;
    private final int subFolderSize;
    private final Cache<String, String> cache;

    public LocalFileCacheClient(Path rootPath, boolean useSubFolders, int subFolderSize) {
        this.rootPath = rootPath;
        this.useSubFolders = useSubFolders;
        this.subFolderSize = subFolderSize;
        this.cache = this.createCache();
    }

    public LocalFileCacheClient(Path rootPath) {
        this(rootPath, false, 0);
    }

    public String lookupFile(String fingerprint) {
        try {
            return (String)this.cache.get((Object)fingerprint, () -> this.findFileFromFingerPrint(fingerprint));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String store(Path from, String fingerprint, String ext, long cost) {
        return this.storeWithSpecificCacheFilename(from, fingerprint, from.getFileName().toString(), cost);
    }

    public String storeWithSpecificCacheFilename(Path path, String fingerprint, String cacheFilename, long cost) {
        try {
            Path subFolder = this.getFolderFromFingerprint(fingerprint, true);
            Path cacheFile = Paths.get(subFolder.toString(), cacheFilename);
            String resultPath = this.moveFile(path, cacheFile);
            if (!StringUtils.isEmpty((CharSequence)resultPath)) {
                this.cache.put((Object)fingerprint, (Object)resultPath);
            }
            if (!cacheFilename.contains(fingerprint)) {
                File md5File = new File(subFolder.toString(), fingerprint + ".md5link");
                FileUtils.writeStringToFile((File)md5File, (String)resultPath, (Charset)Charset.defaultCharset());
            }
            return resultPath;
        }
        catch (IOException ioe) {
            log.error("Error when attempting to store file in cache", (Throwable)ioe);
            return null;
        }
    }

    public String storeSibling(Path path, String fingerprint) {
        try {
            String lookupFilePath = this.lookupFile(fingerprint);
            String lookupFileName = Paths.get(lookupFilePath, new String[0]).getFileName().toString();
            String parentFilePath = Paths.get(lookupFilePath, new String[0]).getParent().toString();
            String fromName = path.getFileName().toString();
            String fromNewName = fingerprint + fromName.substring(fromName.indexOf(46));
            if (!fromName.equalsIgnoreCase(lookupFileName) && !lookupFileName.equalsIgnoreCase(fromNewName)) {
                Path to = Paths.get(parentFilePath, fromNewName);
                this.moveFile(path, to);
                return to.toString();
            }
        }
        catch (IOException ioe) {
            log.error("Error when attempting to store a sibling file in cache", (Throwable)ioe);
        }
        return null;
    }

    public String tempLocation(String fingerprint, String ext) {
        try {
            return Paths.get(this.getFolderFromFingerprint(fingerprint, true).toString(), fingerprint + ext).toString();
        }
        catch (IOException ioe) {
            log.error("Error when attempting return temp location", (Throwable)ioe);
            return null;
        }
    }

    public String[] multiLookup(String[] fingerprints, boolean defer) {
        String[] results = new String[fingerprints.length];
        for (int i = 0; i < fingerprints.length; ++i) {
            results[i] = this.lookupFile(fingerprints[i]);
        }
        return results;
    }

    private Path getFolderFromFingerprint(String fingerprint, boolean createSubFolder) throws IOException {
        if (fingerprint.length() < this.subFolderSize) {
            throw new IllegalArgumentException(String.format("Invalid fingerprint: %1$s, needs to be at least %2$d characters", fingerprint, this.subFolderSize));
        }
        if (this.useSubFolders) {
            Path resultPath = Paths.get(this.rootPath.toString(), fingerprint.substring(0, this.subFolderSize));
            if (createSubFolder) {
                Files.createDirectories(resultPath, new FileAttribute[0]);
            }
            return resultPath;
        }
        return this.rootPath;
    }

    private Cache<String, String> createCache() {
        RemovalListener removalNotifier = notification -> log.debug("Removing file from cache, fingerprint: {}, file: {}, cause: {}", new Object[]{notification.getKey(), notification.getValue(), notification.getCause()});
        return CacheBuilder.newBuilder().removalListener(removalNotifier).build();
    }

    private String findFileFromFingerPrint(String fingerprint) throws IOException {
        Path storageFolder = this.getFolderFromFingerprint(fingerprint, false);
        File dir = new File(storageFolder.toString());
        WildcardFileFilter fileFilter = new WildcardFileFilter(fingerprint + "*");
        File[] files = dir.listFiles((FileFilter)fileFilter);
        String foundFile = null;
        if (files != null && files.length > 0) {
            for (File file : files) {
                DataType dataType;
                if (foundFile != null || (dataType = DataType.fromFileName((String)file.getName())) == null) continue;
                if (dataType.nature == FileNature.MD5_LINK) {
                    foundFile = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()).trim();
                    continue;
                }
                if (dataType.nature != FileNature.VARIANTS && dataType.nature != FileNature.TABLE) continue;
                foundFile = file.toString();
            }
            if (foundFile == null) {
                log.warn("Found more than one file for fingerprint {} and none of them is a valid data file.", (Object)fingerprint);
            }
        }
        return foundFile;
    }

    private String moveFile(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException am) {
            log.warn("Falling back to non-atomic storage ({} -> {})", (Object)from.toAbsolutePath(), (Object)to.toAbsolutePath());
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
        return to.toString();
    }

    public void close() throws Exception {
        this.cache.cleanUp();
    }
}

