/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.function;

import gorsat.Commands.Analysis;
import gorsat.process.GenericSessionFactory;
import gorsat.process.PipeInstance;
import gorsat.process.PipeOptions;
import java.io.Serializable;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gorpipe.gor.function.ListRowAdaptor;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorSession;

public class GorRowQueryFunction
implements Function<Row, Stream<Row>>,
AutoCloseable,
Serializable {
    String query;
    protected String header;
    protected ListRowAdaptor lra;
    protected Analysis bufferedPipeStep;

    public GorRowQueryFunction(String query) {
        this(query, "CHROM\tPOS");
    }

    public GorRowQueryFunction(String query, String inputHeader) {
        this.query = query;
        this.header = inputHeader;
    }

    public String getHeader(String inputHeader) {
        PipeInstance pi = this.init(inputHeader);
        return pi.getHeader();
    }

    public String getHeader() {
        return this.getHeader(this.header);
    }

    public PipeInstance init(String header) {
        String[] args = new String[]{this.query, "-stdin"};
        PipeOptions pipeOptions = new PipeOptions();
        pipeOptions.parseOptions(args);
        GenericSessionFactory gsf = new GenericSessionFactory();
        GorSession gps = gsf.create();
        PipeInstance pi = new PipeInstance(gps.getGorContext());
        pi.init(pipeOptions.query(), pipeOptions.stdIn(), header, pipeOptions.fileSignature(), pipeOptions.virtualFile());
        return pi;
    }

    public void initAdaptor() {
        PipeInstance pi = this.init(this.header);
        Analysis pipeStep = pi.thePipeStep();
        this.lra = new ListRowAdaptor();
        this.bufferedPipeStep = pipeStep != null ? pipeStep.$bar((Analysis)this.lra) : this.lra;
        this.bufferedPipeStep.securedSetup(null);
    }

    @Override
    public Stream<Row> apply(Row row) {
        if (this.lra == null) {
            this.initAdaptor();
        } else {
            this.lra.clear();
        }
        if (row.pos == -1) {
            this.close();
        }
        this.bufferedPipeStep.process(row);
        return this.lra.stream();
    }

    @Override
    public void close() {
        this.bufferedPipeStep.securedFinish(null);
    }
}

