/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.gava;

import java.util.List;
import org.gorpipe.gor.gava.CollapsedCounts;
import org.gorpipe.gor.gava.VariantCounts;

public abstract class GavaLogLikelihood {
    protected double upperFreqThreshold = 0.3;
    protected int controlPenetrance = -1;
    protected int casePenetrance = -1;
    protected boolean noMaxAlleleCounts = false;
    protected boolean includeProtective = false;
    protected int numCases;
    protected int numControls;

    public void setSubjectCounts(int numCases, int numControls) {
        this.numCases = numCases;
        this.numControls = numControls;
    }

    public void setPenetrance(int controlPenetrance, int casePenetrance, boolean noMaxAlleleCounts) {
        this.controlPenetrance = controlPenetrance;
        this.casePenetrance = casePenetrance;
        this.noMaxAlleleCounts = noMaxAlleleCounts;
    }

    public void setUpperFreqThreshold(double upperFreqThreshold) {
        this.upperFreqThreshold = upperFreqThreshold;
    }

    public void setIncludeProtective(boolean includeProtective) {
        this.includeProtective = includeProtective;
    }

    public abstract double computeLogLikelihood(List<CollapsedCounts> var1, int[] var2, boolean var3);

    public double calcVariantLogLikelihood(VariantCounts counts, int[] perm) {
        int numSubjects = perm.length;
        int caseCopies = 0;
        int controlCopies = 0;
        for (int i = 0; i < numSubjects; ++i) {
            if (i < this.numControls) {
                controlCopies += counts.callCounts[perm[i]];
                continue;
            }
            caseCopies += counts.callCounts[perm[i]];
        }
        int allCopies = caseCopies + controlCopies;
        double p = (double)allCopies / (double)(2 * numSubjects);
        double pA = (double)caseCopies / (double)(2 * this.numCases);
        double pU = Math.min((double)controlCopies / (double)(2 * this.numControls), this.upperFreqThreshold);
        double logDiff = 0.0;
        if (this.includeProtective || pA > pU) {
            logDiff = Math.log(counts.altScore) - Math.log(counts.nullScore);
            if (pA > 0.0 && pA < 1.0) {
                logDiff += (double)caseCopies * Math.log(pA) + (double)(2 * this.numCases - caseCopies) * Math.log(1.0 - pA);
            }
            if (pU > 0.0 && pU < 1.0) {
                logDiff += (double)controlCopies * Math.log(pU) + (double)(2 * this.numControls - controlCopies) * Math.log(1.0 - pU);
            }
            if (p > 0.0 && p < 1.0) {
                logDiff -= (double)allCopies * Math.log(p) + (double)(2 * numSubjects - allCopies) * Math.log(1.0 - p);
            }
        }
        return logDiff;
    }
}

