/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.gava;

import cern.jet.stat.Probability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;
import org.gorpipe.gor.gava.CollapsedCounts;
import org.gorpipe.gor.gava.CombinationIterator;
import org.gorpipe.gor.gava.DominantLogLikelihood;
import org.gorpipe.gor.gava.GavaLogLikelihood;
import org.gorpipe.gor.gava.RecessiveLogLikelihood;
import org.gorpipe.gor.gava.RegularLogLikelihood;
import org.gorpipe.gor.gava.VariantCounts;
import org.gorpipe.gor.monitor.CancelMonitor;

public class VariantAssociation {
    private static final Double EPSILON = 1.0E-16;
    private int maxIterations = 1000;
    private int bailOutAfter = 51;
    private int collapseThreshold = 5;
    protected boolean includeProtective = false;
    private GavaLogLikelihood gavaLogLikelihood;
    private CancelMonitor cancelMonitor;
    private boolean debug;
    private String[] pns;
    private int numCases;
    private int numControls;
    private HashMap<String, Integer> pn2index;
    private HashMap<String, VariantCounts> site2counts;

    public void setPnLists(String[] cases, String[] controls) {
        this.numCases = cases.length;
        this.numControls = controls.length;
        this.pns = new String[this.numCases + this.numControls];
        System.arraycopy(controls, 0, this.pns, 0, this.numControls);
        System.arraycopy(cases, 0, this.pns, this.numControls, this.numCases);
        this.pn2index = new HashMap(this.pns.length);
        for (int i = 0; i < this.pns.length; ++i) {
            this.pn2index.put(this.pns[i], i);
        }
        this.site2counts = new HashMap();
    }

    public void setModel(boolean recessiveDisease, boolean dominantDisease, int controlPenetrance, int casePenetrance, boolean noMaxAlleleCounts, double upperFreqThreshold, boolean includeProtective) {
        this.gavaLogLikelihood = recessiveDisease ? new RecessiveLogLikelihood() : (dominantDisease ? new DominantLogLikelihood() : new RegularLogLikelihood());
        this.gavaLogLikelihood.setPenetrance(controlPenetrance, casePenetrance, noMaxAlleleCounts);
        this.gavaLogLikelihood.setUpperFreqThreshold(upperFreqThreshold);
        this.includeProtective = includeProtective;
        this.gavaLogLikelihood.setIncludeProtective(includeProtective);
    }

    public void setNumRandomIterations(int maxIterations, int bailOutAfter) {
        this.maxIterations = maxIterations;
        this.bailOutAfter = bailOutAfter;
    }

    public void setCollapseThreshold(int collapseThreshold) {
        this.collapseThreshold = collapseThreshold;
    }

    public void setCancelMonitor(CancelMonitor cancelMonitor) {
        this.cancelMonitor = cancelMonitor;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void initializeGroup() {
        this.site2counts.clear();
    }

    public void addVariant(String variantString) {
        double altScore;
        String[] cols = variantString.split("\t");
        String hash = cols[0];
        String pn = cols[1];
        int callCopies = Integer.parseInt(cols[2]);
        double nullScore = cols.length > 4 ? Double.parseDouble(cols[4]) : 1.0;
        double d = altScore = cols.length > 5 ? Double.parseDouble(cols[5]) : 1.0;
        if (this.pn2index.containsKey(pn)) {
            int index = this.pn2index.get(pn);
            if (!this.site2counts.containsKey(hash)) {
                this.site2counts.put(hash, new VariantCounts(new int[this.pns.length], nullScore, altScore));
            }
            int n = index;
            this.site2counts.get((Object)hash).callCounts[n] = this.site2counts.get((Object)hash).callCounts[n] + callCopies;
        }
    }

    public String calculateValues() {
        double permPval;
        VariantCounts[] variantCounts = this.site2counts.values().toArray(new VariantCounts[this.site2counts.size()]);
        if (!this.includeProtective) {
            variantCounts = this.filterVariants(variantCounts);
        }
        Arrays.sort(variantCounts, Comparator.comparingDouble(o -> o.nullScore));
        this.gavaLogLikelihood.setSubjectCounts(this.numCases, this.numControls);
        int[] perm = new int[this.pns.length];
        for (int i = 0; i < this.pns.length; ++i) {
            perm[i] = i;
        }
        double baseValue = this.computeTestStatistic(variantCounts, perm, this.debug);
        int counter = 0;
        int iter = 0;
        if (-baseValue <= 0.05 && -baseValue != 0.0) {
            if (this.pns.length > 1000 || CombinationIterator.getNumberOfCombinations(this.pns.length, this.numControls) > (double)Math.min(this.maxIterations, 10000)) {
                Random random = new Random();
                while (iter < this.maxIterations && counter < this.bailOutAfter) {
                    ++iter;
                    for (int i = this.pns.length; i > 1; --i) {
                        int r = random.nextInt(i);
                        int temp = perm[r];
                        perm[r] = perm[i - 1];
                        perm[i - 1] = temp;
                    }
                    double randomValue = this.computeTestStatistic(variantCounts, perm, false);
                    if (randomValue + EPSILON >= baseValue) {
                        ++counter;
                    }
                    if (this.cancelMonitor == null || !this.cancelMonitor.isCancelled()) continue;
                    break;
                }
            } else {
                CombinationIterator combit = new CombinationIterator(this.pns.length, this.numControls);
                while (combit.next()) {
                    ++iter;
                    double combValue = this.computeTestStatistic(variantCounts, combit.getPermutation(), false);
                    if (combValue + EPSILON >= baseValue) {
                        ++counter;
                    }
                    if (this.cancelMonitor == null || !this.cancelMonitor.isCancelled()) continue;
                    break;
                }
            }
            permPval = (double)counter / (double)iter;
        } else {
            permPval = -baseValue;
            if (baseValue == -0.0) {
                baseValue = -1.0;
            }
        }
        double chiPval = -baseValue;
        if (this.debug) {
            System.err.println("Returning values:\t" + chiPval + "\t" + permPval + "\t" + iter);
        }
        if (permPval < chiPval) {
            permPval = chiPval;
        }
        if (permPval == 0.0) {
            permPval = chiPval;
        }
        return chiPval + "\t" + permPval + "\t" + iter;
    }

    private double computeTestStatistic(VariantCounts[] variantCounts, int[] perm, boolean isDebug) {
        ArrayList<CollapsedCounts> collapsedCounts = this.groupVariants(variantCounts, perm);
        double chi2 = -2.0 * this.gavaLogLikelihood.computeLogLikelihood(collapsedCounts, perm, isDebug);
        return -Probability.chiSquareComplemented((double)collapsedCounts.size(), (double)chi2);
    }

    private VariantCounts[] filterVariants(VariantCounts[] variantCounts) {
        ArrayList<VariantCounts> filteredCounts = new ArrayList<VariantCounts>();
        for (VariantCounts varCounts : variantCounts) {
            int[] counts = varCounts.callCounts;
            int caseCopies = 0;
            int controlCopies = 0;
            for (int i = 0; i < this.numControls + this.numCases; ++i) {
                if (i < this.numControls) {
                    controlCopies += counts[i];
                    continue;
                }
                caseCopies += counts[i];
            }
            double pA = (double)caseCopies / (double)(2 * this.numCases);
            double pU = (double)controlCopies / (double)(2 * this.numControls);
            if (!(pA > pU)) continue;
            filteredCounts.add(varCounts);
        }
        return filteredCounts.toArray(new VariantCounts[filteredCounts.size()]);
    }

    private ArrayList<CollapsedCounts> groupVariants(VariantCounts[] variantCounts, int[] perm) {
        int[] counts = this.getCaseCounts(variantCounts, perm);
        CollapsedCounts lastTooFew = null;
        int tooFewSum = 0;
        ArrayList<CollapsedCounts> collapsedCounts = new ArrayList<CollapsedCounts>();
        for (int j = 0; j < variantCounts.length; ++j) {
            double lrValue = this.gavaLogLikelihood.calcVariantLogLikelihood(variantCounts[j], perm);
            if (!(lrValue > 0.0)) continue;
            if (counts[j] < this.collapseThreshold) {
                if (lastTooFew != null && tooFewSum < this.collapseThreshold) {
                    lastTooFew.addVariant(variantCounts[j]);
                    tooFewSum += counts[j];
                    continue;
                }
                lastTooFew = new CollapsedCounts(variantCounts[j]);
                collapsedCounts.add(lastTooFew);
                tooFewSum = counts[j];
                continue;
            }
            collapsedCounts.add(new CollapsedCounts(variantCounts[j]));
        }
        return collapsedCounts;
    }

    private int[] getCaseCounts(VariantCounts[] variantCounts, int[] perm) {
        int[] alleleCounts = new int[variantCounts.length];
        for (int j = 0; j < variantCounts.length; ++j) {
            int[] counts = variantCounts[j].callCounts;
            for (int i = this.numControls; i < perm.length; ++i) {
                int n = j;
                alleleCounts[n] = alleleCounts[n] + counts[perm[i]];
            }
        }
        return alleleCounts;
    }
}

