/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table.files;

import gorsat.process.CLIGorExecutionEngine;
import gorsat.process.PipeOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.TableHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorTable<T extends Row>
extends BaseTable<T> {
    private static final Logger log = LoggerFactory.getLogger(GorTable.class);
    Path tempOutFilePath;

    public GorTable(BaseTable.Builder builder) {
        super(builder);
        this.init();
    }

    public GorTable(URI uri, FileReader inputFileReader) {
        super(uri, inputFileReader);
        this.init();
    }

    public GorTable(URI uri) {
        this(uri, null);
    }

    private void init() {
        this.header = new TableHeader();
        if (this.fileReader.exists(this.getPath().toString())) {
            this.validateFile(this.getPath().toString());
        }
        this.reload();
    }

    public void insert(Collection<T> lines) {
        Path tempInputFile;
        try {
            tempInputFile = this.createInputTempFile(lines);
        }
        catch (IOException e) {
            throw new GorSystemException("Could not create temp file for inserting data", (Throwable)e);
        }
        this.insert(tempInputFile.toUri());
    }

    public void insert(URI gorFile) {
        if (this.isValidateFiles()) {
            this.validateFile(gorFile.toString());
        }
        String gorPipeCommand = this.createInsertTempFileCommand(gorFile);
        this.runMergeCommand(gorPipeCommand);
    }

    public void delete(Collection lines) {
        throw new GorSystemException("Not implemented", null);
    }

    public void saveMainFile() {
        try {
            if (this.tempOutFilePath != null && Files.exists(this.tempOutFilePath, new LinkOption[0])) {
                this.updateFromTempFile(this.getPathUri(), this.tempOutFilePath.toUri());
                Files.delete(this.getTransactionFolderPath());
            } else if (!Files.exists(this.getPath(), new LinkOption[0])) {
                this.writeToFile(this.getPath(), new ArrayList());
            }
        }
        catch (IOException e) {
            throw new GorSystemException("Could not save table", (Throwable)e);
        }
    }

    public void initialize() {
        super.initialize();
    }

    private Path getTransactionFolderPath() {
        return Path.of(this.getFolderPath().toString(), "transactions");
    }

    private Path createInputTempFile(Collection<T> lines) throws IOException {
        String randomString = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
        Path tempFilePath = this.getTransactionFolderPath().resolve("insert_temp_" + randomString + ".gor");
        this.fileReader.createDirectories(tempFilePath.getParent().toString(), new FileAttribute[0]);
        this.writeToFile(tempFilePath, lines);
        return tempFilePath;
    }

    private void writeToFile(Path filePath, Collection<T> lines) throws IOException {
        try (OutputStream os = this.fileReader.getOutputStream(filePath.toString());){
            os.write(35);
            os.write(Stream.of(this.getColumns()).collect(Collectors.joining("\t")).getBytes(StandardCharsets.UTF_8));
            os.write(10);
            for (Row r : lines) {
                os.write(r.getAllCols().toString().getBytes(StandardCharsets.UTF_8));
                os.write(10);
            }
        }
    }

    private String createInsertTempFileCommand(URI insertFile) {
        Path mainFile = this.tempOutFilePath == null ? this.getPath() : this.tempOutFilePath;
        String randomString = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
        this.tempOutFilePath = this.getTransactionFolderPath().resolve(String.format("result_temp_%s.%s", randomString, FilenameUtils.getExtension((String)this.getPath().toString())));
        String command = String.format("gor %s %s | write %s", mainFile, insertFile.toString(), this.tempOutFilePath);
        return command;
    }

    private void runMergeCommand(String gorPipeCommand) {
        Object[] args = new String[]{gorPipeCommand, "-workers", "1"};
        log.trace("Calling bucketize with command args: \"{}\" {} {}", args);
        PipeOptions options = new PipeOptions();
        options.parseOptions((String[])args);
        CLIGorExecutionEngine engine = new CLIGorExecutionEngine(options, null, this.getSecurityContext());
        engine.execute();
    }
}

