/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.argument;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;

public class DateArgument
extends Argument {
    public static final String PROPERTY_DATE_VALUE = "dateValue";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    public DateArgument(ArgumentDescription argDescr, Boolean optional, Object defaultValue, List<? extends Object> allowedValues, List<String> operators, Boolean advanced, Integer displayWidth) {
        super(ArgumentType.DATE, argDescr, optional, defaultValue, allowedValues, null, operators, advanced, displayWidth);
    }

    public DateArgument(DateArgument arg) {
        super(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object parseValue(String val) {
        try {
            DateFormat dateFormat = FORMATTER;
            synchronized (dateFormat) {
                return FORMATTER.parseObject(val);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date format", e);
        }
    }

    @Override
    public DateArgument copyArgument() {
        return new DateArgument(this);
    }
}

