/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.templating;

import freemarker.cache.TemplateLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.gorpipe.gor.model.FileReader;

public class NetworkTemplateLoader
implements TemplateLoader {
    private String basePath;
    private final FileReader fileResolver;

    public NetworkTemplateLoader(String basePath, FileReader fileResolver) {
        this.fileResolver = fileResolver;
        this.basePath = basePath;
        if (!this.basePath.endsWith("/")) {
            this.basePath = this.basePath + "/";
        }
    }

    public Object findTemplateSource(String name) throws IOException {
        try {
            BufferedReader r = this.fileResolver.getReader(this.basePath + name);
            if (r != null) {
                ((Reader)r).close();
            }
        }
        catch (IOException e) {
            return null;
        }
        return new NetworkTemplateSource(this.basePath + name);
    }

    public long getLastModified(Object templateSource) {
        return ((NetworkTemplateSource)templateSource).lastModified;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        NetworkTemplateSource source = (NetworkTemplateSource)templateSource;
        if (source.reader == null) {
            source.reader = this.fileResolver.getReader(source.path);
        }
        return source.reader;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        NetworkTemplateSource source = (NetworkTemplateSource)templateSource;
        if (source.reader != null) {
            source.reader.close();
            source.reader = null;
        }
    }

    private static class NetworkTemplateSource {
        private final String path;
        private final long lastModified;
        private Reader reader;

        public NetworkTemplateSource(String path) {
            this.path = path;
            this.lastModified = System.currentTimeMillis();
        }
    }
}

