
/*
 *  BEGIN_COPYRIGHT
 *
 *  Copyright (C) 2011-2013 deCODE genetics Inc.
 *  Copyright (C) 2013-2019 WuXi NextCode Inc.
 *  All Rights Reserved.
 *
 *  GORpipe is free software: you can redistribute it and/or modify
 *  it under the terms of the AFFERO GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  GORpipe is distributed "AS-IS" AND WITHOUT ANY WARRANTY OF ANY KIND,
 *  INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 *  NON-INFRINGEMENT, OR FITNESS FOR A PARTICULAR PURPOSE. See
 *  the AFFERO GNU General Public License for the complete license terms.
 *
 *  You should have received a copy of the AFFERO GNU General Public License
 *  along with GORpipe.  If not, see <http://www.gnu.org/licenses/agpl-3.0.html>
 *
 *  END_COPYRIGHT
 */

// This file is generated from a Python script - do not modify!!!
package gorsat.parser

import gorsat.parser.FunctionTypes._
    

object FunctionSignature {
    

  // The following are helper functions for getting the signature of a Calc function that
  // requires an owner, that is a ParseArith instance. The signature as far as the parser is
  // concerned is the same as if there is no owner argument. Note that the function returned
  // is a dummy - don't use it for anything but passing to the appropriate getSignature
  // function. Note also that you must use registerWithOwner when registering.
  
  def removeOwner[R](f: (ParseArith) => R): () => R = {
    def dummy(): R = f(null)
    dummy _
  }

  def removeOwner[A1, R](f: (ParseArith, A1) => R): (A1) => R = {
    def dummy(ex1: A1): R = f(null, ex1)
    dummy
  }

  def removeOwner[A1, A2, R](f: (ParseArith, A1, A2) => R): (A1, A2) => R = {
    def dummy(ex1: A1, ex2: A2): R = f(null, ex1, ex2)
    dummy
  }

  def removeOwner[A1, A2, A3, R](f: (ParseArith, A1, A2, A3) => R): (A1, A2, A3) => R = {
    def dummy(ex1: A1, ex2: A2, ex3: A3): R = f(null, ex1, ex2, ex3)
    dummy
  }

  def removeOwner[A1, A2, A3, A4, R](f: (ParseArith, A1, A2, A3, A4) => R): (A1, A2, A3, A4) => R = {
    def dummy(ex1: A1, ex2: A2, ex3: A3, ex4: A4): R = f(null, ex1, ex2, ex3, ex4)
    dummy
  }

  def getSignatureStringStringList2Boolean(f: (sFun, List[String]) => bFun) = getSignature(List(StringFun, StringList), BooleanFun)
  def getSignatureStringStringList2Int(f: (sFun, List[String]) => iFun) = getSignature(List(StringFun, StringList), IntFun)
    
  def getSignatureEmpty2Int(f: () => iFun): String = getSignature(List(), IntFun)
  def getSignatureEmpty2Long(f: () => lFun): String = getSignature(List(), LongFun)
  def getSignatureEmpty2Double(f: () => dFun): String = getSignature(List(), DoubleFun)
  def getSignatureEmpty2String(f: () => sFun): String = getSignature(List(), StringFun)
  def getSignatureEmpty2Boolean(f: () => bFun): String = getSignature(List(), BooleanFun)
  def getSignatureInt2Int(f: (iFun) => iFun): String = getSignature(List(IntFun), IntFun)
  def getSignatureLong2Int(f: (lFun) => iFun): String = getSignature(List(LongFun), IntFun)
  def getSignatureDouble2Int(f: (dFun) => iFun): String = getSignature(List(DoubleFun), IntFun)
  def getSignatureString2Int(f: (sFun) => iFun): String = getSignature(List(StringFun), IntFun)
  def getSignatureBoolean2Int(f: (bFun) => iFun): String = getSignature(List(BooleanFun), IntFun)
  def getSignatureInt2Long(f: (iFun) => lFun): String = getSignature(List(IntFun), LongFun)
  def getSignatureLong2Long(f: (lFun) => lFun): String = getSignature(List(LongFun), LongFun)
  def getSignatureDouble2Long(f: (dFun) => lFun): String = getSignature(List(DoubleFun), LongFun)
  def getSignatureString2Long(f: (sFun) => lFun): String = getSignature(List(StringFun), LongFun)
  def getSignatureBoolean2Long(f: (bFun) => lFun): String = getSignature(List(BooleanFun), LongFun)
  def getSignatureInt2Double(f: (iFun) => dFun): String = getSignature(List(IntFun), DoubleFun)
  def getSignatureLong2Double(f: (lFun) => dFun): String = getSignature(List(LongFun), DoubleFun)
  def getSignatureDouble2Double(f: (dFun) => dFun): String = getSignature(List(DoubleFun), DoubleFun)
  def getSignatureString2Double(f: (sFun) => dFun): String = getSignature(List(StringFun), DoubleFun)
  def getSignatureBoolean2Double(f: (bFun) => dFun): String = getSignature(List(BooleanFun), DoubleFun)
  def getSignatureInt2String(f: (iFun) => sFun): String = getSignature(List(IntFun), StringFun)
  def getSignatureLong2String(f: (lFun) => sFun): String = getSignature(List(LongFun), StringFun)
  def getSignatureDouble2String(f: (dFun) => sFun): String = getSignature(List(DoubleFun), StringFun)
  def getSignatureString2String(f: (sFun) => sFun): String = getSignature(List(StringFun), StringFun)
  def getSignatureBoolean2String(f: (bFun) => sFun): String = getSignature(List(BooleanFun), StringFun)
  def getSignatureInt2Boolean(f: (iFun) => bFun): String = getSignature(List(IntFun), BooleanFun)
  def getSignatureLong2Boolean(f: (lFun) => bFun): String = getSignature(List(LongFun), BooleanFun)
  def getSignatureDouble2Boolean(f: (dFun) => bFun): String = getSignature(List(DoubleFun), BooleanFun)
  def getSignatureString2Boolean(f: (sFun) => bFun): String = getSignature(List(StringFun), BooleanFun)
  def getSignatureBoolean2Boolean(f: (bFun) => bFun): String = getSignature(List(BooleanFun), BooleanFun)
  def getSignatureIntInt2Int(f: (iFun, iFun) => iFun): String = getSignature(List(IntFun, IntFun), IntFun)
  def getSignatureIntLong2Int(f: (iFun, lFun) => iFun): String = getSignature(List(IntFun, LongFun), IntFun)
  def getSignatureIntDouble2Int(f: (iFun, dFun) => iFun): String = getSignature(List(IntFun, DoubleFun), IntFun)
  def getSignatureIntString2Int(f: (iFun, sFun) => iFun): String = getSignature(List(IntFun, StringFun), IntFun)
  def getSignatureIntBoolean2Int(f: (iFun, bFun) => iFun): String = getSignature(List(IntFun, BooleanFun), IntFun)
  def getSignatureLongInt2Int(f: (lFun, iFun) => iFun): String = getSignature(List(LongFun, IntFun), IntFun)
  def getSignatureLongLong2Int(f: (lFun, lFun) => iFun): String = getSignature(List(LongFun, LongFun), IntFun)
  def getSignatureLongDouble2Int(f: (lFun, dFun) => iFun): String = getSignature(List(LongFun, DoubleFun), IntFun)
  def getSignatureLongString2Int(f: (lFun, sFun) => iFun): String = getSignature(List(LongFun, StringFun), IntFun)
  def getSignatureLongBoolean2Int(f: (lFun, bFun) => iFun): String = getSignature(List(LongFun, BooleanFun), IntFun)
  def getSignatureDoubleInt2Int(f: (dFun, iFun) => iFun): String = getSignature(List(DoubleFun, IntFun), IntFun)
  def getSignatureDoubleLong2Int(f: (dFun, lFun) => iFun): String = getSignature(List(DoubleFun, LongFun), IntFun)
  def getSignatureDoubleDouble2Int(f: (dFun, dFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun), IntFun)
  def getSignatureDoubleString2Int(f: (dFun, sFun) => iFun): String = getSignature(List(DoubleFun, StringFun), IntFun)
  def getSignatureDoubleBoolean2Int(f: (dFun, bFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun), IntFun)
  def getSignatureStringInt2Int(f: (sFun, iFun) => iFun): String = getSignature(List(StringFun, IntFun), IntFun)
  def getSignatureStringLong2Int(f: (sFun, lFun) => iFun): String = getSignature(List(StringFun, LongFun), IntFun)
  def getSignatureStringDouble2Int(f: (sFun, dFun) => iFun): String = getSignature(List(StringFun, DoubleFun), IntFun)
  def getSignatureStringString2Int(f: (sFun, sFun) => iFun): String = getSignature(List(StringFun, StringFun), IntFun)
  def getSignatureStringBoolean2Int(f: (sFun, bFun) => iFun): String = getSignature(List(StringFun, BooleanFun), IntFun)
  def getSignatureBooleanInt2Int(f: (bFun, iFun) => iFun): String = getSignature(List(BooleanFun, IntFun), IntFun)
  def getSignatureBooleanLong2Int(f: (bFun, lFun) => iFun): String = getSignature(List(BooleanFun, LongFun), IntFun)
  def getSignatureBooleanDouble2Int(f: (bFun, dFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun), IntFun)
  def getSignatureBooleanString2Int(f: (bFun, sFun) => iFun): String = getSignature(List(BooleanFun, StringFun), IntFun)
  def getSignatureBooleanBoolean2Int(f: (bFun, bFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun), IntFun)
  def getSignatureIntInt2Long(f: (iFun, iFun) => lFun): String = getSignature(List(IntFun, IntFun), LongFun)
  def getSignatureIntLong2Long(f: (iFun, lFun) => lFun): String = getSignature(List(IntFun, LongFun), LongFun)
  def getSignatureIntDouble2Long(f: (iFun, dFun) => lFun): String = getSignature(List(IntFun, DoubleFun), LongFun)
  def getSignatureIntString2Long(f: (iFun, sFun) => lFun): String = getSignature(List(IntFun, StringFun), LongFun)
  def getSignatureIntBoolean2Long(f: (iFun, bFun) => lFun): String = getSignature(List(IntFun, BooleanFun), LongFun)
  def getSignatureLongInt2Long(f: (lFun, iFun) => lFun): String = getSignature(List(LongFun, IntFun), LongFun)
  def getSignatureLongLong2Long(f: (lFun, lFun) => lFun): String = getSignature(List(LongFun, LongFun), LongFun)
  def getSignatureLongDouble2Long(f: (lFun, dFun) => lFun): String = getSignature(List(LongFun, DoubleFun), LongFun)
  def getSignatureLongString2Long(f: (lFun, sFun) => lFun): String = getSignature(List(LongFun, StringFun), LongFun)
  def getSignatureLongBoolean2Long(f: (lFun, bFun) => lFun): String = getSignature(List(LongFun, BooleanFun), LongFun)
  def getSignatureDoubleInt2Long(f: (dFun, iFun) => lFun): String = getSignature(List(DoubleFun, IntFun), LongFun)
  def getSignatureDoubleLong2Long(f: (dFun, lFun) => lFun): String = getSignature(List(DoubleFun, LongFun), LongFun)
  def getSignatureDoubleDouble2Long(f: (dFun, dFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun), LongFun)
  def getSignatureDoubleString2Long(f: (dFun, sFun) => lFun): String = getSignature(List(DoubleFun, StringFun), LongFun)
  def getSignatureDoubleBoolean2Long(f: (dFun, bFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun), LongFun)
  def getSignatureStringInt2Long(f: (sFun, iFun) => lFun): String = getSignature(List(StringFun, IntFun), LongFun)
  def getSignatureStringLong2Long(f: (sFun, lFun) => lFun): String = getSignature(List(StringFun, LongFun), LongFun)
  def getSignatureStringDouble2Long(f: (sFun, dFun) => lFun): String = getSignature(List(StringFun, DoubleFun), LongFun)
  def getSignatureStringString2Long(f: (sFun, sFun) => lFun): String = getSignature(List(StringFun, StringFun), LongFun)
  def getSignatureStringBoolean2Long(f: (sFun, bFun) => lFun): String = getSignature(List(StringFun, BooleanFun), LongFun)
  def getSignatureBooleanInt2Long(f: (bFun, iFun) => lFun): String = getSignature(List(BooleanFun, IntFun), LongFun)
  def getSignatureBooleanLong2Long(f: (bFun, lFun) => lFun): String = getSignature(List(BooleanFun, LongFun), LongFun)
  def getSignatureBooleanDouble2Long(f: (bFun, dFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun), LongFun)
  def getSignatureBooleanString2Long(f: (bFun, sFun) => lFun): String = getSignature(List(BooleanFun, StringFun), LongFun)
  def getSignatureBooleanBoolean2Long(f: (bFun, bFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun), LongFun)
  def getSignatureIntInt2Double(f: (iFun, iFun) => dFun): String = getSignature(List(IntFun, IntFun), DoubleFun)
  def getSignatureIntLong2Double(f: (iFun, lFun) => dFun): String = getSignature(List(IntFun, LongFun), DoubleFun)
  def getSignatureIntDouble2Double(f: (iFun, dFun) => dFun): String = getSignature(List(IntFun, DoubleFun), DoubleFun)
  def getSignatureIntString2Double(f: (iFun, sFun) => dFun): String = getSignature(List(IntFun, StringFun), DoubleFun)
  def getSignatureIntBoolean2Double(f: (iFun, bFun) => dFun): String = getSignature(List(IntFun, BooleanFun), DoubleFun)
  def getSignatureLongInt2Double(f: (lFun, iFun) => dFun): String = getSignature(List(LongFun, IntFun), DoubleFun)
  def getSignatureLongLong2Double(f: (lFun, lFun) => dFun): String = getSignature(List(LongFun, LongFun), DoubleFun)
  def getSignatureLongDouble2Double(f: (lFun, dFun) => dFun): String = getSignature(List(LongFun, DoubleFun), DoubleFun)
  def getSignatureLongString2Double(f: (lFun, sFun) => dFun): String = getSignature(List(LongFun, StringFun), DoubleFun)
  def getSignatureLongBoolean2Double(f: (lFun, bFun) => dFun): String = getSignature(List(LongFun, BooleanFun), DoubleFun)
  def getSignatureDoubleInt2Double(f: (dFun, iFun) => dFun): String = getSignature(List(DoubleFun, IntFun), DoubleFun)
  def getSignatureDoubleLong2Double(f: (dFun, lFun) => dFun): String = getSignature(List(DoubleFun, LongFun), DoubleFun)
  def getSignatureDoubleDouble2Double(f: (dFun, dFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun), DoubleFun)
  def getSignatureDoubleString2Double(f: (dFun, sFun) => dFun): String = getSignature(List(DoubleFun, StringFun), DoubleFun)
  def getSignatureDoubleBoolean2Double(f: (dFun, bFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun), DoubleFun)
  def getSignatureStringInt2Double(f: (sFun, iFun) => dFun): String = getSignature(List(StringFun, IntFun), DoubleFun)
  def getSignatureStringLong2Double(f: (sFun, lFun) => dFun): String = getSignature(List(StringFun, LongFun), DoubleFun)
  def getSignatureStringDouble2Double(f: (sFun, dFun) => dFun): String = getSignature(List(StringFun, DoubleFun), DoubleFun)
  def getSignatureStringString2Double(f: (sFun, sFun) => dFun): String = getSignature(List(StringFun, StringFun), DoubleFun)
  def getSignatureStringBoolean2Double(f: (sFun, bFun) => dFun): String = getSignature(List(StringFun, BooleanFun), DoubleFun)
  def getSignatureBooleanInt2Double(f: (bFun, iFun) => dFun): String = getSignature(List(BooleanFun, IntFun), DoubleFun)
  def getSignatureBooleanLong2Double(f: (bFun, lFun) => dFun): String = getSignature(List(BooleanFun, LongFun), DoubleFun)
  def getSignatureBooleanDouble2Double(f: (bFun, dFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun), DoubleFun)
  def getSignatureBooleanString2Double(f: (bFun, sFun) => dFun): String = getSignature(List(BooleanFun, StringFun), DoubleFun)
  def getSignatureBooleanBoolean2Double(f: (bFun, bFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun), DoubleFun)
  def getSignatureIntInt2String(f: (iFun, iFun) => sFun): String = getSignature(List(IntFun, IntFun), StringFun)
  def getSignatureIntLong2String(f: (iFun, lFun) => sFun): String = getSignature(List(IntFun, LongFun), StringFun)
  def getSignatureIntDouble2String(f: (iFun, dFun) => sFun): String = getSignature(List(IntFun, DoubleFun), StringFun)
  def getSignatureIntString2String(f: (iFun, sFun) => sFun): String = getSignature(List(IntFun, StringFun), StringFun)
  def getSignatureIntBoolean2String(f: (iFun, bFun) => sFun): String = getSignature(List(IntFun, BooleanFun), StringFun)
  def getSignatureLongInt2String(f: (lFun, iFun) => sFun): String = getSignature(List(LongFun, IntFun), StringFun)
  def getSignatureLongLong2String(f: (lFun, lFun) => sFun): String = getSignature(List(LongFun, LongFun), StringFun)
  def getSignatureLongDouble2String(f: (lFun, dFun) => sFun): String = getSignature(List(LongFun, DoubleFun), StringFun)
  def getSignatureLongString2String(f: (lFun, sFun) => sFun): String = getSignature(List(LongFun, StringFun), StringFun)
  def getSignatureLongBoolean2String(f: (lFun, bFun) => sFun): String = getSignature(List(LongFun, BooleanFun), StringFun)
  def getSignatureDoubleInt2String(f: (dFun, iFun) => sFun): String = getSignature(List(DoubleFun, IntFun), StringFun)
  def getSignatureDoubleLong2String(f: (dFun, lFun) => sFun): String = getSignature(List(DoubleFun, LongFun), StringFun)
  def getSignatureDoubleDouble2String(f: (dFun, dFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun), StringFun)
  def getSignatureDoubleString2String(f: (dFun, sFun) => sFun): String = getSignature(List(DoubleFun, StringFun), StringFun)
  def getSignatureDoubleBoolean2String(f: (dFun, bFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun), StringFun)
  def getSignatureStringInt2String(f: (sFun, iFun) => sFun): String = getSignature(List(StringFun, IntFun), StringFun)
  def getSignatureStringLong2String(f: (sFun, lFun) => sFun): String = getSignature(List(StringFun, LongFun), StringFun)
  def getSignatureStringDouble2String(f: (sFun, dFun) => sFun): String = getSignature(List(StringFun, DoubleFun), StringFun)
  def getSignatureStringString2String(f: (sFun, sFun) => sFun): String = getSignature(List(StringFun, StringFun), StringFun)
  def getSignatureStringBoolean2String(f: (sFun, bFun) => sFun): String = getSignature(List(StringFun, BooleanFun), StringFun)
  def getSignatureBooleanInt2String(f: (bFun, iFun) => sFun): String = getSignature(List(BooleanFun, IntFun), StringFun)
  def getSignatureBooleanLong2String(f: (bFun, lFun) => sFun): String = getSignature(List(BooleanFun, LongFun), StringFun)
  def getSignatureBooleanDouble2String(f: (bFun, dFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun), StringFun)
  def getSignatureBooleanString2String(f: (bFun, sFun) => sFun): String = getSignature(List(BooleanFun, StringFun), StringFun)
  def getSignatureBooleanBoolean2String(f: (bFun, bFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun), StringFun)
  def getSignatureIntInt2Boolean(f: (iFun, iFun) => bFun): String = getSignature(List(IntFun, IntFun), BooleanFun)
  def getSignatureIntLong2Boolean(f: (iFun, lFun) => bFun): String = getSignature(List(IntFun, LongFun), BooleanFun)
  def getSignatureIntDouble2Boolean(f: (iFun, dFun) => bFun): String = getSignature(List(IntFun, DoubleFun), BooleanFun)
  def getSignatureIntString2Boolean(f: (iFun, sFun) => bFun): String = getSignature(List(IntFun, StringFun), BooleanFun)
  def getSignatureIntBoolean2Boolean(f: (iFun, bFun) => bFun): String = getSignature(List(IntFun, BooleanFun), BooleanFun)
  def getSignatureLongInt2Boolean(f: (lFun, iFun) => bFun): String = getSignature(List(LongFun, IntFun), BooleanFun)
  def getSignatureLongLong2Boolean(f: (lFun, lFun) => bFun): String = getSignature(List(LongFun, LongFun), BooleanFun)
  def getSignatureLongDouble2Boolean(f: (lFun, dFun) => bFun): String = getSignature(List(LongFun, DoubleFun), BooleanFun)
  def getSignatureLongString2Boolean(f: (lFun, sFun) => bFun): String = getSignature(List(LongFun, StringFun), BooleanFun)
  def getSignatureLongBoolean2Boolean(f: (lFun, bFun) => bFun): String = getSignature(List(LongFun, BooleanFun), BooleanFun)
  def getSignatureDoubleInt2Boolean(f: (dFun, iFun) => bFun): String = getSignature(List(DoubleFun, IntFun), BooleanFun)
  def getSignatureDoubleLong2Boolean(f: (dFun, lFun) => bFun): String = getSignature(List(DoubleFun, LongFun), BooleanFun)
  def getSignatureDoubleDouble2Boolean(f: (dFun, dFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun), BooleanFun)
  def getSignatureDoubleString2Boolean(f: (dFun, sFun) => bFun): String = getSignature(List(DoubleFun, StringFun), BooleanFun)
  def getSignatureDoubleBoolean2Boolean(f: (dFun, bFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun), BooleanFun)
  def getSignatureStringInt2Boolean(f: (sFun, iFun) => bFun): String = getSignature(List(StringFun, IntFun), BooleanFun)
  def getSignatureStringLong2Boolean(f: (sFun, lFun) => bFun): String = getSignature(List(StringFun, LongFun), BooleanFun)
  def getSignatureStringDouble2Boolean(f: (sFun, dFun) => bFun): String = getSignature(List(StringFun, DoubleFun), BooleanFun)
  def getSignatureStringString2Boolean(f: (sFun, sFun) => bFun): String = getSignature(List(StringFun, StringFun), BooleanFun)
  def getSignatureStringBoolean2Boolean(f: (sFun, bFun) => bFun): String = getSignature(List(StringFun, BooleanFun), BooleanFun)
  def getSignatureBooleanInt2Boolean(f: (bFun, iFun) => bFun): String = getSignature(List(BooleanFun, IntFun), BooleanFun)
  def getSignatureBooleanLong2Boolean(f: (bFun, lFun) => bFun): String = getSignature(List(BooleanFun, LongFun), BooleanFun)
  def getSignatureBooleanDouble2Boolean(f: (bFun, dFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun), BooleanFun)
  def getSignatureBooleanString2Boolean(f: (bFun, sFun) => bFun): String = getSignature(List(BooleanFun, StringFun), BooleanFun)
  def getSignatureBooleanBoolean2Boolean(f: (bFun, bFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun), BooleanFun)
  def getSignatureIntIntInt2Int(f: (iFun, iFun, iFun) => iFun): String = getSignature(List(IntFun, IntFun, IntFun), IntFun)
  def getSignatureIntIntLong2Int(f: (iFun, iFun, lFun) => iFun): String = getSignature(List(IntFun, IntFun, LongFun), IntFun)
  def getSignatureIntIntDouble2Int(f: (iFun, iFun, dFun) => iFun): String = getSignature(List(IntFun, IntFun, DoubleFun), IntFun)
  def getSignatureIntIntString2Int(f: (iFun, iFun, sFun) => iFun): String = getSignature(List(IntFun, IntFun, StringFun), IntFun)
  def getSignatureIntIntBoolean2Int(f: (iFun, iFun, bFun) => iFun): String = getSignature(List(IntFun, IntFun, BooleanFun), IntFun)
  def getSignatureIntLongInt2Int(f: (iFun, lFun, iFun) => iFun): String = getSignature(List(IntFun, LongFun, IntFun), IntFun)
  def getSignatureIntLongLong2Int(f: (iFun, lFun, lFun) => iFun): String = getSignature(List(IntFun, LongFun, LongFun), IntFun)
  def getSignatureIntLongDouble2Int(f: (iFun, lFun, dFun) => iFun): String = getSignature(List(IntFun, LongFun, DoubleFun), IntFun)
  def getSignatureIntLongString2Int(f: (iFun, lFun, sFun) => iFun): String = getSignature(List(IntFun, LongFun, StringFun), IntFun)
  def getSignatureIntLongBoolean2Int(f: (iFun, lFun, bFun) => iFun): String = getSignature(List(IntFun, LongFun, BooleanFun), IntFun)
  def getSignatureIntDoubleInt2Int(f: (iFun, dFun, iFun) => iFun): String = getSignature(List(IntFun, DoubleFun, IntFun), IntFun)
  def getSignatureIntDoubleLong2Int(f: (iFun, dFun, lFun) => iFun): String = getSignature(List(IntFun, DoubleFun, LongFun), IntFun)
  def getSignatureIntDoubleDouble2Int(f: (iFun, dFun, dFun) => iFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureIntDoubleString2Int(f: (iFun, dFun, sFun) => iFun): String = getSignature(List(IntFun, DoubleFun, StringFun), IntFun)
  def getSignatureIntDoubleBoolean2Int(f: (iFun, dFun, bFun) => iFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureIntStringInt2Int(f: (iFun, sFun, iFun) => iFun): String = getSignature(List(IntFun, StringFun, IntFun), IntFun)
  def getSignatureIntStringLong2Int(f: (iFun, sFun, lFun) => iFun): String = getSignature(List(IntFun, StringFun, LongFun), IntFun)
  def getSignatureIntStringDouble2Int(f: (iFun, sFun, dFun) => iFun): String = getSignature(List(IntFun, StringFun, DoubleFun), IntFun)
  def getSignatureIntStringString2Int(f: (iFun, sFun, sFun) => iFun): String = getSignature(List(IntFun, StringFun, StringFun), IntFun)
  def getSignatureIntStringBoolean2Int(f: (iFun, sFun, bFun) => iFun): String = getSignature(List(IntFun, StringFun, BooleanFun), IntFun)
  def getSignatureIntBooleanInt2Int(f: (iFun, bFun, iFun) => iFun): String = getSignature(List(IntFun, BooleanFun, IntFun), IntFun)
  def getSignatureIntBooleanLong2Int(f: (iFun, bFun, lFun) => iFun): String = getSignature(List(IntFun, BooleanFun, LongFun), IntFun)
  def getSignatureIntBooleanDouble2Int(f: (iFun, bFun, dFun) => iFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureIntBooleanString2Int(f: (iFun, bFun, sFun) => iFun): String = getSignature(List(IntFun, BooleanFun, StringFun), IntFun)
  def getSignatureIntBooleanBoolean2Int(f: (iFun, bFun, bFun) => iFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureLongIntInt2Int(f: (lFun, iFun, iFun) => iFun): String = getSignature(List(LongFun, IntFun, IntFun), IntFun)
  def getSignatureLongIntLong2Int(f: (lFun, iFun, lFun) => iFun): String = getSignature(List(LongFun, IntFun, LongFun), IntFun)
  def getSignatureLongIntDouble2Int(f: (lFun, iFun, dFun) => iFun): String = getSignature(List(LongFun, IntFun, DoubleFun), IntFun)
  def getSignatureLongIntString2Int(f: (lFun, iFun, sFun) => iFun): String = getSignature(List(LongFun, IntFun, StringFun), IntFun)
  def getSignatureLongIntBoolean2Int(f: (lFun, iFun, bFun) => iFun): String = getSignature(List(LongFun, IntFun, BooleanFun), IntFun)
  def getSignatureLongLongInt2Int(f: (lFun, lFun, iFun) => iFun): String = getSignature(List(LongFun, LongFun, IntFun), IntFun)
  def getSignatureLongLongLong2Int(f: (lFun, lFun, lFun) => iFun): String = getSignature(List(LongFun, LongFun, LongFun), IntFun)
  def getSignatureLongLongDouble2Int(f: (lFun, lFun, dFun) => iFun): String = getSignature(List(LongFun, LongFun, DoubleFun), IntFun)
  def getSignatureLongLongString2Int(f: (lFun, lFun, sFun) => iFun): String = getSignature(List(LongFun, LongFun, StringFun), IntFun)
  def getSignatureLongLongBoolean2Int(f: (lFun, lFun, bFun) => iFun): String = getSignature(List(LongFun, LongFun, BooleanFun), IntFun)
  def getSignatureLongDoubleInt2Int(f: (lFun, dFun, iFun) => iFun): String = getSignature(List(LongFun, DoubleFun, IntFun), IntFun)
  def getSignatureLongDoubleLong2Int(f: (lFun, dFun, lFun) => iFun): String = getSignature(List(LongFun, DoubleFun, LongFun), IntFun)
  def getSignatureLongDoubleDouble2Int(f: (lFun, dFun, dFun) => iFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureLongDoubleString2Int(f: (lFun, dFun, sFun) => iFun): String = getSignature(List(LongFun, DoubleFun, StringFun), IntFun)
  def getSignatureLongDoubleBoolean2Int(f: (lFun, dFun, bFun) => iFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureLongStringInt2Int(f: (lFun, sFun, iFun) => iFun): String = getSignature(List(LongFun, StringFun, IntFun), IntFun)
  def getSignatureLongStringLong2Int(f: (lFun, sFun, lFun) => iFun): String = getSignature(List(LongFun, StringFun, LongFun), IntFun)
  def getSignatureLongStringDouble2Int(f: (lFun, sFun, dFun) => iFun): String = getSignature(List(LongFun, StringFun, DoubleFun), IntFun)
  def getSignatureLongStringString2Int(f: (lFun, sFun, sFun) => iFun): String = getSignature(List(LongFun, StringFun, StringFun), IntFun)
  def getSignatureLongStringBoolean2Int(f: (lFun, sFun, bFun) => iFun): String = getSignature(List(LongFun, StringFun, BooleanFun), IntFun)
  def getSignatureLongBooleanInt2Int(f: (lFun, bFun, iFun) => iFun): String = getSignature(List(LongFun, BooleanFun, IntFun), IntFun)
  def getSignatureLongBooleanLong2Int(f: (lFun, bFun, lFun) => iFun): String = getSignature(List(LongFun, BooleanFun, LongFun), IntFun)
  def getSignatureLongBooleanDouble2Int(f: (lFun, bFun, dFun) => iFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureLongBooleanString2Int(f: (lFun, bFun, sFun) => iFun): String = getSignature(List(LongFun, BooleanFun, StringFun), IntFun)
  def getSignatureLongBooleanBoolean2Int(f: (lFun, bFun, bFun) => iFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureDoubleIntInt2Int(f: (dFun, iFun, iFun) => iFun): String = getSignature(List(DoubleFun, IntFun, IntFun), IntFun)
  def getSignatureDoubleIntLong2Int(f: (dFun, iFun, lFun) => iFun): String = getSignature(List(DoubleFun, IntFun, LongFun), IntFun)
  def getSignatureDoubleIntDouble2Int(f: (dFun, iFun, dFun) => iFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun), IntFun)
  def getSignatureDoubleIntString2Int(f: (dFun, iFun, sFun) => iFun): String = getSignature(List(DoubleFun, IntFun, StringFun), IntFun)
  def getSignatureDoubleIntBoolean2Int(f: (dFun, iFun, bFun) => iFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun), IntFun)
  def getSignatureDoubleLongInt2Int(f: (dFun, lFun, iFun) => iFun): String = getSignature(List(DoubleFun, LongFun, IntFun), IntFun)
  def getSignatureDoubleLongLong2Int(f: (dFun, lFun, lFun) => iFun): String = getSignature(List(DoubleFun, LongFun, LongFun), IntFun)
  def getSignatureDoubleLongDouble2Int(f: (dFun, lFun, dFun) => iFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun), IntFun)
  def getSignatureDoubleLongString2Int(f: (dFun, lFun, sFun) => iFun): String = getSignature(List(DoubleFun, LongFun, StringFun), IntFun)
  def getSignatureDoubleLongBoolean2Int(f: (dFun, lFun, bFun) => iFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun), IntFun)
  def getSignatureDoubleDoubleInt2Int(f: (dFun, dFun, iFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun), IntFun)
  def getSignatureDoubleDoubleLong2Int(f: (dFun, dFun, lFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun), IntFun)
  def getSignatureDoubleDoubleDouble2Int(f: (dFun, dFun, dFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureDoubleDoubleString2Int(f: (dFun, dFun, sFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun), IntFun)
  def getSignatureDoubleDoubleBoolean2Int(f: (dFun, dFun, bFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureDoubleStringInt2Int(f: (dFun, sFun, iFun) => iFun): String = getSignature(List(DoubleFun, StringFun, IntFun), IntFun)
  def getSignatureDoubleStringLong2Int(f: (dFun, sFun, lFun) => iFun): String = getSignature(List(DoubleFun, StringFun, LongFun), IntFun)
  def getSignatureDoubleStringDouble2Int(f: (dFun, sFun, dFun) => iFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun), IntFun)
  def getSignatureDoubleStringString2Int(f: (dFun, sFun, sFun) => iFun): String = getSignature(List(DoubleFun, StringFun, StringFun), IntFun)
  def getSignatureDoubleStringBoolean2Int(f: (dFun, sFun, bFun) => iFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun), IntFun)
  def getSignatureDoubleBooleanInt2Int(f: (dFun, bFun, iFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun), IntFun)
  def getSignatureDoubleBooleanLong2Int(f: (dFun, bFun, lFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun), IntFun)
  def getSignatureDoubleBooleanDouble2Int(f: (dFun, bFun, dFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureDoubleBooleanString2Int(f: (dFun, bFun, sFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun), IntFun)
  def getSignatureDoubleBooleanBoolean2Int(f: (dFun, bFun, bFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureStringIntInt2Int(f: (sFun, iFun, iFun) => iFun): String = getSignature(List(StringFun, IntFun, IntFun), IntFun)
  def getSignatureStringIntLong2Int(f: (sFun, iFun, lFun) => iFun): String = getSignature(List(StringFun, IntFun, LongFun), IntFun)
  def getSignatureStringIntDouble2Int(f: (sFun, iFun, dFun) => iFun): String = getSignature(List(StringFun, IntFun, DoubleFun), IntFun)
  def getSignatureStringIntString2Int(f: (sFun, iFun, sFun) => iFun): String = getSignature(List(StringFun, IntFun, StringFun), IntFun)
  def getSignatureStringIntBoolean2Int(f: (sFun, iFun, bFun) => iFun): String = getSignature(List(StringFun, IntFun, BooleanFun), IntFun)
  def getSignatureStringLongInt2Int(f: (sFun, lFun, iFun) => iFun): String = getSignature(List(StringFun, LongFun, IntFun), IntFun)
  def getSignatureStringLongLong2Int(f: (sFun, lFun, lFun) => iFun): String = getSignature(List(StringFun, LongFun, LongFun), IntFun)
  def getSignatureStringLongDouble2Int(f: (sFun, lFun, dFun) => iFun): String = getSignature(List(StringFun, LongFun, DoubleFun), IntFun)
  def getSignatureStringLongString2Int(f: (sFun, lFun, sFun) => iFun): String = getSignature(List(StringFun, LongFun, StringFun), IntFun)
  def getSignatureStringLongBoolean2Int(f: (sFun, lFun, bFun) => iFun): String = getSignature(List(StringFun, LongFun, BooleanFun), IntFun)
  def getSignatureStringDoubleInt2Int(f: (sFun, dFun, iFun) => iFun): String = getSignature(List(StringFun, DoubleFun, IntFun), IntFun)
  def getSignatureStringDoubleLong2Int(f: (sFun, dFun, lFun) => iFun): String = getSignature(List(StringFun, DoubleFun, LongFun), IntFun)
  def getSignatureStringDoubleDouble2Int(f: (sFun, dFun, dFun) => iFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureStringDoubleString2Int(f: (sFun, dFun, sFun) => iFun): String = getSignature(List(StringFun, DoubleFun, StringFun), IntFun)
  def getSignatureStringDoubleBoolean2Int(f: (sFun, dFun, bFun) => iFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureStringStringInt2Int(f: (sFun, sFun, iFun) => iFun): String = getSignature(List(StringFun, StringFun, IntFun), IntFun)
  def getSignatureStringStringLong2Int(f: (sFun, sFun, lFun) => iFun): String = getSignature(List(StringFun, StringFun, LongFun), IntFun)
  def getSignatureStringStringDouble2Int(f: (sFun, sFun, dFun) => iFun): String = getSignature(List(StringFun, StringFun, DoubleFun), IntFun)
  def getSignatureStringStringString2Int(f: (sFun, sFun, sFun) => iFun): String = getSignature(List(StringFun, StringFun, StringFun), IntFun)
  def getSignatureStringStringBoolean2Int(f: (sFun, sFun, bFun) => iFun): String = getSignature(List(StringFun, StringFun, BooleanFun), IntFun)
  def getSignatureStringBooleanInt2Int(f: (sFun, bFun, iFun) => iFun): String = getSignature(List(StringFun, BooleanFun, IntFun), IntFun)
  def getSignatureStringBooleanLong2Int(f: (sFun, bFun, lFun) => iFun): String = getSignature(List(StringFun, BooleanFun, LongFun), IntFun)
  def getSignatureStringBooleanDouble2Int(f: (sFun, bFun, dFun) => iFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureStringBooleanString2Int(f: (sFun, bFun, sFun) => iFun): String = getSignature(List(StringFun, BooleanFun, StringFun), IntFun)
  def getSignatureStringBooleanBoolean2Int(f: (sFun, bFun, bFun) => iFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureBooleanIntInt2Int(f: (bFun, iFun, iFun) => iFun): String = getSignature(List(BooleanFun, IntFun, IntFun), IntFun)
  def getSignatureBooleanIntLong2Int(f: (bFun, iFun, lFun) => iFun): String = getSignature(List(BooleanFun, IntFun, LongFun), IntFun)
  def getSignatureBooleanIntDouble2Int(f: (bFun, iFun, dFun) => iFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun), IntFun)
  def getSignatureBooleanIntString2Int(f: (bFun, iFun, sFun) => iFun): String = getSignature(List(BooleanFun, IntFun, StringFun), IntFun)
  def getSignatureBooleanIntBoolean2Int(f: (bFun, iFun, bFun) => iFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun), IntFun)
  def getSignatureBooleanLongInt2Int(f: (bFun, lFun, iFun) => iFun): String = getSignature(List(BooleanFun, LongFun, IntFun), IntFun)
  def getSignatureBooleanLongLong2Int(f: (bFun, lFun, lFun) => iFun): String = getSignature(List(BooleanFun, LongFun, LongFun), IntFun)
  def getSignatureBooleanLongDouble2Int(f: (bFun, lFun, dFun) => iFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun), IntFun)
  def getSignatureBooleanLongString2Int(f: (bFun, lFun, sFun) => iFun): String = getSignature(List(BooleanFun, LongFun, StringFun), IntFun)
  def getSignatureBooleanLongBoolean2Int(f: (bFun, lFun, bFun) => iFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun), IntFun)
  def getSignatureBooleanDoubleInt2Int(f: (bFun, dFun, iFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun), IntFun)
  def getSignatureBooleanDoubleLong2Int(f: (bFun, dFun, lFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun), IntFun)
  def getSignatureBooleanDoubleDouble2Int(f: (bFun, dFun, dFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureBooleanDoubleString2Int(f: (bFun, dFun, sFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun), IntFun)
  def getSignatureBooleanDoubleBoolean2Int(f: (bFun, dFun, bFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureBooleanStringInt2Int(f: (bFun, sFun, iFun) => iFun): String = getSignature(List(BooleanFun, StringFun, IntFun), IntFun)
  def getSignatureBooleanStringLong2Int(f: (bFun, sFun, lFun) => iFun): String = getSignature(List(BooleanFun, StringFun, LongFun), IntFun)
  def getSignatureBooleanStringDouble2Int(f: (bFun, sFun, dFun) => iFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun), IntFun)
  def getSignatureBooleanStringString2Int(f: (bFun, sFun, sFun) => iFun): String = getSignature(List(BooleanFun, StringFun, StringFun), IntFun)
  def getSignatureBooleanStringBoolean2Int(f: (bFun, sFun, bFun) => iFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun), IntFun)
  def getSignatureBooleanBooleanInt2Int(f: (bFun, bFun, iFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun), IntFun)
  def getSignatureBooleanBooleanLong2Int(f: (bFun, bFun, lFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun), IntFun)
  def getSignatureBooleanBooleanDouble2Int(f: (bFun, bFun, dFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureBooleanBooleanString2Int(f: (bFun, bFun, sFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun), IntFun)
  def getSignatureBooleanBooleanBoolean2Int(f: (bFun, bFun, bFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureIntIntInt2Long(f: (iFun, iFun, iFun) => lFun): String = getSignature(List(IntFun, IntFun, IntFun), LongFun)
  def getSignatureIntIntLong2Long(f: (iFun, iFun, lFun) => lFun): String = getSignature(List(IntFun, IntFun, LongFun), LongFun)
  def getSignatureIntIntDouble2Long(f: (iFun, iFun, dFun) => lFun): String = getSignature(List(IntFun, IntFun, DoubleFun), LongFun)
  def getSignatureIntIntString2Long(f: (iFun, iFun, sFun) => lFun): String = getSignature(List(IntFun, IntFun, StringFun), LongFun)
  def getSignatureIntIntBoolean2Long(f: (iFun, iFun, bFun) => lFun): String = getSignature(List(IntFun, IntFun, BooleanFun), LongFun)
  def getSignatureIntLongInt2Long(f: (iFun, lFun, iFun) => lFun): String = getSignature(List(IntFun, LongFun, IntFun), LongFun)
  def getSignatureIntLongLong2Long(f: (iFun, lFun, lFun) => lFun): String = getSignature(List(IntFun, LongFun, LongFun), LongFun)
  def getSignatureIntLongDouble2Long(f: (iFun, lFun, dFun) => lFun): String = getSignature(List(IntFun, LongFun, DoubleFun), LongFun)
  def getSignatureIntLongString2Long(f: (iFun, lFun, sFun) => lFun): String = getSignature(List(IntFun, LongFun, StringFun), LongFun)
  def getSignatureIntLongBoolean2Long(f: (iFun, lFun, bFun) => lFun): String = getSignature(List(IntFun, LongFun, BooleanFun), LongFun)
  def getSignatureIntDoubleInt2Long(f: (iFun, dFun, iFun) => lFun): String = getSignature(List(IntFun, DoubleFun, IntFun), LongFun)
  def getSignatureIntDoubleLong2Long(f: (iFun, dFun, lFun) => lFun): String = getSignature(List(IntFun, DoubleFun, LongFun), LongFun)
  def getSignatureIntDoubleDouble2Long(f: (iFun, dFun, dFun) => lFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureIntDoubleString2Long(f: (iFun, dFun, sFun) => lFun): String = getSignature(List(IntFun, DoubleFun, StringFun), LongFun)
  def getSignatureIntDoubleBoolean2Long(f: (iFun, dFun, bFun) => lFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureIntStringInt2Long(f: (iFun, sFun, iFun) => lFun): String = getSignature(List(IntFun, StringFun, IntFun), LongFun)
  def getSignatureIntStringLong2Long(f: (iFun, sFun, lFun) => lFun): String = getSignature(List(IntFun, StringFun, LongFun), LongFun)
  def getSignatureIntStringDouble2Long(f: (iFun, sFun, dFun) => lFun): String = getSignature(List(IntFun, StringFun, DoubleFun), LongFun)
  def getSignatureIntStringString2Long(f: (iFun, sFun, sFun) => lFun): String = getSignature(List(IntFun, StringFun, StringFun), LongFun)
  def getSignatureIntStringBoolean2Long(f: (iFun, sFun, bFun) => lFun): String = getSignature(List(IntFun, StringFun, BooleanFun), LongFun)
  def getSignatureIntBooleanInt2Long(f: (iFun, bFun, iFun) => lFun): String = getSignature(List(IntFun, BooleanFun, IntFun), LongFun)
  def getSignatureIntBooleanLong2Long(f: (iFun, bFun, lFun) => lFun): String = getSignature(List(IntFun, BooleanFun, LongFun), LongFun)
  def getSignatureIntBooleanDouble2Long(f: (iFun, bFun, dFun) => lFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureIntBooleanString2Long(f: (iFun, bFun, sFun) => lFun): String = getSignature(List(IntFun, BooleanFun, StringFun), LongFun)
  def getSignatureIntBooleanBoolean2Long(f: (iFun, bFun, bFun) => lFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureLongIntInt2Long(f: (lFun, iFun, iFun) => lFun): String = getSignature(List(LongFun, IntFun, IntFun), LongFun)
  def getSignatureLongIntLong2Long(f: (lFun, iFun, lFun) => lFun): String = getSignature(List(LongFun, IntFun, LongFun), LongFun)
  def getSignatureLongIntDouble2Long(f: (lFun, iFun, dFun) => lFun): String = getSignature(List(LongFun, IntFun, DoubleFun), LongFun)
  def getSignatureLongIntString2Long(f: (lFun, iFun, sFun) => lFun): String = getSignature(List(LongFun, IntFun, StringFun), LongFun)
  def getSignatureLongIntBoolean2Long(f: (lFun, iFun, bFun) => lFun): String = getSignature(List(LongFun, IntFun, BooleanFun), LongFun)
  def getSignatureLongLongInt2Long(f: (lFun, lFun, iFun) => lFun): String = getSignature(List(LongFun, LongFun, IntFun), LongFun)
  def getSignatureLongLongLong2Long(f: (lFun, lFun, lFun) => lFun): String = getSignature(List(LongFun, LongFun, LongFun), LongFun)
  def getSignatureLongLongDouble2Long(f: (lFun, lFun, dFun) => lFun): String = getSignature(List(LongFun, LongFun, DoubleFun), LongFun)
  def getSignatureLongLongString2Long(f: (lFun, lFun, sFun) => lFun): String = getSignature(List(LongFun, LongFun, StringFun), LongFun)
  def getSignatureLongLongBoolean2Long(f: (lFun, lFun, bFun) => lFun): String = getSignature(List(LongFun, LongFun, BooleanFun), LongFun)
  def getSignatureLongDoubleInt2Long(f: (lFun, dFun, iFun) => lFun): String = getSignature(List(LongFun, DoubleFun, IntFun), LongFun)
  def getSignatureLongDoubleLong2Long(f: (lFun, dFun, lFun) => lFun): String = getSignature(List(LongFun, DoubleFun, LongFun), LongFun)
  def getSignatureLongDoubleDouble2Long(f: (lFun, dFun, dFun) => lFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureLongDoubleString2Long(f: (lFun, dFun, sFun) => lFun): String = getSignature(List(LongFun, DoubleFun, StringFun), LongFun)
  def getSignatureLongDoubleBoolean2Long(f: (lFun, dFun, bFun) => lFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureLongStringInt2Long(f: (lFun, sFun, iFun) => lFun): String = getSignature(List(LongFun, StringFun, IntFun), LongFun)
  def getSignatureLongStringLong2Long(f: (lFun, sFun, lFun) => lFun): String = getSignature(List(LongFun, StringFun, LongFun), LongFun)
  def getSignatureLongStringDouble2Long(f: (lFun, sFun, dFun) => lFun): String = getSignature(List(LongFun, StringFun, DoubleFun), LongFun)
  def getSignatureLongStringString2Long(f: (lFun, sFun, sFun) => lFun): String = getSignature(List(LongFun, StringFun, StringFun), LongFun)
  def getSignatureLongStringBoolean2Long(f: (lFun, sFun, bFun) => lFun): String = getSignature(List(LongFun, StringFun, BooleanFun), LongFun)
  def getSignatureLongBooleanInt2Long(f: (lFun, bFun, iFun) => lFun): String = getSignature(List(LongFun, BooleanFun, IntFun), LongFun)
  def getSignatureLongBooleanLong2Long(f: (lFun, bFun, lFun) => lFun): String = getSignature(List(LongFun, BooleanFun, LongFun), LongFun)
  def getSignatureLongBooleanDouble2Long(f: (lFun, bFun, dFun) => lFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureLongBooleanString2Long(f: (lFun, bFun, sFun) => lFun): String = getSignature(List(LongFun, BooleanFun, StringFun), LongFun)
  def getSignatureLongBooleanBoolean2Long(f: (lFun, bFun, bFun) => lFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureDoubleIntInt2Long(f: (dFun, iFun, iFun) => lFun): String = getSignature(List(DoubleFun, IntFun, IntFun), LongFun)
  def getSignatureDoubleIntLong2Long(f: (dFun, iFun, lFun) => lFun): String = getSignature(List(DoubleFun, IntFun, LongFun), LongFun)
  def getSignatureDoubleIntDouble2Long(f: (dFun, iFun, dFun) => lFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun), LongFun)
  def getSignatureDoubleIntString2Long(f: (dFun, iFun, sFun) => lFun): String = getSignature(List(DoubleFun, IntFun, StringFun), LongFun)
  def getSignatureDoubleIntBoolean2Long(f: (dFun, iFun, bFun) => lFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun), LongFun)
  def getSignatureDoubleLongInt2Long(f: (dFun, lFun, iFun) => lFun): String = getSignature(List(DoubleFun, LongFun, IntFun), LongFun)
  def getSignatureDoubleLongLong2Long(f: (dFun, lFun, lFun) => lFun): String = getSignature(List(DoubleFun, LongFun, LongFun), LongFun)
  def getSignatureDoubleLongDouble2Long(f: (dFun, lFun, dFun) => lFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun), LongFun)
  def getSignatureDoubleLongString2Long(f: (dFun, lFun, sFun) => lFun): String = getSignature(List(DoubleFun, LongFun, StringFun), LongFun)
  def getSignatureDoubleLongBoolean2Long(f: (dFun, lFun, bFun) => lFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun), LongFun)
  def getSignatureDoubleDoubleInt2Long(f: (dFun, dFun, iFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun), LongFun)
  def getSignatureDoubleDoubleLong2Long(f: (dFun, dFun, lFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun), LongFun)
  def getSignatureDoubleDoubleDouble2Long(f: (dFun, dFun, dFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureDoubleDoubleString2Long(f: (dFun, dFun, sFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun), LongFun)
  def getSignatureDoubleDoubleBoolean2Long(f: (dFun, dFun, bFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureDoubleStringInt2Long(f: (dFun, sFun, iFun) => lFun): String = getSignature(List(DoubleFun, StringFun, IntFun), LongFun)
  def getSignatureDoubleStringLong2Long(f: (dFun, sFun, lFun) => lFun): String = getSignature(List(DoubleFun, StringFun, LongFun), LongFun)
  def getSignatureDoubleStringDouble2Long(f: (dFun, sFun, dFun) => lFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun), LongFun)
  def getSignatureDoubleStringString2Long(f: (dFun, sFun, sFun) => lFun): String = getSignature(List(DoubleFun, StringFun, StringFun), LongFun)
  def getSignatureDoubleStringBoolean2Long(f: (dFun, sFun, bFun) => lFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun), LongFun)
  def getSignatureDoubleBooleanInt2Long(f: (dFun, bFun, iFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun), LongFun)
  def getSignatureDoubleBooleanLong2Long(f: (dFun, bFun, lFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun), LongFun)
  def getSignatureDoubleBooleanDouble2Long(f: (dFun, bFun, dFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureDoubleBooleanString2Long(f: (dFun, bFun, sFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun), LongFun)
  def getSignatureDoubleBooleanBoolean2Long(f: (dFun, bFun, bFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureStringIntInt2Long(f: (sFun, iFun, iFun) => lFun): String = getSignature(List(StringFun, IntFun, IntFun), LongFun)
  def getSignatureStringIntLong2Long(f: (sFun, iFun, lFun) => lFun): String = getSignature(List(StringFun, IntFun, LongFun), LongFun)
  def getSignatureStringIntDouble2Long(f: (sFun, iFun, dFun) => lFun): String = getSignature(List(StringFun, IntFun, DoubleFun), LongFun)
  def getSignatureStringIntString2Long(f: (sFun, iFun, sFun) => lFun): String = getSignature(List(StringFun, IntFun, StringFun), LongFun)
  def getSignatureStringIntBoolean2Long(f: (sFun, iFun, bFun) => lFun): String = getSignature(List(StringFun, IntFun, BooleanFun), LongFun)
  def getSignatureStringLongInt2Long(f: (sFun, lFun, iFun) => lFun): String = getSignature(List(StringFun, LongFun, IntFun), LongFun)
  def getSignatureStringLongLong2Long(f: (sFun, lFun, lFun) => lFun): String = getSignature(List(StringFun, LongFun, LongFun), LongFun)
  def getSignatureStringLongDouble2Long(f: (sFun, lFun, dFun) => lFun): String = getSignature(List(StringFun, LongFun, DoubleFun), LongFun)
  def getSignatureStringLongString2Long(f: (sFun, lFun, sFun) => lFun): String = getSignature(List(StringFun, LongFun, StringFun), LongFun)
  def getSignatureStringLongBoolean2Long(f: (sFun, lFun, bFun) => lFun): String = getSignature(List(StringFun, LongFun, BooleanFun), LongFun)
  def getSignatureStringDoubleInt2Long(f: (sFun, dFun, iFun) => lFun): String = getSignature(List(StringFun, DoubleFun, IntFun), LongFun)
  def getSignatureStringDoubleLong2Long(f: (sFun, dFun, lFun) => lFun): String = getSignature(List(StringFun, DoubleFun, LongFun), LongFun)
  def getSignatureStringDoubleDouble2Long(f: (sFun, dFun, dFun) => lFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureStringDoubleString2Long(f: (sFun, dFun, sFun) => lFun): String = getSignature(List(StringFun, DoubleFun, StringFun), LongFun)
  def getSignatureStringDoubleBoolean2Long(f: (sFun, dFun, bFun) => lFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureStringStringInt2Long(f: (sFun, sFun, iFun) => lFun): String = getSignature(List(StringFun, StringFun, IntFun), LongFun)
  def getSignatureStringStringLong2Long(f: (sFun, sFun, lFun) => lFun): String = getSignature(List(StringFun, StringFun, LongFun), LongFun)
  def getSignatureStringStringDouble2Long(f: (sFun, sFun, dFun) => lFun): String = getSignature(List(StringFun, StringFun, DoubleFun), LongFun)
  def getSignatureStringStringString2Long(f: (sFun, sFun, sFun) => lFun): String = getSignature(List(StringFun, StringFun, StringFun), LongFun)
  def getSignatureStringStringBoolean2Long(f: (sFun, sFun, bFun) => lFun): String = getSignature(List(StringFun, StringFun, BooleanFun), LongFun)
  def getSignatureStringBooleanInt2Long(f: (sFun, bFun, iFun) => lFun): String = getSignature(List(StringFun, BooleanFun, IntFun), LongFun)
  def getSignatureStringBooleanLong2Long(f: (sFun, bFun, lFun) => lFun): String = getSignature(List(StringFun, BooleanFun, LongFun), LongFun)
  def getSignatureStringBooleanDouble2Long(f: (sFun, bFun, dFun) => lFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureStringBooleanString2Long(f: (sFun, bFun, sFun) => lFun): String = getSignature(List(StringFun, BooleanFun, StringFun), LongFun)
  def getSignatureStringBooleanBoolean2Long(f: (sFun, bFun, bFun) => lFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureBooleanIntInt2Long(f: (bFun, iFun, iFun) => lFun): String = getSignature(List(BooleanFun, IntFun, IntFun), LongFun)
  def getSignatureBooleanIntLong2Long(f: (bFun, iFun, lFun) => lFun): String = getSignature(List(BooleanFun, IntFun, LongFun), LongFun)
  def getSignatureBooleanIntDouble2Long(f: (bFun, iFun, dFun) => lFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun), LongFun)
  def getSignatureBooleanIntString2Long(f: (bFun, iFun, sFun) => lFun): String = getSignature(List(BooleanFun, IntFun, StringFun), LongFun)
  def getSignatureBooleanIntBoolean2Long(f: (bFun, iFun, bFun) => lFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun), LongFun)
  def getSignatureBooleanLongInt2Long(f: (bFun, lFun, iFun) => lFun): String = getSignature(List(BooleanFun, LongFun, IntFun), LongFun)
  def getSignatureBooleanLongLong2Long(f: (bFun, lFun, lFun) => lFun): String = getSignature(List(BooleanFun, LongFun, LongFun), LongFun)
  def getSignatureBooleanLongDouble2Long(f: (bFun, lFun, dFun) => lFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun), LongFun)
  def getSignatureBooleanLongString2Long(f: (bFun, lFun, sFun) => lFun): String = getSignature(List(BooleanFun, LongFun, StringFun), LongFun)
  def getSignatureBooleanLongBoolean2Long(f: (bFun, lFun, bFun) => lFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun), LongFun)
  def getSignatureBooleanDoubleInt2Long(f: (bFun, dFun, iFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun), LongFun)
  def getSignatureBooleanDoubleLong2Long(f: (bFun, dFun, lFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun), LongFun)
  def getSignatureBooleanDoubleDouble2Long(f: (bFun, dFun, dFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureBooleanDoubleString2Long(f: (bFun, dFun, sFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun), LongFun)
  def getSignatureBooleanDoubleBoolean2Long(f: (bFun, dFun, bFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureBooleanStringInt2Long(f: (bFun, sFun, iFun) => lFun): String = getSignature(List(BooleanFun, StringFun, IntFun), LongFun)
  def getSignatureBooleanStringLong2Long(f: (bFun, sFun, lFun) => lFun): String = getSignature(List(BooleanFun, StringFun, LongFun), LongFun)
  def getSignatureBooleanStringDouble2Long(f: (bFun, sFun, dFun) => lFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun), LongFun)
  def getSignatureBooleanStringString2Long(f: (bFun, sFun, sFun) => lFun): String = getSignature(List(BooleanFun, StringFun, StringFun), LongFun)
  def getSignatureBooleanStringBoolean2Long(f: (bFun, sFun, bFun) => lFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun), LongFun)
  def getSignatureBooleanBooleanInt2Long(f: (bFun, bFun, iFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun), LongFun)
  def getSignatureBooleanBooleanLong2Long(f: (bFun, bFun, lFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun), LongFun)
  def getSignatureBooleanBooleanDouble2Long(f: (bFun, bFun, dFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureBooleanBooleanString2Long(f: (bFun, bFun, sFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun), LongFun)
  def getSignatureBooleanBooleanBoolean2Long(f: (bFun, bFun, bFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureIntIntInt2Double(f: (iFun, iFun, iFun) => dFun): String = getSignature(List(IntFun, IntFun, IntFun), DoubleFun)
  def getSignatureIntIntLong2Double(f: (iFun, iFun, lFun) => dFun): String = getSignature(List(IntFun, IntFun, LongFun), DoubleFun)
  def getSignatureIntIntDouble2Double(f: (iFun, iFun, dFun) => dFun): String = getSignature(List(IntFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureIntIntString2Double(f: (iFun, iFun, sFun) => dFun): String = getSignature(List(IntFun, IntFun, StringFun), DoubleFun)
  def getSignatureIntIntBoolean2Double(f: (iFun, iFun, bFun) => dFun): String = getSignature(List(IntFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureIntLongInt2Double(f: (iFun, lFun, iFun) => dFun): String = getSignature(List(IntFun, LongFun, IntFun), DoubleFun)
  def getSignatureIntLongLong2Double(f: (iFun, lFun, lFun) => dFun): String = getSignature(List(IntFun, LongFun, LongFun), DoubleFun)
  def getSignatureIntLongDouble2Double(f: (iFun, lFun, dFun) => dFun): String = getSignature(List(IntFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureIntLongString2Double(f: (iFun, lFun, sFun) => dFun): String = getSignature(List(IntFun, LongFun, StringFun), DoubleFun)
  def getSignatureIntLongBoolean2Double(f: (iFun, lFun, bFun) => dFun): String = getSignature(List(IntFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureIntDoubleInt2Double(f: (iFun, dFun, iFun) => dFun): String = getSignature(List(IntFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureIntDoubleLong2Double(f: (iFun, dFun, lFun) => dFun): String = getSignature(List(IntFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureIntDoubleDouble2Double(f: (iFun, dFun, dFun) => dFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureIntDoubleString2Double(f: (iFun, dFun, sFun) => dFun): String = getSignature(List(IntFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureIntDoubleBoolean2Double(f: (iFun, dFun, bFun) => dFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureIntStringInt2Double(f: (iFun, sFun, iFun) => dFun): String = getSignature(List(IntFun, StringFun, IntFun), DoubleFun)
  def getSignatureIntStringLong2Double(f: (iFun, sFun, lFun) => dFun): String = getSignature(List(IntFun, StringFun, LongFun), DoubleFun)
  def getSignatureIntStringDouble2Double(f: (iFun, sFun, dFun) => dFun): String = getSignature(List(IntFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureIntStringString2Double(f: (iFun, sFun, sFun) => dFun): String = getSignature(List(IntFun, StringFun, StringFun), DoubleFun)
  def getSignatureIntStringBoolean2Double(f: (iFun, sFun, bFun) => dFun): String = getSignature(List(IntFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureIntBooleanInt2Double(f: (iFun, bFun, iFun) => dFun): String = getSignature(List(IntFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureIntBooleanLong2Double(f: (iFun, bFun, lFun) => dFun): String = getSignature(List(IntFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureIntBooleanDouble2Double(f: (iFun, bFun, dFun) => dFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureIntBooleanString2Double(f: (iFun, bFun, sFun) => dFun): String = getSignature(List(IntFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureIntBooleanBoolean2Double(f: (iFun, bFun, bFun) => dFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureLongIntInt2Double(f: (lFun, iFun, iFun) => dFun): String = getSignature(List(LongFun, IntFun, IntFun), DoubleFun)
  def getSignatureLongIntLong2Double(f: (lFun, iFun, lFun) => dFun): String = getSignature(List(LongFun, IntFun, LongFun), DoubleFun)
  def getSignatureLongIntDouble2Double(f: (lFun, iFun, dFun) => dFun): String = getSignature(List(LongFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureLongIntString2Double(f: (lFun, iFun, sFun) => dFun): String = getSignature(List(LongFun, IntFun, StringFun), DoubleFun)
  def getSignatureLongIntBoolean2Double(f: (lFun, iFun, bFun) => dFun): String = getSignature(List(LongFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureLongLongInt2Double(f: (lFun, lFun, iFun) => dFun): String = getSignature(List(LongFun, LongFun, IntFun), DoubleFun)
  def getSignatureLongLongLong2Double(f: (lFun, lFun, lFun) => dFun): String = getSignature(List(LongFun, LongFun, LongFun), DoubleFun)
  def getSignatureLongLongDouble2Double(f: (lFun, lFun, dFun) => dFun): String = getSignature(List(LongFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureLongLongString2Double(f: (lFun, lFun, sFun) => dFun): String = getSignature(List(LongFun, LongFun, StringFun), DoubleFun)
  def getSignatureLongLongBoolean2Double(f: (lFun, lFun, bFun) => dFun): String = getSignature(List(LongFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureLongDoubleInt2Double(f: (lFun, dFun, iFun) => dFun): String = getSignature(List(LongFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureLongDoubleLong2Double(f: (lFun, dFun, lFun) => dFun): String = getSignature(List(LongFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureLongDoubleDouble2Double(f: (lFun, dFun, dFun) => dFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureLongDoubleString2Double(f: (lFun, dFun, sFun) => dFun): String = getSignature(List(LongFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureLongDoubleBoolean2Double(f: (lFun, dFun, bFun) => dFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureLongStringInt2Double(f: (lFun, sFun, iFun) => dFun): String = getSignature(List(LongFun, StringFun, IntFun), DoubleFun)
  def getSignatureLongStringLong2Double(f: (lFun, sFun, lFun) => dFun): String = getSignature(List(LongFun, StringFun, LongFun), DoubleFun)
  def getSignatureLongStringDouble2Double(f: (lFun, sFun, dFun) => dFun): String = getSignature(List(LongFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureLongStringString2Double(f: (lFun, sFun, sFun) => dFun): String = getSignature(List(LongFun, StringFun, StringFun), DoubleFun)
  def getSignatureLongStringBoolean2Double(f: (lFun, sFun, bFun) => dFun): String = getSignature(List(LongFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureLongBooleanInt2Double(f: (lFun, bFun, iFun) => dFun): String = getSignature(List(LongFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureLongBooleanLong2Double(f: (lFun, bFun, lFun) => dFun): String = getSignature(List(LongFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureLongBooleanDouble2Double(f: (lFun, bFun, dFun) => dFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureLongBooleanString2Double(f: (lFun, bFun, sFun) => dFun): String = getSignature(List(LongFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureLongBooleanBoolean2Double(f: (lFun, bFun, bFun) => dFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureDoubleIntInt2Double(f: (dFun, iFun, iFun) => dFun): String = getSignature(List(DoubleFun, IntFun, IntFun), DoubleFun)
  def getSignatureDoubleIntLong2Double(f: (dFun, iFun, lFun) => dFun): String = getSignature(List(DoubleFun, IntFun, LongFun), DoubleFun)
  def getSignatureDoubleIntDouble2Double(f: (dFun, iFun, dFun) => dFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureDoubleIntString2Double(f: (dFun, iFun, sFun) => dFun): String = getSignature(List(DoubleFun, IntFun, StringFun), DoubleFun)
  def getSignatureDoubleIntBoolean2Double(f: (dFun, iFun, bFun) => dFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureDoubleLongInt2Double(f: (dFun, lFun, iFun) => dFun): String = getSignature(List(DoubleFun, LongFun, IntFun), DoubleFun)
  def getSignatureDoubleLongLong2Double(f: (dFun, lFun, lFun) => dFun): String = getSignature(List(DoubleFun, LongFun, LongFun), DoubleFun)
  def getSignatureDoubleLongDouble2Double(f: (dFun, lFun, dFun) => dFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureDoubleLongString2Double(f: (dFun, lFun, sFun) => dFun): String = getSignature(List(DoubleFun, LongFun, StringFun), DoubleFun)
  def getSignatureDoubleLongBoolean2Double(f: (dFun, lFun, bFun) => dFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureDoubleDoubleInt2Double(f: (dFun, dFun, iFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureDoubleDoubleLong2Double(f: (dFun, dFun, lFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureDoubleDoubleDouble2Double(f: (dFun, dFun, dFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureDoubleDoubleString2Double(f: (dFun, dFun, sFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureDoubleDoubleBoolean2Double(f: (dFun, dFun, bFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureDoubleStringInt2Double(f: (dFun, sFun, iFun) => dFun): String = getSignature(List(DoubleFun, StringFun, IntFun), DoubleFun)
  def getSignatureDoubleStringLong2Double(f: (dFun, sFun, lFun) => dFun): String = getSignature(List(DoubleFun, StringFun, LongFun), DoubleFun)
  def getSignatureDoubleStringDouble2Double(f: (dFun, sFun, dFun) => dFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureDoubleStringString2Double(f: (dFun, sFun, sFun) => dFun): String = getSignature(List(DoubleFun, StringFun, StringFun), DoubleFun)
  def getSignatureDoubleStringBoolean2Double(f: (dFun, sFun, bFun) => dFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureDoubleBooleanInt2Double(f: (dFun, bFun, iFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureDoubleBooleanLong2Double(f: (dFun, bFun, lFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureDoubleBooleanDouble2Double(f: (dFun, bFun, dFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureDoubleBooleanString2Double(f: (dFun, bFun, sFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureDoubleBooleanBoolean2Double(f: (dFun, bFun, bFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureStringIntInt2Double(f: (sFun, iFun, iFun) => dFun): String = getSignature(List(StringFun, IntFun, IntFun), DoubleFun)
  def getSignatureStringIntLong2Double(f: (sFun, iFun, lFun) => dFun): String = getSignature(List(StringFun, IntFun, LongFun), DoubleFun)
  def getSignatureStringIntDouble2Double(f: (sFun, iFun, dFun) => dFun): String = getSignature(List(StringFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureStringIntString2Double(f: (sFun, iFun, sFun) => dFun): String = getSignature(List(StringFun, IntFun, StringFun), DoubleFun)
  def getSignatureStringIntBoolean2Double(f: (sFun, iFun, bFun) => dFun): String = getSignature(List(StringFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureStringLongInt2Double(f: (sFun, lFun, iFun) => dFun): String = getSignature(List(StringFun, LongFun, IntFun), DoubleFun)
  def getSignatureStringLongLong2Double(f: (sFun, lFun, lFun) => dFun): String = getSignature(List(StringFun, LongFun, LongFun), DoubleFun)
  def getSignatureStringLongDouble2Double(f: (sFun, lFun, dFun) => dFun): String = getSignature(List(StringFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureStringLongString2Double(f: (sFun, lFun, sFun) => dFun): String = getSignature(List(StringFun, LongFun, StringFun), DoubleFun)
  def getSignatureStringLongBoolean2Double(f: (sFun, lFun, bFun) => dFun): String = getSignature(List(StringFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureStringDoubleInt2Double(f: (sFun, dFun, iFun) => dFun): String = getSignature(List(StringFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureStringDoubleLong2Double(f: (sFun, dFun, lFun) => dFun): String = getSignature(List(StringFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureStringDoubleDouble2Double(f: (sFun, dFun, dFun) => dFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureStringDoubleString2Double(f: (sFun, dFun, sFun) => dFun): String = getSignature(List(StringFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureStringDoubleBoolean2Double(f: (sFun, dFun, bFun) => dFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureStringStringInt2Double(f: (sFun, sFun, iFun) => dFun): String = getSignature(List(StringFun, StringFun, IntFun), DoubleFun)
  def getSignatureStringStringLong2Double(f: (sFun, sFun, lFun) => dFun): String = getSignature(List(StringFun, StringFun, LongFun), DoubleFun)
  def getSignatureStringStringDouble2Double(f: (sFun, sFun, dFun) => dFun): String = getSignature(List(StringFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureStringStringString2Double(f: (sFun, sFun, sFun) => dFun): String = getSignature(List(StringFun, StringFun, StringFun), DoubleFun)
  def getSignatureStringStringBoolean2Double(f: (sFun, sFun, bFun) => dFun): String = getSignature(List(StringFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureStringBooleanInt2Double(f: (sFun, bFun, iFun) => dFun): String = getSignature(List(StringFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureStringBooleanLong2Double(f: (sFun, bFun, lFun) => dFun): String = getSignature(List(StringFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureStringBooleanDouble2Double(f: (sFun, bFun, dFun) => dFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureStringBooleanString2Double(f: (sFun, bFun, sFun) => dFun): String = getSignature(List(StringFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureStringBooleanBoolean2Double(f: (sFun, bFun, bFun) => dFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureBooleanIntInt2Double(f: (bFun, iFun, iFun) => dFun): String = getSignature(List(BooleanFun, IntFun, IntFun), DoubleFun)
  def getSignatureBooleanIntLong2Double(f: (bFun, iFun, lFun) => dFun): String = getSignature(List(BooleanFun, IntFun, LongFun), DoubleFun)
  def getSignatureBooleanIntDouble2Double(f: (bFun, iFun, dFun) => dFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureBooleanIntString2Double(f: (bFun, iFun, sFun) => dFun): String = getSignature(List(BooleanFun, IntFun, StringFun), DoubleFun)
  def getSignatureBooleanIntBoolean2Double(f: (bFun, iFun, bFun) => dFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureBooleanLongInt2Double(f: (bFun, lFun, iFun) => dFun): String = getSignature(List(BooleanFun, LongFun, IntFun), DoubleFun)
  def getSignatureBooleanLongLong2Double(f: (bFun, lFun, lFun) => dFun): String = getSignature(List(BooleanFun, LongFun, LongFun), DoubleFun)
  def getSignatureBooleanLongDouble2Double(f: (bFun, lFun, dFun) => dFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureBooleanLongString2Double(f: (bFun, lFun, sFun) => dFun): String = getSignature(List(BooleanFun, LongFun, StringFun), DoubleFun)
  def getSignatureBooleanLongBoolean2Double(f: (bFun, lFun, bFun) => dFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureBooleanDoubleInt2Double(f: (bFun, dFun, iFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureBooleanDoubleLong2Double(f: (bFun, dFun, lFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureBooleanDoubleDouble2Double(f: (bFun, dFun, dFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureBooleanDoubleString2Double(f: (bFun, dFun, sFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureBooleanDoubleBoolean2Double(f: (bFun, dFun, bFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureBooleanStringInt2Double(f: (bFun, sFun, iFun) => dFun): String = getSignature(List(BooleanFun, StringFun, IntFun), DoubleFun)
  def getSignatureBooleanStringLong2Double(f: (bFun, sFun, lFun) => dFun): String = getSignature(List(BooleanFun, StringFun, LongFun), DoubleFun)
  def getSignatureBooleanStringDouble2Double(f: (bFun, sFun, dFun) => dFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureBooleanStringString2Double(f: (bFun, sFun, sFun) => dFun): String = getSignature(List(BooleanFun, StringFun, StringFun), DoubleFun)
  def getSignatureBooleanStringBoolean2Double(f: (bFun, sFun, bFun) => dFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureBooleanBooleanInt2Double(f: (bFun, bFun, iFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureBooleanBooleanLong2Double(f: (bFun, bFun, lFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureBooleanBooleanDouble2Double(f: (bFun, bFun, dFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureBooleanBooleanString2Double(f: (bFun, bFun, sFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureBooleanBooleanBoolean2Double(f: (bFun, bFun, bFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureIntIntInt2String(f: (iFun, iFun, iFun) => sFun): String = getSignature(List(IntFun, IntFun, IntFun), StringFun)
  def getSignatureIntIntLong2String(f: (iFun, iFun, lFun) => sFun): String = getSignature(List(IntFun, IntFun, LongFun), StringFun)
  def getSignatureIntIntDouble2String(f: (iFun, iFun, dFun) => sFun): String = getSignature(List(IntFun, IntFun, DoubleFun), StringFun)
  def getSignatureIntIntString2String(f: (iFun, iFun, sFun) => sFun): String = getSignature(List(IntFun, IntFun, StringFun), StringFun)
  def getSignatureIntIntBoolean2String(f: (iFun, iFun, bFun) => sFun): String = getSignature(List(IntFun, IntFun, BooleanFun), StringFun)
  def getSignatureIntLongInt2String(f: (iFun, lFun, iFun) => sFun): String = getSignature(List(IntFun, LongFun, IntFun), StringFun)
  def getSignatureIntLongLong2String(f: (iFun, lFun, lFun) => sFun): String = getSignature(List(IntFun, LongFun, LongFun), StringFun)
  def getSignatureIntLongDouble2String(f: (iFun, lFun, dFun) => sFun): String = getSignature(List(IntFun, LongFun, DoubleFun), StringFun)
  def getSignatureIntLongString2String(f: (iFun, lFun, sFun) => sFun): String = getSignature(List(IntFun, LongFun, StringFun), StringFun)
  def getSignatureIntLongBoolean2String(f: (iFun, lFun, bFun) => sFun): String = getSignature(List(IntFun, LongFun, BooleanFun), StringFun)
  def getSignatureIntDoubleInt2String(f: (iFun, dFun, iFun) => sFun): String = getSignature(List(IntFun, DoubleFun, IntFun), StringFun)
  def getSignatureIntDoubleLong2String(f: (iFun, dFun, lFun) => sFun): String = getSignature(List(IntFun, DoubleFun, LongFun), StringFun)
  def getSignatureIntDoubleDouble2String(f: (iFun, dFun, dFun) => sFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureIntDoubleString2String(f: (iFun, dFun, sFun) => sFun): String = getSignature(List(IntFun, DoubleFun, StringFun), StringFun)
  def getSignatureIntDoubleBoolean2String(f: (iFun, dFun, bFun) => sFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureIntStringInt2String(f: (iFun, sFun, iFun) => sFun): String = getSignature(List(IntFun, StringFun, IntFun), StringFun)
  def getSignatureIntStringLong2String(f: (iFun, sFun, lFun) => sFun): String = getSignature(List(IntFun, StringFun, LongFun), StringFun)
  def getSignatureIntStringDouble2String(f: (iFun, sFun, dFun) => sFun): String = getSignature(List(IntFun, StringFun, DoubleFun), StringFun)
  def getSignatureIntStringString2String(f: (iFun, sFun, sFun) => sFun): String = getSignature(List(IntFun, StringFun, StringFun), StringFun)
  def getSignatureIntStringBoolean2String(f: (iFun, sFun, bFun) => sFun): String = getSignature(List(IntFun, StringFun, BooleanFun), StringFun)
  def getSignatureIntBooleanInt2String(f: (iFun, bFun, iFun) => sFun): String = getSignature(List(IntFun, BooleanFun, IntFun), StringFun)
  def getSignatureIntBooleanLong2String(f: (iFun, bFun, lFun) => sFun): String = getSignature(List(IntFun, BooleanFun, LongFun), StringFun)
  def getSignatureIntBooleanDouble2String(f: (iFun, bFun, dFun) => sFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureIntBooleanString2String(f: (iFun, bFun, sFun) => sFun): String = getSignature(List(IntFun, BooleanFun, StringFun), StringFun)
  def getSignatureIntBooleanBoolean2String(f: (iFun, bFun, bFun) => sFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureLongIntInt2String(f: (lFun, iFun, iFun) => sFun): String = getSignature(List(LongFun, IntFun, IntFun), StringFun)
  def getSignatureLongIntLong2String(f: (lFun, iFun, lFun) => sFun): String = getSignature(List(LongFun, IntFun, LongFun), StringFun)
  def getSignatureLongIntDouble2String(f: (lFun, iFun, dFun) => sFun): String = getSignature(List(LongFun, IntFun, DoubleFun), StringFun)
  def getSignatureLongIntString2String(f: (lFun, iFun, sFun) => sFun): String = getSignature(List(LongFun, IntFun, StringFun), StringFun)
  def getSignatureLongIntBoolean2String(f: (lFun, iFun, bFun) => sFun): String = getSignature(List(LongFun, IntFun, BooleanFun), StringFun)
  def getSignatureLongLongInt2String(f: (lFun, lFun, iFun) => sFun): String = getSignature(List(LongFun, LongFun, IntFun), StringFun)
  def getSignatureLongLongLong2String(f: (lFun, lFun, lFun) => sFun): String = getSignature(List(LongFun, LongFun, LongFun), StringFun)
  def getSignatureLongLongDouble2String(f: (lFun, lFun, dFun) => sFun): String = getSignature(List(LongFun, LongFun, DoubleFun), StringFun)
  def getSignatureLongLongString2String(f: (lFun, lFun, sFun) => sFun): String = getSignature(List(LongFun, LongFun, StringFun), StringFun)
  def getSignatureLongLongBoolean2String(f: (lFun, lFun, bFun) => sFun): String = getSignature(List(LongFun, LongFun, BooleanFun), StringFun)
  def getSignatureLongDoubleInt2String(f: (lFun, dFun, iFun) => sFun): String = getSignature(List(LongFun, DoubleFun, IntFun), StringFun)
  def getSignatureLongDoubleLong2String(f: (lFun, dFun, lFun) => sFun): String = getSignature(List(LongFun, DoubleFun, LongFun), StringFun)
  def getSignatureLongDoubleDouble2String(f: (lFun, dFun, dFun) => sFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureLongDoubleString2String(f: (lFun, dFun, sFun) => sFun): String = getSignature(List(LongFun, DoubleFun, StringFun), StringFun)
  def getSignatureLongDoubleBoolean2String(f: (lFun, dFun, bFun) => sFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureLongStringInt2String(f: (lFun, sFun, iFun) => sFun): String = getSignature(List(LongFun, StringFun, IntFun), StringFun)
  def getSignatureLongStringLong2String(f: (lFun, sFun, lFun) => sFun): String = getSignature(List(LongFun, StringFun, LongFun), StringFun)
  def getSignatureLongStringDouble2String(f: (lFun, sFun, dFun) => sFun): String = getSignature(List(LongFun, StringFun, DoubleFun), StringFun)
  def getSignatureLongStringString2String(f: (lFun, sFun, sFun) => sFun): String = getSignature(List(LongFun, StringFun, StringFun), StringFun)
  def getSignatureLongStringBoolean2String(f: (lFun, sFun, bFun) => sFun): String = getSignature(List(LongFun, StringFun, BooleanFun), StringFun)
  def getSignatureLongBooleanInt2String(f: (lFun, bFun, iFun) => sFun): String = getSignature(List(LongFun, BooleanFun, IntFun), StringFun)
  def getSignatureLongBooleanLong2String(f: (lFun, bFun, lFun) => sFun): String = getSignature(List(LongFun, BooleanFun, LongFun), StringFun)
  def getSignatureLongBooleanDouble2String(f: (lFun, bFun, dFun) => sFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureLongBooleanString2String(f: (lFun, bFun, sFun) => sFun): String = getSignature(List(LongFun, BooleanFun, StringFun), StringFun)
  def getSignatureLongBooleanBoolean2String(f: (lFun, bFun, bFun) => sFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureDoubleIntInt2String(f: (dFun, iFun, iFun) => sFun): String = getSignature(List(DoubleFun, IntFun, IntFun), StringFun)
  def getSignatureDoubleIntLong2String(f: (dFun, iFun, lFun) => sFun): String = getSignature(List(DoubleFun, IntFun, LongFun), StringFun)
  def getSignatureDoubleIntDouble2String(f: (dFun, iFun, dFun) => sFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun), StringFun)
  def getSignatureDoubleIntString2String(f: (dFun, iFun, sFun) => sFun): String = getSignature(List(DoubleFun, IntFun, StringFun), StringFun)
  def getSignatureDoubleIntBoolean2String(f: (dFun, iFun, bFun) => sFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun), StringFun)
  def getSignatureDoubleLongInt2String(f: (dFun, lFun, iFun) => sFun): String = getSignature(List(DoubleFun, LongFun, IntFun), StringFun)
  def getSignatureDoubleLongLong2String(f: (dFun, lFun, lFun) => sFun): String = getSignature(List(DoubleFun, LongFun, LongFun), StringFun)
  def getSignatureDoubleLongDouble2String(f: (dFun, lFun, dFun) => sFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun), StringFun)
  def getSignatureDoubleLongString2String(f: (dFun, lFun, sFun) => sFun): String = getSignature(List(DoubleFun, LongFun, StringFun), StringFun)
  def getSignatureDoubleLongBoolean2String(f: (dFun, lFun, bFun) => sFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun), StringFun)
  def getSignatureDoubleDoubleInt2String(f: (dFun, dFun, iFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun), StringFun)
  def getSignatureDoubleDoubleLong2String(f: (dFun, dFun, lFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun), StringFun)
  def getSignatureDoubleDoubleDouble2String(f: (dFun, dFun, dFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureDoubleDoubleString2String(f: (dFun, dFun, sFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun), StringFun)
  def getSignatureDoubleDoubleBoolean2String(f: (dFun, dFun, bFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureDoubleStringInt2String(f: (dFun, sFun, iFun) => sFun): String = getSignature(List(DoubleFun, StringFun, IntFun), StringFun)
  def getSignatureDoubleStringLong2String(f: (dFun, sFun, lFun) => sFun): String = getSignature(List(DoubleFun, StringFun, LongFun), StringFun)
  def getSignatureDoubleStringDouble2String(f: (dFun, sFun, dFun) => sFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun), StringFun)
  def getSignatureDoubleStringString2String(f: (dFun, sFun, sFun) => sFun): String = getSignature(List(DoubleFun, StringFun, StringFun), StringFun)
  def getSignatureDoubleStringBoolean2String(f: (dFun, sFun, bFun) => sFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun), StringFun)
  def getSignatureDoubleBooleanInt2String(f: (dFun, bFun, iFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun), StringFun)
  def getSignatureDoubleBooleanLong2String(f: (dFun, bFun, lFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun), StringFun)
  def getSignatureDoubleBooleanDouble2String(f: (dFun, bFun, dFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureDoubleBooleanString2String(f: (dFun, bFun, sFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun), StringFun)
  def getSignatureDoubleBooleanBoolean2String(f: (dFun, bFun, bFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureStringIntInt2String(f: (sFun, iFun, iFun) => sFun): String = getSignature(List(StringFun, IntFun, IntFun), StringFun)
  def getSignatureStringIntLong2String(f: (sFun, iFun, lFun) => sFun): String = getSignature(List(StringFun, IntFun, LongFun), StringFun)
  def getSignatureStringIntDouble2String(f: (sFun, iFun, dFun) => sFun): String = getSignature(List(StringFun, IntFun, DoubleFun), StringFun)
  def getSignatureStringIntString2String(f: (sFun, iFun, sFun) => sFun): String = getSignature(List(StringFun, IntFun, StringFun), StringFun)
  def getSignatureStringIntBoolean2String(f: (sFun, iFun, bFun) => sFun): String = getSignature(List(StringFun, IntFun, BooleanFun), StringFun)
  def getSignatureStringLongInt2String(f: (sFun, lFun, iFun) => sFun): String = getSignature(List(StringFun, LongFun, IntFun), StringFun)
  def getSignatureStringLongLong2String(f: (sFun, lFun, lFun) => sFun): String = getSignature(List(StringFun, LongFun, LongFun), StringFun)
  def getSignatureStringLongDouble2String(f: (sFun, lFun, dFun) => sFun): String = getSignature(List(StringFun, LongFun, DoubleFun), StringFun)
  def getSignatureStringLongString2String(f: (sFun, lFun, sFun) => sFun): String = getSignature(List(StringFun, LongFun, StringFun), StringFun)
  def getSignatureStringLongBoolean2String(f: (sFun, lFun, bFun) => sFun): String = getSignature(List(StringFun, LongFun, BooleanFun), StringFun)
  def getSignatureStringDoubleInt2String(f: (sFun, dFun, iFun) => sFun): String = getSignature(List(StringFun, DoubleFun, IntFun), StringFun)
  def getSignatureStringDoubleLong2String(f: (sFun, dFun, lFun) => sFun): String = getSignature(List(StringFun, DoubleFun, LongFun), StringFun)
  def getSignatureStringDoubleDouble2String(f: (sFun, dFun, dFun) => sFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureStringDoubleString2String(f: (sFun, dFun, sFun) => sFun): String = getSignature(List(StringFun, DoubleFun, StringFun), StringFun)
  def getSignatureStringDoubleBoolean2String(f: (sFun, dFun, bFun) => sFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureStringStringInt2String(f: (sFun, sFun, iFun) => sFun): String = getSignature(List(StringFun, StringFun, IntFun), StringFun)
  def getSignatureStringStringLong2String(f: (sFun, sFun, lFun) => sFun): String = getSignature(List(StringFun, StringFun, LongFun), StringFun)
  def getSignatureStringStringDouble2String(f: (sFun, sFun, dFun) => sFun): String = getSignature(List(StringFun, StringFun, DoubleFun), StringFun)
  def getSignatureStringStringString2String(f: (sFun, sFun, sFun) => sFun): String = getSignature(List(StringFun, StringFun, StringFun), StringFun)
  def getSignatureStringStringBoolean2String(f: (sFun, sFun, bFun) => sFun): String = getSignature(List(StringFun, StringFun, BooleanFun), StringFun)
  def getSignatureStringBooleanInt2String(f: (sFun, bFun, iFun) => sFun): String = getSignature(List(StringFun, BooleanFun, IntFun), StringFun)
  def getSignatureStringBooleanLong2String(f: (sFun, bFun, lFun) => sFun): String = getSignature(List(StringFun, BooleanFun, LongFun), StringFun)
  def getSignatureStringBooleanDouble2String(f: (sFun, bFun, dFun) => sFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureStringBooleanString2String(f: (sFun, bFun, sFun) => sFun): String = getSignature(List(StringFun, BooleanFun, StringFun), StringFun)
  def getSignatureStringBooleanBoolean2String(f: (sFun, bFun, bFun) => sFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureBooleanIntInt2String(f: (bFun, iFun, iFun) => sFun): String = getSignature(List(BooleanFun, IntFun, IntFun), StringFun)
  def getSignatureBooleanIntLong2String(f: (bFun, iFun, lFun) => sFun): String = getSignature(List(BooleanFun, IntFun, LongFun), StringFun)
  def getSignatureBooleanIntDouble2String(f: (bFun, iFun, dFun) => sFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun), StringFun)
  def getSignatureBooleanIntString2String(f: (bFun, iFun, sFun) => sFun): String = getSignature(List(BooleanFun, IntFun, StringFun), StringFun)
  def getSignatureBooleanIntBoolean2String(f: (bFun, iFun, bFun) => sFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun), StringFun)
  def getSignatureBooleanLongInt2String(f: (bFun, lFun, iFun) => sFun): String = getSignature(List(BooleanFun, LongFun, IntFun), StringFun)
  def getSignatureBooleanLongLong2String(f: (bFun, lFun, lFun) => sFun): String = getSignature(List(BooleanFun, LongFun, LongFun), StringFun)
  def getSignatureBooleanLongDouble2String(f: (bFun, lFun, dFun) => sFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun), StringFun)
  def getSignatureBooleanLongString2String(f: (bFun, lFun, sFun) => sFun): String = getSignature(List(BooleanFun, LongFun, StringFun), StringFun)
  def getSignatureBooleanLongBoolean2String(f: (bFun, lFun, bFun) => sFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun), StringFun)
  def getSignatureBooleanDoubleInt2String(f: (bFun, dFun, iFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun), StringFun)
  def getSignatureBooleanDoubleLong2String(f: (bFun, dFun, lFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun), StringFun)
  def getSignatureBooleanDoubleDouble2String(f: (bFun, dFun, dFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureBooleanDoubleString2String(f: (bFun, dFun, sFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun), StringFun)
  def getSignatureBooleanDoubleBoolean2String(f: (bFun, dFun, bFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureBooleanStringInt2String(f: (bFun, sFun, iFun) => sFun): String = getSignature(List(BooleanFun, StringFun, IntFun), StringFun)
  def getSignatureBooleanStringLong2String(f: (bFun, sFun, lFun) => sFun): String = getSignature(List(BooleanFun, StringFun, LongFun), StringFun)
  def getSignatureBooleanStringDouble2String(f: (bFun, sFun, dFun) => sFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun), StringFun)
  def getSignatureBooleanStringString2String(f: (bFun, sFun, sFun) => sFun): String = getSignature(List(BooleanFun, StringFun, StringFun), StringFun)
  def getSignatureBooleanStringBoolean2String(f: (bFun, sFun, bFun) => sFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun), StringFun)
  def getSignatureBooleanBooleanInt2String(f: (bFun, bFun, iFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun), StringFun)
  def getSignatureBooleanBooleanLong2String(f: (bFun, bFun, lFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun), StringFun)
  def getSignatureBooleanBooleanDouble2String(f: (bFun, bFun, dFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureBooleanBooleanString2String(f: (bFun, bFun, sFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun), StringFun)
  def getSignatureBooleanBooleanBoolean2String(f: (bFun, bFun, bFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureIntIntInt2Boolean(f: (iFun, iFun, iFun) => bFun): String = getSignature(List(IntFun, IntFun, IntFun), BooleanFun)
  def getSignatureIntIntLong2Boolean(f: (iFun, iFun, lFun) => bFun): String = getSignature(List(IntFun, IntFun, LongFun), BooleanFun)
  def getSignatureIntIntDouble2Boolean(f: (iFun, iFun, dFun) => bFun): String = getSignature(List(IntFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureIntIntString2Boolean(f: (iFun, iFun, sFun) => bFun): String = getSignature(List(IntFun, IntFun, StringFun), BooleanFun)
  def getSignatureIntIntBoolean2Boolean(f: (iFun, iFun, bFun) => bFun): String = getSignature(List(IntFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureIntLongInt2Boolean(f: (iFun, lFun, iFun) => bFun): String = getSignature(List(IntFun, LongFun, IntFun), BooleanFun)
  def getSignatureIntLongLong2Boolean(f: (iFun, lFun, lFun) => bFun): String = getSignature(List(IntFun, LongFun, LongFun), BooleanFun)
  def getSignatureIntLongDouble2Boolean(f: (iFun, lFun, dFun) => bFun): String = getSignature(List(IntFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureIntLongString2Boolean(f: (iFun, lFun, sFun) => bFun): String = getSignature(List(IntFun, LongFun, StringFun), BooleanFun)
  def getSignatureIntLongBoolean2Boolean(f: (iFun, lFun, bFun) => bFun): String = getSignature(List(IntFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureIntDoubleInt2Boolean(f: (iFun, dFun, iFun) => bFun): String = getSignature(List(IntFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureIntDoubleLong2Boolean(f: (iFun, dFun, lFun) => bFun): String = getSignature(List(IntFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureIntDoubleDouble2Boolean(f: (iFun, dFun, dFun) => bFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureIntDoubleString2Boolean(f: (iFun, dFun, sFun) => bFun): String = getSignature(List(IntFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureIntDoubleBoolean2Boolean(f: (iFun, dFun, bFun) => bFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureIntStringInt2Boolean(f: (iFun, sFun, iFun) => bFun): String = getSignature(List(IntFun, StringFun, IntFun), BooleanFun)
  def getSignatureIntStringLong2Boolean(f: (iFun, sFun, lFun) => bFun): String = getSignature(List(IntFun, StringFun, LongFun), BooleanFun)
  def getSignatureIntStringDouble2Boolean(f: (iFun, sFun, dFun) => bFun): String = getSignature(List(IntFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureIntStringString2Boolean(f: (iFun, sFun, sFun) => bFun): String = getSignature(List(IntFun, StringFun, StringFun), BooleanFun)
  def getSignatureIntStringBoolean2Boolean(f: (iFun, sFun, bFun) => bFun): String = getSignature(List(IntFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureIntBooleanInt2Boolean(f: (iFun, bFun, iFun) => bFun): String = getSignature(List(IntFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureIntBooleanLong2Boolean(f: (iFun, bFun, lFun) => bFun): String = getSignature(List(IntFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureIntBooleanDouble2Boolean(f: (iFun, bFun, dFun) => bFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureIntBooleanString2Boolean(f: (iFun, bFun, sFun) => bFun): String = getSignature(List(IntFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureIntBooleanBoolean2Boolean(f: (iFun, bFun, bFun) => bFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureLongIntInt2Boolean(f: (lFun, iFun, iFun) => bFun): String = getSignature(List(LongFun, IntFun, IntFun), BooleanFun)
  def getSignatureLongIntLong2Boolean(f: (lFun, iFun, lFun) => bFun): String = getSignature(List(LongFun, IntFun, LongFun), BooleanFun)
  def getSignatureLongIntDouble2Boolean(f: (lFun, iFun, dFun) => bFun): String = getSignature(List(LongFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureLongIntString2Boolean(f: (lFun, iFun, sFun) => bFun): String = getSignature(List(LongFun, IntFun, StringFun), BooleanFun)
  def getSignatureLongIntBoolean2Boolean(f: (lFun, iFun, bFun) => bFun): String = getSignature(List(LongFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureLongLongInt2Boolean(f: (lFun, lFun, iFun) => bFun): String = getSignature(List(LongFun, LongFun, IntFun), BooleanFun)
  def getSignatureLongLongLong2Boolean(f: (lFun, lFun, lFun) => bFun): String = getSignature(List(LongFun, LongFun, LongFun), BooleanFun)
  def getSignatureLongLongDouble2Boolean(f: (lFun, lFun, dFun) => bFun): String = getSignature(List(LongFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureLongLongString2Boolean(f: (lFun, lFun, sFun) => bFun): String = getSignature(List(LongFun, LongFun, StringFun), BooleanFun)
  def getSignatureLongLongBoolean2Boolean(f: (lFun, lFun, bFun) => bFun): String = getSignature(List(LongFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureLongDoubleInt2Boolean(f: (lFun, dFun, iFun) => bFun): String = getSignature(List(LongFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureLongDoubleLong2Boolean(f: (lFun, dFun, lFun) => bFun): String = getSignature(List(LongFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureLongDoubleDouble2Boolean(f: (lFun, dFun, dFun) => bFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureLongDoubleString2Boolean(f: (lFun, dFun, sFun) => bFun): String = getSignature(List(LongFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureLongDoubleBoolean2Boolean(f: (lFun, dFun, bFun) => bFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureLongStringInt2Boolean(f: (lFun, sFun, iFun) => bFun): String = getSignature(List(LongFun, StringFun, IntFun), BooleanFun)
  def getSignatureLongStringLong2Boolean(f: (lFun, sFun, lFun) => bFun): String = getSignature(List(LongFun, StringFun, LongFun), BooleanFun)
  def getSignatureLongStringDouble2Boolean(f: (lFun, sFun, dFun) => bFun): String = getSignature(List(LongFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureLongStringString2Boolean(f: (lFun, sFun, sFun) => bFun): String = getSignature(List(LongFun, StringFun, StringFun), BooleanFun)
  def getSignatureLongStringBoolean2Boolean(f: (lFun, sFun, bFun) => bFun): String = getSignature(List(LongFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureLongBooleanInt2Boolean(f: (lFun, bFun, iFun) => bFun): String = getSignature(List(LongFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureLongBooleanLong2Boolean(f: (lFun, bFun, lFun) => bFun): String = getSignature(List(LongFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureLongBooleanDouble2Boolean(f: (lFun, bFun, dFun) => bFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureLongBooleanString2Boolean(f: (lFun, bFun, sFun) => bFun): String = getSignature(List(LongFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureLongBooleanBoolean2Boolean(f: (lFun, bFun, bFun) => bFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureDoubleIntInt2Boolean(f: (dFun, iFun, iFun) => bFun): String = getSignature(List(DoubleFun, IntFun, IntFun), BooleanFun)
  def getSignatureDoubleIntLong2Boolean(f: (dFun, iFun, lFun) => bFun): String = getSignature(List(DoubleFun, IntFun, LongFun), BooleanFun)
  def getSignatureDoubleIntDouble2Boolean(f: (dFun, iFun, dFun) => bFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureDoubleIntString2Boolean(f: (dFun, iFun, sFun) => bFun): String = getSignature(List(DoubleFun, IntFun, StringFun), BooleanFun)
  def getSignatureDoubleIntBoolean2Boolean(f: (dFun, iFun, bFun) => bFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureDoubleLongInt2Boolean(f: (dFun, lFun, iFun) => bFun): String = getSignature(List(DoubleFun, LongFun, IntFun), BooleanFun)
  def getSignatureDoubleLongLong2Boolean(f: (dFun, lFun, lFun) => bFun): String = getSignature(List(DoubleFun, LongFun, LongFun), BooleanFun)
  def getSignatureDoubleLongDouble2Boolean(f: (dFun, lFun, dFun) => bFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureDoubleLongString2Boolean(f: (dFun, lFun, sFun) => bFun): String = getSignature(List(DoubleFun, LongFun, StringFun), BooleanFun)
  def getSignatureDoubleLongBoolean2Boolean(f: (dFun, lFun, bFun) => bFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureDoubleDoubleInt2Boolean(f: (dFun, dFun, iFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureDoubleDoubleLong2Boolean(f: (dFun, dFun, lFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureDoubleDoubleDouble2Boolean(f: (dFun, dFun, dFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureDoubleDoubleString2Boolean(f: (dFun, dFun, sFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureDoubleDoubleBoolean2Boolean(f: (dFun, dFun, bFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureDoubleStringInt2Boolean(f: (dFun, sFun, iFun) => bFun): String = getSignature(List(DoubleFun, StringFun, IntFun), BooleanFun)
  def getSignatureDoubleStringLong2Boolean(f: (dFun, sFun, lFun) => bFun): String = getSignature(List(DoubleFun, StringFun, LongFun), BooleanFun)
  def getSignatureDoubleStringDouble2Boolean(f: (dFun, sFun, dFun) => bFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureDoubleStringString2Boolean(f: (dFun, sFun, sFun) => bFun): String = getSignature(List(DoubleFun, StringFun, StringFun), BooleanFun)
  def getSignatureDoubleStringBoolean2Boolean(f: (dFun, sFun, bFun) => bFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureDoubleBooleanInt2Boolean(f: (dFun, bFun, iFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureDoubleBooleanLong2Boolean(f: (dFun, bFun, lFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureDoubleBooleanDouble2Boolean(f: (dFun, bFun, dFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureDoubleBooleanString2Boolean(f: (dFun, bFun, sFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureDoubleBooleanBoolean2Boolean(f: (dFun, bFun, bFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureStringIntInt2Boolean(f: (sFun, iFun, iFun) => bFun): String = getSignature(List(StringFun, IntFun, IntFun), BooleanFun)
  def getSignatureStringIntLong2Boolean(f: (sFun, iFun, lFun) => bFun): String = getSignature(List(StringFun, IntFun, LongFun), BooleanFun)
  def getSignatureStringIntDouble2Boolean(f: (sFun, iFun, dFun) => bFun): String = getSignature(List(StringFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureStringIntString2Boolean(f: (sFun, iFun, sFun) => bFun): String = getSignature(List(StringFun, IntFun, StringFun), BooleanFun)
  def getSignatureStringIntBoolean2Boolean(f: (sFun, iFun, bFun) => bFun): String = getSignature(List(StringFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureStringLongInt2Boolean(f: (sFun, lFun, iFun) => bFun): String = getSignature(List(StringFun, LongFun, IntFun), BooleanFun)
  def getSignatureStringLongLong2Boolean(f: (sFun, lFun, lFun) => bFun): String = getSignature(List(StringFun, LongFun, LongFun), BooleanFun)
  def getSignatureStringLongDouble2Boolean(f: (sFun, lFun, dFun) => bFun): String = getSignature(List(StringFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureStringLongString2Boolean(f: (sFun, lFun, sFun) => bFun): String = getSignature(List(StringFun, LongFun, StringFun), BooleanFun)
  def getSignatureStringLongBoolean2Boolean(f: (sFun, lFun, bFun) => bFun): String = getSignature(List(StringFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureStringDoubleInt2Boolean(f: (sFun, dFun, iFun) => bFun): String = getSignature(List(StringFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureStringDoubleLong2Boolean(f: (sFun, dFun, lFun) => bFun): String = getSignature(List(StringFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureStringDoubleDouble2Boolean(f: (sFun, dFun, dFun) => bFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureStringDoubleString2Boolean(f: (sFun, dFun, sFun) => bFun): String = getSignature(List(StringFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureStringDoubleBoolean2Boolean(f: (sFun, dFun, bFun) => bFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureStringStringInt2Boolean(f: (sFun, sFun, iFun) => bFun): String = getSignature(List(StringFun, StringFun, IntFun), BooleanFun)
  def getSignatureStringStringLong2Boolean(f: (sFun, sFun, lFun) => bFun): String = getSignature(List(StringFun, StringFun, LongFun), BooleanFun)
  def getSignatureStringStringDouble2Boolean(f: (sFun, sFun, dFun) => bFun): String = getSignature(List(StringFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureStringStringString2Boolean(f: (sFun, sFun, sFun) => bFun): String = getSignature(List(StringFun, StringFun, StringFun), BooleanFun)
  def getSignatureStringStringBoolean2Boolean(f: (sFun, sFun, bFun) => bFun): String = getSignature(List(StringFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureStringBooleanInt2Boolean(f: (sFun, bFun, iFun) => bFun): String = getSignature(List(StringFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureStringBooleanLong2Boolean(f: (sFun, bFun, lFun) => bFun): String = getSignature(List(StringFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureStringBooleanDouble2Boolean(f: (sFun, bFun, dFun) => bFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureStringBooleanString2Boolean(f: (sFun, bFun, sFun) => bFun): String = getSignature(List(StringFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureStringBooleanBoolean2Boolean(f: (sFun, bFun, bFun) => bFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureBooleanIntInt2Boolean(f: (bFun, iFun, iFun) => bFun): String = getSignature(List(BooleanFun, IntFun, IntFun), BooleanFun)
  def getSignatureBooleanIntLong2Boolean(f: (bFun, iFun, lFun) => bFun): String = getSignature(List(BooleanFun, IntFun, LongFun), BooleanFun)
  def getSignatureBooleanIntDouble2Boolean(f: (bFun, iFun, dFun) => bFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureBooleanIntString2Boolean(f: (bFun, iFun, sFun) => bFun): String = getSignature(List(BooleanFun, IntFun, StringFun), BooleanFun)
  def getSignatureBooleanIntBoolean2Boolean(f: (bFun, iFun, bFun) => bFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureBooleanLongInt2Boolean(f: (bFun, lFun, iFun) => bFun): String = getSignature(List(BooleanFun, LongFun, IntFun), BooleanFun)
  def getSignatureBooleanLongLong2Boolean(f: (bFun, lFun, lFun) => bFun): String = getSignature(List(BooleanFun, LongFun, LongFun), BooleanFun)
  def getSignatureBooleanLongDouble2Boolean(f: (bFun, lFun, dFun) => bFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureBooleanLongString2Boolean(f: (bFun, lFun, sFun) => bFun): String = getSignature(List(BooleanFun, LongFun, StringFun), BooleanFun)
  def getSignatureBooleanLongBoolean2Boolean(f: (bFun, lFun, bFun) => bFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureBooleanDoubleInt2Boolean(f: (bFun, dFun, iFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureBooleanDoubleLong2Boolean(f: (bFun, dFun, lFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureBooleanDoubleDouble2Boolean(f: (bFun, dFun, dFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureBooleanDoubleString2Boolean(f: (bFun, dFun, sFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureBooleanDoubleBoolean2Boolean(f: (bFun, dFun, bFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureBooleanStringInt2Boolean(f: (bFun, sFun, iFun) => bFun): String = getSignature(List(BooleanFun, StringFun, IntFun), BooleanFun)
  def getSignatureBooleanStringLong2Boolean(f: (bFun, sFun, lFun) => bFun): String = getSignature(List(BooleanFun, StringFun, LongFun), BooleanFun)
  def getSignatureBooleanStringDouble2Boolean(f: (bFun, sFun, dFun) => bFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureBooleanStringString2Boolean(f: (bFun, sFun, sFun) => bFun): String = getSignature(List(BooleanFun, StringFun, StringFun), BooleanFun)
  def getSignatureBooleanStringBoolean2Boolean(f: (bFun, sFun, bFun) => bFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureBooleanBooleanInt2Boolean(f: (bFun, bFun, iFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureBooleanBooleanLong2Boolean(f: (bFun, bFun, lFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureBooleanBooleanDouble2Boolean(f: (bFun, bFun, dFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureBooleanBooleanString2Boolean(f: (bFun, bFun, sFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureBooleanBooleanBoolean2Boolean(f: (bFun, bFun, bFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureIntIntIntInt2Int(f: (iFun, iFun, iFun, iFun) => iFun): String = getSignature(List(IntFun, IntFun, IntFun, IntFun), IntFun)
  def getSignatureIntIntIntLong2Int(f: (iFun, iFun, iFun, lFun) => iFun): String = getSignature(List(IntFun, IntFun, IntFun, LongFun), IntFun)
  def getSignatureIntIntIntDouble2Int(f: (iFun, iFun, iFun, dFun) => iFun): String = getSignature(List(IntFun, IntFun, IntFun, DoubleFun), IntFun)
  def getSignatureIntIntIntString2Int(f: (iFun, iFun, iFun, sFun) => iFun): String = getSignature(List(IntFun, IntFun, IntFun, StringFun), IntFun)
  def getSignatureIntIntIntBoolean2Int(f: (iFun, iFun, iFun, bFun) => iFun): String = getSignature(List(IntFun, IntFun, IntFun, BooleanFun), IntFun)
  def getSignatureIntIntLongInt2Int(f: (iFun, iFun, lFun, iFun) => iFun): String = getSignature(List(IntFun, IntFun, LongFun, IntFun), IntFun)
  def getSignatureIntIntLongLong2Int(f: (iFun, iFun, lFun, lFun) => iFun): String = getSignature(List(IntFun, IntFun, LongFun, LongFun), IntFun)
  def getSignatureIntIntLongDouble2Int(f: (iFun, iFun, lFun, dFun) => iFun): String = getSignature(List(IntFun, IntFun, LongFun, DoubleFun), IntFun)
  def getSignatureIntIntLongString2Int(f: (iFun, iFun, lFun, sFun) => iFun): String = getSignature(List(IntFun, IntFun, LongFun, StringFun), IntFun)
  def getSignatureIntIntLongBoolean2Int(f: (iFun, iFun, lFun, bFun) => iFun): String = getSignature(List(IntFun, IntFun, LongFun, BooleanFun), IntFun)
  def getSignatureIntIntDoubleInt2Int(f: (iFun, iFun, dFun, iFun) => iFun): String = getSignature(List(IntFun, IntFun, DoubleFun, IntFun), IntFun)
  def getSignatureIntIntDoubleLong2Int(f: (iFun, iFun, dFun, lFun) => iFun): String = getSignature(List(IntFun, IntFun, DoubleFun, LongFun), IntFun)
  def getSignatureIntIntDoubleDouble2Int(f: (iFun, iFun, dFun, dFun) => iFun): String = getSignature(List(IntFun, IntFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureIntIntDoubleString2Int(f: (iFun, iFun, dFun, sFun) => iFun): String = getSignature(List(IntFun, IntFun, DoubleFun, StringFun), IntFun)
  def getSignatureIntIntDoubleBoolean2Int(f: (iFun, iFun, dFun, bFun) => iFun): String = getSignature(List(IntFun, IntFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureIntIntStringInt2Int(f: (iFun, iFun, sFun, iFun) => iFun): String = getSignature(List(IntFun, IntFun, StringFun, IntFun), IntFun)
  def getSignatureIntIntStringLong2Int(f: (iFun, iFun, sFun, lFun) => iFun): String = getSignature(List(IntFun, IntFun, StringFun, LongFun), IntFun)
  def getSignatureIntIntStringDouble2Int(f: (iFun, iFun, sFun, dFun) => iFun): String = getSignature(List(IntFun, IntFun, StringFun, DoubleFun), IntFun)
  def getSignatureIntIntStringString2Int(f: (iFun, iFun, sFun, sFun) => iFun): String = getSignature(List(IntFun, IntFun, StringFun, StringFun), IntFun)
  def getSignatureIntIntStringBoolean2Int(f: (iFun, iFun, sFun, bFun) => iFun): String = getSignature(List(IntFun, IntFun, StringFun, BooleanFun), IntFun)
  def getSignatureIntIntBooleanInt2Int(f: (iFun, iFun, bFun, iFun) => iFun): String = getSignature(List(IntFun, IntFun, BooleanFun, IntFun), IntFun)
  def getSignatureIntIntBooleanLong2Int(f: (iFun, iFun, bFun, lFun) => iFun): String = getSignature(List(IntFun, IntFun, BooleanFun, LongFun), IntFun)
  def getSignatureIntIntBooleanDouble2Int(f: (iFun, iFun, bFun, dFun) => iFun): String = getSignature(List(IntFun, IntFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureIntIntBooleanString2Int(f: (iFun, iFun, bFun, sFun) => iFun): String = getSignature(List(IntFun, IntFun, BooleanFun, StringFun), IntFun)
  def getSignatureIntIntBooleanBoolean2Int(f: (iFun, iFun, bFun, bFun) => iFun): String = getSignature(List(IntFun, IntFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureIntLongIntInt2Int(f: (iFun, lFun, iFun, iFun) => iFun): String = getSignature(List(IntFun, LongFun, IntFun, IntFun), IntFun)
  def getSignatureIntLongIntLong2Int(f: (iFun, lFun, iFun, lFun) => iFun): String = getSignature(List(IntFun, LongFun, IntFun, LongFun), IntFun)
  def getSignatureIntLongIntDouble2Int(f: (iFun, lFun, iFun, dFun) => iFun): String = getSignature(List(IntFun, LongFun, IntFun, DoubleFun), IntFun)
  def getSignatureIntLongIntString2Int(f: (iFun, lFun, iFun, sFun) => iFun): String = getSignature(List(IntFun, LongFun, IntFun, StringFun), IntFun)
  def getSignatureIntLongIntBoolean2Int(f: (iFun, lFun, iFun, bFun) => iFun): String = getSignature(List(IntFun, LongFun, IntFun, BooleanFun), IntFun)
  def getSignatureIntLongLongInt2Int(f: (iFun, lFun, lFun, iFun) => iFun): String = getSignature(List(IntFun, LongFun, LongFun, IntFun), IntFun)
  def getSignatureIntLongLongLong2Int(f: (iFun, lFun, lFun, lFun) => iFun): String = getSignature(List(IntFun, LongFun, LongFun, LongFun), IntFun)
  def getSignatureIntLongLongDouble2Int(f: (iFun, lFun, lFun, dFun) => iFun): String = getSignature(List(IntFun, LongFun, LongFun, DoubleFun), IntFun)
  def getSignatureIntLongLongString2Int(f: (iFun, lFun, lFun, sFun) => iFun): String = getSignature(List(IntFun, LongFun, LongFun, StringFun), IntFun)
  def getSignatureIntLongLongBoolean2Int(f: (iFun, lFun, lFun, bFun) => iFun): String = getSignature(List(IntFun, LongFun, LongFun, BooleanFun), IntFun)
  def getSignatureIntLongDoubleInt2Int(f: (iFun, lFun, dFun, iFun) => iFun): String = getSignature(List(IntFun, LongFun, DoubleFun, IntFun), IntFun)
  def getSignatureIntLongDoubleLong2Int(f: (iFun, lFun, dFun, lFun) => iFun): String = getSignature(List(IntFun, LongFun, DoubleFun, LongFun), IntFun)
  def getSignatureIntLongDoubleDouble2Int(f: (iFun, lFun, dFun, dFun) => iFun): String = getSignature(List(IntFun, LongFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureIntLongDoubleString2Int(f: (iFun, lFun, dFun, sFun) => iFun): String = getSignature(List(IntFun, LongFun, DoubleFun, StringFun), IntFun)
  def getSignatureIntLongDoubleBoolean2Int(f: (iFun, lFun, dFun, bFun) => iFun): String = getSignature(List(IntFun, LongFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureIntLongStringInt2Int(f: (iFun, lFun, sFun, iFun) => iFun): String = getSignature(List(IntFun, LongFun, StringFun, IntFun), IntFun)
  def getSignatureIntLongStringLong2Int(f: (iFun, lFun, sFun, lFun) => iFun): String = getSignature(List(IntFun, LongFun, StringFun, LongFun), IntFun)
  def getSignatureIntLongStringDouble2Int(f: (iFun, lFun, sFun, dFun) => iFun): String = getSignature(List(IntFun, LongFun, StringFun, DoubleFun), IntFun)
  def getSignatureIntLongStringString2Int(f: (iFun, lFun, sFun, sFun) => iFun): String = getSignature(List(IntFun, LongFun, StringFun, StringFun), IntFun)
  def getSignatureIntLongStringBoolean2Int(f: (iFun, lFun, sFun, bFun) => iFun): String = getSignature(List(IntFun, LongFun, StringFun, BooleanFun), IntFun)
  def getSignatureIntLongBooleanInt2Int(f: (iFun, lFun, bFun, iFun) => iFun): String = getSignature(List(IntFun, LongFun, BooleanFun, IntFun), IntFun)
  def getSignatureIntLongBooleanLong2Int(f: (iFun, lFun, bFun, lFun) => iFun): String = getSignature(List(IntFun, LongFun, BooleanFun, LongFun), IntFun)
  def getSignatureIntLongBooleanDouble2Int(f: (iFun, lFun, bFun, dFun) => iFun): String = getSignature(List(IntFun, LongFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureIntLongBooleanString2Int(f: (iFun, lFun, bFun, sFun) => iFun): String = getSignature(List(IntFun, LongFun, BooleanFun, StringFun), IntFun)
  def getSignatureIntLongBooleanBoolean2Int(f: (iFun, lFun, bFun, bFun) => iFun): String = getSignature(List(IntFun, LongFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureIntDoubleIntInt2Int(f: (iFun, dFun, iFun, iFun) => iFun): String = getSignature(List(IntFun, DoubleFun, IntFun, IntFun), IntFun)
  def getSignatureIntDoubleIntLong2Int(f: (iFun, dFun, iFun, lFun) => iFun): String = getSignature(List(IntFun, DoubleFun, IntFun, LongFun), IntFun)
  def getSignatureIntDoubleIntDouble2Int(f: (iFun, dFun, iFun, dFun) => iFun): String = getSignature(List(IntFun, DoubleFun, IntFun, DoubleFun), IntFun)
  def getSignatureIntDoubleIntString2Int(f: (iFun, dFun, iFun, sFun) => iFun): String = getSignature(List(IntFun, DoubleFun, IntFun, StringFun), IntFun)
  def getSignatureIntDoubleIntBoolean2Int(f: (iFun, dFun, iFun, bFun) => iFun): String = getSignature(List(IntFun, DoubleFun, IntFun, BooleanFun), IntFun)
  def getSignatureIntDoubleLongInt2Int(f: (iFun, dFun, lFun, iFun) => iFun): String = getSignature(List(IntFun, DoubleFun, LongFun, IntFun), IntFun)
  def getSignatureIntDoubleLongLong2Int(f: (iFun, dFun, lFun, lFun) => iFun): String = getSignature(List(IntFun, DoubleFun, LongFun, LongFun), IntFun)
  def getSignatureIntDoubleLongDouble2Int(f: (iFun, dFun, lFun, dFun) => iFun): String = getSignature(List(IntFun, DoubleFun, LongFun, DoubleFun), IntFun)
  def getSignatureIntDoubleLongString2Int(f: (iFun, dFun, lFun, sFun) => iFun): String = getSignature(List(IntFun, DoubleFun, LongFun, StringFun), IntFun)
  def getSignatureIntDoubleLongBoolean2Int(f: (iFun, dFun, lFun, bFun) => iFun): String = getSignature(List(IntFun, DoubleFun, LongFun, BooleanFun), IntFun)
  def getSignatureIntDoubleDoubleInt2Int(f: (iFun, dFun, dFun, iFun) => iFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, IntFun), IntFun)
  def getSignatureIntDoubleDoubleLong2Int(f: (iFun, dFun, dFun, lFun) => iFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, LongFun), IntFun)
  def getSignatureIntDoubleDoubleDouble2Int(f: (iFun, dFun, dFun, dFun) => iFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureIntDoubleDoubleString2Int(f: (iFun, dFun, dFun, sFun) => iFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, StringFun), IntFun)
  def getSignatureIntDoubleDoubleBoolean2Int(f: (iFun, dFun, dFun, bFun) => iFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureIntDoubleStringInt2Int(f: (iFun, dFun, sFun, iFun) => iFun): String = getSignature(List(IntFun, DoubleFun, StringFun, IntFun), IntFun)
  def getSignatureIntDoubleStringLong2Int(f: (iFun, dFun, sFun, lFun) => iFun): String = getSignature(List(IntFun, DoubleFun, StringFun, LongFun), IntFun)
  def getSignatureIntDoubleStringDouble2Int(f: (iFun, dFun, sFun, dFun) => iFun): String = getSignature(List(IntFun, DoubleFun, StringFun, DoubleFun), IntFun)
  def getSignatureIntDoubleStringString2Int(f: (iFun, dFun, sFun, sFun) => iFun): String = getSignature(List(IntFun, DoubleFun, StringFun, StringFun), IntFun)
  def getSignatureIntDoubleStringBoolean2Int(f: (iFun, dFun, sFun, bFun) => iFun): String = getSignature(List(IntFun, DoubleFun, StringFun, BooleanFun), IntFun)
  def getSignatureIntDoubleBooleanInt2Int(f: (iFun, dFun, bFun, iFun) => iFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, IntFun), IntFun)
  def getSignatureIntDoubleBooleanLong2Int(f: (iFun, dFun, bFun, lFun) => iFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, LongFun), IntFun)
  def getSignatureIntDoubleBooleanDouble2Int(f: (iFun, dFun, bFun, dFun) => iFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureIntDoubleBooleanString2Int(f: (iFun, dFun, bFun, sFun) => iFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, StringFun), IntFun)
  def getSignatureIntDoubleBooleanBoolean2Int(f: (iFun, dFun, bFun, bFun) => iFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureIntStringIntInt2Int(f: (iFun, sFun, iFun, iFun) => iFun): String = getSignature(List(IntFun, StringFun, IntFun, IntFun), IntFun)
  def getSignatureIntStringIntLong2Int(f: (iFun, sFun, iFun, lFun) => iFun): String = getSignature(List(IntFun, StringFun, IntFun, LongFun), IntFun)
  def getSignatureIntStringIntDouble2Int(f: (iFun, sFun, iFun, dFun) => iFun): String = getSignature(List(IntFun, StringFun, IntFun, DoubleFun), IntFun)
  def getSignatureIntStringIntString2Int(f: (iFun, sFun, iFun, sFun) => iFun): String = getSignature(List(IntFun, StringFun, IntFun, StringFun), IntFun)
  def getSignatureIntStringIntBoolean2Int(f: (iFun, sFun, iFun, bFun) => iFun): String = getSignature(List(IntFun, StringFun, IntFun, BooleanFun), IntFun)
  def getSignatureIntStringLongInt2Int(f: (iFun, sFun, lFun, iFun) => iFun): String = getSignature(List(IntFun, StringFun, LongFun, IntFun), IntFun)
  def getSignatureIntStringLongLong2Int(f: (iFun, sFun, lFun, lFun) => iFun): String = getSignature(List(IntFun, StringFun, LongFun, LongFun), IntFun)
  def getSignatureIntStringLongDouble2Int(f: (iFun, sFun, lFun, dFun) => iFun): String = getSignature(List(IntFun, StringFun, LongFun, DoubleFun), IntFun)
  def getSignatureIntStringLongString2Int(f: (iFun, sFun, lFun, sFun) => iFun): String = getSignature(List(IntFun, StringFun, LongFun, StringFun), IntFun)
  def getSignatureIntStringLongBoolean2Int(f: (iFun, sFun, lFun, bFun) => iFun): String = getSignature(List(IntFun, StringFun, LongFun, BooleanFun), IntFun)
  def getSignatureIntStringDoubleInt2Int(f: (iFun, sFun, dFun, iFun) => iFun): String = getSignature(List(IntFun, StringFun, DoubleFun, IntFun), IntFun)
  def getSignatureIntStringDoubleLong2Int(f: (iFun, sFun, dFun, lFun) => iFun): String = getSignature(List(IntFun, StringFun, DoubleFun, LongFun), IntFun)
  def getSignatureIntStringDoubleDouble2Int(f: (iFun, sFun, dFun, dFun) => iFun): String = getSignature(List(IntFun, StringFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureIntStringDoubleString2Int(f: (iFun, sFun, dFun, sFun) => iFun): String = getSignature(List(IntFun, StringFun, DoubleFun, StringFun), IntFun)
  def getSignatureIntStringDoubleBoolean2Int(f: (iFun, sFun, dFun, bFun) => iFun): String = getSignature(List(IntFun, StringFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureIntStringStringInt2Int(f: (iFun, sFun, sFun, iFun) => iFun): String = getSignature(List(IntFun, StringFun, StringFun, IntFun), IntFun)
  def getSignatureIntStringStringLong2Int(f: (iFun, sFun, sFun, lFun) => iFun): String = getSignature(List(IntFun, StringFun, StringFun, LongFun), IntFun)
  def getSignatureIntStringStringDouble2Int(f: (iFun, sFun, sFun, dFun) => iFun): String = getSignature(List(IntFun, StringFun, StringFun, DoubleFun), IntFun)
  def getSignatureIntStringStringString2Int(f: (iFun, sFun, sFun, sFun) => iFun): String = getSignature(List(IntFun, StringFun, StringFun, StringFun), IntFun)
  def getSignatureIntStringStringBoolean2Int(f: (iFun, sFun, sFun, bFun) => iFun): String = getSignature(List(IntFun, StringFun, StringFun, BooleanFun), IntFun)
  def getSignatureIntStringBooleanInt2Int(f: (iFun, sFun, bFun, iFun) => iFun): String = getSignature(List(IntFun, StringFun, BooleanFun, IntFun), IntFun)
  def getSignatureIntStringBooleanLong2Int(f: (iFun, sFun, bFun, lFun) => iFun): String = getSignature(List(IntFun, StringFun, BooleanFun, LongFun), IntFun)
  def getSignatureIntStringBooleanDouble2Int(f: (iFun, sFun, bFun, dFun) => iFun): String = getSignature(List(IntFun, StringFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureIntStringBooleanString2Int(f: (iFun, sFun, bFun, sFun) => iFun): String = getSignature(List(IntFun, StringFun, BooleanFun, StringFun), IntFun)
  def getSignatureIntStringBooleanBoolean2Int(f: (iFun, sFun, bFun, bFun) => iFun): String = getSignature(List(IntFun, StringFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureIntBooleanIntInt2Int(f: (iFun, bFun, iFun, iFun) => iFun): String = getSignature(List(IntFun, BooleanFun, IntFun, IntFun), IntFun)
  def getSignatureIntBooleanIntLong2Int(f: (iFun, bFun, iFun, lFun) => iFun): String = getSignature(List(IntFun, BooleanFun, IntFun, LongFun), IntFun)
  def getSignatureIntBooleanIntDouble2Int(f: (iFun, bFun, iFun, dFun) => iFun): String = getSignature(List(IntFun, BooleanFun, IntFun, DoubleFun), IntFun)
  def getSignatureIntBooleanIntString2Int(f: (iFun, bFun, iFun, sFun) => iFun): String = getSignature(List(IntFun, BooleanFun, IntFun, StringFun), IntFun)
  def getSignatureIntBooleanIntBoolean2Int(f: (iFun, bFun, iFun, bFun) => iFun): String = getSignature(List(IntFun, BooleanFun, IntFun, BooleanFun), IntFun)
  def getSignatureIntBooleanLongInt2Int(f: (iFun, bFun, lFun, iFun) => iFun): String = getSignature(List(IntFun, BooleanFun, LongFun, IntFun), IntFun)
  def getSignatureIntBooleanLongLong2Int(f: (iFun, bFun, lFun, lFun) => iFun): String = getSignature(List(IntFun, BooleanFun, LongFun, LongFun), IntFun)
  def getSignatureIntBooleanLongDouble2Int(f: (iFun, bFun, lFun, dFun) => iFun): String = getSignature(List(IntFun, BooleanFun, LongFun, DoubleFun), IntFun)
  def getSignatureIntBooleanLongString2Int(f: (iFun, bFun, lFun, sFun) => iFun): String = getSignature(List(IntFun, BooleanFun, LongFun, StringFun), IntFun)
  def getSignatureIntBooleanLongBoolean2Int(f: (iFun, bFun, lFun, bFun) => iFun): String = getSignature(List(IntFun, BooleanFun, LongFun, BooleanFun), IntFun)
  def getSignatureIntBooleanDoubleInt2Int(f: (iFun, bFun, dFun, iFun) => iFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, IntFun), IntFun)
  def getSignatureIntBooleanDoubleLong2Int(f: (iFun, bFun, dFun, lFun) => iFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, LongFun), IntFun)
  def getSignatureIntBooleanDoubleDouble2Int(f: (iFun, bFun, dFun, dFun) => iFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureIntBooleanDoubleString2Int(f: (iFun, bFun, dFun, sFun) => iFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, StringFun), IntFun)
  def getSignatureIntBooleanDoubleBoolean2Int(f: (iFun, bFun, dFun, bFun) => iFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureIntBooleanStringInt2Int(f: (iFun, bFun, sFun, iFun) => iFun): String = getSignature(List(IntFun, BooleanFun, StringFun, IntFun), IntFun)
  def getSignatureIntBooleanStringLong2Int(f: (iFun, bFun, sFun, lFun) => iFun): String = getSignature(List(IntFun, BooleanFun, StringFun, LongFun), IntFun)
  def getSignatureIntBooleanStringDouble2Int(f: (iFun, bFun, sFun, dFun) => iFun): String = getSignature(List(IntFun, BooleanFun, StringFun, DoubleFun), IntFun)
  def getSignatureIntBooleanStringString2Int(f: (iFun, bFun, sFun, sFun) => iFun): String = getSignature(List(IntFun, BooleanFun, StringFun, StringFun), IntFun)
  def getSignatureIntBooleanStringBoolean2Int(f: (iFun, bFun, sFun, bFun) => iFun): String = getSignature(List(IntFun, BooleanFun, StringFun, BooleanFun), IntFun)
  def getSignatureIntBooleanBooleanInt2Int(f: (iFun, bFun, bFun, iFun) => iFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, IntFun), IntFun)
  def getSignatureIntBooleanBooleanLong2Int(f: (iFun, bFun, bFun, lFun) => iFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, LongFun), IntFun)
  def getSignatureIntBooleanBooleanDouble2Int(f: (iFun, bFun, bFun, dFun) => iFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureIntBooleanBooleanString2Int(f: (iFun, bFun, bFun, sFun) => iFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, StringFun), IntFun)
  def getSignatureIntBooleanBooleanBoolean2Int(f: (iFun, bFun, bFun, bFun) => iFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureLongIntIntInt2Int(f: (lFun, iFun, iFun, iFun) => iFun): String = getSignature(List(LongFun, IntFun, IntFun, IntFun), IntFun)
  def getSignatureLongIntIntLong2Int(f: (lFun, iFun, iFun, lFun) => iFun): String = getSignature(List(LongFun, IntFun, IntFun, LongFun), IntFun)
  def getSignatureLongIntIntDouble2Int(f: (lFun, iFun, iFun, dFun) => iFun): String = getSignature(List(LongFun, IntFun, IntFun, DoubleFun), IntFun)
  def getSignatureLongIntIntString2Int(f: (lFun, iFun, iFun, sFun) => iFun): String = getSignature(List(LongFun, IntFun, IntFun, StringFun), IntFun)
  def getSignatureLongIntIntBoolean2Int(f: (lFun, iFun, iFun, bFun) => iFun): String = getSignature(List(LongFun, IntFun, IntFun, BooleanFun), IntFun)
  def getSignatureLongIntLongInt2Int(f: (lFun, iFun, lFun, iFun) => iFun): String = getSignature(List(LongFun, IntFun, LongFun, IntFun), IntFun)
  def getSignatureLongIntLongLong2Int(f: (lFun, iFun, lFun, lFun) => iFun): String = getSignature(List(LongFun, IntFun, LongFun, LongFun), IntFun)
  def getSignatureLongIntLongDouble2Int(f: (lFun, iFun, lFun, dFun) => iFun): String = getSignature(List(LongFun, IntFun, LongFun, DoubleFun), IntFun)
  def getSignatureLongIntLongString2Int(f: (lFun, iFun, lFun, sFun) => iFun): String = getSignature(List(LongFun, IntFun, LongFun, StringFun), IntFun)
  def getSignatureLongIntLongBoolean2Int(f: (lFun, iFun, lFun, bFun) => iFun): String = getSignature(List(LongFun, IntFun, LongFun, BooleanFun), IntFun)
  def getSignatureLongIntDoubleInt2Int(f: (lFun, iFun, dFun, iFun) => iFun): String = getSignature(List(LongFun, IntFun, DoubleFun, IntFun), IntFun)
  def getSignatureLongIntDoubleLong2Int(f: (lFun, iFun, dFun, lFun) => iFun): String = getSignature(List(LongFun, IntFun, DoubleFun, LongFun), IntFun)
  def getSignatureLongIntDoubleDouble2Int(f: (lFun, iFun, dFun, dFun) => iFun): String = getSignature(List(LongFun, IntFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureLongIntDoubleString2Int(f: (lFun, iFun, dFun, sFun) => iFun): String = getSignature(List(LongFun, IntFun, DoubleFun, StringFun), IntFun)
  def getSignatureLongIntDoubleBoolean2Int(f: (lFun, iFun, dFun, bFun) => iFun): String = getSignature(List(LongFun, IntFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureLongIntStringInt2Int(f: (lFun, iFun, sFun, iFun) => iFun): String = getSignature(List(LongFun, IntFun, StringFun, IntFun), IntFun)
  def getSignatureLongIntStringLong2Int(f: (lFun, iFun, sFun, lFun) => iFun): String = getSignature(List(LongFun, IntFun, StringFun, LongFun), IntFun)
  def getSignatureLongIntStringDouble2Int(f: (lFun, iFun, sFun, dFun) => iFun): String = getSignature(List(LongFun, IntFun, StringFun, DoubleFun), IntFun)
  def getSignatureLongIntStringString2Int(f: (lFun, iFun, sFun, sFun) => iFun): String = getSignature(List(LongFun, IntFun, StringFun, StringFun), IntFun)
  def getSignatureLongIntStringBoolean2Int(f: (lFun, iFun, sFun, bFun) => iFun): String = getSignature(List(LongFun, IntFun, StringFun, BooleanFun), IntFun)
  def getSignatureLongIntBooleanInt2Int(f: (lFun, iFun, bFun, iFun) => iFun): String = getSignature(List(LongFun, IntFun, BooleanFun, IntFun), IntFun)
  def getSignatureLongIntBooleanLong2Int(f: (lFun, iFun, bFun, lFun) => iFun): String = getSignature(List(LongFun, IntFun, BooleanFun, LongFun), IntFun)
  def getSignatureLongIntBooleanDouble2Int(f: (lFun, iFun, bFun, dFun) => iFun): String = getSignature(List(LongFun, IntFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureLongIntBooleanString2Int(f: (lFun, iFun, bFun, sFun) => iFun): String = getSignature(List(LongFun, IntFun, BooleanFun, StringFun), IntFun)
  def getSignatureLongIntBooleanBoolean2Int(f: (lFun, iFun, bFun, bFun) => iFun): String = getSignature(List(LongFun, IntFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureLongLongIntInt2Int(f: (lFun, lFun, iFun, iFun) => iFun): String = getSignature(List(LongFun, LongFun, IntFun, IntFun), IntFun)
  def getSignatureLongLongIntLong2Int(f: (lFun, lFun, iFun, lFun) => iFun): String = getSignature(List(LongFun, LongFun, IntFun, LongFun), IntFun)
  def getSignatureLongLongIntDouble2Int(f: (lFun, lFun, iFun, dFun) => iFun): String = getSignature(List(LongFun, LongFun, IntFun, DoubleFun), IntFun)
  def getSignatureLongLongIntString2Int(f: (lFun, lFun, iFun, sFun) => iFun): String = getSignature(List(LongFun, LongFun, IntFun, StringFun), IntFun)
  def getSignatureLongLongIntBoolean2Int(f: (lFun, lFun, iFun, bFun) => iFun): String = getSignature(List(LongFun, LongFun, IntFun, BooleanFun), IntFun)
  def getSignatureLongLongLongInt2Int(f: (lFun, lFun, lFun, iFun) => iFun): String = getSignature(List(LongFun, LongFun, LongFun, IntFun), IntFun)
  def getSignatureLongLongLongLong2Int(f: (lFun, lFun, lFun, lFun) => iFun): String = getSignature(List(LongFun, LongFun, LongFun, LongFun), IntFun)
  def getSignatureLongLongLongDouble2Int(f: (lFun, lFun, lFun, dFun) => iFun): String = getSignature(List(LongFun, LongFun, LongFun, DoubleFun), IntFun)
  def getSignatureLongLongLongString2Int(f: (lFun, lFun, lFun, sFun) => iFun): String = getSignature(List(LongFun, LongFun, LongFun, StringFun), IntFun)
  def getSignatureLongLongLongBoolean2Int(f: (lFun, lFun, lFun, bFun) => iFun): String = getSignature(List(LongFun, LongFun, LongFun, BooleanFun), IntFun)
  def getSignatureLongLongDoubleInt2Int(f: (lFun, lFun, dFun, iFun) => iFun): String = getSignature(List(LongFun, LongFun, DoubleFun, IntFun), IntFun)
  def getSignatureLongLongDoubleLong2Int(f: (lFun, lFun, dFun, lFun) => iFun): String = getSignature(List(LongFun, LongFun, DoubleFun, LongFun), IntFun)
  def getSignatureLongLongDoubleDouble2Int(f: (lFun, lFun, dFun, dFun) => iFun): String = getSignature(List(LongFun, LongFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureLongLongDoubleString2Int(f: (lFun, lFun, dFun, sFun) => iFun): String = getSignature(List(LongFun, LongFun, DoubleFun, StringFun), IntFun)
  def getSignatureLongLongDoubleBoolean2Int(f: (lFun, lFun, dFun, bFun) => iFun): String = getSignature(List(LongFun, LongFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureLongLongStringInt2Int(f: (lFun, lFun, sFun, iFun) => iFun): String = getSignature(List(LongFun, LongFun, StringFun, IntFun), IntFun)
  def getSignatureLongLongStringLong2Int(f: (lFun, lFun, sFun, lFun) => iFun): String = getSignature(List(LongFun, LongFun, StringFun, LongFun), IntFun)
  def getSignatureLongLongStringDouble2Int(f: (lFun, lFun, sFun, dFun) => iFun): String = getSignature(List(LongFun, LongFun, StringFun, DoubleFun), IntFun)
  def getSignatureLongLongStringString2Int(f: (lFun, lFun, sFun, sFun) => iFun): String = getSignature(List(LongFun, LongFun, StringFun, StringFun), IntFun)
  def getSignatureLongLongStringBoolean2Int(f: (lFun, lFun, sFun, bFun) => iFun): String = getSignature(List(LongFun, LongFun, StringFun, BooleanFun), IntFun)
  def getSignatureLongLongBooleanInt2Int(f: (lFun, lFun, bFun, iFun) => iFun): String = getSignature(List(LongFun, LongFun, BooleanFun, IntFun), IntFun)
  def getSignatureLongLongBooleanLong2Int(f: (lFun, lFun, bFun, lFun) => iFun): String = getSignature(List(LongFun, LongFun, BooleanFun, LongFun), IntFun)
  def getSignatureLongLongBooleanDouble2Int(f: (lFun, lFun, bFun, dFun) => iFun): String = getSignature(List(LongFun, LongFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureLongLongBooleanString2Int(f: (lFun, lFun, bFun, sFun) => iFun): String = getSignature(List(LongFun, LongFun, BooleanFun, StringFun), IntFun)
  def getSignatureLongLongBooleanBoolean2Int(f: (lFun, lFun, bFun, bFun) => iFun): String = getSignature(List(LongFun, LongFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureLongDoubleIntInt2Int(f: (lFun, dFun, iFun, iFun) => iFun): String = getSignature(List(LongFun, DoubleFun, IntFun, IntFun), IntFun)
  def getSignatureLongDoubleIntLong2Int(f: (lFun, dFun, iFun, lFun) => iFun): String = getSignature(List(LongFun, DoubleFun, IntFun, LongFun), IntFun)
  def getSignatureLongDoubleIntDouble2Int(f: (lFun, dFun, iFun, dFun) => iFun): String = getSignature(List(LongFun, DoubleFun, IntFun, DoubleFun), IntFun)
  def getSignatureLongDoubleIntString2Int(f: (lFun, dFun, iFun, sFun) => iFun): String = getSignature(List(LongFun, DoubleFun, IntFun, StringFun), IntFun)
  def getSignatureLongDoubleIntBoolean2Int(f: (lFun, dFun, iFun, bFun) => iFun): String = getSignature(List(LongFun, DoubleFun, IntFun, BooleanFun), IntFun)
  def getSignatureLongDoubleLongInt2Int(f: (lFun, dFun, lFun, iFun) => iFun): String = getSignature(List(LongFun, DoubleFun, LongFun, IntFun), IntFun)
  def getSignatureLongDoubleLongLong2Int(f: (lFun, dFun, lFun, lFun) => iFun): String = getSignature(List(LongFun, DoubleFun, LongFun, LongFun), IntFun)
  def getSignatureLongDoubleLongDouble2Int(f: (lFun, dFun, lFun, dFun) => iFun): String = getSignature(List(LongFun, DoubleFun, LongFun, DoubleFun), IntFun)
  def getSignatureLongDoubleLongString2Int(f: (lFun, dFun, lFun, sFun) => iFun): String = getSignature(List(LongFun, DoubleFun, LongFun, StringFun), IntFun)
  def getSignatureLongDoubleLongBoolean2Int(f: (lFun, dFun, lFun, bFun) => iFun): String = getSignature(List(LongFun, DoubleFun, LongFun, BooleanFun), IntFun)
  def getSignatureLongDoubleDoubleInt2Int(f: (lFun, dFun, dFun, iFun) => iFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, IntFun), IntFun)
  def getSignatureLongDoubleDoubleLong2Int(f: (lFun, dFun, dFun, lFun) => iFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, LongFun), IntFun)
  def getSignatureLongDoubleDoubleDouble2Int(f: (lFun, dFun, dFun, dFun) => iFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureLongDoubleDoubleString2Int(f: (lFun, dFun, dFun, sFun) => iFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, StringFun), IntFun)
  def getSignatureLongDoubleDoubleBoolean2Int(f: (lFun, dFun, dFun, bFun) => iFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureLongDoubleStringInt2Int(f: (lFun, dFun, sFun, iFun) => iFun): String = getSignature(List(LongFun, DoubleFun, StringFun, IntFun), IntFun)
  def getSignatureLongDoubleStringLong2Int(f: (lFun, dFun, sFun, lFun) => iFun): String = getSignature(List(LongFun, DoubleFun, StringFun, LongFun), IntFun)
  def getSignatureLongDoubleStringDouble2Int(f: (lFun, dFun, sFun, dFun) => iFun): String = getSignature(List(LongFun, DoubleFun, StringFun, DoubleFun), IntFun)
  def getSignatureLongDoubleStringString2Int(f: (lFun, dFun, sFun, sFun) => iFun): String = getSignature(List(LongFun, DoubleFun, StringFun, StringFun), IntFun)
  def getSignatureLongDoubleStringBoolean2Int(f: (lFun, dFun, sFun, bFun) => iFun): String = getSignature(List(LongFun, DoubleFun, StringFun, BooleanFun), IntFun)
  def getSignatureLongDoubleBooleanInt2Int(f: (lFun, dFun, bFun, iFun) => iFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, IntFun), IntFun)
  def getSignatureLongDoubleBooleanLong2Int(f: (lFun, dFun, bFun, lFun) => iFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, LongFun), IntFun)
  def getSignatureLongDoubleBooleanDouble2Int(f: (lFun, dFun, bFun, dFun) => iFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureLongDoubleBooleanString2Int(f: (lFun, dFun, bFun, sFun) => iFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, StringFun), IntFun)
  def getSignatureLongDoubleBooleanBoolean2Int(f: (lFun, dFun, bFun, bFun) => iFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureLongStringIntInt2Int(f: (lFun, sFun, iFun, iFun) => iFun): String = getSignature(List(LongFun, StringFun, IntFun, IntFun), IntFun)
  def getSignatureLongStringIntLong2Int(f: (lFun, sFun, iFun, lFun) => iFun): String = getSignature(List(LongFun, StringFun, IntFun, LongFun), IntFun)
  def getSignatureLongStringIntDouble2Int(f: (lFun, sFun, iFun, dFun) => iFun): String = getSignature(List(LongFun, StringFun, IntFun, DoubleFun), IntFun)
  def getSignatureLongStringIntString2Int(f: (lFun, sFun, iFun, sFun) => iFun): String = getSignature(List(LongFun, StringFun, IntFun, StringFun), IntFun)
  def getSignatureLongStringIntBoolean2Int(f: (lFun, sFun, iFun, bFun) => iFun): String = getSignature(List(LongFun, StringFun, IntFun, BooleanFun), IntFun)
  def getSignatureLongStringLongInt2Int(f: (lFun, sFun, lFun, iFun) => iFun): String = getSignature(List(LongFun, StringFun, LongFun, IntFun), IntFun)
  def getSignatureLongStringLongLong2Int(f: (lFun, sFun, lFun, lFun) => iFun): String = getSignature(List(LongFun, StringFun, LongFun, LongFun), IntFun)
  def getSignatureLongStringLongDouble2Int(f: (lFun, sFun, lFun, dFun) => iFun): String = getSignature(List(LongFun, StringFun, LongFun, DoubleFun), IntFun)
  def getSignatureLongStringLongString2Int(f: (lFun, sFun, lFun, sFun) => iFun): String = getSignature(List(LongFun, StringFun, LongFun, StringFun), IntFun)
  def getSignatureLongStringLongBoolean2Int(f: (lFun, sFun, lFun, bFun) => iFun): String = getSignature(List(LongFun, StringFun, LongFun, BooleanFun), IntFun)
  def getSignatureLongStringDoubleInt2Int(f: (lFun, sFun, dFun, iFun) => iFun): String = getSignature(List(LongFun, StringFun, DoubleFun, IntFun), IntFun)
  def getSignatureLongStringDoubleLong2Int(f: (lFun, sFun, dFun, lFun) => iFun): String = getSignature(List(LongFun, StringFun, DoubleFun, LongFun), IntFun)
  def getSignatureLongStringDoubleDouble2Int(f: (lFun, sFun, dFun, dFun) => iFun): String = getSignature(List(LongFun, StringFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureLongStringDoubleString2Int(f: (lFun, sFun, dFun, sFun) => iFun): String = getSignature(List(LongFun, StringFun, DoubleFun, StringFun), IntFun)
  def getSignatureLongStringDoubleBoolean2Int(f: (lFun, sFun, dFun, bFun) => iFun): String = getSignature(List(LongFun, StringFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureLongStringStringInt2Int(f: (lFun, sFun, sFun, iFun) => iFun): String = getSignature(List(LongFun, StringFun, StringFun, IntFun), IntFun)
  def getSignatureLongStringStringLong2Int(f: (lFun, sFun, sFun, lFun) => iFun): String = getSignature(List(LongFun, StringFun, StringFun, LongFun), IntFun)
  def getSignatureLongStringStringDouble2Int(f: (lFun, sFun, sFun, dFun) => iFun): String = getSignature(List(LongFun, StringFun, StringFun, DoubleFun), IntFun)
  def getSignatureLongStringStringString2Int(f: (lFun, sFun, sFun, sFun) => iFun): String = getSignature(List(LongFun, StringFun, StringFun, StringFun), IntFun)
  def getSignatureLongStringStringBoolean2Int(f: (lFun, sFun, sFun, bFun) => iFun): String = getSignature(List(LongFun, StringFun, StringFun, BooleanFun), IntFun)
  def getSignatureLongStringBooleanInt2Int(f: (lFun, sFun, bFun, iFun) => iFun): String = getSignature(List(LongFun, StringFun, BooleanFun, IntFun), IntFun)
  def getSignatureLongStringBooleanLong2Int(f: (lFun, sFun, bFun, lFun) => iFun): String = getSignature(List(LongFun, StringFun, BooleanFun, LongFun), IntFun)
  def getSignatureLongStringBooleanDouble2Int(f: (lFun, sFun, bFun, dFun) => iFun): String = getSignature(List(LongFun, StringFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureLongStringBooleanString2Int(f: (lFun, sFun, bFun, sFun) => iFun): String = getSignature(List(LongFun, StringFun, BooleanFun, StringFun), IntFun)
  def getSignatureLongStringBooleanBoolean2Int(f: (lFun, sFun, bFun, bFun) => iFun): String = getSignature(List(LongFun, StringFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureLongBooleanIntInt2Int(f: (lFun, bFun, iFun, iFun) => iFun): String = getSignature(List(LongFun, BooleanFun, IntFun, IntFun), IntFun)
  def getSignatureLongBooleanIntLong2Int(f: (lFun, bFun, iFun, lFun) => iFun): String = getSignature(List(LongFun, BooleanFun, IntFun, LongFun), IntFun)
  def getSignatureLongBooleanIntDouble2Int(f: (lFun, bFun, iFun, dFun) => iFun): String = getSignature(List(LongFun, BooleanFun, IntFun, DoubleFun), IntFun)
  def getSignatureLongBooleanIntString2Int(f: (lFun, bFun, iFun, sFun) => iFun): String = getSignature(List(LongFun, BooleanFun, IntFun, StringFun), IntFun)
  def getSignatureLongBooleanIntBoolean2Int(f: (lFun, bFun, iFun, bFun) => iFun): String = getSignature(List(LongFun, BooleanFun, IntFun, BooleanFun), IntFun)
  def getSignatureLongBooleanLongInt2Int(f: (lFun, bFun, lFun, iFun) => iFun): String = getSignature(List(LongFun, BooleanFun, LongFun, IntFun), IntFun)
  def getSignatureLongBooleanLongLong2Int(f: (lFun, bFun, lFun, lFun) => iFun): String = getSignature(List(LongFun, BooleanFun, LongFun, LongFun), IntFun)
  def getSignatureLongBooleanLongDouble2Int(f: (lFun, bFun, lFun, dFun) => iFun): String = getSignature(List(LongFun, BooleanFun, LongFun, DoubleFun), IntFun)
  def getSignatureLongBooleanLongString2Int(f: (lFun, bFun, lFun, sFun) => iFun): String = getSignature(List(LongFun, BooleanFun, LongFun, StringFun), IntFun)
  def getSignatureLongBooleanLongBoolean2Int(f: (lFun, bFun, lFun, bFun) => iFun): String = getSignature(List(LongFun, BooleanFun, LongFun, BooleanFun), IntFun)
  def getSignatureLongBooleanDoubleInt2Int(f: (lFun, bFun, dFun, iFun) => iFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, IntFun), IntFun)
  def getSignatureLongBooleanDoubleLong2Int(f: (lFun, bFun, dFun, lFun) => iFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, LongFun), IntFun)
  def getSignatureLongBooleanDoubleDouble2Int(f: (lFun, bFun, dFun, dFun) => iFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureLongBooleanDoubleString2Int(f: (lFun, bFun, dFun, sFun) => iFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, StringFun), IntFun)
  def getSignatureLongBooleanDoubleBoolean2Int(f: (lFun, bFun, dFun, bFun) => iFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureLongBooleanStringInt2Int(f: (lFun, bFun, sFun, iFun) => iFun): String = getSignature(List(LongFun, BooleanFun, StringFun, IntFun), IntFun)
  def getSignatureLongBooleanStringLong2Int(f: (lFun, bFun, sFun, lFun) => iFun): String = getSignature(List(LongFun, BooleanFun, StringFun, LongFun), IntFun)
  def getSignatureLongBooleanStringDouble2Int(f: (lFun, bFun, sFun, dFun) => iFun): String = getSignature(List(LongFun, BooleanFun, StringFun, DoubleFun), IntFun)
  def getSignatureLongBooleanStringString2Int(f: (lFun, bFun, sFun, sFun) => iFun): String = getSignature(List(LongFun, BooleanFun, StringFun, StringFun), IntFun)
  def getSignatureLongBooleanStringBoolean2Int(f: (lFun, bFun, sFun, bFun) => iFun): String = getSignature(List(LongFun, BooleanFun, StringFun, BooleanFun), IntFun)
  def getSignatureLongBooleanBooleanInt2Int(f: (lFun, bFun, bFun, iFun) => iFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, IntFun), IntFun)
  def getSignatureLongBooleanBooleanLong2Int(f: (lFun, bFun, bFun, lFun) => iFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, LongFun), IntFun)
  def getSignatureLongBooleanBooleanDouble2Int(f: (lFun, bFun, bFun, dFun) => iFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureLongBooleanBooleanString2Int(f: (lFun, bFun, bFun, sFun) => iFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, StringFun), IntFun)
  def getSignatureLongBooleanBooleanBoolean2Int(f: (lFun, bFun, bFun, bFun) => iFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureDoubleIntIntInt2Int(f: (dFun, iFun, iFun, iFun) => iFun): String = getSignature(List(DoubleFun, IntFun, IntFun, IntFun), IntFun)
  def getSignatureDoubleIntIntLong2Int(f: (dFun, iFun, iFun, lFun) => iFun): String = getSignature(List(DoubleFun, IntFun, IntFun, LongFun), IntFun)
  def getSignatureDoubleIntIntDouble2Int(f: (dFun, iFun, iFun, dFun) => iFun): String = getSignature(List(DoubleFun, IntFun, IntFun, DoubleFun), IntFun)
  def getSignatureDoubleIntIntString2Int(f: (dFun, iFun, iFun, sFun) => iFun): String = getSignature(List(DoubleFun, IntFun, IntFun, StringFun), IntFun)
  def getSignatureDoubleIntIntBoolean2Int(f: (dFun, iFun, iFun, bFun) => iFun): String = getSignature(List(DoubleFun, IntFun, IntFun, BooleanFun), IntFun)
  def getSignatureDoubleIntLongInt2Int(f: (dFun, iFun, lFun, iFun) => iFun): String = getSignature(List(DoubleFun, IntFun, LongFun, IntFun), IntFun)
  def getSignatureDoubleIntLongLong2Int(f: (dFun, iFun, lFun, lFun) => iFun): String = getSignature(List(DoubleFun, IntFun, LongFun, LongFun), IntFun)
  def getSignatureDoubleIntLongDouble2Int(f: (dFun, iFun, lFun, dFun) => iFun): String = getSignature(List(DoubleFun, IntFun, LongFun, DoubleFun), IntFun)
  def getSignatureDoubleIntLongString2Int(f: (dFun, iFun, lFun, sFun) => iFun): String = getSignature(List(DoubleFun, IntFun, LongFun, StringFun), IntFun)
  def getSignatureDoubleIntLongBoolean2Int(f: (dFun, iFun, lFun, bFun) => iFun): String = getSignature(List(DoubleFun, IntFun, LongFun, BooleanFun), IntFun)
  def getSignatureDoubleIntDoubleInt2Int(f: (dFun, iFun, dFun, iFun) => iFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, IntFun), IntFun)
  def getSignatureDoubleIntDoubleLong2Int(f: (dFun, iFun, dFun, lFun) => iFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, LongFun), IntFun)
  def getSignatureDoubleIntDoubleDouble2Int(f: (dFun, iFun, dFun, dFun) => iFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureDoubleIntDoubleString2Int(f: (dFun, iFun, dFun, sFun) => iFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, StringFun), IntFun)
  def getSignatureDoubleIntDoubleBoolean2Int(f: (dFun, iFun, dFun, bFun) => iFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureDoubleIntStringInt2Int(f: (dFun, iFun, sFun, iFun) => iFun): String = getSignature(List(DoubleFun, IntFun, StringFun, IntFun), IntFun)
  def getSignatureDoubleIntStringLong2Int(f: (dFun, iFun, sFun, lFun) => iFun): String = getSignature(List(DoubleFun, IntFun, StringFun, LongFun), IntFun)
  def getSignatureDoubleIntStringDouble2Int(f: (dFun, iFun, sFun, dFun) => iFun): String = getSignature(List(DoubleFun, IntFun, StringFun, DoubleFun), IntFun)
  def getSignatureDoubleIntStringString2Int(f: (dFun, iFun, sFun, sFun) => iFun): String = getSignature(List(DoubleFun, IntFun, StringFun, StringFun), IntFun)
  def getSignatureDoubleIntStringBoolean2Int(f: (dFun, iFun, sFun, bFun) => iFun): String = getSignature(List(DoubleFun, IntFun, StringFun, BooleanFun), IntFun)
  def getSignatureDoubleIntBooleanInt2Int(f: (dFun, iFun, bFun, iFun) => iFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, IntFun), IntFun)
  def getSignatureDoubleIntBooleanLong2Int(f: (dFun, iFun, bFun, lFun) => iFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, LongFun), IntFun)
  def getSignatureDoubleIntBooleanDouble2Int(f: (dFun, iFun, bFun, dFun) => iFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureDoubleIntBooleanString2Int(f: (dFun, iFun, bFun, sFun) => iFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, StringFun), IntFun)
  def getSignatureDoubleIntBooleanBoolean2Int(f: (dFun, iFun, bFun, bFun) => iFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureDoubleLongIntInt2Int(f: (dFun, lFun, iFun, iFun) => iFun): String = getSignature(List(DoubleFun, LongFun, IntFun, IntFun), IntFun)
  def getSignatureDoubleLongIntLong2Int(f: (dFun, lFun, iFun, lFun) => iFun): String = getSignature(List(DoubleFun, LongFun, IntFun, LongFun), IntFun)
  def getSignatureDoubleLongIntDouble2Int(f: (dFun, lFun, iFun, dFun) => iFun): String = getSignature(List(DoubleFun, LongFun, IntFun, DoubleFun), IntFun)
  def getSignatureDoubleLongIntString2Int(f: (dFun, lFun, iFun, sFun) => iFun): String = getSignature(List(DoubleFun, LongFun, IntFun, StringFun), IntFun)
  def getSignatureDoubleLongIntBoolean2Int(f: (dFun, lFun, iFun, bFun) => iFun): String = getSignature(List(DoubleFun, LongFun, IntFun, BooleanFun), IntFun)
  def getSignatureDoubleLongLongInt2Int(f: (dFun, lFun, lFun, iFun) => iFun): String = getSignature(List(DoubleFun, LongFun, LongFun, IntFun), IntFun)
  def getSignatureDoubleLongLongLong2Int(f: (dFun, lFun, lFun, lFun) => iFun): String = getSignature(List(DoubleFun, LongFun, LongFun, LongFun), IntFun)
  def getSignatureDoubleLongLongDouble2Int(f: (dFun, lFun, lFun, dFun) => iFun): String = getSignature(List(DoubleFun, LongFun, LongFun, DoubleFun), IntFun)
  def getSignatureDoubleLongLongString2Int(f: (dFun, lFun, lFun, sFun) => iFun): String = getSignature(List(DoubleFun, LongFun, LongFun, StringFun), IntFun)
  def getSignatureDoubleLongLongBoolean2Int(f: (dFun, lFun, lFun, bFun) => iFun): String = getSignature(List(DoubleFun, LongFun, LongFun, BooleanFun), IntFun)
  def getSignatureDoubleLongDoubleInt2Int(f: (dFun, lFun, dFun, iFun) => iFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, IntFun), IntFun)
  def getSignatureDoubleLongDoubleLong2Int(f: (dFun, lFun, dFun, lFun) => iFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, LongFun), IntFun)
  def getSignatureDoubleLongDoubleDouble2Int(f: (dFun, lFun, dFun, dFun) => iFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureDoubleLongDoubleString2Int(f: (dFun, lFun, dFun, sFun) => iFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, StringFun), IntFun)
  def getSignatureDoubleLongDoubleBoolean2Int(f: (dFun, lFun, dFun, bFun) => iFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureDoubleLongStringInt2Int(f: (dFun, lFun, sFun, iFun) => iFun): String = getSignature(List(DoubleFun, LongFun, StringFun, IntFun), IntFun)
  def getSignatureDoubleLongStringLong2Int(f: (dFun, lFun, sFun, lFun) => iFun): String = getSignature(List(DoubleFun, LongFun, StringFun, LongFun), IntFun)
  def getSignatureDoubleLongStringDouble2Int(f: (dFun, lFun, sFun, dFun) => iFun): String = getSignature(List(DoubleFun, LongFun, StringFun, DoubleFun), IntFun)
  def getSignatureDoubleLongStringString2Int(f: (dFun, lFun, sFun, sFun) => iFun): String = getSignature(List(DoubleFun, LongFun, StringFun, StringFun), IntFun)
  def getSignatureDoubleLongStringBoolean2Int(f: (dFun, lFun, sFun, bFun) => iFun): String = getSignature(List(DoubleFun, LongFun, StringFun, BooleanFun), IntFun)
  def getSignatureDoubleLongBooleanInt2Int(f: (dFun, lFun, bFun, iFun) => iFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, IntFun), IntFun)
  def getSignatureDoubleLongBooleanLong2Int(f: (dFun, lFun, bFun, lFun) => iFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, LongFun), IntFun)
  def getSignatureDoubleLongBooleanDouble2Int(f: (dFun, lFun, bFun, dFun) => iFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureDoubleLongBooleanString2Int(f: (dFun, lFun, bFun, sFun) => iFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, StringFun), IntFun)
  def getSignatureDoubleLongBooleanBoolean2Int(f: (dFun, lFun, bFun, bFun) => iFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureDoubleDoubleIntInt2Int(f: (dFun, dFun, iFun, iFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, IntFun), IntFun)
  def getSignatureDoubleDoubleIntLong2Int(f: (dFun, dFun, iFun, lFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, LongFun), IntFun)
  def getSignatureDoubleDoubleIntDouble2Int(f: (dFun, dFun, iFun, dFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, DoubleFun), IntFun)
  def getSignatureDoubleDoubleIntString2Int(f: (dFun, dFun, iFun, sFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, StringFun), IntFun)
  def getSignatureDoubleDoubleIntBoolean2Int(f: (dFun, dFun, iFun, bFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, BooleanFun), IntFun)
  def getSignatureDoubleDoubleLongInt2Int(f: (dFun, dFun, lFun, iFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, IntFun), IntFun)
  def getSignatureDoubleDoubleLongLong2Int(f: (dFun, dFun, lFun, lFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, LongFun), IntFun)
  def getSignatureDoubleDoubleLongDouble2Int(f: (dFun, dFun, lFun, dFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, DoubleFun), IntFun)
  def getSignatureDoubleDoubleLongString2Int(f: (dFun, dFun, lFun, sFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, StringFun), IntFun)
  def getSignatureDoubleDoubleLongBoolean2Int(f: (dFun, dFun, lFun, bFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, BooleanFun), IntFun)
  def getSignatureDoubleDoubleDoubleInt2Int(f: (dFun, dFun, dFun, iFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, IntFun), IntFun)
  def getSignatureDoubleDoubleDoubleLong2Int(f: (dFun, dFun, dFun, lFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, LongFun), IntFun)
  def getSignatureDoubleDoubleDoubleDouble2Int(f: (dFun, dFun, dFun, dFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureDoubleDoubleDoubleString2Int(f: (dFun, dFun, dFun, sFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, StringFun), IntFun)
  def getSignatureDoubleDoubleDoubleBoolean2Int(f: (dFun, dFun, dFun, bFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureDoubleDoubleStringInt2Int(f: (dFun, dFun, sFun, iFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, IntFun), IntFun)
  def getSignatureDoubleDoubleStringLong2Int(f: (dFun, dFun, sFun, lFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, LongFun), IntFun)
  def getSignatureDoubleDoubleStringDouble2Int(f: (dFun, dFun, sFun, dFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, DoubleFun), IntFun)
  def getSignatureDoubleDoubleStringString2Int(f: (dFun, dFun, sFun, sFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, StringFun), IntFun)
  def getSignatureDoubleDoubleStringBoolean2Int(f: (dFun, dFun, sFun, bFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, BooleanFun), IntFun)
  def getSignatureDoubleDoubleBooleanInt2Int(f: (dFun, dFun, bFun, iFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, IntFun), IntFun)
  def getSignatureDoubleDoubleBooleanLong2Int(f: (dFun, dFun, bFun, lFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, LongFun), IntFun)
  def getSignatureDoubleDoubleBooleanDouble2Int(f: (dFun, dFun, bFun, dFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureDoubleDoubleBooleanString2Int(f: (dFun, dFun, bFun, sFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, StringFun), IntFun)
  def getSignatureDoubleDoubleBooleanBoolean2Int(f: (dFun, dFun, bFun, bFun) => iFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureDoubleStringIntInt2Int(f: (dFun, sFun, iFun, iFun) => iFun): String = getSignature(List(DoubleFun, StringFun, IntFun, IntFun), IntFun)
  def getSignatureDoubleStringIntLong2Int(f: (dFun, sFun, iFun, lFun) => iFun): String = getSignature(List(DoubleFun, StringFun, IntFun, LongFun), IntFun)
  def getSignatureDoubleStringIntDouble2Int(f: (dFun, sFun, iFun, dFun) => iFun): String = getSignature(List(DoubleFun, StringFun, IntFun, DoubleFun), IntFun)
  def getSignatureDoubleStringIntString2Int(f: (dFun, sFun, iFun, sFun) => iFun): String = getSignature(List(DoubleFun, StringFun, IntFun, StringFun), IntFun)
  def getSignatureDoubleStringIntBoolean2Int(f: (dFun, sFun, iFun, bFun) => iFun): String = getSignature(List(DoubleFun, StringFun, IntFun, BooleanFun), IntFun)
  def getSignatureDoubleStringLongInt2Int(f: (dFun, sFun, lFun, iFun) => iFun): String = getSignature(List(DoubleFun, StringFun, LongFun, IntFun), IntFun)
  def getSignatureDoubleStringLongLong2Int(f: (dFun, sFun, lFun, lFun) => iFun): String = getSignature(List(DoubleFun, StringFun, LongFun, LongFun), IntFun)
  def getSignatureDoubleStringLongDouble2Int(f: (dFun, sFun, lFun, dFun) => iFun): String = getSignature(List(DoubleFun, StringFun, LongFun, DoubleFun), IntFun)
  def getSignatureDoubleStringLongString2Int(f: (dFun, sFun, lFun, sFun) => iFun): String = getSignature(List(DoubleFun, StringFun, LongFun, StringFun), IntFun)
  def getSignatureDoubleStringLongBoolean2Int(f: (dFun, sFun, lFun, bFun) => iFun): String = getSignature(List(DoubleFun, StringFun, LongFun, BooleanFun), IntFun)
  def getSignatureDoubleStringDoubleInt2Int(f: (dFun, sFun, dFun, iFun) => iFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, IntFun), IntFun)
  def getSignatureDoubleStringDoubleLong2Int(f: (dFun, sFun, dFun, lFun) => iFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, LongFun), IntFun)
  def getSignatureDoubleStringDoubleDouble2Int(f: (dFun, sFun, dFun, dFun) => iFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureDoubleStringDoubleString2Int(f: (dFun, sFun, dFun, sFun) => iFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, StringFun), IntFun)
  def getSignatureDoubleStringDoubleBoolean2Int(f: (dFun, sFun, dFun, bFun) => iFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureDoubleStringStringInt2Int(f: (dFun, sFun, sFun, iFun) => iFun): String = getSignature(List(DoubleFun, StringFun, StringFun, IntFun), IntFun)
  def getSignatureDoubleStringStringLong2Int(f: (dFun, sFun, sFun, lFun) => iFun): String = getSignature(List(DoubleFun, StringFun, StringFun, LongFun), IntFun)
  def getSignatureDoubleStringStringDouble2Int(f: (dFun, sFun, sFun, dFun) => iFun): String = getSignature(List(DoubleFun, StringFun, StringFun, DoubleFun), IntFun)
  def getSignatureDoubleStringStringString2Int(f: (dFun, sFun, sFun, sFun) => iFun): String = getSignature(List(DoubleFun, StringFun, StringFun, StringFun), IntFun)
  def getSignatureDoubleStringStringBoolean2Int(f: (dFun, sFun, sFun, bFun) => iFun): String = getSignature(List(DoubleFun, StringFun, StringFun, BooleanFun), IntFun)
  def getSignatureDoubleStringBooleanInt2Int(f: (dFun, sFun, bFun, iFun) => iFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, IntFun), IntFun)
  def getSignatureDoubleStringBooleanLong2Int(f: (dFun, sFun, bFun, lFun) => iFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, LongFun), IntFun)
  def getSignatureDoubleStringBooleanDouble2Int(f: (dFun, sFun, bFun, dFun) => iFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureDoubleStringBooleanString2Int(f: (dFun, sFun, bFun, sFun) => iFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, StringFun), IntFun)
  def getSignatureDoubleStringBooleanBoolean2Int(f: (dFun, sFun, bFun, bFun) => iFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureDoubleBooleanIntInt2Int(f: (dFun, bFun, iFun, iFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, IntFun), IntFun)
  def getSignatureDoubleBooleanIntLong2Int(f: (dFun, bFun, iFun, lFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, LongFun), IntFun)
  def getSignatureDoubleBooleanIntDouble2Int(f: (dFun, bFun, iFun, dFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, DoubleFun), IntFun)
  def getSignatureDoubleBooleanIntString2Int(f: (dFun, bFun, iFun, sFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, StringFun), IntFun)
  def getSignatureDoubleBooleanIntBoolean2Int(f: (dFun, bFun, iFun, bFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, BooleanFun), IntFun)
  def getSignatureDoubleBooleanLongInt2Int(f: (dFun, bFun, lFun, iFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, IntFun), IntFun)
  def getSignatureDoubleBooleanLongLong2Int(f: (dFun, bFun, lFun, lFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, LongFun), IntFun)
  def getSignatureDoubleBooleanLongDouble2Int(f: (dFun, bFun, lFun, dFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, DoubleFun), IntFun)
  def getSignatureDoubleBooleanLongString2Int(f: (dFun, bFun, lFun, sFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, StringFun), IntFun)
  def getSignatureDoubleBooleanLongBoolean2Int(f: (dFun, bFun, lFun, bFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, BooleanFun), IntFun)
  def getSignatureDoubleBooleanDoubleInt2Int(f: (dFun, bFun, dFun, iFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, IntFun), IntFun)
  def getSignatureDoubleBooleanDoubleLong2Int(f: (dFun, bFun, dFun, lFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, LongFun), IntFun)
  def getSignatureDoubleBooleanDoubleDouble2Int(f: (dFun, bFun, dFun, dFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureDoubleBooleanDoubleString2Int(f: (dFun, bFun, dFun, sFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, StringFun), IntFun)
  def getSignatureDoubleBooleanDoubleBoolean2Int(f: (dFun, bFun, dFun, bFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureDoubleBooleanStringInt2Int(f: (dFun, bFun, sFun, iFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, IntFun), IntFun)
  def getSignatureDoubleBooleanStringLong2Int(f: (dFun, bFun, sFun, lFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, LongFun), IntFun)
  def getSignatureDoubleBooleanStringDouble2Int(f: (dFun, bFun, sFun, dFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, DoubleFun), IntFun)
  def getSignatureDoubleBooleanStringString2Int(f: (dFun, bFun, sFun, sFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, StringFun), IntFun)
  def getSignatureDoubleBooleanStringBoolean2Int(f: (dFun, bFun, sFun, bFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, BooleanFun), IntFun)
  def getSignatureDoubleBooleanBooleanInt2Int(f: (dFun, bFun, bFun, iFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, IntFun), IntFun)
  def getSignatureDoubleBooleanBooleanLong2Int(f: (dFun, bFun, bFun, lFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, LongFun), IntFun)
  def getSignatureDoubleBooleanBooleanDouble2Int(f: (dFun, bFun, bFun, dFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureDoubleBooleanBooleanString2Int(f: (dFun, bFun, bFun, sFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, StringFun), IntFun)
  def getSignatureDoubleBooleanBooleanBoolean2Int(f: (dFun, bFun, bFun, bFun) => iFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureStringIntIntInt2Int(f: (sFun, iFun, iFun, iFun) => iFun): String = getSignature(List(StringFun, IntFun, IntFun, IntFun), IntFun)
  def getSignatureStringIntIntLong2Int(f: (sFun, iFun, iFun, lFun) => iFun): String = getSignature(List(StringFun, IntFun, IntFun, LongFun), IntFun)
  def getSignatureStringIntIntDouble2Int(f: (sFun, iFun, iFun, dFun) => iFun): String = getSignature(List(StringFun, IntFun, IntFun, DoubleFun), IntFun)
  def getSignatureStringIntIntString2Int(f: (sFun, iFun, iFun, sFun) => iFun): String = getSignature(List(StringFun, IntFun, IntFun, StringFun), IntFun)
  def getSignatureStringIntIntBoolean2Int(f: (sFun, iFun, iFun, bFun) => iFun): String = getSignature(List(StringFun, IntFun, IntFun, BooleanFun), IntFun)
  def getSignatureStringIntLongInt2Int(f: (sFun, iFun, lFun, iFun) => iFun): String = getSignature(List(StringFun, IntFun, LongFun, IntFun), IntFun)
  def getSignatureStringIntLongLong2Int(f: (sFun, iFun, lFun, lFun) => iFun): String = getSignature(List(StringFun, IntFun, LongFun, LongFun), IntFun)
  def getSignatureStringIntLongDouble2Int(f: (sFun, iFun, lFun, dFun) => iFun): String = getSignature(List(StringFun, IntFun, LongFun, DoubleFun), IntFun)
  def getSignatureStringIntLongString2Int(f: (sFun, iFun, lFun, sFun) => iFun): String = getSignature(List(StringFun, IntFun, LongFun, StringFun), IntFun)
  def getSignatureStringIntLongBoolean2Int(f: (sFun, iFun, lFun, bFun) => iFun): String = getSignature(List(StringFun, IntFun, LongFun, BooleanFun), IntFun)
  def getSignatureStringIntDoubleInt2Int(f: (sFun, iFun, dFun, iFun) => iFun): String = getSignature(List(StringFun, IntFun, DoubleFun, IntFun), IntFun)
  def getSignatureStringIntDoubleLong2Int(f: (sFun, iFun, dFun, lFun) => iFun): String = getSignature(List(StringFun, IntFun, DoubleFun, LongFun), IntFun)
  def getSignatureStringIntDoubleDouble2Int(f: (sFun, iFun, dFun, dFun) => iFun): String = getSignature(List(StringFun, IntFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureStringIntDoubleString2Int(f: (sFun, iFun, dFun, sFun) => iFun): String = getSignature(List(StringFun, IntFun, DoubleFun, StringFun), IntFun)
  def getSignatureStringIntDoubleBoolean2Int(f: (sFun, iFun, dFun, bFun) => iFun): String = getSignature(List(StringFun, IntFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureStringIntStringInt2Int(f: (sFun, iFun, sFun, iFun) => iFun): String = getSignature(List(StringFun, IntFun, StringFun, IntFun), IntFun)
  def getSignatureStringIntStringLong2Int(f: (sFun, iFun, sFun, lFun) => iFun): String = getSignature(List(StringFun, IntFun, StringFun, LongFun), IntFun)
  def getSignatureStringIntStringDouble2Int(f: (sFun, iFun, sFun, dFun) => iFun): String = getSignature(List(StringFun, IntFun, StringFun, DoubleFun), IntFun)
  def getSignatureStringIntStringString2Int(f: (sFun, iFun, sFun, sFun) => iFun): String = getSignature(List(StringFun, IntFun, StringFun, StringFun), IntFun)
  def getSignatureStringIntStringBoolean2Int(f: (sFun, iFun, sFun, bFun) => iFun): String = getSignature(List(StringFun, IntFun, StringFun, BooleanFun), IntFun)
  def getSignatureStringIntBooleanInt2Int(f: (sFun, iFun, bFun, iFun) => iFun): String = getSignature(List(StringFun, IntFun, BooleanFun, IntFun), IntFun)
  def getSignatureStringIntBooleanLong2Int(f: (sFun, iFun, bFun, lFun) => iFun): String = getSignature(List(StringFun, IntFun, BooleanFun, LongFun), IntFun)
  def getSignatureStringIntBooleanDouble2Int(f: (sFun, iFun, bFun, dFun) => iFun): String = getSignature(List(StringFun, IntFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureStringIntBooleanString2Int(f: (sFun, iFun, bFun, sFun) => iFun): String = getSignature(List(StringFun, IntFun, BooleanFun, StringFun), IntFun)
  def getSignatureStringIntBooleanBoolean2Int(f: (sFun, iFun, bFun, bFun) => iFun): String = getSignature(List(StringFun, IntFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureStringLongIntInt2Int(f: (sFun, lFun, iFun, iFun) => iFun): String = getSignature(List(StringFun, LongFun, IntFun, IntFun), IntFun)
  def getSignatureStringLongIntLong2Int(f: (sFun, lFun, iFun, lFun) => iFun): String = getSignature(List(StringFun, LongFun, IntFun, LongFun), IntFun)
  def getSignatureStringLongIntDouble2Int(f: (sFun, lFun, iFun, dFun) => iFun): String = getSignature(List(StringFun, LongFun, IntFun, DoubleFun), IntFun)
  def getSignatureStringLongIntString2Int(f: (sFun, lFun, iFun, sFun) => iFun): String = getSignature(List(StringFun, LongFun, IntFun, StringFun), IntFun)
  def getSignatureStringLongIntBoolean2Int(f: (sFun, lFun, iFun, bFun) => iFun): String = getSignature(List(StringFun, LongFun, IntFun, BooleanFun), IntFun)
  def getSignatureStringLongLongInt2Int(f: (sFun, lFun, lFun, iFun) => iFun): String = getSignature(List(StringFun, LongFun, LongFun, IntFun), IntFun)
  def getSignatureStringLongLongLong2Int(f: (sFun, lFun, lFun, lFun) => iFun): String = getSignature(List(StringFun, LongFun, LongFun, LongFun), IntFun)
  def getSignatureStringLongLongDouble2Int(f: (sFun, lFun, lFun, dFun) => iFun): String = getSignature(List(StringFun, LongFun, LongFun, DoubleFun), IntFun)
  def getSignatureStringLongLongString2Int(f: (sFun, lFun, lFun, sFun) => iFun): String = getSignature(List(StringFun, LongFun, LongFun, StringFun), IntFun)
  def getSignatureStringLongLongBoolean2Int(f: (sFun, lFun, lFun, bFun) => iFun): String = getSignature(List(StringFun, LongFun, LongFun, BooleanFun), IntFun)
  def getSignatureStringLongDoubleInt2Int(f: (sFun, lFun, dFun, iFun) => iFun): String = getSignature(List(StringFun, LongFun, DoubleFun, IntFun), IntFun)
  def getSignatureStringLongDoubleLong2Int(f: (sFun, lFun, dFun, lFun) => iFun): String = getSignature(List(StringFun, LongFun, DoubleFun, LongFun), IntFun)
  def getSignatureStringLongDoubleDouble2Int(f: (sFun, lFun, dFun, dFun) => iFun): String = getSignature(List(StringFun, LongFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureStringLongDoubleString2Int(f: (sFun, lFun, dFun, sFun) => iFun): String = getSignature(List(StringFun, LongFun, DoubleFun, StringFun), IntFun)
  def getSignatureStringLongDoubleBoolean2Int(f: (sFun, lFun, dFun, bFun) => iFun): String = getSignature(List(StringFun, LongFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureStringLongStringInt2Int(f: (sFun, lFun, sFun, iFun) => iFun): String = getSignature(List(StringFun, LongFun, StringFun, IntFun), IntFun)
  def getSignatureStringLongStringLong2Int(f: (sFun, lFun, sFun, lFun) => iFun): String = getSignature(List(StringFun, LongFun, StringFun, LongFun), IntFun)
  def getSignatureStringLongStringDouble2Int(f: (sFun, lFun, sFun, dFun) => iFun): String = getSignature(List(StringFun, LongFun, StringFun, DoubleFun), IntFun)
  def getSignatureStringLongStringString2Int(f: (sFun, lFun, sFun, sFun) => iFun): String = getSignature(List(StringFun, LongFun, StringFun, StringFun), IntFun)
  def getSignatureStringLongStringBoolean2Int(f: (sFun, lFun, sFun, bFun) => iFun): String = getSignature(List(StringFun, LongFun, StringFun, BooleanFun), IntFun)
  def getSignatureStringLongBooleanInt2Int(f: (sFun, lFun, bFun, iFun) => iFun): String = getSignature(List(StringFun, LongFun, BooleanFun, IntFun), IntFun)
  def getSignatureStringLongBooleanLong2Int(f: (sFun, lFun, bFun, lFun) => iFun): String = getSignature(List(StringFun, LongFun, BooleanFun, LongFun), IntFun)
  def getSignatureStringLongBooleanDouble2Int(f: (sFun, lFun, bFun, dFun) => iFun): String = getSignature(List(StringFun, LongFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureStringLongBooleanString2Int(f: (sFun, lFun, bFun, sFun) => iFun): String = getSignature(List(StringFun, LongFun, BooleanFun, StringFun), IntFun)
  def getSignatureStringLongBooleanBoolean2Int(f: (sFun, lFun, bFun, bFun) => iFun): String = getSignature(List(StringFun, LongFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureStringDoubleIntInt2Int(f: (sFun, dFun, iFun, iFun) => iFun): String = getSignature(List(StringFun, DoubleFun, IntFun, IntFun), IntFun)
  def getSignatureStringDoubleIntLong2Int(f: (sFun, dFun, iFun, lFun) => iFun): String = getSignature(List(StringFun, DoubleFun, IntFun, LongFun), IntFun)
  def getSignatureStringDoubleIntDouble2Int(f: (sFun, dFun, iFun, dFun) => iFun): String = getSignature(List(StringFun, DoubleFun, IntFun, DoubleFun), IntFun)
  def getSignatureStringDoubleIntString2Int(f: (sFun, dFun, iFun, sFun) => iFun): String = getSignature(List(StringFun, DoubleFun, IntFun, StringFun), IntFun)
  def getSignatureStringDoubleIntBoolean2Int(f: (sFun, dFun, iFun, bFun) => iFun): String = getSignature(List(StringFun, DoubleFun, IntFun, BooleanFun), IntFun)
  def getSignatureStringDoubleLongInt2Int(f: (sFun, dFun, lFun, iFun) => iFun): String = getSignature(List(StringFun, DoubleFun, LongFun, IntFun), IntFun)
  def getSignatureStringDoubleLongLong2Int(f: (sFun, dFun, lFun, lFun) => iFun): String = getSignature(List(StringFun, DoubleFun, LongFun, LongFun), IntFun)
  def getSignatureStringDoubleLongDouble2Int(f: (sFun, dFun, lFun, dFun) => iFun): String = getSignature(List(StringFun, DoubleFun, LongFun, DoubleFun), IntFun)
  def getSignatureStringDoubleLongString2Int(f: (sFun, dFun, lFun, sFun) => iFun): String = getSignature(List(StringFun, DoubleFun, LongFun, StringFun), IntFun)
  def getSignatureStringDoubleLongBoolean2Int(f: (sFun, dFun, lFun, bFun) => iFun): String = getSignature(List(StringFun, DoubleFun, LongFun, BooleanFun), IntFun)
  def getSignatureStringDoubleDoubleInt2Int(f: (sFun, dFun, dFun, iFun) => iFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, IntFun), IntFun)
  def getSignatureStringDoubleDoubleLong2Int(f: (sFun, dFun, dFun, lFun) => iFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, LongFun), IntFun)
  def getSignatureStringDoubleDoubleDouble2Int(f: (sFun, dFun, dFun, dFun) => iFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureStringDoubleDoubleString2Int(f: (sFun, dFun, dFun, sFun) => iFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, StringFun), IntFun)
  def getSignatureStringDoubleDoubleBoolean2Int(f: (sFun, dFun, dFun, bFun) => iFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureStringDoubleStringInt2Int(f: (sFun, dFun, sFun, iFun) => iFun): String = getSignature(List(StringFun, DoubleFun, StringFun, IntFun), IntFun)
  def getSignatureStringDoubleStringLong2Int(f: (sFun, dFun, sFun, lFun) => iFun): String = getSignature(List(StringFun, DoubleFun, StringFun, LongFun), IntFun)
  def getSignatureStringDoubleStringDouble2Int(f: (sFun, dFun, sFun, dFun) => iFun): String = getSignature(List(StringFun, DoubleFun, StringFun, DoubleFun), IntFun)
  def getSignatureStringDoubleStringString2Int(f: (sFun, dFun, sFun, sFun) => iFun): String = getSignature(List(StringFun, DoubleFun, StringFun, StringFun), IntFun)
  def getSignatureStringDoubleStringBoolean2Int(f: (sFun, dFun, sFun, bFun) => iFun): String = getSignature(List(StringFun, DoubleFun, StringFun, BooleanFun), IntFun)
  def getSignatureStringDoubleBooleanInt2Int(f: (sFun, dFun, bFun, iFun) => iFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, IntFun), IntFun)
  def getSignatureStringDoubleBooleanLong2Int(f: (sFun, dFun, bFun, lFun) => iFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, LongFun), IntFun)
  def getSignatureStringDoubleBooleanDouble2Int(f: (sFun, dFun, bFun, dFun) => iFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureStringDoubleBooleanString2Int(f: (sFun, dFun, bFun, sFun) => iFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, StringFun), IntFun)
  def getSignatureStringDoubleBooleanBoolean2Int(f: (sFun, dFun, bFun, bFun) => iFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureStringStringIntInt2Int(f: (sFun, sFun, iFun, iFun) => iFun): String = getSignature(List(StringFun, StringFun, IntFun, IntFun), IntFun)
  def getSignatureStringStringIntLong2Int(f: (sFun, sFun, iFun, lFun) => iFun): String = getSignature(List(StringFun, StringFun, IntFun, LongFun), IntFun)
  def getSignatureStringStringIntDouble2Int(f: (sFun, sFun, iFun, dFun) => iFun): String = getSignature(List(StringFun, StringFun, IntFun, DoubleFun), IntFun)
  def getSignatureStringStringIntString2Int(f: (sFun, sFun, iFun, sFun) => iFun): String = getSignature(List(StringFun, StringFun, IntFun, StringFun), IntFun)
  def getSignatureStringStringIntBoolean2Int(f: (sFun, sFun, iFun, bFun) => iFun): String = getSignature(List(StringFun, StringFun, IntFun, BooleanFun), IntFun)
  def getSignatureStringStringLongInt2Int(f: (sFun, sFun, lFun, iFun) => iFun): String = getSignature(List(StringFun, StringFun, LongFun, IntFun), IntFun)
  def getSignatureStringStringLongLong2Int(f: (sFun, sFun, lFun, lFun) => iFun): String = getSignature(List(StringFun, StringFun, LongFun, LongFun), IntFun)
  def getSignatureStringStringLongDouble2Int(f: (sFun, sFun, lFun, dFun) => iFun): String = getSignature(List(StringFun, StringFun, LongFun, DoubleFun), IntFun)
  def getSignatureStringStringLongString2Int(f: (sFun, sFun, lFun, sFun) => iFun): String = getSignature(List(StringFun, StringFun, LongFun, StringFun), IntFun)
  def getSignatureStringStringLongBoolean2Int(f: (sFun, sFun, lFun, bFun) => iFun): String = getSignature(List(StringFun, StringFun, LongFun, BooleanFun), IntFun)
  def getSignatureStringStringDoubleInt2Int(f: (sFun, sFun, dFun, iFun) => iFun): String = getSignature(List(StringFun, StringFun, DoubleFun, IntFun), IntFun)
  def getSignatureStringStringDoubleLong2Int(f: (sFun, sFun, dFun, lFun) => iFun): String = getSignature(List(StringFun, StringFun, DoubleFun, LongFun), IntFun)
  def getSignatureStringStringDoubleDouble2Int(f: (sFun, sFun, dFun, dFun) => iFun): String = getSignature(List(StringFun, StringFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureStringStringDoubleString2Int(f: (sFun, sFun, dFun, sFun) => iFun): String = getSignature(List(StringFun, StringFun, DoubleFun, StringFun), IntFun)
  def getSignatureStringStringDoubleBoolean2Int(f: (sFun, sFun, dFun, bFun) => iFun): String = getSignature(List(StringFun, StringFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureStringStringStringInt2Int(f: (sFun, sFun, sFun, iFun) => iFun): String = getSignature(List(StringFun, StringFun, StringFun, IntFun), IntFun)
  def getSignatureStringStringStringLong2Int(f: (sFun, sFun, sFun, lFun) => iFun): String = getSignature(List(StringFun, StringFun, StringFun, LongFun), IntFun)
  def getSignatureStringStringStringDouble2Int(f: (sFun, sFun, sFun, dFun) => iFun): String = getSignature(List(StringFun, StringFun, StringFun, DoubleFun), IntFun)
  def getSignatureStringStringStringString2Int(f: (sFun, sFun, sFun, sFun) => iFun): String = getSignature(List(StringFun, StringFun, StringFun, StringFun), IntFun)
  def getSignatureStringStringStringBoolean2Int(f: (sFun, sFun, sFun, bFun) => iFun): String = getSignature(List(StringFun, StringFun, StringFun, BooleanFun), IntFun)
  def getSignatureStringStringBooleanInt2Int(f: (sFun, sFun, bFun, iFun) => iFun): String = getSignature(List(StringFun, StringFun, BooleanFun, IntFun), IntFun)
  def getSignatureStringStringBooleanLong2Int(f: (sFun, sFun, bFun, lFun) => iFun): String = getSignature(List(StringFun, StringFun, BooleanFun, LongFun), IntFun)
  def getSignatureStringStringBooleanDouble2Int(f: (sFun, sFun, bFun, dFun) => iFun): String = getSignature(List(StringFun, StringFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureStringStringBooleanString2Int(f: (sFun, sFun, bFun, sFun) => iFun): String = getSignature(List(StringFun, StringFun, BooleanFun, StringFun), IntFun)
  def getSignatureStringStringBooleanBoolean2Int(f: (sFun, sFun, bFun, bFun) => iFun): String = getSignature(List(StringFun, StringFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureStringBooleanIntInt2Int(f: (sFun, bFun, iFun, iFun) => iFun): String = getSignature(List(StringFun, BooleanFun, IntFun, IntFun), IntFun)
  def getSignatureStringBooleanIntLong2Int(f: (sFun, bFun, iFun, lFun) => iFun): String = getSignature(List(StringFun, BooleanFun, IntFun, LongFun), IntFun)
  def getSignatureStringBooleanIntDouble2Int(f: (sFun, bFun, iFun, dFun) => iFun): String = getSignature(List(StringFun, BooleanFun, IntFun, DoubleFun), IntFun)
  def getSignatureStringBooleanIntString2Int(f: (sFun, bFun, iFun, sFun) => iFun): String = getSignature(List(StringFun, BooleanFun, IntFun, StringFun), IntFun)
  def getSignatureStringBooleanIntBoolean2Int(f: (sFun, bFun, iFun, bFun) => iFun): String = getSignature(List(StringFun, BooleanFun, IntFun, BooleanFun), IntFun)
  def getSignatureStringBooleanLongInt2Int(f: (sFun, bFun, lFun, iFun) => iFun): String = getSignature(List(StringFun, BooleanFun, LongFun, IntFun), IntFun)
  def getSignatureStringBooleanLongLong2Int(f: (sFun, bFun, lFun, lFun) => iFun): String = getSignature(List(StringFun, BooleanFun, LongFun, LongFun), IntFun)
  def getSignatureStringBooleanLongDouble2Int(f: (sFun, bFun, lFun, dFun) => iFun): String = getSignature(List(StringFun, BooleanFun, LongFun, DoubleFun), IntFun)
  def getSignatureStringBooleanLongString2Int(f: (sFun, bFun, lFun, sFun) => iFun): String = getSignature(List(StringFun, BooleanFun, LongFun, StringFun), IntFun)
  def getSignatureStringBooleanLongBoolean2Int(f: (sFun, bFun, lFun, bFun) => iFun): String = getSignature(List(StringFun, BooleanFun, LongFun, BooleanFun), IntFun)
  def getSignatureStringBooleanDoubleInt2Int(f: (sFun, bFun, dFun, iFun) => iFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, IntFun), IntFun)
  def getSignatureStringBooleanDoubleLong2Int(f: (sFun, bFun, dFun, lFun) => iFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, LongFun), IntFun)
  def getSignatureStringBooleanDoubleDouble2Int(f: (sFun, bFun, dFun, dFun) => iFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureStringBooleanDoubleString2Int(f: (sFun, bFun, dFun, sFun) => iFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, StringFun), IntFun)
  def getSignatureStringBooleanDoubleBoolean2Int(f: (sFun, bFun, dFun, bFun) => iFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureStringBooleanStringInt2Int(f: (sFun, bFun, sFun, iFun) => iFun): String = getSignature(List(StringFun, BooleanFun, StringFun, IntFun), IntFun)
  def getSignatureStringBooleanStringLong2Int(f: (sFun, bFun, sFun, lFun) => iFun): String = getSignature(List(StringFun, BooleanFun, StringFun, LongFun), IntFun)
  def getSignatureStringBooleanStringDouble2Int(f: (sFun, bFun, sFun, dFun) => iFun): String = getSignature(List(StringFun, BooleanFun, StringFun, DoubleFun), IntFun)
  def getSignatureStringBooleanStringString2Int(f: (sFun, bFun, sFun, sFun) => iFun): String = getSignature(List(StringFun, BooleanFun, StringFun, StringFun), IntFun)
  def getSignatureStringBooleanStringBoolean2Int(f: (sFun, bFun, sFun, bFun) => iFun): String = getSignature(List(StringFun, BooleanFun, StringFun, BooleanFun), IntFun)
  def getSignatureStringBooleanBooleanInt2Int(f: (sFun, bFun, bFun, iFun) => iFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, IntFun), IntFun)
  def getSignatureStringBooleanBooleanLong2Int(f: (sFun, bFun, bFun, lFun) => iFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, LongFun), IntFun)
  def getSignatureStringBooleanBooleanDouble2Int(f: (sFun, bFun, bFun, dFun) => iFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureStringBooleanBooleanString2Int(f: (sFun, bFun, bFun, sFun) => iFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, StringFun), IntFun)
  def getSignatureStringBooleanBooleanBoolean2Int(f: (sFun, bFun, bFun, bFun) => iFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureBooleanIntIntInt2Int(f: (bFun, iFun, iFun, iFun) => iFun): String = getSignature(List(BooleanFun, IntFun, IntFun, IntFun), IntFun)
  def getSignatureBooleanIntIntLong2Int(f: (bFun, iFun, iFun, lFun) => iFun): String = getSignature(List(BooleanFun, IntFun, IntFun, LongFun), IntFun)
  def getSignatureBooleanIntIntDouble2Int(f: (bFun, iFun, iFun, dFun) => iFun): String = getSignature(List(BooleanFun, IntFun, IntFun, DoubleFun), IntFun)
  def getSignatureBooleanIntIntString2Int(f: (bFun, iFun, iFun, sFun) => iFun): String = getSignature(List(BooleanFun, IntFun, IntFun, StringFun), IntFun)
  def getSignatureBooleanIntIntBoolean2Int(f: (bFun, iFun, iFun, bFun) => iFun): String = getSignature(List(BooleanFun, IntFun, IntFun, BooleanFun), IntFun)
  def getSignatureBooleanIntLongInt2Int(f: (bFun, iFun, lFun, iFun) => iFun): String = getSignature(List(BooleanFun, IntFun, LongFun, IntFun), IntFun)
  def getSignatureBooleanIntLongLong2Int(f: (bFun, iFun, lFun, lFun) => iFun): String = getSignature(List(BooleanFun, IntFun, LongFun, LongFun), IntFun)
  def getSignatureBooleanIntLongDouble2Int(f: (bFun, iFun, lFun, dFun) => iFun): String = getSignature(List(BooleanFun, IntFun, LongFun, DoubleFun), IntFun)
  def getSignatureBooleanIntLongString2Int(f: (bFun, iFun, lFun, sFun) => iFun): String = getSignature(List(BooleanFun, IntFun, LongFun, StringFun), IntFun)
  def getSignatureBooleanIntLongBoolean2Int(f: (bFun, iFun, lFun, bFun) => iFun): String = getSignature(List(BooleanFun, IntFun, LongFun, BooleanFun), IntFun)
  def getSignatureBooleanIntDoubleInt2Int(f: (bFun, iFun, dFun, iFun) => iFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, IntFun), IntFun)
  def getSignatureBooleanIntDoubleLong2Int(f: (bFun, iFun, dFun, lFun) => iFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, LongFun), IntFun)
  def getSignatureBooleanIntDoubleDouble2Int(f: (bFun, iFun, dFun, dFun) => iFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureBooleanIntDoubleString2Int(f: (bFun, iFun, dFun, sFun) => iFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, StringFun), IntFun)
  def getSignatureBooleanIntDoubleBoolean2Int(f: (bFun, iFun, dFun, bFun) => iFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureBooleanIntStringInt2Int(f: (bFun, iFun, sFun, iFun) => iFun): String = getSignature(List(BooleanFun, IntFun, StringFun, IntFun), IntFun)
  def getSignatureBooleanIntStringLong2Int(f: (bFun, iFun, sFun, lFun) => iFun): String = getSignature(List(BooleanFun, IntFun, StringFun, LongFun), IntFun)
  def getSignatureBooleanIntStringDouble2Int(f: (bFun, iFun, sFun, dFun) => iFun): String = getSignature(List(BooleanFun, IntFun, StringFun, DoubleFun), IntFun)
  def getSignatureBooleanIntStringString2Int(f: (bFun, iFun, sFun, sFun) => iFun): String = getSignature(List(BooleanFun, IntFun, StringFun, StringFun), IntFun)
  def getSignatureBooleanIntStringBoolean2Int(f: (bFun, iFun, sFun, bFun) => iFun): String = getSignature(List(BooleanFun, IntFun, StringFun, BooleanFun), IntFun)
  def getSignatureBooleanIntBooleanInt2Int(f: (bFun, iFun, bFun, iFun) => iFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, IntFun), IntFun)
  def getSignatureBooleanIntBooleanLong2Int(f: (bFun, iFun, bFun, lFun) => iFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, LongFun), IntFun)
  def getSignatureBooleanIntBooleanDouble2Int(f: (bFun, iFun, bFun, dFun) => iFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureBooleanIntBooleanString2Int(f: (bFun, iFun, bFun, sFun) => iFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, StringFun), IntFun)
  def getSignatureBooleanIntBooleanBoolean2Int(f: (bFun, iFun, bFun, bFun) => iFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureBooleanLongIntInt2Int(f: (bFun, lFun, iFun, iFun) => iFun): String = getSignature(List(BooleanFun, LongFun, IntFun, IntFun), IntFun)
  def getSignatureBooleanLongIntLong2Int(f: (bFun, lFun, iFun, lFun) => iFun): String = getSignature(List(BooleanFun, LongFun, IntFun, LongFun), IntFun)
  def getSignatureBooleanLongIntDouble2Int(f: (bFun, lFun, iFun, dFun) => iFun): String = getSignature(List(BooleanFun, LongFun, IntFun, DoubleFun), IntFun)
  def getSignatureBooleanLongIntString2Int(f: (bFun, lFun, iFun, sFun) => iFun): String = getSignature(List(BooleanFun, LongFun, IntFun, StringFun), IntFun)
  def getSignatureBooleanLongIntBoolean2Int(f: (bFun, lFun, iFun, bFun) => iFun): String = getSignature(List(BooleanFun, LongFun, IntFun, BooleanFun), IntFun)
  def getSignatureBooleanLongLongInt2Int(f: (bFun, lFun, lFun, iFun) => iFun): String = getSignature(List(BooleanFun, LongFun, LongFun, IntFun), IntFun)
  def getSignatureBooleanLongLongLong2Int(f: (bFun, lFun, lFun, lFun) => iFun): String = getSignature(List(BooleanFun, LongFun, LongFun, LongFun), IntFun)
  def getSignatureBooleanLongLongDouble2Int(f: (bFun, lFun, lFun, dFun) => iFun): String = getSignature(List(BooleanFun, LongFun, LongFun, DoubleFun), IntFun)
  def getSignatureBooleanLongLongString2Int(f: (bFun, lFun, lFun, sFun) => iFun): String = getSignature(List(BooleanFun, LongFun, LongFun, StringFun), IntFun)
  def getSignatureBooleanLongLongBoolean2Int(f: (bFun, lFun, lFun, bFun) => iFun): String = getSignature(List(BooleanFun, LongFun, LongFun, BooleanFun), IntFun)
  def getSignatureBooleanLongDoubleInt2Int(f: (bFun, lFun, dFun, iFun) => iFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, IntFun), IntFun)
  def getSignatureBooleanLongDoubleLong2Int(f: (bFun, lFun, dFun, lFun) => iFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, LongFun), IntFun)
  def getSignatureBooleanLongDoubleDouble2Int(f: (bFun, lFun, dFun, dFun) => iFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureBooleanLongDoubleString2Int(f: (bFun, lFun, dFun, sFun) => iFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, StringFun), IntFun)
  def getSignatureBooleanLongDoubleBoolean2Int(f: (bFun, lFun, dFun, bFun) => iFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureBooleanLongStringInt2Int(f: (bFun, lFun, sFun, iFun) => iFun): String = getSignature(List(BooleanFun, LongFun, StringFun, IntFun), IntFun)
  def getSignatureBooleanLongStringLong2Int(f: (bFun, lFun, sFun, lFun) => iFun): String = getSignature(List(BooleanFun, LongFun, StringFun, LongFun), IntFun)
  def getSignatureBooleanLongStringDouble2Int(f: (bFun, lFun, sFun, dFun) => iFun): String = getSignature(List(BooleanFun, LongFun, StringFun, DoubleFun), IntFun)
  def getSignatureBooleanLongStringString2Int(f: (bFun, lFun, sFun, sFun) => iFun): String = getSignature(List(BooleanFun, LongFun, StringFun, StringFun), IntFun)
  def getSignatureBooleanLongStringBoolean2Int(f: (bFun, lFun, sFun, bFun) => iFun): String = getSignature(List(BooleanFun, LongFun, StringFun, BooleanFun), IntFun)
  def getSignatureBooleanLongBooleanInt2Int(f: (bFun, lFun, bFun, iFun) => iFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, IntFun), IntFun)
  def getSignatureBooleanLongBooleanLong2Int(f: (bFun, lFun, bFun, lFun) => iFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, LongFun), IntFun)
  def getSignatureBooleanLongBooleanDouble2Int(f: (bFun, lFun, bFun, dFun) => iFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureBooleanLongBooleanString2Int(f: (bFun, lFun, bFun, sFun) => iFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, StringFun), IntFun)
  def getSignatureBooleanLongBooleanBoolean2Int(f: (bFun, lFun, bFun, bFun) => iFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureBooleanDoubleIntInt2Int(f: (bFun, dFun, iFun, iFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, IntFun), IntFun)
  def getSignatureBooleanDoubleIntLong2Int(f: (bFun, dFun, iFun, lFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, LongFun), IntFun)
  def getSignatureBooleanDoubleIntDouble2Int(f: (bFun, dFun, iFun, dFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, DoubleFun), IntFun)
  def getSignatureBooleanDoubleIntString2Int(f: (bFun, dFun, iFun, sFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, StringFun), IntFun)
  def getSignatureBooleanDoubleIntBoolean2Int(f: (bFun, dFun, iFun, bFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, BooleanFun), IntFun)
  def getSignatureBooleanDoubleLongInt2Int(f: (bFun, dFun, lFun, iFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, IntFun), IntFun)
  def getSignatureBooleanDoubleLongLong2Int(f: (bFun, dFun, lFun, lFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, LongFun), IntFun)
  def getSignatureBooleanDoubleLongDouble2Int(f: (bFun, dFun, lFun, dFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, DoubleFun), IntFun)
  def getSignatureBooleanDoubleLongString2Int(f: (bFun, dFun, lFun, sFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, StringFun), IntFun)
  def getSignatureBooleanDoubleLongBoolean2Int(f: (bFun, dFun, lFun, bFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, BooleanFun), IntFun)
  def getSignatureBooleanDoubleDoubleInt2Int(f: (bFun, dFun, dFun, iFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, IntFun), IntFun)
  def getSignatureBooleanDoubleDoubleLong2Int(f: (bFun, dFun, dFun, lFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, LongFun), IntFun)
  def getSignatureBooleanDoubleDoubleDouble2Int(f: (bFun, dFun, dFun, dFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureBooleanDoubleDoubleString2Int(f: (bFun, dFun, dFun, sFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, StringFun), IntFun)
  def getSignatureBooleanDoubleDoubleBoolean2Int(f: (bFun, dFun, dFun, bFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureBooleanDoubleStringInt2Int(f: (bFun, dFun, sFun, iFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, IntFun), IntFun)
  def getSignatureBooleanDoubleStringLong2Int(f: (bFun, dFun, sFun, lFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, LongFun), IntFun)
  def getSignatureBooleanDoubleStringDouble2Int(f: (bFun, dFun, sFun, dFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, DoubleFun), IntFun)
  def getSignatureBooleanDoubleStringString2Int(f: (bFun, dFun, sFun, sFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, StringFun), IntFun)
  def getSignatureBooleanDoubleStringBoolean2Int(f: (bFun, dFun, sFun, bFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, BooleanFun), IntFun)
  def getSignatureBooleanDoubleBooleanInt2Int(f: (bFun, dFun, bFun, iFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, IntFun), IntFun)
  def getSignatureBooleanDoubleBooleanLong2Int(f: (bFun, dFun, bFun, lFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, LongFun), IntFun)
  def getSignatureBooleanDoubleBooleanDouble2Int(f: (bFun, dFun, bFun, dFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureBooleanDoubleBooleanString2Int(f: (bFun, dFun, bFun, sFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, StringFun), IntFun)
  def getSignatureBooleanDoubleBooleanBoolean2Int(f: (bFun, dFun, bFun, bFun) => iFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureBooleanStringIntInt2Int(f: (bFun, sFun, iFun, iFun) => iFun): String = getSignature(List(BooleanFun, StringFun, IntFun, IntFun), IntFun)
  def getSignatureBooleanStringIntLong2Int(f: (bFun, sFun, iFun, lFun) => iFun): String = getSignature(List(BooleanFun, StringFun, IntFun, LongFun), IntFun)
  def getSignatureBooleanStringIntDouble2Int(f: (bFun, sFun, iFun, dFun) => iFun): String = getSignature(List(BooleanFun, StringFun, IntFun, DoubleFun), IntFun)
  def getSignatureBooleanStringIntString2Int(f: (bFun, sFun, iFun, sFun) => iFun): String = getSignature(List(BooleanFun, StringFun, IntFun, StringFun), IntFun)
  def getSignatureBooleanStringIntBoolean2Int(f: (bFun, sFun, iFun, bFun) => iFun): String = getSignature(List(BooleanFun, StringFun, IntFun, BooleanFun), IntFun)
  def getSignatureBooleanStringLongInt2Int(f: (bFun, sFun, lFun, iFun) => iFun): String = getSignature(List(BooleanFun, StringFun, LongFun, IntFun), IntFun)
  def getSignatureBooleanStringLongLong2Int(f: (bFun, sFun, lFun, lFun) => iFun): String = getSignature(List(BooleanFun, StringFun, LongFun, LongFun), IntFun)
  def getSignatureBooleanStringLongDouble2Int(f: (bFun, sFun, lFun, dFun) => iFun): String = getSignature(List(BooleanFun, StringFun, LongFun, DoubleFun), IntFun)
  def getSignatureBooleanStringLongString2Int(f: (bFun, sFun, lFun, sFun) => iFun): String = getSignature(List(BooleanFun, StringFun, LongFun, StringFun), IntFun)
  def getSignatureBooleanStringLongBoolean2Int(f: (bFun, sFun, lFun, bFun) => iFun): String = getSignature(List(BooleanFun, StringFun, LongFun, BooleanFun), IntFun)
  def getSignatureBooleanStringDoubleInt2Int(f: (bFun, sFun, dFun, iFun) => iFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, IntFun), IntFun)
  def getSignatureBooleanStringDoubleLong2Int(f: (bFun, sFun, dFun, lFun) => iFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, LongFun), IntFun)
  def getSignatureBooleanStringDoubleDouble2Int(f: (bFun, sFun, dFun, dFun) => iFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureBooleanStringDoubleString2Int(f: (bFun, sFun, dFun, sFun) => iFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, StringFun), IntFun)
  def getSignatureBooleanStringDoubleBoolean2Int(f: (bFun, sFun, dFun, bFun) => iFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureBooleanStringStringInt2Int(f: (bFun, sFun, sFun, iFun) => iFun): String = getSignature(List(BooleanFun, StringFun, StringFun, IntFun), IntFun)
  def getSignatureBooleanStringStringLong2Int(f: (bFun, sFun, sFun, lFun) => iFun): String = getSignature(List(BooleanFun, StringFun, StringFun, LongFun), IntFun)
  def getSignatureBooleanStringStringDouble2Int(f: (bFun, sFun, sFun, dFun) => iFun): String = getSignature(List(BooleanFun, StringFun, StringFun, DoubleFun), IntFun)
  def getSignatureBooleanStringStringString2Int(f: (bFun, sFun, sFun, sFun) => iFun): String = getSignature(List(BooleanFun, StringFun, StringFun, StringFun), IntFun)
  def getSignatureBooleanStringStringBoolean2Int(f: (bFun, sFun, sFun, bFun) => iFun): String = getSignature(List(BooleanFun, StringFun, StringFun, BooleanFun), IntFun)
  def getSignatureBooleanStringBooleanInt2Int(f: (bFun, sFun, bFun, iFun) => iFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, IntFun), IntFun)
  def getSignatureBooleanStringBooleanLong2Int(f: (bFun, sFun, bFun, lFun) => iFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, LongFun), IntFun)
  def getSignatureBooleanStringBooleanDouble2Int(f: (bFun, sFun, bFun, dFun) => iFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureBooleanStringBooleanString2Int(f: (bFun, sFun, bFun, sFun) => iFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, StringFun), IntFun)
  def getSignatureBooleanStringBooleanBoolean2Int(f: (bFun, sFun, bFun, bFun) => iFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureBooleanBooleanIntInt2Int(f: (bFun, bFun, iFun, iFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, IntFun), IntFun)
  def getSignatureBooleanBooleanIntLong2Int(f: (bFun, bFun, iFun, lFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, LongFun), IntFun)
  def getSignatureBooleanBooleanIntDouble2Int(f: (bFun, bFun, iFun, dFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, DoubleFun), IntFun)
  def getSignatureBooleanBooleanIntString2Int(f: (bFun, bFun, iFun, sFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, StringFun), IntFun)
  def getSignatureBooleanBooleanIntBoolean2Int(f: (bFun, bFun, iFun, bFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, BooleanFun), IntFun)
  def getSignatureBooleanBooleanLongInt2Int(f: (bFun, bFun, lFun, iFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, IntFun), IntFun)
  def getSignatureBooleanBooleanLongLong2Int(f: (bFun, bFun, lFun, lFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, LongFun), IntFun)
  def getSignatureBooleanBooleanLongDouble2Int(f: (bFun, bFun, lFun, dFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, DoubleFun), IntFun)
  def getSignatureBooleanBooleanLongString2Int(f: (bFun, bFun, lFun, sFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, StringFun), IntFun)
  def getSignatureBooleanBooleanLongBoolean2Int(f: (bFun, bFun, lFun, bFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, BooleanFun), IntFun)
  def getSignatureBooleanBooleanDoubleInt2Int(f: (bFun, bFun, dFun, iFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, IntFun), IntFun)
  def getSignatureBooleanBooleanDoubleLong2Int(f: (bFun, bFun, dFun, lFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, LongFun), IntFun)
  def getSignatureBooleanBooleanDoubleDouble2Int(f: (bFun, bFun, dFun, dFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, DoubleFun), IntFun)
  def getSignatureBooleanBooleanDoubleString2Int(f: (bFun, bFun, dFun, sFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, StringFun), IntFun)
  def getSignatureBooleanBooleanDoubleBoolean2Int(f: (bFun, bFun, dFun, bFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, BooleanFun), IntFun)
  def getSignatureBooleanBooleanStringInt2Int(f: (bFun, bFun, sFun, iFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, IntFun), IntFun)
  def getSignatureBooleanBooleanStringLong2Int(f: (bFun, bFun, sFun, lFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, LongFun), IntFun)
  def getSignatureBooleanBooleanStringDouble2Int(f: (bFun, bFun, sFun, dFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, DoubleFun), IntFun)
  def getSignatureBooleanBooleanStringString2Int(f: (bFun, bFun, sFun, sFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, StringFun), IntFun)
  def getSignatureBooleanBooleanStringBoolean2Int(f: (bFun, bFun, sFun, bFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, BooleanFun), IntFun)
  def getSignatureBooleanBooleanBooleanInt2Int(f: (bFun, bFun, bFun, iFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, IntFun), IntFun)
  def getSignatureBooleanBooleanBooleanLong2Int(f: (bFun, bFun, bFun, lFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, LongFun), IntFun)
  def getSignatureBooleanBooleanBooleanDouble2Int(f: (bFun, bFun, bFun, dFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, DoubleFun), IntFun)
  def getSignatureBooleanBooleanBooleanString2Int(f: (bFun, bFun, bFun, sFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, StringFun), IntFun)
  def getSignatureBooleanBooleanBooleanBoolean2Int(f: (bFun, bFun, bFun, bFun) => iFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, BooleanFun), IntFun)
  def getSignatureIntIntIntInt2Long(f: (iFun, iFun, iFun, iFun) => lFun): String = getSignature(List(IntFun, IntFun, IntFun, IntFun), LongFun)
  def getSignatureIntIntIntLong2Long(f: (iFun, iFun, iFun, lFun) => lFun): String = getSignature(List(IntFun, IntFun, IntFun, LongFun), LongFun)
  def getSignatureIntIntIntDouble2Long(f: (iFun, iFun, iFun, dFun) => lFun): String = getSignature(List(IntFun, IntFun, IntFun, DoubleFun), LongFun)
  def getSignatureIntIntIntString2Long(f: (iFun, iFun, iFun, sFun) => lFun): String = getSignature(List(IntFun, IntFun, IntFun, StringFun), LongFun)
  def getSignatureIntIntIntBoolean2Long(f: (iFun, iFun, iFun, bFun) => lFun): String = getSignature(List(IntFun, IntFun, IntFun, BooleanFun), LongFun)
  def getSignatureIntIntLongInt2Long(f: (iFun, iFun, lFun, iFun) => lFun): String = getSignature(List(IntFun, IntFun, LongFun, IntFun), LongFun)
  def getSignatureIntIntLongLong2Long(f: (iFun, iFun, lFun, lFun) => lFun): String = getSignature(List(IntFun, IntFun, LongFun, LongFun), LongFun)
  def getSignatureIntIntLongDouble2Long(f: (iFun, iFun, lFun, dFun) => lFun): String = getSignature(List(IntFun, IntFun, LongFun, DoubleFun), LongFun)
  def getSignatureIntIntLongString2Long(f: (iFun, iFun, lFun, sFun) => lFun): String = getSignature(List(IntFun, IntFun, LongFun, StringFun), LongFun)
  def getSignatureIntIntLongBoolean2Long(f: (iFun, iFun, lFun, bFun) => lFun): String = getSignature(List(IntFun, IntFun, LongFun, BooleanFun), LongFun)
  def getSignatureIntIntDoubleInt2Long(f: (iFun, iFun, dFun, iFun) => lFun): String = getSignature(List(IntFun, IntFun, DoubleFun, IntFun), LongFun)
  def getSignatureIntIntDoubleLong2Long(f: (iFun, iFun, dFun, lFun) => lFun): String = getSignature(List(IntFun, IntFun, DoubleFun, LongFun), LongFun)
  def getSignatureIntIntDoubleDouble2Long(f: (iFun, iFun, dFun, dFun) => lFun): String = getSignature(List(IntFun, IntFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureIntIntDoubleString2Long(f: (iFun, iFun, dFun, sFun) => lFun): String = getSignature(List(IntFun, IntFun, DoubleFun, StringFun), LongFun)
  def getSignatureIntIntDoubleBoolean2Long(f: (iFun, iFun, dFun, bFun) => lFun): String = getSignature(List(IntFun, IntFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureIntIntStringInt2Long(f: (iFun, iFun, sFun, iFun) => lFun): String = getSignature(List(IntFun, IntFun, StringFun, IntFun), LongFun)
  def getSignatureIntIntStringLong2Long(f: (iFun, iFun, sFun, lFun) => lFun): String = getSignature(List(IntFun, IntFun, StringFun, LongFun), LongFun)
  def getSignatureIntIntStringDouble2Long(f: (iFun, iFun, sFun, dFun) => lFun): String = getSignature(List(IntFun, IntFun, StringFun, DoubleFun), LongFun)
  def getSignatureIntIntStringString2Long(f: (iFun, iFun, sFun, sFun) => lFun): String = getSignature(List(IntFun, IntFun, StringFun, StringFun), LongFun)
  def getSignatureIntIntStringBoolean2Long(f: (iFun, iFun, sFun, bFun) => lFun): String = getSignature(List(IntFun, IntFun, StringFun, BooleanFun), LongFun)
  def getSignatureIntIntBooleanInt2Long(f: (iFun, iFun, bFun, iFun) => lFun): String = getSignature(List(IntFun, IntFun, BooleanFun, IntFun), LongFun)
  def getSignatureIntIntBooleanLong2Long(f: (iFun, iFun, bFun, lFun) => lFun): String = getSignature(List(IntFun, IntFun, BooleanFun, LongFun), LongFun)
  def getSignatureIntIntBooleanDouble2Long(f: (iFun, iFun, bFun, dFun) => lFun): String = getSignature(List(IntFun, IntFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureIntIntBooleanString2Long(f: (iFun, iFun, bFun, sFun) => lFun): String = getSignature(List(IntFun, IntFun, BooleanFun, StringFun), LongFun)
  def getSignatureIntIntBooleanBoolean2Long(f: (iFun, iFun, bFun, bFun) => lFun): String = getSignature(List(IntFun, IntFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureIntLongIntInt2Long(f: (iFun, lFun, iFun, iFun) => lFun): String = getSignature(List(IntFun, LongFun, IntFun, IntFun), LongFun)
  def getSignatureIntLongIntLong2Long(f: (iFun, lFun, iFun, lFun) => lFun): String = getSignature(List(IntFun, LongFun, IntFun, LongFun), LongFun)
  def getSignatureIntLongIntDouble2Long(f: (iFun, lFun, iFun, dFun) => lFun): String = getSignature(List(IntFun, LongFun, IntFun, DoubleFun), LongFun)
  def getSignatureIntLongIntString2Long(f: (iFun, lFun, iFun, sFun) => lFun): String = getSignature(List(IntFun, LongFun, IntFun, StringFun), LongFun)
  def getSignatureIntLongIntBoolean2Long(f: (iFun, lFun, iFun, bFun) => lFun): String = getSignature(List(IntFun, LongFun, IntFun, BooleanFun), LongFun)
  def getSignatureIntLongLongInt2Long(f: (iFun, lFun, lFun, iFun) => lFun): String = getSignature(List(IntFun, LongFun, LongFun, IntFun), LongFun)
  def getSignatureIntLongLongLong2Long(f: (iFun, lFun, lFun, lFun) => lFun): String = getSignature(List(IntFun, LongFun, LongFun, LongFun), LongFun)
  def getSignatureIntLongLongDouble2Long(f: (iFun, lFun, lFun, dFun) => lFun): String = getSignature(List(IntFun, LongFun, LongFun, DoubleFun), LongFun)
  def getSignatureIntLongLongString2Long(f: (iFun, lFun, lFun, sFun) => lFun): String = getSignature(List(IntFun, LongFun, LongFun, StringFun), LongFun)
  def getSignatureIntLongLongBoolean2Long(f: (iFun, lFun, lFun, bFun) => lFun): String = getSignature(List(IntFun, LongFun, LongFun, BooleanFun), LongFun)
  def getSignatureIntLongDoubleInt2Long(f: (iFun, lFun, dFun, iFun) => lFun): String = getSignature(List(IntFun, LongFun, DoubleFun, IntFun), LongFun)
  def getSignatureIntLongDoubleLong2Long(f: (iFun, lFun, dFun, lFun) => lFun): String = getSignature(List(IntFun, LongFun, DoubleFun, LongFun), LongFun)
  def getSignatureIntLongDoubleDouble2Long(f: (iFun, lFun, dFun, dFun) => lFun): String = getSignature(List(IntFun, LongFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureIntLongDoubleString2Long(f: (iFun, lFun, dFun, sFun) => lFun): String = getSignature(List(IntFun, LongFun, DoubleFun, StringFun), LongFun)
  def getSignatureIntLongDoubleBoolean2Long(f: (iFun, lFun, dFun, bFun) => lFun): String = getSignature(List(IntFun, LongFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureIntLongStringInt2Long(f: (iFun, lFun, sFun, iFun) => lFun): String = getSignature(List(IntFun, LongFun, StringFun, IntFun), LongFun)
  def getSignatureIntLongStringLong2Long(f: (iFun, lFun, sFun, lFun) => lFun): String = getSignature(List(IntFun, LongFun, StringFun, LongFun), LongFun)
  def getSignatureIntLongStringDouble2Long(f: (iFun, lFun, sFun, dFun) => lFun): String = getSignature(List(IntFun, LongFun, StringFun, DoubleFun), LongFun)
  def getSignatureIntLongStringString2Long(f: (iFun, lFun, sFun, sFun) => lFun): String = getSignature(List(IntFun, LongFun, StringFun, StringFun), LongFun)
  def getSignatureIntLongStringBoolean2Long(f: (iFun, lFun, sFun, bFun) => lFun): String = getSignature(List(IntFun, LongFun, StringFun, BooleanFun), LongFun)
  def getSignatureIntLongBooleanInt2Long(f: (iFun, lFun, bFun, iFun) => lFun): String = getSignature(List(IntFun, LongFun, BooleanFun, IntFun), LongFun)
  def getSignatureIntLongBooleanLong2Long(f: (iFun, lFun, bFun, lFun) => lFun): String = getSignature(List(IntFun, LongFun, BooleanFun, LongFun), LongFun)
  def getSignatureIntLongBooleanDouble2Long(f: (iFun, lFun, bFun, dFun) => lFun): String = getSignature(List(IntFun, LongFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureIntLongBooleanString2Long(f: (iFun, lFun, bFun, sFun) => lFun): String = getSignature(List(IntFun, LongFun, BooleanFun, StringFun), LongFun)
  def getSignatureIntLongBooleanBoolean2Long(f: (iFun, lFun, bFun, bFun) => lFun): String = getSignature(List(IntFun, LongFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureIntDoubleIntInt2Long(f: (iFun, dFun, iFun, iFun) => lFun): String = getSignature(List(IntFun, DoubleFun, IntFun, IntFun), LongFun)
  def getSignatureIntDoubleIntLong2Long(f: (iFun, dFun, iFun, lFun) => lFun): String = getSignature(List(IntFun, DoubleFun, IntFun, LongFun), LongFun)
  def getSignatureIntDoubleIntDouble2Long(f: (iFun, dFun, iFun, dFun) => lFun): String = getSignature(List(IntFun, DoubleFun, IntFun, DoubleFun), LongFun)
  def getSignatureIntDoubleIntString2Long(f: (iFun, dFun, iFun, sFun) => lFun): String = getSignature(List(IntFun, DoubleFun, IntFun, StringFun), LongFun)
  def getSignatureIntDoubleIntBoolean2Long(f: (iFun, dFun, iFun, bFun) => lFun): String = getSignature(List(IntFun, DoubleFun, IntFun, BooleanFun), LongFun)
  def getSignatureIntDoubleLongInt2Long(f: (iFun, dFun, lFun, iFun) => lFun): String = getSignature(List(IntFun, DoubleFun, LongFun, IntFun), LongFun)
  def getSignatureIntDoubleLongLong2Long(f: (iFun, dFun, lFun, lFun) => lFun): String = getSignature(List(IntFun, DoubleFun, LongFun, LongFun), LongFun)
  def getSignatureIntDoubleLongDouble2Long(f: (iFun, dFun, lFun, dFun) => lFun): String = getSignature(List(IntFun, DoubleFun, LongFun, DoubleFun), LongFun)
  def getSignatureIntDoubleLongString2Long(f: (iFun, dFun, lFun, sFun) => lFun): String = getSignature(List(IntFun, DoubleFun, LongFun, StringFun), LongFun)
  def getSignatureIntDoubleLongBoolean2Long(f: (iFun, dFun, lFun, bFun) => lFun): String = getSignature(List(IntFun, DoubleFun, LongFun, BooleanFun), LongFun)
  def getSignatureIntDoubleDoubleInt2Long(f: (iFun, dFun, dFun, iFun) => lFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, IntFun), LongFun)
  def getSignatureIntDoubleDoubleLong2Long(f: (iFun, dFun, dFun, lFun) => lFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, LongFun), LongFun)
  def getSignatureIntDoubleDoubleDouble2Long(f: (iFun, dFun, dFun, dFun) => lFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureIntDoubleDoubleString2Long(f: (iFun, dFun, dFun, sFun) => lFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, StringFun), LongFun)
  def getSignatureIntDoubleDoubleBoolean2Long(f: (iFun, dFun, dFun, bFun) => lFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureIntDoubleStringInt2Long(f: (iFun, dFun, sFun, iFun) => lFun): String = getSignature(List(IntFun, DoubleFun, StringFun, IntFun), LongFun)
  def getSignatureIntDoubleStringLong2Long(f: (iFun, dFun, sFun, lFun) => lFun): String = getSignature(List(IntFun, DoubleFun, StringFun, LongFun), LongFun)
  def getSignatureIntDoubleStringDouble2Long(f: (iFun, dFun, sFun, dFun) => lFun): String = getSignature(List(IntFun, DoubleFun, StringFun, DoubleFun), LongFun)
  def getSignatureIntDoubleStringString2Long(f: (iFun, dFun, sFun, sFun) => lFun): String = getSignature(List(IntFun, DoubleFun, StringFun, StringFun), LongFun)
  def getSignatureIntDoubleStringBoolean2Long(f: (iFun, dFun, sFun, bFun) => lFun): String = getSignature(List(IntFun, DoubleFun, StringFun, BooleanFun), LongFun)
  def getSignatureIntDoubleBooleanInt2Long(f: (iFun, dFun, bFun, iFun) => lFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, IntFun), LongFun)
  def getSignatureIntDoubleBooleanLong2Long(f: (iFun, dFun, bFun, lFun) => lFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, LongFun), LongFun)
  def getSignatureIntDoubleBooleanDouble2Long(f: (iFun, dFun, bFun, dFun) => lFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureIntDoubleBooleanString2Long(f: (iFun, dFun, bFun, sFun) => lFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, StringFun), LongFun)
  def getSignatureIntDoubleBooleanBoolean2Long(f: (iFun, dFun, bFun, bFun) => lFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureIntStringIntInt2Long(f: (iFun, sFun, iFun, iFun) => lFun): String = getSignature(List(IntFun, StringFun, IntFun, IntFun), LongFun)
  def getSignatureIntStringIntLong2Long(f: (iFun, sFun, iFun, lFun) => lFun): String = getSignature(List(IntFun, StringFun, IntFun, LongFun), LongFun)
  def getSignatureIntStringIntDouble2Long(f: (iFun, sFun, iFun, dFun) => lFun): String = getSignature(List(IntFun, StringFun, IntFun, DoubleFun), LongFun)
  def getSignatureIntStringIntString2Long(f: (iFun, sFun, iFun, sFun) => lFun): String = getSignature(List(IntFun, StringFun, IntFun, StringFun), LongFun)
  def getSignatureIntStringIntBoolean2Long(f: (iFun, sFun, iFun, bFun) => lFun): String = getSignature(List(IntFun, StringFun, IntFun, BooleanFun), LongFun)
  def getSignatureIntStringLongInt2Long(f: (iFun, sFun, lFun, iFun) => lFun): String = getSignature(List(IntFun, StringFun, LongFun, IntFun), LongFun)
  def getSignatureIntStringLongLong2Long(f: (iFun, sFun, lFun, lFun) => lFun): String = getSignature(List(IntFun, StringFun, LongFun, LongFun), LongFun)
  def getSignatureIntStringLongDouble2Long(f: (iFun, sFun, lFun, dFun) => lFun): String = getSignature(List(IntFun, StringFun, LongFun, DoubleFun), LongFun)
  def getSignatureIntStringLongString2Long(f: (iFun, sFun, lFun, sFun) => lFun): String = getSignature(List(IntFun, StringFun, LongFun, StringFun), LongFun)
  def getSignatureIntStringLongBoolean2Long(f: (iFun, sFun, lFun, bFun) => lFun): String = getSignature(List(IntFun, StringFun, LongFun, BooleanFun), LongFun)
  def getSignatureIntStringDoubleInt2Long(f: (iFun, sFun, dFun, iFun) => lFun): String = getSignature(List(IntFun, StringFun, DoubleFun, IntFun), LongFun)
  def getSignatureIntStringDoubleLong2Long(f: (iFun, sFun, dFun, lFun) => lFun): String = getSignature(List(IntFun, StringFun, DoubleFun, LongFun), LongFun)
  def getSignatureIntStringDoubleDouble2Long(f: (iFun, sFun, dFun, dFun) => lFun): String = getSignature(List(IntFun, StringFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureIntStringDoubleString2Long(f: (iFun, sFun, dFun, sFun) => lFun): String = getSignature(List(IntFun, StringFun, DoubleFun, StringFun), LongFun)
  def getSignatureIntStringDoubleBoolean2Long(f: (iFun, sFun, dFun, bFun) => lFun): String = getSignature(List(IntFun, StringFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureIntStringStringInt2Long(f: (iFun, sFun, sFun, iFun) => lFun): String = getSignature(List(IntFun, StringFun, StringFun, IntFun), LongFun)
  def getSignatureIntStringStringLong2Long(f: (iFun, sFun, sFun, lFun) => lFun): String = getSignature(List(IntFun, StringFun, StringFun, LongFun), LongFun)
  def getSignatureIntStringStringDouble2Long(f: (iFun, sFun, sFun, dFun) => lFun): String = getSignature(List(IntFun, StringFun, StringFun, DoubleFun), LongFun)
  def getSignatureIntStringStringString2Long(f: (iFun, sFun, sFun, sFun) => lFun): String = getSignature(List(IntFun, StringFun, StringFun, StringFun), LongFun)
  def getSignatureIntStringStringBoolean2Long(f: (iFun, sFun, sFun, bFun) => lFun): String = getSignature(List(IntFun, StringFun, StringFun, BooleanFun), LongFun)
  def getSignatureIntStringBooleanInt2Long(f: (iFun, sFun, bFun, iFun) => lFun): String = getSignature(List(IntFun, StringFun, BooleanFun, IntFun), LongFun)
  def getSignatureIntStringBooleanLong2Long(f: (iFun, sFun, bFun, lFun) => lFun): String = getSignature(List(IntFun, StringFun, BooleanFun, LongFun), LongFun)
  def getSignatureIntStringBooleanDouble2Long(f: (iFun, sFun, bFun, dFun) => lFun): String = getSignature(List(IntFun, StringFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureIntStringBooleanString2Long(f: (iFun, sFun, bFun, sFun) => lFun): String = getSignature(List(IntFun, StringFun, BooleanFun, StringFun), LongFun)
  def getSignatureIntStringBooleanBoolean2Long(f: (iFun, sFun, bFun, bFun) => lFun): String = getSignature(List(IntFun, StringFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureIntBooleanIntInt2Long(f: (iFun, bFun, iFun, iFun) => lFun): String = getSignature(List(IntFun, BooleanFun, IntFun, IntFun), LongFun)
  def getSignatureIntBooleanIntLong2Long(f: (iFun, bFun, iFun, lFun) => lFun): String = getSignature(List(IntFun, BooleanFun, IntFun, LongFun), LongFun)
  def getSignatureIntBooleanIntDouble2Long(f: (iFun, bFun, iFun, dFun) => lFun): String = getSignature(List(IntFun, BooleanFun, IntFun, DoubleFun), LongFun)
  def getSignatureIntBooleanIntString2Long(f: (iFun, bFun, iFun, sFun) => lFun): String = getSignature(List(IntFun, BooleanFun, IntFun, StringFun), LongFun)
  def getSignatureIntBooleanIntBoolean2Long(f: (iFun, bFun, iFun, bFun) => lFun): String = getSignature(List(IntFun, BooleanFun, IntFun, BooleanFun), LongFun)
  def getSignatureIntBooleanLongInt2Long(f: (iFun, bFun, lFun, iFun) => lFun): String = getSignature(List(IntFun, BooleanFun, LongFun, IntFun), LongFun)
  def getSignatureIntBooleanLongLong2Long(f: (iFun, bFun, lFun, lFun) => lFun): String = getSignature(List(IntFun, BooleanFun, LongFun, LongFun), LongFun)
  def getSignatureIntBooleanLongDouble2Long(f: (iFun, bFun, lFun, dFun) => lFun): String = getSignature(List(IntFun, BooleanFun, LongFun, DoubleFun), LongFun)
  def getSignatureIntBooleanLongString2Long(f: (iFun, bFun, lFun, sFun) => lFun): String = getSignature(List(IntFun, BooleanFun, LongFun, StringFun), LongFun)
  def getSignatureIntBooleanLongBoolean2Long(f: (iFun, bFun, lFun, bFun) => lFun): String = getSignature(List(IntFun, BooleanFun, LongFun, BooleanFun), LongFun)
  def getSignatureIntBooleanDoubleInt2Long(f: (iFun, bFun, dFun, iFun) => lFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, IntFun), LongFun)
  def getSignatureIntBooleanDoubleLong2Long(f: (iFun, bFun, dFun, lFun) => lFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, LongFun), LongFun)
  def getSignatureIntBooleanDoubleDouble2Long(f: (iFun, bFun, dFun, dFun) => lFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureIntBooleanDoubleString2Long(f: (iFun, bFun, dFun, sFun) => lFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, StringFun), LongFun)
  def getSignatureIntBooleanDoubleBoolean2Long(f: (iFun, bFun, dFun, bFun) => lFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureIntBooleanStringInt2Long(f: (iFun, bFun, sFun, iFun) => lFun): String = getSignature(List(IntFun, BooleanFun, StringFun, IntFun), LongFun)
  def getSignatureIntBooleanStringLong2Long(f: (iFun, bFun, sFun, lFun) => lFun): String = getSignature(List(IntFun, BooleanFun, StringFun, LongFun), LongFun)
  def getSignatureIntBooleanStringDouble2Long(f: (iFun, bFun, sFun, dFun) => lFun): String = getSignature(List(IntFun, BooleanFun, StringFun, DoubleFun), LongFun)
  def getSignatureIntBooleanStringString2Long(f: (iFun, bFun, sFun, sFun) => lFun): String = getSignature(List(IntFun, BooleanFun, StringFun, StringFun), LongFun)
  def getSignatureIntBooleanStringBoolean2Long(f: (iFun, bFun, sFun, bFun) => lFun): String = getSignature(List(IntFun, BooleanFun, StringFun, BooleanFun), LongFun)
  def getSignatureIntBooleanBooleanInt2Long(f: (iFun, bFun, bFun, iFun) => lFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, IntFun), LongFun)
  def getSignatureIntBooleanBooleanLong2Long(f: (iFun, bFun, bFun, lFun) => lFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, LongFun), LongFun)
  def getSignatureIntBooleanBooleanDouble2Long(f: (iFun, bFun, bFun, dFun) => lFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureIntBooleanBooleanString2Long(f: (iFun, bFun, bFun, sFun) => lFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, StringFun), LongFun)
  def getSignatureIntBooleanBooleanBoolean2Long(f: (iFun, bFun, bFun, bFun) => lFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureLongIntIntInt2Long(f: (lFun, iFun, iFun, iFun) => lFun): String = getSignature(List(LongFun, IntFun, IntFun, IntFun), LongFun)
  def getSignatureLongIntIntLong2Long(f: (lFun, iFun, iFun, lFun) => lFun): String = getSignature(List(LongFun, IntFun, IntFun, LongFun), LongFun)
  def getSignatureLongIntIntDouble2Long(f: (lFun, iFun, iFun, dFun) => lFun): String = getSignature(List(LongFun, IntFun, IntFun, DoubleFun), LongFun)
  def getSignatureLongIntIntString2Long(f: (lFun, iFun, iFun, sFun) => lFun): String = getSignature(List(LongFun, IntFun, IntFun, StringFun), LongFun)
  def getSignatureLongIntIntBoolean2Long(f: (lFun, iFun, iFun, bFun) => lFun): String = getSignature(List(LongFun, IntFun, IntFun, BooleanFun), LongFun)
  def getSignatureLongIntLongInt2Long(f: (lFun, iFun, lFun, iFun) => lFun): String = getSignature(List(LongFun, IntFun, LongFun, IntFun), LongFun)
  def getSignatureLongIntLongLong2Long(f: (lFun, iFun, lFun, lFun) => lFun): String = getSignature(List(LongFun, IntFun, LongFun, LongFun), LongFun)
  def getSignatureLongIntLongDouble2Long(f: (lFun, iFun, lFun, dFun) => lFun): String = getSignature(List(LongFun, IntFun, LongFun, DoubleFun), LongFun)
  def getSignatureLongIntLongString2Long(f: (lFun, iFun, lFun, sFun) => lFun): String = getSignature(List(LongFun, IntFun, LongFun, StringFun), LongFun)
  def getSignatureLongIntLongBoolean2Long(f: (lFun, iFun, lFun, bFun) => lFun): String = getSignature(List(LongFun, IntFun, LongFun, BooleanFun), LongFun)
  def getSignatureLongIntDoubleInt2Long(f: (lFun, iFun, dFun, iFun) => lFun): String = getSignature(List(LongFun, IntFun, DoubleFun, IntFun), LongFun)
  def getSignatureLongIntDoubleLong2Long(f: (lFun, iFun, dFun, lFun) => lFun): String = getSignature(List(LongFun, IntFun, DoubleFun, LongFun), LongFun)
  def getSignatureLongIntDoubleDouble2Long(f: (lFun, iFun, dFun, dFun) => lFun): String = getSignature(List(LongFun, IntFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureLongIntDoubleString2Long(f: (lFun, iFun, dFun, sFun) => lFun): String = getSignature(List(LongFun, IntFun, DoubleFun, StringFun), LongFun)
  def getSignatureLongIntDoubleBoolean2Long(f: (lFun, iFun, dFun, bFun) => lFun): String = getSignature(List(LongFun, IntFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureLongIntStringInt2Long(f: (lFun, iFun, sFun, iFun) => lFun): String = getSignature(List(LongFun, IntFun, StringFun, IntFun), LongFun)
  def getSignatureLongIntStringLong2Long(f: (lFun, iFun, sFun, lFun) => lFun): String = getSignature(List(LongFun, IntFun, StringFun, LongFun), LongFun)
  def getSignatureLongIntStringDouble2Long(f: (lFun, iFun, sFun, dFun) => lFun): String = getSignature(List(LongFun, IntFun, StringFun, DoubleFun), LongFun)
  def getSignatureLongIntStringString2Long(f: (lFun, iFun, sFun, sFun) => lFun): String = getSignature(List(LongFun, IntFun, StringFun, StringFun), LongFun)
  def getSignatureLongIntStringBoolean2Long(f: (lFun, iFun, sFun, bFun) => lFun): String = getSignature(List(LongFun, IntFun, StringFun, BooleanFun), LongFun)
  def getSignatureLongIntBooleanInt2Long(f: (lFun, iFun, bFun, iFun) => lFun): String = getSignature(List(LongFun, IntFun, BooleanFun, IntFun), LongFun)
  def getSignatureLongIntBooleanLong2Long(f: (lFun, iFun, bFun, lFun) => lFun): String = getSignature(List(LongFun, IntFun, BooleanFun, LongFun), LongFun)
  def getSignatureLongIntBooleanDouble2Long(f: (lFun, iFun, bFun, dFun) => lFun): String = getSignature(List(LongFun, IntFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureLongIntBooleanString2Long(f: (lFun, iFun, bFun, sFun) => lFun): String = getSignature(List(LongFun, IntFun, BooleanFun, StringFun), LongFun)
  def getSignatureLongIntBooleanBoolean2Long(f: (lFun, iFun, bFun, bFun) => lFun): String = getSignature(List(LongFun, IntFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureLongLongIntInt2Long(f: (lFun, lFun, iFun, iFun) => lFun): String = getSignature(List(LongFun, LongFun, IntFun, IntFun), LongFun)
  def getSignatureLongLongIntLong2Long(f: (lFun, lFun, iFun, lFun) => lFun): String = getSignature(List(LongFun, LongFun, IntFun, LongFun), LongFun)
  def getSignatureLongLongIntDouble2Long(f: (lFun, lFun, iFun, dFun) => lFun): String = getSignature(List(LongFun, LongFun, IntFun, DoubleFun), LongFun)
  def getSignatureLongLongIntString2Long(f: (lFun, lFun, iFun, sFun) => lFun): String = getSignature(List(LongFun, LongFun, IntFun, StringFun), LongFun)
  def getSignatureLongLongIntBoolean2Long(f: (lFun, lFun, iFun, bFun) => lFun): String = getSignature(List(LongFun, LongFun, IntFun, BooleanFun), LongFun)
  def getSignatureLongLongLongInt2Long(f: (lFun, lFun, lFun, iFun) => lFun): String = getSignature(List(LongFun, LongFun, LongFun, IntFun), LongFun)
  def getSignatureLongLongLongLong2Long(f: (lFun, lFun, lFun, lFun) => lFun): String = getSignature(List(LongFun, LongFun, LongFun, LongFun), LongFun)
  def getSignatureLongLongLongDouble2Long(f: (lFun, lFun, lFun, dFun) => lFun): String = getSignature(List(LongFun, LongFun, LongFun, DoubleFun), LongFun)
  def getSignatureLongLongLongString2Long(f: (lFun, lFun, lFun, sFun) => lFun): String = getSignature(List(LongFun, LongFun, LongFun, StringFun), LongFun)
  def getSignatureLongLongLongBoolean2Long(f: (lFun, lFun, lFun, bFun) => lFun): String = getSignature(List(LongFun, LongFun, LongFun, BooleanFun), LongFun)
  def getSignatureLongLongDoubleInt2Long(f: (lFun, lFun, dFun, iFun) => lFun): String = getSignature(List(LongFun, LongFun, DoubleFun, IntFun), LongFun)
  def getSignatureLongLongDoubleLong2Long(f: (lFun, lFun, dFun, lFun) => lFun): String = getSignature(List(LongFun, LongFun, DoubleFun, LongFun), LongFun)
  def getSignatureLongLongDoubleDouble2Long(f: (lFun, lFun, dFun, dFun) => lFun): String = getSignature(List(LongFun, LongFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureLongLongDoubleString2Long(f: (lFun, lFun, dFun, sFun) => lFun): String = getSignature(List(LongFun, LongFun, DoubleFun, StringFun), LongFun)
  def getSignatureLongLongDoubleBoolean2Long(f: (lFun, lFun, dFun, bFun) => lFun): String = getSignature(List(LongFun, LongFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureLongLongStringInt2Long(f: (lFun, lFun, sFun, iFun) => lFun): String = getSignature(List(LongFun, LongFun, StringFun, IntFun), LongFun)
  def getSignatureLongLongStringLong2Long(f: (lFun, lFun, sFun, lFun) => lFun): String = getSignature(List(LongFun, LongFun, StringFun, LongFun), LongFun)
  def getSignatureLongLongStringDouble2Long(f: (lFun, lFun, sFun, dFun) => lFun): String = getSignature(List(LongFun, LongFun, StringFun, DoubleFun), LongFun)
  def getSignatureLongLongStringString2Long(f: (lFun, lFun, sFun, sFun) => lFun): String = getSignature(List(LongFun, LongFun, StringFun, StringFun), LongFun)
  def getSignatureLongLongStringBoolean2Long(f: (lFun, lFun, sFun, bFun) => lFun): String = getSignature(List(LongFun, LongFun, StringFun, BooleanFun), LongFun)
  def getSignatureLongLongBooleanInt2Long(f: (lFun, lFun, bFun, iFun) => lFun): String = getSignature(List(LongFun, LongFun, BooleanFun, IntFun), LongFun)
  def getSignatureLongLongBooleanLong2Long(f: (lFun, lFun, bFun, lFun) => lFun): String = getSignature(List(LongFun, LongFun, BooleanFun, LongFun), LongFun)
  def getSignatureLongLongBooleanDouble2Long(f: (lFun, lFun, bFun, dFun) => lFun): String = getSignature(List(LongFun, LongFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureLongLongBooleanString2Long(f: (lFun, lFun, bFun, sFun) => lFun): String = getSignature(List(LongFun, LongFun, BooleanFun, StringFun), LongFun)
  def getSignatureLongLongBooleanBoolean2Long(f: (lFun, lFun, bFun, bFun) => lFun): String = getSignature(List(LongFun, LongFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureLongDoubleIntInt2Long(f: (lFun, dFun, iFun, iFun) => lFun): String = getSignature(List(LongFun, DoubleFun, IntFun, IntFun), LongFun)
  def getSignatureLongDoubleIntLong2Long(f: (lFun, dFun, iFun, lFun) => lFun): String = getSignature(List(LongFun, DoubleFun, IntFun, LongFun), LongFun)
  def getSignatureLongDoubleIntDouble2Long(f: (lFun, dFun, iFun, dFun) => lFun): String = getSignature(List(LongFun, DoubleFun, IntFun, DoubleFun), LongFun)
  def getSignatureLongDoubleIntString2Long(f: (lFun, dFun, iFun, sFun) => lFun): String = getSignature(List(LongFun, DoubleFun, IntFun, StringFun), LongFun)
  def getSignatureLongDoubleIntBoolean2Long(f: (lFun, dFun, iFun, bFun) => lFun): String = getSignature(List(LongFun, DoubleFun, IntFun, BooleanFun), LongFun)
  def getSignatureLongDoubleLongInt2Long(f: (lFun, dFun, lFun, iFun) => lFun): String = getSignature(List(LongFun, DoubleFun, LongFun, IntFun), LongFun)
  def getSignatureLongDoubleLongLong2Long(f: (lFun, dFun, lFun, lFun) => lFun): String = getSignature(List(LongFun, DoubleFun, LongFun, LongFun), LongFun)
  def getSignatureLongDoubleLongDouble2Long(f: (lFun, dFun, lFun, dFun) => lFun): String = getSignature(List(LongFun, DoubleFun, LongFun, DoubleFun), LongFun)
  def getSignatureLongDoubleLongString2Long(f: (lFun, dFun, lFun, sFun) => lFun): String = getSignature(List(LongFun, DoubleFun, LongFun, StringFun), LongFun)
  def getSignatureLongDoubleLongBoolean2Long(f: (lFun, dFun, lFun, bFun) => lFun): String = getSignature(List(LongFun, DoubleFun, LongFun, BooleanFun), LongFun)
  def getSignatureLongDoubleDoubleInt2Long(f: (lFun, dFun, dFun, iFun) => lFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, IntFun), LongFun)
  def getSignatureLongDoubleDoubleLong2Long(f: (lFun, dFun, dFun, lFun) => lFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, LongFun), LongFun)
  def getSignatureLongDoubleDoubleDouble2Long(f: (lFun, dFun, dFun, dFun) => lFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureLongDoubleDoubleString2Long(f: (lFun, dFun, dFun, sFun) => lFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, StringFun), LongFun)
  def getSignatureLongDoubleDoubleBoolean2Long(f: (lFun, dFun, dFun, bFun) => lFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureLongDoubleStringInt2Long(f: (lFun, dFun, sFun, iFun) => lFun): String = getSignature(List(LongFun, DoubleFun, StringFun, IntFun), LongFun)
  def getSignatureLongDoubleStringLong2Long(f: (lFun, dFun, sFun, lFun) => lFun): String = getSignature(List(LongFun, DoubleFun, StringFun, LongFun), LongFun)
  def getSignatureLongDoubleStringDouble2Long(f: (lFun, dFun, sFun, dFun) => lFun): String = getSignature(List(LongFun, DoubleFun, StringFun, DoubleFun), LongFun)
  def getSignatureLongDoubleStringString2Long(f: (lFun, dFun, sFun, sFun) => lFun): String = getSignature(List(LongFun, DoubleFun, StringFun, StringFun), LongFun)
  def getSignatureLongDoubleStringBoolean2Long(f: (lFun, dFun, sFun, bFun) => lFun): String = getSignature(List(LongFun, DoubleFun, StringFun, BooleanFun), LongFun)
  def getSignatureLongDoubleBooleanInt2Long(f: (lFun, dFun, bFun, iFun) => lFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, IntFun), LongFun)
  def getSignatureLongDoubleBooleanLong2Long(f: (lFun, dFun, bFun, lFun) => lFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, LongFun), LongFun)
  def getSignatureLongDoubleBooleanDouble2Long(f: (lFun, dFun, bFun, dFun) => lFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureLongDoubleBooleanString2Long(f: (lFun, dFun, bFun, sFun) => lFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, StringFun), LongFun)
  def getSignatureLongDoubleBooleanBoolean2Long(f: (lFun, dFun, bFun, bFun) => lFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureLongStringIntInt2Long(f: (lFun, sFun, iFun, iFun) => lFun): String = getSignature(List(LongFun, StringFun, IntFun, IntFun), LongFun)
  def getSignatureLongStringIntLong2Long(f: (lFun, sFun, iFun, lFun) => lFun): String = getSignature(List(LongFun, StringFun, IntFun, LongFun), LongFun)
  def getSignatureLongStringIntDouble2Long(f: (lFun, sFun, iFun, dFun) => lFun): String = getSignature(List(LongFun, StringFun, IntFun, DoubleFun), LongFun)
  def getSignatureLongStringIntString2Long(f: (lFun, sFun, iFun, sFun) => lFun): String = getSignature(List(LongFun, StringFun, IntFun, StringFun), LongFun)
  def getSignatureLongStringIntBoolean2Long(f: (lFun, sFun, iFun, bFun) => lFun): String = getSignature(List(LongFun, StringFun, IntFun, BooleanFun), LongFun)
  def getSignatureLongStringLongInt2Long(f: (lFun, sFun, lFun, iFun) => lFun): String = getSignature(List(LongFun, StringFun, LongFun, IntFun), LongFun)
  def getSignatureLongStringLongLong2Long(f: (lFun, sFun, lFun, lFun) => lFun): String = getSignature(List(LongFun, StringFun, LongFun, LongFun), LongFun)
  def getSignatureLongStringLongDouble2Long(f: (lFun, sFun, lFun, dFun) => lFun): String = getSignature(List(LongFun, StringFun, LongFun, DoubleFun), LongFun)
  def getSignatureLongStringLongString2Long(f: (lFun, sFun, lFun, sFun) => lFun): String = getSignature(List(LongFun, StringFun, LongFun, StringFun), LongFun)
  def getSignatureLongStringLongBoolean2Long(f: (lFun, sFun, lFun, bFun) => lFun): String = getSignature(List(LongFun, StringFun, LongFun, BooleanFun), LongFun)
  def getSignatureLongStringDoubleInt2Long(f: (lFun, sFun, dFun, iFun) => lFun): String = getSignature(List(LongFun, StringFun, DoubleFun, IntFun), LongFun)
  def getSignatureLongStringDoubleLong2Long(f: (lFun, sFun, dFun, lFun) => lFun): String = getSignature(List(LongFun, StringFun, DoubleFun, LongFun), LongFun)
  def getSignatureLongStringDoubleDouble2Long(f: (lFun, sFun, dFun, dFun) => lFun): String = getSignature(List(LongFun, StringFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureLongStringDoubleString2Long(f: (lFun, sFun, dFun, sFun) => lFun): String = getSignature(List(LongFun, StringFun, DoubleFun, StringFun), LongFun)
  def getSignatureLongStringDoubleBoolean2Long(f: (lFun, sFun, dFun, bFun) => lFun): String = getSignature(List(LongFun, StringFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureLongStringStringInt2Long(f: (lFun, sFun, sFun, iFun) => lFun): String = getSignature(List(LongFun, StringFun, StringFun, IntFun), LongFun)
  def getSignatureLongStringStringLong2Long(f: (lFun, sFun, sFun, lFun) => lFun): String = getSignature(List(LongFun, StringFun, StringFun, LongFun), LongFun)
  def getSignatureLongStringStringDouble2Long(f: (lFun, sFun, sFun, dFun) => lFun): String = getSignature(List(LongFun, StringFun, StringFun, DoubleFun), LongFun)
  def getSignatureLongStringStringString2Long(f: (lFun, sFun, sFun, sFun) => lFun): String = getSignature(List(LongFun, StringFun, StringFun, StringFun), LongFun)
  def getSignatureLongStringStringBoolean2Long(f: (lFun, sFun, sFun, bFun) => lFun): String = getSignature(List(LongFun, StringFun, StringFun, BooleanFun), LongFun)
  def getSignatureLongStringBooleanInt2Long(f: (lFun, sFun, bFun, iFun) => lFun): String = getSignature(List(LongFun, StringFun, BooleanFun, IntFun), LongFun)
  def getSignatureLongStringBooleanLong2Long(f: (lFun, sFun, bFun, lFun) => lFun): String = getSignature(List(LongFun, StringFun, BooleanFun, LongFun), LongFun)
  def getSignatureLongStringBooleanDouble2Long(f: (lFun, sFun, bFun, dFun) => lFun): String = getSignature(List(LongFun, StringFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureLongStringBooleanString2Long(f: (lFun, sFun, bFun, sFun) => lFun): String = getSignature(List(LongFun, StringFun, BooleanFun, StringFun), LongFun)
  def getSignatureLongStringBooleanBoolean2Long(f: (lFun, sFun, bFun, bFun) => lFun): String = getSignature(List(LongFun, StringFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureLongBooleanIntInt2Long(f: (lFun, bFun, iFun, iFun) => lFun): String = getSignature(List(LongFun, BooleanFun, IntFun, IntFun), LongFun)
  def getSignatureLongBooleanIntLong2Long(f: (lFun, bFun, iFun, lFun) => lFun): String = getSignature(List(LongFun, BooleanFun, IntFun, LongFun), LongFun)
  def getSignatureLongBooleanIntDouble2Long(f: (lFun, bFun, iFun, dFun) => lFun): String = getSignature(List(LongFun, BooleanFun, IntFun, DoubleFun), LongFun)
  def getSignatureLongBooleanIntString2Long(f: (lFun, bFun, iFun, sFun) => lFun): String = getSignature(List(LongFun, BooleanFun, IntFun, StringFun), LongFun)
  def getSignatureLongBooleanIntBoolean2Long(f: (lFun, bFun, iFun, bFun) => lFun): String = getSignature(List(LongFun, BooleanFun, IntFun, BooleanFun), LongFun)
  def getSignatureLongBooleanLongInt2Long(f: (lFun, bFun, lFun, iFun) => lFun): String = getSignature(List(LongFun, BooleanFun, LongFun, IntFun), LongFun)
  def getSignatureLongBooleanLongLong2Long(f: (lFun, bFun, lFun, lFun) => lFun): String = getSignature(List(LongFun, BooleanFun, LongFun, LongFun), LongFun)
  def getSignatureLongBooleanLongDouble2Long(f: (lFun, bFun, lFun, dFun) => lFun): String = getSignature(List(LongFun, BooleanFun, LongFun, DoubleFun), LongFun)
  def getSignatureLongBooleanLongString2Long(f: (lFun, bFun, lFun, sFun) => lFun): String = getSignature(List(LongFun, BooleanFun, LongFun, StringFun), LongFun)
  def getSignatureLongBooleanLongBoolean2Long(f: (lFun, bFun, lFun, bFun) => lFun): String = getSignature(List(LongFun, BooleanFun, LongFun, BooleanFun), LongFun)
  def getSignatureLongBooleanDoubleInt2Long(f: (lFun, bFun, dFun, iFun) => lFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, IntFun), LongFun)
  def getSignatureLongBooleanDoubleLong2Long(f: (lFun, bFun, dFun, lFun) => lFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, LongFun), LongFun)
  def getSignatureLongBooleanDoubleDouble2Long(f: (lFun, bFun, dFun, dFun) => lFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureLongBooleanDoubleString2Long(f: (lFun, bFun, dFun, sFun) => lFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, StringFun), LongFun)
  def getSignatureLongBooleanDoubleBoolean2Long(f: (lFun, bFun, dFun, bFun) => lFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureLongBooleanStringInt2Long(f: (lFun, bFun, sFun, iFun) => lFun): String = getSignature(List(LongFun, BooleanFun, StringFun, IntFun), LongFun)
  def getSignatureLongBooleanStringLong2Long(f: (lFun, bFun, sFun, lFun) => lFun): String = getSignature(List(LongFun, BooleanFun, StringFun, LongFun), LongFun)
  def getSignatureLongBooleanStringDouble2Long(f: (lFun, bFun, sFun, dFun) => lFun): String = getSignature(List(LongFun, BooleanFun, StringFun, DoubleFun), LongFun)
  def getSignatureLongBooleanStringString2Long(f: (lFun, bFun, sFun, sFun) => lFun): String = getSignature(List(LongFun, BooleanFun, StringFun, StringFun), LongFun)
  def getSignatureLongBooleanStringBoolean2Long(f: (lFun, bFun, sFun, bFun) => lFun): String = getSignature(List(LongFun, BooleanFun, StringFun, BooleanFun), LongFun)
  def getSignatureLongBooleanBooleanInt2Long(f: (lFun, bFun, bFun, iFun) => lFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, IntFun), LongFun)
  def getSignatureLongBooleanBooleanLong2Long(f: (lFun, bFun, bFun, lFun) => lFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, LongFun), LongFun)
  def getSignatureLongBooleanBooleanDouble2Long(f: (lFun, bFun, bFun, dFun) => lFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureLongBooleanBooleanString2Long(f: (lFun, bFun, bFun, sFun) => lFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, StringFun), LongFun)
  def getSignatureLongBooleanBooleanBoolean2Long(f: (lFun, bFun, bFun, bFun) => lFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureDoubleIntIntInt2Long(f: (dFun, iFun, iFun, iFun) => lFun): String = getSignature(List(DoubleFun, IntFun, IntFun, IntFun), LongFun)
  def getSignatureDoubleIntIntLong2Long(f: (dFun, iFun, iFun, lFun) => lFun): String = getSignature(List(DoubleFun, IntFun, IntFun, LongFun), LongFun)
  def getSignatureDoubleIntIntDouble2Long(f: (dFun, iFun, iFun, dFun) => lFun): String = getSignature(List(DoubleFun, IntFun, IntFun, DoubleFun), LongFun)
  def getSignatureDoubleIntIntString2Long(f: (dFun, iFun, iFun, sFun) => lFun): String = getSignature(List(DoubleFun, IntFun, IntFun, StringFun), LongFun)
  def getSignatureDoubleIntIntBoolean2Long(f: (dFun, iFun, iFun, bFun) => lFun): String = getSignature(List(DoubleFun, IntFun, IntFun, BooleanFun), LongFun)
  def getSignatureDoubleIntLongInt2Long(f: (dFun, iFun, lFun, iFun) => lFun): String = getSignature(List(DoubleFun, IntFun, LongFun, IntFun), LongFun)
  def getSignatureDoubleIntLongLong2Long(f: (dFun, iFun, lFun, lFun) => lFun): String = getSignature(List(DoubleFun, IntFun, LongFun, LongFun), LongFun)
  def getSignatureDoubleIntLongDouble2Long(f: (dFun, iFun, lFun, dFun) => lFun): String = getSignature(List(DoubleFun, IntFun, LongFun, DoubleFun), LongFun)
  def getSignatureDoubleIntLongString2Long(f: (dFun, iFun, lFun, sFun) => lFun): String = getSignature(List(DoubleFun, IntFun, LongFun, StringFun), LongFun)
  def getSignatureDoubleIntLongBoolean2Long(f: (dFun, iFun, lFun, bFun) => lFun): String = getSignature(List(DoubleFun, IntFun, LongFun, BooleanFun), LongFun)
  def getSignatureDoubleIntDoubleInt2Long(f: (dFun, iFun, dFun, iFun) => lFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, IntFun), LongFun)
  def getSignatureDoubleIntDoubleLong2Long(f: (dFun, iFun, dFun, lFun) => lFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, LongFun), LongFun)
  def getSignatureDoubleIntDoubleDouble2Long(f: (dFun, iFun, dFun, dFun) => lFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureDoubleIntDoubleString2Long(f: (dFun, iFun, dFun, sFun) => lFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, StringFun), LongFun)
  def getSignatureDoubleIntDoubleBoolean2Long(f: (dFun, iFun, dFun, bFun) => lFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureDoubleIntStringInt2Long(f: (dFun, iFun, sFun, iFun) => lFun): String = getSignature(List(DoubleFun, IntFun, StringFun, IntFun), LongFun)
  def getSignatureDoubleIntStringLong2Long(f: (dFun, iFun, sFun, lFun) => lFun): String = getSignature(List(DoubleFun, IntFun, StringFun, LongFun), LongFun)
  def getSignatureDoubleIntStringDouble2Long(f: (dFun, iFun, sFun, dFun) => lFun): String = getSignature(List(DoubleFun, IntFun, StringFun, DoubleFun), LongFun)
  def getSignatureDoubleIntStringString2Long(f: (dFun, iFun, sFun, sFun) => lFun): String = getSignature(List(DoubleFun, IntFun, StringFun, StringFun), LongFun)
  def getSignatureDoubleIntStringBoolean2Long(f: (dFun, iFun, sFun, bFun) => lFun): String = getSignature(List(DoubleFun, IntFun, StringFun, BooleanFun), LongFun)
  def getSignatureDoubleIntBooleanInt2Long(f: (dFun, iFun, bFun, iFun) => lFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, IntFun), LongFun)
  def getSignatureDoubleIntBooleanLong2Long(f: (dFun, iFun, bFun, lFun) => lFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, LongFun), LongFun)
  def getSignatureDoubleIntBooleanDouble2Long(f: (dFun, iFun, bFun, dFun) => lFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureDoubleIntBooleanString2Long(f: (dFun, iFun, bFun, sFun) => lFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, StringFun), LongFun)
  def getSignatureDoubleIntBooleanBoolean2Long(f: (dFun, iFun, bFun, bFun) => lFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureDoubleLongIntInt2Long(f: (dFun, lFun, iFun, iFun) => lFun): String = getSignature(List(DoubleFun, LongFun, IntFun, IntFun), LongFun)
  def getSignatureDoubleLongIntLong2Long(f: (dFun, lFun, iFun, lFun) => lFun): String = getSignature(List(DoubleFun, LongFun, IntFun, LongFun), LongFun)
  def getSignatureDoubleLongIntDouble2Long(f: (dFun, lFun, iFun, dFun) => lFun): String = getSignature(List(DoubleFun, LongFun, IntFun, DoubleFun), LongFun)
  def getSignatureDoubleLongIntString2Long(f: (dFun, lFun, iFun, sFun) => lFun): String = getSignature(List(DoubleFun, LongFun, IntFun, StringFun), LongFun)
  def getSignatureDoubleLongIntBoolean2Long(f: (dFun, lFun, iFun, bFun) => lFun): String = getSignature(List(DoubleFun, LongFun, IntFun, BooleanFun), LongFun)
  def getSignatureDoubleLongLongInt2Long(f: (dFun, lFun, lFun, iFun) => lFun): String = getSignature(List(DoubleFun, LongFun, LongFun, IntFun), LongFun)
  def getSignatureDoubleLongLongLong2Long(f: (dFun, lFun, lFun, lFun) => lFun): String = getSignature(List(DoubleFun, LongFun, LongFun, LongFun), LongFun)
  def getSignatureDoubleLongLongDouble2Long(f: (dFun, lFun, lFun, dFun) => lFun): String = getSignature(List(DoubleFun, LongFun, LongFun, DoubleFun), LongFun)
  def getSignatureDoubleLongLongString2Long(f: (dFun, lFun, lFun, sFun) => lFun): String = getSignature(List(DoubleFun, LongFun, LongFun, StringFun), LongFun)
  def getSignatureDoubleLongLongBoolean2Long(f: (dFun, lFun, lFun, bFun) => lFun): String = getSignature(List(DoubleFun, LongFun, LongFun, BooleanFun), LongFun)
  def getSignatureDoubleLongDoubleInt2Long(f: (dFun, lFun, dFun, iFun) => lFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, IntFun), LongFun)
  def getSignatureDoubleLongDoubleLong2Long(f: (dFun, lFun, dFun, lFun) => lFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, LongFun), LongFun)
  def getSignatureDoubleLongDoubleDouble2Long(f: (dFun, lFun, dFun, dFun) => lFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureDoubleLongDoubleString2Long(f: (dFun, lFun, dFun, sFun) => lFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, StringFun), LongFun)
  def getSignatureDoubleLongDoubleBoolean2Long(f: (dFun, lFun, dFun, bFun) => lFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureDoubleLongStringInt2Long(f: (dFun, lFun, sFun, iFun) => lFun): String = getSignature(List(DoubleFun, LongFun, StringFun, IntFun), LongFun)
  def getSignatureDoubleLongStringLong2Long(f: (dFun, lFun, sFun, lFun) => lFun): String = getSignature(List(DoubleFun, LongFun, StringFun, LongFun), LongFun)
  def getSignatureDoubleLongStringDouble2Long(f: (dFun, lFun, sFun, dFun) => lFun): String = getSignature(List(DoubleFun, LongFun, StringFun, DoubleFun), LongFun)
  def getSignatureDoubleLongStringString2Long(f: (dFun, lFun, sFun, sFun) => lFun): String = getSignature(List(DoubleFun, LongFun, StringFun, StringFun), LongFun)
  def getSignatureDoubleLongStringBoolean2Long(f: (dFun, lFun, sFun, bFun) => lFun): String = getSignature(List(DoubleFun, LongFun, StringFun, BooleanFun), LongFun)
  def getSignatureDoubleLongBooleanInt2Long(f: (dFun, lFun, bFun, iFun) => lFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, IntFun), LongFun)
  def getSignatureDoubleLongBooleanLong2Long(f: (dFun, lFun, bFun, lFun) => lFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, LongFun), LongFun)
  def getSignatureDoubleLongBooleanDouble2Long(f: (dFun, lFun, bFun, dFun) => lFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureDoubleLongBooleanString2Long(f: (dFun, lFun, bFun, sFun) => lFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, StringFun), LongFun)
  def getSignatureDoubleLongBooleanBoolean2Long(f: (dFun, lFun, bFun, bFun) => lFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureDoubleDoubleIntInt2Long(f: (dFun, dFun, iFun, iFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, IntFun), LongFun)
  def getSignatureDoubleDoubleIntLong2Long(f: (dFun, dFun, iFun, lFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, LongFun), LongFun)
  def getSignatureDoubleDoubleIntDouble2Long(f: (dFun, dFun, iFun, dFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, DoubleFun), LongFun)
  def getSignatureDoubleDoubleIntString2Long(f: (dFun, dFun, iFun, sFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, StringFun), LongFun)
  def getSignatureDoubleDoubleIntBoolean2Long(f: (dFun, dFun, iFun, bFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, BooleanFun), LongFun)
  def getSignatureDoubleDoubleLongInt2Long(f: (dFun, dFun, lFun, iFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, IntFun), LongFun)
  def getSignatureDoubleDoubleLongLong2Long(f: (dFun, dFun, lFun, lFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, LongFun), LongFun)
  def getSignatureDoubleDoubleLongDouble2Long(f: (dFun, dFun, lFun, dFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, DoubleFun), LongFun)
  def getSignatureDoubleDoubleLongString2Long(f: (dFun, dFun, lFun, sFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, StringFun), LongFun)
  def getSignatureDoubleDoubleLongBoolean2Long(f: (dFun, dFun, lFun, bFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, BooleanFun), LongFun)
  def getSignatureDoubleDoubleDoubleInt2Long(f: (dFun, dFun, dFun, iFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, IntFun), LongFun)
  def getSignatureDoubleDoubleDoubleLong2Long(f: (dFun, dFun, dFun, lFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, LongFun), LongFun)
  def getSignatureDoubleDoubleDoubleDouble2Long(f: (dFun, dFun, dFun, dFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureDoubleDoubleDoubleString2Long(f: (dFun, dFun, dFun, sFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, StringFun), LongFun)
  def getSignatureDoubleDoubleDoubleBoolean2Long(f: (dFun, dFun, dFun, bFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureDoubleDoubleStringInt2Long(f: (dFun, dFun, sFun, iFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, IntFun), LongFun)
  def getSignatureDoubleDoubleStringLong2Long(f: (dFun, dFun, sFun, lFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, LongFun), LongFun)
  def getSignatureDoubleDoubleStringDouble2Long(f: (dFun, dFun, sFun, dFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, DoubleFun), LongFun)
  def getSignatureDoubleDoubleStringString2Long(f: (dFun, dFun, sFun, sFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, StringFun), LongFun)
  def getSignatureDoubleDoubleStringBoolean2Long(f: (dFun, dFun, sFun, bFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, BooleanFun), LongFun)
  def getSignatureDoubleDoubleBooleanInt2Long(f: (dFun, dFun, bFun, iFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, IntFun), LongFun)
  def getSignatureDoubleDoubleBooleanLong2Long(f: (dFun, dFun, bFun, lFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, LongFun), LongFun)
  def getSignatureDoubleDoubleBooleanDouble2Long(f: (dFun, dFun, bFun, dFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureDoubleDoubleBooleanString2Long(f: (dFun, dFun, bFun, sFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, StringFun), LongFun)
  def getSignatureDoubleDoubleBooleanBoolean2Long(f: (dFun, dFun, bFun, bFun) => lFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureDoubleStringIntInt2Long(f: (dFun, sFun, iFun, iFun) => lFun): String = getSignature(List(DoubleFun, StringFun, IntFun, IntFun), LongFun)
  def getSignatureDoubleStringIntLong2Long(f: (dFun, sFun, iFun, lFun) => lFun): String = getSignature(List(DoubleFun, StringFun, IntFun, LongFun), LongFun)
  def getSignatureDoubleStringIntDouble2Long(f: (dFun, sFun, iFun, dFun) => lFun): String = getSignature(List(DoubleFun, StringFun, IntFun, DoubleFun), LongFun)
  def getSignatureDoubleStringIntString2Long(f: (dFun, sFun, iFun, sFun) => lFun): String = getSignature(List(DoubleFun, StringFun, IntFun, StringFun), LongFun)
  def getSignatureDoubleStringIntBoolean2Long(f: (dFun, sFun, iFun, bFun) => lFun): String = getSignature(List(DoubleFun, StringFun, IntFun, BooleanFun), LongFun)
  def getSignatureDoubleStringLongInt2Long(f: (dFun, sFun, lFun, iFun) => lFun): String = getSignature(List(DoubleFun, StringFun, LongFun, IntFun), LongFun)
  def getSignatureDoubleStringLongLong2Long(f: (dFun, sFun, lFun, lFun) => lFun): String = getSignature(List(DoubleFun, StringFun, LongFun, LongFun), LongFun)
  def getSignatureDoubleStringLongDouble2Long(f: (dFun, sFun, lFun, dFun) => lFun): String = getSignature(List(DoubleFun, StringFun, LongFun, DoubleFun), LongFun)
  def getSignatureDoubleStringLongString2Long(f: (dFun, sFun, lFun, sFun) => lFun): String = getSignature(List(DoubleFun, StringFun, LongFun, StringFun), LongFun)
  def getSignatureDoubleStringLongBoolean2Long(f: (dFun, sFun, lFun, bFun) => lFun): String = getSignature(List(DoubleFun, StringFun, LongFun, BooleanFun), LongFun)
  def getSignatureDoubleStringDoubleInt2Long(f: (dFun, sFun, dFun, iFun) => lFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, IntFun), LongFun)
  def getSignatureDoubleStringDoubleLong2Long(f: (dFun, sFun, dFun, lFun) => lFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, LongFun), LongFun)
  def getSignatureDoubleStringDoubleDouble2Long(f: (dFun, sFun, dFun, dFun) => lFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureDoubleStringDoubleString2Long(f: (dFun, sFun, dFun, sFun) => lFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, StringFun), LongFun)
  def getSignatureDoubleStringDoubleBoolean2Long(f: (dFun, sFun, dFun, bFun) => lFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureDoubleStringStringInt2Long(f: (dFun, sFun, sFun, iFun) => lFun): String = getSignature(List(DoubleFun, StringFun, StringFun, IntFun), LongFun)
  def getSignatureDoubleStringStringLong2Long(f: (dFun, sFun, sFun, lFun) => lFun): String = getSignature(List(DoubleFun, StringFun, StringFun, LongFun), LongFun)
  def getSignatureDoubleStringStringDouble2Long(f: (dFun, sFun, sFun, dFun) => lFun): String = getSignature(List(DoubleFun, StringFun, StringFun, DoubleFun), LongFun)
  def getSignatureDoubleStringStringString2Long(f: (dFun, sFun, sFun, sFun) => lFun): String = getSignature(List(DoubleFun, StringFun, StringFun, StringFun), LongFun)
  def getSignatureDoubleStringStringBoolean2Long(f: (dFun, sFun, sFun, bFun) => lFun): String = getSignature(List(DoubleFun, StringFun, StringFun, BooleanFun), LongFun)
  def getSignatureDoubleStringBooleanInt2Long(f: (dFun, sFun, bFun, iFun) => lFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, IntFun), LongFun)
  def getSignatureDoubleStringBooleanLong2Long(f: (dFun, sFun, bFun, lFun) => lFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, LongFun), LongFun)
  def getSignatureDoubleStringBooleanDouble2Long(f: (dFun, sFun, bFun, dFun) => lFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureDoubleStringBooleanString2Long(f: (dFun, sFun, bFun, sFun) => lFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, StringFun), LongFun)
  def getSignatureDoubleStringBooleanBoolean2Long(f: (dFun, sFun, bFun, bFun) => lFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureDoubleBooleanIntInt2Long(f: (dFun, bFun, iFun, iFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, IntFun), LongFun)
  def getSignatureDoubleBooleanIntLong2Long(f: (dFun, bFun, iFun, lFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, LongFun), LongFun)
  def getSignatureDoubleBooleanIntDouble2Long(f: (dFun, bFun, iFun, dFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, DoubleFun), LongFun)
  def getSignatureDoubleBooleanIntString2Long(f: (dFun, bFun, iFun, sFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, StringFun), LongFun)
  def getSignatureDoubleBooleanIntBoolean2Long(f: (dFun, bFun, iFun, bFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, BooleanFun), LongFun)
  def getSignatureDoubleBooleanLongInt2Long(f: (dFun, bFun, lFun, iFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, IntFun), LongFun)
  def getSignatureDoubleBooleanLongLong2Long(f: (dFun, bFun, lFun, lFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, LongFun), LongFun)
  def getSignatureDoubleBooleanLongDouble2Long(f: (dFun, bFun, lFun, dFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, DoubleFun), LongFun)
  def getSignatureDoubleBooleanLongString2Long(f: (dFun, bFun, lFun, sFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, StringFun), LongFun)
  def getSignatureDoubleBooleanLongBoolean2Long(f: (dFun, bFun, lFun, bFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, BooleanFun), LongFun)
  def getSignatureDoubleBooleanDoubleInt2Long(f: (dFun, bFun, dFun, iFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, IntFun), LongFun)
  def getSignatureDoubleBooleanDoubleLong2Long(f: (dFun, bFun, dFun, lFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, LongFun), LongFun)
  def getSignatureDoubleBooleanDoubleDouble2Long(f: (dFun, bFun, dFun, dFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureDoubleBooleanDoubleString2Long(f: (dFun, bFun, dFun, sFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, StringFun), LongFun)
  def getSignatureDoubleBooleanDoubleBoolean2Long(f: (dFun, bFun, dFun, bFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureDoubleBooleanStringInt2Long(f: (dFun, bFun, sFun, iFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, IntFun), LongFun)
  def getSignatureDoubleBooleanStringLong2Long(f: (dFun, bFun, sFun, lFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, LongFun), LongFun)
  def getSignatureDoubleBooleanStringDouble2Long(f: (dFun, bFun, sFun, dFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, DoubleFun), LongFun)
  def getSignatureDoubleBooleanStringString2Long(f: (dFun, bFun, sFun, sFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, StringFun), LongFun)
  def getSignatureDoubleBooleanStringBoolean2Long(f: (dFun, bFun, sFun, bFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, BooleanFun), LongFun)
  def getSignatureDoubleBooleanBooleanInt2Long(f: (dFun, bFun, bFun, iFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, IntFun), LongFun)
  def getSignatureDoubleBooleanBooleanLong2Long(f: (dFun, bFun, bFun, lFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, LongFun), LongFun)
  def getSignatureDoubleBooleanBooleanDouble2Long(f: (dFun, bFun, bFun, dFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureDoubleBooleanBooleanString2Long(f: (dFun, bFun, bFun, sFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, StringFun), LongFun)
  def getSignatureDoubleBooleanBooleanBoolean2Long(f: (dFun, bFun, bFun, bFun) => lFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureStringIntIntInt2Long(f: (sFun, iFun, iFun, iFun) => lFun): String = getSignature(List(StringFun, IntFun, IntFun, IntFun), LongFun)
  def getSignatureStringIntIntLong2Long(f: (sFun, iFun, iFun, lFun) => lFun): String = getSignature(List(StringFun, IntFun, IntFun, LongFun), LongFun)
  def getSignatureStringIntIntDouble2Long(f: (sFun, iFun, iFun, dFun) => lFun): String = getSignature(List(StringFun, IntFun, IntFun, DoubleFun), LongFun)
  def getSignatureStringIntIntString2Long(f: (sFun, iFun, iFun, sFun) => lFun): String = getSignature(List(StringFun, IntFun, IntFun, StringFun), LongFun)
  def getSignatureStringIntIntBoolean2Long(f: (sFun, iFun, iFun, bFun) => lFun): String = getSignature(List(StringFun, IntFun, IntFun, BooleanFun), LongFun)
  def getSignatureStringIntLongInt2Long(f: (sFun, iFun, lFun, iFun) => lFun): String = getSignature(List(StringFun, IntFun, LongFun, IntFun), LongFun)
  def getSignatureStringIntLongLong2Long(f: (sFun, iFun, lFun, lFun) => lFun): String = getSignature(List(StringFun, IntFun, LongFun, LongFun), LongFun)
  def getSignatureStringIntLongDouble2Long(f: (sFun, iFun, lFun, dFun) => lFun): String = getSignature(List(StringFun, IntFun, LongFun, DoubleFun), LongFun)
  def getSignatureStringIntLongString2Long(f: (sFun, iFun, lFun, sFun) => lFun): String = getSignature(List(StringFun, IntFun, LongFun, StringFun), LongFun)
  def getSignatureStringIntLongBoolean2Long(f: (sFun, iFun, lFun, bFun) => lFun): String = getSignature(List(StringFun, IntFun, LongFun, BooleanFun), LongFun)
  def getSignatureStringIntDoubleInt2Long(f: (sFun, iFun, dFun, iFun) => lFun): String = getSignature(List(StringFun, IntFun, DoubleFun, IntFun), LongFun)
  def getSignatureStringIntDoubleLong2Long(f: (sFun, iFun, dFun, lFun) => lFun): String = getSignature(List(StringFun, IntFun, DoubleFun, LongFun), LongFun)
  def getSignatureStringIntDoubleDouble2Long(f: (sFun, iFun, dFun, dFun) => lFun): String = getSignature(List(StringFun, IntFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureStringIntDoubleString2Long(f: (sFun, iFun, dFun, sFun) => lFun): String = getSignature(List(StringFun, IntFun, DoubleFun, StringFun), LongFun)
  def getSignatureStringIntDoubleBoolean2Long(f: (sFun, iFun, dFun, bFun) => lFun): String = getSignature(List(StringFun, IntFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureStringIntStringInt2Long(f: (sFun, iFun, sFun, iFun) => lFun): String = getSignature(List(StringFun, IntFun, StringFun, IntFun), LongFun)
  def getSignatureStringIntStringLong2Long(f: (sFun, iFun, sFun, lFun) => lFun): String = getSignature(List(StringFun, IntFun, StringFun, LongFun), LongFun)
  def getSignatureStringIntStringDouble2Long(f: (sFun, iFun, sFun, dFun) => lFun): String = getSignature(List(StringFun, IntFun, StringFun, DoubleFun), LongFun)
  def getSignatureStringIntStringString2Long(f: (sFun, iFun, sFun, sFun) => lFun): String = getSignature(List(StringFun, IntFun, StringFun, StringFun), LongFun)
  def getSignatureStringIntStringBoolean2Long(f: (sFun, iFun, sFun, bFun) => lFun): String = getSignature(List(StringFun, IntFun, StringFun, BooleanFun), LongFun)
  def getSignatureStringIntBooleanInt2Long(f: (sFun, iFun, bFun, iFun) => lFun): String = getSignature(List(StringFun, IntFun, BooleanFun, IntFun), LongFun)
  def getSignatureStringIntBooleanLong2Long(f: (sFun, iFun, bFun, lFun) => lFun): String = getSignature(List(StringFun, IntFun, BooleanFun, LongFun), LongFun)
  def getSignatureStringIntBooleanDouble2Long(f: (sFun, iFun, bFun, dFun) => lFun): String = getSignature(List(StringFun, IntFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureStringIntBooleanString2Long(f: (sFun, iFun, bFun, sFun) => lFun): String = getSignature(List(StringFun, IntFun, BooleanFun, StringFun), LongFun)
  def getSignatureStringIntBooleanBoolean2Long(f: (sFun, iFun, bFun, bFun) => lFun): String = getSignature(List(StringFun, IntFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureStringLongIntInt2Long(f: (sFun, lFun, iFun, iFun) => lFun): String = getSignature(List(StringFun, LongFun, IntFun, IntFun), LongFun)
  def getSignatureStringLongIntLong2Long(f: (sFun, lFun, iFun, lFun) => lFun): String = getSignature(List(StringFun, LongFun, IntFun, LongFun), LongFun)
  def getSignatureStringLongIntDouble2Long(f: (sFun, lFun, iFun, dFun) => lFun): String = getSignature(List(StringFun, LongFun, IntFun, DoubleFun), LongFun)
  def getSignatureStringLongIntString2Long(f: (sFun, lFun, iFun, sFun) => lFun): String = getSignature(List(StringFun, LongFun, IntFun, StringFun), LongFun)
  def getSignatureStringLongIntBoolean2Long(f: (sFun, lFun, iFun, bFun) => lFun): String = getSignature(List(StringFun, LongFun, IntFun, BooleanFun), LongFun)
  def getSignatureStringLongLongInt2Long(f: (sFun, lFun, lFun, iFun) => lFun): String = getSignature(List(StringFun, LongFun, LongFun, IntFun), LongFun)
  def getSignatureStringLongLongLong2Long(f: (sFun, lFun, lFun, lFun) => lFun): String = getSignature(List(StringFun, LongFun, LongFun, LongFun), LongFun)
  def getSignatureStringLongLongDouble2Long(f: (sFun, lFun, lFun, dFun) => lFun): String = getSignature(List(StringFun, LongFun, LongFun, DoubleFun), LongFun)
  def getSignatureStringLongLongString2Long(f: (sFun, lFun, lFun, sFun) => lFun): String = getSignature(List(StringFun, LongFun, LongFun, StringFun), LongFun)
  def getSignatureStringLongLongBoolean2Long(f: (sFun, lFun, lFun, bFun) => lFun): String = getSignature(List(StringFun, LongFun, LongFun, BooleanFun), LongFun)
  def getSignatureStringLongDoubleInt2Long(f: (sFun, lFun, dFun, iFun) => lFun): String = getSignature(List(StringFun, LongFun, DoubleFun, IntFun), LongFun)
  def getSignatureStringLongDoubleLong2Long(f: (sFun, lFun, dFun, lFun) => lFun): String = getSignature(List(StringFun, LongFun, DoubleFun, LongFun), LongFun)
  def getSignatureStringLongDoubleDouble2Long(f: (sFun, lFun, dFun, dFun) => lFun): String = getSignature(List(StringFun, LongFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureStringLongDoubleString2Long(f: (sFun, lFun, dFun, sFun) => lFun): String = getSignature(List(StringFun, LongFun, DoubleFun, StringFun), LongFun)
  def getSignatureStringLongDoubleBoolean2Long(f: (sFun, lFun, dFun, bFun) => lFun): String = getSignature(List(StringFun, LongFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureStringLongStringInt2Long(f: (sFun, lFun, sFun, iFun) => lFun): String = getSignature(List(StringFun, LongFun, StringFun, IntFun), LongFun)
  def getSignatureStringLongStringLong2Long(f: (sFun, lFun, sFun, lFun) => lFun): String = getSignature(List(StringFun, LongFun, StringFun, LongFun), LongFun)
  def getSignatureStringLongStringDouble2Long(f: (sFun, lFun, sFun, dFun) => lFun): String = getSignature(List(StringFun, LongFun, StringFun, DoubleFun), LongFun)
  def getSignatureStringLongStringString2Long(f: (sFun, lFun, sFun, sFun) => lFun): String = getSignature(List(StringFun, LongFun, StringFun, StringFun), LongFun)
  def getSignatureStringLongStringBoolean2Long(f: (sFun, lFun, sFun, bFun) => lFun): String = getSignature(List(StringFun, LongFun, StringFun, BooleanFun), LongFun)
  def getSignatureStringLongBooleanInt2Long(f: (sFun, lFun, bFun, iFun) => lFun): String = getSignature(List(StringFun, LongFun, BooleanFun, IntFun), LongFun)
  def getSignatureStringLongBooleanLong2Long(f: (sFun, lFun, bFun, lFun) => lFun): String = getSignature(List(StringFun, LongFun, BooleanFun, LongFun), LongFun)
  def getSignatureStringLongBooleanDouble2Long(f: (sFun, lFun, bFun, dFun) => lFun): String = getSignature(List(StringFun, LongFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureStringLongBooleanString2Long(f: (sFun, lFun, bFun, sFun) => lFun): String = getSignature(List(StringFun, LongFun, BooleanFun, StringFun), LongFun)
  def getSignatureStringLongBooleanBoolean2Long(f: (sFun, lFun, bFun, bFun) => lFun): String = getSignature(List(StringFun, LongFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureStringDoubleIntInt2Long(f: (sFun, dFun, iFun, iFun) => lFun): String = getSignature(List(StringFun, DoubleFun, IntFun, IntFun), LongFun)
  def getSignatureStringDoubleIntLong2Long(f: (sFun, dFun, iFun, lFun) => lFun): String = getSignature(List(StringFun, DoubleFun, IntFun, LongFun), LongFun)
  def getSignatureStringDoubleIntDouble2Long(f: (sFun, dFun, iFun, dFun) => lFun): String = getSignature(List(StringFun, DoubleFun, IntFun, DoubleFun), LongFun)
  def getSignatureStringDoubleIntString2Long(f: (sFun, dFun, iFun, sFun) => lFun): String = getSignature(List(StringFun, DoubleFun, IntFun, StringFun), LongFun)
  def getSignatureStringDoubleIntBoolean2Long(f: (sFun, dFun, iFun, bFun) => lFun): String = getSignature(List(StringFun, DoubleFun, IntFun, BooleanFun), LongFun)
  def getSignatureStringDoubleLongInt2Long(f: (sFun, dFun, lFun, iFun) => lFun): String = getSignature(List(StringFun, DoubleFun, LongFun, IntFun), LongFun)
  def getSignatureStringDoubleLongLong2Long(f: (sFun, dFun, lFun, lFun) => lFun): String = getSignature(List(StringFun, DoubleFun, LongFun, LongFun), LongFun)
  def getSignatureStringDoubleLongDouble2Long(f: (sFun, dFun, lFun, dFun) => lFun): String = getSignature(List(StringFun, DoubleFun, LongFun, DoubleFun), LongFun)
  def getSignatureStringDoubleLongString2Long(f: (sFun, dFun, lFun, sFun) => lFun): String = getSignature(List(StringFun, DoubleFun, LongFun, StringFun), LongFun)
  def getSignatureStringDoubleLongBoolean2Long(f: (sFun, dFun, lFun, bFun) => lFun): String = getSignature(List(StringFun, DoubleFun, LongFun, BooleanFun), LongFun)
  def getSignatureStringDoubleDoubleInt2Long(f: (sFun, dFun, dFun, iFun) => lFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, IntFun), LongFun)
  def getSignatureStringDoubleDoubleLong2Long(f: (sFun, dFun, dFun, lFun) => lFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, LongFun), LongFun)
  def getSignatureStringDoubleDoubleDouble2Long(f: (sFun, dFun, dFun, dFun) => lFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureStringDoubleDoubleString2Long(f: (sFun, dFun, dFun, sFun) => lFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, StringFun), LongFun)
  def getSignatureStringDoubleDoubleBoolean2Long(f: (sFun, dFun, dFun, bFun) => lFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureStringDoubleStringInt2Long(f: (sFun, dFun, sFun, iFun) => lFun): String = getSignature(List(StringFun, DoubleFun, StringFun, IntFun), LongFun)
  def getSignatureStringDoubleStringLong2Long(f: (sFun, dFun, sFun, lFun) => lFun): String = getSignature(List(StringFun, DoubleFun, StringFun, LongFun), LongFun)
  def getSignatureStringDoubleStringDouble2Long(f: (sFun, dFun, sFun, dFun) => lFun): String = getSignature(List(StringFun, DoubleFun, StringFun, DoubleFun), LongFun)
  def getSignatureStringDoubleStringString2Long(f: (sFun, dFun, sFun, sFun) => lFun): String = getSignature(List(StringFun, DoubleFun, StringFun, StringFun), LongFun)
  def getSignatureStringDoubleStringBoolean2Long(f: (sFun, dFun, sFun, bFun) => lFun): String = getSignature(List(StringFun, DoubleFun, StringFun, BooleanFun), LongFun)
  def getSignatureStringDoubleBooleanInt2Long(f: (sFun, dFun, bFun, iFun) => lFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, IntFun), LongFun)
  def getSignatureStringDoubleBooleanLong2Long(f: (sFun, dFun, bFun, lFun) => lFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, LongFun), LongFun)
  def getSignatureStringDoubleBooleanDouble2Long(f: (sFun, dFun, bFun, dFun) => lFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureStringDoubleBooleanString2Long(f: (sFun, dFun, bFun, sFun) => lFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, StringFun), LongFun)
  def getSignatureStringDoubleBooleanBoolean2Long(f: (sFun, dFun, bFun, bFun) => lFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureStringStringIntInt2Long(f: (sFun, sFun, iFun, iFun) => lFun): String = getSignature(List(StringFun, StringFun, IntFun, IntFun), LongFun)
  def getSignatureStringStringIntLong2Long(f: (sFun, sFun, iFun, lFun) => lFun): String = getSignature(List(StringFun, StringFun, IntFun, LongFun), LongFun)
  def getSignatureStringStringIntDouble2Long(f: (sFun, sFun, iFun, dFun) => lFun): String = getSignature(List(StringFun, StringFun, IntFun, DoubleFun), LongFun)
  def getSignatureStringStringIntString2Long(f: (sFun, sFun, iFun, sFun) => lFun): String = getSignature(List(StringFun, StringFun, IntFun, StringFun), LongFun)
  def getSignatureStringStringIntBoolean2Long(f: (sFun, sFun, iFun, bFun) => lFun): String = getSignature(List(StringFun, StringFun, IntFun, BooleanFun), LongFun)
  def getSignatureStringStringLongInt2Long(f: (sFun, sFun, lFun, iFun) => lFun): String = getSignature(List(StringFun, StringFun, LongFun, IntFun), LongFun)
  def getSignatureStringStringLongLong2Long(f: (sFun, sFun, lFun, lFun) => lFun): String = getSignature(List(StringFun, StringFun, LongFun, LongFun), LongFun)
  def getSignatureStringStringLongDouble2Long(f: (sFun, sFun, lFun, dFun) => lFun): String = getSignature(List(StringFun, StringFun, LongFun, DoubleFun), LongFun)
  def getSignatureStringStringLongString2Long(f: (sFun, sFun, lFun, sFun) => lFun): String = getSignature(List(StringFun, StringFun, LongFun, StringFun), LongFun)
  def getSignatureStringStringLongBoolean2Long(f: (sFun, sFun, lFun, bFun) => lFun): String = getSignature(List(StringFun, StringFun, LongFun, BooleanFun), LongFun)
  def getSignatureStringStringDoubleInt2Long(f: (sFun, sFun, dFun, iFun) => lFun): String = getSignature(List(StringFun, StringFun, DoubleFun, IntFun), LongFun)
  def getSignatureStringStringDoubleLong2Long(f: (sFun, sFun, dFun, lFun) => lFun): String = getSignature(List(StringFun, StringFun, DoubleFun, LongFun), LongFun)
  def getSignatureStringStringDoubleDouble2Long(f: (sFun, sFun, dFun, dFun) => lFun): String = getSignature(List(StringFun, StringFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureStringStringDoubleString2Long(f: (sFun, sFun, dFun, sFun) => lFun): String = getSignature(List(StringFun, StringFun, DoubleFun, StringFun), LongFun)
  def getSignatureStringStringDoubleBoolean2Long(f: (sFun, sFun, dFun, bFun) => lFun): String = getSignature(List(StringFun, StringFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureStringStringStringInt2Long(f: (sFun, sFun, sFun, iFun) => lFun): String = getSignature(List(StringFun, StringFun, StringFun, IntFun), LongFun)
  def getSignatureStringStringStringLong2Long(f: (sFun, sFun, sFun, lFun) => lFun): String = getSignature(List(StringFun, StringFun, StringFun, LongFun), LongFun)
  def getSignatureStringStringStringDouble2Long(f: (sFun, sFun, sFun, dFun) => lFun): String = getSignature(List(StringFun, StringFun, StringFun, DoubleFun), LongFun)
  def getSignatureStringStringStringString2Long(f: (sFun, sFun, sFun, sFun) => lFun): String = getSignature(List(StringFun, StringFun, StringFun, StringFun), LongFun)
  def getSignatureStringStringStringBoolean2Long(f: (sFun, sFun, sFun, bFun) => lFun): String = getSignature(List(StringFun, StringFun, StringFun, BooleanFun), LongFun)
  def getSignatureStringStringBooleanInt2Long(f: (sFun, sFun, bFun, iFun) => lFun): String = getSignature(List(StringFun, StringFun, BooleanFun, IntFun), LongFun)
  def getSignatureStringStringBooleanLong2Long(f: (sFun, sFun, bFun, lFun) => lFun): String = getSignature(List(StringFun, StringFun, BooleanFun, LongFun), LongFun)
  def getSignatureStringStringBooleanDouble2Long(f: (sFun, sFun, bFun, dFun) => lFun): String = getSignature(List(StringFun, StringFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureStringStringBooleanString2Long(f: (sFun, sFun, bFun, sFun) => lFun): String = getSignature(List(StringFun, StringFun, BooleanFun, StringFun), LongFun)
  def getSignatureStringStringBooleanBoolean2Long(f: (sFun, sFun, bFun, bFun) => lFun): String = getSignature(List(StringFun, StringFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureStringBooleanIntInt2Long(f: (sFun, bFun, iFun, iFun) => lFun): String = getSignature(List(StringFun, BooleanFun, IntFun, IntFun), LongFun)
  def getSignatureStringBooleanIntLong2Long(f: (sFun, bFun, iFun, lFun) => lFun): String = getSignature(List(StringFun, BooleanFun, IntFun, LongFun), LongFun)
  def getSignatureStringBooleanIntDouble2Long(f: (sFun, bFun, iFun, dFun) => lFun): String = getSignature(List(StringFun, BooleanFun, IntFun, DoubleFun), LongFun)
  def getSignatureStringBooleanIntString2Long(f: (sFun, bFun, iFun, sFun) => lFun): String = getSignature(List(StringFun, BooleanFun, IntFun, StringFun), LongFun)
  def getSignatureStringBooleanIntBoolean2Long(f: (sFun, bFun, iFun, bFun) => lFun): String = getSignature(List(StringFun, BooleanFun, IntFun, BooleanFun), LongFun)
  def getSignatureStringBooleanLongInt2Long(f: (sFun, bFun, lFun, iFun) => lFun): String = getSignature(List(StringFun, BooleanFun, LongFun, IntFun), LongFun)
  def getSignatureStringBooleanLongLong2Long(f: (sFun, bFun, lFun, lFun) => lFun): String = getSignature(List(StringFun, BooleanFun, LongFun, LongFun), LongFun)
  def getSignatureStringBooleanLongDouble2Long(f: (sFun, bFun, lFun, dFun) => lFun): String = getSignature(List(StringFun, BooleanFun, LongFun, DoubleFun), LongFun)
  def getSignatureStringBooleanLongString2Long(f: (sFun, bFun, lFun, sFun) => lFun): String = getSignature(List(StringFun, BooleanFun, LongFun, StringFun), LongFun)
  def getSignatureStringBooleanLongBoolean2Long(f: (sFun, bFun, lFun, bFun) => lFun): String = getSignature(List(StringFun, BooleanFun, LongFun, BooleanFun), LongFun)
  def getSignatureStringBooleanDoubleInt2Long(f: (sFun, bFun, dFun, iFun) => lFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, IntFun), LongFun)
  def getSignatureStringBooleanDoubleLong2Long(f: (sFun, bFun, dFun, lFun) => lFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, LongFun), LongFun)
  def getSignatureStringBooleanDoubleDouble2Long(f: (sFun, bFun, dFun, dFun) => lFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureStringBooleanDoubleString2Long(f: (sFun, bFun, dFun, sFun) => lFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, StringFun), LongFun)
  def getSignatureStringBooleanDoubleBoolean2Long(f: (sFun, bFun, dFun, bFun) => lFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureStringBooleanStringInt2Long(f: (sFun, bFun, sFun, iFun) => lFun): String = getSignature(List(StringFun, BooleanFun, StringFun, IntFun), LongFun)
  def getSignatureStringBooleanStringLong2Long(f: (sFun, bFun, sFun, lFun) => lFun): String = getSignature(List(StringFun, BooleanFun, StringFun, LongFun), LongFun)
  def getSignatureStringBooleanStringDouble2Long(f: (sFun, bFun, sFun, dFun) => lFun): String = getSignature(List(StringFun, BooleanFun, StringFun, DoubleFun), LongFun)
  def getSignatureStringBooleanStringString2Long(f: (sFun, bFun, sFun, sFun) => lFun): String = getSignature(List(StringFun, BooleanFun, StringFun, StringFun), LongFun)
  def getSignatureStringBooleanStringBoolean2Long(f: (sFun, bFun, sFun, bFun) => lFun): String = getSignature(List(StringFun, BooleanFun, StringFun, BooleanFun), LongFun)
  def getSignatureStringBooleanBooleanInt2Long(f: (sFun, bFun, bFun, iFun) => lFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, IntFun), LongFun)
  def getSignatureStringBooleanBooleanLong2Long(f: (sFun, bFun, bFun, lFun) => lFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, LongFun), LongFun)
  def getSignatureStringBooleanBooleanDouble2Long(f: (sFun, bFun, bFun, dFun) => lFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureStringBooleanBooleanString2Long(f: (sFun, bFun, bFun, sFun) => lFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, StringFun), LongFun)
  def getSignatureStringBooleanBooleanBoolean2Long(f: (sFun, bFun, bFun, bFun) => lFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureBooleanIntIntInt2Long(f: (bFun, iFun, iFun, iFun) => lFun): String = getSignature(List(BooleanFun, IntFun, IntFun, IntFun), LongFun)
  def getSignatureBooleanIntIntLong2Long(f: (bFun, iFun, iFun, lFun) => lFun): String = getSignature(List(BooleanFun, IntFun, IntFun, LongFun), LongFun)
  def getSignatureBooleanIntIntDouble2Long(f: (bFun, iFun, iFun, dFun) => lFun): String = getSignature(List(BooleanFun, IntFun, IntFun, DoubleFun), LongFun)
  def getSignatureBooleanIntIntString2Long(f: (bFun, iFun, iFun, sFun) => lFun): String = getSignature(List(BooleanFun, IntFun, IntFun, StringFun), LongFun)
  def getSignatureBooleanIntIntBoolean2Long(f: (bFun, iFun, iFun, bFun) => lFun): String = getSignature(List(BooleanFun, IntFun, IntFun, BooleanFun), LongFun)
  def getSignatureBooleanIntLongInt2Long(f: (bFun, iFun, lFun, iFun) => lFun): String = getSignature(List(BooleanFun, IntFun, LongFun, IntFun), LongFun)
  def getSignatureBooleanIntLongLong2Long(f: (bFun, iFun, lFun, lFun) => lFun): String = getSignature(List(BooleanFun, IntFun, LongFun, LongFun), LongFun)
  def getSignatureBooleanIntLongDouble2Long(f: (bFun, iFun, lFun, dFun) => lFun): String = getSignature(List(BooleanFun, IntFun, LongFun, DoubleFun), LongFun)
  def getSignatureBooleanIntLongString2Long(f: (bFun, iFun, lFun, sFun) => lFun): String = getSignature(List(BooleanFun, IntFun, LongFun, StringFun), LongFun)
  def getSignatureBooleanIntLongBoolean2Long(f: (bFun, iFun, lFun, bFun) => lFun): String = getSignature(List(BooleanFun, IntFun, LongFun, BooleanFun), LongFun)
  def getSignatureBooleanIntDoubleInt2Long(f: (bFun, iFun, dFun, iFun) => lFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, IntFun), LongFun)
  def getSignatureBooleanIntDoubleLong2Long(f: (bFun, iFun, dFun, lFun) => lFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, LongFun), LongFun)
  def getSignatureBooleanIntDoubleDouble2Long(f: (bFun, iFun, dFun, dFun) => lFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureBooleanIntDoubleString2Long(f: (bFun, iFun, dFun, sFun) => lFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, StringFun), LongFun)
  def getSignatureBooleanIntDoubleBoolean2Long(f: (bFun, iFun, dFun, bFun) => lFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureBooleanIntStringInt2Long(f: (bFun, iFun, sFun, iFun) => lFun): String = getSignature(List(BooleanFun, IntFun, StringFun, IntFun), LongFun)
  def getSignatureBooleanIntStringLong2Long(f: (bFun, iFun, sFun, lFun) => lFun): String = getSignature(List(BooleanFun, IntFun, StringFun, LongFun), LongFun)
  def getSignatureBooleanIntStringDouble2Long(f: (bFun, iFun, sFun, dFun) => lFun): String = getSignature(List(BooleanFun, IntFun, StringFun, DoubleFun), LongFun)
  def getSignatureBooleanIntStringString2Long(f: (bFun, iFun, sFun, sFun) => lFun): String = getSignature(List(BooleanFun, IntFun, StringFun, StringFun), LongFun)
  def getSignatureBooleanIntStringBoolean2Long(f: (bFun, iFun, sFun, bFun) => lFun): String = getSignature(List(BooleanFun, IntFun, StringFun, BooleanFun), LongFun)
  def getSignatureBooleanIntBooleanInt2Long(f: (bFun, iFun, bFun, iFun) => lFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, IntFun), LongFun)
  def getSignatureBooleanIntBooleanLong2Long(f: (bFun, iFun, bFun, lFun) => lFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, LongFun), LongFun)
  def getSignatureBooleanIntBooleanDouble2Long(f: (bFun, iFun, bFun, dFun) => lFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureBooleanIntBooleanString2Long(f: (bFun, iFun, bFun, sFun) => lFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, StringFun), LongFun)
  def getSignatureBooleanIntBooleanBoolean2Long(f: (bFun, iFun, bFun, bFun) => lFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureBooleanLongIntInt2Long(f: (bFun, lFun, iFun, iFun) => lFun): String = getSignature(List(BooleanFun, LongFun, IntFun, IntFun), LongFun)
  def getSignatureBooleanLongIntLong2Long(f: (bFun, lFun, iFun, lFun) => lFun): String = getSignature(List(BooleanFun, LongFun, IntFun, LongFun), LongFun)
  def getSignatureBooleanLongIntDouble2Long(f: (bFun, lFun, iFun, dFun) => lFun): String = getSignature(List(BooleanFun, LongFun, IntFun, DoubleFun), LongFun)
  def getSignatureBooleanLongIntString2Long(f: (bFun, lFun, iFun, sFun) => lFun): String = getSignature(List(BooleanFun, LongFun, IntFun, StringFun), LongFun)
  def getSignatureBooleanLongIntBoolean2Long(f: (bFun, lFun, iFun, bFun) => lFun): String = getSignature(List(BooleanFun, LongFun, IntFun, BooleanFun), LongFun)
  def getSignatureBooleanLongLongInt2Long(f: (bFun, lFun, lFun, iFun) => lFun): String = getSignature(List(BooleanFun, LongFun, LongFun, IntFun), LongFun)
  def getSignatureBooleanLongLongLong2Long(f: (bFun, lFun, lFun, lFun) => lFun): String = getSignature(List(BooleanFun, LongFun, LongFun, LongFun), LongFun)
  def getSignatureBooleanLongLongDouble2Long(f: (bFun, lFun, lFun, dFun) => lFun): String = getSignature(List(BooleanFun, LongFun, LongFun, DoubleFun), LongFun)
  def getSignatureBooleanLongLongString2Long(f: (bFun, lFun, lFun, sFun) => lFun): String = getSignature(List(BooleanFun, LongFun, LongFun, StringFun), LongFun)
  def getSignatureBooleanLongLongBoolean2Long(f: (bFun, lFun, lFun, bFun) => lFun): String = getSignature(List(BooleanFun, LongFun, LongFun, BooleanFun), LongFun)
  def getSignatureBooleanLongDoubleInt2Long(f: (bFun, lFun, dFun, iFun) => lFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, IntFun), LongFun)
  def getSignatureBooleanLongDoubleLong2Long(f: (bFun, lFun, dFun, lFun) => lFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, LongFun), LongFun)
  def getSignatureBooleanLongDoubleDouble2Long(f: (bFun, lFun, dFun, dFun) => lFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureBooleanLongDoubleString2Long(f: (bFun, lFun, dFun, sFun) => lFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, StringFun), LongFun)
  def getSignatureBooleanLongDoubleBoolean2Long(f: (bFun, lFun, dFun, bFun) => lFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureBooleanLongStringInt2Long(f: (bFun, lFun, sFun, iFun) => lFun): String = getSignature(List(BooleanFun, LongFun, StringFun, IntFun), LongFun)
  def getSignatureBooleanLongStringLong2Long(f: (bFun, lFun, sFun, lFun) => lFun): String = getSignature(List(BooleanFun, LongFun, StringFun, LongFun), LongFun)
  def getSignatureBooleanLongStringDouble2Long(f: (bFun, lFun, sFun, dFun) => lFun): String = getSignature(List(BooleanFun, LongFun, StringFun, DoubleFun), LongFun)
  def getSignatureBooleanLongStringString2Long(f: (bFun, lFun, sFun, sFun) => lFun): String = getSignature(List(BooleanFun, LongFun, StringFun, StringFun), LongFun)
  def getSignatureBooleanLongStringBoolean2Long(f: (bFun, lFun, sFun, bFun) => lFun): String = getSignature(List(BooleanFun, LongFun, StringFun, BooleanFun), LongFun)
  def getSignatureBooleanLongBooleanInt2Long(f: (bFun, lFun, bFun, iFun) => lFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, IntFun), LongFun)
  def getSignatureBooleanLongBooleanLong2Long(f: (bFun, lFun, bFun, lFun) => lFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, LongFun), LongFun)
  def getSignatureBooleanLongBooleanDouble2Long(f: (bFun, lFun, bFun, dFun) => lFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureBooleanLongBooleanString2Long(f: (bFun, lFun, bFun, sFun) => lFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, StringFun), LongFun)
  def getSignatureBooleanLongBooleanBoolean2Long(f: (bFun, lFun, bFun, bFun) => lFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureBooleanDoubleIntInt2Long(f: (bFun, dFun, iFun, iFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, IntFun), LongFun)
  def getSignatureBooleanDoubleIntLong2Long(f: (bFun, dFun, iFun, lFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, LongFun), LongFun)
  def getSignatureBooleanDoubleIntDouble2Long(f: (bFun, dFun, iFun, dFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, DoubleFun), LongFun)
  def getSignatureBooleanDoubleIntString2Long(f: (bFun, dFun, iFun, sFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, StringFun), LongFun)
  def getSignatureBooleanDoubleIntBoolean2Long(f: (bFun, dFun, iFun, bFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, BooleanFun), LongFun)
  def getSignatureBooleanDoubleLongInt2Long(f: (bFun, dFun, lFun, iFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, IntFun), LongFun)
  def getSignatureBooleanDoubleLongLong2Long(f: (bFun, dFun, lFun, lFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, LongFun), LongFun)
  def getSignatureBooleanDoubleLongDouble2Long(f: (bFun, dFun, lFun, dFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, DoubleFun), LongFun)
  def getSignatureBooleanDoubleLongString2Long(f: (bFun, dFun, lFun, sFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, StringFun), LongFun)
  def getSignatureBooleanDoubleLongBoolean2Long(f: (bFun, dFun, lFun, bFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, BooleanFun), LongFun)
  def getSignatureBooleanDoubleDoubleInt2Long(f: (bFun, dFun, dFun, iFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, IntFun), LongFun)
  def getSignatureBooleanDoubleDoubleLong2Long(f: (bFun, dFun, dFun, lFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, LongFun), LongFun)
  def getSignatureBooleanDoubleDoubleDouble2Long(f: (bFun, dFun, dFun, dFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureBooleanDoubleDoubleString2Long(f: (bFun, dFun, dFun, sFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, StringFun), LongFun)
  def getSignatureBooleanDoubleDoubleBoolean2Long(f: (bFun, dFun, dFun, bFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureBooleanDoubleStringInt2Long(f: (bFun, dFun, sFun, iFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, IntFun), LongFun)
  def getSignatureBooleanDoubleStringLong2Long(f: (bFun, dFun, sFun, lFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, LongFun), LongFun)
  def getSignatureBooleanDoubleStringDouble2Long(f: (bFun, dFun, sFun, dFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, DoubleFun), LongFun)
  def getSignatureBooleanDoubleStringString2Long(f: (bFun, dFun, sFun, sFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, StringFun), LongFun)
  def getSignatureBooleanDoubleStringBoolean2Long(f: (bFun, dFun, sFun, bFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, BooleanFun), LongFun)
  def getSignatureBooleanDoubleBooleanInt2Long(f: (bFun, dFun, bFun, iFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, IntFun), LongFun)
  def getSignatureBooleanDoubleBooleanLong2Long(f: (bFun, dFun, bFun, lFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, LongFun), LongFun)
  def getSignatureBooleanDoubleBooleanDouble2Long(f: (bFun, dFun, bFun, dFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureBooleanDoubleBooleanString2Long(f: (bFun, dFun, bFun, sFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, StringFun), LongFun)
  def getSignatureBooleanDoubleBooleanBoolean2Long(f: (bFun, dFun, bFun, bFun) => lFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureBooleanStringIntInt2Long(f: (bFun, sFun, iFun, iFun) => lFun): String = getSignature(List(BooleanFun, StringFun, IntFun, IntFun), LongFun)
  def getSignatureBooleanStringIntLong2Long(f: (bFun, sFun, iFun, lFun) => lFun): String = getSignature(List(BooleanFun, StringFun, IntFun, LongFun), LongFun)
  def getSignatureBooleanStringIntDouble2Long(f: (bFun, sFun, iFun, dFun) => lFun): String = getSignature(List(BooleanFun, StringFun, IntFun, DoubleFun), LongFun)
  def getSignatureBooleanStringIntString2Long(f: (bFun, sFun, iFun, sFun) => lFun): String = getSignature(List(BooleanFun, StringFun, IntFun, StringFun), LongFun)
  def getSignatureBooleanStringIntBoolean2Long(f: (bFun, sFun, iFun, bFun) => lFun): String = getSignature(List(BooleanFun, StringFun, IntFun, BooleanFun), LongFun)
  def getSignatureBooleanStringLongInt2Long(f: (bFun, sFun, lFun, iFun) => lFun): String = getSignature(List(BooleanFun, StringFun, LongFun, IntFun), LongFun)
  def getSignatureBooleanStringLongLong2Long(f: (bFun, sFun, lFun, lFun) => lFun): String = getSignature(List(BooleanFun, StringFun, LongFun, LongFun), LongFun)
  def getSignatureBooleanStringLongDouble2Long(f: (bFun, sFun, lFun, dFun) => lFun): String = getSignature(List(BooleanFun, StringFun, LongFun, DoubleFun), LongFun)
  def getSignatureBooleanStringLongString2Long(f: (bFun, sFun, lFun, sFun) => lFun): String = getSignature(List(BooleanFun, StringFun, LongFun, StringFun), LongFun)
  def getSignatureBooleanStringLongBoolean2Long(f: (bFun, sFun, lFun, bFun) => lFun): String = getSignature(List(BooleanFun, StringFun, LongFun, BooleanFun), LongFun)
  def getSignatureBooleanStringDoubleInt2Long(f: (bFun, sFun, dFun, iFun) => lFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, IntFun), LongFun)
  def getSignatureBooleanStringDoubleLong2Long(f: (bFun, sFun, dFun, lFun) => lFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, LongFun), LongFun)
  def getSignatureBooleanStringDoubleDouble2Long(f: (bFun, sFun, dFun, dFun) => lFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureBooleanStringDoubleString2Long(f: (bFun, sFun, dFun, sFun) => lFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, StringFun), LongFun)
  def getSignatureBooleanStringDoubleBoolean2Long(f: (bFun, sFun, dFun, bFun) => lFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureBooleanStringStringInt2Long(f: (bFun, sFun, sFun, iFun) => lFun): String = getSignature(List(BooleanFun, StringFun, StringFun, IntFun), LongFun)
  def getSignatureBooleanStringStringLong2Long(f: (bFun, sFun, sFun, lFun) => lFun): String = getSignature(List(BooleanFun, StringFun, StringFun, LongFun), LongFun)
  def getSignatureBooleanStringStringDouble2Long(f: (bFun, sFun, sFun, dFun) => lFun): String = getSignature(List(BooleanFun, StringFun, StringFun, DoubleFun), LongFun)
  def getSignatureBooleanStringStringString2Long(f: (bFun, sFun, sFun, sFun) => lFun): String = getSignature(List(BooleanFun, StringFun, StringFun, StringFun), LongFun)
  def getSignatureBooleanStringStringBoolean2Long(f: (bFun, sFun, sFun, bFun) => lFun): String = getSignature(List(BooleanFun, StringFun, StringFun, BooleanFun), LongFun)
  def getSignatureBooleanStringBooleanInt2Long(f: (bFun, sFun, bFun, iFun) => lFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, IntFun), LongFun)
  def getSignatureBooleanStringBooleanLong2Long(f: (bFun, sFun, bFun, lFun) => lFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, LongFun), LongFun)
  def getSignatureBooleanStringBooleanDouble2Long(f: (bFun, sFun, bFun, dFun) => lFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureBooleanStringBooleanString2Long(f: (bFun, sFun, bFun, sFun) => lFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, StringFun), LongFun)
  def getSignatureBooleanStringBooleanBoolean2Long(f: (bFun, sFun, bFun, bFun) => lFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureBooleanBooleanIntInt2Long(f: (bFun, bFun, iFun, iFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, IntFun), LongFun)
  def getSignatureBooleanBooleanIntLong2Long(f: (bFun, bFun, iFun, lFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, LongFun), LongFun)
  def getSignatureBooleanBooleanIntDouble2Long(f: (bFun, bFun, iFun, dFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, DoubleFun), LongFun)
  def getSignatureBooleanBooleanIntString2Long(f: (bFun, bFun, iFun, sFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, StringFun), LongFun)
  def getSignatureBooleanBooleanIntBoolean2Long(f: (bFun, bFun, iFun, bFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, BooleanFun), LongFun)
  def getSignatureBooleanBooleanLongInt2Long(f: (bFun, bFun, lFun, iFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, IntFun), LongFun)
  def getSignatureBooleanBooleanLongLong2Long(f: (bFun, bFun, lFun, lFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, LongFun), LongFun)
  def getSignatureBooleanBooleanLongDouble2Long(f: (bFun, bFun, lFun, dFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, DoubleFun), LongFun)
  def getSignatureBooleanBooleanLongString2Long(f: (bFun, bFun, lFun, sFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, StringFun), LongFun)
  def getSignatureBooleanBooleanLongBoolean2Long(f: (bFun, bFun, lFun, bFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, BooleanFun), LongFun)
  def getSignatureBooleanBooleanDoubleInt2Long(f: (bFun, bFun, dFun, iFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, IntFun), LongFun)
  def getSignatureBooleanBooleanDoubleLong2Long(f: (bFun, bFun, dFun, lFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, LongFun), LongFun)
  def getSignatureBooleanBooleanDoubleDouble2Long(f: (bFun, bFun, dFun, dFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, DoubleFun), LongFun)
  def getSignatureBooleanBooleanDoubleString2Long(f: (bFun, bFun, dFun, sFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, StringFun), LongFun)
  def getSignatureBooleanBooleanDoubleBoolean2Long(f: (bFun, bFun, dFun, bFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, BooleanFun), LongFun)
  def getSignatureBooleanBooleanStringInt2Long(f: (bFun, bFun, sFun, iFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, IntFun), LongFun)
  def getSignatureBooleanBooleanStringLong2Long(f: (bFun, bFun, sFun, lFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, LongFun), LongFun)
  def getSignatureBooleanBooleanStringDouble2Long(f: (bFun, bFun, sFun, dFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, DoubleFun), LongFun)
  def getSignatureBooleanBooleanStringString2Long(f: (bFun, bFun, sFun, sFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, StringFun), LongFun)
  def getSignatureBooleanBooleanStringBoolean2Long(f: (bFun, bFun, sFun, bFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, BooleanFun), LongFun)
  def getSignatureBooleanBooleanBooleanInt2Long(f: (bFun, bFun, bFun, iFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, IntFun), LongFun)
  def getSignatureBooleanBooleanBooleanLong2Long(f: (bFun, bFun, bFun, lFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, LongFun), LongFun)
  def getSignatureBooleanBooleanBooleanDouble2Long(f: (bFun, bFun, bFun, dFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, DoubleFun), LongFun)
  def getSignatureBooleanBooleanBooleanString2Long(f: (bFun, bFun, bFun, sFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, StringFun), LongFun)
  def getSignatureBooleanBooleanBooleanBoolean2Long(f: (bFun, bFun, bFun, bFun) => lFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, BooleanFun), LongFun)
  def getSignatureIntIntIntInt2Double(f: (iFun, iFun, iFun, iFun) => dFun): String = getSignature(List(IntFun, IntFun, IntFun, IntFun), DoubleFun)
  def getSignatureIntIntIntLong2Double(f: (iFun, iFun, iFun, lFun) => dFun): String = getSignature(List(IntFun, IntFun, IntFun, LongFun), DoubleFun)
  def getSignatureIntIntIntDouble2Double(f: (iFun, iFun, iFun, dFun) => dFun): String = getSignature(List(IntFun, IntFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureIntIntIntString2Double(f: (iFun, iFun, iFun, sFun) => dFun): String = getSignature(List(IntFun, IntFun, IntFun, StringFun), DoubleFun)
  def getSignatureIntIntIntBoolean2Double(f: (iFun, iFun, iFun, bFun) => dFun): String = getSignature(List(IntFun, IntFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureIntIntLongInt2Double(f: (iFun, iFun, lFun, iFun) => dFun): String = getSignature(List(IntFun, IntFun, LongFun, IntFun), DoubleFun)
  def getSignatureIntIntLongLong2Double(f: (iFun, iFun, lFun, lFun) => dFun): String = getSignature(List(IntFun, IntFun, LongFun, LongFun), DoubleFun)
  def getSignatureIntIntLongDouble2Double(f: (iFun, iFun, lFun, dFun) => dFun): String = getSignature(List(IntFun, IntFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureIntIntLongString2Double(f: (iFun, iFun, lFun, sFun) => dFun): String = getSignature(List(IntFun, IntFun, LongFun, StringFun), DoubleFun)
  def getSignatureIntIntLongBoolean2Double(f: (iFun, iFun, lFun, bFun) => dFun): String = getSignature(List(IntFun, IntFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureIntIntDoubleInt2Double(f: (iFun, iFun, dFun, iFun) => dFun): String = getSignature(List(IntFun, IntFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureIntIntDoubleLong2Double(f: (iFun, iFun, dFun, lFun) => dFun): String = getSignature(List(IntFun, IntFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureIntIntDoubleDouble2Double(f: (iFun, iFun, dFun, dFun) => dFun): String = getSignature(List(IntFun, IntFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureIntIntDoubleString2Double(f: (iFun, iFun, dFun, sFun) => dFun): String = getSignature(List(IntFun, IntFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureIntIntDoubleBoolean2Double(f: (iFun, iFun, dFun, bFun) => dFun): String = getSignature(List(IntFun, IntFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureIntIntStringInt2Double(f: (iFun, iFun, sFun, iFun) => dFun): String = getSignature(List(IntFun, IntFun, StringFun, IntFun), DoubleFun)
  def getSignatureIntIntStringLong2Double(f: (iFun, iFun, sFun, lFun) => dFun): String = getSignature(List(IntFun, IntFun, StringFun, LongFun), DoubleFun)
  def getSignatureIntIntStringDouble2Double(f: (iFun, iFun, sFun, dFun) => dFun): String = getSignature(List(IntFun, IntFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureIntIntStringString2Double(f: (iFun, iFun, sFun, sFun) => dFun): String = getSignature(List(IntFun, IntFun, StringFun, StringFun), DoubleFun)
  def getSignatureIntIntStringBoolean2Double(f: (iFun, iFun, sFun, bFun) => dFun): String = getSignature(List(IntFun, IntFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureIntIntBooleanInt2Double(f: (iFun, iFun, bFun, iFun) => dFun): String = getSignature(List(IntFun, IntFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureIntIntBooleanLong2Double(f: (iFun, iFun, bFun, lFun) => dFun): String = getSignature(List(IntFun, IntFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureIntIntBooleanDouble2Double(f: (iFun, iFun, bFun, dFun) => dFun): String = getSignature(List(IntFun, IntFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureIntIntBooleanString2Double(f: (iFun, iFun, bFun, sFun) => dFun): String = getSignature(List(IntFun, IntFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureIntIntBooleanBoolean2Double(f: (iFun, iFun, bFun, bFun) => dFun): String = getSignature(List(IntFun, IntFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureIntLongIntInt2Double(f: (iFun, lFun, iFun, iFun) => dFun): String = getSignature(List(IntFun, LongFun, IntFun, IntFun), DoubleFun)
  def getSignatureIntLongIntLong2Double(f: (iFun, lFun, iFun, lFun) => dFun): String = getSignature(List(IntFun, LongFun, IntFun, LongFun), DoubleFun)
  def getSignatureIntLongIntDouble2Double(f: (iFun, lFun, iFun, dFun) => dFun): String = getSignature(List(IntFun, LongFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureIntLongIntString2Double(f: (iFun, lFun, iFun, sFun) => dFun): String = getSignature(List(IntFun, LongFun, IntFun, StringFun), DoubleFun)
  def getSignatureIntLongIntBoolean2Double(f: (iFun, lFun, iFun, bFun) => dFun): String = getSignature(List(IntFun, LongFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureIntLongLongInt2Double(f: (iFun, lFun, lFun, iFun) => dFun): String = getSignature(List(IntFun, LongFun, LongFun, IntFun), DoubleFun)
  def getSignatureIntLongLongLong2Double(f: (iFun, lFun, lFun, lFun) => dFun): String = getSignature(List(IntFun, LongFun, LongFun, LongFun), DoubleFun)
  def getSignatureIntLongLongDouble2Double(f: (iFun, lFun, lFun, dFun) => dFun): String = getSignature(List(IntFun, LongFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureIntLongLongString2Double(f: (iFun, lFun, lFun, sFun) => dFun): String = getSignature(List(IntFun, LongFun, LongFun, StringFun), DoubleFun)
  def getSignatureIntLongLongBoolean2Double(f: (iFun, lFun, lFun, bFun) => dFun): String = getSignature(List(IntFun, LongFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureIntLongDoubleInt2Double(f: (iFun, lFun, dFun, iFun) => dFun): String = getSignature(List(IntFun, LongFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureIntLongDoubleLong2Double(f: (iFun, lFun, dFun, lFun) => dFun): String = getSignature(List(IntFun, LongFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureIntLongDoubleDouble2Double(f: (iFun, lFun, dFun, dFun) => dFun): String = getSignature(List(IntFun, LongFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureIntLongDoubleString2Double(f: (iFun, lFun, dFun, sFun) => dFun): String = getSignature(List(IntFun, LongFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureIntLongDoubleBoolean2Double(f: (iFun, lFun, dFun, bFun) => dFun): String = getSignature(List(IntFun, LongFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureIntLongStringInt2Double(f: (iFun, lFun, sFun, iFun) => dFun): String = getSignature(List(IntFun, LongFun, StringFun, IntFun), DoubleFun)
  def getSignatureIntLongStringLong2Double(f: (iFun, lFun, sFun, lFun) => dFun): String = getSignature(List(IntFun, LongFun, StringFun, LongFun), DoubleFun)
  def getSignatureIntLongStringDouble2Double(f: (iFun, lFun, sFun, dFun) => dFun): String = getSignature(List(IntFun, LongFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureIntLongStringString2Double(f: (iFun, lFun, sFun, sFun) => dFun): String = getSignature(List(IntFun, LongFun, StringFun, StringFun), DoubleFun)
  def getSignatureIntLongStringBoolean2Double(f: (iFun, lFun, sFun, bFun) => dFun): String = getSignature(List(IntFun, LongFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureIntLongBooleanInt2Double(f: (iFun, lFun, bFun, iFun) => dFun): String = getSignature(List(IntFun, LongFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureIntLongBooleanLong2Double(f: (iFun, lFun, bFun, lFun) => dFun): String = getSignature(List(IntFun, LongFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureIntLongBooleanDouble2Double(f: (iFun, lFun, bFun, dFun) => dFun): String = getSignature(List(IntFun, LongFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureIntLongBooleanString2Double(f: (iFun, lFun, bFun, sFun) => dFun): String = getSignature(List(IntFun, LongFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureIntLongBooleanBoolean2Double(f: (iFun, lFun, bFun, bFun) => dFun): String = getSignature(List(IntFun, LongFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureIntDoubleIntInt2Double(f: (iFun, dFun, iFun, iFun) => dFun): String = getSignature(List(IntFun, DoubleFun, IntFun, IntFun), DoubleFun)
  def getSignatureIntDoubleIntLong2Double(f: (iFun, dFun, iFun, lFun) => dFun): String = getSignature(List(IntFun, DoubleFun, IntFun, LongFun), DoubleFun)
  def getSignatureIntDoubleIntDouble2Double(f: (iFun, dFun, iFun, dFun) => dFun): String = getSignature(List(IntFun, DoubleFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureIntDoubleIntString2Double(f: (iFun, dFun, iFun, sFun) => dFun): String = getSignature(List(IntFun, DoubleFun, IntFun, StringFun), DoubleFun)
  def getSignatureIntDoubleIntBoolean2Double(f: (iFun, dFun, iFun, bFun) => dFun): String = getSignature(List(IntFun, DoubleFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureIntDoubleLongInt2Double(f: (iFun, dFun, lFun, iFun) => dFun): String = getSignature(List(IntFun, DoubleFun, LongFun, IntFun), DoubleFun)
  def getSignatureIntDoubleLongLong2Double(f: (iFun, dFun, lFun, lFun) => dFun): String = getSignature(List(IntFun, DoubleFun, LongFun, LongFun), DoubleFun)
  def getSignatureIntDoubleLongDouble2Double(f: (iFun, dFun, lFun, dFun) => dFun): String = getSignature(List(IntFun, DoubleFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureIntDoubleLongString2Double(f: (iFun, dFun, lFun, sFun) => dFun): String = getSignature(List(IntFun, DoubleFun, LongFun, StringFun), DoubleFun)
  def getSignatureIntDoubleLongBoolean2Double(f: (iFun, dFun, lFun, bFun) => dFun): String = getSignature(List(IntFun, DoubleFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureIntDoubleDoubleInt2Double(f: (iFun, dFun, dFun, iFun) => dFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureIntDoubleDoubleLong2Double(f: (iFun, dFun, dFun, lFun) => dFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureIntDoubleDoubleDouble2Double(f: (iFun, dFun, dFun, dFun) => dFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureIntDoubleDoubleString2Double(f: (iFun, dFun, dFun, sFun) => dFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureIntDoubleDoubleBoolean2Double(f: (iFun, dFun, dFun, bFun) => dFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureIntDoubleStringInt2Double(f: (iFun, dFun, sFun, iFun) => dFun): String = getSignature(List(IntFun, DoubleFun, StringFun, IntFun), DoubleFun)
  def getSignatureIntDoubleStringLong2Double(f: (iFun, dFun, sFun, lFun) => dFun): String = getSignature(List(IntFun, DoubleFun, StringFun, LongFun), DoubleFun)
  def getSignatureIntDoubleStringDouble2Double(f: (iFun, dFun, sFun, dFun) => dFun): String = getSignature(List(IntFun, DoubleFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureIntDoubleStringString2Double(f: (iFun, dFun, sFun, sFun) => dFun): String = getSignature(List(IntFun, DoubleFun, StringFun, StringFun), DoubleFun)
  def getSignatureIntDoubleStringBoolean2Double(f: (iFun, dFun, sFun, bFun) => dFun): String = getSignature(List(IntFun, DoubleFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureIntDoubleBooleanInt2Double(f: (iFun, dFun, bFun, iFun) => dFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureIntDoubleBooleanLong2Double(f: (iFun, dFun, bFun, lFun) => dFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureIntDoubleBooleanDouble2Double(f: (iFun, dFun, bFun, dFun) => dFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureIntDoubleBooleanString2Double(f: (iFun, dFun, bFun, sFun) => dFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureIntDoubleBooleanBoolean2Double(f: (iFun, dFun, bFun, bFun) => dFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureIntStringIntInt2Double(f: (iFun, sFun, iFun, iFun) => dFun): String = getSignature(List(IntFun, StringFun, IntFun, IntFun), DoubleFun)
  def getSignatureIntStringIntLong2Double(f: (iFun, sFun, iFun, lFun) => dFun): String = getSignature(List(IntFun, StringFun, IntFun, LongFun), DoubleFun)
  def getSignatureIntStringIntDouble2Double(f: (iFun, sFun, iFun, dFun) => dFun): String = getSignature(List(IntFun, StringFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureIntStringIntString2Double(f: (iFun, sFun, iFun, sFun) => dFun): String = getSignature(List(IntFun, StringFun, IntFun, StringFun), DoubleFun)
  def getSignatureIntStringIntBoolean2Double(f: (iFun, sFun, iFun, bFun) => dFun): String = getSignature(List(IntFun, StringFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureIntStringLongInt2Double(f: (iFun, sFun, lFun, iFun) => dFun): String = getSignature(List(IntFun, StringFun, LongFun, IntFun), DoubleFun)
  def getSignatureIntStringLongLong2Double(f: (iFun, sFun, lFun, lFun) => dFun): String = getSignature(List(IntFun, StringFun, LongFun, LongFun), DoubleFun)
  def getSignatureIntStringLongDouble2Double(f: (iFun, sFun, lFun, dFun) => dFun): String = getSignature(List(IntFun, StringFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureIntStringLongString2Double(f: (iFun, sFun, lFun, sFun) => dFun): String = getSignature(List(IntFun, StringFun, LongFun, StringFun), DoubleFun)
  def getSignatureIntStringLongBoolean2Double(f: (iFun, sFun, lFun, bFun) => dFun): String = getSignature(List(IntFun, StringFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureIntStringDoubleInt2Double(f: (iFun, sFun, dFun, iFun) => dFun): String = getSignature(List(IntFun, StringFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureIntStringDoubleLong2Double(f: (iFun, sFun, dFun, lFun) => dFun): String = getSignature(List(IntFun, StringFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureIntStringDoubleDouble2Double(f: (iFun, sFun, dFun, dFun) => dFun): String = getSignature(List(IntFun, StringFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureIntStringDoubleString2Double(f: (iFun, sFun, dFun, sFun) => dFun): String = getSignature(List(IntFun, StringFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureIntStringDoubleBoolean2Double(f: (iFun, sFun, dFun, bFun) => dFun): String = getSignature(List(IntFun, StringFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureIntStringStringInt2Double(f: (iFun, sFun, sFun, iFun) => dFun): String = getSignature(List(IntFun, StringFun, StringFun, IntFun), DoubleFun)
  def getSignatureIntStringStringLong2Double(f: (iFun, sFun, sFun, lFun) => dFun): String = getSignature(List(IntFun, StringFun, StringFun, LongFun), DoubleFun)
  def getSignatureIntStringStringDouble2Double(f: (iFun, sFun, sFun, dFun) => dFun): String = getSignature(List(IntFun, StringFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureIntStringStringString2Double(f: (iFun, sFun, sFun, sFun) => dFun): String = getSignature(List(IntFun, StringFun, StringFun, StringFun), DoubleFun)
  def getSignatureIntStringStringBoolean2Double(f: (iFun, sFun, sFun, bFun) => dFun): String = getSignature(List(IntFun, StringFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureIntStringBooleanInt2Double(f: (iFun, sFun, bFun, iFun) => dFun): String = getSignature(List(IntFun, StringFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureIntStringBooleanLong2Double(f: (iFun, sFun, bFun, lFun) => dFun): String = getSignature(List(IntFun, StringFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureIntStringBooleanDouble2Double(f: (iFun, sFun, bFun, dFun) => dFun): String = getSignature(List(IntFun, StringFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureIntStringBooleanString2Double(f: (iFun, sFun, bFun, sFun) => dFun): String = getSignature(List(IntFun, StringFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureIntStringBooleanBoolean2Double(f: (iFun, sFun, bFun, bFun) => dFun): String = getSignature(List(IntFun, StringFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureIntBooleanIntInt2Double(f: (iFun, bFun, iFun, iFun) => dFun): String = getSignature(List(IntFun, BooleanFun, IntFun, IntFun), DoubleFun)
  def getSignatureIntBooleanIntLong2Double(f: (iFun, bFun, iFun, lFun) => dFun): String = getSignature(List(IntFun, BooleanFun, IntFun, LongFun), DoubleFun)
  def getSignatureIntBooleanIntDouble2Double(f: (iFun, bFun, iFun, dFun) => dFun): String = getSignature(List(IntFun, BooleanFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureIntBooleanIntString2Double(f: (iFun, bFun, iFun, sFun) => dFun): String = getSignature(List(IntFun, BooleanFun, IntFun, StringFun), DoubleFun)
  def getSignatureIntBooleanIntBoolean2Double(f: (iFun, bFun, iFun, bFun) => dFun): String = getSignature(List(IntFun, BooleanFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureIntBooleanLongInt2Double(f: (iFun, bFun, lFun, iFun) => dFun): String = getSignature(List(IntFun, BooleanFun, LongFun, IntFun), DoubleFun)
  def getSignatureIntBooleanLongLong2Double(f: (iFun, bFun, lFun, lFun) => dFun): String = getSignature(List(IntFun, BooleanFun, LongFun, LongFun), DoubleFun)
  def getSignatureIntBooleanLongDouble2Double(f: (iFun, bFun, lFun, dFun) => dFun): String = getSignature(List(IntFun, BooleanFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureIntBooleanLongString2Double(f: (iFun, bFun, lFun, sFun) => dFun): String = getSignature(List(IntFun, BooleanFun, LongFun, StringFun), DoubleFun)
  def getSignatureIntBooleanLongBoolean2Double(f: (iFun, bFun, lFun, bFun) => dFun): String = getSignature(List(IntFun, BooleanFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureIntBooleanDoubleInt2Double(f: (iFun, bFun, dFun, iFun) => dFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureIntBooleanDoubleLong2Double(f: (iFun, bFun, dFun, lFun) => dFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureIntBooleanDoubleDouble2Double(f: (iFun, bFun, dFun, dFun) => dFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureIntBooleanDoubleString2Double(f: (iFun, bFun, dFun, sFun) => dFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureIntBooleanDoubleBoolean2Double(f: (iFun, bFun, dFun, bFun) => dFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureIntBooleanStringInt2Double(f: (iFun, bFun, sFun, iFun) => dFun): String = getSignature(List(IntFun, BooleanFun, StringFun, IntFun), DoubleFun)
  def getSignatureIntBooleanStringLong2Double(f: (iFun, bFun, sFun, lFun) => dFun): String = getSignature(List(IntFun, BooleanFun, StringFun, LongFun), DoubleFun)
  def getSignatureIntBooleanStringDouble2Double(f: (iFun, bFun, sFun, dFun) => dFun): String = getSignature(List(IntFun, BooleanFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureIntBooleanStringString2Double(f: (iFun, bFun, sFun, sFun) => dFun): String = getSignature(List(IntFun, BooleanFun, StringFun, StringFun), DoubleFun)
  def getSignatureIntBooleanStringBoolean2Double(f: (iFun, bFun, sFun, bFun) => dFun): String = getSignature(List(IntFun, BooleanFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureIntBooleanBooleanInt2Double(f: (iFun, bFun, bFun, iFun) => dFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureIntBooleanBooleanLong2Double(f: (iFun, bFun, bFun, lFun) => dFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureIntBooleanBooleanDouble2Double(f: (iFun, bFun, bFun, dFun) => dFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureIntBooleanBooleanString2Double(f: (iFun, bFun, bFun, sFun) => dFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureIntBooleanBooleanBoolean2Double(f: (iFun, bFun, bFun, bFun) => dFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureLongIntIntInt2Double(f: (lFun, iFun, iFun, iFun) => dFun): String = getSignature(List(LongFun, IntFun, IntFun, IntFun), DoubleFun)
  def getSignatureLongIntIntLong2Double(f: (lFun, iFun, iFun, lFun) => dFun): String = getSignature(List(LongFun, IntFun, IntFun, LongFun), DoubleFun)
  def getSignatureLongIntIntDouble2Double(f: (lFun, iFun, iFun, dFun) => dFun): String = getSignature(List(LongFun, IntFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureLongIntIntString2Double(f: (lFun, iFun, iFun, sFun) => dFun): String = getSignature(List(LongFun, IntFun, IntFun, StringFun), DoubleFun)
  def getSignatureLongIntIntBoolean2Double(f: (lFun, iFun, iFun, bFun) => dFun): String = getSignature(List(LongFun, IntFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureLongIntLongInt2Double(f: (lFun, iFun, lFun, iFun) => dFun): String = getSignature(List(LongFun, IntFun, LongFun, IntFun), DoubleFun)
  def getSignatureLongIntLongLong2Double(f: (lFun, iFun, lFun, lFun) => dFun): String = getSignature(List(LongFun, IntFun, LongFun, LongFun), DoubleFun)
  def getSignatureLongIntLongDouble2Double(f: (lFun, iFun, lFun, dFun) => dFun): String = getSignature(List(LongFun, IntFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureLongIntLongString2Double(f: (lFun, iFun, lFun, sFun) => dFun): String = getSignature(List(LongFun, IntFun, LongFun, StringFun), DoubleFun)
  def getSignatureLongIntLongBoolean2Double(f: (lFun, iFun, lFun, bFun) => dFun): String = getSignature(List(LongFun, IntFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureLongIntDoubleInt2Double(f: (lFun, iFun, dFun, iFun) => dFun): String = getSignature(List(LongFun, IntFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureLongIntDoubleLong2Double(f: (lFun, iFun, dFun, lFun) => dFun): String = getSignature(List(LongFun, IntFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureLongIntDoubleDouble2Double(f: (lFun, iFun, dFun, dFun) => dFun): String = getSignature(List(LongFun, IntFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureLongIntDoubleString2Double(f: (lFun, iFun, dFun, sFun) => dFun): String = getSignature(List(LongFun, IntFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureLongIntDoubleBoolean2Double(f: (lFun, iFun, dFun, bFun) => dFun): String = getSignature(List(LongFun, IntFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureLongIntStringInt2Double(f: (lFun, iFun, sFun, iFun) => dFun): String = getSignature(List(LongFun, IntFun, StringFun, IntFun), DoubleFun)
  def getSignatureLongIntStringLong2Double(f: (lFun, iFun, sFun, lFun) => dFun): String = getSignature(List(LongFun, IntFun, StringFun, LongFun), DoubleFun)
  def getSignatureLongIntStringDouble2Double(f: (lFun, iFun, sFun, dFun) => dFun): String = getSignature(List(LongFun, IntFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureLongIntStringString2Double(f: (lFun, iFun, sFun, sFun) => dFun): String = getSignature(List(LongFun, IntFun, StringFun, StringFun), DoubleFun)
  def getSignatureLongIntStringBoolean2Double(f: (lFun, iFun, sFun, bFun) => dFun): String = getSignature(List(LongFun, IntFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureLongIntBooleanInt2Double(f: (lFun, iFun, bFun, iFun) => dFun): String = getSignature(List(LongFun, IntFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureLongIntBooleanLong2Double(f: (lFun, iFun, bFun, lFun) => dFun): String = getSignature(List(LongFun, IntFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureLongIntBooleanDouble2Double(f: (lFun, iFun, bFun, dFun) => dFun): String = getSignature(List(LongFun, IntFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureLongIntBooleanString2Double(f: (lFun, iFun, bFun, sFun) => dFun): String = getSignature(List(LongFun, IntFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureLongIntBooleanBoolean2Double(f: (lFun, iFun, bFun, bFun) => dFun): String = getSignature(List(LongFun, IntFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureLongLongIntInt2Double(f: (lFun, lFun, iFun, iFun) => dFun): String = getSignature(List(LongFun, LongFun, IntFun, IntFun), DoubleFun)
  def getSignatureLongLongIntLong2Double(f: (lFun, lFun, iFun, lFun) => dFun): String = getSignature(List(LongFun, LongFun, IntFun, LongFun), DoubleFun)
  def getSignatureLongLongIntDouble2Double(f: (lFun, lFun, iFun, dFun) => dFun): String = getSignature(List(LongFun, LongFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureLongLongIntString2Double(f: (lFun, lFun, iFun, sFun) => dFun): String = getSignature(List(LongFun, LongFun, IntFun, StringFun), DoubleFun)
  def getSignatureLongLongIntBoolean2Double(f: (lFun, lFun, iFun, bFun) => dFun): String = getSignature(List(LongFun, LongFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureLongLongLongInt2Double(f: (lFun, lFun, lFun, iFun) => dFun): String = getSignature(List(LongFun, LongFun, LongFun, IntFun), DoubleFun)
  def getSignatureLongLongLongLong2Double(f: (lFun, lFun, lFun, lFun) => dFun): String = getSignature(List(LongFun, LongFun, LongFun, LongFun), DoubleFun)
  def getSignatureLongLongLongDouble2Double(f: (lFun, lFun, lFun, dFun) => dFun): String = getSignature(List(LongFun, LongFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureLongLongLongString2Double(f: (lFun, lFun, lFun, sFun) => dFun): String = getSignature(List(LongFun, LongFun, LongFun, StringFun), DoubleFun)
  def getSignatureLongLongLongBoolean2Double(f: (lFun, lFun, lFun, bFun) => dFun): String = getSignature(List(LongFun, LongFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureLongLongDoubleInt2Double(f: (lFun, lFun, dFun, iFun) => dFun): String = getSignature(List(LongFun, LongFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureLongLongDoubleLong2Double(f: (lFun, lFun, dFun, lFun) => dFun): String = getSignature(List(LongFun, LongFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureLongLongDoubleDouble2Double(f: (lFun, lFun, dFun, dFun) => dFun): String = getSignature(List(LongFun, LongFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureLongLongDoubleString2Double(f: (lFun, lFun, dFun, sFun) => dFun): String = getSignature(List(LongFun, LongFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureLongLongDoubleBoolean2Double(f: (lFun, lFun, dFun, bFun) => dFun): String = getSignature(List(LongFun, LongFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureLongLongStringInt2Double(f: (lFun, lFun, sFun, iFun) => dFun): String = getSignature(List(LongFun, LongFun, StringFun, IntFun), DoubleFun)
  def getSignatureLongLongStringLong2Double(f: (lFun, lFun, sFun, lFun) => dFun): String = getSignature(List(LongFun, LongFun, StringFun, LongFun), DoubleFun)
  def getSignatureLongLongStringDouble2Double(f: (lFun, lFun, sFun, dFun) => dFun): String = getSignature(List(LongFun, LongFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureLongLongStringString2Double(f: (lFun, lFun, sFun, sFun) => dFun): String = getSignature(List(LongFun, LongFun, StringFun, StringFun), DoubleFun)
  def getSignatureLongLongStringBoolean2Double(f: (lFun, lFun, sFun, bFun) => dFun): String = getSignature(List(LongFun, LongFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureLongLongBooleanInt2Double(f: (lFun, lFun, bFun, iFun) => dFun): String = getSignature(List(LongFun, LongFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureLongLongBooleanLong2Double(f: (lFun, lFun, bFun, lFun) => dFun): String = getSignature(List(LongFun, LongFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureLongLongBooleanDouble2Double(f: (lFun, lFun, bFun, dFun) => dFun): String = getSignature(List(LongFun, LongFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureLongLongBooleanString2Double(f: (lFun, lFun, bFun, sFun) => dFun): String = getSignature(List(LongFun, LongFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureLongLongBooleanBoolean2Double(f: (lFun, lFun, bFun, bFun) => dFun): String = getSignature(List(LongFun, LongFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureLongDoubleIntInt2Double(f: (lFun, dFun, iFun, iFun) => dFun): String = getSignature(List(LongFun, DoubleFun, IntFun, IntFun), DoubleFun)
  def getSignatureLongDoubleIntLong2Double(f: (lFun, dFun, iFun, lFun) => dFun): String = getSignature(List(LongFun, DoubleFun, IntFun, LongFun), DoubleFun)
  def getSignatureLongDoubleIntDouble2Double(f: (lFun, dFun, iFun, dFun) => dFun): String = getSignature(List(LongFun, DoubleFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureLongDoubleIntString2Double(f: (lFun, dFun, iFun, sFun) => dFun): String = getSignature(List(LongFun, DoubleFun, IntFun, StringFun), DoubleFun)
  def getSignatureLongDoubleIntBoolean2Double(f: (lFun, dFun, iFun, bFun) => dFun): String = getSignature(List(LongFun, DoubleFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureLongDoubleLongInt2Double(f: (lFun, dFun, lFun, iFun) => dFun): String = getSignature(List(LongFun, DoubleFun, LongFun, IntFun), DoubleFun)
  def getSignatureLongDoubleLongLong2Double(f: (lFun, dFun, lFun, lFun) => dFun): String = getSignature(List(LongFun, DoubleFun, LongFun, LongFun), DoubleFun)
  def getSignatureLongDoubleLongDouble2Double(f: (lFun, dFun, lFun, dFun) => dFun): String = getSignature(List(LongFun, DoubleFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureLongDoubleLongString2Double(f: (lFun, dFun, lFun, sFun) => dFun): String = getSignature(List(LongFun, DoubleFun, LongFun, StringFun), DoubleFun)
  def getSignatureLongDoubleLongBoolean2Double(f: (lFun, dFun, lFun, bFun) => dFun): String = getSignature(List(LongFun, DoubleFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureLongDoubleDoubleInt2Double(f: (lFun, dFun, dFun, iFun) => dFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureLongDoubleDoubleLong2Double(f: (lFun, dFun, dFun, lFun) => dFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureLongDoubleDoubleDouble2Double(f: (lFun, dFun, dFun, dFun) => dFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureLongDoubleDoubleString2Double(f: (lFun, dFun, dFun, sFun) => dFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureLongDoubleDoubleBoolean2Double(f: (lFun, dFun, dFun, bFun) => dFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureLongDoubleStringInt2Double(f: (lFun, dFun, sFun, iFun) => dFun): String = getSignature(List(LongFun, DoubleFun, StringFun, IntFun), DoubleFun)
  def getSignatureLongDoubleStringLong2Double(f: (lFun, dFun, sFun, lFun) => dFun): String = getSignature(List(LongFun, DoubleFun, StringFun, LongFun), DoubleFun)
  def getSignatureLongDoubleStringDouble2Double(f: (lFun, dFun, sFun, dFun) => dFun): String = getSignature(List(LongFun, DoubleFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureLongDoubleStringString2Double(f: (lFun, dFun, sFun, sFun) => dFun): String = getSignature(List(LongFun, DoubleFun, StringFun, StringFun), DoubleFun)
  def getSignatureLongDoubleStringBoolean2Double(f: (lFun, dFun, sFun, bFun) => dFun): String = getSignature(List(LongFun, DoubleFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureLongDoubleBooleanInt2Double(f: (lFun, dFun, bFun, iFun) => dFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureLongDoubleBooleanLong2Double(f: (lFun, dFun, bFun, lFun) => dFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureLongDoubleBooleanDouble2Double(f: (lFun, dFun, bFun, dFun) => dFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureLongDoubleBooleanString2Double(f: (lFun, dFun, bFun, sFun) => dFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureLongDoubleBooleanBoolean2Double(f: (lFun, dFun, bFun, bFun) => dFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureLongStringIntInt2Double(f: (lFun, sFun, iFun, iFun) => dFun): String = getSignature(List(LongFun, StringFun, IntFun, IntFun), DoubleFun)
  def getSignatureLongStringIntLong2Double(f: (lFun, sFun, iFun, lFun) => dFun): String = getSignature(List(LongFun, StringFun, IntFun, LongFun), DoubleFun)
  def getSignatureLongStringIntDouble2Double(f: (lFun, sFun, iFun, dFun) => dFun): String = getSignature(List(LongFun, StringFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureLongStringIntString2Double(f: (lFun, sFun, iFun, sFun) => dFun): String = getSignature(List(LongFun, StringFun, IntFun, StringFun), DoubleFun)
  def getSignatureLongStringIntBoolean2Double(f: (lFun, sFun, iFun, bFun) => dFun): String = getSignature(List(LongFun, StringFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureLongStringLongInt2Double(f: (lFun, sFun, lFun, iFun) => dFun): String = getSignature(List(LongFun, StringFun, LongFun, IntFun), DoubleFun)
  def getSignatureLongStringLongLong2Double(f: (lFun, sFun, lFun, lFun) => dFun): String = getSignature(List(LongFun, StringFun, LongFun, LongFun), DoubleFun)
  def getSignatureLongStringLongDouble2Double(f: (lFun, sFun, lFun, dFun) => dFun): String = getSignature(List(LongFun, StringFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureLongStringLongString2Double(f: (lFun, sFun, lFun, sFun) => dFun): String = getSignature(List(LongFun, StringFun, LongFun, StringFun), DoubleFun)
  def getSignatureLongStringLongBoolean2Double(f: (lFun, sFun, lFun, bFun) => dFun): String = getSignature(List(LongFun, StringFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureLongStringDoubleInt2Double(f: (lFun, sFun, dFun, iFun) => dFun): String = getSignature(List(LongFun, StringFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureLongStringDoubleLong2Double(f: (lFun, sFun, dFun, lFun) => dFun): String = getSignature(List(LongFun, StringFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureLongStringDoubleDouble2Double(f: (lFun, sFun, dFun, dFun) => dFun): String = getSignature(List(LongFun, StringFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureLongStringDoubleString2Double(f: (lFun, sFun, dFun, sFun) => dFun): String = getSignature(List(LongFun, StringFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureLongStringDoubleBoolean2Double(f: (lFun, sFun, dFun, bFun) => dFun): String = getSignature(List(LongFun, StringFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureLongStringStringInt2Double(f: (lFun, sFun, sFun, iFun) => dFun): String = getSignature(List(LongFun, StringFun, StringFun, IntFun), DoubleFun)
  def getSignatureLongStringStringLong2Double(f: (lFun, sFun, sFun, lFun) => dFun): String = getSignature(List(LongFun, StringFun, StringFun, LongFun), DoubleFun)
  def getSignatureLongStringStringDouble2Double(f: (lFun, sFun, sFun, dFun) => dFun): String = getSignature(List(LongFun, StringFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureLongStringStringString2Double(f: (lFun, sFun, sFun, sFun) => dFun): String = getSignature(List(LongFun, StringFun, StringFun, StringFun), DoubleFun)
  def getSignatureLongStringStringBoolean2Double(f: (lFun, sFun, sFun, bFun) => dFun): String = getSignature(List(LongFun, StringFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureLongStringBooleanInt2Double(f: (lFun, sFun, bFun, iFun) => dFun): String = getSignature(List(LongFun, StringFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureLongStringBooleanLong2Double(f: (lFun, sFun, bFun, lFun) => dFun): String = getSignature(List(LongFun, StringFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureLongStringBooleanDouble2Double(f: (lFun, sFun, bFun, dFun) => dFun): String = getSignature(List(LongFun, StringFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureLongStringBooleanString2Double(f: (lFun, sFun, bFun, sFun) => dFun): String = getSignature(List(LongFun, StringFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureLongStringBooleanBoolean2Double(f: (lFun, sFun, bFun, bFun) => dFun): String = getSignature(List(LongFun, StringFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureLongBooleanIntInt2Double(f: (lFun, bFun, iFun, iFun) => dFun): String = getSignature(List(LongFun, BooleanFun, IntFun, IntFun), DoubleFun)
  def getSignatureLongBooleanIntLong2Double(f: (lFun, bFun, iFun, lFun) => dFun): String = getSignature(List(LongFun, BooleanFun, IntFun, LongFun), DoubleFun)
  def getSignatureLongBooleanIntDouble2Double(f: (lFun, bFun, iFun, dFun) => dFun): String = getSignature(List(LongFun, BooleanFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureLongBooleanIntString2Double(f: (lFun, bFun, iFun, sFun) => dFun): String = getSignature(List(LongFun, BooleanFun, IntFun, StringFun), DoubleFun)
  def getSignatureLongBooleanIntBoolean2Double(f: (lFun, bFun, iFun, bFun) => dFun): String = getSignature(List(LongFun, BooleanFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureLongBooleanLongInt2Double(f: (lFun, bFun, lFun, iFun) => dFun): String = getSignature(List(LongFun, BooleanFun, LongFun, IntFun), DoubleFun)
  def getSignatureLongBooleanLongLong2Double(f: (lFun, bFun, lFun, lFun) => dFun): String = getSignature(List(LongFun, BooleanFun, LongFun, LongFun), DoubleFun)
  def getSignatureLongBooleanLongDouble2Double(f: (lFun, bFun, lFun, dFun) => dFun): String = getSignature(List(LongFun, BooleanFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureLongBooleanLongString2Double(f: (lFun, bFun, lFun, sFun) => dFun): String = getSignature(List(LongFun, BooleanFun, LongFun, StringFun), DoubleFun)
  def getSignatureLongBooleanLongBoolean2Double(f: (lFun, bFun, lFun, bFun) => dFun): String = getSignature(List(LongFun, BooleanFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureLongBooleanDoubleInt2Double(f: (lFun, bFun, dFun, iFun) => dFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureLongBooleanDoubleLong2Double(f: (lFun, bFun, dFun, lFun) => dFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureLongBooleanDoubleDouble2Double(f: (lFun, bFun, dFun, dFun) => dFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureLongBooleanDoubleString2Double(f: (lFun, bFun, dFun, sFun) => dFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureLongBooleanDoubleBoolean2Double(f: (lFun, bFun, dFun, bFun) => dFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureLongBooleanStringInt2Double(f: (lFun, bFun, sFun, iFun) => dFun): String = getSignature(List(LongFun, BooleanFun, StringFun, IntFun), DoubleFun)
  def getSignatureLongBooleanStringLong2Double(f: (lFun, bFun, sFun, lFun) => dFun): String = getSignature(List(LongFun, BooleanFun, StringFun, LongFun), DoubleFun)
  def getSignatureLongBooleanStringDouble2Double(f: (lFun, bFun, sFun, dFun) => dFun): String = getSignature(List(LongFun, BooleanFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureLongBooleanStringString2Double(f: (lFun, bFun, sFun, sFun) => dFun): String = getSignature(List(LongFun, BooleanFun, StringFun, StringFun), DoubleFun)
  def getSignatureLongBooleanStringBoolean2Double(f: (lFun, bFun, sFun, bFun) => dFun): String = getSignature(List(LongFun, BooleanFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureLongBooleanBooleanInt2Double(f: (lFun, bFun, bFun, iFun) => dFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureLongBooleanBooleanLong2Double(f: (lFun, bFun, bFun, lFun) => dFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureLongBooleanBooleanDouble2Double(f: (lFun, bFun, bFun, dFun) => dFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureLongBooleanBooleanString2Double(f: (lFun, bFun, bFun, sFun) => dFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureLongBooleanBooleanBoolean2Double(f: (lFun, bFun, bFun, bFun) => dFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureDoubleIntIntInt2Double(f: (dFun, iFun, iFun, iFun) => dFun): String = getSignature(List(DoubleFun, IntFun, IntFun, IntFun), DoubleFun)
  def getSignatureDoubleIntIntLong2Double(f: (dFun, iFun, iFun, lFun) => dFun): String = getSignature(List(DoubleFun, IntFun, IntFun, LongFun), DoubleFun)
  def getSignatureDoubleIntIntDouble2Double(f: (dFun, iFun, iFun, dFun) => dFun): String = getSignature(List(DoubleFun, IntFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureDoubleIntIntString2Double(f: (dFun, iFun, iFun, sFun) => dFun): String = getSignature(List(DoubleFun, IntFun, IntFun, StringFun), DoubleFun)
  def getSignatureDoubleIntIntBoolean2Double(f: (dFun, iFun, iFun, bFun) => dFun): String = getSignature(List(DoubleFun, IntFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureDoubleIntLongInt2Double(f: (dFun, iFun, lFun, iFun) => dFun): String = getSignature(List(DoubleFun, IntFun, LongFun, IntFun), DoubleFun)
  def getSignatureDoubleIntLongLong2Double(f: (dFun, iFun, lFun, lFun) => dFun): String = getSignature(List(DoubleFun, IntFun, LongFun, LongFun), DoubleFun)
  def getSignatureDoubleIntLongDouble2Double(f: (dFun, iFun, lFun, dFun) => dFun): String = getSignature(List(DoubleFun, IntFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureDoubleIntLongString2Double(f: (dFun, iFun, lFun, sFun) => dFun): String = getSignature(List(DoubleFun, IntFun, LongFun, StringFun), DoubleFun)
  def getSignatureDoubleIntLongBoolean2Double(f: (dFun, iFun, lFun, bFun) => dFun): String = getSignature(List(DoubleFun, IntFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureDoubleIntDoubleInt2Double(f: (dFun, iFun, dFun, iFun) => dFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureDoubleIntDoubleLong2Double(f: (dFun, iFun, dFun, lFun) => dFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureDoubleIntDoubleDouble2Double(f: (dFun, iFun, dFun, dFun) => dFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureDoubleIntDoubleString2Double(f: (dFun, iFun, dFun, sFun) => dFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureDoubleIntDoubleBoolean2Double(f: (dFun, iFun, dFun, bFun) => dFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureDoubleIntStringInt2Double(f: (dFun, iFun, sFun, iFun) => dFun): String = getSignature(List(DoubleFun, IntFun, StringFun, IntFun), DoubleFun)
  def getSignatureDoubleIntStringLong2Double(f: (dFun, iFun, sFun, lFun) => dFun): String = getSignature(List(DoubleFun, IntFun, StringFun, LongFun), DoubleFun)
  def getSignatureDoubleIntStringDouble2Double(f: (dFun, iFun, sFun, dFun) => dFun): String = getSignature(List(DoubleFun, IntFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureDoubleIntStringString2Double(f: (dFun, iFun, sFun, sFun) => dFun): String = getSignature(List(DoubleFun, IntFun, StringFun, StringFun), DoubleFun)
  def getSignatureDoubleIntStringBoolean2Double(f: (dFun, iFun, sFun, bFun) => dFun): String = getSignature(List(DoubleFun, IntFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureDoubleIntBooleanInt2Double(f: (dFun, iFun, bFun, iFun) => dFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureDoubleIntBooleanLong2Double(f: (dFun, iFun, bFun, lFun) => dFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureDoubleIntBooleanDouble2Double(f: (dFun, iFun, bFun, dFun) => dFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureDoubleIntBooleanString2Double(f: (dFun, iFun, bFun, sFun) => dFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureDoubleIntBooleanBoolean2Double(f: (dFun, iFun, bFun, bFun) => dFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureDoubleLongIntInt2Double(f: (dFun, lFun, iFun, iFun) => dFun): String = getSignature(List(DoubleFun, LongFun, IntFun, IntFun), DoubleFun)
  def getSignatureDoubleLongIntLong2Double(f: (dFun, lFun, iFun, lFun) => dFun): String = getSignature(List(DoubleFun, LongFun, IntFun, LongFun), DoubleFun)
  def getSignatureDoubleLongIntDouble2Double(f: (dFun, lFun, iFun, dFun) => dFun): String = getSignature(List(DoubleFun, LongFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureDoubleLongIntString2Double(f: (dFun, lFun, iFun, sFun) => dFun): String = getSignature(List(DoubleFun, LongFun, IntFun, StringFun), DoubleFun)
  def getSignatureDoubleLongIntBoolean2Double(f: (dFun, lFun, iFun, bFun) => dFun): String = getSignature(List(DoubleFun, LongFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureDoubleLongLongInt2Double(f: (dFun, lFun, lFun, iFun) => dFun): String = getSignature(List(DoubleFun, LongFun, LongFun, IntFun), DoubleFun)
  def getSignatureDoubleLongLongLong2Double(f: (dFun, lFun, lFun, lFun) => dFun): String = getSignature(List(DoubleFun, LongFun, LongFun, LongFun), DoubleFun)
  def getSignatureDoubleLongLongDouble2Double(f: (dFun, lFun, lFun, dFun) => dFun): String = getSignature(List(DoubleFun, LongFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureDoubleLongLongString2Double(f: (dFun, lFun, lFun, sFun) => dFun): String = getSignature(List(DoubleFun, LongFun, LongFun, StringFun), DoubleFun)
  def getSignatureDoubleLongLongBoolean2Double(f: (dFun, lFun, lFun, bFun) => dFun): String = getSignature(List(DoubleFun, LongFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureDoubleLongDoubleInt2Double(f: (dFun, lFun, dFun, iFun) => dFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureDoubleLongDoubleLong2Double(f: (dFun, lFun, dFun, lFun) => dFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureDoubleLongDoubleDouble2Double(f: (dFun, lFun, dFun, dFun) => dFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureDoubleLongDoubleString2Double(f: (dFun, lFun, dFun, sFun) => dFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureDoubleLongDoubleBoolean2Double(f: (dFun, lFun, dFun, bFun) => dFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureDoubleLongStringInt2Double(f: (dFun, lFun, sFun, iFun) => dFun): String = getSignature(List(DoubleFun, LongFun, StringFun, IntFun), DoubleFun)
  def getSignatureDoubleLongStringLong2Double(f: (dFun, lFun, sFun, lFun) => dFun): String = getSignature(List(DoubleFun, LongFun, StringFun, LongFun), DoubleFun)
  def getSignatureDoubleLongStringDouble2Double(f: (dFun, lFun, sFun, dFun) => dFun): String = getSignature(List(DoubleFun, LongFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureDoubleLongStringString2Double(f: (dFun, lFun, sFun, sFun) => dFun): String = getSignature(List(DoubleFun, LongFun, StringFun, StringFun), DoubleFun)
  def getSignatureDoubleLongStringBoolean2Double(f: (dFun, lFun, sFun, bFun) => dFun): String = getSignature(List(DoubleFun, LongFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureDoubleLongBooleanInt2Double(f: (dFun, lFun, bFun, iFun) => dFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureDoubleLongBooleanLong2Double(f: (dFun, lFun, bFun, lFun) => dFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureDoubleLongBooleanDouble2Double(f: (dFun, lFun, bFun, dFun) => dFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureDoubleLongBooleanString2Double(f: (dFun, lFun, bFun, sFun) => dFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureDoubleLongBooleanBoolean2Double(f: (dFun, lFun, bFun, bFun) => dFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureDoubleDoubleIntInt2Double(f: (dFun, dFun, iFun, iFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, IntFun), DoubleFun)
  def getSignatureDoubleDoubleIntLong2Double(f: (dFun, dFun, iFun, lFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, LongFun), DoubleFun)
  def getSignatureDoubleDoubleIntDouble2Double(f: (dFun, dFun, iFun, dFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureDoubleDoubleIntString2Double(f: (dFun, dFun, iFun, sFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, StringFun), DoubleFun)
  def getSignatureDoubleDoubleIntBoolean2Double(f: (dFun, dFun, iFun, bFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureDoubleDoubleLongInt2Double(f: (dFun, dFun, lFun, iFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, IntFun), DoubleFun)
  def getSignatureDoubleDoubleLongLong2Double(f: (dFun, dFun, lFun, lFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, LongFun), DoubleFun)
  def getSignatureDoubleDoubleLongDouble2Double(f: (dFun, dFun, lFun, dFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureDoubleDoubleLongString2Double(f: (dFun, dFun, lFun, sFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, StringFun), DoubleFun)
  def getSignatureDoubleDoubleLongBoolean2Double(f: (dFun, dFun, lFun, bFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureDoubleDoubleDoubleInt2Double(f: (dFun, dFun, dFun, iFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureDoubleDoubleDoubleLong2Double(f: (dFun, dFun, dFun, lFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureDoubleDoubleDoubleDouble2Double(f: (dFun, dFun, dFun, dFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureDoubleDoubleDoubleString2Double(f: (dFun, dFun, dFun, sFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureDoubleDoubleDoubleBoolean2Double(f: (dFun, dFun, dFun, bFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureDoubleDoubleStringInt2Double(f: (dFun, dFun, sFun, iFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, IntFun), DoubleFun)
  def getSignatureDoubleDoubleStringLong2Double(f: (dFun, dFun, sFun, lFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, LongFun), DoubleFun)
  def getSignatureDoubleDoubleStringDouble2Double(f: (dFun, dFun, sFun, dFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureDoubleDoubleStringString2Double(f: (dFun, dFun, sFun, sFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, StringFun), DoubleFun)
  def getSignatureDoubleDoubleStringBoolean2Double(f: (dFun, dFun, sFun, bFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureDoubleDoubleBooleanInt2Double(f: (dFun, dFun, bFun, iFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureDoubleDoubleBooleanLong2Double(f: (dFun, dFun, bFun, lFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureDoubleDoubleBooleanDouble2Double(f: (dFun, dFun, bFun, dFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureDoubleDoubleBooleanString2Double(f: (dFun, dFun, bFun, sFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureDoubleDoubleBooleanBoolean2Double(f: (dFun, dFun, bFun, bFun) => dFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureDoubleStringIntInt2Double(f: (dFun, sFun, iFun, iFun) => dFun): String = getSignature(List(DoubleFun, StringFun, IntFun, IntFun), DoubleFun)
  def getSignatureDoubleStringIntLong2Double(f: (dFun, sFun, iFun, lFun) => dFun): String = getSignature(List(DoubleFun, StringFun, IntFun, LongFun), DoubleFun)
  def getSignatureDoubleStringIntDouble2Double(f: (dFun, sFun, iFun, dFun) => dFun): String = getSignature(List(DoubleFun, StringFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureDoubleStringIntString2Double(f: (dFun, sFun, iFun, sFun) => dFun): String = getSignature(List(DoubleFun, StringFun, IntFun, StringFun), DoubleFun)
  def getSignatureDoubleStringIntBoolean2Double(f: (dFun, sFun, iFun, bFun) => dFun): String = getSignature(List(DoubleFun, StringFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureDoubleStringLongInt2Double(f: (dFun, sFun, lFun, iFun) => dFun): String = getSignature(List(DoubleFun, StringFun, LongFun, IntFun), DoubleFun)
  def getSignatureDoubleStringLongLong2Double(f: (dFun, sFun, lFun, lFun) => dFun): String = getSignature(List(DoubleFun, StringFun, LongFun, LongFun), DoubleFun)
  def getSignatureDoubleStringLongDouble2Double(f: (dFun, sFun, lFun, dFun) => dFun): String = getSignature(List(DoubleFun, StringFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureDoubleStringLongString2Double(f: (dFun, sFun, lFun, sFun) => dFun): String = getSignature(List(DoubleFun, StringFun, LongFun, StringFun), DoubleFun)
  def getSignatureDoubleStringLongBoolean2Double(f: (dFun, sFun, lFun, bFun) => dFun): String = getSignature(List(DoubleFun, StringFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureDoubleStringDoubleInt2Double(f: (dFun, sFun, dFun, iFun) => dFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureDoubleStringDoubleLong2Double(f: (dFun, sFun, dFun, lFun) => dFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureDoubleStringDoubleDouble2Double(f: (dFun, sFun, dFun, dFun) => dFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureDoubleStringDoubleString2Double(f: (dFun, sFun, dFun, sFun) => dFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureDoubleStringDoubleBoolean2Double(f: (dFun, sFun, dFun, bFun) => dFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureDoubleStringStringInt2Double(f: (dFun, sFun, sFun, iFun) => dFun): String = getSignature(List(DoubleFun, StringFun, StringFun, IntFun), DoubleFun)
  def getSignatureDoubleStringStringLong2Double(f: (dFun, sFun, sFun, lFun) => dFun): String = getSignature(List(DoubleFun, StringFun, StringFun, LongFun), DoubleFun)
  def getSignatureDoubleStringStringDouble2Double(f: (dFun, sFun, sFun, dFun) => dFun): String = getSignature(List(DoubleFun, StringFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureDoubleStringStringString2Double(f: (dFun, sFun, sFun, sFun) => dFun): String = getSignature(List(DoubleFun, StringFun, StringFun, StringFun), DoubleFun)
  def getSignatureDoubleStringStringBoolean2Double(f: (dFun, sFun, sFun, bFun) => dFun): String = getSignature(List(DoubleFun, StringFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureDoubleStringBooleanInt2Double(f: (dFun, sFun, bFun, iFun) => dFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureDoubleStringBooleanLong2Double(f: (dFun, sFun, bFun, lFun) => dFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureDoubleStringBooleanDouble2Double(f: (dFun, sFun, bFun, dFun) => dFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureDoubleStringBooleanString2Double(f: (dFun, sFun, bFun, sFun) => dFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureDoubleStringBooleanBoolean2Double(f: (dFun, sFun, bFun, bFun) => dFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureDoubleBooleanIntInt2Double(f: (dFun, bFun, iFun, iFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, IntFun), DoubleFun)
  def getSignatureDoubleBooleanIntLong2Double(f: (dFun, bFun, iFun, lFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, LongFun), DoubleFun)
  def getSignatureDoubleBooleanIntDouble2Double(f: (dFun, bFun, iFun, dFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureDoubleBooleanIntString2Double(f: (dFun, bFun, iFun, sFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, StringFun), DoubleFun)
  def getSignatureDoubleBooleanIntBoolean2Double(f: (dFun, bFun, iFun, bFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureDoubleBooleanLongInt2Double(f: (dFun, bFun, lFun, iFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, IntFun), DoubleFun)
  def getSignatureDoubleBooleanLongLong2Double(f: (dFun, bFun, lFun, lFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, LongFun), DoubleFun)
  def getSignatureDoubleBooleanLongDouble2Double(f: (dFun, bFun, lFun, dFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureDoubleBooleanLongString2Double(f: (dFun, bFun, lFun, sFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, StringFun), DoubleFun)
  def getSignatureDoubleBooleanLongBoolean2Double(f: (dFun, bFun, lFun, bFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureDoubleBooleanDoubleInt2Double(f: (dFun, bFun, dFun, iFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureDoubleBooleanDoubleLong2Double(f: (dFun, bFun, dFun, lFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureDoubleBooleanDoubleDouble2Double(f: (dFun, bFun, dFun, dFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureDoubleBooleanDoubleString2Double(f: (dFun, bFun, dFun, sFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureDoubleBooleanDoubleBoolean2Double(f: (dFun, bFun, dFun, bFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureDoubleBooleanStringInt2Double(f: (dFun, bFun, sFun, iFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, IntFun), DoubleFun)
  def getSignatureDoubleBooleanStringLong2Double(f: (dFun, bFun, sFun, lFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, LongFun), DoubleFun)
  def getSignatureDoubleBooleanStringDouble2Double(f: (dFun, bFun, sFun, dFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureDoubleBooleanStringString2Double(f: (dFun, bFun, sFun, sFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, StringFun), DoubleFun)
  def getSignatureDoubleBooleanStringBoolean2Double(f: (dFun, bFun, sFun, bFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureDoubleBooleanBooleanInt2Double(f: (dFun, bFun, bFun, iFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureDoubleBooleanBooleanLong2Double(f: (dFun, bFun, bFun, lFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureDoubleBooleanBooleanDouble2Double(f: (dFun, bFun, bFun, dFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureDoubleBooleanBooleanString2Double(f: (dFun, bFun, bFun, sFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureDoubleBooleanBooleanBoolean2Double(f: (dFun, bFun, bFun, bFun) => dFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureStringIntIntInt2Double(f: (sFun, iFun, iFun, iFun) => dFun): String = getSignature(List(StringFun, IntFun, IntFun, IntFun), DoubleFun)
  def getSignatureStringIntIntLong2Double(f: (sFun, iFun, iFun, lFun) => dFun): String = getSignature(List(StringFun, IntFun, IntFun, LongFun), DoubleFun)
  def getSignatureStringIntIntDouble2Double(f: (sFun, iFun, iFun, dFun) => dFun): String = getSignature(List(StringFun, IntFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureStringIntIntString2Double(f: (sFun, iFun, iFun, sFun) => dFun): String = getSignature(List(StringFun, IntFun, IntFun, StringFun), DoubleFun)
  def getSignatureStringIntIntBoolean2Double(f: (sFun, iFun, iFun, bFun) => dFun): String = getSignature(List(StringFun, IntFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureStringIntLongInt2Double(f: (sFun, iFun, lFun, iFun) => dFun): String = getSignature(List(StringFun, IntFun, LongFun, IntFun), DoubleFun)
  def getSignatureStringIntLongLong2Double(f: (sFun, iFun, lFun, lFun) => dFun): String = getSignature(List(StringFun, IntFun, LongFun, LongFun), DoubleFun)
  def getSignatureStringIntLongDouble2Double(f: (sFun, iFun, lFun, dFun) => dFun): String = getSignature(List(StringFun, IntFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureStringIntLongString2Double(f: (sFun, iFun, lFun, sFun) => dFun): String = getSignature(List(StringFun, IntFun, LongFun, StringFun), DoubleFun)
  def getSignatureStringIntLongBoolean2Double(f: (sFun, iFun, lFun, bFun) => dFun): String = getSignature(List(StringFun, IntFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureStringIntDoubleInt2Double(f: (sFun, iFun, dFun, iFun) => dFun): String = getSignature(List(StringFun, IntFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureStringIntDoubleLong2Double(f: (sFun, iFun, dFun, lFun) => dFun): String = getSignature(List(StringFun, IntFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureStringIntDoubleDouble2Double(f: (sFun, iFun, dFun, dFun) => dFun): String = getSignature(List(StringFun, IntFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureStringIntDoubleString2Double(f: (sFun, iFun, dFun, sFun) => dFun): String = getSignature(List(StringFun, IntFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureStringIntDoubleBoolean2Double(f: (sFun, iFun, dFun, bFun) => dFun): String = getSignature(List(StringFun, IntFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureStringIntStringInt2Double(f: (sFun, iFun, sFun, iFun) => dFun): String = getSignature(List(StringFun, IntFun, StringFun, IntFun), DoubleFun)
  def getSignatureStringIntStringLong2Double(f: (sFun, iFun, sFun, lFun) => dFun): String = getSignature(List(StringFun, IntFun, StringFun, LongFun), DoubleFun)
  def getSignatureStringIntStringDouble2Double(f: (sFun, iFun, sFun, dFun) => dFun): String = getSignature(List(StringFun, IntFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureStringIntStringString2Double(f: (sFun, iFun, sFun, sFun) => dFun): String = getSignature(List(StringFun, IntFun, StringFun, StringFun), DoubleFun)
  def getSignatureStringIntStringBoolean2Double(f: (sFun, iFun, sFun, bFun) => dFun): String = getSignature(List(StringFun, IntFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureStringIntBooleanInt2Double(f: (sFun, iFun, bFun, iFun) => dFun): String = getSignature(List(StringFun, IntFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureStringIntBooleanLong2Double(f: (sFun, iFun, bFun, lFun) => dFun): String = getSignature(List(StringFun, IntFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureStringIntBooleanDouble2Double(f: (sFun, iFun, bFun, dFun) => dFun): String = getSignature(List(StringFun, IntFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureStringIntBooleanString2Double(f: (sFun, iFun, bFun, sFun) => dFun): String = getSignature(List(StringFun, IntFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureStringIntBooleanBoolean2Double(f: (sFun, iFun, bFun, bFun) => dFun): String = getSignature(List(StringFun, IntFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureStringLongIntInt2Double(f: (sFun, lFun, iFun, iFun) => dFun): String = getSignature(List(StringFun, LongFun, IntFun, IntFun), DoubleFun)
  def getSignatureStringLongIntLong2Double(f: (sFun, lFun, iFun, lFun) => dFun): String = getSignature(List(StringFun, LongFun, IntFun, LongFun), DoubleFun)
  def getSignatureStringLongIntDouble2Double(f: (sFun, lFun, iFun, dFun) => dFun): String = getSignature(List(StringFun, LongFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureStringLongIntString2Double(f: (sFun, lFun, iFun, sFun) => dFun): String = getSignature(List(StringFun, LongFun, IntFun, StringFun), DoubleFun)
  def getSignatureStringLongIntBoolean2Double(f: (sFun, lFun, iFun, bFun) => dFun): String = getSignature(List(StringFun, LongFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureStringLongLongInt2Double(f: (sFun, lFun, lFun, iFun) => dFun): String = getSignature(List(StringFun, LongFun, LongFun, IntFun), DoubleFun)
  def getSignatureStringLongLongLong2Double(f: (sFun, lFun, lFun, lFun) => dFun): String = getSignature(List(StringFun, LongFun, LongFun, LongFun), DoubleFun)
  def getSignatureStringLongLongDouble2Double(f: (sFun, lFun, lFun, dFun) => dFun): String = getSignature(List(StringFun, LongFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureStringLongLongString2Double(f: (sFun, lFun, lFun, sFun) => dFun): String = getSignature(List(StringFun, LongFun, LongFun, StringFun), DoubleFun)
  def getSignatureStringLongLongBoolean2Double(f: (sFun, lFun, lFun, bFun) => dFun): String = getSignature(List(StringFun, LongFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureStringLongDoubleInt2Double(f: (sFun, lFun, dFun, iFun) => dFun): String = getSignature(List(StringFun, LongFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureStringLongDoubleLong2Double(f: (sFun, lFun, dFun, lFun) => dFun): String = getSignature(List(StringFun, LongFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureStringLongDoubleDouble2Double(f: (sFun, lFun, dFun, dFun) => dFun): String = getSignature(List(StringFun, LongFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureStringLongDoubleString2Double(f: (sFun, lFun, dFun, sFun) => dFun): String = getSignature(List(StringFun, LongFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureStringLongDoubleBoolean2Double(f: (sFun, lFun, dFun, bFun) => dFun): String = getSignature(List(StringFun, LongFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureStringLongStringInt2Double(f: (sFun, lFun, sFun, iFun) => dFun): String = getSignature(List(StringFun, LongFun, StringFun, IntFun), DoubleFun)
  def getSignatureStringLongStringLong2Double(f: (sFun, lFun, sFun, lFun) => dFun): String = getSignature(List(StringFun, LongFun, StringFun, LongFun), DoubleFun)
  def getSignatureStringLongStringDouble2Double(f: (sFun, lFun, sFun, dFun) => dFun): String = getSignature(List(StringFun, LongFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureStringLongStringString2Double(f: (sFun, lFun, sFun, sFun) => dFun): String = getSignature(List(StringFun, LongFun, StringFun, StringFun), DoubleFun)
  def getSignatureStringLongStringBoolean2Double(f: (sFun, lFun, sFun, bFun) => dFun): String = getSignature(List(StringFun, LongFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureStringLongBooleanInt2Double(f: (sFun, lFun, bFun, iFun) => dFun): String = getSignature(List(StringFun, LongFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureStringLongBooleanLong2Double(f: (sFun, lFun, bFun, lFun) => dFun): String = getSignature(List(StringFun, LongFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureStringLongBooleanDouble2Double(f: (sFun, lFun, bFun, dFun) => dFun): String = getSignature(List(StringFun, LongFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureStringLongBooleanString2Double(f: (sFun, lFun, bFun, sFun) => dFun): String = getSignature(List(StringFun, LongFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureStringLongBooleanBoolean2Double(f: (sFun, lFun, bFun, bFun) => dFun): String = getSignature(List(StringFun, LongFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureStringDoubleIntInt2Double(f: (sFun, dFun, iFun, iFun) => dFun): String = getSignature(List(StringFun, DoubleFun, IntFun, IntFun), DoubleFun)
  def getSignatureStringDoubleIntLong2Double(f: (sFun, dFun, iFun, lFun) => dFun): String = getSignature(List(StringFun, DoubleFun, IntFun, LongFun), DoubleFun)
  def getSignatureStringDoubleIntDouble2Double(f: (sFun, dFun, iFun, dFun) => dFun): String = getSignature(List(StringFun, DoubleFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureStringDoubleIntString2Double(f: (sFun, dFun, iFun, sFun) => dFun): String = getSignature(List(StringFun, DoubleFun, IntFun, StringFun), DoubleFun)
  def getSignatureStringDoubleIntBoolean2Double(f: (sFun, dFun, iFun, bFun) => dFun): String = getSignature(List(StringFun, DoubleFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureStringDoubleLongInt2Double(f: (sFun, dFun, lFun, iFun) => dFun): String = getSignature(List(StringFun, DoubleFun, LongFun, IntFun), DoubleFun)
  def getSignatureStringDoubleLongLong2Double(f: (sFun, dFun, lFun, lFun) => dFun): String = getSignature(List(StringFun, DoubleFun, LongFun, LongFun), DoubleFun)
  def getSignatureStringDoubleLongDouble2Double(f: (sFun, dFun, lFun, dFun) => dFun): String = getSignature(List(StringFun, DoubleFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureStringDoubleLongString2Double(f: (sFun, dFun, lFun, sFun) => dFun): String = getSignature(List(StringFun, DoubleFun, LongFun, StringFun), DoubleFun)
  def getSignatureStringDoubleLongBoolean2Double(f: (sFun, dFun, lFun, bFun) => dFun): String = getSignature(List(StringFun, DoubleFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureStringDoubleDoubleInt2Double(f: (sFun, dFun, dFun, iFun) => dFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureStringDoubleDoubleLong2Double(f: (sFun, dFun, dFun, lFun) => dFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureStringDoubleDoubleDouble2Double(f: (sFun, dFun, dFun, dFun) => dFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureStringDoubleDoubleString2Double(f: (sFun, dFun, dFun, sFun) => dFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureStringDoubleDoubleBoolean2Double(f: (sFun, dFun, dFun, bFun) => dFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureStringDoubleStringInt2Double(f: (sFun, dFun, sFun, iFun) => dFun): String = getSignature(List(StringFun, DoubleFun, StringFun, IntFun), DoubleFun)
  def getSignatureStringDoubleStringLong2Double(f: (sFun, dFun, sFun, lFun) => dFun): String = getSignature(List(StringFun, DoubleFun, StringFun, LongFun), DoubleFun)
  def getSignatureStringDoubleStringDouble2Double(f: (sFun, dFun, sFun, dFun) => dFun): String = getSignature(List(StringFun, DoubleFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureStringDoubleStringString2Double(f: (sFun, dFun, sFun, sFun) => dFun): String = getSignature(List(StringFun, DoubleFun, StringFun, StringFun), DoubleFun)
  def getSignatureStringDoubleStringBoolean2Double(f: (sFun, dFun, sFun, bFun) => dFun): String = getSignature(List(StringFun, DoubleFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureStringDoubleBooleanInt2Double(f: (sFun, dFun, bFun, iFun) => dFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureStringDoubleBooleanLong2Double(f: (sFun, dFun, bFun, lFun) => dFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureStringDoubleBooleanDouble2Double(f: (sFun, dFun, bFun, dFun) => dFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureStringDoubleBooleanString2Double(f: (sFun, dFun, bFun, sFun) => dFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureStringDoubleBooleanBoolean2Double(f: (sFun, dFun, bFun, bFun) => dFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureStringStringIntInt2Double(f: (sFun, sFun, iFun, iFun) => dFun): String = getSignature(List(StringFun, StringFun, IntFun, IntFun), DoubleFun)
  def getSignatureStringStringIntLong2Double(f: (sFun, sFun, iFun, lFun) => dFun): String = getSignature(List(StringFun, StringFun, IntFun, LongFun), DoubleFun)
  def getSignatureStringStringIntDouble2Double(f: (sFun, sFun, iFun, dFun) => dFun): String = getSignature(List(StringFun, StringFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureStringStringIntString2Double(f: (sFun, sFun, iFun, sFun) => dFun): String = getSignature(List(StringFun, StringFun, IntFun, StringFun), DoubleFun)
  def getSignatureStringStringIntBoolean2Double(f: (sFun, sFun, iFun, bFun) => dFun): String = getSignature(List(StringFun, StringFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureStringStringLongInt2Double(f: (sFun, sFun, lFun, iFun) => dFun): String = getSignature(List(StringFun, StringFun, LongFun, IntFun), DoubleFun)
  def getSignatureStringStringLongLong2Double(f: (sFun, sFun, lFun, lFun) => dFun): String = getSignature(List(StringFun, StringFun, LongFun, LongFun), DoubleFun)
  def getSignatureStringStringLongDouble2Double(f: (sFun, sFun, lFun, dFun) => dFun): String = getSignature(List(StringFun, StringFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureStringStringLongString2Double(f: (sFun, sFun, lFun, sFun) => dFun): String = getSignature(List(StringFun, StringFun, LongFun, StringFun), DoubleFun)
  def getSignatureStringStringLongBoolean2Double(f: (sFun, sFun, lFun, bFun) => dFun): String = getSignature(List(StringFun, StringFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureStringStringDoubleInt2Double(f: (sFun, sFun, dFun, iFun) => dFun): String = getSignature(List(StringFun, StringFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureStringStringDoubleLong2Double(f: (sFun, sFun, dFun, lFun) => dFun): String = getSignature(List(StringFun, StringFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureStringStringDoubleDouble2Double(f: (sFun, sFun, dFun, dFun) => dFun): String = getSignature(List(StringFun, StringFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureStringStringDoubleString2Double(f: (sFun, sFun, dFun, sFun) => dFun): String = getSignature(List(StringFun, StringFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureStringStringDoubleBoolean2Double(f: (sFun, sFun, dFun, bFun) => dFun): String = getSignature(List(StringFun, StringFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureStringStringStringInt2Double(f: (sFun, sFun, sFun, iFun) => dFun): String = getSignature(List(StringFun, StringFun, StringFun, IntFun), DoubleFun)
  def getSignatureStringStringStringLong2Double(f: (sFun, sFun, sFun, lFun) => dFun): String = getSignature(List(StringFun, StringFun, StringFun, LongFun), DoubleFun)
  def getSignatureStringStringStringDouble2Double(f: (sFun, sFun, sFun, dFun) => dFun): String = getSignature(List(StringFun, StringFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureStringStringStringString2Double(f: (sFun, sFun, sFun, sFun) => dFun): String = getSignature(List(StringFun, StringFun, StringFun, StringFun), DoubleFun)
  def getSignatureStringStringStringBoolean2Double(f: (sFun, sFun, sFun, bFun) => dFun): String = getSignature(List(StringFun, StringFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureStringStringBooleanInt2Double(f: (sFun, sFun, bFun, iFun) => dFun): String = getSignature(List(StringFun, StringFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureStringStringBooleanLong2Double(f: (sFun, sFun, bFun, lFun) => dFun): String = getSignature(List(StringFun, StringFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureStringStringBooleanDouble2Double(f: (sFun, sFun, bFun, dFun) => dFun): String = getSignature(List(StringFun, StringFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureStringStringBooleanString2Double(f: (sFun, sFun, bFun, sFun) => dFun): String = getSignature(List(StringFun, StringFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureStringStringBooleanBoolean2Double(f: (sFun, sFun, bFun, bFun) => dFun): String = getSignature(List(StringFun, StringFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureStringBooleanIntInt2Double(f: (sFun, bFun, iFun, iFun) => dFun): String = getSignature(List(StringFun, BooleanFun, IntFun, IntFun), DoubleFun)
  def getSignatureStringBooleanIntLong2Double(f: (sFun, bFun, iFun, lFun) => dFun): String = getSignature(List(StringFun, BooleanFun, IntFun, LongFun), DoubleFun)
  def getSignatureStringBooleanIntDouble2Double(f: (sFun, bFun, iFun, dFun) => dFun): String = getSignature(List(StringFun, BooleanFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureStringBooleanIntString2Double(f: (sFun, bFun, iFun, sFun) => dFun): String = getSignature(List(StringFun, BooleanFun, IntFun, StringFun), DoubleFun)
  def getSignatureStringBooleanIntBoolean2Double(f: (sFun, bFun, iFun, bFun) => dFun): String = getSignature(List(StringFun, BooleanFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureStringBooleanLongInt2Double(f: (sFun, bFun, lFun, iFun) => dFun): String = getSignature(List(StringFun, BooleanFun, LongFun, IntFun), DoubleFun)
  def getSignatureStringBooleanLongLong2Double(f: (sFun, bFun, lFun, lFun) => dFun): String = getSignature(List(StringFun, BooleanFun, LongFun, LongFun), DoubleFun)
  def getSignatureStringBooleanLongDouble2Double(f: (sFun, bFun, lFun, dFun) => dFun): String = getSignature(List(StringFun, BooleanFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureStringBooleanLongString2Double(f: (sFun, bFun, lFun, sFun) => dFun): String = getSignature(List(StringFun, BooleanFun, LongFun, StringFun), DoubleFun)
  def getSignatureStringBooleanLongBoolean2Double(f: (sFun, bFun, lFun, bFun) => dFun): String = getSignature(List(StringFun, BooleanFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureStringBooleanDoubleInt2Double(f: (sFun, bFun, dFun, iFun) => dFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureStringBooleanDoubleLong2Double(f: (sFun, bFun, dFun, lFun) => dFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureStringBooleanDoubleDouble2Double(f: (sFun, bFun, dFun, dFun) => dFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureStringBooleanDoubleString2Double(f: (sFun, bFun, dFun, sFun) => dFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureStringBooleanDoubleBoolean2Double(f: (sFun, bFun, dFun, bFun) => dFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureStringBooleanStringInt2Double(f: (sFun, bFun, sFun, iFun) => dFun): String = getSignature(List(StringFun, BooleanFun, StringFun, IntFun), DoubleFun)
  def getSignatureStringBooleanStringLong2Double(f: (sFun, bFun, sFun, lFun) => dFun): String = getSignature(List(StringFun, BooleanFun, StringFun, LongFun), DoubleFun)
  def getSignatureStringBooleanStringDouble2Double(f: (sFun, bFun, sFun, dFun) => dFun): String = getSignature(List(StringFun, BooleanFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureStringBooleanStringString2Double(f: (sFun, bFun, sFun, sFun) => dFun): String = getSignature(List(StringFun, BooleanFun, StringFun, StringFun), DoubleFun)
  def getSignatureStringBooleanStringBoolean2Double(f: (sFun, bFun, sFun, bFun) => dFun): String = getSignature(List(StringFun, BooleanFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureStringBooleanBooleanInt2Double(f: (sFun, bFun, bFun, iFun) => dFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureStringBooleanBooleanLong2Double(f: (sFun, bFun, bFun, lFun) => dFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureStringBooleanBooleanDouble2Double(f: (sFun, bFun, bFun, dFun) => dFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureStringBooleanBooleanString2Double(f: (sFun, bFun, bFun, sFun) => dFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureStringBooleanBooleanBoolean2Double(f: (sFun, bFun, bFun, bFun) => dFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureBooleanIntIntInt2Double(f: (bFun, iFun, iFun, iFun) => dFun): String = getSignature(List(BooleanFun, IntFun, IntFun, IntFun), DoubleFun)
  def getSignatureBooleanIntIntLong2Double(f: (bFun, iFun, iFun, lFun) => dFun): String = getSignature(List(BooleanFun, IntFun, IntFun, LongFun), DoubleFun)
  def getSignatureBooleanIntIntDouble2Double(f: (bFun, iFun, iFun, dFun) => dFun): String = getSignature(List(BooleanFun, IntFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureBooleanIntIntString2Double(f: (bFun, iFun, iFun, sFun) => dFun): String = getSignature(List(BooleanFun, IntFun, IntFun, StringFun), DoubleFun)
  def getSignatureBooleanIntIntBoolean2Double(f: (bFun, iFun, iFun, bFun) => dFun): String = getSignature(List(BooleanFun, IntFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureBooleanIntLongInt2Double(f: (bFun, iFun, lFun, iFun) => dFun): String = getSignature(List(BooleanFun, IntFun, LongFun, IntFun), DoubleFun)
  def getSignatureBooleanIntLongLong2Double(f: (bFun, iFun, lFun, lFun) => dFun): String = getSignature(List(BooleanFun, IntFun, LongFun, LongFun), DoubleFun)
  def getSignatureBooleanIntLongDouble2Double(f: (bFun, iFun, lFun, dFun) => dFun): String = getSignature(List(BooleanFun, IntFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureBooleanIntLongString2Double(f: (bFun, iFun, lFun, sFun) => dFun): String = getSignature(List(BooleanFun, IntFun, LongFun, StringFun), DoubleFun)
  def getSignatureBooleanIntLongBoolean2Double(f: (bFun, iFun, lFun, bFun) => dFun): String = getSignature(List(BooleanFun, IntFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureBooleanIntDoubleInt2Double(f: (bFun, iFun, dFun, iFun) => dFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureBooleanIntDoubleLong2Double(f: (bFun, iFun, dFun, lFun) => dFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureBooleanIntDoubleDouble2Double(f: (bFun, iFun, dFun, dFun) => dFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureBooleanIntDoubleString2Double(f: (bFun, iFun, dFun, sFun) => dFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureBooleanIntDoubleBoolean2Double(f: (bFun, iFun, dFun, bFun) => dFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureBooleanIntStringInt2Double(f: (bFun, iFun, sFun, iFun) => dFun): String = getSignature(List(BooleanFun, IntFun, StringFun, IntFun), DoubleFun)
  def getSignatureBooleanIntStringLong2Double(f: (bFun, iFun, sFun, lFun) => dFun): String = getSignature(List(BooleanFun, IntFun, StringFun, LongFun), DoubleFun)
  def getSignatureBooleanIntStringDouble2Double(f: (bFun, iFun, sFun, dFun) => dFun): String = getSignature(List(BooleanFun, IntFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureBooleanIntStringString2Double(f: (bFun, iFun, sFun, sFun) => dFun): String = getSignature(List(BooleanFun, IntFun, StringFun, StringFun), DoubleFun)
  def getSignatureBooleanIntStringBoolean2Double(f: (bFun, iFun, sFun, bFun) => dFun): String = getSignature(List(BooleanFun, IntFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureBooleanIntBooleanInt2Double(f: (bFun, iFun, bFun, iFun) => dFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureBooleanIntBooleanLong2Double(f: (bFun, iFun, bFun, lFun) => dFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureBooleanIntBooleanDouble2Double(f: (bFun, iFun, bFun, dFun) => dFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureBooleanIntBooleanString2Double(f: (bFun, iFun, bFun, sFun) => dFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureBooleanIntBooleanBoolean2Double(f: (bFun, iFun, bFun, bFun) => dFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureBooleanLongIntInt2Double(f: (bFun, lFun, iFun, iFun) => dFun): String = getSignature(List(BooleanFun, LongFun, IntFun, IntFun), DoubleFun)
  def getSignatureBooleanLongIntLong2Double(f: (bFun, lFun, iFun, lFun) => dFun): String = getSignature(List(BooleanFun, LongFun, IntFun, LongFun), DoubleFun)
  def getSignatureBooleanLongIntDouble2Double(f: (bFun, lFun, iFun, dFun) => dFun): String = getSignature(List(BooleanFun, LongFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureBooleanLongIntString2Double(f: (bFun, lFun, iFun, sFun) => dFun): String = getSignature(List(BooleanFun, LongFun, IntFun, StringFun), DoubleFun)
  def getSignatureBooleanLongIntBoolean2Double(f: (bFun, lFun, iFun, bFun) => dFun): String = getSignature(List(BooleanFun, LongFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureBooleanLongLongInt2Double(f: (bFun, lFun, lFun, iFun) => dFun): String = getSignature(List(BooleanFun, LongFun, LongFun, IntFun), DoubleFun)
  def getSignatureBooleanLongLongLong2Double(f: (bFun, lFun, lFun, lFun) => dFun): String = getSignature(List(BooleanFun, LongFun, LongFun, LongFun), DoubleFun)
  def getSignatureBooleanLongLongDouble2Double(f: (bFun, lFun, lFun, dFun) => dFun): String = getSignature(List(BooleanFun, LongFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureBooleanLongLongString2Double(f: (bFun, lFun, lFun, sFun) => dFun): String = getSignature(List(BooleanFun, LongFun, LongFun, StringFun), DoubleFun)
  def getSignatureBooleanLongLongBoolean2Double(f: (bFun, lFun, lFun, bFun) => dFun): String = getSignature(List(BooleanFun, LongFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureBooleanLongDoubleInt2Double(f: (bFun, lFun, dFun, iFun) => dFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureBooleanLongDoubleLong2Double(f: (bFun, lFun, dFun, lFun) => dFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureBooleanLongDoubleDouble2Double(f: (bFun, lFun, dFun, dFun) => dFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureBooleanLongDoubleString2Double(f: (bFun, lFun, dFun, sFun) => dFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureBooleanLongDoubleBoolean2Double(f: (bFun, lFun, dFun, bFun) => dFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureBooleanLongStringInt2Double(f: (bFun, lFun, sFun, iFun) => dFun): String = getSignature(List(BooleanFun, LongFun, StringFun, IntFun), DoubleFun)
  def getSignatureBooleanLongStringLong2Double(f: (bFun, lFun, sFun, lFun) => dFun): String = getSignature(List(BooleanFun, LongFun, StringFun, LongFun), DoubleFun)
  def getSignatureBooleanLongStringDouble2Double(f: (bFun, lFun, sFun, dFun) => dFun): String = getSignature(List(BooleanFun, LongFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureBooleanLongStringString2Double(f: (bFun, lFun, sFun, sFun) => dFun): String = getSignature(List(BooleanFun, LongFun, StringFun, StringFun), DoubleFun)
  def getSignatureBooleanLongStringBoolean2Double(f: (bFun, lFun, sFun, bFun) => dFun): String = getSignature(List(BooleanFun, LongFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureBooleanLongBooleanInt2Double(f: (bFun, lFun, bFun, iFun) => dFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureBooleanLongBooleanLong2Double(f: (bFun, lFun, bFun, lFun) => dFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureBooleanLongBooleanDouble2Double(f: (bFun, lFun, bFun, dFun) => dFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureBooleanLongBooleanString2Double(f: (bFun, lFun, bFun, sFun) => dFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureBooleanLongBooleanBoolean2Double(f: (bFun, lFun, bFun, bFun) => dFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureBooleanDoubleIntInt2Double(f: (bFun, dFun, iFun, iFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, IntFun), DoubleFun)
  def getSignatureBooleanDoubleIntLong2Double(f: (bFun, dFun, iFun, lFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, LongFun), DoubleFun)
  def getSignatureBooleanDoubleIntDouble2Double(f: (bFun, dFun, iFun, dFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureBooleanDoubleIntString2Double(f: (bFun, dFun, iFun, sFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, StringFun), DoubleFun)
  def getSignatureBooleanDoubleIntBoolean2Double(f: (bFun, dFun, iFun, bFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureBooleanDoubleLongInt2Double(f: (bFun, dFun, lFun, iFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, IntFun), DoubleFun)
  def getSignatureBooleanDoubleLongLong2Double(f: (bFun, dFun, lFun, lFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, LongFun), DoubleFun)
  def getSignatureBooleanDoubleLongDouble2Double(f: (bFun, dFun, lFun, dFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureBooleanDoubleLongString2Double(f: (bFun, dFun, lFun, sFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, StringFun), DoubleFun)
  def getSignatureBooleanDoubleLongBoolean2Double(f: (bFun, dFun, lFun, bFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureBooleanDoubleDoubleInt2Double(f: (bFun, dFun, dFun, iFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureBooleanDoubleDoubleLong2Double(f: (bFun, dFun, dFun, lFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureBooleanDoubleDoubleDouble2Double(f: (bFun, dFun, dFun, dFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureBooleanDoubleDoubleString2Double(f: (bFun, dFun, dFun, sFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureBooleanDoubleDoubleBoolean2Double(f: (bFun, dFun, dFun, bFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureBooleanDoubleStringInt2Double(f: (bFun, dFun, sFun, iFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, IntFun), DoubleFun)
  def getSignatureBooleanDoubleStringLong2Double(f: (bFun, dFun, sFun, lFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, LongFun), DoubleFun)
  def getSignatureBooleanDoubleStringDouble2Double(f: (bFun, dFun, sFun, dFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureBooleanDoubleStringString2Double(f: (bFun, dFun, sFun, sFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, StringFun), DoubleFun)
  def getSignatureBooleanDoubleStringBoolean2Double(f: (bFun, dFun, sFun, bFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureBooleanDoubleBooleanInt2Double(f: (bFun, dFun, bFun, iFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureBooleanDoubleBooleanLong2Double(f: (bFun, dFun, bFun, lFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureBooleanDoubleBooleanDouble2Double(f: (bFun, dFun, bFun, dFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureBooleanDoubleBooleanString2Double(f: (bFun, dFun, bFun, sFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureBooleanDoubleBooleanBoolean2Double(f: (bFun, dFun, bFun, bFun) => dFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureBooleanStringIntInt2Double(f: (bFun, sFun, iFun, iFun) => dFun): String = getSignature(List(BooleanFun, StringFun, IntFun, IntFun), DoubleFun)
  def getSignatureBooleanStringIntLong2Double(f: (bFun, sFun, iFun, lFun) => dFun): String = getSignature(List(BooleanFun, StringFun, IntFun, LongFun), DoubleFun)
  def getSignatureBooleanStringIntDouble2Double(f: (bFun, sFun, iFun, dFun) => dFun): String = getSignature(List(BooleanFun, StringFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureBooleanStringIntString2Double(f: (bFun, sFun, iFun, sFun) => dFun): String = getSignature(List(BooleanFun, StringFun, IntFun, StringFun), DoubleFun)
  def getSignatureBooleanStringIntBoolean2Double(f: (bFun, sFun, iFun, bFun) => dFun): String = getSignature(List(BooleanFun, StringFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureBooleanStringLongInt2Double(f: (bFun, sFun, lFun, iFun) => dFun): String = getSignature(List(BooleanFun, StringFun, LongFun, IntFun), DoubleFun)
  def getSignatureBooleanStringLongLong2Double(f: (bFun, sFun, lFun, lFun) => dFun): String = getSignature(List(BooleanFun, StringFun, LongFun, LongFun), DoubleFun)
  def getSignatureBooleanStringLongDouble2Double(f: (bFun, sFun, lFun, dFun) => dFun): String = getSignature(List(BooleanFun, StringFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureBooleanStringLongString2Double(f: (bFun, sFun, lFun, sFun) => dFun): String = getSignature(List(BooleanFun, StringFun, LongFun, StringFun), DoubleFun)
  def getSignatureBooleanStringLongBoolean2Double(f: (bFun, sFun, lFun, bFun) => dFun): String = getSignature(List(BooleanFun, StringFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureBooleanStringDoubleInt2Double(f: (bFun, sFun, dFun, iFun) => dFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureBooleanStringDoubleLong2Double(f: (bFun, sFun, dFun, lFun) => dFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureBooleanStringDoubleDouble2Double(f: (bFun, sFun, dFun, dFun) => dFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureBooleanStringDoubleString2Double(f: (bFun, sFun, dFun, sFun) => dFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureBooleanStringDoubleBoolean2Double(f: (bFun, sFun, dFun, bFun) => dFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureBooleanStringStringInt2Double(f: (bFun, sFun, sFun, iFun) => dFun): String = getSignature(List(BooleanFun, StringFun, StringFun, IntFun), DoubleFun)
  def getSignatureBooleanStringStringLong2Double(f: (bFun, sFun, sFun, lFun) => dFun): String = getSignature(List(BooleanFun, StringFun, StringFun, LongFun), DoubleFun)
  def getSignatureBooleanStringStringDouble2Double(f: (bFun, sFun, sFun, dFun) => dFun): String = getSignature(List(BooleanFun, StringFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureBooleanStringStringString2Double(f: (bFun, sFun, sFun, sFun) => dFun): String = getSignature(List(BooleanFun, StringFun, StringFun, StringFun), DoubleFun)
  def getSignatureBooleanStringStringBoolean2Double(f: (bFun, sFun, sFun, bFun) => dFun): String = getSignature(List(BooleanFun, StringFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureBooleanStringBooleanInt2Double(f: (bFun, sFun, bFun, iFun) => dFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureBooleanStringBooleanLong2Double(f: (bFun, sFun, bFun, lFun) => dFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureBooleanStringBooleanDouble2Double(f: (bFun, sFun, bFun, dFun) => dFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureBooleanStringBooleanString2Double(f: (bFun, sFun, bFun, sFun) => dFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureBooleanStringBooleanBoolean2Double(f: (bFun, sFun, bFun, bFun) => dFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureBooleanBooleanIntInt2Double(f: (bFun, bFun, iFun, iFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, IntFun), DoubleFun)
  def getSignatureBooleanBooleanIntLong2Double(f: (bFun, bFun, iFun, lFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, LongFun), DoubleFun)
  def getSignatureBooleanBooleanIntDouble2Double(f: (bFun, bFun, iFun, dFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, DoubleFun), DoubleFun)
  def getSignatureBooleanBooleanIntString2Double(f: (bFun, bFun, iFun, sFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, StringFun), DoubleFun)
  def getSignatureBooleanBooleanIntBoolean2Double(f: (bFun, bFun, iFun, bFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, BooleanFun), DoubleFun)
  def getSignatureBooleanBooleanLongInt2Double(f: (bFun, bFun, lFun, iFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, IntFun), DoubleFun)
  def getSignatureBooleanBooleanLongLong2Double(f: (bFun, bFun, lFun, lFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, LongFun), DoubleFun)
  def getSignatureBooleanBooleanLongDouble2Double(f: (bFun, bFun, lFun, dFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, DoubleFun), DoubleFun)
  def getSignatureBooleanBooleanLongString2Double(f: (bFun, bFun, lFun, sFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, StringFun), DoubleFun)
  def getSignatureBooleanBooleanLongBoolean2Double(f: (bFun, bFun, lFun, bFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, BooleanFun), DoubleFun)
  def getSignatureBooleanBooleanDoubleInt2Double(f: (bFun, bFun, dFun, iFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, IntFun), DoubleFun)
  def getSignatureBooleanBooleanDoubleLong2Double(f: (bFun, bFun, dFun, lFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, LongFun), DoubleFun)
  def getSignatureBooleanBooleanDoubleDouble2Double(f: (bFun, bFun, dFun, dFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, DoubleFun), DoubleFun)
  def getSignatureBooleanBooleanDoubleString2Double(f: (bFun, bFun, dFun, sFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, StringFun), DoubleFun)
  def getSignatureBooleanBooleanDoubleBoolean2Double(f: (bFun, bFun, dFun, bFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, BooleanFun), DoubleFun)
  def getSignatureBooleanBooleanStringInt2Double(f: (bFun, bFun, sFun, iFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, IntFun), DoubleFun)
  def getSignatureBooleanBooleanStringLong2Double(f: (bFun, bFun, sFun, lFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, LongFun), DoubleFun)
  def getSignatureBooleanBooleanStringDouble2Double(f: (bFun, bFun, sFun, dFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, DoubleFun), DoubleFun)
  def getSignatureBooleanBooleanStringString2Double(f: (bFun, bFun, sFun, sFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, StringFun), DoubleFun)
  def getSignatureBooleanBooleanStringBoolean2Double(f: (bFun, bFun, sFun, bFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, BooleanFun), DoubleFun)
  def getSignatureBooleanBooleanBooleanInt2Double(f: (bFun, bFun, bFun, iFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, IntFun), DoubleFun)
  def getSignatureBooleanBooleanBooleanLong2Double(f: (bFun, bFun, bFun, lFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, LongFun), DoubleFun)
  def getSignatureBooleanBooleanBooleanDouble2Double(f: (bFun, bFun, bFun, dFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, DoubleFun), DoubleFun)
  def getSignatureBooleanBooleanBooleanString2Double(f: (bFun, bFun, bFun, sFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, StringFun), DoubleFun)
  def getSignatureBooleanBooleanBooleanBoolean2Double(f: (bFun, bFun, bFun, bFun) => dFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, BooleanFun), DoubleFun)
  def getSignatureIntIntIntInt2String(f: (iFun, iFun, iFun, iFun) => sFun): String = getSignature(List(IntFun, IntFun, IntFun, IntFun), StringFun)
  def getSignatureIntIntIntLong2String(f: (iFun, iFun, iFun, lFun) => sFun): String = getSignature(List(IntFun, IntFun, IntFun, LongFun), StringFun)
  def getSignatureIntIntIntDouble2String(f: (iFun, iFun, iFun, dFun) => sFun): String = getSignature(List(IntFun, IntFun, IntFun, DoubleFun), StringFun)
  def getSignatureIntIntIntString2String(f: (iFun, iFun, iFun, sFun) => sFun): String = getSignature(List(IntFun, IntFun, IntFun, StringFun), StringFun)
  def getSignatureIntIntIntBoolean2String(f: (iFun, iFun, iFun, bFun) => sFun): String = getSignature(List(IntFun, IntFun, IntFun, BooleanFun), StringFun)
  def getSignatureIntIntLongInt2String(f: (iFun, iFun, lFun, iFun) => sFun): String = getSignature(List(IntFun, IntFun, LongFun, IntFun), StringFun)
  def getSignatureIntIntLongLong2String(f: (iFun, iFun, lFun, lFun) => sFun): String = getSignature(List(IntFun, IntFun, LongFun, LongFun), StringFun)
  def getSignatureIntIntLongDouble2String(f: (iFun, iFun, lFun, dFun) => sFun): String = getSignature(List(IntFun, IntFun, LongFun, DoubleFun), StringFun)
  def getSignatureIntIntLongString2String(f: (iFun, iFun, lFun, sFun) => sFun): String = getSignature(List(IntFun, IntFun, LongFun, StringFun), StringFun)
  def getSignatureIntIntLongBoolean2String(f: (iFun, iFun, lFun, bFun) => sFun): String = getSignature(List(IntFun, IntFun, LongFun, BooleanFun), StringFun)
  def getSignatureIntIntDoubleInt2String(f: (iFun, iFun, dFun, iFun) => sFun): String = getSignature(List(IntFun, IntFun, DoubleFun, IntFun), StringFun)
  def getSignatureIntIntDoubleLong2String(f: (iFun, iFun, dFun, lFun) => sFun): String = getSignature(List(IntFun, IntFun, DoubleFun, LongFun), StringFun)
  def getSignatureIntIntDoubleDouble2String(f: (iFun, iFun, dFun, dFun) => sFun): String = getSignature(List(IntFun, IntFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureIntIntDoubleString2String(f: (iFun, iFun, dFun, sFun) => sFun): String = getSignature(List(IntFun, IntFun, DoubleFun, StringFun), StringFun)
  def getSignatureIntIntDoubleBoolean2String(f: (iFun, iFun, dFun, bFun) => sFun): String = getSignature(List(IntFun, IntFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureIntIntStringInt2String(f: (iFun, iFun, sFun, iFun) => sFun): String = getSignature(List(IntFun, IntFun, StringFun, IntFun), StringFun)
  def getSignatureIntIntStringLong2String(f: (iFun, iFun, sFun, lFun) => sFun): String = getSignature(List(IntFun, IntFun, StringFun, LongFun), StringFun)
  def getSignatureIntIntStringDouble2String(f: (iFun, iFun, sFun, dFun) => sFun): String = getSignature(List(IntFun, IntFun, StringFun, DoubleFun), StringFun)
  def getSignatureIntIntStringString2String(f: (iFun, iFun, sFun, sFun) => sFun): String = getSignature(List(IntFun, IntFun, StringFun, StringFun), StringFun)
  def getSignatureIntIntStringBoolean2String(f: (iFun, iFun, sFun, bFun) => sFun): String = getSignature(List(IntFun, IntFun, StringFun, BooleanFun), StringFun)
  def getSignatureIntIntBooleanInt2String(f: (iFun, iFun, bFun, iFun) => sFun): String = getSignature(List(IntFun, IntFun, BooleanFun, IntFun), StringFun)
  def getSignatureIntIntBooleanLong2String(f: (iFun, iFun, bFun, lFun) => sFun): String = getSignature(List(IntFun, IntFun, BooleanFun, LongFun), StringFun)
  def getSignatureIntIntBooleanDouble2String(f: (iFun, iFun, bFun, dFun) => sFun): String = getSignature(List(IntFun, IntFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureIntIntBooleanString2String(f: (iFun, iFun, bFun, sFun) => sFun): String = getSignature(List(IntFun, IntFun, BooleanFun, StringFun), StringFun)
  def getSignatureIntIntBooleanBoolean2String(f: (iFun, iFun, bFun, bFun) => sFun): String = getSignature(List(IntFun, IntFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureIntLongIntInt2String(f: (iFun, lFun, iFun, iFun) => sFun): String = getSignature(List(IntFun, LongFun, IntFun, IntFun), StringFun)
  def getSignatureIntLongIntLong2String(f: (iFun, lFun, iFun, lFun) => sFun): String = getSignature(List(IntFun, LongFun, IntFun, LongFun), StringFun)
  def getSignatureIntLongIntDouble2String(f: (iFun, lFun, iFun, dFun) => sFun): String = getSignature(List(IntFun, LongFun, IntFun, DoubleFun), StringFun)
  def getSignatureIntLongIntString2String(f: (iFun, lFun, iFun, sFun) => sFun): String = getSignature(List(IntFun, LongFun, IntFun, StringFun), StringFun)
  def getSignatureIntLongIntBoolean2String(f: (iFun, lFun, iFun, bFun) => sFun): String = getSignature(List(IntFun, LongFun, IntFun, BooleanFun), StringFun)
  def getSignatureIntLongLongInt2String(f: (iFun, lFun, lFun, iFun) => sFun): String = getSignature(List(IntFun, LongFun, LongFun, IntFun), StringFun)
  def getSignatureIntLongLongLong2String(f: (iFun, lFun, lFun, lFun) => sFun): String = getSignature(List(IntFun, LongFun, LongFun, LongFun), StringFun)
  def getSignatureIntLongLongDouble2String(f: (iFun, lFun, lFun, dFun) => sFun): String = getSignature(List(IntFun, LongFun, LongFun, DoubleFun), StringFun)
  def getSignatureIntLongLongString2String(f: (iFun, lFun, lFun, sFun) => sFun): String = getSignature(List(IntFun, LongFun, LongFun, StringFun), StringFun)
  def getSignatureIntLongLongBoolean2String(f: (iFun, lFun, lFun, bFun) => sFun): String = getSignature(List(IntFun, LongFun, LongFun, BooleanFun), StringFun)
  def getSignatureIntLongDoubleInt2String(f: (iFun, lFun, dFun, iFun) => sFun): String = getSignature(List(IntFun, LongFun, DoubleFun, IntFun), StringFun)
  def getSignatureIntLongDoubleLong2String(f: (iFun, lFun, dFun, lFun) => sFun): String = getSignature(List(IntFun, LongFun, DoubleFun, LongFun), StringFun)
  def getSignatureIntLongDoubleDouble2String(f: (iFun, lFun, dFun, dFun) => sFun): String = getSignature(List(IntFun, LongFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureIntLongDoubleString2String(f: (iFun, lFun, dFun, sFun) => sFun): String = getSignature(List(IntFun, LongFun, DoubleFun, StringFun), StringFun)
  def getSignatureIntLongDoubleBoolean2String(f: (iFun, lFun, dFun, bFun) => sFun): String = getSignature(List(IntFun, LongFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureIntLongStringInt2String(f: (iFun, lFun, sFun, iFun) => sFun): String = getSignature(List(IntFun, LongFun, StringFun, IntFun), StringFun)
  def getSignatureIntLongStringLong2String(f: (iFun, lFun, sFun, lFun) => sFun): String = getSignature(List(IntFun, LongFun, StringFun, LongFun), StringFun)
  def getSignatureIntLongStringDouble2String(f: (iFun, lFun, sFun, dFun) => sFun): String = getSignature(List(IntFun, LongFun, StringFun, DoubleFun), StringFun)
  def getSignatureIntLongStringString2String(f: (iFun, lFun, sFun, sFun) => sFun): String = getSignature(List(IntFun, LongFun, StringFun, StringFun), StringFun)
  def getSignatureIntLongStringBoolean2String(f: (iFun, lFun, sFun, bFun) => sFun): String = getSignature(List(IntFun, LongFun, StringFun, BooleanFun), StringFun)
  def getSignatureIntLongBooleanInt2String(f: (iFun, lFun, bFun, iFun) => sFun): String = getSignature(List(IntFun, LongFun, BooleanFun, IntFun), StringFun)
  def getSignatureIntLongBooleanLong2String(f: (iFun, lFun, bFun, lFun) => sFun): String = getSignature(List(IntFun, LongFun, BooleanFun, LongFun), StringFun)
  def getSignatureIntLongBooleanDouble2String(f: (iFun, lFun, bFun, dFun) => sFun): String = getSignature(List(IntFun, LongFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureIntLongBooleanString2String(f: (iFun, lFun, bFun, sFun) => sFun): String = getSignature(List(IntFun, LongFun, BooleanFun, StringFun), StringFun)
  def getSignatureIntLongBooleanBoolean2String(f: (iFun, lFun, bFun, bFun) => sFun): String = getSignature(List(IntFun, LongFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureIntDoubleIntInt2String(f: (iFun, dFun, iFun, iFun) => sFun): String = getSignature(List(IntFun, DoubleFun, IntFun, IntFun), StringFun)
  def getSignatureIntDoubleIntLong2String(f: (iFun, dFun, iFun, lFun) => sFun): String = getSignature(List(IntFun, DoubleFun, IntFun, LongFun), StringFun)
  def getSignatureIntDoubleIntDouble2String(f: (iFun, dFun, iFun, dFun) => sFun): String = getSignature(List(IntFun, DoubleFun, IntFun, DoubleFun), StringFun)
  def getSignatureIntDoubleIntString2String(f: (iFun, dFun, iFun, sFun) => sFun): String = getSignature(List(IntFun, DoubleFun, IntFun, StringFun), StringFun)
  def getSignatureIntDoubleIntBoolean2String(f: (iFun, dFun, iFun, bFun) => sFun): String = getSignature(List(IntFun, DoubleFun, IntFun, BooleanFun), StringFun)
  def getSignatureIntDoubleLongInt2String(f: (iFun, dFun, lFun, iFun) => sFun): String = getSignature(List(IntFun, DoubleFun, LongFun, IntFun), StringFun)
  def getSignatureIntDoubleLongLong2String(f: (iFun, dFun, lFun, lFun) => sFun): String = getSignature(List(IntFun, DoubleFun, LongFun, LongFun), StringFun)
  def getSignatureIntDoubleLongDouble2String(f: (iFun, dFun, lFun, dFun) => sFun): String = getSignature(List(IntFun, DoubleFun, LongFun, DoubleFun), StringFun)
  def getSignatureIntDoubleLongString2String(f: (iFun, dFun, lFun, sFun) => sFun): String = getSignature(List(IntFun, DoubleFun, LongFun, StringFun), StringFun)
  def getSignatureIntDoubleLongBoolean2String(f: (iFun, dFun, lFun, bFun) => sFun): String = getSignature(List(IntFun, DoubleFun, LongFun, BooleanFun), StringFun)
  def getSignatureIntDoubleDoubleInt2String(f: (iFun, dFun, dFun, iFun) => sFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, IntFun), StringFun)
  def getSignatureIntDoubleDoubleLong2String(f: (iFun, dFun, dFun, lFun) => sFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, LongFun), StringFun)
  def getSignatureIntDoubleDoubleDouble2String(f: (iFun, dFun, dFun, dFun) => sFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureIntDoubleDoubleString2String(f: (iFun, dFun, dFun, sFun) => sFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, StringFun), StringFun)
  def getSignatureIntDoubleDoubleBoolean2String(f: (iFun, dFun, dFun, bFun) => sFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureIntDoubleStringInt2String(f: (iFun, dFun, sFun, iFun) => sFun): String = getSignature(List(IntFun, DoubleFun, StringFun, IntFun), StringFun)
  def getSignatureIntDoubleStringLong2String(f: (iFun, dFun, sFun, lFun) => sFun): String = getSignature(List(IntFun, DoubleFun, StringFun, LongFun), StringFun)
  def getSignatureIntDoubleStringDouble2String(f: (iFun, dFun, sFun, dFun) => sFun): String = getSignature(List(IntFun, DoubleFun, StringFun, DoubleFun), StringFun)
  def getSignatureIntDoubleStringString2String(f: (iFun, dFun, sFun, sFun) => sFun): String = getSignature(List(IntFun, DoubleFun, StringFun, StringFun), StringFun)
  def getSignatureIntDoubleStringBoolean2String(f: (iFun, dFun, sFun, bFun) => sFun): String = getSignature(List(IntFun, DoubleFun, StringFun, BooleanFun), StringFun)
  def getSignatureIntDoubleBooleanInt2String(f: (iFun, dFun, bFun, iFun) => sFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, IntFun), StringFun)
  def getSignatureIntDoubleBooleanLong2String(f: (iFun, dFun, bFun, lFun) => sFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, LongFun), StringFun)
  def getSignatureIntDoubleBooleanDouble2String(f: (iFun, dFun, bFun, dFun) => sFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureIntDoubleBooleanString2String(f: (iFun, dFun, bFun, sFun) => sFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, StringFun), StringFun)
  def getSignatureIntDoubleBooleanBoolean2String(f: (iFun, dFun, bFun, bFun) => sFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureIntStringIntInt2String(f: (iFun, sFun, iFun, iFun) => sFun): String = getSignature(List(IntFun, StringFun, IntFun, IntFun), StringFun)
  def getSignatureIntStringIntLong2String(f: (iFun, sFun, iFun, lFun) => sFun): String = getSignature(List(IntFun, StringFun, IntFun, LongFun), StringFun)
  def getSignatureIntStringIntDouble2String(f: (iFun, sFun, iFun, dFun) => sFun): String = getSignature(List(IntFun, StringFun, IntFun, DoubleFun), StringFun)
  def getSignatureIntStringIntString2String(f: (iFun, sFun, iFun, sFun) => sFun): String = getSignature(List(IntFun, StringFun, IntFun, StringFun), StringFun)
  def getSignatureIntStringIntBoolean2String(f: (iFun, sFun, iFun, bFun) => sFun): String = getSignature(List(IntFun, StringFun, IntFun, BooleanFun), StringFun)
  def getSignatureIntStringLongInt2String(f: (iFun, sFun, lFun, iFun) => sFun): String = getSignature(List(IntFun, StringFun, LongFun, IntFun), StringFun)
  def getSignatureIntStringLongLong2String(f: (iFun, sFun, lFun, lFun) => sFun): String = getSignature(List(IntFun, StringFun, LongFun, LongFun), StringFun)
  def getSignatureIntStringLongDouble2String(f: (iFun, sFun, lFun, dFun) => sFun): String = getSignature(List(IntFun, StringFun, LongFun, DoubleFun), StringFun)
  def getSignatureIntStringLongString2String(f: (iFun, sFun, lFun, sFun) => sFun): String = getSignature(List(IntFun, StringFun, LongFun, StringFun), StringFun)
  def getSignatureIntStringLongBoolean2String(f: (iFun, sFun, lFun, bFun) => sFun): String = getSignature(List(IntFun, StringFun, LongFun, BooleanFun), StringFun)
  def getSignatureIntStringDoubleInt2String(f: (iFun, sFun, dFun, iFun) => sFun): String = getSignature(List(IntFun, StringFun, DoubleFun, IntFun), StringFun)
  def getSignatureIntStringDoubleLong2String(f: (iFun, sFun, dFun, lFun) => sFun): String = getSignature(List(IntFun, StringFun, DoubleFun, LongFun), StringFun)
  def getSignatureIntStringDoubleDouble2String(f: (iFun, sFun, dFun, dFun) => sFun): String = getSignature(List(IntFun, StringFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureIntStringDoubleString2String(f: (iFun, sFun, dFun, sFun) => sFun): String = getSignature(List(IntFun, StringFun, DoubleFun, StringFun), StringFun)
  def getSignatureIntStringDoubleBoolean2String(f: (iFun, sFun, dFun, bFun) => sFun): String = getSignature(List(IntFun, StringFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureIntStringStringInt2String(f: (iFun, sFun, sFun, iFun) => sFun): String = getSignature(List(IntFun, StringFun, StringFun, IntFun), StringFun)
  def getSignatureIntStringStringLong2String(f: (iFun, sFun, sFun, lFun) => sFun): String = getSignature(List(IntFun, StringFun, StringFun, LongFun), StringFun)
  def getSignatureIntStringStringDouble2String(f: (iFun, sFun, sFun, dFun) => sFun): String = getSignature(List(IntFun, StringFun, StringFun, DoubleFun), StringFun)
  def getSignatureIntStringStringString2String(f: (iFun, sFun, sFun, sFun) => sFun): String = getSignature(List(IntFun, StringFun, StringFun, StringFun), StringFun)
  def getSignatureIntStringStringBoolean2String(f: (iFun, sFun, sFun, bFun) => sFun): String = getSignature(List(IntFun, StringFun, StringFun, BooleanFun), StringFun)
  def getSignatureIntStringBooleanInt2String(f: (iFun, sFun, bFun, iFun) => sFun): String = getSignature(List(IntFun, StringFun, BooleanFun, IntFun), StringFun)
  def getSignatureIntStringBooleanLong2String(f: (iFun, sFun, bFun, lFun) => sFun): String = getSignature(List(IntFun, StringFun, BooleanFun, LongFun), StringFun)
  def getSignatureIntStringBooleanDouble2String(f: (iFun, sFun, bFun, dFun) => sFun): String = getSignature(List(IntFun, StringFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureIntStringBooleanString2String(f: (iFun, sFun, bFun, sFun) => sFun): String = getSignature(List(IntFun, StringFun, BooleanFun, StringFun), StringFun)
  def getSignatureIntStringBooleanBoolean2String(f: (iFun, sFun, bFun, bFun) => sFun): String = getSignature(List(IntFun, StringFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureIntBooleanIntInt2String(f: (iFun, bFun, iFun, iFun) => sFun): String = getSignature(List(IntFun, BooleanFun, IntFun, IntFun), StringFun)
  def getSignatureIntBooleanIntLong2String(f: (iFun, bFun, iFun, lFun) => sFun): String = getSignature(List(IntFun, BooleanFun, IntFun, LongFun), StringFun)
  def getSignatureIntBooleanIntDouble2String(f: (iFun, bFun, iFun, dFun) => sFun): String = getSignature(List(IntFun, BooleanFun, IntFun, DoubleFun), StringFun)
  def getSignatureIntBooleanIntString2String(f: (iFun, bFun, iFun, sFun) => sFun): String = getSignature(List(IntFun, BooleanFun, IntFun, StringFun), StringFun)
  def getSignatureIntBooleanIntBoolean2String(f: (iFun, bFun, iFun, bFun) => sFun): String = getSignature(List(IntFun, BooleanFun, IntFun, BooleanFun), StringFun)
  def getSignatureIntBooleanLongInt2String(f: (iFun, bFun, lFun, iFun) => sFun): String = getSignature(List(IntFun, BooleanFun, LongFun, IntFun), StringFun)
  def getSignatureIntBooleanLongLong2String(f: (iFun, bFun, lFun, lFun) => sFun): String = getSignature(List(IntFun, BooleanFun, LongFun, LongFun), StringFun)
  def getSignatureIntBooleanLongDouble2String(f: (iFun, bFun, lFun, dFun) => sFun): String = getSignature(List(IntFun, BooleanFun, LongFun, DoubleFun), StringFun)
  def getSignatureIntBooleanLongString2String(f: (iFun, bFun, lFun, sFun) => sFun): String = getSignature(List(IntFun, BooleanFun, LongFun, StringFun), StringFun)
  def getSignatureIntBooleanLongBoolean2String(f: (iFun, bFun, lFun, bFun) => sFun): String = getSignature(List(IntFun, BooleanFun, LongFun, BooleanFun), StringFun)
  def getSignatureIntBooleanDoubleInt2String(f: (iFun, bFun, dFun, iFun) => sFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, IntFun), StringFun)
  def getSignatureIntBooleanDoubleLong2String(f: (iFun, bFun, dFun, lFun) => sFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, LongFun), StringFun)
  def getSignatureIntBooleanDoubleDouble2String(f: (iFun, bFun, dFun, dFun) => sFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureIntBooleanDoubleString2String(f: (iFun, bFun, dFun, sFun) => sFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, StringFun), StringFun)
  def getSignatureIntBooleanDoubleBoolean2String(f: (iFun, bFun, dFun, bFun) => sFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureIntBooleanStringInt2String(f: (iFun, bFun, sFun, iFun) => sFun): String = getSignature(List(IntFun, BooleanFun, StringFun, IntFun), StringFun)
  def getSignatureIntBooleanStringLong2String(f: (iFun, bFun, sFun, lFun) => sFun): String = getSignature(List(IntFun, BooleanFun, StringFun, LongFun), StringFun)
  def getSignatureIntBooleanStringDouble2String(f: (iFun, bFun, sFun, dFun) => sFun): String = getSignature(List(IntFun, BooleanFun, StringFun, DoubleFun), StringFun)
  def getSignatureIntBooleanStringString2String(f: (iFun, bFun, sFun, sFun) => sFun): String = getSignature(List(IntFun, BooleanFun, StringFun, StringFun), StringFun)
  def getSignatureIntBooleanStringBoolean2String(f: (iFun, bFun, sFun, bFun) => sFun): String = getSignature(List(IntFun, BooleanFun, StringFun, BooleanFun), StringFun)
  def getSignatureIntBooleanBooleanInt2String(f: (iFun, bFun, bFun, iFun) => sFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, IntFun), StringFun)
  def getSignatureIntBooleanBooleanLong2String(f: (iFun, bFun, bFun, lFun) => sFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, LongFun), StringFun)
  def getSignatureIntBooleanBooleanDouble2String(f: (iFun, bFun, bFun, dFun) => sFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureIntBooleanBooleanString2String(f: (iFun, bFun, bFun, sFun) => sFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, StringFun), StringFun)
  def getSignatureIntBooleanBooleanBoolean2String(f: (iFun, bFun, bFun, bFun) => sFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureLongIntIntInt2String(f: (lFun, iFun, iFun, iFun) => sFun): String = getSignature(List(LongFun, IntFun, IntFun, IntFun), StringFun)
  def getSignatureLongIntIntLong2String(f: (lFun, iFun, iFun, lFun) => sFun): String = getSignature(List(LongFun, IntFun, IntFun, LongFun), StringFun)
  def getSignatureLongIntIntDouble2String(f: (lFun, iFun, iFun, dFun) => sFun): String = getSignature(List(LongFun, IntFun, IntFun, DoubleFun), StringFun)
  def getSignatureLongIntIntString2String(f: (lFun, iFun, iFun, sFun) => sFun): String = getSignature(List(LongFun, IntFun, IntFun, StringFun), StringFun)
  def getSignatureLongIntIntBoolean2String(f: (lFun, iFun, iFun, bFun) => sFun): String = getSignature(List(LongFun, IntFun, IntFun, BooleanFun), StringFun)
  def getSignatureLongIntLongInt2String(f: (lFun, iFun, lFun, iFun) => sFun): String = getSignature(List(LongFun, IntFun, LongFun, IntFun), StringFun)
  def getSignatureLongIntLongLong2String(f: (lFun, iFun, lFun, lFun) => sFun): String = getSignature(List(LongFun, IntFun, LongFun, LongFun), StringFun)
  def getSignatureLongIntLongDouble2String(f: (lFun, iFun, lFun, dFun) => sFun): String = getSignature(List(LongFun, IntFun, LongFun, DoubleFun), StringFun)
  def getSignatureLongIntLongString2String(f: (lFun, iFun, lFun, sFun) => sFun): String = getSignature(List(LongFun, IntFun, LongFun, StringFun), StringFun)
  def getSignatureLongIntLongBoolean2String(f: (lFun, iFun, lFun, bFun) => sFun): String = getSignature(List(LongFun, IntFun, LongFun, BooleanFun), StringFun)
  def getSignatureLongIntDoubleInt2String(f: (lFun, iFun, dFun, iFun) => sFun): String = getSignature(List(LongFun, IntFun, DoubleFun, IntFun), StringFun)
  def getSignatureLongIntDoubleLong2String(f: (lFun, iFun, dFun, lFun) => sFun): String = getSignature(List(LongFun, IntFun, DoubleFun, LongFun), StringFun)
  def getSignatureLongIntDoubleDouble2String(f: (lFun, iFun, dFun, dFun) => sFun): String = getSignature(List(LongFun, IntFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureLongIntDoubleString2String(f: (lFun, iFun, dFun, sFun) => sFun): String = getSignature(List(LongFun, IntFun, DoubleFun, StringFun), StringFun)
  def getSignatureLongIntDoubleBoolean2String(f: (lFun, iFun, dFun, bFun) => sFun): String = getSignature(List(LongFun, IntFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureLongIntStringInt2String(f: (lFun, iFun, sFun, iFun) => sFun): String = getSignature(List(LongFun, IntFun, StringFun, IntFun), StringFun)
  def getSignatureLongIntStringLong2String(f: (lFun, iFun, sFun, lFun) => sFun): String = getSignature(List(LongFun, IntFun, StringFun, LongFun), StringFun)
  def getSignatureLongIntStringDouble2String(f: (lFun, iFun, sFun, dFun) => sFun): String = getSignature(List(LongFun, IntFun, StringFun, DoubleFun), StringFun)
  def getSignatureLongIntStringString2String(f: (lFun, iFun, sFun, sFun) => sFun): String = getSignature(List(LongFun, IntFun, StringFun, StringFun), StringFun)
  def getSignatureLongIntStringBoolean2String(f: (lFun, iFun, sFun, bFun) => sFun): String = getSignature(List(LongFun, IntFun, StringFun, BooleanFun), StringFun)
  def getSignatureLongIntBooleanInt2String(f: (lFun, iFun, bFun, iFun) => sFun): String = getSignature(List(LongFun, IntFun, BooleanFun, IntFun), StringFun)
  def getSignatureLongIntBooleanLong2String(f: (lFun, iFun, bFun, lFun) => sFun): String = getSignature(List(LongFun, IntFun, BooleanFun, LongFun), StringFun)
  def getSignatureLongIntBooleanDouble2String(f: (lFun, iFun, bFun, dFun) => sFun): String = getSignature(List(LongFun, IntFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureLongIntBooleanString2String(f: (lFun, iFun, bFun, sFun) => sFun): String = getSignature(List(LongFun, IntFun, BooleanFun, StringFun), StringFun)
  def getSignatureLongIntBooleanBoolean2String(f: (lFun, iFun, bFun, bFun) => sFun): String = getSignature(List(LongFun, IntFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureLongLongIntInt2String(f: (lFun, lFun, iFun, iFun) => sFun): String = getSignature(List(LongFun, LongFun, IntFun, IntFun), StringFun)
  def getSignatureLongLongIntLong2String(f: (lFun, lFun, iFun, lFun) => sFun): String = getSignature(List(LongFun, LongFun, IntFun, LongFun), StringFun)
  def getSignatureLongLongIntDouble2String(f: (lFun, lFun, iFun, dFun) => sFun): String = getSignature(List(LongFun, LongFun, IntFun, DoubleFun), StringFun)
  def getSignatureLongLongIntString2String(f: (lFun, lFun, iFun, sFun) => sFun): String = getSignature(List(LongFun, LongFun, IntFun, StringFun), StringFun)
  def getSignatureLongLongIntBoolean2String(f: (lFun, lFun, iFun, bFun) => sFun): String = getSignature(List(LongFun, LongFun, IntFun, BooleanFun), StringFun)
  def getSignatureLongLongLongInt2String(f: (lFun, lFun, lFun, iFun) => sFun): String = getSignature(List(LongFun, LongFun, LongFun, IntFun), StringFun)
  def getSignatureLongLongLongLong2String(f: (lFun, lFun, lFun, lFun) => sFun): String = getSignature(List(LongFun, LongFun, LongFun, LongFun), StringFun)
  def getSignatureLongLongLongDouble2String(f: (lFun, lFun, lFun, dFun) => sFun): String = getSignature(List(LongFun, LongFun, LongFun, DoubleFun), StringFun)
  def getSignatureLongLongLongString2String(f: (lFun, lFun, lFun, sFun) => sFun): String = getSignature(List(LongFun, LongFun, LongFun, StringFun), StringFun)
  def getSignatureLongLongLongBoolean2String(f: (lFun, lFun, lFun, bFun) => sFun): String = getSignature(List(LongFun, LongFun, LongFun, BooleanFun), StringFun)
  def getSignatureLongLongDoubleInt2String(f: (lFun, lFun, dFun, iFun) => sFun): String = getSignature(List(LongFun, LongFun, DoubleFun, IntFun), StringFun)
  def getSignatureLongLongDoubleLong2String(f: (lFun, lFun, dFun, lFun) => sFun): String = getSignature(List(LongFun, LongFun, DoubleFun, LongFun), StringFun)
  def getSignatureLongLongDoubleDouble2String(f: (lFun, lFun, dFun, dFun) => sFun): String = getSignature(List(LongFun, LongFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureLongLongDoubleString2String(f: (lFun, lFun, dFun, sFun) => sFun): String = getSignature(List(LongFun, LongFun, DoubleFun, StringFun), StringFun)
  def getSignatureLongLongDoubleBoolean2String(f: (lFun, lFun, dFun, bFun) => sFun): String = getSignature(List(LongFun, LongFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureLongLongStringInt2String(f: (lFun, lFun, sFun, iFun) => sFun): String = getSignature(List(LongFun, LongFun, StringFun, IntFun), StringFun)
  def getSignatureLongLongStringLong2String(f: (lFun, lFun, sFun, lFun) => sFun): String = getSignature(List(LongFun, LongFun, StringFun, LongFun), StringFun)
  def getSignatureLongLongStringDouble2String(f: (lFun, lFun, sFun, dFun) => sFun): String = getSignature(List(LongFun, LongFun, StringFun, DoubleFun), StringFun)
  def getSignatureLongLongStringString2String(f: (lFun, lFun, sFun, sFun) => sFun): String = getSignature(List(LongFun, LongFun, StringFun, StringFun), StringFun)
  def getSignatureLongLongStringBoolean2String(f: (lFun, lFun, sFun, bFun) => sFun): String = getSignature(List(LongFun, LongFun, StringFun, BooleanFun), StringFun)
  def getSignatureLongLongBooleanInt2String(f: (lFun, lFun, bFun, iFun) => sFun): String = getSignature(List(LongFun, LongFun, BooleanFun, IntFun), StringFun)
  def getSignatureLongLongBooleanLong2String(f: (lFun, lFun, bFun, lFun) => sFun): String = getSignature(List(LongFun, LongFun, BooleanFun, LongFun), StringFun)
  def getSignatureLongLongBooleanDouble2String(f: (lFun, lFun, bFun, dFun) => sFun): String = getSignature(List(LongFun, LongFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureLongLongBooleanString2String(f: (lFun, lFun, bFun, sFun) => sFun): String = getSignature(List(LongFun, LongFun, BooleanFun, StringFun), StringFun)
  def getSignatureLongLongBooleanBoolean2String(f: (lFun, lFun, bFun, bFun) => sFun): String = getSignature(List(LongFun, LongFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureLongDoubleIntInt2String(f: (lFun, dFun, iFun, iFun) => sFun): String = getSignature(List(LongFun, DoubleFun, IntFun, IntFun), StringFun)
  def getSignatureLongDoubleIntLong2String(f: (lFun, dFun, iFun, lFun) => sFun): String = getSignature(List(LongFun, DoubleFun, IntFun, LongFun), StringFun)
  def getSignatureLongDoubleIntDouble2String(f: (lFun, dFun, iFun, dFun) => sFun): String = getSignature(List(LongFun, DoubleFun, IntFun, DoubleFun), StringFun)
  def getSignatureLongDoubleIntString2String(f: (lFun, dFun, iFun, sFun) => sFun): String = getSignature(List(LongFun, DoubleFun, IntFun, StringFun), StringFun)
  def getSignatureLongDoubleIntBoolean2String(f: (lFun, dFun, iFun, bFun) => sFun): String = getSignature(List(LongFun, DoubleFun, IntFun, BooleanFun), StringFun)
  def getSignatureLongDoubleLongInt2String(f: (lFun, dFun, lFun, iFun) => sFun): String = getSignature(List(LongFun, DoubleFun, LongFun, IntFun), StringFun)
  def getSignatureLongDoubleLongLong2String(f: (lFun, dFun, lFun, lFun) => sFun): String = getSignature(List(LongFun, DoubleFun, LongFun, LongFun), StringFun)
  def getSignatureLongDoubleLongDouble2String(f: (lFun, dFun, lFun, dFun) => sFun): String = getSignature(List(LongFun, DoubleFun, LongFun, DoubleFun), StringFun)
  def getSignatureLongDoubleLongString2String(f: (lFun, dFun, lFun, sFun) => sFun): String = getSignature(List(LongFun, DoubleFun, LongFun, StringFun), StringFun)
  def getSignatureLongDoubleLongBoolean2String(f: (lFun, dFun, lFun, bFun) => sFun): String = getSignature(List(LongFun, DoubleFun, LongFun, BooleanFun), StringFun)
  def getSignatureLongDoubleDoubleInt2String(f: (lFun, dFun, dFun, iFun) => sFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, IntFun), StringFun)
  def getSignatureLongDoubleDoubleLong2String(f: (lFun, dFun, dFun, lFun) => sFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, LongFun), StringFun)
  def getSignatureLongDoubleDoubleDouble2String(f: (lFun, dFun, dFun, dFun) => sFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureLongDoubleDoubleString2String(f: (lFun, dFun, dFun, sFun) => sFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, StringFun), StringFun)
  def getSignatureLongDoubleDoubleBoolean2String(f: (lFun, dFun, dFun, bFun) => sFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureLongDoubleStringInt2String(f: (lFun, dFun, sFun, iFun) => sFun): String = getSignature(List(LongFun, DoubleFun, StringFun, IntFun), StringFun)
  def getSignatureLongDoubleStringLong2String(f: (lFun, dFun, sFun, lFun) => sFun): String = getSignature(List(LongFun, DoubleFun, StringFun, LongFun), StringFun)
  def getSignatureLongDoubleStringDouble2String(f: (lFun, dFun, sFun, dFun) => sFun): String = getSignature(List(LongFun, DoubleFun, StringFun, DoubleFun), StringFun)
  def getSignatureLongDoubleStringString2String(f: (lFun, dFun, sFun, sFun) => sFun): String = getSignature(List(LongFun, DoubleFun, StringFun, StringFun), StringFun)
  def getSignatureLongDoubleStringBoolean2String(f: (lFun, dFun, sFun, bFun) => sFun): String = getSignature(List(LongFun, DoubleFun, StringFun, BooleanFun), StringFun)
  def getSignatureLongDoubleBooleanInt2String(f: (lFun, dFun, bFun, iFun) => sFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, IntFun), StringFun)
  def getSignatureLongDoubleBooleanLong2String(f: (lFun, dFun, bFun, lFun) => sFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, LongFun), StringFun)
  def getSignatureLongDoubleBooleanDouble2String(f: (lFun, dFun, bFun, dFun) => sFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureLongDoubleBooleanString2String(f: (lFun, dFun, bFun, sFun) => sFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, StringFun), StringFun)
  def getSignatureLongDoubleBooleanBoolean2String(f: (lFun, dFun, bFun, bFun) => sFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureLongStringIntInt2String(f: (lFun, sFun, iFun, iFun) => sFun): String = getSignature(List(LongFun, StringFun, IntFun, IntFun), StringFun)
  def getSignatureLongStringIntLong2String(f: (lFun, sFun, iFun, lFun) => sFun): String = getSignature(List(LongFun, StringFun, IntFun, LongFun), StringFun)
  def getSignatureLongStringIntDouble2String(f: (lFun, sFun, iFun, dFun) => sFun): String = getSignature(List(LongFun, StringFun, IntFun, DoubleFun), StringFun)
  def getSignatureLongStringIntString2String(f: (lFun, sFun, iFun, sFun) => sFun): String = getSignature(List(LongFun, StringFun, IntFun, StringFun), StringFun)
  def getSignatureLongStringIntBoolean2String(f: (lFun, sFun, iFun, bFun) => sFun): String = getSignature(List(LongFun, StringFun, IntFun, BooleanFun), StringFun)
  def getSignatureLongStringLongInt2String(f: (lFun, sFun, lFun, iFun) => sFun): String = getSignature(List(LongFun, StringFun, LongFun, IntFun), StringFun)
  def getSignatureLongStringLongLong2String(f: (lFun, sFun, lFun, lFun) => sFun): String = getSignature(List(LongFun, StringFun, LongFun, LongFun), StringFun)
  def getSignatureLongStringLongDouble2String(f: (lFun, sFun, lFun, dFun) => sFun): String = getSignature(List(LongFun, StringFun, LongFun, DoubleFun), StringFun)
  def getSignatureLongStringLongString2String(f: (lFun, sFun, lFun, sFun) => sFun): String = getSignature(List(LongFun, StringFun, LongFun, StringFun), StringFun)
  def getSignatureLongStringLongBoolean2String(f: (lFun, sFun, lFun, bFun) => sFun): String = getSignature(List(LongFun, StringFun, LongFun, BooleanFun), StringFun)
  def getSignatureLongStringDoubleInt2String(f: (lFun, sFun, dFun, iFun) => sFun): String = getSignature(List(LongFun, StringFun, DoubleFun, IntFun), StringFun)
  def getSignatureLongStringDoubleLong2String(f: (lFun, sFun, dFun, lFun) => sFun): String = getSignature(List(LongFun, StringFun, DoubleFun, LongFun), StringFun)
  def getSignatureLongStringDoubleDouble2String(f: (lFun, sFun, dFun, dFun) => sFun): String = getSignature(List(LongFun, StringFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureLongStringDoubleString2String(f: (lFun, sFun, dFun, sFun) => sFun): String = getSignature(List(LongFun, StringFun, DoubleFun, StringFun), StringFun)
  def getSignatureLongStringDoubleBoolean2String(f: (lFun, sFun, dFun, bFun) => sFun): String = getSignature(List(LongFun, StringFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureLongStringStringInt2String(f: (lFun, sFun, sFun, iFun) => sFun): String = getSignature(List(LongFun, StringFun, StringFun, IntFun), StringFun)
  def getSignatureLongStringStringLong2String(f: (lFun, sFun, sFun, lFun) => sFun): String = getSignature(List(LongFun, StringFun, StringFun, LongFun), StringFun)
  def getSignatureLongStringStringDouble2String(f: (lFun, sFun, sFun, dFun) => sFun): String = getSignature(List(LongFun, StringFun, StringFun, DoubleFun), StringFun)
  def getSignatureLongStringStringString2String(f: (lFun, sFun, sFun, sFun) => sFun): String = getSignature(List(LongFun, StringFun, StringFun, StringFun), StringFun)
  def getSignatureLongStringStringBoolean2String(f: (lFun, sFun, sFun, bFun) => sFun): String = getSignature(List(LongFun, StringFun, StringFun, BooleanFun), StringFun)
  def getSignatureLongStringBooleanInt2String(f: (lFun, sFun, bFun, iFun) => sFun): String = getSignature(List(LongFun, StringFun, BooleanFun, IntFun), StringFun)
  def getSignatureLongStringBooleanLong2String(f: (lFun, sFun, bFun, lFun) => sFun): String = getSignature(List(LongFun, StringFun, BooleanFun, LongFun), StringFun)
  def getSignatureLongStringBooleanDouble2String(f: (lFun, sFun, bFun, dFun) => sFun): String = getSignature(List(LongFun, StringFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureLongStringBooleanString2String(f: (lFun, sFun, bFun, sFun) => sFun): String = getSignature(List(LongFun, StringFun, BooleanFun, StringFun), StringFun)
  def getSignatureLongStringBooleanBoolean2String(f: (lFun, sFun, bFun, bFun) => sFun): String = getSignature(List(LongFun, StringFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureLongBooleanIntInt2String(f: (lFun, bFun, iFun, iFun) => sFun): String = getSignature(List(LongFun, BooleanFun, IntFun, IntFun), StringFun)
  def getSignatureLongBooleanIntLong2String(f: (lFun, bFun, iFun, lFun) => sFun): String = getSignature(List(LongFun, BooleanFun, IntFun, LongFun), StringFun)
  def getSignatureLongBooleanIntDouble2String(f: (lFun, bFun, iFun, dFun) => sFun): String = getSignature(List(LongFun, BooleanFun, IntFun, DoubleFun), StringFun)
  def getSignatureLongBooleanIntString2String(f: (lFun, bFun, iFun, sFun) => sFun): String = getSignature(List(LongFun, BooleanFun, IntFun, StringFun), StringFun)
  def getSignatureLongBooleanIntBoolean2String(f: (lFun, bFun, iFun, bFun) => sFun): String = getSignature(List(LongFun, BooleanFun, IntFun, BooleanFun), StringFun)
  def getSignatureLongBooleanLongInt2String(f: (lFun, bFun, lFun, iFun) => sFun): String = getSignature(List(LongFun, BooleanFun, LongFun, IntFun), StringFun)
  def getSignatureLongBooleanLongLong2String(f: (lFun, bFun, lFun, lFun) => sFun): String = getSignature(List(LongFun, BooleanFun, LongFun, LongFun), StringFun)
  def getSignatureLongBooleanLongDouble2String(f: (lFun, bFun, lFun, dFun) => sFun): String = getSignature(List(LongFun, BooleanFun, LongFun, DoubleFun), StringFun)
  def getSignatureLongBooleanLongString2String(f: (lFun, bFun, lFun, sFun) => sFun): String = getSignature(List(LongFun, BooleanFun, LongFun, StringFun), StringFun)
  def getSignatureLongBooleanLongBoolean2String(f: (lFun, bFun, lFun, bFun) => sFun): String = getSignature(List(LongFun, BooleanFun, LongFun, BooleanFun), StringFun)
  def getSignatureLongBooleanDoubleInt2String(f: (lFun, bFun, dFun, iFun) => sFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, IntFun), StringFun)
  def getSignatureLongBooleanDoubleLong2String(f: (lFun, bFun, dFun, lFun) => sFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, LongFun), StringFun)
  def getSignatureLongBooleanDoubleDouble2String(f: (lFun, bFun, dFun, dFun) => sFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureLongBooleanDoubleString2String(f: (lFun, bFun, dFun, sFun) => sFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, StringFun), StringFun)
  def getSignatureLongBooleanDoubleBoolean2String(f: (lFun, bFun, dFun, bFun) => sFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureLongBooleanStringInt2String(f: (lFun, bFun, sFun, iFun) => sFun): String = getSignature(List(LongFun, BooleanFun, StringFun, IntFun), StringFun)
  def getSignatureLongBooleanStringLong2String(f: (lFun, bFun, sFun, lFun) => sFun): String = getSignature(List(LongFun, BooleanFun, StringFun, LongFun), StringFun)
  def getSignatureLongBooleanStringDouble2String(f: (lFun, bFun, sFun, dFun) => sFun): String = getSignature(List(LongFun, BooleanFun, StringFun, DoubleFun), StringFun)
  def getSignatureLongBooleanStringString2String(f: (lFun, bFun, sFun, sFun) => sFun): String = getSignature(List(LongFun, BooleanFun, StringFun, StringFun), StringFun)
  def getSignatureLongBooleanStringBoolean2String(f: (lFun, bFun, sFun, bFun) => sFun): String = getSignature(List(LongFun, BooleanFun, StringFun, BooleanFun), StringFun)
  def getSignatureLongBooleanBooleanInt2String(f: (lFun, bFun, bFun, iFun) => sFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, IntFun), StringFun)
  def getSignatureLongBooleanBooleanLong2String(f: (lFun, bFun, bFun, lFun) => sFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, LongFun), StringFun)
  def getSignatureLongBooleanBooleanDouble2String(f: (lFun, bFun, bFun, dFun) => sFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureLongBooleanBooleanString2String(f: (lFun, bFun, bFun, sFun) => sFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, StringFun), StringFun)
  def getSignatureLongBooleanBooleanBoolean2String(f: (lFun, bFun, bFun, bFun) => sFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureDoubleIntIntInt2String(f: (dFun, iFun, iFun, iFun) => sFun): String = getSignature(List(DoubleFun, IntFun, IntFun, IntFun), StringFun)
  def getSignatureDoubleIntIntLong2String(f: (dFun, iFun, iFun, lFun) => sFun): String = getSignature(List(DoubleFun, IntFun, IntFun, LongFun), StringFun)
  def getSignatureDoubleIntIntDouble2String(f: (dFun, iFun, iFun, dFun) => sFun): String = getSignature(List(DoubleFun, IntFun, IntFun, DoubleFun), StringFun)
  def getSignatureDoubleIntIntString2String(f: (dFun, iFun, iFun, sFun) => sFun): String = getSignature(List(DoubleFun, IntFun, IntFun, StringFun), StringFun)
  def getSignatureDoubleIntIntBoolean2String(f: (dFun, iFun, iFun, bFun) => sFun): String = getSignature(List(DoubleFun, IntFun, IntFun, BooleanFun), StringFun)
  def getSignatureDoubleIntLongInt2String(f: (dFun, iFun, lFun, iFun) => sFun): String = getSignature(List(DoubleFun, IntFun, LongFun, IntFun), StringFun)
  def getSignatureDoubleIntLongLong2String(f: (dFun, iFun, lFun, lFun) => sFun): String = getSignature(List(DoubleFun, IntFun, LongFun, LongFun), StringFun)
  def getSignatureDoubleIntLongDouble2String(f: (dFun, iFun, lFun, dFun) => sFun): String = getSignature(List(DoubleFun, IntFun, LongFun, DoubleFun), StringFun)
  def getSignatureDoubleIntLongString2String(f: (dFun, iFun, lFun, sFun) => sFun): String = getSignature(List(DoubleFun, IntFun, LongFun, StringFun), StringFun)
  def getSignatureDoubleIntLongBoolean2String(f: (dFun, iFun, lFun, bFun) => sFun): String = getSignature(List(DoubleFun, IntFun, LongFun, BooleanFun), StringFun)
  def getSignatureDoubleIntDoubleInt2String(f: (dFun, iFun, dFun, iFun) => sFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, IntFun), StringFun)
  def getSignatureDoubleIntDoubleLong2String(f: (dFun, iFun, dFun, lFun) => sFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, LongFun), StringFun)
  def getSignatureDoubleIntDoubleDouble2String(f: (dFun, iFun, dFun, dFun) => sFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureDoubleIntDoubleString2String(f: (dFun, iFun, dFun, sFun) => sFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, StringFun), StringFun)
  def getSignatureDoubleIntDoubleBoolean2String(f: (dFun, iFun, dFun, bFun) => sFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureDoubleIntStringInt2String(f: (dFun, iFun, sFun, iFun) => sFun): String = getSignature(List(DoubleFun, IntFun, StringFun, IntFun), StringFun)
  def getSignatureDoubleIntStringLong2String(f: (dFun, iFun, sFun, lFun) => sFun): String = getSignature(List(DoubleFun, IntFun, StringFun, LongFun), StringFun)
  def getSignatureDoubleIntStringDouble2String(f: (dFun, iFun, sFun, dFun) => sFun): String = getSignature(List(DoubleFun, IntFun, StringFun, DoubleFun), StringFun)
  def getSignatureDoubleIntStringString2String(f: (dFun, iFun, sFun, sFun) => sFun): String = getSignature(List(DoubleFun, IntFun, StringFun, StringFun), StringFun)
  def getSignatureDoubleIntStringBoolean2String(f: (dFun, iFun, sFun, bFun) => sFun): String = getSignature(List(DoubleFun, IntFun, StringFun, BooleanFun), StringFun)
  def getSignatureDoubleIntBooleanInt2String(f: (dFun, iFun, bFun, iFun) => sFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, IntFun), StringFun)
  def getSignatureDoubleIntBooleanLong2String(f: (dFun, iFun, bFun, lFun) => sFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, LongFun), StringFun)
  def getSignatureDoubleIntBooleanDouble2String(f: (dFun, iFun, bFun, dFun) => sFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureDoubleIntBooleanString2String(f: (dFun, iFun, bFun, sFun) => sFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, StringFun), StringFun)
  def getSignatureDoubleIntBooleanBoolean2String(f: (dFun, iFun, bFun, bFun) => sFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureDoubleLongIntInt2String(f: (dFun, lFun, iFun, iFun) => sFun): String = getSignature(List(DoubleFun, LongFun, IntFun, IntFun), StringFun)
  def getSignatureDoubleLongIntLong2String(f: (dFun, lFun, iFun, lFun) => sFun): String = getSignature(List(DoubleFun, LongFun, IntFun, LongFun), StringFun)
  def getSignatureDoubleLongIntDouble2String(f: (dFun, lFun, iFun, dFun) => sFun): String = getSignature(List(DoubleFun, LongFun, IntFun, DoubleFun), StringFun)
  def getSignatureDoubleLongIntString2String(f: (dFun, lFun, iFun, sFun) => sFun): String = getSignature(List(DoubleFun, LongFun, IntFun, StringFun), StringFun)
  def getSignatureDoubleLongIntBoolean2String(f: (dFun, lFun, iFun, bFun) => sFun): String = getSignature(List(DoubleFun, LongFun, IntFun, BooleanFun), StringFun)
  def getSignatureDoubleLongLongInt2String(f: (dFun, lFun, lFun, iFun) => sFun): String = getSignature(List(DoubleFun, LongFun, LongFun, IntFun), StringFun)
  def getSignatureDoubleLongLongLong2String(f: (dFun, lFun, lFun, lFun) => sFun): String = getSignature(List(DoubleFun, LongFun, LongFun, LongFun), StringFun)
  def getSignatureDoubleLongLongDouble2String(f: (dFun, lFun, lFun, dFun) => sFun): String = getSignature(List(DoubleFun, LongFun, LongFun, DoubleFun), StringFun)
  def getSignatureDoubleLongLongString2String(f: (dFun, lFun, lFun, sFun) => sFun): String = getSignature(List(DoubleFun, LongFun, LongFun, StringFun), StringFun)
  def getSignatureDoubleLongLongBoolean2String(f: (dFun, lFun, lFun, bFun) => sFun): String = getSignature(List(DoubleFun, LongFun, LongFun, BooleanFun), StringFun)
  def getSignatureDoubleLongDoubleInt2String(f: (dFun, lFun, dFun, iFun) => sFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, IntFun), StringFun)
  def getSignatureDoubleLongDoubleLong2String(f: (dFun, lFun, dFun, lFun) => sFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, LongFun), StringFun)
  def getSignatureDoubleLongDoubleDouble2String(f: (dFun, lFun, dFun, dFun) => sFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureDoubleLongDoubleString2String(f: (dFun, lFun, dFun, sFun) => sFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, StringFun), StringFun)
  def getSignatureDoubleLongDoubleBoolean2String(f: (dFun, lFun, dFun, bFun) => sFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureDoubleLongStringInt2String(f: (dFun, lFun, sFun, iFun) => sFun): String = getSignature(List(DoubleFun, LongFun, StringFun, IntFun), StringFun)
  def getSignatureDoubleLongStringLong2String(f: (dFun, lFun, sFun, lFun) => sFun): String = getSignature(List(DoubleFun, LongFun, StringFun, LongFun), StringFun)
  def getSignatureDoubleLongStringDouble2String(f: (dFun, lFun, sFun, dFun) => sFun): String = getSignature(List(DoubleFun, LongFun, StringFun, DoubleFun), StringFun)
  def getSignatureDoubleLongStringString2String(f: (dFun, lFun, sFun, sFun) => sFun): String = getSignature(List(DoubleFun, LongFun, StringFun, StringFun), StringFun)
  def getSignatureDoubleLongStringBoolean2String(f: (dFun, lFun, sFun, bFun) => sFun): String = getSignature(List(DoubleFun, LongFun, StringFun, BooleanFun), StringFun)
  def getSignatureDoubleLongBooleanInt2String(f: (dFun, lFun, bFun, iFun) => sFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, IntFun), StringFun)
  def getSignatureDoubleLongBooleanLong2String(f: (dFun, lFun, bFun, lFun) => sFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, LongFun), StringFun)
  def getSignatureDoubleLongBooleanDouble2String(f: (dFun, lFun, bFun, dFun) => sFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureDoubleLongBooleanString2String(f: (dFun, lFun, bFun, sFun) => sFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, StringFun), StringFun)
  def getSignatureDoubleLongBooleanBoolean2String(f: (dFun, lFun, bFun, bFun) => sFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureDoubleDoubleIntInt2String(f: (dFun, dFun, iFun, iFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, IntFun), StringFun)
  def getSignatureDoubleDoubleIntLong2String(f: (dFun, dFun, iFun, lFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, LongFun), StringFun)
  def getSignatureDoubleDoubleIntDouble2String(f: (dFun, dFun, iFun, dFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, DoubleFun), StringFun)
  def getSignatureDoubleDoubleIntString2String(f: (dFun, dFun, iFun, sFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, StringFun), StringFun)
  def getSignatureDoubleDoubleIntBoolean2String(f: (dFun, dFun, iFun, bFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, BooleanFun), StringFun)
  def getSignatureDoubleDoubleLongInt2String(f: (dFun, dFun, lFun, iFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, IntFun), StringFun)
  def getSignatureDoubleDoubleLongLong2String(f: (dFun, dFun, lFun, lFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, LongFun), StringFun)
  def getSignatureDoubleDoubleLongDouble2String(f: (dFun, dFun, lFun, dFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, DoubleFun), StringFun)
  def getSignatureDoubleDoubleLongString2String(f: (dFun, dFun, lFun, sFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, StringFun), StringFun)
  def getSignatureDoubleDoubleLongBoolean2String(f: (dFun, dFun, lFun, bFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, BooleanFun), StringFun)
  def getSignatureDoubleDoubleDoubleInt2String(f: (dFun, dFun, dFun, iFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, IntFun), StringFun)
  def getSignatureDoubleDoubleDoubleLong2String(f: (dFun, dFun, dFun, lFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, LongFun), StringFun)
  def getSignatureDoubleDoubleDoubleDouble2String(f: (dFun, dFun, dFun, dFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureDoubleDoubleDoubleString2String(f: (dFun, dFun, dFun, sFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, StringFun), StringFun)
  def getSignatureDoubleDoubleDoubleBoolean2String(f: (dFun, dFun, dFun, bFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureDoubleDoubleStringInt2String(f: (dFun, dFun, sFun, iFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, IntFun), StringFun)
  def getSignatureDoubleDoubleStringLong2String(f: (dFun, dFun, sFun, lFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, LongFun), StringFun)
  def getSignatureDoubleDoubleStringDouble2String(f: (dFun, dFun, sFun, dFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, DoubleFun), StringFun)
  def getSignatureDoubleDoubleStringString2String(f: (dFun, dFun, sFun, sFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, StringFun), StringFun)
  def getSignatureDoubleDoubleStringBoolean2String(f: (dFun, dFun, sFun, bFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, BooleanFun), StringFun)
  def getSignatureDoubleDoubleBooleanInt2String(f: (dFun, dFun, bFun, iFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, IntFun), StringFun)
  def getSignatureDoubleDoubleBooleanLong2String(f: (dFun, dFun, bFun, lFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, LongFun), StringFun)
  def getSignatureDoubleDoubleBooleanDouble2String(f: (dFun, dFun, bFun, dFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureDoubleDoubleBooleanString2String(f: (dFun, dFun, bFun, sFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, StringFun), StringFun)
  def getSignatureDoubleDoubleBooleanBoolean2String(f: (dFun, dFun, bFun, bFun) => sFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureDoubleStringIntInt2String(f: (dFun, sFun, iFun, iFun) => sFun): String = getSignature(List(DoubleFun, StringFun, IntFun, IntFun), StringFun)
  def getSignatureDoubleStringIntLong2String(f: (dFun, sFun, iFun, lFun) => sFun): String = getSignature(List(DoubleFun, StringFun, IntFun, LongFun), StringFun)
  def getSignatureDoubleStringIntDouble2String(f: (dFun, sFun, iFun, dFun) => sFun): String = getSignature(List(DoubleFun, StringFun, IntFun, DoubleFun), StringFun)
  def getSignatureDoubleStringIntString2String(f: (dFun, sFun, iFun, sFun) => sFun): String = getSignature(List(DoubleFun, StringFun, IntFun, StringFun), StringFun)
  def getSignatureDoubleStringIntBoolean2String(f: (dFun, sFun, iFun, bFun) => sFun): String = getSignature(List(DoubleFun, StringFun, IntFun, BooleanFun), StringFun)
  def getSignatureDoubleStringLongInt2String(f: (dFun, sFun, lFun, iFun) => sFun): String = getSignature(List(DoubleFun, StringFun, LongFun, IntFun), StringFun)
  def getSignatureDoubleStringLongLong2String(f: (dFun, sFun, lFun, lFun) => sFun): String = getSignature(List(DoubleFun, StringFun, LongFun, LongFun), StringFun)
  def getSignatureDoubleStringLongDouble2String(f: (dFun, sFun, lFun, dFun) => sFun): String = getSignature(List(DoubleFun, StringFun, LongFun, DoubleFun), StringFun)
  def getSignatureDoubleStringLongString2String(f: (dFun, sFun, lFun, sFun) => sFun): String = getSignature(List(DoubleFun, StringFun, LongFun, StringFun), StringFun)
  def getSignatureDoubleStringLongBoolean2String(f: (dFun, sFun, lFun, bFun) => sFun): String = getSignature(List(DoubleFun, StringFun, LongFun, BooleanFun), StringFun)
  def getSignatureDoubleStringDoubleInt2String(f: (dFun, sFun, dFun, iFun) => sFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, IntFun), StringFun)
  def getSignatureDoubleStringDoubleLong2String(f: (dFun, sFun, dFun, lFun) => sFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, LongFun), StringFun)
  def getSignatureDoubleStringDoubleDouble2String(f: (dFun, sFun, dFun, dFun) => sFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureDoubleStringDoubleString2String(f: (dFun, sFun, dFun, sFun) => sFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, StringFun), StringFun)
  def getSignatureDoubleStringDoubleBoolean2String(f: (dFun, sFun, dFun, bFun) => sFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureDoubleStringStringInt2String(f: (dFun, sFun, sFun, iFun) => sFun): String = getSignature(List(DoubleFun, StringFun, StringFun, IntFun), StringFun)
  def getSignatureDoubleStringStringLong2String(f: (dFun, sFun, sFun, lFun) => sFun): String = getSignature(List(DoubleFun, StringFun, StringFun, LongFun), StringFun)
  def getSignatureDoubleStringStringDouble2String(f: (dFun, sFun, sFun, dFun) => sFun): String = getSignature(List(DoubleFun, StringFun, StringFun, DoubleFun), StringFun)
  def getSignatureDoubleStringStringString2String(f: (dFun, sFun, sFun, sFun) => sFun): String = getSignature(List(DoubleFun, StringFun, StringFun, StringFun), StringFun)
  def getSignatureDoubleStringStringBoolean2String(f: (dFun, sFun, sFun, bFun) => sFun): String = getSignature(List(DoubleFun, StringFun, StringFun, BooleanFun), StringFun)
  def getSignatureDoubleStringBooleanInt2String(f: (dFun, sFun, bFun, iFun) => sFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, IntFun), StringFun)
  def getSignatureDoubleStringBooleanLong2String(f: (dFun, sFun, bFun, lFun) => sFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, LongFun), StringFun)
  def getSignatureDoubleStringBooleanDouble2String(f: (dFun, sFun, bFun, dFun) => sFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureDoubleStringBooleanString2String(f: (dFun, sFun, bFun, sFun) => sFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, StringFun), StringFun)
  def getSignatureDoubleStringBooleanBoolean2String(f: (dFun, sFun, bFun, bFun) => sFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureDoubleBooleanIntInt2String(f: (dFun, bFun, iFun, iFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, IntFun), StringFun)
  def getSignatureDoubleBooleanIntLong2String(f: (dFun, bFun, iFun, lFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, LongFun), StringFun)
  def getSignatureDoubleBooleanIntDouble2String(f: (dFun, bFun, iFun, dFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, DoubleFun), StringFun)
  def getSignatureDoubleBooleanIntString2String(f: (dFun, bFun, iFun, sFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, StringFun), StringFun)
  def getSignatureDoubleBooleanIntBoolean2String(f: (dFun, bFun, iFun, bFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, BooleanFun), StringFun)
  def getSignatureDoubleBooleanLongInt2String(f: (dFun, bFun, lFun, iFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, IntFun), StringFun)
  def getSignatureDoubleBooleanLongLong2String(f: (dFun, bFun, lFun, lFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, LongFun), StringFun)
  def getSignatureDoubleBooleanLongDouble2String(f: (dFun, bFun, lFun, dFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, DoubleFun), StringFun)
  def getSignatureDoubleBooleanLongString2String(f: (dFun, bFun, lFun, sFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, StringFun), StringFun)
  def getSignatureDoubleBooleanLongBoolean2String(f: (dFun, bFun, lFun, bFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, BooleanFun), StringFun)
  def getSignatureDoubleBooleanDoubleInt2String(f: (dFun, bFun, dFun, iFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, IntFun), StringFun)
  def getSignatureDoubleBooleanDoubleLong2String(f: (dFun, bFun, dFun, lFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, LongFun), StringFun)
  def getSignatureDoubleBooleanDoubleDouble2String(f: (dFun, bFun, dFun, dFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureDoubleBooleanDoubleString2String(f: (dFun, bFun, dFun, sFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, StringFun), StringFun)
  def getSignatureDoubleBooleanDoubleBoolean2String(f: (dFun, bFun, dFun, bFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureDoubleBooleanStringInt2String(f: (dFun, bFun, sFun, iFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, IntFun), StringFun)
  def getSignatureDoubleBooleanStringLong2String(f: (dFun, bFun, sFun, lFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, LongFun), StringFun)
  def getSignatureDoubleBooleanStringDouble2String(f: (dFun, bFun, sFun, dFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, DoubleFun), StringFun)
  def getSignatureDoubleBooleanStringString2String(f: (dFun, bFun, sFun, sFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, StringFun), StringFun)
  def getSignatureDoubleBooleanStringBoolean2String(f: (dFun, bFun, sFun, bFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, BooleanFun), StringFun)
  def getSignatureDoubleBooleanBooleanInt2String(f: (dFun, bFun, bFun, iFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, IntFun), StringFun)
  def getSignatureDoubleBooleanBooleanLong2String(f: (dFun, bFun, bFun, lFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, LongFun), StringFun)
  def getSignatureDoubleBooleanBooleanDouble2String(f: (dFun, bFun, bFun, dFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureDoubleBooleanBooleanString2String(f: (dFun, bFun, bFun, sFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, StringFun), StringFun)
  def getSignatureDoubleBooleanBooleanBoolean2String(f: (dFun, bFun, bFun, bFun) => sFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureStringIntIntInt2String(f: (sFun, iFun, iFun, iFun) => sFun): String = getSignature(List(StringFun, IntFun, IntFun, IntFun), StringFun)
  def getSignatureStringIntIntLong2String(f: (sFun, iFun, iFun, lFun) => sFun): String = getSignature(List(StringFun, IntFun, IntFun, LongFun), StringFun)
  def getSignatureStringIntIntDouble2String(f: (sFun, iFun, iFun, dFun) => sFun): String = getSignature(List(StringFun, IntFun, IntFun, DoubleFun), StringFun)
  def getSignatureStringIntIntString2String(f: (sFun, iFun, iFun, sFun) => sFun): String = getSignature(List(StringFun, IntFun, IntFun, StringFun), StringFun)
  def getSignatureStringIntIntBoolean2String(f: (sFun, iFun, iFun, bFun) => sFun): String = getSignature(List(StringFun, IntFun, IntFun, BooleanFun), StringFun)
  def getSignatureStringIntLongInt2String(f: (sFun, iFun, lFun, iFun) => sFun): String = getSignature(List(StringFun, IntFun, LongFun, IntFun), StringFun)
  def getSignatureStringIntLongLong2String(f: (sFun, iFun, lFun, lFun) => sFun): String = getSignature(List(StringFun, IntFun, LongFun, LongFun), StringFun)
  def getSignatureStringIntLongDouble2String(f: (sFun, iFun, lFun, dFun) => sFun): String = getSignature(List(StringFun, IntFun, LongFun, DoubleFun), StringFun)
  def getSignatureStringIntLongString2String(f: (sFun, iFun, lFun, sFun) => sFun): String = getSignature(List(StringFun, IntFun, LongFun, StringFun), StringFun)
  def getSignatureStringIntLongBoolean2String(f: (sFun, iFun, lFun, bFun) => sFun): String = getSignature(List(StringFun, IntFun, LongFun, BooleanFun), StringFun)
  def getSignatureStringIntDoubleInt2String(f: (sFun, iFun, dFun, iFun) => sFun): String = getSignature(List(StringFun, IntFun, DoubleFun, IntFun), StringFun)
  def getSignatureStringIntDoubleLong2String(f: (sFun, iFun, dFun, lFun) => sFun): String = getSignature(List(StringFun, IntFun, DoubleFun, LongFun), StringFun)
  def getSignatureStringIntDoubleDouble2String(f: (sFun, iFun, dFun, dFun) => sFun): String = getSignature(List(StringFun, IntFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureStringIntDoubleString2String(f: (sFun, iFun, dFun, sFun) => sFun): String = getSignature(List(StringFun, IntFun, DoubleFun, StringFun), StringFun)
  def getSignatureStringIntDoubleBoolean2String(f: (sFun, iFun, dFun, bFun) => sFun): String = getSignature(List(StringFun, IntFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureStringIntStringInt2String(f: (sFun, iFun, sFun, iFun) => sFun): String = getSignature(List(StringFun, IntFun, StringFun, IntFun), StringFun)
  def getSignatureStringIntStringLong2String(f: (sFun, iFun, sFun, lFun) => sFun): String = getSignature(List(StringFun, IntFun, StringFun, LongFun), StringFun)
  def getSignatureStringIntStringDouble2String(f: (sFun, iFun, sFun, dFun) => sFun): String = getSignature(List(StringFun, IntFun, StringFun, DoubleFun), StringFun)
  def getSignatureStringIntStringString2String(f: (sFun, iFun, sFun, sFun) => sFun): String = getSignature(List(StringFun, IntFun, StringFun, StringFun), StringFun)
  def getSignatureStringIntStringBoolean2String(f: (sFun, iFun, sFun, bFun) => sFun): String = getSignature(List(StringFun, IntFun, StringFun, BooleanFun), StringFun)
  def getSignatureStringIntBooleanInt2String(f: (sFun, iFun, bFun, iFun) => sFun): String = getSignature(List(StringFun, IntFun, BooleanFun, IntFun), StringFun)
  def getSignatureStringIntBooleanLong2String(f: (sFun, iFun, bFun, lFun) => sFun): String = getSignature(List(StringFun, IntFun, BooleanFun, LongFun), StringFun)
  def getSignatureStringIntBooleanDouble2String(f: (sFun, iFun, bFun, dFun) => sFun): String = getSignature(List(StringFun, IntFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureStringIntBooleanString2String(f: (sFun, iFun, bFun, sFun) => sFun): String = getSignature(List(StringFun, IntFun, BooleanFun, StringFun), StringFun)
  def getSignatureStringIntBooleanBoolean2String(f: (sFun, iFun, bFun, bFun) => sFun): String = getSignature(List(StringFun, IntFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureStringLongIntInt2String(f: (sFun, lFun, iFun, iFun) => sFun): String = getSignature(List(StringFun, LongFun, IntFun, IntFun), StringFun)
  def getSignatureStringLongIntLong2String(f: (sFun, lFun, iFun, lFun) => sFun): String = getSignature(List(StringFun, LongFun, IntFun, LongFun), StringFun)
  def getSignatureStringLongIntDouble2String(f: (sFun, lFun, iFun, dFun) => sFun): String = getSignature(List(StringFun, LongFun, IntFun, DoubleFun), StringFun)
  def getSignatureStringLongIntString2String(f: (sFun, lFun, iFun, sFun) => sFun): String = getSignature(List(StringFun, LongFun, IntFun, StringFun), StringFun)
  def getSignatureStringLongIntBoolean2String(f: (sFun, lFun, iFun, bFun) => sFun): String = getSignature(List(StringFun, LongFun, IntFun, BooleanFun), StringFun)
  def getSignatureStringLongLongInt2String(f: (sFun, lFun, lFun, iFun) => sFun): String = getSignature(List(StringFun, LongFun, LongFun, IntFun), StringFun)
  def getSignatureStringLongLongLong2String(f: (sFun, lFun, lFun, lFun) => sFun): String = getSignature(List(StringFun, LongFun, LongFun, LongFun), StringFun)
  def getSignatureStringLongLongDouble2String(f: (sFun, lFun, lFun, dFun) => sFun): String = getSignature(List(StringFun, LongFun, LongFun, DoubleFun), StringFun)
  def getSignatureStringLongLongString2String(f: (sFun, lFun, lFun, sFun) => sFun): String = getSignature(List(StringFun, LongFun, LongFun, StringFun), StringFun)
  def getSignatureStringLongLongBoolean2String(f: (sFun, lFun, lFun, bFun) => sFun): String = getSignature(List(StringFun, LongFun, LongFun, BooleanFun), StringFun)
  def getSignatureStringLongDoubleInt2String(f: (sFun, lFun, dFun, iFun) => sFun): String = getSignature(List(StringFun, LongFun, DoubleFun, IntFun), StringFun)
  def getSignatureStringLongDoubleLong2String(f: (sFun, lFun, dFun, lFun) => sFun): String = getSignature(List(StringFun, LongFun, DoubleFun, LongFun), StringFun)
  def getSignatureStringLongDoubleDouble2String(f: (sFun, lFun, dFun, dFun) => sFun): String = getSignature(List(StringFun, LongFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureStringLongDoubleString2String(f: (sFun, lFun, dFun, sFun) => sFun): String = getSignature(List(StringFun, LongFun, DoubleFun, StringFun), StringFun)
  def getSignatureStringLongDoubleBoolean2String(f: (sFun, lFun, dFun, bFun) => sFun): String = getSignature(List(StringFun, LongFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureStringLongStringInt2String(f: (sFun, lFun, sFun, iFun) => sFun): String = getSignature(List(StringFun, LongFun, StringFun, IntFun), StringFun)
  def getSignatureStringLongStringLong2String(f: (sFun, lFun, sFun, lFun) => sFun): String = getSignature(List(StringFun, LongFun, StringFun, LongFun), StringFun)
  def getSignatureStringLongStringDouble2String(f: (sFun, lFun, sFun, dFun) => sFun): String = getSignature(List(StringFun, LongFun, StringFun, DoubleFun), StringFun)
  def getSignatureStringLongStringString2String(f: (sFun, lFun, sFun, sFun) => sFun): String = getSignature(List(StringFun, LongFun, StringFun, StringFun), StringFun)
  def getSignatureStringLongStringBoolean2String(f: (sFun, lFun, sFun, bFun) => sFun): String = getSignature(List(StringFun, LongFun, StringFun, BooleanFun), StringFun)
  def getSignatureStringLongBooleanInt2String(f: (sFun, lFun, bFun, iFun) => sFun): String = getSignature(List(StringFun, LongFun, BooleanFun, IntFun), StringFun)
  def getSignatureStringLongBooleanLong2String(f: (sFun, lFun, bFun, lFun) => sFun): String = getSignature(List(StringFun, LongFun, BooleanFun, LongFun), StringFun)
  def getSignatureStringLongBooleanDouble2String(f: (sFun, lFun, bFun, dFun) => sFun): String = getSignature(List(StringFun, LongFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureStringLongBooleanString2String(f: (sFun, lFun, bFun, sFun) => sFun): String = getSignature(List(StringFun, LongFun, BooleanFun, StringFun), StringFun)
  def getSignatureStringLongBooleanBoolean2String(f: (sFun, lFun, bFun, bFun) => sFun): String = getSignature(List(StringFun, LongFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureStringDoubleIntInt2String(f: (sFun, dFun, iFun, iFun) => sFun): String = getSignature(List(StringFun, DoubleFun, IntFun, IntFun), StringFun)
  def getSignatureStringDoubleIntLong2String(f: (sFun, dFun, iFun, lFun) => sFun): String = getSignature(List(StringFun, DoubleFun, IntFun, LongFun), StringFun)
  def getSignatureStringDoubleIntDouble2String(f: (sFun, dFun, iFun, dFun) => sFun): String = getSignature(List(StringFun, DoubleFun, IntFun, DoubleFun), StringFun)
  def getSignatureStringDoubleIntString2String(f: (sFun, dFun, iFun, sFun) => sFun): String = getSignature(List(StringFun, DoubleFun, IntFun, StringFun), StringFun)
  def getSignatureStringDoubleIntBoolean2String(f: (sFun, dFun, iFun, bFun) => sFun): String = getSignature(List(StringFun, DoubleFun, IntFun, BooleanFun), StringFun)
  def getSignatureStringDoubleLongInt2String(f: (sFun, dFun, lFun, iFun) => sFun): String = getSignature(List(StringFun, DoubleFun, LongFun, IntFun), StringFun)
  def getSignatureStringDoubleLongLong2String(f: (sFun, dFun, lFun, lFun) => sFun): String = getSignature(List(StringFun, DoubleFun, LongFun, LongFun), StringFun)
  def getSignatureStringDoubleLongDouble2String(f: (sFun, dFun, lFun, dFun) => sFun): String = getSignature(List(StringFun, DoubleFun, LongFun, DoubleFun), StringFun)
  def getSignatureStringDoubleLongString2String(f: (sFun, dFun, lFun, sFun) => sFun): String = getSignature(List(StringFun, DoubleFun, LongFun, StringFun), StringFun)
  def getSignatureStringDoubleLongBoolean2String(f: (sFun, dFun, lFun, bFun) => sFun): String = getSignature(List(StringFun, DoubleFun, LongFun, BooleanFun), StringFun)
  def getSignatureStringDoubleDoubleInt2String(f: (sFun, dFun, dFun, iFun) => sFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, IntFun), StringFun)
  def getSignatureStringDoubleDoubleLong2String(f: (sFun, dFun, dFun, lFun) => sFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, LongFun), StringFun)
  def getSignatureStringDoubleDoubleDouble2String(f: (sFun, dFun, dFun, dFun) => sFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureStringDoubleDoubleString2String(f: (sFun, dFun, dFun, sFun) => sFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, StringFun), StringFun)
  def getSignatureStringDoubleDoubleBoolean2String(f: (sFun, dFun, dFun, bFun) => sFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureStringDoubleStringInt2String(f: (sFun, dFun, sFun, iFun) => sFun): String = getSignature(List(StringFun, DoubleFun, StringFun, IntFun), StringFun)
  def getSignatureStringDoubleStringLong2String(f: (sFun, dFun, sFun, lFun) => sFun): String = getSignature(List(StringFun, DoubleFun, StringFun, LongFun), StringFun)
  def getSignatureStringDoubleStringDouble2String(f: (sFun, dFun, sFun, dFun) => sFun): String = getSignature(List(StringFun, DoubleFun, StringFun, DoubleFun), StringFun)
  def getSignatureStringDoubleStringString2String(f: (sFun, dFun, sFun, sFun) => sFun): String = getSignature(List(StringFun, DoubleFun, StringFun, StringFun), StringFun)
  def getSignatureStringDoubleStringBoolean2String(f: (sFun, dFun, sFun, bFun) => sFun): String = getSignature(List(StringFun, DoubleFun, StringFun, BooleanFun), StringFun)
  def getSignatureStringDoubleBooleanInt2String(f: (sFun, dFun, bFun, iFun) => sFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, IntFun), StringFun)
  def getSignatureStringDoubleBooleanLong2String(f: (sFun, dFun, bFun, lFun) => sFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, LongFun), StringFun)
  def getSignatureStringDoubleBooleanDouble2String(f: (sFun, dFun, bFun, dFun) => sFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureStringDoubleBooleanString2String(f: (sFun, dFun, bFun, sFun) => sFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, StringFun), StringFun)
  def getSignatureStringDoubleBooleanBoolean2String(f: (sFun, dFun, bFun, bFun) => sFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureStringStringIntInt2String(f: (sFun, sFun, iFun, iFun) => sFun): String = getSignature(List(StringFun, StringFun, IntFun, IntFun), StringFun)
  def getSignatureStringStringIntLong2String(f: (sFun, sFun, iFun, lFun) => sFun): String = getSignature(List(StringFun, StringFun, IntFun, LongFun), StringFun)
  def getSignatureStringStringIntDouble2String(f: (sFun, sFun, iFun, dFun) => sFun): String = getSignature(List(StringFun, StringFun, IntFun, DoubleFun), StringFun)
  def getSignatureStringStringIntString2String(f: (sFun, sFun, iFun, sFun) => sFun): String = getSignature(List(StringFun, StringFun, IntFun, StringFun), StringFun)
  def getSignatureStringStringIntBoolean2String(f: (sFun, sFun, iFun, bFun) => sFun): String = getSignature(List(StringFun, StringFun, IntFun, BooleanFun), StringFun)
  def getSignatureStringStringLongInt2String(f: (sFun, sFun, lFun, iFun) => sFun): String = getSignature(List(StringFun, StringFun, LongFun, IntFun), StringFun)
  def getSignatureStringStringLongLong2String(f: (sFun, sFun, lFun, lFun) => sFun): String = getSignature(List(StringFun, StringFun, LongFun, LongFun), StringFun)
  def getSignatureStringStringLongDouble2String(f: (sFun, sFun, lFun, dFun) => sFun): String = getSignature(List(StringFun, StringFun, LongFun, DoubleFun), StringFun)
  def getSignatureStringStringLongString2String(f: (sFun, sFun, lFun, sFun) => sFun): String = getSignature(List(StringFun, StringFun, LongFun, StringFun), StringFun)
  def getSignatureStringStringLongBoolean2String(f: (sFun, sFun, lFun, bFun) => sFun): String = getSignature(List(StringFun, StringFun, LongFun, BooleanFun), StringFun)
  def getSignatureStringStringDoubleInt2String(f: (sFun, sFun, dFun, iFun) => sFun): String = getSignature(List(StringFun, StringFun, DoubleFun, IntFun), StringFun)
  def getSignatureStringStringDoubleLong2String(f: (sFun, sFun, dFun, lFun) => sFun): String = getSignature(List(StringFun, StringFun, DoubleFun, LongFun), StringFun)
  def getSignatureStringStringDoubleDouble2String(f: (sFun, sFun, dFun, dFun) => sFun): String = getSignature(List(StringFun, StringFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureStringStringDoubleString2String(f: (sFun, sFun, dFun, sFun) => sFun): String = getSignature(List(StringFun, StringFun, DoubleFun, StringFun), StringFun)
  def getSignatureStringStringDoubleBoolean2String(f: (sFun, sFun, dFun, bFun) => sFun): String = getSignature(List(StringFun, StringFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureStringStringStringInt2String(f: (sFun, sFun, sFun, iFun) => sFun): String = getSignature(List(StringFun, StringFun, StringFun, IntFun), StringFun)
  def getSignatureStringStringStringLong2String(f: (sFun, sFun, sFun, lFun) => sFun): String = getSignature(List(StringFun, StringFun, StringFun, LongFun), StringFun)
  def getSignatureStringStringStringDouble2String(f: (sFun, sFun, sFun, dFun) => sFun): String = getSignature(List(StringFun, StringFun, StringFun, DoubleFun), StringFun)
  def getSignatureStringStringStringString2String(f: (sFun, sFun, sFun, sFun) => sFun): String = getSignature(List(StringFun, StringFun, StringFun, StringFun), StringFun)
  def getSignatureStringStringStringBoolean2String(f: (sFun, sFun, sFun, bFun) => sFun): String = getSignature(List(StringFun, StringFun, StringFun, BooleanFun), StringFun)
  def getSignatureStringStringBooleanInt2String(f: (sFun, sFun, bFun, iFun) => sFun): String = getSignature(List(StringFun, StringFun, BooleanFun, IntFun), StringFun)
  def getSignatureStringStringBooleanLong2String(f: (sFun, sFun, bFun, lFun) => sFun): String = getSignature(List(StringFun, StringFun, BooleanFun, LongFun), StringFun)
  def getSignatureStringStringBooleanDouble2String(f: (sFun, sFun, bFun, dFun) => sFun): String = getSignature(List(StringFun, StringFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureStringStringBooleanString2String(f: (sFun, sFun, bFun, sFun) => sFun): String = getSignature(List(StringFun, StringFun, BooleanFun, StringFun), StringFun)
  def getSignatureStringStringBooleanBoolean2String(f: (sFun, sFun, bFun, bFun) => sFun): String = getSignature(List(StringFun, StringFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureStringBooleanIntInt2String(f: (sFun, bFun, iFun, iFun) => sFun): String = getSignature(List(StringFun, BooleanFun, IntFun, IntFun), StringFun)
  def getSignatureStringBooleanIntLong2String(f: (sFun, bFun, iFun, lFun) => sFun): String = getSignature(List(StringFun, BooleanFun, IntFun, LongFun), StringFun)
  def getSignatureStringBooleanIntDouble2String(f: (sFun, bFun, iFun, dFun) => sFun): String = getSignature(List(StringFun, BooleanFun, IntFun, DoubleFun), StringFun)
  def getSignatureStringBooleanIntString2String(f: (sFun, bFun, iFun, sFun) => sFun): String = getSignature(List(StringFun, BooleanFun, IntFun, StringFun), StringFun)
  def getSignatureStringBooleanIntBoolean2String(f: (sFun, bFun, iFun, bFun) => sFun): String = getSignature(List(StringFun, BooleanFun, IntFun, BooleanFun), StringFun)
  def getSignatureStringBooleanLongInt2String(f: (sFun, bFun, lFun, iFun) => sFun): String = getSignature(List(StringFun, BooleanFun, LongFun, IntFun), StringFun)
  def getSignatureStringBooleanLongLong2String(f: (sFun, bFun, lFun, lFun) => sFun): String = getSignature(List(StringFun, BooleanFun, LongFun, LongFun), StringFun)
  def getSignatureStringBooleanLongDouble2String(f: (sFun, bFun, lFun, dFun) => sFun): String = getSignature(List(StringFun, BooleanFun, LongFun, DoubleFun), StringFun)
  def getSignatureStringBooleanLongString2String(f: (sFun, bFun, lFun, sFun) => sFun): String = getSignature(List(StringFun, BooleanFun, LongFun, StringFun), StringFun)
  def getSignatureStringBooleanLongBoolean2String(f: (sFun, bFun, lFun, bFun) => sFun): String = getSignature(List(StringFun, BooleanFun, LongFun, BooleanFun), StringFun)
  def getSignatureStringBooleanDoubleInt2String(f: (sFun, bFun, dFun, iFun) => sFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, IntFun), StringFun)
  def getSignatureStringBooleanDoubleLong2String(f: (sFun, bFun, dFun, lFun) => sFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, LongFun), StringFun)
  def getSignatureStringBooleanDoubleDouble2String(f: (sFun, bFun, dFun, dFun) => sFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureStringBooleanDoubleString2String(f: (sFun, bFun, dFun, sFun) => sFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, StringFun), StringFun)
  def getSignatureStringBooleanDoubleBoolean2String(f: (sFun, bFun, dFun, bFun) => sFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureStringBooleanStringInt2String(f: (sFun, bFun, sFun, iFun) => sFun): String = getSignature(List(StringFun, BooleanFun, StringFun, IntFun), StringFun)
  def getSignatureStringBooleanStringLong2String(f: (sFun, bFun, sFun, lFun) => sFun): String = getSignature(List(StringFun, BooleanFun, StringFun, LongFun), StringFun)
  def getSignatureStringBooleanStringDouble2String(f: (sFun, bFun, sFun, dFun) => sFun): String = getSignature(List(StringFun, BooleanFun, StringFun, DoubleFun), StringFun)
  def getSignatureStringBooleanStringString2String(f: (sFun, bFun, sFun, sFun) => sFun): String = getSignature(List(StringFun, BooleanFun, StringFun, StringFun), StringFun)
  def getSignatureStringBooleanStringBoolean2String(f: (sFun, bFun, sFun, bFun) => sFun): String = getSignature(List(StringFun, BooleanFun, StringFun, BooleanFun), StringFun)
  def getSignatureStringBooleanBooleanInt2String(f: (sFun, bFun, bFun, iFun) => sFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, IntFun), StringFun)
  def getSignatureStringBooleanBooleanLong2String(f: (sFun, bFun, bFun, lFun) => sFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, LongFun), StringFun)
  def getSignatureStringBooleanBooleanDouble2String(f: (sFun, bFun, bFun, dFun) => sFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureStringBooleanBooleanString2String(f: (sFun, bFun, bFun, sFun) => sFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, StringFun), StringFun)
  def getSignatureStringBooleanBooleanBoolean2String(f: (sFun, bFun, bFun, bFun) => sFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureBooleanIntIntInt2String(f: (bFun, iFun, iFun, iFun) => sFun): String = getSignature(List(BooleanFun, IntFun, IntFun, IntFun), StringFun)
  def getSignatureBooleanIntIntLong2String(f: (bFun, iFun, iFun, lFun) => sFun): String = getSignature(List(BooleanFun, IntFun, IntFun, LongFun), StringFun)
  def getSignatureBooleanIntIntDouble2String(f: (bFun, iFun, iFun, dFun) => sFun): String = getSignature(List(BooleanFun, IntFun, IntFun, DoubleFun), StringFun)
  def getSignatureBooleanIntIntString2String(f: (bFun, iFun, iFun, sFun) => sFun): String = getSignature(List(BooleanFun, IntFun, IntFun, StringFun), StringFun)
  def getSignatureBooleanIntIntBoolean2String(f: (bFun, iFun, iFun, bFun) => sFun): String = getSignature(List(BooleanFun, IntFun, IntFun, BooleanFun), StringFun)
  def getSignatureBooleanIntLongInt2String(f: (bFun, iFun, lFun, iFun) => sFun): String = getSignature(List(BooleanFun, IntFun, LongFun, IntFun), StringFun)
  def getSignatureBooleanIntLongLong2String(f: (bFun, iFun, lFun, lFun) => sFun): String = getSignature(List(BooleanFun, IntFun, LongFun, LongFun), StringFun)
  def getSignatureBooleanIntLongDouble2String(f: (bFun, iFun, lFun, dFun) => sFun): String = getSignature(List(BooleanFun, IntFun, LongFun, DoubleFun), StringFun)
  def getSignatureBooleanIntLongString2String(f: (bFun, iFun, lFun, sFun) => sFun): String = getSignature(List(BooleanFun, IntFun, LongFun, StringFun), StringFun)
  def getSignatureBooleanIntLongBoolean2String(f: (bFun, iFun, lFun, bFun) => sFun): String = getSignature(List(BooleanFun, IntFun, LongFun, BooleanFun), StringFun)
  def getSignatureBooleanIntDoubleInt2String(f: (bFun, iFun, dFun, iFun) => sFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, IntFun), StringFun)
  def getSignatureBooleanIntDoubleLong2String(f: (bFun, iFun, dFun, lFun) => sFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, LongFun), StringFun)
  def getSignatureBooleanIntDoubleDouble2String(f: (bFun, iFun, dFun, dFun) => sFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureBooleanIntDoubleString2String(f: (bFun, iFun, dFun, sFun) => sFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, StringFun), StringFun)
  def getSignatureBooleanIntDoubleBoolean2String(f: (bFun, iFun, dFun, bFun) => sFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureBooleanIntStringInt2String(f: (bFun, iFun, sFun, iFun) => sFun): String = getSignature(List(BooleanFun, IntFun, StringFun, IntFun), StringFun)
  def getSignatureBooleanIntStringLong2String(f: (bFun, iFun, sFun, lFun) => sFun): String = getSignature(List(BooleanFun, IntFun, StringFun, LongFun), StringFun)
  def getSignatureBooleanIntStringDouble2String(f: (bFun, iFun, sFun, dFun) => sFun): String = getSignature(List(BooleanFun, IntFun, StringFun, DoubleFun), StringFun)
  def getSignatureBooleanIntStringString2String(f: (bFun, iFun, sFun, sFun) => sFun): String = getSignature(List(BooleanFun, IntFun, StringFun, StringFun), StringFun)
  def getSignatureBooleanIntStringBoolean2String(f: (bFun, iFun, sFun, bFun) => sFun): String = getSignature(List(BooleanFun, IntFun, StringFun, BooleanFun), StringFun)
  def getSignatureBooleanIntBooleanInt2String(f: (bFun, iFun, bFun, iFun) => sFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, IntFun), StringFun)
  def getSignatureBooleanIntBooleanLong2String(f: (bFun, iFun, bFun, lFun) => sFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, LongFun), StringFun)
  def getSignatureBooleanIntBooleanDouble2String(f: (bFun, iFun, bFun, dFun) => sFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureBooleanIntBooleanString2String(f: (bFun, iFun, bFun, sFun) => sFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, StringFun), StringFun)
  def getSignatureBooleanIntBooleanBoolean2String(f: (bFun, iFun, bFun, bFun) => sFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureBooleanLongIntInt2String(f: (bFun, lFun, iFun, iFun) => sFun): String = getSignature(List(BooleanFun, LongFun, IntFun, IntFun), StringFun)
  def getSignatureBooleanLongIntLong2String(f: (bFun, lFun, iFun, lFun) => sFun): String = getSignature(List(BooleanFun, LongFun, IntFun, LongFun), StringFun)
  def getSignatureBooleanLongIntDouble2String(f: (bFun, lFun, iFun, dFun) => sFun): String = getSignature(List(BooleanFun, LongFun, IntFun, DoubleFun), StringFun)
  def getSignatureBooleanLongIntString2String(f: (bFun, lFun, iFun, sFun) => sFun): String = getSignature(List(BooleanFun, LongFun, IntFun, StringFun), StringFun)
  def getSignatureBooleanLongIntBoolean2String(f: (bFun, lFun, iFun, bFun) => sFun): String = getSignature(List(BooleanFun, LongFun, IntFun, BooleanFun), StringFun)
  def getSignatureBooleanLongLongInt2String(f: (bFun, lFun, lFun, iFun) => sFun): String = getSignature(List(BooleanFun, LongFun, LongFun, IntFun), StringFun)
  def getSignatureBooleanLongLongLong2String(f: (bFun, lFun, lFun, lFun) => sFun): String = getSignature(List(BooleanFun, LongFun, LongFun, LongFun), StringFun)
  def getSignatureBooleanLongLongDouble2String(f: (bFun, lFun, lFun, dFun) => sFun): String = getSignature(List(BooleanFun, LongFun, LongFun, DoubleFun), StringFun)
  def getSignatureBooleanLongLongString2String(f: (bFun, lFun, lFun, sFun) => sFun): String = getSignature(List(BooleanFun, LongFun, LongFun, StringFun), StringFun)
  def getSignatureBooleanLongLongBoolean2String(f: (bFun, lFun, lFun, bFun) => sFun): String = getSignature(List(BooleanFun, LongFun, LongFun, BooleanFun), StringFun)
  def getSignatureBooleanLongDoubleInt2String(f: (bFun, lFun, dFun, iFun) => sFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, IntFun), StringFun)
  def getSignatureBooleanLongDoubleLong2String(f: (bFun, lFun, dFun, lFun) => sFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, LongFun), StringFun)
  def getSignatureBooleanLongDoubleDouble2String(f: (bFun, lFun, dFun, dFun) => sFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureBooleanLongDoubleString2String(f: (bFun, lFun, dFun, sFun) => sFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, StringFun), StringFun)
  def getSignatureBooleanLongDoubleBoolean2String(f: (bFun, lFun, dFun, bFun) => sFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureBooleanLongStringInt2String(f: (bFun, lFun, sFun, iFun) => sFun): String = getSignature(List(BooleanFun, LongFun, StringFun, IntFun), StringFun)
  def getSignatureBooleanLongStringLong2String(f: (bFun, lFun, sFun, lFun) => sFun): String = getSignature(List(BooleanFun, LongFun, StringFun, LongFun), StringFun)
  def getSignatureBooleanLongStringDouble2String(f: (bFun, lFun, sFun, dFun) => sFun): String = getSignature(List(BooleanFun, LongFun, StringFun, DoubleFun), StringFun)
  def getSignatureBooleanLongStringString2String(f: (bFun, lFun, sFun, sFun) => sFun): String = getSignature(List(BooleanFun, LongFun, StringFun, StringFun), StringFun)
  def getSignatureBooleanLongStringBoolean2String(f: (bFun, lFun, sFun, bFun) => sFun): String = getSignature(List(BooleanFun, LongFun, StringFun, BooleanFun), StringFun)
  def getSignatureBooleanLongBooleanInt2String(f: (bFun, lFun, bFun, iFun) => sFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, IntFun), StringFun)
  def getSignatureBooleanLongBooleanLong2String(f: (bFun, lFun, bFun, lFun) => sFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, LongFun), StringFun)
  def getSignatureBooleanLongBooleanDouble2String(f: (bFun, lFun, bFun, dFun) => sFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureBooleanLongBooleanString2String(f: (bFun, lFun, bFun, sFun) => sFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, StringFun), StringFun)
  def getSignatureBooleanLongBooleanBoolean2String(f: (bFun, lFun, bFun, bFun) => sFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureBooleanDoubleIntInt2String(f: (bFun, dFun, iFun, iFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, IntFun), StringFun)
  def getSignatureBooleanDoubleIntLong2String(f: (bFun, dFun, iFun, lFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, LongFun), StringFun)
  def getSignatureBooleanDoubleIntDouble2String(f: (bFun, dFun, iFun, dFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, DoubleFun), StringFun)
  def getSignatureBooleanDoubleIntString2String(f: (bFun, dFun, iFun, sFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, StringFun), StringFun)
  def getSignatureBooleanDoubleIntBoolean2String(f: (bFun, dFun, iFun, bFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, BooleanFun), StringFun)
  def getSignatureBooleanDoubleLongInt2String(f: (bFun, dFun, lFun, iFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, IntFun), StringFun)
  def getSignatureBooleanDoubleLongLong2String(f: (bFun, dFun, lFun, lFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, LongFun), StringFun)
  def getSignatureBooleanDoubleLongDouble2String(f: (bFun, dFun, lFun, dFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, DoubleFun), StringFun)
  def getSignatureBooleanDoubleLongString2String(f: (bFun, dFun, lFun, sFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, StringFun), StringFun)
  def getSignatureBooleanDoubleLongBoolean2String(f: (bFun, dFun, lFun, bFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, BooleanFun), StringFun)
  def getSignatureBooleanDoubleDoubleInt2String(f: (bFun, dFun, dFun, iFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, IntFun), StringFun)
  def getSignatureBooleanDoubleDoubleLong2String(f: (bFun, dFun, dFun, lFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, LongFun), StringFun)
  def getSignatureBooleanDoubleDoubleDouble2String(f: (bFun, dFun, dFun, dFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureBooleanDoubleDoubleString2String(f: (bFun, dFun, dFun, sFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, StringFun), StringFun)
  def getSignatureBooleanDoubleDoubleBoolean2String(f: (bFun, dFun, dFun, bFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureBooleanDoubleStringInt2String(f: (bFun, dFun, sFun, iFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, IntFun), StringFun)
  def getSignatureBooleanDoubleStringLong2String(f: (bFun, dFun, sFun, lFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, LongFun), StringFun)
  def getSignatureBooleanDoubleStringDouble2String(f: (bFun, dFun, sFun, dFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, DoubleFun), StringFun)
  def getSignatureBooleanDoubleStringString2String(f: (bFun, dFun, sFun, sFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, StringFun), StringFun)
  def getSignatureBooleanDoubleStringBoolean2String(f: (bFun, dFun, sFun, bFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, BooleanFun), StringFun)
  def getSignatureBooleanDoubleBooleanInt2String(f: (bFun, dFun, bFun, iFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, IntFun), StringFun)
  def getSignatureBooleanDoubleBooleanLong2String(f: (bFun, dFun, bFun, lFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, LongFun), StringFun)
  def getSignatureBooleanDoubleBooleanDouble2String(f: (bFun, dFun, bFun, dFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureBooleanDoubleBooleanString2String(f: (bFun, dFun, bFun, sFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, StringFun), StringFun)
  def getSignatureBooleanDoubleBooleanBoolean2String(f: (bFun, dFun, bFun, bFun) => sFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureBooleanStringIntInt2String(f: (bFun, sFun, iFun, iFun) => sFun): String = getSignature(List(BooleanFun, StringFun, IntFun, IntFun), StringFun)
  def getSignatureBooleanStringIntLong2String(f: (bFun, sFun, iFun, lFun) => sFun): String = getSignature(List(BooleanFun, StringFun, IntFun, LongFun), StringFun)
  def getSignatureBooleanStringIntDouble2String(f: (bFun, sFun, iFun, dFun) => sFun): String = getSignature(List(BooleanFun, StringFun, IntFun, DoubleFun), StringFun)
  def getSignatureBooleanStringIntString2String(f: (bFun, sFun, iFun, sFun) => sFun): String = getSignature(List(BooleanFun, StringFun, IntFun, StringFun), StringFun)
  def getSignatureBooleanStringIntBoolean2String(f: (bFun, sFun, iFun, bFun) => sFun): String = getSignature(List(BooleanFun, StringFun, IntFun, BooleanFun), StringFun)
  def getSignatureBooleanStringLongInt2String(f: (bFun, sFun, lFun, iFun) => sFun): String = getSignature(List(BooleanFun, StringFun, LongFun, IntFun), StringFun)
  def getSignatureBooleanStringLongLong2String(f: (bFun, sFun, lFun, lFun) => sFun): String = getSignature(List(BooleanFun, StringFun, LongFun, LongFun), StringFun)
  def getSignatureBooleanStringLongDouble2String(f: (bFun, sFun, lFun, dFun) => sFun): String = getSignature(List(BooleanFun, StringFun, LongFun, DoubleFun), StringFun)
  def getSignatureBooleanStringLongString2String(f: (bFun, sFun, lFun, sFun) => sFun): String = getSignature(List(BooleanFun, StringFun, LongFun, StringFun), StringFun)
  def getSignatureBooleanStringLongBoolean2String(f: (bFun, sFun, lFun, bFun) => sFun): String = getSignature(List(BooleanFun, StringFun, LongFun, BooleanFun), StringFun)
  def getSignatureBooleanStringDoubleInt2String(f: (bFun, sFun, dFun, iFun) => sFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, IntFun), StringFun)
  def getSignatureBooleanStringDoubleLong2String(f: (bFun, sFun, dFun, lFun) => sFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, LongFun), StringFun)
  def getSignatureBooleanStringDoubleDouble2String(f: (bFun, sFun, dFun, dFun) => sFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureBooleanStringDoubleString2String(f: (bFun, sFun, dFun, sFun) => sFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, StringFun), StringFun)
  def getSignatureBooleanStringDoubleBoolean2String(f: (bFun, sFun, dFun, bFun) => sFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureBooleanStringStringInt2String(f: (bFun, sFun, sFun, iFun) => sFun): String = getSignature(List(BooleanFun, StringFun, StringFun, IntFun), StringFun)
  def getSignatureBooleanStringStringLong2String(f: (bFun, sFun, sFun, lFun) => sFun): String = getSignature(List(BooleanFun, StringFun, StringFun, LongFun), StringFun)
  def getSignatureBooleanStringStringDouble2String(f: (bFun, sFun, sFun, dFun) => sFun): String = getSignature(List(BooleanFun, StringFun, StringFun, DoubleFun), StringFun)
  def getSignatureBooleanStringStringString2String(f: (bFun, sFun, sFun, sFun) => sFun): String = getSignature(List(BooleanFun, StringFun, StringFun, StringFun), StringFun)
  def getSignatureBooleanStringStringBoolean2String(f: (bFun, sFun, sFun, bFun) => sFun): String = getSignature(List(BooleanFun, StringFun, StringFun, BooleanFun), StringFun)
  def getSignatureBooleanStringBooleanInt2String(f: (bFun, sFun, bFun, iFun) => sFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, IntFun), StringFun)
  def getSignatureBooleanStringBooleanLong2String(f: (bFun, sFun, bFun, lFun) => sFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, LongFun), StringFun)
  def getSignatureBooleanStringBooleanDouble2String(f: (bFun, sFun, bFun, dFun) => sFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureBooleanStringBooleanString2String(f: (bFun, sFun, bFun, sFun) => sFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, StringFun), StringFun)
  def getSignatureBooleanStringBooleanBoolean2String(f: (bFun, sFun, bFun, bFun) => sFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureBooleanBooleanIntInt2String(f: (bFun, bFun, iFun, iFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, IntFun), StringFun)
  def getSignatureBooleanBooleanIntLong2String(f: (bFun, bFun, iFun, lFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, LongFun), StringFun)
  def getSignatureBooleanBooleanIntDouble2String(f: (bFun, bFun, iFun, dFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, DoubleFun), StringFun)
  def getSignatureBooleanBooleanIntString2String(f: (bFun, bFun, iFun, sFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, StringFun), StringFun)
  def getSignatureBooleanBooleanIntBoolean2String(f: (bFun, bFun, iFun, bFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, BooleanFun), StringFun)
  def getSignatureBooleanBooleanLongInt2String(f: (bFun, bFun, lFun, iFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, IntFun), StringFun)
  def getSignatureBooleanBooleanLongLong2String(f: (bFun, bFun, lFun, lFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, LongFun), StringFun)
  def getSignatureBooleanBooleanLongDouble2String(f: (bFun, bFun, lFun, dFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, DoubleFun), StringFun)
  def getSignatureBooleanBooleanLongString2String(f: (bFun, bFun, lFun, sFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, StringFun), StringFun)
  def getSignatureBooleanBooleanLongBoolean2String(f: (bFun, bFun, lFun, bFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, BooleanFun), StringFun)
  def getSignatureBooleanBooleanDoubleInt2String(f: (bFun, bFun, dFun, iFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, IntFun), StringFun)
  def getSignatureBooleanBooleanDoubleLong2String(f: (bFun, bFun, dFun, lFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, LongFun), StringFun)
  def getSignatureBooleanBooleanDoubleDouble2String(f: (bFun, bFun, dFun, dFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, DoubleFun), StringFun)
  def getSignatureBooleanBooleanDoubleString2String(f: (bFun, bFun, dFun, sFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, StringFun), StringFun)
  def getSignatureBooleanBooleanDoubleBoolean2String(f: (bFun, bFun, dFun, bFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, BooleanFun), StringFun)
  def getSignatureBooleanBooleanStringInt2String(f: (bFun, bFun, sFun, iFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, IntFun), StringFun)
  def getSignatureBooleanBooleanStringLong2String(f: (bFun, bFun, sFun, lFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, LongFun), StringFun)
  def getSignatureBooleanBooleanStringDouble2String(f: (bFun, bFun, sFun, dFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, DoubleFun), StringFun)
  def getSignatureBooleanBooleanStringString2String(f: (bFun, bFun, sFun, sFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, StringFun), StringFun)
  def getSignatureBooleanBooleanStringBoolean2String(f: (bFun, bFun, sFun, bFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, BooleanFun), StringFun)
  def getSignatureBooleanBooleanBooleanInt2String(f: (bFun, bFun, bFun, iFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, IntFun), StringFun)
  def getSignatureBooleanBooleanBooleanLong2String(f: (bFun, bFun, bFun, lFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, LongFun), StringFun)
  def getSignatureBooleanBooleanBooleanDouble2String(f: (bFun, bFun, bFun, dFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, DoubleFun), StringFun)
  def getSignatureBooleanBooleanBooleanString2String(f: (bFun, bFun, bFun, sFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, StringFun), StringFun)
  def getSignatureBooleanBooleanBooleanBoolean2String(f: (bFun, bFun, bFun, bFun) => sFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, BooleanFun), StringFun)
  def getSignatureIntIntIntInt2Boolean(f: (iFun, iFun, iFun, iFun) => bFun): String = getSignature(List(IntFun, IntFun, IntFun, IntFun), BooleanFun)
  def getSignatureIntIntIntLong2Boolean(f: (iFun, iFun, iFun, lFun) => bFun): String = getSignature(List(IntFun, IntFun, IntFun, LongFun), BooleanFun)
  def getSignatureIntIntIntDouble2Boolean(f: (iFun, iFun, iFun, dFun) => bFun): String = getSignature(List(IntFun, IntFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureIntIntIntString2Boolean(f: (iFun, iFun, iFun, sFun) => bFun): String = getSignature(List(IntFun, IntFun, IntFun, StringFun), BooleanFun)
  def getSignatureIntIntIntBoolean2Boolean(f: (iFun, iFun, iFun, bFun) => bFun): String = getSignature(List(IntFun, IntFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureIntIntLongInt2Boolean(f: (iFun, iFun, lFun, iFun) => bFun): String = getSignature(List(IntFun, IntFun, LongFun, IntFun), BooleanFun)
  def getSignatureIntIntLongLong2Boolean(f: (iFun, iFun, lFun, lFun) => bFun): String = getSignature(List(IntFun, IntFun, LongFun, LongFun), BooleanFun)
  def getSignatureIntIntLongDouble2Boolean(f: (iFun, iFun, lFun, dFun) => bFun): String = getSignature(List(IntFun, IntFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureIntIntLongString2Boolean(f: (iFun, iFun, lFun, sFun) => bFun): String = getSignature(List(IntFun, IntFun, LongFun, StringFun), BooleanFun)
  def getSignatureIntIntLongBoolean2Boolean(f: (iFun, iFun, lFun, bFun) => bFun): String = getSignature(List(IntFun, IntFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureIntIntDoubleInt2Boolean(f: (iFun, iFun, dFun, iFun) => bFun): String = getSignature(List(IntFun, IntFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureIntIntDoubleLong2Boolean(f: (iFun, iFun, dFun, lFun) => bFun): String = getSignature(List(IntFun, IntFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureIntIntDoubleDouble2Boolean(f: (iFun, iFun, dFun, dFun) => bFun): String = getSignature(List(IntFun, IntFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureIntIntDoubleString2Boolean(f: (iFun, iFun, dFun, sFun) => bFun): String = getSignature(List(IntFun, IntFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureIntIntDoubleBoolean2Boolean(f: (iFun, iFun, dFun, bFun) => bFun): String = getSignature(List(IntFun, IntFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureIntIntStringInt2Boolean(f: (iFun, iFun, sFun, iFun) => bFun): String = getSignature(List(IntFun, IntFun, StringFun, IntFun), BooleanFun)
  def getSignatureIntIntStringLong2Boolean(f: (iFun, iFun, sFun, lFun) => bFun): String = getSignature(List(IntFun, IntFun, StringFun, LongFun), BooleanFun)
  def getSignatureIntIntStringDouble2Boolean(f: (iFun, iFun, sFun, dFun) => bFun): String = getSignature(List(IntFun, IntFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureIntIntStringString2Boolean(f: (iFun, iFun, sFun, sFun) => bFun): String = getSignature(List(IntFun, IntFun, StringFun, StringFun), BooleanFun)
  def getSignatureIntIntStringBoolean2Boolean(f: (iFun, iFun, sFun, bFun) => bFun): String = getSignature(List(IntFun, IntFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureIntIntBooleanInt2Boolean(f: (iFun, iFun, bFun, iFun) => bFun): String = getSignature(List(IntFun, IntFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureIntIntBooleanLong2Boolean(f: (iFun, iFun, bFun, lFun) => bFun): String = getSignature(List(IntFun, IntFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureIntIntBooleanDouble2Boolean(f: (iFun, iFun, bFun, dFun) => bFun): String = getSignature(List(IntFun, IntFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureIntIntBooleanString2Boolean(f: (iFun, iFun, bFun, sFun) => bFun): String = getSignature(List(IntFun, IntFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureIntIntBooleanBoolean2Boolean(f: (iFun, iFun, bFun, bFun) => bFun): String = getSignature(List(IntFun, IntFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureIntLongIntInt2Boolean(f: (iFun, lFun, iFun, iFun) => bFun): String = getSignature(List(IntFun, LongFun, IntFun, IntFun), BooleanFun)
  def getSignatureIntLongIntLong2Boolean(f: (iFun, lFun, iFun, lFun) => bFun): String = getSignature(List(IntFun, LongFun, IntFun, LongFun), BooleanFun)
  def getSignatureIntLongIntDouble2Boolean(f: (iFun, lFun, iFun, dFun) => bFun): String = getSignature(List(IntFun, LongFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureIntLongIntString2Boolean(f: (iFun, lFun, iFun, sFun) => bFun): String = getSignature(List(IntFun, LongFun, IntFun, StringFun), BooleanFun)
  def getSignatureIntLongIntBoolean2Boolean(f: (iFun, lFun, iFun, bFun) => bFun): String = getSignature(List(IntFun, LongFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureIntLongLongInt2Boolean(f: (iFun, lFun, lFun, iFun) => bFun): String = getSignature(List(IntFun, LongFun, LongFun, IntFun), BooleanFun)
  def getSignatureIntLongLongLong2Boolean(f: (iFun, lFun, lFun, lFun) => bFun): String = getSignature(List(IntFun, LongFun, LongFun, LongFun), BooleanFun)
  def getSignatureIntLongLongDouble2Boolean(f: (iFun, lFun, lFun, dFun) => bFun): String = getSignature(List(IntFun, LongFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureIntLongLongString2Boolean(f: (iFun, lFun, lFun, sFun) => bFun): String = getSignature(List(IntFun, LongFun, LongFun, StringFun), BooleanFun)
  def getSignatureIntLongLongBoolean2Boolean(f: (iFun, lFun, lFun, bFun) => bFun): String = getSignature(List(IntFun, LongFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureIntLongDoubleInt2Boolean(f: (iFun, lFun, dFun, iFun) => bFun): String = getSignature(List(IntFun, LongFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureIntLongDoubleLong2Boolean(f: (iFun, lFun, dFun, lFun) => bFun): String = getSignature(List(IntFun, LongFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureIntLongDoubleDouble2Boolean(f: (iFun, lFun, dFun, dFun) => bFun): String = getSignature(List(IntFun, LongFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureIntLongDoubleString2Boolean(f: (iFun, lFun, dFun, sFun) => bFun): String = getSignature(List(IntFun, LongFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureIntLongDoubleBoolean2Boolean(f: (iFun, lFun, dFun, bFun) => bFun): String = getSignature(List(IntFun, LongFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureIntLongStringInt2Boolean(f: (iFun, lFun, sFun, iFun) => bFun): String = getSignature(List(IntFun, LongFun, StringFun, IntFun), BooleanFun)
  def getSignatureIntLongStringLong2Boolean(f: (iFun, lFun, sFun, lFun) => bFun): String = getSignature(List(IntFun, LongFun, StringFun, LongFun), BooleanFun)
  def getSignatureIntLongStringDouble2Boolean(f: (iFun, lFun, sFun, dFun) => bFun): String = getSignature(List(IntFun, LongFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureIntLongStringString2Boolean(f: (iFun, lFun, sFun, sFun) => bFun): String = getSignature(List(IntFun, LongFun, StringFun, StringFun), BooleanFun)
  def getSignatureIntLongStringBoolean2Boolean(f: (iFun, lFun, sFun, bFun) => bFun): String = getSignature(List(IntFun, LongFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureIntLongBooleanInt2Boolean(f: (iFun, lFun, bFun, iFun) => bFun): String = getSignature(List(IntFun, LongFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureIntLongBooleanLong2Boolean(f: (iFun, lFun, bFun, lFun) => bFun): String = getSignature(List(IntFun, LongFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureIntLongBooleanDouble2Boolean(f: (iFun, lFun, bFun, dFun) => bFun): String = getSignature(List(IntFun, LongFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureIntLongBooleanString2Boolean(f: (iFun, lFun, bFun, sFun) => bFun): String = getSignature(List(IntFun, LongFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureIntLongBooleanBoolean2Boolean(f: (iFun, lFun, bFun, bFun) => bFun): String = getSignature(List(IntFun, LongFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureIntDoubleIntInt2Boolean(f: (iFun, dFun, iFun, iFun) => bFun): String = getSignature(List(IntFun, DoubleFun, IntFun, IntFun), BooleanFun)
  def getSignatureIntDoubleIntLong2Boolean(f: (iFun, dFun, iFun, lFun) => bFun): String = getSignature(List(IntFun, DoubleFun, IntFun, LongFun), BooleanFun)
  def getSignatureIntDoubleIntDouble2Boolean(f: (iFun, dFun, iFun, dFun) => bFun): String = getSignature(List(IntFun, DoubleFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureIntDoubleIntString2Boolean(f: (iFun, dFun, iFun, sFun) => bFun): String = getSignature(List(IntFun, DoubleFun, IntFun, StringFun), BooleanFun)
  def getSignatureIntDoubleIntBoolean2Boolean(f: (iFun, dFun, iFun, bFun) => bFun): String = getSignature(List(IntFun, DoubleFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureIntDoubleLongInt2Boolean(f: (iFun, dFun, lFun, iFun) => bFun): String = getSignature(List(IntFun, DoubleFun, LongFun, IntFun), BooleanFun)
  def getSignatureIntDoubleLongLong2Boolean(f: (iFun, dFun, lFun, lFun) => bFun): String = getSignature(List(IntFun, DoubleFun, LongFun, LongFun), BooleanFun)
  def getSignatureIntDoubleLongDouble2Boolean(f: (iFun, dFun, lFun, dFun) => bFun): String = getSignature(List(IntFun, DoubleFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureIntDoubleLongString2Boolean(f: (iFun, dFun, lFun, sFun) => bFun): String = getSignature(List(IntFun, DoubleFun, LongFun, StringFun), BooleanFun)
  def getSignatureIntDoubleLongBoolean2Boolean(f: (iFun, dFun, lFun, bFun) => bFun): String = getSignature(List(IntFun, DoubleFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureIntDoubleDoubleInt2Boolean(f: (iFun, dFun, dFun, iFun) => bFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureIntDoubleDoubleLong2Boolean(f: (iFun, dFun, dFun, lFun) => bFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureIntDoubleDoubleDouble2Boolean(f: (iFun, dFun, dFun, dFun) => bFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureIntDoubleDoubleString2Boolean(f: (iFun, dFun, dFun, sFun) => bFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureIntDoubleDoubleBoolean2Boolean(f: (iFun, dFun, dFun, bFun) => bFun): String = getSignature(List(IntFun, DoubleFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureIntDoubleStringInt2Boolean(f: (iFun, dFun, sFun, iFun) => bFun): String = getSignature(List(IntFun, DoubleFun, StringFun, IntFun), BooleanFun)
  def getSignatureIntDoubleStringLong2Boolean(f: (iFun, dFun, sFun, lFun) => bFun): String = getSignature(List(IntFun, DoubleFun, StringFun, LongFun), BooleanFun)
  def getSignatureIntDoubleStringDouble2Boolean(f: (iFun, dFun, sFun, dFun) => bFun): String = getSignature(List(IntFun, DoubleFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureIntDoubleStringString2Boolean(f: (iFun, dFun, sFun, sFun) => bFun): String = getSignature(List(IntFun, DoubleFun, StringFun, StringFun), BooleanFun)
  def getSignatureIntDoubleStringBoolean2Boolean(f: (iFun, dFun, sFun, bFun) => bFun): String = getSignature(List(IntFun, DoubleFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureIntDoubleBooleanInt2Boolean(f: (iFun, dFun, bFun, iFun) => bFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureIntDoubleBooleanLong2Boolean(f: (iFun, dFun, bFun, lFun) => bFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureIntDoubleBooleanDouble2Boolean(f: (iFun, dFun, bFun, dFun) => bFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureIntDoubleBooleanString2Boolean(f: (iFun, dFun, bFun, sFun) => bFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureIntDoubleBooleanBoolean2Boolean(f: (iFun, dFun, bFun, bFun) => bFun): String = getSignature(List(IntFun, DoubleFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureIntStringIntInt2Boolean(f: (iFun, sFun, iFun, iFun) => bFun): String = getSignature(List(IntFun, StringFun, IntFun, IntFun), BooleanFun)
  def getSignatureIntStringIntLong2Boolean(f: (iFun, sFun, iFun, lFun) => bFun): String = getSignature(List(IntFun, StringFun, IntFun, LongFun), BooleanFun)
  def getSignatureIntStringIntDouble2Boolean(f: (iFun, sFun, iFun, dFun) => bFun): String = getSignature(List(IntFun, StringFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureIntStringIntString2Boolean(f: (iFun, sFun, iFun, sFun) => bFun): String = getSignature(List(IntFun, StringFun, IntFun, StringFun), BooleanFun)
  def getSignatureIntStringIntBoolean2Boolean(f: (iFun, sFun, iFun, bFun) => bFun): String = getSignature(List(IntFun, StringFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureIntStringLongInt2Boolean(f: (iFun, sFun, lFun, iFun) => bFun): String = getSignature(List(IntFun, StringFun, LongFun, IntFun), BooleanFun)
  def getSignatureIntStringLongLong2Boolean(f: (iFun, sFun, lFun, lFun) => bFun): String = getSignature(List(IntFun, StringFun, LongFun, LongFun), BooleanFun)
  def getSignatureIntStringLongDouble2Boolean(f: (iFun, sFun, lFun, dFun) => bFun): String = getSignature(List(IntFun, StringFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureIntStringLongString2Boolean(f: (iFun, sFun, lFun, sFun) => bFun): String = getSignature(List(IntFun, StringFun, LongFun, StringFun), BooleanFun)
  def getSignatureIntStringLongBoolean2Boolean(f: (iFun, sFun, lFun, bFun) => bFun): String = getSignature(List(IntFun, StringFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureIntStringDoubleInt2Boolean(f: (iFun, sFun, dFun, iFun) => bFun): String = getSignature(List(IntFun, StringFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureIntStringDoubleLong2Boolean(f: (iFun, sFun, dFun, lFun) => bFun): String = getSignature(List(IntFun, StringFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureIntStringDoubleDouble2Boolean(f: (iFun, sFun, dFun, dFun) => bFun): String = getSignature(List(IntFun, StringFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureIntStringDoubleString2Boolean(f: (iFun, sFun, dFun, sFun) => bFun): String = getSignature(List(IntFun, StringFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureIntStringDoubleBoolean2Boolean(f: (iFun, sFun, dFun, bFun) => bFun): String = getSignature(List(IntFun, StringFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureIntStringStringInt2Boolean(f: (iFun, sFun, sFun, iFun) => bFun): String = getSignature(List(IntFun, StringFun, StringFun, IntFun), BooleanFun)
  def getSignatureIntStringStringLong2Boolean(f: (iFun, sFun, sFun, lFun) => bFun): String = getSignature(List(IntFun, StringFun, StringFun, LongFun), BooleanFun)
  def getSignatureIntStringStringDouble2Boolean(f: (iFun, sFun, sFun, dFun) => bFun): String = getSignature(List(IntFun, StringFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureIntStringStringString2Boolean(f: (iFun, sFun, sFun, sFun) => bFun): String = getSignature(List(IntFun, StringFun, StringFun, StringFun), BooleanFun)
  def getSignatureIntStringStringBoolean2Boolean(f: (iFun, sFun, sFun, bFun) => bFun): String = getSignature(List(IntFun, StringFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureIntStringBooleanInt2Boolean(f: (iFun, sFun, bFun, iFun) => bFun): String = getSignature(List(IntFun, StringFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureIntStringBooleanLong2Boolean(f: (iFun, sFun, bFun, lFun) => bFun): String = getSignature(List(IntFun, StringFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureIntStringBooleanDouble2Boolean(f: (iFun, sFun, bFun, dFun) => bFun): String = getSignature(List(IntFun, StringFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureIntStringBooleanString2Boolean(f: (iFun, sFun, bFun, sFun) => bFun): String = getSignature(List(IntFun, StringFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureIntStringBooleanBoolean2Boolean(f: (iFun, sFun, bFun, bFun) => bFun): String = getSignature(List(IntFun, StringFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureIntBooleanIntInt2Boolean(f: (iFun, bFun, iFun, iFun) => bFun): String = getSignature(List(IntFun, BooleanFun, IntFun, IntFun), BooleanFun)
  def getSignatureIntBooleanIntLong2Boolean(f: (iFun, bFun, iFun, lFun) => bFun): String = getSignature(List(IntFun, BooleanFun, IntFun, LongFun), BooleanFun)
  def getSignatureIntBooleanIntDouble2Boolean(f: (iFun, bFun, iFun, dFun) => bFun): String = getSignature(List(IntFun, BooleanFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureIntBooleanIntString2Boolean(f: (iFun, bFun, iFun, sFun) => bFun): String = getSignature(List(IntFun, BooleanFun, IntFun, StringFun), BooleanFun)
  def getSignatureIntBooleanIntBoolean2Boolean(f: (iFun, bFun, iFun, bFun) => bFun): String = getSignature(List(IntFun, BooleanFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureIntBooleanLongInt2Boolean(f: (iFun, bFun, lFun, iFun) => bFun): String = getSignature(List(IntFun, BooleanFun, LongFun, IntFun), BooleanFun)
  def getSignatureIntBooleanLongLong2Boolean(f: (iFun, bFun, lFun, lFun) => bFun): String = getSignature(List(IntFun, BooleanFun, LongFun, LongFun), BooleanFun)
  def getSignatureIntBooleanLongDouble2Boolean(f: (iFun, bFun, lFun, dFun) => bFun): String = getSignature(List(IntFun, BooleanFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureIntBooleanLongString2Boolean(f: (iFun, bFun, lFun, sFun) => bFun): String = getSignature(List(IntFun, BooleanFun, LongFun, StringFun), BooleanFun)
  def getSignatureIntBooleanLongBoolean2Boolean(f: (iFun, bFun, lFun, bFun) => bFun): String = getSignature(List(IntFun, BooleanFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureIntBooleanDoubleInt2Boolean(f: (iFun, bFun, dFun, iFun) => bFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureIntBooleanDoubleLong2Boolean(f: (iFun, bFun, dFun, lFun) => bFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureIntBooleanDoubleDouble2Boolean(f: (iFun, bFun, dFun, dFun) => bFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureIntBooleanDoubleString2Boolean(f: (iFun, bFun, dFun, sFun) => bFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureIntBooleanDoubleBoolean2Boolean(f: (iFun, bFun, dFun, bFun) => bFun): String = getSignature(List(IntFun, BooleanFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureIntBooleanStringInt2Boolean(f: (iFun, bFun, sFun, iFun) => bFun): String = getSignature(List(IntFun, BooleanFun, StringFun, IntFun), BooleanFun)
  def getSignatureIntBooleanStringLong2Boolean(f: (iFun, bFun, sFun, lFun) => bFun): String = getSignature(List(IntFun, BooleanFun, StringFun, LongFun), BooleanFun)
  def getSignatureIntBooleanStringDouble2Boolean(f: (iFun, bFun, sFun, dFun) => bFun): String = getSignature(List(IntFun, BooleanFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureIntBooleanStringString2Boolean(f: (iFun, bFun, sFun, sFun) => bFun): String = getSignature(List(IntFun, BooleanFun, StringFun, StringFun), BooleanFun)
  def getSignatureIntBooleanStringBoolean2Boolean(f: (iFun, bFun, sFun, bFun) => bFun): String = getSignature(List(IntFun, BooleanFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureIntBooleanBooleanInt2Boolean(f: (iFun, bFun, bFun, iFun) => bFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureIntBooleanBooleanLong2Boolean(f: (iFun, bFun, bFun, lFun) => bFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureIntBooleanBooleanDouble2Boolean(f: (iFun, bFun, bFun, dFun) => bFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureIntBooleanBooleanString2Boolean(f: (iFun, bFun, bFun, sFun) => bFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureIntBooleanBooleanBoolean2Boolean(f: (iFun, bFun, bFun, bFun) => bFun): String = getSignature(List(IntFun, BooleanFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureLongIntIntInt2Boolean(f: (lFun, iFun, iFun, iFun) => bFun): String = getSignature(List(LongFun, IntFun, IntFun, IntFun), BooleanFun)
  def getSignatureLongIntIntLong2Boolean(f: (lFun, iFun, iFun, lFun) => bFun): String = getSignature(List(LongFun, IntFun, IntFun, LongFun), BooleanFun)
  def getSignatureLongIntIntDouble2Boolean(f: (lFun, iFun, iFun, dFun) => bFun): String = getSignature(List(LongFun, IntFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureLongIntIntString2Boolean(f: (lFun, iFun, iFun, sFun) => bFun): String = getSignature(List(LongFun, IntFun, IntFun, StringFun), BooleanFun)
  def getSignatureLongIntIntBoolean2Boolean(f: (lFun, iFun, iFun, bFun) => bFun): String = getSignature(List(LongFun, IntFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureLongIntLongInt2Boolean(f: (lFun, iFun, lFun, iFun) => bFun): String = getSignature(List(LongFun, IntFun, LongFun, IntFun), BooleanFun)
  def getSignatureLongIntLongLong2Boolean(f: (lFun, iFun, lFun, lFun) => bFun): String = getSignature(List(LongFun, IntFun, LongFun, LongFun), BooleanFun)
  def getSignatureLongIntLongDouble2Boolean(f: (lFun, iFun, lFun, dFun) => bFun): String = getSignature(List(LongFun, IntFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureLongIntLongString2Boolean(f: (lFun, iFun, lFun, sFun) => bFun): String = getSignature(List(LongFun, IntFun, LongFun, StringFun), BooleanFun)
  def getSignatureLongIntLongBoolean2Boolean(f: (lFun, iFun, lFun, bFun) => bFun): String = getSignature(List(LongFun, IntFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureLongIntDoubleInt2Boolean(f: (lFun, iFun, dFun, iFun) => bFun): String = getSignature(List(LongFun, IntFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureLongIntDoubleLong2Boolean(f: (lFun, iFun, dFun, lFun) => bFun): String = getSignature(List(LongFun, IntFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureLongIntDoubleDouble2Boolean(f: (lFun, iFun, dFun, dFun) => bFun): String = getSignature(List(LongFun, IntFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureLongIntDoubleString2Boolean(f: (lFun, iFun, dFun, sFun) => bFun): String = getSignature(List(LongFun, IntFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureLongIntDoubleBoolean2Boolean(f: (lFun, iFun, dFun, bFun) => bFun): String = getSignature(List(LongFun, IntFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureLongIntStringInt2Boolean(f: (lFun, iFun, sFun, iFun) => bFun): String = getSignature(List(LongFun, IntFun, StringFun, IntFun), BooleanFun)
  def getSignatureLongIntStringLong2Boolean(f: (lFun, iFun, sFun, lFun) => bFun): String = getSignature(List(LongFun, IntFun, StringFun, LongFun), BooleanFun)
  def getSignatureLongIntStringDouble2Boolean(f: (lFun, iFun, sFun, dFun) => bFun): String = getSignature(List(LongFun, IntFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureLongIntStringString2Boolean(f: (lFun, iFun, sFun, sFun) => bFun): String = getSignature(List(LongFun, IntFun, StringFun, StringFun), BooleanFun)
  def getSignatureLongIntStringBoolean2Boolean(f: (lFun, iFun, sFun, bFun) => bFun): String = getSignature(List(LongFun, IntFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureLongIntBooleanInt2Boolean(f: (lFun, iFun, bFun, iFun) => bFun): String = getSignature(List(LongFun, IntFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureLongIntBooleanLong2Boolean(f: (lFun, iFun, bFun, lFun) => bFun): String = getSignature(List(LongFun, IntFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureLongIntBooleanDouble2Boolean(f: (lFun, iFun, bFun, dFun) => bFun): String = getSignature(List(LongFun, IntFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureLongIntBooleanString2Boolean(f: (lFun, iFun, bFun, sFun) => bFun): String = getSignature(List(LongFun, IntFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureLongIntBooleanBoolean2Boolean(f: (lFun, iFun, bFun, bFun) => bFun): String = getSignature(List(LongFun, IntFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureLongLongIntInt2Boolean(f: (lFun, lFun, iFun, iFun) => bFun): String = getSignature(List(LongFun, LongFun, IntFun, IntFun), BooleanFun)
  def getSignatureLongLongIntLong2Boolean(f: (lFun, lFun, iFun, lFun) => bFun): String = getSignature(List(LongFun, LongFun, IntFun, LongFun), BooleanFun)
  def getSignatureLongLongIntDouble2Boolean(f: (lFun, lFun, iFun, dFun) => bFun): String = getSignature(List(LongFun, LongFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureLongLongIntString2Boolean(f: (lFun, lFun, iFun, sFun) => bFun): String = getSignature(List(LongFun, LongFun, IntFun, StringFun), BooleanFun)
  def getSignatureLongLongIntBoolean2Boolean(f: (lFun, lFun, iFun, bFun) => bFun): String = getSignature(List(LongFun, LongFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureLongLongLongInt2Boolean(f: (lFun, lFun, lFun, iFun) => bFun): String = getSignature(List(LongFun, LongFun, LongFun, IntFun), BooleanFun)
  def getSignatureLongLongLongLong2Boolean(f: (lFun, lFun, lFun, lFun) => bFun): String = getSignature(List(LongFun, LongFun, LongFun, LongFun), BooleanFun)
  def getSignatureLongLongLongDouble2Boolean(f: (lFun, lFun, lFun, dFun) => bFun): String = getSignature(List(LongFun, LongFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureLongLongLongString2Boolean(f: (lFun, lFun, lFun, sFun) => bFun): String = getSignature(List(LongFun, LongFun, LongFun, StringFun), BooleanFun)
  def getSignatureLongLongLongBoolean2Boolean(f: (lFun, lFun, lFun, bFun) => bFun): String = getSignature(List(LongFun, LongFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureLongLongDoubleInt2Boolean(f: (lFun, lFun, dFun, iFun) => bFun): String = getSignature(List(LongFun, LongFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureLongLongDoubleLong2Boolean(f: (lFun, lFun, dFun, lFun) => bFun): String = getSignature(List(LongFun, LongFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureLongLongDoubleDouble2Boolean(f: (lFun, lFun, dFun, dFun) => bFun): String = getSignature(List(LongFun, LongFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureLongLongDoubleString2Boolean(f: (lFun, lFun, dFun, sFun) => bFun): String = getSignature(List(LongFun, LongFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureLongLongDoubleBoolean2Boolean(f: (lFun, lFun, dFun, bFun) => bFun): String = getSignature(List(LongFun, LongFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureLongLongStringInt2Boolean(f: (lFun, lFun, sFun, iFun) => bFun): String = getSignature(List(LongFun, LongFun, StringFun, IntFun), BooleanFun)
  def getSignatureLongLongStringLong2Boolean(f: (lFun, lFun, sFun, lFun) => bFun): String = getSignature(List(LongFun, LongFun, StringFun, LongFun), BooleanFun)
  def getSignatureLongLongStringDouble2Boolean(f: (lFun, lFun, sFun, dFun) => bFun): String = getSignature(List(LongFun, LongFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureLongLongStringString2Boolean(f: (lFun, lFun, sFun, sFun) => bFun): String = getSignature(List(LongFun, LongFun, StringFun, StringFun), BooleanFun)
  def getSignatureLongLongStringBoolean2Boolean(f: (lFun, lFun, sFun, bFun) => bFun): String = getSignature(List(LongFun, LongFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureLongLongBooleanInt2Boolean(f: (lFun, lFun, bFun, iFun) => bFun): String = getSignature(List(LongFun, LongFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureLongLongBooleanLong2Boolean(f: (lFun, lFun, bFun, lFun) => bFun): String = getSignature(List(LongFun, LongFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureLongLongBooleanDouble2Boolean(f: (lFun, lFun, bFun, dFun) => bFun): String = getSignature(List(LongFun, LongFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureLongLongBooleanString2Boolean(f: (lFun, lFun, bFun, sFun) => bFun): String = getSignature(List(LongFun, LongFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureLongLongBooleanBoolean2Boolean(f: (lFun, lFun, bFun, bFun) => bFun): String = getSignature(List(LongFun, LongFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureLongDoubleIntInt2Boolean(f: (lFun, dFun, iFun, iFun) => bFun): String = getSignature(List(LongFun, DoubleFun, IntFun, IntFun), BooleanFun)
  def getSignatureLongDoubleIntLong2Boolean(f: (lFun, dFun, iFun, lFun) => bFun): String = getSignature(List(LongFun, DoubleFun, IntFun, LongFun), BooleanFun)
  def getSignatureLongDoubleIntDouble2Boolean(f: (lFun, dFun, iFun, dFun) => bFun): String = getSignature(List(LongFun, DoubleFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureLongDoubleIntString2Boolean(f: (lFun, dFun, iFun, sFun) => bFun): String = getSignature(List(LongFun, DoubleFun, IntFun, StringFun), BooleanFun)
  def getSignatureLongDoubleIntBoolean2Boolean(f: (lFun, dFun, iFun, bFun) => bFun): String = getSignature(List(LongFun, DoubleFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureLongDoubleLongInt2Boolean(f: (lFun, dFun, lFun, iFun) => bFun): String = getSignature(List(LongFun, DoubleFun, LongFun, IntFun), BooleanFun)
  def getSignatureLongDoubleLongLong2Boolean(f: (lFun, dFun, lFun, lFun) => bFun): String = getSignature(List(LongFun, DoubleFun, LongFun, LongFun), BooleanFun)
  def getSignatureLongDoubleLongDouble2Boolean(f: (lFun, dFun, lFun, dFun) => bFun): String = getSignature(List(LongFun, DoubleFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureLongDoubleLongString2Boolean(f: (lFun, dFun, lFun, sFun) => bFun): String = getSignature(List(LongFun, DoubleFun, LongFun, StringFun), BooleanFun)
  def getSignatureLongDoubleLongBoolean2Boolean(f: (lFun, dFun, lFun, bFun) => bFun): String = getSignature(List(LongFun, DoubleFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureLongDoubleDoubleInt2Boolean(f: (lFun, dFun, dFun, iFun) => bFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureLongDoubleDoubleLong2Boolean(f: (lFun, dFun, dFun, lFun) => bFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureLongDoubleDoubleDouble2Boolean(f: (lFun, dFun, dFun, dFun) => bFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureLongDoubleDoubleString2Boolean(f: (lFun, dFun, dFun, sFun) => bFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureLongDoubleDoubleBoolean2Boolean(f: (lFun, dFun, dFun, bFun) => bFun): String = getSignature(List(LongFun, DoubleFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureLongDoubleStringInt2Boolean(f: (lFun, dFun, sFun, iFun) => bFun): String = getSignature(List(LongFun, DoubleFun, StringFun, IntFun), BooleanFun)
  def getSignatureLongDoubleStringLong2Boolean(f: (lFun, dFun, sFun, lFun) => bFun): String = getSignature(List(LongFun, DoubleFun, StringFun, LongFun), BooleanFun)
  def getSignatureLongDoubleStringDouble2Boolean(f: (lFun, dFun, sFun, dFun) => bFun): String = getSignature(List(LongFun, DoubleFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureLongDoubleStringString2Boolean(f: (lFun, dFun, sFun, sFun) => bFun): String = getSignature(List(LongFun, DoubleFun, StringFun, StringFun), BooleanFun)
  def getSignatureLongDoubleStringBoolean2Boolean(f: (lFun, dFun, sFun, bFun) => bFun): String = getSignature(List(LongFun, DoubleFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureLongDoubleBooleanInt2Boolean(f: (lFun, dFun, bFun, iFun) => bFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureLongDoubleBooleanLong2Boolean(f: (lFun, dFun, bFun, lFun) => bFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureLongDoubleBooleanDouble2Boolean(f: (lFun, dFun, bFun, dFun) => bFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureLongDoubleBooleanString2Boolean(f: (lFun, dFun, bFun, sFun) => bFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureLongDoubleBooleanBoolean2Boolean(f: (lFun, dFun, bFun, bFun) => bFun): String = getSignature(List(LongFun, DoubleFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureLongStringIntInt2Boolean(f: (lFun, sFun, iFun, iFun) => bFun): String = getSignature(List(LongFun, StringFun, IntFun, IntFun), BooleanFun)
  def getSignatureLongStringIntLong2Boolean(f: (lFun, sFun, iFun, lFun) => bFun): String = getSignature(List(LongFun, StringFun, IntFun, LongFun), BooleanFun)
  def getSignatureLongStringIntDouble2Boolean(f: (lFun, sFun, iFun, dFun) => bFun): String = getSignature(List(LongFun, StringFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureLongStringIntString2Boolean(f: (lFun, sFun, iFun, sFun) => bFun): String = getSignature(List(LongFun, StringFun, IntFun, StringFun), BooleanFun)
  def getSignatureLongStringIntBoolean2Boolean(f: (lFun, sFun, iFun, bFun) => bFun): String = getSignature(List(LongFun, StringFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureLongStringLongInt2Boolean(f: (lFun, sFun, lFun, iFun) => bFun): String = getSignature(List(LongFun, StringFun, LongFun, IntFun), BooleanFun)
  def getSignatureLongStringLongLong2Boolean(f: (lFun, sFun, lFun, lFun) => bFun): String = getSignature(List(LongFun, StringFun, LongFun, LongFun), BooleanFun)
  def getSignatureLongStringLongDouble2Boolean(f: (lFun, sFun, lFun, dFun) => bFun): String = getSignature(List(LongFun, StringFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureLongStringLongString2Boolean(f: (lFun, sFun, lFun, sFun) => bFun): String = getSignature(List(LongFun, StringFun, LongFun, StringFun), BooleanFun)
  def getSignatureLongStringLongBoolean2Boolean(f: (lFun, sFun, lFun, bFun) => bFun): String = getSignature(List(LongFun, StringFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureLongStringDoubleInt2Boolean(f: (lFun, sFun, dFun, iFun) => bFun): String = getSignature(List(LongFun, StringFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureLongStringDoubleLong2Boolean(f: (lFun, sFun, dFun, lFun) => bFun): String = getSignature(List(LongFun, StringFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureLongStringDoubleDouble2Boolean(f: (lFun, sFun, dFun, dFun) => bFun): String = getSignature(List(LongFun, StringFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureLongStringDoubleString2Boolean(f: (lFun, sFun, dFun, sFun) => bFun): String = getSignature(List(LongFun, StringFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureLongStringDoubleBoolean2Boolean(f: (lFun, sFun, dFun, bFun) => bFun): String = getSignature(List(LongFun, StringFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureLongStringStringInt2Boolean(f: (lFun, sFun, sFun, iFun) => bFun): String = getSignature(List(LongFun, StringFun, StringFun, IntFun), BooleanFun)
  def getSignatureLongStringStringLong2Boolean(f: (lFun, sFun, sFun, lFun) => bFun): String = getSignature(List(LongFun, StringFun, StringFun, LongFun), BooleanFun)
  def getSignatureLongStringStringDouble2Boolean(f: (lFun, sFun, sFun, dFun) => bFun): String = getSignature(List(LongFun, StringFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureLongStringStringString2Boolean(f: (lFun, sFun, sFun, sFun) => bFun): String = getSignature(List(LongFun, StringFun, StringFun, StringFun), BooleanFun)
  def getSignatureLongStringStringBoolean2Boolean(f: (lFun, sFun, sFun, bFun) => bFun): String = getSignature(List(LongFun, StringFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureLongStringBooleanInt2Boolean(f: (lFun, sFun, bFun, iFun) => bFun): String = getSignature(List(LongFun, StringFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureLongStringBooleanLong2Boolean(f: (lFun, sFun, bFun, lFun) => bFun): String = getSignature(List(LongFun, StringFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureLongStringBooleanDouble2Boolean(f: (lFun, sFun, bFun, dFun) => bFun): String = getSignature(List(LongFun, StringFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureLongStringBooleanString2Boolean(f: (lFun, sFun, bFun, sFun) => bFun): String = getSignature(List(LongFun, StringFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureLongStringBooleanBoolean2Boolean(f: (lFun, sFun, bFun, bFun) => bFun): String = getSignature(List(LongFun, StringFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureLongBooleanIntInt2Boolean(f: (lFun, bFun, iFun, iFun) => bFun): String = getSignature(List(LongFun, BooleanFun, IntFun, IntFun), BooleanFun)
  def getSignatureLongBooleanIntLong2Boolean(f: (lFun, bFun, iFun, lFun) => bFun): String = getSignature(List(LongFun, BooleanFun, IntFun, LongFun), BooleanFun)
  def getSignatureLongBooleanIntDouble2Boolean(f: (lFun, bFun, iFun, dFun) => bFun): String = getSignature(List(LongFun, BooleanFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureLongBooleanIntString2Boolean(f: (lFun, bFun, iFun, sFun) => bFun): String = getSignature(List(LongFun, BooleanFun, IntFun, StringFun), BooleanFun)
  def getSignatureLongBooleanIntBoolean2Boolean(f: (lFun, bFun, iFun, bFun) => bFun): String = getSignature(List(LongFun, BooleanFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureLongBooleanLongInt2Boolean(f: (lFun, bFun, lFun, iFun) => bFun): String = getSignature(List(LongFun, BooleanFun, LongFun, IntFun), BooleanFun)
  def getSignatureLongBooleanLongLong2Boolean(f: (lFun, bFun, lFun, lFun) => bFun): String = getSignature(List(LongFun, BooleanFun, LongFun, LongFun), BooleanFun)
  def getSignatureLongBooleanLongDouble2Boolean(f: (lFun, bFun, lFun, dFun) => bFun): String = getSignature(List(LongFun, BooleanFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureLongBooleanLongString2Boolean(f: (lFun, bFun, lFun, sFun) => bFun): String = getSignature(List(LongFun, BooleanFun, LongFun, StringFun), BooleanFun)
  def getSignatureLongBooleanLongBoolean2Boolean(f: (lFun, bFun, lFun, bFun) => bFun): String = getSignature(List(LongFun, BooleanFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureLongBooleanDoubleInt2Boolean(f: (lFun, bFun, dFun, iFun) => bFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureLongBooleanDoubleLong2Boolean(f: (lFun, bFun, dFun, lFun) => bFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureLongBooleanDoubleDouble2Boolean(f: (lFun, bFun, dFun, dFun) => bFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureLongBooleanDoubleString2Boolean(f: (lFun, bFun, dFun, sFun) => bFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureLongBooleanDoubleBoolean2Boolean(f: (lFun, bFun, dFun, bFun) => bFun): String = getSignature(List(LongFun, BooleanFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureLongBooleanStringInt2Boolean(f: (lFun, bFun, sFun, iFun) => bFun): String = getSignature(List(LongFun, BooleanFun, StringFun, IntFun), BooleanFun)
  def getSignatureLongBooleanStringLong2Boolean(f: (lFun, bFun, sFun, lFun) => bFun): String = getSignature(List(LongFun, BooleanFun, StringFun, LongFun), BooleanFun)
  def getSignatureLongBooleanStringDouble2Boolean(f: (lFun, bFun, sFun, dFun) => bFun): String = getSignature(List(LongFun, BooleanFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureLongBooleanStringString2Boolean(f: (lFun, bFun, sFun, sFun) => bFun): String = getSignature(List(LongFun, BooleanFun, StringFun, StringFun), BooleanFun)
  def getSignatureLongBooleanStringBoolean2Boolean(f: (lFun, bFun, sFun, bFun) => bFun): String = getSignature(List(LongFun, BooleanFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureLongBooleanBooleanInt2Boolean(f: (lFun, bFun, bFun, iFun) => bFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureLongBooleanBooleanLong2Boolean(f: (lFun, bFun, bFun, lFun) => bFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureLongBooleanBooleanDouble2Boolean(f: (lFun, bFun, bFun, dFun) => bFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureLongBooleanBooleanString2Boolean(f: (lFun, bFun, bFun, sFun) => bFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureLongBooleanBooleanBoolean2Boolean(f: (lFun, bFun, bFun, bFun) => bFun): String = getSignature(List(LongFun, BooleanFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureDoubleIntIntInt2Boolean(f: (dFun, iFun, iFun, iFun) => bFun): String = getSignature(List(DoubleFun, IntFun, IntFun, IntFun), BooleanFun)
  def getSignatureDoubleIntIntLong2Boolean(f: (dFun, iFun, iFun, lFun) => bFun): String = getSignature(List(DoubleFun, IntFun, IntFun, LongFun), BooleanFun)
  def getSignatureDoubleIntIntDouble2Boolean(f: (dFun, iFun, iFun, dFun) => bFun): String = getSignature(List(DoubleFun, IntFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureDoubleIntIntString2Boolean(f: (dFun, iFun, iFun, sFun) => bFun): String = getSignature(List(DoubleFun, IntFun, IntFun, StringFun), BooleanFun)
  def getSignatureDoubleIntIntBoolean2Boolean(f: (dFun, iFun, iFun, bFun) => bFun): String = getSignature(List(DoubleFun, IntFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureDoubleIntLongInt2Boolean(f: (dFun, iFun, lFun, iFun) => bFun): String = getSignature(List(DoubleFun, IntFun, LongFun, IntFun), BooleanFun)
  def getSignatureDoubleIntLongLong2Boolean(f: (dFun, iFun, lFun, lFun) => bFun): String = getSignature(List(DoubleFun, IntFun, LongFun, LongFun), BooleanFun)
  def getSignatureDoubleIntLongDouble2Boolean(f: (dFun, iFun, lFun, dFun) => bFun): String = getSignature(List(DoubleFun, IntFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureDoubleIntLongString2Boolean(f: (dFun, iFun, lFun, sFun) => bFun): String = getSignature(List(DoubleFun, IntFun, LongFun, StringFun), BooleanFun)
  def getSignatureDoubleIntLongBoolean2Boolean(f: (dFun, iFun, lFun, bFun) => bFun): String = getSignature(List(DoubleFun, IntFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureDoubleIntDoubleInt2Boolean(f: (dFun, iFun, dFun, iFun) => bFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureDoubleIntDoubleLong2Boolean(f: (dFun, iFun, dFun, lFun) => bFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureDoubleIntDoubleDouble2Boolean(f: (dFun, iFun, dFun, dFun) => bFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureDoubleIntDoubleString2Boolean(f: (dFun, iFun, dFun, sFun) => bFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureDoubleIntDoubleBoolean2Boolean(f: (dFun, iFun, dFun, bFun) => bFun): String = getSignature(List(DoubleFun, IntFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureDoubleIntStringInt2Boolean(f: (dFun, iFun, sFun, iFun) => bFun): String = getSignature(List(DoubleFun, IntFun, StringFun, IntFun), BooleanFun)
  def getSignatureDoubleIntStringLong2Boolean(f: (dFun, iFun, sFun, lFun) => bFun): String = getSignature(List(DoubleFun, IntFun, StringFun, LongFun), BooleanFun)
  def getSignatureDoubleIntStringDouble2Boolean(f: (dFun, iFun, sFun, dFun) => bFun): String = getSignature(List(DoubleFun, IntFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureDoubleIntStringString2Boolean(f: (dFun, iFun, sFun, sFun) => bFun): String = getSignature(List(DoubleFun, IntFun, StringFun, StringFun), BooleanFun)
  def getSignatureDoubleIntStringBoolean2Boolean(f: (dFun, iFun, sFun, bFun) => bFun): String = getSignature(List(DoubleFun, IntFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureDoubleIntBooleanInt2Boolean(f: (dFun, iFun, bFun, iFun) => bFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureDoubleIntBooleanLong2Boolean(f: (dFun, iFun, bFun, lFun) => bFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureDoubleIntBooleanDouble2Boolean(f: (dFun, iFun, bFun, dFun) => bFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureDoubleIntBooleanString2Boolean(f: (dFun, iFun, bFun, sFun) => bFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureDoubleIntBooleanBoolean2Boolean(f: (dFun, iFun, bFun, bFun) => bFun): String = getSignature(List(DoubleFun, IntFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureDoubleLongIntInt2Boolean(f: (dFun, lFun, iFun, iFun) => bFun): String = getSignature(List(DoubleFun, LongFun, IntFun, IntFun), BooleanFun)
  def getSignatureDoubleLongIntLong2Boolean(f: (dFun, lFun, iFun, lFun) => bFun): String = getSignature(List(DoubleFun, LongFun, IntFun, LongFun), BooleanFun)
  def getSignatureDoubleLongIntDouble2Boolean(f: (dFun, lFun, iFun, dFun) => bFun): String = getSignature(List(DoubleFun, LongFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureDoubleLongIntString2Boolean(f: (dFun, lFun, iFun, sFun) => bFun): String = getSignature(List(DoubleFun, LongFun, IntFun, StringFun), BooleanFun)
  def getSignatureDoubleLongIntBoolean2Boolean(f: (dFun, lFun, iFun, bFun) => bFun): String = getSignature(List(DoubleFun, LongFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureDoubleLongLongInt2Boolean(f: (dFun, lFun, lFun, iFun) => bFun): String = getSignature(List(DoubleFun, LongFun, LongFun, IntFun), BooleanFun)
  def getSignatureDoubleLongLongLong2Boolean(f: (dFun, lFun, lFun, lFun) => bFun): String = getSignature(List(DoubleFun, LongFun, LongFun, LongFun), BooleanFun)
  def getSignatureDoubleLongLongDouble2Boolean(f: (dFun, lFun, lFun, dFun) => bFun): String = getSignature(List(DoubleFun, LongFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureDoubleLongLongString2Boolean(f: (dFun, lFun, lFun, sFun) => bFun): String = getSignature(List(DoubleFun, LongFun, LongFun, StringFun), BooleanFun)
  def getSignatureDoubleLongLongBoolean2Boolean(f: (dFun, lFun, lFun, bFun) => bFun): String = getSignature(List(DoubleFun, LongFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureDoubleLongDoubleInt2Boolean(f: (dFun, lFun, dFun, iFun) => bFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureDoubleLongDoubleLong2Boolean(f: (dFun, lFun, dFun, lFun) => bFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureDoubleLongDoubleDouble2Boolean(f: (dFun, lFun, dFun, dFun) => bFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureDoubleLongDoubleString2Boolean(f: (dFun, lFun, dFun, sFun) => bFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureDoubleLongDoubleBoolean2Boolean(f: (dFun, lFun, dFun, bFun) => bFun): String = getSignature(List(DoubleFun, LongFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureDoubleLongStringInt2Boolean(f: (dFun, lFun, sFun, iFun) => bFun): String = getSignature(List(DoubleFun, LongFun, StringFun, IntFun), BooleanFun)
  def getSignatureDoubleLongStringLong2Boolean(f: (dFun, lFun, sFun, lFun) => bFun): String = getSignature(List(DoubleFun, LongFun, StringFun, LongFun), BooleanFun)
  def getSignatureDoubleLongStringDouble2Boolean(f: (dFun, lFun, sFun, dFun) => bFun): String = getSignature(List(DoubleFun, LongFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureDoubleLongStringString2Boolean(f: (dFun, lFun, sFun, sFun) => bFun): String = getSignature(List(DoubleFun, LongFun, StringFun, StringFun), BooleanFun)
  def getSignatureDoubleLongStringBoolean2Boolean(f: (dFun, lFun, sFun, bFun) => bFun): String = getSignature(List(DoubleFun, LongFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureDoubleLongBooleanInt2Boolean(f: (dFun, lFun, bFun, iFun) => bFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureDoubleLongBooleanLong2Boolean(f: (dFun, lFun, bFun, lFun) => bFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureDoubleLongBooleanDouble2Boolean(f: (dFun, lFun, bFun, dFun) => bFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureDoubleLongBooleanString2Boolean(f: (dFun, lFun, bFun, sFun) => bFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureDoubleLongBooleanBoolean2Boolean(f: (dFun, lFun, bFun, bFun) => bFun): String = getSignature(List(DoubleFun, LongFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureDoubleDoubleIntInt2Boolean(f: (dFun, dFun, iFun, iFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, IntFun), BooleanFun)
  def getSignatureDoubleDoubleIntLong2Boolean(f: (dFun, dFun, iFun, lFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, LongFun), BooleanFun)
  def getSignatureDoubleDoubleIntDouble2Boolean(f: (dFun, dFun, iFun, dFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureDoubleDoubleIntString2Boolean(f: (dFun, dFun, iFun, sFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, StringFun), BooleanFun)
  def getSignatureDoubleDoubleIntBoolean2Boolean(f: (dFun, dFun, iFun, bFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureDoubleDoubleLongInt2Boolean(f: (dFun, dFun, lFun, iFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, IntFun), BooleanFun)
  def getSignatureDoubleDoubleLongLong2Boolean(f: (dFun, dFun, lFun, lFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, LongFun), BooleanFun)
  def getSignatureDoubleDoubleLongDouble2Boolean(f: (dFun, dFun, lFun, dFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureDoubleDoubleLongString2Boolean(f: (dFun, dFun, lFun, sFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, StringFun), BooleanFun)
  def getSignatureDoubleDoubleLongBoolean2Boolean(f: (dFun, dFun, lFun, bFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureDoubleDoubleDoubleInt2Boolean(f: (dFun, dFun, dFun, iFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureDoubleDoubleDoubleLong2Boolean(f: (dFun, dFun, dFun, lFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureDoubleDoubleDoubleDouble2Boolean(f: (dFun, dFun, dFun, dFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureDoubleDoubleDoubleString2Boolean(f: (dFun, dFun, dFun, sFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureDoubleDoubleDoubleBoolean2Boolean(f: (dFun, dFun, dFun, bFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureDoubleDoubleStringInt2Boolean(f: (dFun, dFun, sFun, iFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, IntFun), BooleanFun)
  def getSignatureDoubleDoubleStringLong2Boolean(f: (dFun, dFun, sFun, lFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, LongFun), BooleanFun)
  def getSignatureDoubleDoubleStringDouble2Boolean(f: (dFun, dFun, sFun, dFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureDoubleDoubleStringString2Boolean(f: (dFun, dFun, sFun, sFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, StringFun), BooleanFun)
  def getSignatureDoubleDoubleStringBoolean2Boolean(f: (dFun, dFun, sFun, bFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureDoubleDoubleBooleanInt2Boolean(f: (dFun, dFun, bFun, iFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureDoubleDoubleBooleanLong2Boolean(f: (dFun, dFun, bFun, lFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureDoubleDoubleBooleanDouble2Boolean(f: (dFun, dFun, bFun, dFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureDoubleDoubleBooleanString2Boolean(f: (dFun, dFun, bFun, sFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureDoubleDoubleBooleanBoolean2Boolean(f: (dFun, dFun, bFun, bFun) => bFun): String = getSignature(List(DoubleFun, DoubleFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureDoubleStringIntInt2Boolean(f: (dFun, sFun, iFun, iFun) => bFun): String = getSignature(List(DoubleFun, StringFun, IntFun, IntFun), BooleanFun)
  def getSignatureDoubleStringIntLong2Boolean(f: (dFun, sFun, iFun, lFun) => bFun): String = getSignature(List(DoubleFun, StringFun, IntFun, LongFun), BooleanFun)
  def getSignatureDoubleStringIntDouble2Boolean(f: (dFun, sFun, iFun, dFun) => bFun): String = getSignature(List(DoubleFun, StringFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureDoubleStringIntString2Boolean(f: (dFun, sFun, iFun, sFun) => bFun): String = getSignature(List(DoubleFun, StringFun, IntFun, StringFun), BooleanFun)
  def getSignatureDoubleStringIntBoolean2Boolean(f: (dFun, sFun, iFun, bFun) => bFun): String = getSignature(List(DoubleFun, StringFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureDoubleStringLongInt2Boolean(f: (dFun, sFun, lFun, iFun) => bFun): String = getSignature(List(DoubleFun, StringFun, LongFun, IntFun), BooleanFun)
  def getSignatureDoubleStringLongLong2Boolean(f: (dFun, sFun, lFun, lFun) => bFun): String = getSignature(List(DoubleFun, StringFun, LongFun, LongFun), BooleanFun)
  def getSignatureDoubleStringLongDouble2Boolean(f: (dFun, sFun, lFun, dFun) => bFun): String = getSignature(List(DoubleFun, StringFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureDoubleStringLongString2Boolean(f: (dFun, sFun, lFun, sFun) => bFun): String = getSignature(List(DoubleFun, StringFun, LongFun, StringFun), BooleanFun)
  def getSignatureDoubleStringLongBoolean2Boolean(f: (dFun, sFun, lFun, bFun) => bFun): String = getSignature(List(DoubleFun, StringFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureDoubleStringDoubleInt2Boolean(f: (dFun, sFun, dFun, iFun) => bFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureDoubleStringDoubleLong2Boolean(f: (dFun, sFun, dFun, lFun) => bFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureDoubleStringDoubleDouble2Boolean(f: (dFun, sFun, dFun, dFun) => bFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureDoubleStringDoubleString2Boolean(f: (dFun, sFun, dFun, sFun) => bFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureDoubleStringDoubleBoolean2Boolean(f: (dFun, sFun, dFun, bFun) => bFun): String = getSignature(List(DoubleFun, StringFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureDoubleStringStringInt2Boolean(f: (dFun, sFun, sFun, iFun) => bFun): String = getSignature(List(DoubleFun, StringFun, StringFun, IntFun), BooleanFun)
  def getSignatureDoubleStringStringLong2Boolean(f: (dFun, sFun, sFun, lFun) => bFun): String = getSignature(List(DoubleFun, StringFun, StringFun, LongFun), BooleanFun)
  def getSignatureDoubleStringStringDouble2Boolean(f: (dFun, sFun, sFun, dFun) => bFun): String = getSignature(List(DoubleFun, StringFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureDoubleStringStringString2Boolean(f: (dFun, sFun, sFun, sFun) => bFun): String = getSignature(List(DoubleFun, StringFun, StringFun, StringFun), BooleanFun)
  def getSignatureDoubleStringStringBoolean2Boolean(f: (dFun, sFun, sFun, bFun) => bFun): String = getSignature(List(DoubleFun, StringFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureDoubleStringBooleanInt2Boolean(f: (dFun, sFun, bFun, iFun) => bFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureDoubleStringBooleanLong2Boolean(f: (dFun, sFun, bFun, lFun) => bFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureDoubleStringBooleanDouble2Boolean(f: (dFun, sFun, bFun, dFun) => bFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureDoubleStringBooleanString2Boolean(f: (dFun, sFun, bFun, sFun) => bFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureDoubleStringBooleanBoolean2Boolean(f: (dFun, sFun, bFun, bFun) => bFun): String = getSignature(List(DoubleFun, StringFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureDoubleBooleanIntInt2Boolean(f: (dFun, bFun, iFun, iFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, IntFun), BooleanFun)
  def getSignatureDoubleBooleanIntLong2Boolean(f: (dFun, bFun, iFun, lFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, LongFun), BooleanFun)
  def getSignatureDoubleBooleanIntDouble2Boolean(f: (dFun, bFun, iFun, dFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureDoubleBooleanIntString2Boolean(f: (dFun, bFun, iFun, sFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, StringFun), BooleanFun)
  def getSignatureDoubleBooleanIntBoolean2Boolean(f: (dFun, bFun, iFun, bFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureDoubleBooleanLongInt2Boolean(f: (dFun, bFun, lFun, iFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, IntFun), BooleanFun)
  def getSignatureDoubleBooleanLongLong2Boolean(f: (dFun, bFun, lFun, lFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, LongFun), BooleanFun)
  def getSignatureDoubleBooleanLongDouble2Boolean(f: (dFun, bFun, lFun, dFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureDoubleBooleanLongString2Boolean(f: (dFun, bFun, lFun, sFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, StringFun), BooleanFun)
  def getSignatureDoubleBooleanLongBoolean2Boolean(f: (dFun, bFun, lFun, bFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureDoubleBooleanDoubleInt2Boolean(f: (dFun, bFun, dFun, iFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureDoubleBooleanDoubleLong2Boolean(f: (dFun, bFun, dFun, lFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureDoubleBooleanDoubleDouble2Boolean(f: (dFun, bFun, dFun, dFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureDoubleBooleanDoubleString2Boolean(f: (dFun, bFun, dFun, sFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureDoubleBooleanDoubleBoolean2Boolean(f: (dFun, bFun, dFun, bFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureDoubleBooleanStringInt2Boolean(f: (dFun, bFun, sFun, iFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, IntFun), BooleanFun)
  def getSignatureDoubleBooleanStringLong2Boolean(f: (dFun, bFun, sFun, lFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, LongFun), BooleanFun)
  def getSignatureDoubleBooleanStringDouble2Boolean(f: (dFun, bFun, sFun, dFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureDoubleBooleanStringString2Boolean(f: (dFun, bFun, sFun, sFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, StringFun), BooleanFun)
  def getSignatureDoubleBooleanStringBoolean2Boolean(f: (dFun, bFun, sFun, bFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureDoubleBooleanBooleanInt2Boolean(f: (dFun, bFun, bFun, iFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureDoubleBooleanBooleanLong2Boolean(f: (dFun, bFun, bFun, lFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureDoubleBooleanBooleanDouble2Boolean(f: (dFun, bFun, bFun, dFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureDoubleBooleanBooleanString2Boolean(f: (dFun, bFun, bFun, sFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureDoubleBooleanBooleanBoolean2Boolean(f: (dFun, bFun, bFun, bFun) => bFun): String = getSignature(List(DoubleFun, BooleanFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureStringIntIntInt2Boolean(f: (sFun, iFun, iFun, iFun) => bFun): String = getSignature(List(StringFun, IntFun, IntFun, IntFun), BooleanFun)
  def getSignatureStringIntIntLong2Boolean(f: (sFun, iFun, iFun, lFun) => bFun): String = getSignature(List(StringFun, IntFun, IntFun, LongFun), BooleanFun)
  def getSignatureStringIntIntDouble2Boolean(f: (sFun, iFun, iFun, dFun) => bFun): String = getSignature(List(StringFun, IntFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureStringIntIntString2Boolean(f: (sFun, iFun, iFun, sFun) => bFun): String = getSignature(List(StringFun, IntFun, IntFun, StringFun), BooleanFun)
  def getSignatureStringIntIntBoolean2Boolean(f: (sFun, iFun, iFun, bFun) => bFun): String = getSignature(List(StringFun, IntFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureStringIntLongInt2Boolean(f: (sFun, iFun, lFun, iFun) => bFun): String = getSignature(List(StringFun, IntFun, LongFun, IntFun), BooleanFun)
  def getSignatureStringIntLongLong2Boolean(f: (sFun, iFun, lFun, lFun) => bFun): String = getSignature(List(StringFun, IntFun, LongFun, LongFun), BooleanFun)
  def getSignatureStringIntLongDouble2Boolean(f: (sFun, iFun, lFun, dFun) => bFun): String = getSignature(List(StringFun, IntFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureStringIntLongString2Boolean(f: (sFun, iFun, lFun, sFun) => bFun): String = getSignature(List(StringFun, IntFun, LongFun, StringFun), BooleanFun)
  def getSignatureStringIntLongBoolean2Boolean(f: (sFun, iFun, lFun, bFun) => bFun): String = getSignature(List(StringFun, IntFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureStringIntDoubleInt2Boolean(f: (sFun, iFun, dFun, iFun) => bFun): String = getSignature(List(StringFun, IntFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureStringIntDoubleLong2Boolean(f: (sFun, iFun, dFun, lFun) => bFun): String = getSignature(List(StringFun, IntFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureStringIntDoubleDouble2Boolean(f: (sFun, iFun, dFun, dFun) => bFun): String = getSignature(List(StringFun, IntFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureStringIntDoubleString2Boolean(f: (sFun, iFun, dFun, sFun) => bFun): String = getSignature(List(StringFun, IntFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureStringIntDoubleBoolean2Boolean(f: (sFun, iFun, dFun, bFun) => bFun): String = getSignature(List(StringFun, IntFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureStringIntStringInt2Boolean(f: (sFun, iFun, sFun, iFun) => bFun): String = getSignature(List(StringFun, IntFun, StringFun, IntFun), BooleanFun)
  def getSignatureStringIntStringLong2Boolean(f: (sFun, iFun, sFun, lFun) => bFun): String = getSignature(List(StringFun, IntFun, StringFun, LongFun), BooleanFun)
  def getSignatureStringIntStringDouble2Boolean(f: (sFun, iFun, sFun, dFun) => bFun): String = getSignature(List(StringFun, IntFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureStringIntStringString2Boolean(f: (sFun, iFun, sFun, sFun) => bFun): String = getSignature(List(StringFun, IntFun, StringFun, StringFun), BooleanFun)
  def getSignatureStringIntStringBoolean2Boolean(f: (sFun, iFun, sFun, bFun) => bFun): String = getSignature(List(StringFun, IntFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureStringIntBooleanInt2Boolean(f: (sFun, iFun, bFun, iFun) => bFun): String = getSignature(List(StringFun, IntFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureStringIntBooleanLong2Boolean(f: (sFun, iFun, bFun, lFun) => bFun): String = getSignature(List(StringFun, IntFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureStringIntBooleanDouble2Boolean(f: (sFun, iFun, bFun, dFun) => bFun): String = getSignature(List(StringFun, IntFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureStringIntBooleanString2Boolean(f: (sFun, iFun, bFun, sFun) => bFun): String = getSignature(List(StringFun, IntFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureStringIntBooleanBoolean2Boolean(f: (sFun, iFun, bFun, bFun) => bFun): String = getSignature(List(StringFun, IntFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureStringLongIntInt2Boolean(f: (sFun, lFun, iFun, iFun) => bFun): String = getSignature(List(StringFun, LongFun, IntFun, IntFun), BooleanFun)
  def getSignatureStringLongIntLong2Boolean(f: (sFun, lFun, iFun, lFun) => bFun): String = getSignature(List(StringFun, LongFun, IntFun, LongFun), BooleanFun)
  def getSignatureStringLongIntDouble2Boolean(f: (sFun, lFun, iFun, dFun) => bFun): String = getSignature(List(StringFun, LongFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureStringLongIntString2Boolean(f: (sFun, lFun, iFun, sFun) => bFun): String = getSignature(List(StringFun, LongFun, IntFun, StringFun), BooleanFun)
  def getSignatureStringLongIntBoolean2Boolean(f: (sFun, lFun, iFun, bFun) => bFun): String = getSignature(List(StringFun, LongFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureStringLongLongInt2Boolean(f: (sFun, lFun, lFun, iFun) => bFun): String = getSignature(List(StringFun, LongFun, LongFun, IntFun), BooleanFun)
  def getSignatureStringLongLongLong2Boolean(f: (sFun, lFun, lFun, lFun) => bFun): String = getSignature(List(StringFun, LongFun, LongFun, LongFun), BooleanFun)
  def getSignatureStringLongLongDouble2Boolean(f: (sFun, lFun, lFun, dFun) => bFun): String = getSignature(List(StringFun, LongFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureStringLongLongString2Boolean(f: (sFun, lFun, lFun, sFun) => bFun): String = getSignature(List(StringFun, LongFun, LongFun, StringFun), BooleanFun)
  def getSignatureStringLongLongBoolean2Boolean(f: (sFun, lFun, lFun, bFun) => bFun): String = getSignature(List(StringFun, LongFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureStringLongDoubleInt2Boolean(f: (sFun, lFun, dFun, iFun) => bFun): String = getSignature(List(StringFun, LongFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureStringLongDoubleLong2Boolean(f: (sFun, lFun, dFun, lFun) => bFun): String = getSignature(List(StringFun, LongFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureStringLongDoubleDouble2Boolean(f: (sFun, lFun, dFun, dFun) => bFun): String = getSignature(List(StringFun, LongFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureStringLongDoubleString2Boolean(f: (sFun, lFun, dFun, sFun) => bFun): String = getSignature(List(StringFun, LongFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureStringLongDoubleBoolean2Boolean(f: (sFun, lFun, dFun, bFun) => bFun): String = getSignature(List(StringFun, LongFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureStringLongStringInt2Boolean(f: (sFun, lFun, sFun, iFun) => bFun): String = getSignature(List(StringFun, LongFun, StringFun, IntFun), BooleanFun)
  def getSignatureStringLongStringLong2Boolean(f: (sFun, lFun, sFun, lFun) => bFun): String = getSignature(List(StringFun, LongFun, StringFun, LongFun), BooleanFun)
  def getSignatureStringLongStringDouble2Boolean(f: (sFun, lFun, sFun, dFun) => bFun): String = getSignature(List(StringFun, LongFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureStringLongStringString2Boolean(f: (sFun, lFun, sFun, sFun) => bFun): String = getSignature(List(StringFun, LongFun, StringFun, StringFun), BooleanFun)
  def getSignatureStringLongStringBoolean2Boolean(f: (sFun, lFun, sFun, bFun) => bFun): String = getSignature(List(StringFun, LongFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureStringLongBooleanInt2Boolean(f: (sFun, lFun, bFun, iFun) => bFun): String = getSignature(List(StringFun, LongFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureStringLongBooleanLong2Boolean(f: (sFun, lFun, bFun, lFun) => bFun): String = getSignature(List(StringFun, LongFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureStringLongBooleanDouble2Boolean(f: (sFun, lFun, bFun, dFun) => bFun): String = getSignature(List(StringFun, LongFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureStringLongBooleanString2Boolean(f: (sFun, lFun, bFun, sFun) => bFun): String = getSignature(List(StringFun, LongFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureStringLongBooleanBoolean2Boolean(f: (sFun, lFun, bFun, bFun) => bFun): String = getSignature(List(StringFun, LongFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureStringDoubleIntInt2Boolean(f: (sFun, dFun, iFun, iFun) => bFun): String = getSignature(List(StringFun, DoubleFun, IntFun, IntFun), BooleanFun)
  def getSignatureStringDoubleIntLong2Boolean(f: (sFun, dFun, iFun, lFun) => bFun): String = getSignature(List(StringFun, DoubleFun, IntFun, LongFun), BooleanFun)
  def getSignatureStringDoubleIntDouble2Boolean(f: (sFun, dFun, iFun, dFun) => bFun): String = getSignature(List(StringFun, DoubleFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureStringDoubleIntString2Boolean(f: (sFun, dFun, iFun, sFun) => bFun): String = getSignature(List(StringFun, DoubleFun, IntFun, StringFun), BooleanFun)
  def getSignatureStringDoubleIntBoolean2Boolean(f: (sFun, dFun, iFun, bFun) => bFun): String = getSignature(List(StringFun, DoubleFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureStringDoubleLongInt2Boolean(f: (sFun, dFun, lFun, iFun) => bFun): String = getSignature(List(StringFun, DoubleFun, LongFun, IntFun), BooleanFun)
  def getSignatureStringDoubleLongLong2Boolean(f: (sFun, dFun, lFun, lFun) => bFun): String = getSignature(List(StringFun, DoubleFun, LongFun, LongFun), BooleanFun)
  def getSignatureStringDoubleLongDouble2Boolean(f: (sFun, dFun, lFun, dFun) => bFun): String = getSignature(List(StringFun, DoubleFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureStringDoubleLongString2Boolean(f: (sFun, dFun, lFun, sFun) => bFun): String = getSignature(List(StringFun, DoubleFun, LongFun, StringFun), BooleanFun)
  def getSignatureStringDoubleLongBoolean2Boolean(f: (sFun, dFun, lFun, bFun) => bFun): String = getSignature(List(StringFun, DoubleFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureStringDoubleDoubleInt2Boolean(f: (sFun, dFun, dFun, iFun) => bFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureStringDoubleDoubleLong2Boolean(f: (sFun, dFun, dFun, lFun) => bFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureStringDoubleDoubleDouble2Boolean(f: (sFun, dFun, dFun, dFun) => bFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureStringDoubleDoubleString2Boolean(f: (sFun, dFun, dFun, sFun) => bFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureStringDoubleDoubleBoolean2Boolean(f: (sFun, dFun, dFun, bFun) => bFun): String = getSignature(List(StringFun, DoubleFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureStringDoubleStringInt2Boolean(f: (sFun, dFun, sFun, iFun) => bFun): String = getSignature(List(StringFun, DoubleFun, StringFun, IntFun), BooleanFun)
  def getSignatureStringDoubleStringLong2Boolean(f: (sFun, dFun, sFun, lFun) => bFun): String = getSignature(List(StringFun, DoubleFun, StringFun, LongFun), BooleanFun)
  def getSignatureStringDoubleStringDouble2Boolean(f: (sFun, dFun, sFun, dFun) => bFun): String = getSignature(List(StringFun, DoubleFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureStringDoubleStringString2Boolean(f: (sFun, dFun, sFun, sFun) => bFun): String = getSignature(List(StringFun, DoubleFun, StringFun, StringFun), BooleanFun)
  def getSignatureStringDoubleStringBoolean2Boolean(f: (sFun, dFun, sFun, bFun) => bFun): String = getSignature(List(StringFun, DoubleFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureStringDoubleBooleanInt2Boolean(f: (sFun, dFun, bFun, iFun) => bFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureStringDoubleBooleanLong2Boolean(f: (sFun, dFun, bFun, lFun) => bFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureStringDoubleBooleanDouble2Boolean(f: (sFun, dFun, bFun, dFun) => bFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureStringDoubleBooleanString2Boolean(f: (sFun, dFun, bFun, sFun) => bFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureStringDoubleBooleanBoolean2Boolean(f: (sFun, dFun, bFun, bFun) => bFun): String = getSignature(List(StringFun, DoubleFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureStringStringIntInt2Boolean(f: (sFun, sFun, iFun, iFun) => bFun): String = getSignature(List(StringFun, StringFun, IntFun, IntFun), BooleanFun)
  def getSignatureStringStringIntLong2Boolean(f: (sFun, sFun, iFun, lFun) => bFun): String = getSignature(List(StringFun, StringFun, IntFun, LongFun), BooleanFun)
  def getSignatureStringStringIntDouble2Boolean(f: (sFun, sFun, iFun, dFun) => bFun): String = getSignature(List(StringFun, StringFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureStringStringIntString2Boolean(f: (sFun, sFun, iFun, sFun) => bFun): String = getSignature(List(StringFun, StringFun, IntFun, StringFun), BooleanFun)
  def getSignatureStringStringIntBoolean2Boolean(f: (sFun, sFun, iFun, bFun) => bFun): String = getSignature(List(StringFun, StringFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureStringStringLongInt2Boolean(f: (sFun, sFun, lFun, iFun) => bFun): String = getSignature(List(StringFun, StringFun, LongFun, IntFun), BooleanFun)
  def getSignatureStringStringLongLong2Boolean(f: (sFun, sFun, lFun, lFun) => bFun): String = getSignature(List(StringFun, StringFun, LongFun, LongFun), BooleanFun)
  def getSignatureStringStringLongDouble2Boolean(f: (sFun, sFun, lFun, dFun) => bFun): String = getSignature(List(StringFun, StringFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureStringStringLongString2Boolean(f: (sFun, sFun, lFun, sFun) => bFun): String = getSignature(List(StringFun, StringFun, LongFun, StringFun), BooleanFun)
  def getSignatureStringStringLongBoolean2Boolean(f: (sFun, sFun, lFun, bFun) => bFun): String = getSignature(List(StringFun, StringFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureStringStringDoubleInt2Boolean(f: (sFun, sFun, dFun, iFun) => bFun): String = getSignature(List(StringFun, StringFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureStringStringDoubleLong2Boolean(f: (sFun, sFun, dFun, lFun) => bFun): String = getSignature(List(StringFun, StringFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureStringStringDoubleDouble2Boolean(f: (sFun, sFun, dFun, dFun) => bFun): String = getSignature(List(StringFun, StringFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureStringStringDoubleString2Boolean(f: (sFun, sFun, dFun, sFun) => bFun): String = getSignature(List(StringFun, StringFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureStringStringDoubleBoolean2Boolean(f: (sFun, sFun, dFun, bFun) => bFun): String = getSignature(List(StringFun, StringFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureStringStringStringInt2Boolean(f: (sFun, sFun, sFun, iFun) => bFun): String = getSignature(List(StringFun, StringFun, StringFun, IntFun), BooleanFun)
  def getSignatureStringStringStringLong2Boolean(f: (sFun, sFun, sFun, lFun) => bFun): String = getSignature(List(StringFun, StringFun, StringFun, LongFun), BooleanFun)
  def getSignatureStringStringStringDouble2Boolean(f: (sFun, sFun, sFun, dFun) => bFun): String = getSignature(List(StringFun, StringFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureStringStringStringString2Boolean(f: (sFun, sFun, sFun, sFun) => bFun): String = getSignature(List(StringFun, StringFun, StringFun, StringFun), BooleanFun)
  def getSignatureStringStringStringBoolean2Boolean(f: (sFun, sFun, sFun, bFun) => bFun): String = getSignature(List(StringFun, StringFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureStringStringBooleanInt2Boolean(f: (sFun, sFun, bFun, iFun) => bFun): String = getSignature(List(StringFun, StringFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureStringStringBooleanLong2Boolean(f: (sFun, sFun, bFun, lFun) => bFun): String = getSignature(List(StringFun, StringFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureStringStringBooleanDouble2Boolean(f: (sFun, sFun, bFun, dFun) => bFun): String = getSignature(List(StringFun, StringFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureStringStringBooleanString2Boolean(f: (sFun, sFun, bFun, sFun) => bFun): String = getSignature(List(StringFun, StringFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureStringStringBooleanBoolean2Boolean(f: (sFun, sFun, bFun, bFun) => bFun): String = getSignature(List(StringFun, StringFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureStringBooleanIntInt2Boolean(f: (sFun, bFun, iFun, iFun) => bFun): String = getSignature(List(StringFun, BooleanFun, IntFun, IntFun), BooleanFun)
  def getSignatureStringBooleanIntLong2Boolean(f: (sFun, bFun, iFun, lFun) => bFun): String = getSignature(List(StringFun, BooleanFun, IntFun, LongFun), BooleanFun)
  def getSignatureStringBooleanIntDouble2Boolean(f: (sFun, bFun, iFun, dFun) => bFun): String = getSignature(List(StringFun, BooleanFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureStringBooleanIntString2Boolean(f: (sFun, bFun, iFun, sFun) => bFun): String = getSignature(List(StringFun, BooleanFun, IntFun, StringFun), BooleanFun)
  def getSignatureStringBooleanIntBoolean2Boolean(f: (sFun, bFun, iFun, bFun) => bFun): String = getSignature(List(StringFun, BooleanFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureStringBooleanLongInt2Boolean(f: (sFun, bFun, lFun, iFun) => bFun): String = getSignature(List(StringFun, BooleanFun, LongFun, IntFun), BooleanFun)
  def getSignatureStringBooleanLongLong2Boolean(f: (sFun, bFun, lFun, lFun) => bFun): String = getSignature(List(StringFun, BooleanFun, LongFun, LongFun), BooleanFun)
  def getSignatureStringBooleanLongDouble2Boolean(f: (sFun, bFun, lFun, dFun) => bFun): String = getSignature(List(StringFun, BooleanFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureStringBooleanLongString2Boolean(f: (sFun, bFun, lFun, sFun) => bFun): String = getSignature(List(StringFun, BooleanFun, LongFun, StringFun), BooleanFun)
  def getSignatureStringBooleanLongBoolean2Boolean(f: (sFun, bFun, lFun, bFun) => bFun): String = getSignature(List(StringFun, BooleanFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureStringBooleanDoubleInt2Boolean(f: (sFun, bFun, dFun, iFun) => bFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureStringBooleanDoubleLong2Boolean(f: (sFun, bFun, dFun, lFun) => bFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureStringBooleanDoubleDouble2Boolean(f: (sFun, bFun, dFun, dFun) => bFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureStringBooleanDoubleString2Boolean(f: (sFun, bFun, dFun, sFun) => bFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureStringBooleanDoubleBoolean2Boolean(f: (sFun, bFun, dFun, bFun) => bFun): String = getSignature(List(StringFun, BooleanFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureStringBooleanStringInt2Boolean(f: (sFun, bFun, sFun, iFun) => bFun): String = getSignature(List(StringFun, BooleanFun, StringFun, IntFun), BooleanFun)
  def getSignatureStringBooleanStringLong2Boolean(f: (sFun, bFun, sFun, lFun) => bFun): String = getSignature(List(StringFun, BooleanFun, StringFun, LongFun), BooleanFun)
  def getSignatureStringBooleanStringDouble2Boolean(f: (sFun, bFun, sFun, dFun) => bFun): String = getSignature(List(StringFun, BooleanFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureStringBooleanStringString2Boolean(f: (sFun, bFun, sFun, sFun) => bFun): String = getSignature(List(StringFun, BooleanFun, StringFun, StringFun), BooleanFun)
  def getSignatureStringBooleanStringBoolean2Boolean(f: (sFun, bFun, sFun, bFun) => bFun): String = getSignature(List(StringFun, BooleanFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureStringBooleanBooleanInt2Boolean(f: (sFun, bFun, bFun, iFun) => bFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureStringBooleanBooleanLong2Boolean(f: (sFun, bFun, bFun, lFun) => bFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureStringBooleanBooleanDouble2Boolean(f: (sFun, bFun, bFun, dFun) => bFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureStringBooleanBooleanString2Boolean(f: (sFun, bFun, bFun, sFun) => bFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureStringBooleanBooleanBoolean2Boolean(f: (sFun, bFun, bFun, bFun) => bFun): String = getSignature(List(StringFun, BooleanFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureBooleanIntIntInt2Boolean(f: (bFun, iFun, iFun, iFun) => bFun): String = getSignature(List(BooleanFun, IntFun, IntFun, IntFun), BooleanFun)
  def getSignatureBooleanIntIntLong2Boolean(f: (bFun, iFun, iFun, lFun) => bFun): String = getSignature(List(BooleanFun, IntFun, IntFun, LongFun), BooleanFun)
  def getSignatureBooleanIntIntDouble2Boolean(f: (bFun, iFun, iFun, dFun) => bFun): String = getSignature(List(BooleanFun, IntFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureBooleanIntIntString2Boolean(f: (bFun, iFun, iFun, sFun) => bFun): String = getSignature(List(BooleanFun, IntFun, IntFun, StringFun), BooleanFun)
  def getSignatureBooleanIntIntBoolean2Boolean(f: (bFun, iFun, iFun, bFun) => bFun): String = getSignature(List(BooleanFun, IntFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureBooleanIntLongInt2Boolean(f: (bFun, iFun, lFun, iFun) => bFun): String = getSignature(List(BooleanFun, IntFun, LongFun, IntFun), BooleanFun)
  def getSignatureBooleanIntLongLong2Boolean(f: (bFun, iFun, lFun, lFun) => bFun): String = getSignature(List(BooleanFun, IntFun, LongFun, LongFun), BooleanFun)
  def getSignatureBooleanIntLongDouble2Boolean(f: (bFun, iFun, lFun, dFun) => bFun): String = getSignature(List(BooleanFun, IntFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureBooleanIntLongString2Boolean(f: (bFun, iFun, lFun, sFun) => bFun): String = getSignature(List(BooleanFun, IntFun, LongFun, StringFun), BooleanFun)
  def getSignatureBooleanIntLongBoolean2Boolean(f: (bFun, iFun, lFun, bFun) => bFun): String = getSignature(List(BooleanFun, IntFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureBooleanIntDoubleInt2Boolean(f: (bFun, iFun, dFun, iFun) => bFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureBooleanIntDoubleLong2Boolean(f: (bFun, iFun, dFun, lFun) => bFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureBooleanIntDoubleDouble2Boolean(f: (bFun, iFun, dFun, dFun) => bFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureBooleanIntDoubleString2Boolean(f: (bFun, iFun, dFun, sFun) => bFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureBooleanIntDoubleBoolean2Boolean(f: (bFun, iFun, dFun, bFun) => bFun): String = getSignature(List(BooleanFun, IntFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureBooleanIntStringInt2Boolean(f: (bFun, iFun, sFun, iFun) => bFun): String = getSignature(List(BooleanFun, IntFun, StringFun, IntFun), BooleanFun)
  def getSignatureBooleanIntStringLong2Boolean(f: (bFun, iFun, sFun, lFun) => bFun): String = getSignature(List(BooleanFun, IntFun, StringFun, LongFun), BooleanFun)
  def getSignatureBooleanIntStringDouble2Boolean(f: (bFun, iFun, sFun, dFun) => bFun): String = getSignature(List(BooleanFun, IntFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureBooleanIntStringString2Boolean(f: (bFun, iFun, sFun, sFun) => bFun): String = getSignature(List(BooleanFun, IntFun, StringFun, StringFun), BooleanFun)
  def getSignatureBooleanIntStringBoolean2Boolean(f: (bFun, iFun, sFun, bFun) => bFun): String = getSignature(List(BooleanFun, IntFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureBooleanIntBooleanInt2Boolean(f: (bFun, iFun, bFun, iFun) => bFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureBooleanIntBooleanLong2Boolean(f: (bFun, iFun, bFun, lFun) => bFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureBooleanIntBooleanDouble2Boolean(f: (bFun, iFun, bFun, dFun) => bFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureBooleanIntBooleanString2Boolean(f: (bFun, iFun, bFun, sFun) => bFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureBooleanIntBooleanBoolean2Boolean(f: (bFun, iFun, bFun, bFun) => bFun): String = getSignature(List(BooleanFun, IntFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureBooleanLongIntInt2Boolean(f: (bFun, lFun, iFun, iFun) => bFun): String = getSignature(List(BooleanFun, LongFun, IntFun, IntFun), BooleanFun)
  def getSignatureBooleanLongIntLong2Boolean(f: (bFun, lFun, iFun, lFun) => bFun): String = getSignature(List(BooleanFun, LongFun, IntFun, LongFun), BooleanFun)
  def getSignatureBooleanLongIntDouble2Boolean(f: (bFun, lFun, iFun, dFun) => bFun): String = getSignature(List(BooleanFun, LongFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureBooleanLongIntString2Boolean(f: (bFun, lFun, iFun, sFun) => bFun): String = getSignature(List(BooleanFun, LongFun, IntFun, StringFun), BooleanFun)
  def getSignatureBooleanLongIntBoolean2Boolean(f: (bFun, lFun, iFun, bFun) => bFun): String = getSignature(List(BooleanFun, LongFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureBooleanLongLongInt2Boolean(f: (bFun, lFun, lFun, iFun) => bFun): String = getSignature(List(BooleanFun, LongFun, LongFun, IntFun), BooleanFun)
  def getSignatureBooleanLongLongLong2Boolean(f: (bFun, lFun, lFun, lFun) => bFun): String = getSignature(List(BooleanFun, LongFun, LongFun, LongFun), BooleanFun)
  def getSignatureBooleanLongLongDouble2Boolean(f: (bFun, lFun, lFun, dFun) => bFun): String = getSignature(List(BooleanFun, LongFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureBooleanLongLongString2Boolean(f: (bFun, lFun, lFun, sFun) => bFun): String = getSignature(List(BooleanFun, LongFun, LongFun, StringFun), BooleanFun)
  def getSignatureBooleanLongLongBoolean2Boolean(f: (bFun, lFun, lFun, bFun) => bFun): String = getSignature(List(BooleanFun, LongFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureBooleanLongDoubleInt2Boolean(f: (bFun, lFun, dFun, iFun) => bFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureBooleanLongDoubleLong2Boolean(f: (bFun, lFun, dFun, lFun) => bFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureBooleanLongDoubleDouble2Boolean(f: (bFun, lFun, dFun, dFun) => bFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureBooleanLongDoubleString2Boolean(f: (bFun, lFun, dFun, sFun) => bFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureBooleanLongDoubleBoolean2Boolean(f: (bFun, lFun, dFun, bFun) => bFun): String = getSignature(List(BooleanFun, LongFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureBooleanLongStringInt2Boolean(f: (bFun, lFun, sFun, iFun) => bFun): String = getSignature(List(BooleanFun, LongFun, StringFun, IntFun), BooleanFun)
  def getSignatureBooleanLongStringLong2Boolean(f: (bFun, lFun, sFun, lFun) => bFun): String = getSignature(List(BooleanFun, LongFun, StringFun, LongFun), BooleanFun)
  def getSignatureBooleanLongStringDouble2Boolean(f: (bFun, lFun, sFun, dFun) => bFun): String = getSignature(List(BooleanFun, LongFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureBooleanLongStringString2Boolean(f: (bFun, lFun, sFun, sFun) => bFun): String = getSignature(List(BooleanFun, LongFun, StringFun, StringFun), BooleanFun)
  def getSignatureBooleanLongStringBoolean2Boolean(f: (bFun, lFun, sFun, bFun) => bFun): String = getSignature(List(BooleanFun, LongFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureBooleanLongBooleanInt2Boolean(f: (bFun, lFun, bFun, iFun) => bFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureBooleanLongBooleanLong2Boolean(f: (bFun, lFun, bFun, lFun) => bFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureBooleanLongBooleanDouble2Boolean(f: (bFun, lFun, bFun, dFun) => bFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureBooleanLongBooleanString2Boolean(f: (bFun, lFun, bFun, sFun) => bFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureBooleanLongBooleanBoolean2Boolean(f: (bFun, lFun, bFun, bFun) => bFun): String = getSignature(List(BooleanFun, LongFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureBooleanDoubleIntInt2Boolean(f: (bFun, dFun, iFun, iFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, IntFun), BooleanFun)
  def getSignatureBooleanDoubleIntLong2Boolean(f: (bFun, dFun, iFun, lFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, LongFun), BooleanFun)
  def getSignatureBooleanDoubleIntDouble2Boolean(f: (bFun, dFun, iFun, dFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureBooleanDoubleIntString2Boolean(f: (bFun, dFun, iFun, sFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, StringFun), BooleanFun)
  def getSignatureBooleanDoubleIntBoolean2Boolean(f: (bFun, dFun, iFun, bFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureBooleanDoubleLongInt2Boolean(f: (bFun, dFun, lFun, iFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, IntFun), BooleanFun)
  def getSignatureBooleanDoubleLongLong2Boolean(f: (bFun, dFun, lFun, lFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, LongFun), BooleanFun)
  def getSignatureBooleanDoubleLongDouble2Boolean(f: (bFun, dFun, lFun, dFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureBooleanDoubleLongString2Boolean(f: (bFun, dFun, lFun, sFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, StringFun), BooleanFun)
  def getSignatureBooleanDoubleLongBoolean2Boolean(f: (bFun, dFun, lFun, bFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureBooleanDoubleDoubleInt2Boolean(f: (bFun, dFun, dFun, iFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureBooleanDoubleDoubleLong2Boolean(f: (bFun, dFun, dFun, lFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureBooleanDoubleDoubleDouble2Boolean(f: (bFun, dFun, dFun, dFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureBooleanDoubleDoubleString2Boolean(f: (bFun, dFun, dFun, sFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureBooleanDoubleDoubleBoolean2Boolean(f: (bFun, dFun, dFun, bFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureBooleanDoubleStringInt2Boolean(f: (bFun, dFun, sFun, iFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, IntFun), BooleanFun)
  def getSignatureBooleanDoubleStringLong2Boolean(f: (bFun, dFun, sFun, lFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, LongFun), BooleanFun)
  def getSignatureBooleanDoubleStringDouble2Boolean(f: (bFun, dFun, sFun, dFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureBooleanDoubleStringString2Boolean(f: (bFun, dFun, sFun, sFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, StringFun), BooleanFun)
  def getSignatureBooleanDoubleStringBoolean2Boolean(f: (bFun, dFun, sFun, bFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureBooleanDoubleBooleanInt2Boolean(f: (bFun, dFun, bFun, iFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureBooleanDoubleBooleanLong2Boolean(f: (bFun, dFun, bFun, lFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureBooleanDoubleBooleanDouble2Boolean(f: (bFun, dFun, bFun, dFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureBooleanDoubleBooleanString2Boolean(f: (bFun, dFun, bFun, sFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureBooleanDoubleBooleanBoolean2Boolean(f: (bFun, dFun, bFun, bFun) => bFun): String = getSignature(List(BooleanFun, DoubleFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureBooleanStringIntInt2Boolean(f: (bFun, sFun, iFun, iFun) => bFun): String = getSignature(List(BooleanFun, StringFun, IntFun, IntFun), BooleanFun)
  def getSignatureBooleanStringIntLong2Boolean(f: (bFun, sFun, iFun, lFun) => bFun): String = getSignature(List(BooleanFun, StringFun, IntFun, LongFun), BooleanFun)
  def getSignatureBooleanStringIntDouble2Boolean(f: (bFun, sFun, iFun, dFun) => bFun): String = getSignature(List(BooleanFun, StringFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureBooleanStringIntString2Boolean(f: (bFun, sFun, iFun, sFun) => bFun): String = getSignature(List(BooleanFun, StringFun, IntFun, StringFun), BooleanFun)
  def getSignatureBooleanStringIntBoolean2Boolean(f: (bFun, sFun, iFun, bFun) => bFun): String = getSignature(List(BooleanFun, StringFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureBooleanStringLongInt2Boolean(f: (bFun, sFun, lFun, iFun) => bFun): String = getSignature(List(BooleanFun, StringFun, LongFun, IntFun), BooleanFun)
  def getSignatureBooleanStringLongLong2Boolean(f: (bFun, sFun, lFun, lFun) => bFun): String = getSignature(List(BooleanFun, StringFun, LongFun, LongFun), BooleanFun)
  def getSignatureBooleanStringLongDouble2Boolean(f: (bFun, sFun, lFun, dFun) => bFun): String = getSignature(List(BooleanFun, StringFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureBooleanStringLongString2Boolean(f: (bFun, sFun, lFun, sFun) => bFun): String = getSignature(List(BooleanFun, StringFun, LongFun, StringFun), BooleanFun)
  def getSignatureBooleanStringLongBoolean2Boolean(f: (bFun, sFun, lFun, bFun) => bFun): String = getSignature(List(BooleanFun, StringFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureBooleanStringDoubleInt2Boolean(f: (bFun, sFun, dFun, iFun) => bFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureBooleanStringDoubleLong2Boolean(f: (bFun, sFun, dFun, lFun) => bFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureBooleanStringDoubleDouble2Boolean(f: (bFun, sFun, dFun, dFun) => bFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureBooleanStringDoubleString2Boolean(f: (bFun, sFun, dFun, sFun) => bFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureBooleanStringDoubleBoolean2Boolean(f: (bFun, sFun, dFun, bFun) => bFun): String = getSignature(List(BooleanFun, StringFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureBooleanStringStringInt2Boolean(f: (bFun, sFun, sFun, iFun) => bFun): String = getSignature(List(BooleanFun, StringFun, StringFun, IntFun), BooleanFun)
  def getSignatureBooleanStringStringLong2Boolean(f: (bFun, sFun, sFun, lFun) => bFun): String = getSignature(List(BooleanFun, StringFun, StringFun, LongFun), BooleanFun)
  def getSignatureBooleanStringStringDouble2Boolean(f: (bFun, sFun, sFun, dFun) => bFun): String = getSignature(List(BooleanFun, StringFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureBooleanStringStringString2Boolean(f: (bFun, sFun, sFun, sFun) => bFun): String = getSignature(List(BooleanFun, StringFun, StringFun, StringFun), BooleanFun)
  def getSignatureBooleanStringStringBoolean2Boolean(f: (bFun, sFun, sFun, bFun) => bFun): String = getSignature(List(BooleanFun, StringFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureBooleanStringBooleanInt2Boolean(f: (bFun, sFun, bFun, iFun) => bFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureBooleanStringBooleanLong2Boolean(f: (bFun, sFun, bFun, lFun) => bFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureBooleanStringBooleanDouble2Boolean(f: (bFun, sFun, bFun, dFun) => bFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureBooleanStringBooleanString2Boolean(f: (bFun, sFun, bFun, sFun) => bFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureBooleanStringBooleanBoolean2Boolean(f: (bFun, sFun, bFun, bFun) => bFun): String = getSignature(List(BooleanFun, StringFun, BooleanFun, BooleanFun), BooleanFun)
  def getSignatureBooleanBooleanIntInt2Boolean(f: (bFun, bFun, iFun, iFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, IntFun), BooleanFun)
  def getSignatureBooleanBooleanIntLong2Boolean(f: (bFun, bFun, iFun, lFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, LongFun), BooleanFun)
  def getSignatureBooleanBooleanIntDouble2Boolean(f: (bFun, bFun, iFun, dFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, DoubleFun), BooleanFun)
  def getSignatureBooleanBooleanIntString2Boolean(f: (bFun, bFun, iFun, sFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, StringFun), BooleanFun)
  def getSignatureBooleanBooleanIntBoolean2Boolean(f: (bFun, bFun, iFun, bFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, IntFun, BooleanFun), BooleanFun)
  def getSignatureBooleanBooleanLongInt2Boolean(f: (bFun, bFun, lFun, iFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, IntFun), BooleanFun)
  def getSignatureBooleanBooleanLongLong2Boolean(f: (bFun, bFun, lFun, lFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, LongFun), BooleanFun)
  def getSignatureBooleanBooleanLongDouble2Boolean(f: (bFun, bFun, lFun, dFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, DoubleFun), BooleanFun)
  def getSignatureBooleanBooleanLongString2Boolean(f: (bFun, bFun, lFun, sFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, StringFun), BooleanFun)
  def getSignatureBooleanBooleanLongBoolean2Boolean(f: (bFun, bFun, lFun, bFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, LongFun, BooleanFun), BooleanFun)
  def getSignatureBooleanBooleanDoubleInt2Boolean(f: (bFun, bFun, dFun, iFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, IntFun), BooleanFun)
  def getSignatureBooleanBooleanDoubleLong2Boolean(f: (bFun, bFun, dFun, lFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, LongFun), BooleanFun)
  def getSignatureBooleanBooleanDoubleDouble2Boolean(f: (bFun, bFun, dFun, dFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, DoubleFun), BooleanFun)
  def getSignatureBooleanBooleanDoubleString2Boolean(f: (bFun, bFun, dFun, sFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, StringFun), BooleanFun)
  def getSignatureBooleanBooleanDoubleBoolean2Boolean(f: (bFun, bFun, dFun, bFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, DoubleFun, BooleanFun), BooleanFun)
  def getSignatureBooleanBooleanStringInt2Boolean(f: (bFun, bFun, sFun, iFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, IntFun), BooleanFun)
  def getSignatureBooleanBooleanStringLong2Boolean(f: (bFun, bFun, sFun, lFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, LongFun), BooleanFun)
  def getSignatureBooleanBooleanStringDouble2Boolean(f: (bFun, bFun, sFun, dFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, DoubleFun), BooleanFun)
  def getSignatureBooleanBooleanStringString2Boolean(f: (bFun, bFun, sFun, sFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, StringFun), BooleanFun)
  def getSignatureBooleanBooleanStringBoolean2Boolean(f: (bFun, bFun, sFun, bFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, StringFun, BooleanFun), BooleanFun)
  def getSignatureBooleanBooleanBooleanInt2Boolean(f: (bFun, bFun, bFun, iFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, IntFun), BooleanFun)
  def getSignatureBooleanBooleanBooleanLong2Boolean(f: (bFun, bFun, bFun, lFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, LongFun), BooleanFun)
  def getSignatureBooleanBooleanBooleanDouble2Boolean(f: (bFun, bFun, bFun, dFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, DoubleFun), BooleanFun)
  def getSignatureBooleanBooleanBooleanString2Boolean(f: (bFun, bFun, bFun, sFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, StringFun), BooleanFun)
  def getSignatureBooleanBooleanBooleanBoolean2Boolean(f: (bFun, bFun, bFun, bFun) => bFun): String = getSignature(List(BooleanFun, BooleanFun, BooleanFun, BooleanFun), BooleanFun)
}
