/*
 * Decompiled with CFR 0.152.
 */
package gorsat;

import gorsat.BatchedReadSourceConfig;
import gorsat.Commands.Analysis;
import gorsat.ReaderThread;
import gorsat.RowBuffer;
import gorsat.SpliteratorAdaptor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.gorpipe.exceptions.GorException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.GenomicIteratorBase;
import org.gorpipe.gor.model.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedPipeStepIteratorAdaptor
extends GenomicIteratorBase
implements Spliterator<Row> {
    private static final Logger log = LoggerFactory.getLogger(BatchedPipeStepIteratorAdaptor.class);
    final Iterator<? extends Row> sourceIterator;
    private final Analysis pipeStep;
    private RowBuffer rowBuffer = null;
    private ReaderThread readerThread;
    private boolean throwOnExit = true;
    boolean nosplit = false;
    String currentChrom;
    private static final Map<String, String> nextChromMap = new HashMap<String, String>();
    private final BatchedReadSourceConfig brsConfig;
    private final boolean autoclose;
    private Throwable ex = null;
    int seekCount = 0;

    public void setEx(Throwable throwable) {
        if (this.ex == null || throwable == null) {
            this.ex = throwable;
        }
    }

    public Throwable getEx() {
        return this.ex;
    }

    public void setCurrentChrom(String chrom) {
        this.currentChrom = chrom;
    }

    public double getAvgRowsPerMilliSecond() {
        return this.readerThread.getAvgRowsPerMilliSecond();
    }

    public double getAvgBasesPerMilliSecond() {
        return this.readerThread.getAvgBasesPerMilliSecond();
    }

    public double getAvgBatchSize() {
        return this.readerThread.getAvgBatchSize();
    }

    public int getCurrentBatchSize() {
        return this.rowBuffer.size();
    }

    public int getCurrentBatchLoc() {
        return this.rowBuffer.getIndex();
    }

    public Row getCurrentBatchRow(int i) {
        return this.rowBuffer.get(i);
    }

    public Stream<Row> getStream() {
        return this.getStream(false);
    }

    public Stream<Row> getStream(boolean parallel) {
        Stream<Row> ret = StreamSupport.stream(this, parallel);
        ret.onClose(this::close);
        return ret;
    }

    @Override
    public Comparator<Row> getComparator() {
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Row> action) {
        if (this.hasNext()) {
            action.accept((Row)this.next());
            return true;
        }
        return false;
    }

    public BatchedPipeStepIteratorAdaptor clone() throws CloneNotSupportedException {
        GenomicIterator cl = ((GenomicIteratorBase)this.sourceIterator).clone();
        return new BatchedPipeStepIteratorAdaptor(this.sourceIterator, this.pipeStep.clone(), this.getHeader(), this.brsConfig);
    }

    @Override
    public Spliterator<Row> trySplit() {
        if (!this.nosplit && this.sourceIterator != null && nextChromMap.containsKey(this.currentChrom)) {
            BatchedPipeStepIteratorAdaptor splitbpia;
            String nextChrom = nextChromMap.get(this.currentChrom);
            try {
                splitbpia = this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new GorSystemException("Trying to clone non clonable object", (Throwable)e);
            }
            splitbpia.seek(this.currentChrom, 0);
            this.currentChrom = nextChrom;
            return splitbpia;
        }
        if (!this.nosplit) {
            this.seek(this.currentChrom, 0);
            this.nosplit = true;
        }
        return null;
    }

    @Override
    public long estimateSize() {
        long est = Long.MAX_VALUE;
        return est;
    }

    @Override
    public int characteristics() {
        return 1300;
    }

    public String toString() {
        return this.pipeStep == null ? this.sourceIterator.toString() : this.sourceIterator + " | " + this.pipeStep;
    }

    public BatchedPipeStepIteratorAdaptor(Iterator<? extends Row> sourceIterator, Analysis pipeStep, String theHeader, BatchedReadSourceConfig brsConfig) {
        this(sourceIterator, pipeStep, false, theHeader, brsConfig);
    }

    public BatchedPipeStepIteratorAdaptor(Iterator<? extends Row> sourceIterator, Analysis pipeStep, boolean autoclose, String theHeader, BatchedReadSourceConfig brsConfig) {
        this.sourceIterator = sourceIterator;
        this.pipeStep = pipeStep;
        this.brsConfig = brsConfig;
        this.autoclose = autoclose;
        this.setHeader(theHeader);
    }

    public boolean hasNext() {
        try {
            boolean ret;
            if (this.rowBuffer == null) {
                this.readerThread = new ReaderThread(this.brsConfig, this, this.pipeStep);
                this.readerThread.setUncaughtExceptionHandler((tt, e) -> {});
                this.readerThread.start();
                this.rowBuffer = this.readerThread.pollBatch();
            } else if (!this.rowBuffer.available()) {
                this.rowBuffer = this.readerThread.pollBatch();
            }
            Throwable exception = this.getEx();
            if (exception != null) {
                this.throwOnExit = false;
                if (exception instanceof GorException) {
                    throw (GorException)exception;
                }
                throw new GorSystemException(exception);
            }
            boolean bl = ret = this.rowBuffer != null && this.rowBuffer.hasNext();
            if (!ret && this.autoclose) {
                this.close();
            }
            return ret;
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Row next() {
        return this.rowBuffer.next();
    }

    public void remove() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachRemaining(Consumer<? super Row> action) {
        SpliteratorAdaptor spliteratorAdaptor = new SpliteratorAdaptor(this, action);
        SpliteratorAdaptor bufferedPipeStep = this.pipeStep != null ? this.pipeStep.$bar((Analysis)spliteratorAdaptor) : spliteratorAdaptor;
        Exception ex = null;
        bufferedPipeStep.securedSetup(null);
        try {
            while (this.sourceIterator.hasNext() && !bufferedPipeStep.wantsNoMore()) {
                Row r = this.sourceIterator.next();
                bufferedPipeStep.process(r);
            }
        }
        catch (Exception e) {
            ex = e;
        }
        finally {
            bufferedPipeStep.securedFinish(ex);
        }
        this.close();
    }

    public boolean seek(String seekChr, int seekPos) {
        return this.seek(seekChr, seekPos, -1);
    }

    public boolean seek(String seekChr, int seekPos, int endPos) {
        long t = System.nanoTime();
        try {
            if (this.readerThread != null) {
                this.readerThread.stopProcessing("Stop processing seeking to " + seekChr + " " + seekPos + " " + endPos);
                this.readerThread.poll();
                this.readerThread.join();
                if (this.sourceIterator instanceof GenomicIterator) {
                    ((GenomicIterator)this.sourceIterator).seek(seekChr, seekPos, endPos);
                } else {
                    while (this.sourceIterator.hasNext()) {
                        Row next = this.sourceIterator.next();
                        if (next.chr.compareTo(seekChr) < 0 || next.chr.compareTo(seekChr) == 0 && next.pos < seekPos) continue;
                    }
                }
                this.readerThread.bufferedPipeStep.wantsNoMore_$eq(true);
                this.readerThread.bufferedPipeStep.alreadyFinished_$eq(false);
                this.readerThread.bufferedPipeStep.reset();
                this.readerThread.bufferAdaptor.reset();
                this.readerThread = new ReaderThread(this, this.readerThread.bufferedPipeStep, this.readerThread.bufferAdaptor, this.brsConfig);
                this.readerThread.setUncaughtExceptionHandler((tt, e) -> {});
                this.rowBuffer = this.readerThread.rowBuffer1;
                this.readerThread.start();
            }
        }
        catch (InterruptedException e2) {
            throw new GorSystemException("rowQueue take interrupted on seek", (Throwable)e2);
        }
        if (this.readerThread != null) {
            this.readerThread.setAvgSeekTimeMilliSecond(((double)this.seekCount * this.readerThread.getAvgSeekTimeMilliSecond() + (double)(System.nanoTime() - t) / 1000000.0) / (double)(this.seekCount + 1));
        }
        ++this.seekCount;
        return true;
    }

    private void closeSourceIterator() {
        if (this.sourceIterator instanceof GenomicIterator) {
            ((GenomicIterator)this.sourceIterator).close();
        }
    }

    public void close() {
        Throwable exception;
        if (this.readerThread != null && this.readerThread.didStart) {
            this.readerThread.stopProcessing("Stop processing closing source");
            try {
                this.readerThread.join(2000L);
            }
            catch (InterruptedException ie) {
                log.warn("Reader thread join interrupted");
                Thread.currentThread().interrupt();
            }
        } else {
            try {
                this.pipeStep.securedFinish(null);
            }
            catch (Exception e) {
                this.setEx(e);
            }
            finally {
                this.closeSourceIterator();
            }
        }
        if (this.throwOnExit && (exception = this.getEx()) != null) {
            if (exception instanceof GorException) {
                throw (GorException)exception;
            }
            throw new GorSystemException("Got exception in bufferedPipeStep process thread", exception);
        }
    }

    public boolean isBuffered() {
        return true;
    }

    static {
        String[] chroms = new String[]{"chr1", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrM", "chrX", "chrY"};
        IntStream.range(0, chroms.length - 1).forEach(i -> nextChromMap.put(chroms[i], chroms[i + 1]));
    }
}

