/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.manager;

import gorsat.process.CLIGorExecutionEngine;
import gorsat.process.PipeOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.output.NullOutputStream;
import org.gorpipe.gor.manager.BucketCreator;
import org.gorpipe.gor.table.dictionary.BaseDictionaryTable;
import org.gorpipe.gor.table.dictionary.BucketableTableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketCreatorGorPipe<T extends BucketableTableEntry>
implements BucketCreator<T> {
    private static final Logger log = LoggerFactory.getLogger(BucketCreatorGorPipe.class);
    public static final int DEFAULT_NUMBER_WORKERS = 4;
    private final int workers;

    public BucketCreatorGorPipe() {
        this(4);
    }

    public BucketCreatorGorPipe(int workers) {
        this.workers = workers;
    }

    @Override
    public void createBuckets(BaseDictionaryTable<T> table, Map<String, List<T>> bucketsToCreate, URI absBucketDir) throws IOException {
        String gorPipeCommand = this.createBucketizeGorCommand(bucketsToCreate, table.getRootUri(), table);
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(gorPipeCommand);
        argsList.add("-workers");
        argsList.add(String.valueOf(this.workers));
        if (table.getFileReader().getCommonRoot() != null) {
            argsList.add("-gorroot");
            argsList.add(table.getFileReader().getCommonRoot());
        }
        Object[] args = argsList.toArray(new String[argsList.size()]);
        log.trace("Calling bucketize with command args: {} \"{}\" {} {} {} {}", args);
        PrintStream oldOut = System.out;
        PipeOptions options = new PipeOptions();
        options.parseOptions((String[])args);
        CLIGorExecutionEngine engine = new CLIGorExecutionEngine(options, null, table.getSecurityContext());
        try (PrintStream newPrintStream = new PrintStream((OutputStream)new NullOutputStream());){
            System.setOut(newPrintStream);
            engine.execute();
        }
        catch (Exception e) {
            log.error("Calling bucketize failed.  Command args: {} \"{}\" {} {} {} {} failed", args);
            throw e;
        }
        finally {
            System.setOut(oldOut);
        }
    }

    private String createBucketizeGorCommand(Map<String, List<T>> bucketsToCreate, URI rootUri, BaseDictionaryTable<T> table) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<T>> b2c : bucketsToCreate.entrySet()) {
            String bucket = b2c.getKey();
            String tags = b2c.getValue().stream().flatMap(e -> Arrays.stream(e.getFilterTags()).distinct()).distinct().collect(Collectors.joining(","));
            if (tags.length() <= 0) continue;
            sb.append(String.format("create #%s# = gor %s -s %s -f %s %s | write -c %s;%n", bucket, table.getPath(), table.getSourceColumn(), tags, table.getSecurityContext() != null ? table.getSecurityContext() : "", rootUri.resolve(bucket)));
        }
        sb.append("gor 1.mem| top 1\n");
        return sb.toString();
    }
}

