/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.util;

import cern.jet.stat.Probability;

public class GChiSquared2by2 {
    private static final boolean USE_CONTINUITY_CORRECTION = true;

    private GChiSquared2by2() {
    }

    public static double computePearsonChiSquared(int o11, int o12, int o21, int o22) {
        double row1 = o11 + o12;
        double row2 = o21 + o22;
        double col1 = o11 + o21;
        double col2 = o12 + o22;
        double total = row1 + row2;
        if (total < 0.5) {
            return 0.0;
        }
        double D = o11 * o22 - o12 * o21;
        D = Math.abs(D) - total * 0.5;
        return total * D * D / (row1 * row2 * col1 * col2);
    }

    public static double computeLogLikelihoodChiSquared(int o11, int o12, int o21, int o22) {
        double chisq = Math.min(2.0 * (GChiSquared2by2.logLikelihood(o11, o12) + GChiSquared2by2.logLikelihood(o21, o22) - GChiSquared2by2.logLikelihood(o11 + o21, o12 + o22)), 999.9);
        return chisq < 1.0E-12 ? 0.0 : chisq;
    }

    private static double logLikelihood(double a, double b) {
        double p = b / (a + b);
        return GChiSquared2by2.alogx(a, 1.0 - p) + GChiSquared2by2.alogx(b, p);
    }

    private static double alogx(double a, double x) {
        return a == 0.0 ? 0.0 : a * Math.log(x);
    }

    public static double getPValue(double chisq) {
        return Probability.chiSquareComplemented((double)1.0, (double)chisq);
    }

    public static double getChiSqValue(double pvalue) {
        if (pvalue / 2.0 > 0.0) {
            double ninv = Probability.normalInverse((double)(pvalue / 2.0));
            return ninv * ninv;
        }
        if (pvalue > -1.0E-10) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    public static double getFiniteChiSqValue(double pvalue, int o11, int o12, int o21, int o22) {
        if (pvalue / 2.0 > 0.0) {
            double ninv = Probability.normalInverse((double)(pvalue / 2.0));
            return ninv * ninv;
        }
        return GChiSquared2by2.computePearsonChiSquared(o11, o12, o21, o22);
    }
}

