/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.gorpipe.gor.table.util.PathUtils;
import org.gorpipe.querydialogs.AbstractListBean;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;

public abstract class Argument
extends AbstractListBean {
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_OPERATOR = "operator";
    public static final List<Object> DEFERRED_LIST = new ArrayList<Object>();
    public static final HashMap<String, List<Object>> path2LoadedValues = new HashMap();
    public static final HashMap<String, String[]> path2LoadedValuesHeader = new HashMap();
    private final ArgumentDescription argDescr;
    protected final ArgumentType type;
    protected Object value;
    protected final Object defaultValue;
    protected List<Object> allowedValues;
    private final boolean optional;
    private String[] valuesHeader;
    private String currentOperator;
    private final List<String> operators;
    private final URI valuesPath;
    private final boolean advanced;
    private Integer displayWidth;

    public Argument(ArgumentType type, ArgumentDescription argDescr, Boolean optional, Object defaultValue, List<? extends Object> allowedValues, URI valuesPath, List<String> operators, Boolean advanced, Integer displayWidth) {
        this.valuesPath = valuesPath;
        this.allowedValues = allowedValues == null ? Collections.emptyList() : (allowedValues == DEFERRED_LIST ? DEFERRED_LIST : new ArrayList<Object>(allowedValues));
        this.operators = operators == null ? Collections.emptyList() : new ArrayList<String>(operators);
        this.type = type;
        this.optional = optional != null && optional != false;
        this.advanced = advanced != null && advanced != false;
        this.displayWidth = displayWidth;
        this.argDescr = argDescr;
        this.defaultValue = defaultValue;
        this.setValue(defaultValue);
        if (!this.operators.isEmpty()) {
            this.setOperator(this.operators.get(0));
        }
    }

    public Argument(Argument arg) {
        this(arg.type, arg.argDescr, arg.optional, arg.defaultValue, arg.allowedValues, arg.valuesPath, arg.operators, arg.advanced, arg.displayWidth);
        this.currentOperator = arg.currentOperator;
        this.value = arg.value;
        this.valuesHeader = arg.valuesHeader;
    }

    public String getName() {
        return this.argDescr.name;
    }

    public String getDescription() {
        return this.argDescr.shortDescr;
    }

    public String getTooltip() {
        return this.argDescr.tooltip;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public Integer getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(Integer displayWidth) {
        this.displayWidth = displayWidth;
    }

    public String getDisplayName() {
        return this.argDescr.getDisplayName();
    }

    public ArgumentType getType() {
        return this.type;
    }

    public String getValuesPath() {
        return this.valuesPath.toString();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    protected void checkAllowed(Object theValue) {
        if (theValue != null && !this.allowedValues.isEmpty() && this.valuesPath == null && !this.allowedValues.contains(theValue)) {
            throw new RuntimeException("Invalid value: " + theValue + " for argument " + this.argDescr.name);
        }
    }

    public void setValue(Object value, boolean checkCommaSeparatedValues) {
        if (checkCommaSeparatedValues) {
            if (value instanceof String && ((String)value).length() > 0 && !this.allowedValues.isEmpty() && this.valuesPath == null) {
                String[] splitValues;
                for (String splitValue : splitValues = ((String)value).split(",")) {
                    if (this.allowedValues.contains(splitValue)) continue;
                    throw new RuntimeException("Invalid value: " + value);
                }
            }
        } else {
            this.checkAllowed(value);
        }
        Object oldValue = this.value;
        this.value = value;
        this.firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public String getOperator() {
        return this.currentOperator;
    }

    public void setOperator(String operator) {
        this.currentOperator = operator;
        this.firePropertyChange(PROPERTY_OPERATOR, this.currentOperator, this.currentOperator);
    }

    public List<String> getOperators() {
        return Collections.unmodifiableList(this.operators);
    }

    public Object getElementAt(int index) {
        return this.allowedValues.get(index);
    }

    @Override
    public int getSize() {
        return this.allowedValues != null ? this.allowedValues.size() : 0;
    }

    public String toString() {
        return this.getValue() == null ? "" : this.getValue().toString();
    }

    public boolean hasDeferredValues() {
        return this.valuesPath != null;
    }

    public boolean deferredValuesLoaded() {
        return this.allowedValues != DEFERRED_LIST;
    }

    public String[] getValuesHeader() {
        return this.valuesHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDeferredValues(boolean checkForHeader, Function<String, BufferedReader> fileResolver) throws IOException {
        if (this.deferredValuesLoaded()) {
            return;
        }
        String valuesPathString = this.valuesPath.toString();
        try (BufferedReader reader = null;){
            List<Object> values;
            if (path2LoadedValues.containsKey(valuesPathString)) {
                values = path2LoadedValues.get(valuesPathString);
                this.valuesHeader = path2LoadedValuesHeader.get(valuesPathString);
            } else {
                reader = fileResolver.apply(valuesPathString);
                String line = reader.readLine();
                if (valuesPathString.endsWith(".link")) {
                    reader.close();
                    reader = fileResolver.apply(PathUtils.fixFileSchema((String)line));
                    line = reader.readLine();
                }
                values = new ArrayList<Object>();
                if (line != null && line.length() > 0) {
                    if (checkForHeader && line.startsWith("#")) {
                        this.valuesHeader = (String[])this.parseValue(line);
                        this.valuesHeader[0] = this.valuesHeader[0].substring(1);
                    } else {
                        values.add(this.parseValue(line));
                    }
                }
                while ((line = reader.readLine()) != null && line.length() > 0) {
                    values.add(this.parseValue(line));
                }
                path2LoadedValues.put(valuesPathString, values);
                path2LoadedValuesHeader.put(valuesPathString, this.valuesHeader);
            }
            this.allowedValues = values;
            this.fireContentsChanged(0, this.allowedValues.size());
        }
    }

    protected Object parseValue(String val) {
        return val.split("\\t", -1);
    }

    public abstract Argument copyArgument();
}

