/*
 * Decompiled with CFR 0.152.
 */
package gorsat;

import gorsat.Commands.Analysis;
import gorsat.ReaderThread;
import gorsat.RowBuffer;
import org.gorpipe.gor.model.Row;
import org.gorpipe.model.gor.RowObj;

public class BufferAdaptor
extends Analysis {
    private final Row endRow = RowObj.StoR((CharSequence)"chrN\t-1");
    RowBuffer current;
    ReaderThread readerThread;
    long t;
    double avgSeekTimeMilliSecond = 0.0;
    double avgBasesPerMilliSecond = 0.0;
    double avgRowsPerMilliSecond = 0.0;
    double avgBatchSize = 0.0;
    int numberOfRowsRead = 0;
    long totalTimeNs = 0L;
    int avgCount = 0;
    int bavgCount = 0;

    public BufferAdaptor(ReaderThread readerThread) {
        this.setReaderThread(readerThread);
        this.t = System.nanoTime();
    }

    public void setReaderThread(ReaderThread rt) {
        this.readerThread = rt;
        this.current = this.readerThread.rowBuffer1;
    }

    public void process(Row r) {
        try {
            if (!this.wantsNoMore()) {
                this.current.add(r);
                if (this.current.isFull()) {
                    if (this.readerThread.offer(this.current)) {
                        this.current = this.current.nextRowBuffer();
                        this.current.reduce(this.current.size() / 2);
                    } else if (!this.current.enlarge(this.current.size() * 8)) {
                        this.readerThread.offerBatch(this.current);
                        this.current = this.current.nextRowBuffer();
                    }
                }
            } else {
                this.readerThread.stopProcessing("Stop processing adaptor wantsNoMore");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public void finish() {
        try {
            if (!this.isInErrorState()) {
                if (this.current.isFull()) {
                    this.readerThread.offerBatch(this.current);
                    this.current = this.current.nextRowBuffer();
                }
                this.current.add(this.endRow);
                this.readerThread.offerBatch(this.current);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }
}

