/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Utilities;

import gorsat.Commands.CommandParseUtilities$;
import gorsat.DynIterator;
import gorsat.Macros.PartGor$;
import gorsat.Script.SplitManager$;
import gorsat.Utilities.AnalysisUtilities;
import gorsat.gorsatGorIterator.MapAndListUtilities$;
import gorsat.process.GorJavaUtilities;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GorOptions;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.gor.table.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.reflect.ClassTag$;
import scala.reflect.io.File$;
import scala.reflect.io.Path$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class AnalysisUtilities$ {
    public static AnalysisUtilities$ MODULE$;
    private final Logger logger;
    private final Logger consoleLogger;
    private final Function1<List<String>, String> slFirst;
    private final Function1<List<String>, String> slToList;
    private final Function1<List<String>, String> slToSet;
    private final Function1<List<String>, String> slCount;
    private final Function1<List<String>, String> slCountDist;
    private final Function1<List<String>, String> slMax;
    private final Function1<List<String>, String> slMin;

    static {
        new AnalysisUtilities$();
    }

    private Logger logger() {
        return this.logger;
    }

    private Logger consoleLogger() {
        return this.consoleLogger;
    }

    public Function1<List<String>, String> slFirst() {
        return this.slFirst;
    }

    public Function1<List<String>, String> slToList() {
        return this.slToList;
    }

    public Function1<List<String>, String> slToSet() {
        return this.slToSet;
    }

    public Function1<List<String>, String> slCount() {
        return this.slCount;
    }

    public Function1<List<String>, String> slCountDist() {
        return this.slCountDist;
    }

    public Function1<List<String>, String> slMax() {
        return this.slMax;
    }

    public Function1<List<String>, String> slMin() {
        return this.slMin;
    }

    public int distSegSeg(AnalysisUtilities.SEGinfo seg1, AnalysisUtilities.SEGinfo seg2) {
        if (seg1.start() < seg2.stop() && seg1.stop() > seg2.start()) {
            return 0;
        }
        int diststart = this.distSnpSeg(seg1.start() + 1, seg2);
        int diststop = this.distSnpSeg(seg1.stop(), seg2);
        return Math.abs(diststart) < Math.abs(diststop) ? diststart : diststop;
    }

    public int distSnpSeg(int pos, AnalysisUtilities.SEGinfo seg) {
        if (seg.start() < pos && pos <= seg.stop()) {
            return 0;
        }
        return pos <= seg.start() ? seg.start() + 1 - pos : seg.stop() - pos;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> readKeyValuePairs(String gortoolFile, FileReader fileReader) {
        void var3_3;
        HashMap theMap = new HashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MapAndListUtilities$.MODULE$.readArray(gortoolFile, fileReader))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)AnalysisUtilities$.$anonfun$readKeyValuePairs$1(x))))).foreach((Function1 & Serializable & scala.Serializable)x -> {
            String[] y = x.split("\t", -1);
            return theMap.put(y[0], y[1]);
        });
        return var3_3;
    }

    public void writeList(FileReader fileReader, String fileName, String header, List<String> m) {
        int idx = fileName.lastIndexOf(47);
        String parent = idx > 0 ? fileName.substring(0, idx) : null;
        try {
            if (parent != null && !fileReader.exists(parent)) {
                fileReader.createDirectories(parent, new FileAttribute[0]);
            }
        }
        catch (Throwable throwable) {
            ObjectRef out = ObjectRef.create(null);
            try {
                out.elem = new OutputStreamWriter(fileReader.getOutputStream(fileName, false));
                ((Writer)out.elem).write(header);
                m.foreach((Function1 & Serializable & scala.Serializable)t -> {
                    AnalysisUtilities$.$anonfun$writeList$1(out, t);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                if ((Writer)out.elem != null) {
                    ((Writer)out.elem).close();
                }
            }
            throw throwable;
        }
        ObjectRef out = ObjectRef.create(null);
        try {
            out.elem = new OutputStreamWriter(fileReader.getOutputStream(fileName, false));
            ((Writer)out.elem).write(header);
            m.foreach((Function1 & Serializable & scala.Serializable)t -> {
                AnalysisUtilities$.$anonfun$writeList$1(out, t);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            if ((Writer)out.elem != null) {
                ((Writer)out.elem).close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getSignature(String commandToExecute) {
        void var2_2;
        String command;
        String result = "";
        String name = "SIGNATURE";
        if (commandToExecute.toUpperCase().contains(name) && new StringOps(Predef$.MODULE$.augmentString(command = this.getSignatureCommand(commandToExecute))).nonEmpty()) {
            String[] args = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CommandParseUtilities$.MODULE$.quoteSafeSplit(command, ' '))).map((Function1 & Serializable & scala.Serializable)x -> x.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            if (CommandParseUtilities$.MODULE$.hasOption(args, "-timeres")) {
                int timeDiff = CommandParseUtilities$.MODULE$.intValueOfOption(args, "-timeres");
                long currentTime = System.currentTimeMillis() / 1000L;
                result = timeDiff > 0 ? Long.toString(currentTime / (long)timeDiff * (long)timeDiff) : Long.toString(currentTime);
                result = new java.lang.StringBuilder(1).append(" ").append(result).toString();
            } else {
                GorParsingException exception = new GorParsingException("Needs to have one of the following options: -timeres");
                exception.setCommandName(name);
                throw exception;
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String getSignatureCommand(String commandToExecute) {
        void var3_3;
        block1: {
            String[] commands;
            String result;
            String name;
            block0: {
                name = "SIGNATURE";
                result = "";
                commands = CommandParseUtilities$.MODULE$.quoteSafeSplit(commandToExecute, '|');
                if (!commandToExecute.contains(SplitManager$.MODULE$.SPLIT_REPLACEMENT_PATTERN()) && !commandToExecute.contains(SplitManager$.MODULE$.REGULAR_REPLACEMENT_PATTERN())) break block0;
                String[] options = CommandParseUtilities$.MODULE$.quoteSafeSplit(commandToExecute, ' ');
                String[] optionsArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])options)).map((Function1 & Serializable & scala.Serializable)x -> x.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)x.startsWith("<(")));
                if (optionsArray.length <= 0) break block1;
                result = this.getSignatureCommand(CommandParseUtilities$.MODULE$.parseNestedCommand(optionsArray[0]));
                break block1;
            }
            String[] commandArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commands)).map((Function1 & Serializable & scala.Serializable)x -> x.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)AnalysisUtilities$.$anonfun$getSignatureCommand$4(name, x)));
            if (commandArray.length <= 0) break block1;
            result = commandArray[0];
        }
        return var3_3;
    }

    public void checkAliasNameReplacement(String[] gorCommands, Map<String, String> fileMap) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gorCommands)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)x.startsWith("def"))))).foreach((Function1 & Serializable & scala.Serializable)x -> (String)fileMap.remove(x.substring(4, x.indexOf(61)).trim()));
    }

    public String theCacheDirectory(GorSession session) {
        ProjectContext projectContext = session.getProjectContext();
        String gorRoot = projectContext.getProjectRoot();
        String cacheDir = session.getProjectContext().getCacheDir() == null ? "gortemp" : session.getProjectContext().getCacheDir();
        cacheDir = PathUtils.resolve((String)gorRoot, (String)cacheDir);
        if (!projectContext.getSystemFileReader().exists(cacheDir)) {
            if (session.getProjectContext().getCacheDir() == null) {
                cacheDir = System.getProperty("java.io.tmpdir");
            } else {
                throw new GorSystemException(new java.lang.StringBuilder(54).append("Cache directory given by -cacheDir ('").append(cacheDir).append("') does not exist").toString(), null);
            }
        }
        return cacheDir;
    }

    public String getTempFileName(String outfile) {
        return outfile.endsWith(".norz") ? outfile.replace(".norz", ".temptempfile.norz") : (outfile.endsWith(".tsv") ? outfile.replace(".tsv", ".temptempfile.tsv") : (outfile.endsWith(".txt") ? outfile.replace(".txt", ".temptempfile.txt") : (outfile.endsWith(".nor") ? outfile.replace(".nor", ".temptempfile.nor") : outfile.replace(".gorz", ".temptempfile.gorz"))));
    }

    public void validateExternalSource(String input) {
        String trimmedInput = input.trim();
        if (!trimmedInput.startsWith("{") || !trimmedInput.endsWith("}")) {
            throw new GorParsingException("External commands need to be enclosed within curly brackets, e.g. {...}");
        }
    }

    public String extractExternalSource(String input) {
        String trimmedInput = input.trim();
        return input.length() > 2 && trimmedInput.startsWith("{") && trimmedInput.endsWith("}") ? input.substring(1, input.length() - 1) : input;
    }

    public String getFilterTags(String[] largs, GorContext context, boolean doHeader) {
        String tags = "";
        boolean hasFileFilter = CommandParseUtilities$.MODULE$.hasOption(largs, "-ff");
        boolean hasFilter = CommandParseUtilities$.MODULE$.hasOption(largs, "-f");
        if (hasFileFilter && hasFilter) {
            throw new GorParsingException("Error in options - -ff and -f are mutually exclusive, please select only one option: ");
        }
        if (hasFileFilter) {
            String iteratorCommand = "";
            DynIterator.DynamicNorSource dsource = null;
            String rightFile = CommandParseUtilities$.MODULE$.stringValueOfOption(largs, "-ff");
            if (rightFile.toUpperCase().endsWith(".NORZ")) {
                String string = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(rightFile), 0, 2);
                String string2 = "<(";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    rightFile = doHeader ? new java.lang.StringBuilder(16).append("<(nor ").append(rightFile).append(" | top 0 )").toString() : new java.lang.StringBuilder(8).append("<(nor ").append(rightFile).append(" )").toString();
                }
            }
            String string = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(rightFile), 0, 2);
            String string3 = "<(";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                iteratorCommand = CommandParseUtilities$.MODULE$.parseNestedCommand(rightFile);
                if (!iteratorCommand.toUpperCase().startsWith("NOR")) {
                    throw new GorParsingException("Error in nested query - nested queries in this context must be NOR queries: ");
                }
                StringBuilder strbuff = new StringBuilder(1000);
                try {
                    dsource = new DynIterator.DynamicNorSource(iteratorCommand, context);
                    String line = null;
                    boolean isFirst = true;
                    while (dsource.hasNext()) {
                        line = dsource.nextLine();
                        int indexOfTab = line.indexOf(9);
                        String aTag = indexOfTab < 0 ? line : StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(line), 0, indexOfTab);
                        Object object = !isFirst ? strbuff.append(',') : BoxedUnit.UNIT;
                        isFirst = false;
                        strbuff.append(aTag);
                    }
                }
                finally {
                    dsource.close();
                }
                tags = strbuff.toString();
            } else {
                if (new StringOps(Predef$.MODULE$.augmentString(context.getSession().getProjectContext().getRoot())).nonEmpty() && !File$.MODULE$.apply(Path$.MODULE$.string2path(rightFile), Codec$.MODULE$.fallbackSystemCodec()).exists()) {
                    rightFile = PartGor$.MODULE$.fullFileName(context.getSession(), rightFile);
                }
                tags = GorOptions.readTags((String)rightFile).stream().collect(Collectors.joining(","));
            }
        } else if (hasFilter) {
            tags = CommandParseUtilities$.MODULE$.stringValueOfOption(largs, "-f").replace("'", "");
        }
        return doHeader ? (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(tags)).split(','))).toList().head() : tags;
    }

    public Map<String, String> loadAliases(String aliasFileName, GorSession session, String defaultAliasFileName) {
        String gaFile = defaultAliasFileName;
        Map fileMap = null;
        if (aliasFileName != null) {
            gaFile = aliasFileName;
            try {
                fileMap = MapAndListUtilities$.MODULE$.getSingleHashMap(gaFile, false, false, session);
            }
            catch (Exception e) {
                throw new GorResourceException("Alias file was not found!", gaFile, (Throwable)e);
            }
        } else {
            try {
                fileMap = MapAndListUtilities$.MODULE$.getSingleHashMap(gaFile, false, false, session);
            }
            catch (Exception exception) {}
        }
        return fileMap;
    }

    public Path getWhiteListCommandFilePath(Path rootPath) {
        String whitelistFileConfig = System.getProperty("gor.cmd.whitelist.file");
        if (whitelistFileConfig == null || whitelistFileConfig.isEmpty()) {
            return null;
        }
        return GorJavaUtilities.resolveWhiteListFilePath(whitelistFileConfig, rootPath);
    }

    public static final /* synthetic */ boolean $anonfun$readKeyValuePairs$1(String x) {
        return x.indexOf(9) > 0;
    }

    public static final /* synthetic */ void $anonfun$writeList$1(ObjectRef out$1, String t) {
        ((Writer)out$1.elem).write(new java.lang.StringBuilder(1).append(t).append("\n").toString());
    }

    public static final /* synthetic */ boolean $anonfun$getSignatureCommand$4(String name$1, String x) {
        return x.toUpperCase().startsWith(name$1);
    }

    private AnalysisUtilities$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.consoleLogger = LoggerFactory.getLogger((String)new java.lang.StringBuilder(8).append("console.").append(this.getClass()).toString());
        this.slFirst = (Function1 & Serializable & scala.Serializable)x -> (String)x.head();
        this.slToList = (Function1 & Serializable & scala.Serializable)x -> (String)((LinearSeqOptimized)x.tail()).foldLeft(x.head(), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> new java.lang.StringBuilder(2).append((String)x$1).append(", ").append((String)x$2).toString());
        this.slToSet = (Function1 & Serializable & scala.Serializable)x -> {
            List y = (List)x.distinct();
            return (String)((LinearSeqOptimized)y.tail()).foldLeft(y.head(), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> new java.lang.StringBuilder(2).append((String)x$3).append(", ").append((String)x$4).toString());
        };
        this.slCount = (Function1 & Serializable & scala.Serializable)x -> Integer.toString(x.size());
        this.slCountDist = (Function1 & Serializable & scala.Serializable)x -> Integer.toString(((SetLike)Set$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)x).size());
        this.slMax = (Function1 & Serializable & scala.Serializable)x2 -> (String)((LinearSeqOptimized)x2.tail()).foldLeft(x2.head(), (Function2 & Serializable & scala.Serializable)(x, y) -> new StringOps(Predef$.MODULE$.augmentString(x)).$greater(y) ? x : y);
        this.slMin = (Function1 & Serializable & scala.Serializable)x2 -> (String)((LinearSeqOptimized)x2.tail()).foldLeft(x2.head(), (Function2 & Serializable & scala.Serializable)(x, y) -> new StringOps(Predef$.MODULE$.augmentString(x)).$less(y) ? x : y);
    }
}

