/*
 * Decompiled with CFR 0.152.
 */
package gorsat.external.plink;

import gorsat.Commands.Analysis;
import gorsat.external.plink.AdjustedGORLineIterator;
import gorsat.external.plink.PlinkAdjustment;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.gorpipe.base.config.ConfigManager;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.driver.GorDriverConfig;
import org.gorpipe.gor.model.Row;

public class PlinkAdjustAdaptor
extends Analysis {
    private static final String DEFAULT_ADJUST_COLUMNS = "chrom,pos,ref,alt,unadj,gc,qq,bonf,holm,sidakss,sidaksd,fdrbh,fdrby";
    private static final String DEFAULT_PHENO_COLUMN = "PHENO";
    private static final String DEFAULT_TEST_COLUMN = "TEST";
    private static final String DEFAULT_TEST_ENTRY = "ADD";
    private static final String DEFAULT_PHENO_ENTRY = "pheno";
    private final ExecutorService es = Executors.newSingleThreadExecutor();
    private final Map<String, FilenameAndWriter> splitFileMap = new HashMap<String, FilenameAndWriter>();
    private final List<Future<Stream<Row>>> futList = new ArrayList<Future<Stream<Row>>>();
    private final int testIndex;
    private final int phenoIndex;
    private final String header;
    private final String resultHeader;
    private final String adjustColumns;
    private final boolean sort;
    private final String[] plinkExecutable;

    public PlinkAdjustAdaptor(String header, boolean sort) throws IOException {
        this(header, DEFAULT_ADJUST_COLUMNS, sort);
    }

    public PlinkAdjustAdaptor(String header, String adjustColumns, boolean sort) throws IOException {
        String[] hSplit = header.toUpperCase().split("\t");
        List<String> hList = Arrays.asList(hSplit);
        this.testIndex = hList.indexOf(DEFAULT_TEST_COLUMN);
        this.phenoIndex = hList.indexOf(DEFAULT_PHENO_COLUMN);
        ArrayList<String> headerList = new ArrayList<String>(Arrays.asList(adjustColumns.toUpperCase().split(",")));
        headerList.add(2, "ID");
        headerList.add(DEFAULT_TEST_COLUMN);
        headerList.add(DEFAULT_PHENO_COLUMN);
        this.resultHeader = String.join((CharSequence)"\t", headerList);
        this.adjustColumns = adjustColumns;
        this.header = header;
        this.sort = sort;
        String pExec = System.getProperty("org.gorpipe.gor.driver.plink.executable");
        if (pExec == null) {
            GorDriverConfig cfg = (GorDriverConfig)ConfigManager.getPrefixConfig((String)"gor", GorDriverConfig.class, (Map[])new Map[0]);
            this.plinkExecutable = cfg.plinkExecutable().split(" ");
        } else {
            this.plinkExecutable = pExec.split(" ");
        }
    }

    public void setup() {
    }

    public void process(Row row) {
        String test = this.testIndex != -1 ? row.colAsString(this.testIndex).toString() : DEFAULT_TEST_ENTRY;
        String pheno = this.phenoIndex != -1 ? row.colAsString(this.phenoIndex).toString() : DEFAULT_PHENO_ENTRY;
        String filename = pheno + "-" + test;
        try {
            Writer writer;
            if (!this.splitFileMap.containsKey(filename)) {
                Path newSplitFile = Files.createTempFile(filename + "_", ".txt", new FileAttribute[0]);
                newSplitFile.toFile().deleteOnExit();
                writer = Files.newBufferedWriter(newSplitFile, new OpenOption[0]);
                writer.write(this.header);
                writer.write(10);
                this.splitFileMap.put(filename, new FilenameAndWriter(newSplitFile, pheno, test, writer));
            } else {
                writer = this.splitFileMap.get((Object)filename).writer;
            }
            row.writeRow(writer);
            writer.write(10);
        }
        catch (IOException e) {
            throw new GorSystemException("Error in writing temporary file for PlinkAdjustment", (Throwable)e);
        }
    }

    public String getHeader() {
        return this.resultHeader;
    }

    public void finish() {
        try {
            this.splitFileMap.forEach((key, fw) -> {
                try {
                    Path filepath = fw.filepath;
                    Writer w = fw.writer;
                    w.close();
                    String pheno = fw.pheno;
                    String test = fw.test;
                    PlinkAdjustment plinkAdjustmentCall = new PlinkAdjustment(this.plinkExecutable, filepath, pheno, test, this.adjustColumns, this.sort);
                    this.futList.add(this.es.submit(plinkAdjustmentCall));
                }
                catch (IOException e) {
                    throw new GorSystemException("Error closing plink adjust temp file", (Throwable)e);
                }
            });
            this.splitFileMap.clear();
            PriorityQueue<AdjustedGORLineIterator> pq = new PriorityQueue<AdjustedGORLineIterator>();
            if (this.sort) {
                this.futList.forEach(future -> {
                    try {
                        Stream file = (Stream)future.get();
                        AdjustedGORLineIterator gorline = new AdjustedGORLineIterator(file);
                        if (gorline.getRow() != null) {
                            pq.add(gorline);
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new GorSystemException("Error joining results from plink adjust", (Throwable)e);
                    }
                });
                while (pq.size() > 0) {
                    AdjustedGORLineIterator gl = (AdjustedGORLineIterator)pq.poll();
                    Row row = gl.getRow();
                    super.process(row);
                    gl.next();
                    if (gl.getRow() == null) continue;
                    pq.add(gl);
                }
            } else {
                this.futList.forEach(future -> {
                    try {
                        Stream file = (Stream)future.get();
                        file.forEach(x$0 -> super.process(x$0));
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new GorSystemException("Error reading from plink adjust result file", (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new GorSystemException("Exception when reading plink adjustment results", (Throwable)e);
        }
        finally {
            this.es.shutdown();
            this.futList.forEach(f -> {
                try {
                    ((Stream)f.get()).close();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            });
            this.splitFileMap.forEach((key, fw) -> {
                try {
                    fw.writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    static class FilenameAndWriter {
        Path filepath;
        String pheno;
        String test;
        Writer writer;

        public FilenameAndWriter(Path filepath, String pheno, String test, Writer writer) {
            this.filepath = filepath;
            this.pheno = pheno;
            this.test = test;
            this.writer = writer;
        }
    }
}

