/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parser;

import gorsat.parser.CalcLambdaDouble;
import gorsat.parser.CalcLambdaLong;
import gorsat.parser.CalcLambdaNumeric;
import gorsat.parser.CalcLambdaString;
import gorsat.parser.CalcLambdaVariable;
import gorsat.parser.Constant;
import gorsat.parser.CvpIntegerLambda;
import gorsat.parser.DoubleType;
import gorsat.parser.FunctionTypes;
import gorsat.parser.IntegerType;
import gorsat.parser.LongType;
import gorsat.parser.Numeric;
import gorsat.parser.TypedCalcLambda;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.model.ColumnValueProvider;

public class CalcLambdaInteger
extends CalcLambdaNumeric
implements IntegerType {
    private CvpIntegerLambda lambda;

    public CalcLambdaInteger(CvpIntegerLambda lambda) {
        this.lambda = lambda;
    }

    @Override
    public String getType() {
        return FunctionTypes.IntFun();
    }

    @Override
    public int evaluateInt(ColumnValueProvider cvp) {
        return this.lambda.evaluate(cvp);
    }

    @Override
    public long evaluateLong(ColumnValueProvider cvp) {
        return this.lambda.evaluate(cvp);
    }

    @Override
    public String evaluateString(ColumnValueProvider cvp) {
        int value = this.lambda.evaluate(cvp);
        return String.valueOf(value);
    }

    @Override
    public double evaluateDouble(ColumnValueProvider cvp) {
        return this.lambda.evaluate(cvp);
    }

    @Override
    public boolean evaluateBoolean(ColumnValueProvider cvp) {
        throw new GorParsingException("Can't cast number to boolean");
    }

    @Override
    public TypedCalcLambda addedTo(TypedCalcLambda left) {
        return left.add(this);
    }

    @Override
    public TypedCalcLambda add(int other) {
        CvpIntegerLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other;
        return this;
    }

    @Override
    public TypedCalcLambda add(CalcLambdaVariable other) {
        return other.toLambda().addedTo(this);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaString other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(String other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(CalcLambdaInteger other) {
        CvpIntegerLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other.evaluateInt(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda add(CalcLambdaLong other) {
        return new CalcLambdaLong(cvp -> this.evaluateLong(cvp) + other.evaluateLong(cvp));
    }

    @Override
    public TypedCalcLambda add(long other) {
        return new CalcLambdaLong(cvp -> this.evaluateLong(cvp) + other);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> (double)this.evaluateLong(cvp) + other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda add(double other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) + other);
    }

    @Override
    public TypedCalcLambda subtractedFrom(TypedCalcLambda other) {
        return other.subtract(this);
    }

    @Override
    public TypedCalcLambda subtract(int other) {
        return new CalcLambdaInteger(cvp -> this.evaluateInt(cvp) - other);
    }

    @Override
    public TypedCalcLambda subtract(long other) {
        return new CalcLambdaLong(cvp -> this.evaluateLong(cvp) - other);
    }

    @Override
    public TypedCalcLambda subtract(double other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) - other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaInteger other) {
        CvpIntegerLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) - other.evaluateInt(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaLong other) {
        return new CalcLambdaLong(cvp -> this.evaluateLong(cvp) - other.evaluateLong(cvp));
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) - other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaVariable other) {
        return other.toLambda().subtractedFrom(this);
    }

    @Override
    public TypedCalcLambda multipliedWith(TypedCalcLambda left) {
        return left.multiply(this);
    }

    @Override
    public TypedCalcLambda multiply(int other) {
        CvpIntegerLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) * other;
        return this;
    }

    @Override
    public TypedCalcLambda multiply(long other) {
        return new CalcLambdaLong(cvp -> this.evaluateLong(cvp) * other);
    }

    @Override
    public TypedCalcLambda multiply(double other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) * other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaInteger other) {
        CvpIntegerLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) * other.evaluateInt(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaLong other) {
        return new CalcLambdaLong(cvp -> this.evaluateLong(cvp) * other.evaluateLong(cvp));
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) * other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda dividedInto(TypedCalcLambda left) {
        return left.divide(this);
    }

    @Override
    public TypedCalcLambda divide(int other) {
        return new CalcLambdaDouble(cvp -> (double)this.lambda.evaluate(cvp) / (double)other);
    }

    @Override
    public TypedCalcLambda divide(long other) {
        return new CalcLambdaDouble(cvp -> (double)this.lambda.evaluate(cvp) / (double)other);
    }

    @Override
    public TypedCalcLambda divide(double other) {
        return new CalcLambdaDouble(cvp -> (double)this.lambda.evaluate(cvp) / other);
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaInteger other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaLong other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / other.evaluateDouble(cvp));
    }

    public TypedCalcLambda divide(TypedCalcLambda o) {
        TypedCalcLambda other = o.toLambda();
        if (!(other instanceof Numeric)) {
            throw new GorParsingException("Number expected for / operator");
        }
        CvpIntegerLambda prev = this.lambda;
        if (other instanceof Constant) {
            double d = other.evaluateDouble(null);
            return new CalcLambdaDouble(cvp -> (double)this.lambda.evaluate(cvp) / d);
        }
        return new CalcLambdaDouble(cvp -> (double)prev.evaluate(cvp) / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda pow(TypedCalcLambda o) {
        TypedCalcLambda other = o.toLambda();
        if (!(other instanceof Numeric)) {
            throw new GorParsingException("Number expected for ^ operator");
        }
        if (other instanceof IntegerType) {
            CvpIntegerLambda prev = this.lambda;
            this.lambda = cvp -> (int)Math.pow(prev.evaluate(cvp), other.evaluateInt(cvp));
            return this;
        }
        if (other instanceof LongType) {
            return new CalcLambdaLong(cvp -> (long)Math.pow(this.evaluateLong(cvp), other.evaluateLong(cvp)));
        }
        if (other instanceof DoubleType) {
            return new CalcLambdaDouble(cvp -> Math.pow(this.evaluateDouble(cvp), other.evaluateDouble(cvp)));
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda negate() {
        CvpIntegerLambda prev = this.lambda;
        this.lambda = cvp -> -prev.evaluate(cvp);
        return this;
    }
}

