/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table;

import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.dictionary.DictionaryTable;
import org.gorpipe.gor.table.files.GorTable;
import org.gorpipe.gor.table.files.NorTable;

public class TableFactory {
    private TableFactory() {
    }

    public static BaseTable getTable(String tablePath, FileReader fileReader) {
        Object table;
        if (fileReader.isDirectory(tablePath)) {
            table = new DictionaryTable(tablePath);
        } else {
            String extension;
            switch (extension = FilenameUtils.getExtension((String)tablePath).toLowerCase()) {
                case "gord": 
                case "gort": {
                    table = new DictionaryTable(tablePath);
                    break;
                }
                case "gor": 
                case "gorz": 
                case "vcf": {
                    table = new GorTable(URI.create(tablePath));
                    break;
                }
                default: {
                    table = new NorTable(URI.create(tablePath));
                }
            }
        }
        table.setFileReader(fileReader);
        return table;
    }

    public static boolean isDictionary(String tablePath, FileReader fileReader) {
        String extension;
        if (fileReader.isDirectory(tablePath)) {
            return true;
        }
        switch (extension = FilenameUtils.getExtension((String)tablePath).toLowerCase()) {
            case "gord": 
            case "gort": {
                return true;
            }
        }
        return false;
    }
}

