/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table.files;

import gorsat.process.CLIGorExecutionEngine;
import gorsat.process.PipeOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.model.RowBase;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.TableHeader;
import org.gorpipe.gor.table.TableLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GorTable<T extends Row>
extends BaseTable<T> {
    private static final Logger log = LoggerFactory.getLogger(GorTable.class);
    protected Path tempOutFilePath;

    public GorTable(BaseTable.Builder builder) {
        super(builder);
        this.init();
    }

    public GorTable(URI uri, FileReader inputFileReader) {
        super(uri, inputFileReader);
        this.init();
    }

    public GorTable(URI uri) {
        this(uri, null);
    }

    private void init() {
        this.header = new TableHeader();
        if (this.fileReader.exists(this.getPath().toString())) {
            this.validateFile(this.getPath().toString());
        }
        this.reload();
    }

    public Iterator<String> getLines() {
        try {
            return this.fileReader.getReader(this.getMainFile().toString()).lines().iterator();
        }
        catch (IOException e) {
            throw new GorSystemException("Error getting file reader", (Throwable)e);
        }
    }

    public void insert(Collection<T> lines) {
        Path tempInputFile;
        try {
            tempInputFile = this.createInputTempFile(lines);
        }
        catch (IOException e) {
            throw new GorSystemException("Could not create temp file for inserting data", (Throwable)e);
        }
        this.insert(tempInputFile.toUri());
        this.logAfter(TableLog.LogAction.INSERT, "", (String[])lines.stream().map(l -> l.otherCols()).toArray(String[]::new));
    }

    public void insert(String ... lines) {
        List<T> entries = this.lineStringsToEntries(lines);
        this.insert(entries);
    }

    private void insert(URI gorFile) {
        if (this.isValidateFiles()) {
            this.validateFile(gorFile.toString());
        }
        String gorPipeCommand = this.createInsertTempFileCommand(gorFile);
        this.runMergeCommand(gorPipeCommand);
    }

    public void delete(Collection<T> lines) {
        this.createDeleteTempFile((String[])lines.stream().map(l -> l.getAllCols()).toArray(String[]::new));
    }

    public void delete(String ... lines) {
        this.createDeleteTempFile(lines);
    }

    protected void createDeleteTempFile(String ... lines) {
        String randomString = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
        Path localTempPath = this.getTransactionFolderPath().resolve(String.format("result_temp_%s.%s", randomString, FilenameUtils.getExtension((String)this.getPath().toString())));
        String[] strippedLines = (String[])Arrays.stream(lines).map(line -> line.endsWith("\n") ? line.substring(0, line.length() - 1) : line).toArray(String[]::new);
        try (OutputStream os = this.fileReader.getOutputStream(localTempPath.toString());){
            Iterator<String> it = this.getLines();
            while (it.hasNext()) {
                String orgLine = it.next();
                if (!this.includeLine(orgLine, strippedLines)) continue;
                os.write(orgLine.getBytes(StandardCharsets.UTF_8));
                os.write(10);
            }
        }
        catch (IOException e) {
            throw new GorSystemException((Throwable)e);
        }
        this.tempOutFilePath = localTempPath;
    }

    private boolean includeLine(String line, String[] skipLines) {
        for (String skipLine : skipLines) {
            if (!line.equals(skipLine)) continue;
            return false;
        }
        return true;
    }

    protected List<T> lineStringsToEntries(String[] lines) {
        ArrayList<T> entries = new ArrayList<T>();
        for (String line : lines) {
            if (line.trim().isEmpty() || line.startsWith("#")) continue;
            entries.add(this.createRow(line));
        }
        return entries;
    }

    protected T createRow(String line) {
        return (T)new RowBase((CharSequence)(line.endsWith("\n") ? line.substring(0, line.length() - 1) : line));
    }

    protected String getInputTempFileEnding() {
        return ".gor";
    }

    protected String getGorCommand() {
        return "gor";
    }

    public void saveTempMainFile() {
        log.debug(String.format("Saving temp file (%s)to temp main file (%s) ", this.tempOutFilePath, this.getTempMainFileName()));
        try {
            if (this.tempOutFilePath != null && this.getFileReader().exists(this.tempOutFilePath.toString())) {
                this.updateFromTempFile(this.tempOutFilePath.toString(), this.getTempMainFileName());
                this.tempOutFilePath = null;
                this.getFileReader().deleteDirectory(this.getTransactionFolderPath().toString());
            } else if (!this.getFileReader().exists(this.getPath().toString())) {
                this.writeToFile(Path.of(this.getTempMainFileName(), new String[0]), new ArrayList());
            }
        }
        catch (IOException e) {
            throw new GorSystemException("Could not save table", (Throwable)e);
        }
    }

    public void initialize() {
        super.initialize();
    }

    protected Path getTransactionFolderPath() {
        return Path.of(this.getFolderPath().toString(), "transactions");
    }

    protected Path createInputTempFile(Collection<T> lines) throws IOException {
        String randomString = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
        Path tempFilePath = this.getTransactionFolderPath().resolve("insert_temp_" + randomString + this.getInputTempFileEnding());
        this.fileReader.createDirectories(tempFilePath.getParent().toString(), new FileAttribute[0]);
        this.writeToFile(tempFilePath, lines);
        return tempFilePath;
    }

    protected void writeToFile(Path filePath, Collection<T> lines) throws IOException {
        try (OutputStream os = this.fileReader.getOutputStream(filePath.toString());){
            os.write(35);
            os.write(Stream.of(this.getColumns()).collect(Collectors.joining("\t")).getBytes(StandardCharsets.UTF_8));
            os.write(10);
            for (Row r : lines) {
                this.writeRowToStream(r, os);
                os.write(10);
            }
        }
    }

    protected void writeRowToStream(Row r, OutputStream os) throws IOException {
        r.writeRowToStream(os);
    }

    protected String createInsertTempFileCommand(URI insertFile) {
        Path mainFile = this.getMainFile();
        this.tempOutFilePath = this.getNewTempFileName();
        return String.format("%s %s | merge %s | write %s", this.getGorCommand(), mainFile, insertFile.toString(), this.tempOutFilePath);
    }

    protected Path getNewTempFileName() {
        String randomString = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
        return this.getTransactionFolderPath().resolve(String.format("result_temp_%s.%s", randomString, FilenameUtils.getExtension((String)this.getPath().toString())));
    }

    protected Path getMainFile() {
        Path mainFile = this.tempOutFilePath == null ? this.getPath() : this.tempOutFilePath;
        return mainFile;
    }

    protected void runMergeCommand(String gorPipeCommand) {
        String[] args = new String[]{gorPipeCommand, "-workers", "1"};
        PipeOptions options = new PipeOptions();
        options.parseOptions(args);
        CLIGorExecutionEngine engine = new CLIGorExecutionEngine(options, null, this.getSecurityContext());
        engine.execute();
    }
}

