/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.table.files;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.model.RowBase;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.files.GorTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NorTable<T extends Row>
extends GorTable<T> {
    public final String HEADER_PRIMARY_KEY_KEY = "PRIMARY_KEY";
    private static final Logger log = LoggerFactory.getLogger(NorTable.class);

    public NorTable(BaseTable.Builder builder) {
        super(builder);
    }

    public NorTable(URI uri, FileReader inputFileReader) {
        super(uri, inputFileReader);
    }

    public NorTable(URI uri) {
        this(uri, null);
    }

    @Override
    protected String getInputTempFileEnding() {
        return ".nor";
    }

    @Override
    protected String getGorCommand() {
        return "nor";
    }

    @Override
    protected T createRow(String line) {
        return (T)new RowBase((CharSequence)("chrN\t0\t" + line));
    }

    @Override
    protected void writeRowToStream(Row r, OutputStream os) throws IOException {
        r.writeNorRowToStream(os);
    }

    @Override
    public void delete(Collection<T> lines) {
        this.createDeleteTempFile((String[])lines.stream().map(l -> l.otherCols()).toArray(String[]::new));
    }

    @Override
    protected String createInsertTempFileCommand(URI insertFile) {
        String key = this.getProperty("PRIMARY_KEY");
        if (key == null) {
            return super.createInsertTempFileCommand(insertFile);
        }
        Path mainFile = this.getMainFile();
        this.tempOutFilePath = this.getNewTempFileName();
        return String.format("%s %s | map <(%s %s) -c %s -n %s -m 'Include' | where %sx = 'Include' | hide %sx | merge %s | sort -c %s | write %s", this.getGorCommand(), mainFile, this.getGorCommand(), insertFile, key, key, key, key, insertFile, key, this.tempOutFilePath);
    }
}

