/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.templating;

import freemarker.template.SimpleCollection;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.util.Collection;
import java.util.List;
import org.gorpipe.gor.model.QueryEvaluator;

public class QueryEvalMethodModel
implements TemplateMethodModel {
    private final QueryEvaluator queryEval;

    public QueryEvalMethodModel(QueryEvaluator queryEval) {
        this.queryEval = queryEval;
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (this.queryEval == null) {
            throw new TemplateModelException("gor method error, query evaluator instance is not available");
        }
        if (arguments.size() < 1 || arguments.size() > 2) {
            throw new TemplateModelException("gor method error, usage: gor(query[, return type])");
        }
        String query = arguments.get(0).toString();
        String returnType = "string";
        if (arguments.size() == 2) {
            returnType = arguments.get(1).toString();
        }
        switch (returnType.toLowerCase()) {
            case "string": {
                return this.queryEval.asValue(query);
            }
            case "number": {
                return new SimpleNumber(Double.parseDouble(this.queryEval.asValue(query)));
            }
            case "list": {
                return new SimpleSequence((Collection)this.queryEval.asList(query));
            }
            case "iterator": {
                return new SimpleCollection((Collection)this.queryEval.asList(query));
            }
        }
        throw new TemplateModelException("gor method error, supported return types are string, number, list or iterator");
    }
}

