/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.util;

import java.util.HashMap;
import java.util.Map;

public class ValueFormatter {
    public static final String DEFAULT_FORMAT = "default";
    public static final String EMPTY_FORMAT = "empty";
    public static final String KEYWORDS_FORMAT = "keywords";
    public static final String VALUES_FORMAT = "values";
    private final Map<Object, String> formats = new HashMap<Object, String>();

    public ValueFormatter(Map<Object, String> formats) {
        this.formats.putAll(formats);
        if (!this.formats.containsKey(DEFAULT_FORMAT)) {
            this.formats.put(DEFAULT_FORMAT, "%s");
        } else if (this.formats.containsKey(this.formats.get(DEFAULT_FORMAT))) {
            this.formats.put(DEFAULT_FORMAT, this.formats.get(this.formats.get(DEFAULT_FORMAT)));
        }
    }

    public String format(Object key, Object ... values) {
        if (this.formats.containsKey(key)) {
            String f = this.formats.get(key);
            if (f == null) {
                return "";
            }
            return String.format(this.formats.get(key), values);
        }
        return null;
    }

    public boolean hasEmptyFormat() {
        return this.formats.containsKey(EMPTY_FORMAT);
    }
}

