/*
 * Decompiled with CFR 0.152.
 */
package gorsat.QueryHandlers;

import gorsat.Analysis.CheckOrder;
import gorsat.Analysis.CheckOrder$;
import gorsat.Commands.CommandParseUtilities$;
import gorsat.Commands.Output;
import gorsat.DynIterator;
import gorsat.Outputs.OutFile$;
import gorsat.Utilities.AnalysisUtilities$;
import gorsat.process.GorJavaUtilities;
import java.io.Serializable;
import java.util.Optional;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.binsearch.GorIndexType;
import org.gorpipe.gor.model.DriverBackedFileReader;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.GorMeta;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.gor.session.GorRunner;
import org.gorpipe.gor.session.ProjectContext;
import org.gorpipe.gor.table.TableHeader;
import org.gorpipe.gor.table.dictionary.DictionaryTableMeta;
import org.gorpipe.gor.table.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class GeneralQueryHandler$ {
    public static GeneralQueryHandler$ MODULE$;
    private final Logger logger;

    static {
        new GeneralQueryHandler$();
    }

    private Logger logger() {
        return this.logger;
    }

    public String findCacheFile(String commandSignature, String commandToExecute, boolean header, FileCache fileCache, String cacheDirectory) {
        return fileCache.tempLocation(commandSignature, CommandParseUtilities$.MODULE$.getExtensionForQuery(commandToExecute, header));
    }

    public String runCommand(GorContext context, String commandToExecute, String outfile, boolean useMd5, boolean theTheDict) {
        context.start(outfile);
        FileReader fileReader = context.getSession().getProjectContext().getSystemFileReader();
        String result = commandToExecute.toUpperCase().startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY_PART()) || commandToExecute.toUpperCase().startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY_FOLDER_PART()) ? this.writeOutGorDictionaryPart(commandToExecute, fileReader, outfile, theTheDict) : (commandToExecute.toUpperCase().startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY()) ? this.writeOutGorDictionary(commandToExecute, fileReader, outfile, theTheDict) : (commandToExecute.toUpperCase().startsWith(CommandParseUtilities$.MODULE$.NOR_DICTIONARY()) ? this.writeOutNorDictionaryPart(commandToExecute, fileReader, outfile) : this.runCommandInternal(context, commandToExecute, outfile, useMd5)));
        context.end();
        return result;
    }

    private String runCommandInternal(GorContext context, String commandToExecute, String outfile, boolean useMd5) {
        String string;
        String string2;
        String temp_cacheFile;
        DynIterator.DynamicRowSource theSource = new DynIterator.DynamicRowSource(commandToExecute, context, DynIterator.DynamicRowSource$.MODULE$.$lessinit$greater$default$3());
        String theHeader = theSource.getHeader();
        ProjectContext projectContext = context.getSession().getProjectContext();
        DriverBackedFileReader fileReader = (DriverBackedFileReader)projectContext.getFileReader();
        String projectRoot = projectContext.getProjectRoot();
        String string3 = temp_cacheFile = outfile != null ? AnalysisUtilities$.MODULE$.getTempFileName(outfile) : null;
        if (temp_cacheFile != null) {
            String tmpcache = temp_cacheFile;
            if (!PathUtils.isAbsolutePath((String)tmpcache)) {
                tmpcache = PathUtils.resolve((String)projectRoot, (String)tmpcache);
            }
            string2 = tmpcache;
        } else {
            string2 = null;
        }
        String oldName = string2;
        try {
            try {
                boolean nor = theSource.isNor();
                String newName = null;
                if (useMd5) {
                    Object object;
                    GorRunner runner = (GorRunner)context.getSession().getSystemContext().getRunnerFactory().create();
                    if (outfile != null) {
                        Output out = OutFile$.MODULE$.apply(temp_cacheFile, (FileReader)fileReader, theHeader, false, false, nor, useMd5, true, GorIndexType.NONE, OutFile$.MODULE$.apply$default$10(), OutFile$.MODULE$.apply$default$11());
                        object = nor ? out : new CheckOrder(CheckOrder$.MODULE$.apply$default$1()).$bar(out);
                    } else {
                        object = null;
                    }
                    Output ps = object;
                    runner.run((GenomicIterator)theSource, ps);
                    String md5File = new StringBuilder(4).append(oldName).append(".md5").toString();
                    if (fileReader.exists(md5File)) {
                        String[] md5SumLines = fileReader.readAll(md5File);
                        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])md5SumLines)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(md5SumLines[0])).nonEmpty()) {
                            String extension = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(outfile), new StringOps(Predef$.MODULE$.augmentString(outfile)).lastIndexOfSlice((GenSeq)Predef$.MODULE$.wrapString(".")), outfile.length());
                            String md5FileParent = PathUtils.getParent((String)md5File);
                            newName = PathUtils.resolve((String)md5FileParent, (String)new StringBuilder(0).append(md5SumLines[0]).append(extension).toString());
                        } else {
                            this.logger().warn("MD5 file names are enabled bu the md5 files are not returning any values.");
                        }
                    } else {
                        this.logger().warn("MD5 files are enabled but no md5 files are found when storing files in filecahce.");
                    }
                    if (newName == null && !PathUtils.isAbsolutePath((String)(newName = outfile))) {
                        newName = PathUtils.resolve((String)projectRoot, (String)newName);
                    }
                } else {
                    Object object;
                    GorRunner runner = (GorRunner)context.getSession().getSystemContext().getRunnerFactory().create();
                    if (outfile != null) {
                        Output out = OutFile$.MODULE$.apply(temp_cacheFile, (FileReader)fileReader, theHeader, false, nor, true, commandToExecute);
                        object = nor ? out : new CheckOrder(CheckOrder$.MODULE$.apply$default$1()).$bar(out);
                    } else {
                        object = null;
                    }
                    Output ps = object;
                    runner.run((GenomicIterator)theSource, ps);
                    if (outfile != null && !PathUtils.isAbsolutePath((String)(newName = outfile))) {
                        newName = PathUtils.resolve((String)projectRoot, (String)newName);
                    }
                }
                if (oldName != null && fileReader.exists(oldName) && !oldName.equals(newName)) {
                    Object object;
                    fileReader.move(oldName, newName);
                    String oldMetaName = new StringBuilder(5).append(oldName).append(".meta").toString();
                    if (fileReader.exists(oldMetaName)) {
                        String parent = PathUtils.getParent((String)oldMetaName);
                        String name = PathUtils.getFileName((String)newName);
                        object = fileReader.move(oldMetaName, new StringBuilder(6).append(parent).append("/").append(name).append(".meta").toString());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    string = newName;
                } else {
                    string = "";
                }
            }
            catch (Exception e) {
                try {
                    fileReader.delete(oldName);
                }
                catch (Exception exception) {}
                throw e;
            }
        }
        finally {
            theSource.close();
        }
        return string;
    }

    private void writeOutGorDictionaryFolder(FileReader fileReader, String outfolderpath, boolean useTheDict) {
        String string;
        if (useTheDict) {
            string = outfolderpath.endsWith("/") ? new StringBuilder(12).append(outfolderpath).append("thedict.gord").toString() : new StringBuilder(13).append(outfolderpath).append("/thedict.gord").toString();
        } else {
            int idx = outfolderpath.lastIndexOf("/");
            if (idx == -1) {
                string = new StringBuilder(1).append(outfolderpath).append("/").append(outfolderpath).toString();
            } else if (idx == outfolderpath.length()) {
                idx = outfolderpath.lastIndexOf("/", idx - 1);
                string = new StringBuilder(1).append(outfolderpath).append("/").append(outfolderpath.substring(idx + 1, outfolderpath.length() - 1)).toString();
            } else {
                string = new StringBuilder(1).append(outfolderpath).append("/").append(outfolderpath.substring(idx + 1)).toString();
            }
        }
        String outpath = string;
        GorJavaUtilities.writeDictionaryFromMeta(fileReader, outfolderpath, outpath);
    }

    public String dictRangeFromSeekRange(String inp, String prefix) {
        String[] cep;
        String[] stasto = (cep = new StringOps(Predef$.MODULE$.augmentString(inp)).split(':')).length > 1 ? new StringOps(Predef$.MODULE$.augmentString(cep[1])).split('-') : (String[])((Object[])new String[]{"0", Integer.toString(Integer.MAX_VALUE)});
        Tuple3 tuple3 = new Tuple3((Object)cep[0], (Object)stasto[0], (Object)(stasto.length > 1 && new StringOps(Predef$.MODULE$.augmentString(stasto[1])).nonEmpty() ? stasto[1] : Integer.toString(Integer.MAX_VALUE)));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String c = (String)tuple3._1();
        String sp2 = (String)tuple3._2();
        String ep = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)c, (Object)sp2, (Object)ep);
        Tuple3 tuple33 = tuple32;
        String c2 = (String)tuple33._1();
        String sp3 = (String)tuple33._2();
        String ep2 = (String)tuple33._3();
        return new StringBuilder(3).append(prefix).append(c2).append("\t").append(sp3).append("\t").append(c2).append("\t").append(ep2).toString();
    }

    private List<String> getDictList(List<String> dictFiles, List<String> chromsrange, FileReader fileReader) {
        IntRef chrI = IntRef.create((int)0);
        String useMetaFile = System.getProperty("gor.use.meta.dictionary", "true");
        return useMetaFile != null && useMetaFile.toLowerCase().equals("true") ? (List)((List)((List)dictFiles.zip(chromsrange, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> {
            Optional<String> optional;
            String f = (String)x._1();
            ++chrI$1.elem;
            String rf = MODULE$.getRelativeFileLocationForDictionaryFileReferences(f);
            String prefix = new StringBuilder(2).append(rf).append("\t").append(chrI$1.elem).append("\t").toString();
            String metaPath = new StringBuilder(5).append(f).append(".meta").toString();
            if (fileReader.exists(metaPath)) {
                GorMeta meta = GorMeta.createAndLoad((FileReader)fileReader, (String)metaPath);
                if (meta.getLineCount() == -1) {
                    String ret = MODULE$.dictRangeFromSeekRange((String)x._2(), prefix);
                    optional = Optional.of(ret);
                } else {
                    optional = meta.getLineCount() > 0 ? Optional.of(new StringBuilder(0).append(prefix).append(meta.getRange().formatAsTabDelimited()).toString()) : Optional.empty();
                }
            } else {
                String ret = MODULE$.dictRangeFromSeekRange((String)x._2(), prefix);
                optional = Optional.of(ret);
            }
            Optional<String> opt = optional;
            return opt;
        }, List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)o -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(o.stream().iterator()).asScala(), List$.MODULE$.canBuildFrom()) : (List)((List)dictFiles.zip(chromsrange, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> {
            String f = (String)x._1();
            ++chrI$1.elem;
            String rf = MODULE$.getRelativeFileLocationForDictionaryFileReferences(f);
            String prefix = new StringBuilder(2).append(rf).append("\t").append(chrI$1.elem).append("\t").toString();
            return MODULE$.dictRangeFromSeekRange((String)x._2(), prefix);
        }, List$.MODULE$.canBuildFrom());
    }

    private List<String> getPartDictList(List<String> dictFiles, List<String> partitions) {
        return (List)((List)dictFiles.zip(partitions, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> {
            String f = MODULE$.getRelativeFileLocationForDictionaryFileReferences((String)x._1());
            String part = (String)x._2();
            return new StringBuilder(1).append(f).append("\t").append(part).toString();
        }, List$.MODULE$.canBuildFrom());
    }

    private String writeOutGorDictionary(String commandToExecute, FileReader fileReader, String outfile, boolean useTheDict) {
        if (fileReader.exists(outfile)) {
            if (!commandToExecute.toLowerCase().contains("-nodict")) {
                this.writeOutGorDictionaryFolder(fileReader, outfile, useTheDict);
            }
        } else {
            String[] w = new StringOps(Predef$.MODULE$.augmentString(commandToExecute)).split(' ');
            Nil$ dictFiles = Nil$.MODULE$;
            Nil$ chromsrange = Nil$.MODULE$;
            for (int i = 1; i < w.length - 1; i += 2) {
                dictFiles = dictFiles.$colon$colon((Object)w[i]);
                chromsrange = chromsrange.$colon$colon((Object)w[i + 1]);
            }
            TableHeader tableHeader = new TableHeader();
            if (dictFiles.nonEmpty()) {
                String[] header = fileReader.readHeaderLine((String)dictFiles.head()).split("\t");
                tableHeader.setColumns(header);
            }
            tableHeader.setFileHeader(DictionaryTableMeta.DEFULT_RANGE_TABLE_HEADER);
            List<String> dictList = this.getDictList((List<String>)dictFiles, (List<String>)chromsrange, fileReader);
            AnalysisUtilities$.MODULE$.writeList(fileReader, outfile, tableHeader.formatHeader(), dictList);
        }
        return outfile;
    }

    public String writeOutNorDictionaryPart(String commandToExecute, FileReader fileReader, String outfile) {
        String[] w = new StringOps(Predef$.MODULE$.augmentString(commandToExecute)).split(' ');
        Nil$ dictFiles = Nil$.MODULE$;
        Nil$ partitions = Nil$.MODULE$;
        for (int i = 1; i < w.length - 1; i += 2) {
            dictFiles = dictFiles.$colon$colon((Object)w[i]);
            partitions = partitions.$colon$colon((Object)w[i + 1]);
        }
        TableHeader tableHeader = new TableHeader();
        String[] header = fileReader.readHeaderLine((String)dictFiles.head()).split("\t");
        tableHeader.setColumns(header);
        List<String> dictList = this.getPartDictList((List<String>)dictFiles, (List<String>)partitions);
        AnalysisUtilities$.MODULE$.writeList(fileReader, outfile, tableHeader.formatHeader(), dictList);
        return outfile;
    }

    private String writeOutGorDictionaryPart(String commandToExecute, FileReader fileReader, String outfile, boolean useTheDict) {
        if (fileReader.isDirectory(outfile)) {
            if (!commandToExecute.toLowerCase().contains("-nodict")) {
                this.writeOutGorDictionaryFolder(fileReader, outfile, useTheDict);
            }
        } else {
            String[] w = new StringOps(Predef$.MODULE$.augmentString(commandToExecute)).split(' ');
            Nil$ dictFiles = Nil$.MODULE$;
            Nil$ partitions = Nil$.MODULE$;
            for (int i = 1; i < w.length - 1; i += 2) {
                dictFiles = dictFiles.$colon$colon((Object)w[i]);
                partitions = partitions.$colon$colon((Object)w[i + 1]);
            }
            TableHeader tableHeader = new TableHeader();
            String[] header = fileReader.readHeaderLine((String)dictFiles.head()).split("\t");
            tableHeader.setColumns(header);
            List<String> dictList = this.getPartDictList((List<String>)dictFiles, (List<String>)partitions);
            AnalysisUtilities$.MODULE$.writeList(fileReader, outfile, tableHeader.formatHeader(), dictList);
        }
        return outfile;
    }

    public String getRelativeFileLocationForDictionaryFileReferences(String fileName) {
        return fileName.startsWith("/") ? fileName : new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("../")).$times(new StringOps(Predef$.MODULE$.augmentString(fileName)).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GeneralQueryHandler$.$anonfun$getRelativeFileLocationForDictionaryFileReferences$1(BoxesRunTime.unboxToChar((Object)x)))))).append(fileName).toString();
    }

    public long findOverheadTime(String commandToExecute) {
        int overheadTime;
        block1: {
            block0: {
                overheadTime = 0;
                if (!commandToExecute.startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY_PART())) break block0;
                overheadTime = 600000;
                break block1;
            }
            if (!commandToExecute.startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY())) break block1;
            overheadTime = 600000;
        }
        return overheadTime;
    }

    public static final /* synthetic */ boolean $anonfun$getRelativeFileLocationForDictionaryFileReferences$1(char x) {
        return x == '/';
    }

    private GeneralQueryHandler$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

